#!/usr/bin/env python

import nsysstats

class KHRGpuPushPopSummary(nsysstats.StatsReport):

    EVENT_TYPE_KHR_DEBUG_GPU_PUSHPOP_RANGE = 63

    display_name = 'DEPRECATED - Use opengl_khr_gpu_range_sum instead'
    usage = '{SCRIPT} -- {{DISPLAY_NAME}}'
    should_display = False

    query = f"""
WITH
    maxts AS(
        SELECT max(max(start), max(end)) AS m
        FROM   KHR_DEBUG_EVENTS
    ),
    khrDebug AS (
        SELECT
            coalesce(khrDebugEvents.end, (SELECT m FROM maxts)) - khrDebugEvents.start AS duration,
            CASE
                WHEN sid.value IS NOT NULL
                    THEN sid.value
                ELSE khrDebugEvents.id
            END AS tag
        FROM
            KHR_DEBUG_EVENTS AS khrDebugEvents
        LEFT OUTER JOIN
            StringIds AS sid
            ON khrDebugEvents.textId == sid.id
        WHERE
            khrDebugEvents.eventClass == {EVENT_TYPE_KHR_DEBUG_GPU_PUSHPOP_RANGE}
    ),
    summary AS (
        SELECT
            tag AS name,
            sum(duration) AS total,
            count(*) AS num,
            avg(duration) AS avg,
            median(duration) AS med,
            min(duration) AS min,
            max(duration) AS max,
            stdev(duration) AS stddev
        FROM
            khrDebug
        GROUP BY 1
    ),
    totals AS (
        SELECT sum(total) AS total
        FROM summary
    )

SELECT
    round(total * 100.0 / (SELECT total FROM totals), 1) AS "Time:ratio_%",
    total AS "Total Time:dur_ns",
    num AS "Instances",
    round(avg, 1) AS "Avg:dur_ns",
    round(med, 1) AS "Med:dur_ns",
    min AS "Min:dur_ns",
    max AS "Max:dur_ns",
    round(stddev, 1) AS "StdDev:dur_ns",
    name AS "Range"
FROM
    summary
WHERE summary.total > 0
ORDER BY 2 DESC
;
"""
    table_checks = {
        'KHR_DEBUG_EVENTS':
            "{DBFILE} does not contain GPU KHR Extension (KHR_DEBUG) data."
    }

if __name__ == "__main__":
    KHRGpuPushPopSummary.Main()
