/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultObjectCreator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;
import org.eclipse.birt.data.engine.olap.data.util.ObjectArrayUtil;

public class AggregationResultRow
implements IAggregationResultRow {
    private Member[] levelMembers = null;
    private Object[] aggregationValues = null;

    public AggregationResultRow() {
    }

    public AggregationResultRow(Member[] levelMembers, Object[] aggregationValues) {
        this.levelMembers = levelMembers;
        this.aggregationValues = aggregationValues;
    }

    @Override
    public Object[] getFieldValues() {
        int memberLength = 0;
        if (this.levelMembers != null) {
            memberLength = this.levelMembers.length;
        }
        Object[][] objectArrays = new Object[memberLength + 1][];
        int i = 0;
        while (i < memberLength) {
            objectArrays[i] = this.levelMembers[i] == null ? null : this.levelMembers[i].getFieldValues();
            ++i;
        }
        if (this.getAggregationValues() != null) {
            objectArrays[objectArrays.length - 1] = new Object[this.getAggregationValues().length + 1];
            objectArrays[objectArrays.length - 1][0] = 1;
            System.arraycopy(this.getAggregationValues(), 0, objectArrays[objectArrays.length - 1], 1, this.getAggregationValues().length);
        } else {
            objectArrays[objectArrays.length - 1] = new Object[1];
            objectArrays[objectArrays.length - 1][0] = 0;
        }
        return ObjectArrayUtil.convert(objectArrays);
    }

    public static IStructureCreator getCreator() {
        return new AggregationResultObjectCreator();
    }

    public int compareTo(Object o) {
        IAggregationResultRow other = (IAggregationResultRow)o;
        int i = 0;
        while (i < this.getLevelMembers().length) {
            if (this.getLevelMembers()[i] != null && other.getLevelMembers()[i] != null) {
                int result = this.getLevelMembers()[i].compareTo(other.getLevelMembers()[i]);
                if (result < 0) {
                    return result;
                }
                if (result > 0) {
                    return result;
                }
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void setLevelMembers(Member[] levelMembers) {
        this.levelMembers = levelMembers;
    }

    @Override
    public Member[] getLevelMembers() {
        return this.levelMembers;
    }

    @Override
    public void setAggregationValues(Object[] aggregationValues) {
        this.aggregationValues = aggregationValues;
    }

    @Override
    public Object[] getAggregationValues() {
        return this.aggregationValues;
    }
}

