"""
teste_livres_pour_eleves.py

Calcul de la liste des livres nécessaires à un élève, quand on connaît
sa classe et les options SIÈCLE qui le concernent.

utilisation :

$ ./manage.py shell
>>> exec(open('outils/teste_livre_pour_eleves.py').read())

ou encore :

$ ./manage.py shell < outils/teste_livre_pour_eleves.py
"""

from gestion.models import *

first = 200
last  = 220

les_eleves = Eleves.objects.all()[first:last]

for e in les_eleves:
    print(e)
    print("=================\n")
    print("Tronc commun")
    print("----------\n")
    for i,t in enumerate(sorted(list({l.titre for l in e.livres_du_tc}))):
        print ("  {:02d}. {}".format(i+1, t))
    print()
