# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
import json
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ..._operations._operations import (
    build_load_test_administration_begin_upload_test_file_request,
    build_load_test_administration_create_or_update_app_components_request,
    build_load_test_administration_create_or_update_server_metrics_config_request,
    build_load_test_administration_create_or_update_test_profile_request,
    build_load_test_administration_create_or_update_test_request,
    build_load_test_administration_delete_test_file_request,
    build_load_test_administration_delete_test_profile_request,
    build_load_test_administration_delete_test_request,
    build_load_test_administration_get_app_components_request,
    build_load_test_administration_get_server_metrics_config_request,
    build_load_test_administration_get_test_file_request,
    build_load_test_administration_get_test_profile_request,
    build_load_test_administration_get_test_request,
    build_load_test_administration_list_test_files_request,
    build_load_test_administration_list_test_profiles_request,
    build_load_test_administration_list_tests_request,
    build_load_test_run_begin_test_profile_run_request,
    build_load_test_run_begin_test_run_request,
    build_load_test_run_create_or_update_app_components_request,
    build_load_test_run_create_or_update_server_metrics_config_request,
    build_load_test_run_delete_test_profile_run_request,
    build_load_test_run_delete_test_run_request,
    build_load_test_run_get_app_components_request,
    build_load_test_run_get_metric_definitions_request,
    build_load_test_run_get_metric_namespaces_request,
    build_load_test_run_get_server_metrics_config_request,
    build_load_test_run_get_test_profile_run_request,
    build_load_test_run_get_test_run_file_request,
    build_load_test_run_get_test_run_request,
    build_load_test_run_list_metric_dimension_values_request,
    build_load_test_run_list_metrics_request,
    build_load_test_run_list_test_profile_runs_request,
    build_load_test_run_list_test_runs_request,
    build_load_test_run_stop_test_profile_run_request,
    build_load_test_run_stop_test_run_request,
)
from ..._validation import api_version_validation
from .._vendor import LoadTestAdministrationClientMixinABC, LoadTestRunClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class LoadTestAdministrationClientOperationsMixin(  # pylint: disable=name-too-long
    LoadTestAdministrationClientMixinABC
):

    @overload
    async def create_or_update_test(
        self, test_id: str, body: _models.Test, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.Test:
        """Create a new test or update an existing test by providing the test Id.

        Create a new test or update an existing test by providing the test Id.

        :param test_id: Unique test identifier for the load test, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: The resource instance. Required.
        :type body: ~azure.developer.loadtesting.models.Test
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: Test. The Test is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.Test
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_test(
        self, test_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.Test:
        """Create a new test or update an existing test by providing the test Id.

        Create a new test or update an existing test by providing the test Id.

        :param test_id: Unique test identifier for the load test, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: The resource instance. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: Test. The Test is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.Test
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_test(
        self, test_id: str, body: IO[bytes], *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.Test:
        """Create a new test or update an existing test by providing the test Id.

        Create a new test or update an existing test by providing the test Id.

        :param test_id: Unique test identifier for the load test, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: The resource instance. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: Test. The Test is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.Test
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_test(
        self, test_id: str, body: Union[_models.Test, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.Test:
        """Create a new test or update an existing test by providing the test Id.

        Create a new test or update an existing test by providing the test Id.

        :param test_id: Unique test identifier for the load test, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: The resource instance. Is one of the following types: Test, JSON, IO[bytes]
         Required.
        :type body: ~azure.developer.loadtesting.models.Test or JSON or IO[bytes]
        :return: Test. The Test is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.Test
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Test] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_load_test_administration_create_or_update_test_request(
            test_id=test_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Test, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_app_components(
        self,
        test_id: str,
        body: _models.TestAppComponents,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TestAppComponents:
        """Add an app component to a test.

        Add an app component to a test by providing the resource Id, name and type.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: App Component model. Required.
        :type body: ~azure.developer.loadtesting.models.TestAppComponents
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestAppComponents. The TestAppComponents is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestAppComponents
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_app_components(
        self, test_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TestAppComponents:
        """Add an app component to a test.

        Add an app component to a test by providing the resource Id, name and type.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: App Component model. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestAppComponents. The TestAppComponents is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestAppComponents
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_app_components(
        self, test_id: str, body: IO[bytes], *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TestAppComponents:
        """Add an app component to a test.

        Add an app component to a test by providing the resource Id, name and type.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: App Component model. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestAppComponents. The TestAppComponents is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestAppComponents
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_app_components(
        self, test_id: str, body: Union[_models.TestAppComponents, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.TestAppComponents:
        """Add an app component to a test.

        Add an app component to a test by providing the resource Id, name and type.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: App Component model. Is one of the following types: TestAppComponents, JSON,
         IO[bytes] Required.
        :type body: ~azure.developer.loadtesting.models.TestAppComponents or JSON or IO[bytes]
        :return: TestAppComponents. The TestAppComponents is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestAppComponents
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models.TestAppComponents] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_load_test_administration_create_or_update_app_components_request(
            test_id=test_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestAppComponents, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_server_metrics_config(
        self,
        test_id: str,
        body: _models.TestServerMetricsConfiguration,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TestServerMetricsConfiguration:
        """Configure server metrics for a test.

        Configure server metrics for a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: Server metric configuration model. Required.
        :type body: ~azure.developer.loadtesting.models.TestServerMetricsConfiguration
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestServerMetricsConfiguration. The TestServerMetricsConfiguration is compatible with
         MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestServerMetricsConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_server_metrics_config(
        self, test_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TestServerMetricsConfiguration:
        """Configure server metrics for a test.

        Configure server metrics for a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: Server metric configuration model. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestServerMetricsConfiguration. The TestServerMetricsConfiguration is compatible with
         MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestServerMetricsConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_server_metrics_config(
        self, test_id: str, body: IO[bytes], *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TestServerMetricsConfiguration:
        """Configure server metrics for a test.

        Configure server metrics for a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: Server metric configuration model. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestServerMetricsConfiguration. The TestServerMetricsConfiguration is compatible with
         MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestServerMetricsConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_server_metrics_config(
        self, test_id: str, body: Union[_models.TestServerMetricsConfiguration, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.TestServerMetricsConfiguration:
        """Configure server metrics for a test.

        Configure server metrics for a test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param body: Server metric configuration model. Is one of the following types:
         TestServerMetricsConfiguration, JSON, IO[bytes] Required.
        :type body: ~azure.developer.loadtesting.models.TestServerMetricsConfiguration or JSON or
         IO[bytes]
        :return: TestServerMetricsConfiguration. The TestServerMetricsConfiguration is compatible with
         MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestServerMetricsConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models.TestServerMetricsConfiguration] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_load_test_administration_create_or_update_server_metrics_config_request(
            test_id=test_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestServerMetricsConfiguration, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_app_components(self, test_id: str, **kwargs: Any) -> _models.TestAppComponents:
        """Get associated app component (collection of azure resources) for the given test.

        Get associated app component (collection of azure resources) for the given test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :return: TestAppComponents. The TestAppComponents is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestAppComponents
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestAppComponents] = kwargs.pop("cls", None)

        _request = build_load_test_administration_get_app_components_request(
            test_id=test_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestAppComponents, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_server_metrics_config(self, test_id: str, **kwargs: Any) -> _models.TestServerMetricsConfiguration:
        """List server metrics configuration for the given test.

        List server metrics configuration for the given test.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :return: TestServerMetricsConfiguration. The TestServerMetricsConfiguration is compatible with
         MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestServerMetricsConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestServerMetricsConfiguration] = kwargs.pop("cls", None)

        _request = build_load_test_administration_get_server_metrics_config_request(
            test_id=test_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestServerMetricsConfiguration, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_test(self, test_id: str, **kwargs: Any) -> _models.Test:
        """Get load test details by test Id.

        Get load test details by test Id.

        :param test_id: Unique test identifier for the load test, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :return: Test. The Test is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.Test
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Test] = kwargs.pop("cls", None)

        _request = build_load_test_administration_get_test_request(
            test_id=test_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Test, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_test_file(self, test_id: str, file_name: str, **kwargs: Any) -> _models.TestFileInfo:
        """Get all the files that are associated with a test.

        Get all the files that are associated with a test.

        :param test_id: Unique test identifier for the load test, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param file_name: Name of the file. Required.
        :type file_name: str
        :return: TestFileInfo. The TestFileInfo is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestFileInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestFileInfo] = kwargs.pop("cls", None)

        _request = build_load_test_administration_get_test_file_request(
            test_id=test_id,
            file_name=file_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestFileInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_test_files(self, test_id: str, **kwargs: Any) -> AsyncIterable["_models.TestFileInfo"]:
        """Get all test files.

        Get all test files.

        :param test_id: Unique test identifier for the load test, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :return: An iterator like instance of TestFileInfo
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.developer.loadtesting.models.TestFileInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.TestFileInfo]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_test_administration_list_test_files_request(
                    test_id=test_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TestFileInfo], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_tests(
        self,
        *,
        orderby: Optional[str] = None,
        search: Optional[str] = None,
        last_modified_start_time: Optional[datetime.datetime] = None,
        last_modified_end_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.Test"]:
        """Get all load tests by the fully qualified resource Id e.g
        subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.

        Get all load tests by the fully qualified resource Id e.g
        subscriptions/{subId}/resourceGroups/{rg}/providers/Microsoft.LoadTestService/loadtests/{resName}.

        :keyword orderby: Sort on the supported fields in (field asc/desc) format. eg:
         lastModifiedDateTime asc. Supported fields - lastModifiedDateTime. Default value is None.
        :paramtype orderby: str
        :keyword search: Prefix based, case sensitive search on searchable fields - displayName,
         createdBy. For example, to search for a test, with display name is Login Test,
         the search parameter can be Login. Default value is None.
        :paramtype search: str
        :keyword last_modified_start_time: Start DateTime(RFC 3339 literal format) of the last updated
         time range to filter tests. Default value is None.
        :paramtype last_modified_start_time: ~datetime.datetime
        :keyword last_modified_end_time: End DateTime(RFC 3339 literal format) of the last updated time
         range to filter tests. Default value is None.
        :paramtype last_modified_end_time: ~datetime.datetime
        :return: An iterator like instance of Test
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.developer.loadtesting.models.Test]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.Test]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_test_administration_list_tests_request(
                    orderby=orderby,
                    search=search,
                    last_modified_start_time=last_modified_start_time,
                    last_modified_end_time=last_modified_end_time,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Test], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def _begin_upload_test_file(
        self,
        test_id: str,
        file_name: str,
        body: bytes,
        *,
        file_type: Optional[Union[str, _models.FileType]] = None,
        **kwargs: Any
    ) -> _models.TestFileInfo:
        """Upload input file for a given test Id. File size can't be more than 50 MB.
        Existing file with same name for the given test will be overwritten. File
        should be provided in the request body as application/octet-stream.

        Upload input file for a given test Id. File size can't be more than 50 MB.
        Existing file with same name for the given test will be overwritten. File
        should be provided in the request body as application/octet-stream.

        :param test_id: Unique name for the load test, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param file_name: Unique name for test file with file extension like : App.jmx. Required.
        :type file_name: str
        :param body: The file content as application/octet-stream. Required.
        :type body: bytes
        :keyword file_type: File type. Known values are: "JMX_FILE", "USER_PROPERTIES",
         "ADDITIONAL_ARTIFACTS", "ZIPPED_ARTIFACTS", "URL_TEST_CONFIG", and "TEST_SCRIPT". Default value
         is None.
        :paramtype file_type: str or ~azure.developer.loadtesting.models.FileType
        :return: TestFileInfo. The TestFileInfo is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestFileInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[_models.TestFileInfo] = kwargs.pop("cls", None)

        _content = body

        _request = build_load_test_administration_begin_upload_test_file_request(
            test_id=test_id,
            file_name=file_name,
            file_type=file_type,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestFileInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_test_file(self, test_id: str, file_name: str, **kwargs: Any) -> None:
        """Delete file by the file name for a test.

        Delete file by the file name for a test.

        :param test_id: Unique test identifier for the load test, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :param file_name: Name of the file. Required.
        :type file_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_load_test_administration_delete_test_file_request(
            test_id=test_id,
            file_name=file_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def delete_test(self, test_id: str, **kwargs: Any) -> None:
        """Delete a test by its test Id.

        Delete a test by its test Id.

        :param test_id: Unique test identifier for the load test, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_load_test_administration_delete_test_request(
            test_id=test_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def create_or_update_test_profile(
        self,
        test_profile_id: str,
        body: _models.TestProfile,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TestProfile:
        """Create a new test profile or update an existing test profile.

        Create a new test profile or update an existing test profile by providing the test profile Id.

        :param test_profile_id: Unique identifier for the test profile, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_profile_id: str
        :param body: The resource instance. Required.
        :type body: ~azure.developer.loadtesting.models.TestProfile
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestProfile. The TestProfile is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestProfile
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_test_profile(
        self, test_profile_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TestProfile:
        """Create a new test profile or update an existing test profile.

        Create a new test profile or update an existing test profile by providing the test profile Id.

        :param test_profile_id: Unique identifier for the test profile, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_profile_id: str
        :param body: The resource instance. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestProfile. The TestProfile is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestProfile
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_test_profile(
        self,
        test_profile_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TestProfile:
        """Create a new test profile or update an existing test profile.

        Create a new test profile or update an existing test profile by providing the test profile Id.

        :param test_profile_id: Unique identifier for the test profile, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_profile_id: str
        :param body: The resource instance. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestProfile. The TestProfile is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestProfile
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2024-05-01-preview",
        params_added_on={"2024-05-01-preview": ["api_version", "test_profile_id", "content_type", "accept"]},
    )
    async def create_or_update_test_profile(
        self, test_profile_id: str, body: Union[_models.TestProfile, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.TestProfile:
        """Create a new test profile or update an existing test profile.

        Create a new test profile or update an existing test profile by providing the test profile Id.

        :param test_profile_id: Unique identifier for the test profile, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_profile_id: str
        :param body: The resource instance. Is one of the following types: TestProfile, JSON, IO[bytes]
         Required.
        :type body: ~azure.developer.loadtesting.models.TestProfile or JSON or IO[bytes]
        :return: TestProfile. The TestProfile is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestProfile
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TestProfile] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_load_test_administration_create_or_update_test_profile_request(
            test_profile_id=test_profile_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestProfile, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2024-05-01-preview",
        params_added_on={"2024-05-01-preview": ["api_version", "test_profile_id", "accept"]},
    )
    async def delete_test_profile(self, test_profile_id: str, **kwargs: Any) -> None:
        """Delete a test profile.

        Delete a test profile by its test profile Id.

        :param test_profile_id: Unique identifier for the test profile, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_profile_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_load_test_administration_delete_test_profile_request(
            test_profile_id=test_profile_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2024-05-01-preview",
        params_added_on={"2024-05-01-preview": ["api_version", "test_profile_id", "accept"]},
    )
    async def get_test_profile(self, test_profile_id: str, **kwargs: Any) -> _models.TestProfile:
        """Get load test profile details.

        Get load test profile details by test profile Id.

        :param test_profile_id: Unique identifier for the test profile, must contain only lower-case
         alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_profile_id: str
        :return: TestProfile. The TestProfile is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestProfile
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestProfile] = kwargs.pop("cls", None)

        _request = build_load_test_administration_get_test_profile_request(
            test_profile_id=test_profile_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestProfile, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    @api_version_validation(
        method_added_on="2024-05-01-preview",
        params_added_on={
            "2024-05-01-preview": [
                "api_version",
                "maxpagesize",
                "last_modified_start_time",
                "last_modified_end_time",
                "test_profile_ids",
                "test_ids",
                "accept",
            ]
        },
    )
    def list_test_profiles(
        self,
        *,
        last_modified_start_time: Optional[datetime.datetime] = None,
        last_modified_end_time: Optional[datetime.datetime] = None,
        test_profile_ids: Optional[List[str]] = None,
        test_ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.TestProfile"]:
        """List test profiles.

        Get all test profiles for the given filters.

        :keyword last_modified_start_time: Start DateTime(RFC 3339 literal format) of the last updated
         time range to filter test profiles. Default value is None.
        :paramtype last_modified_start_time: ~datetime.datetime
        :keyword last_modified_end_time: End DateTime(RFC 3339 literal format) of the last updated time
         range to filter test profiles. Default value is None.
        :paramtype last_modified_end_time: ~datetime.datetime
        :keyword test_profile_ids: Comma separated list of IDs of the test profiles to filter. Default
         value is None.
        :paramtype test_profile_ids: list[str]
        :keyword test_ids: Comma separated list IDs of the tests which should be associated with the
         test profiles to fetch. Default value is None.
        :paramtype test_ids: list[str]
        :return: An iterator like instance of TestProfile
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.developer.loadtesting.models.TestProfile]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.TestProfile]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_test_administration_list_test_profiles_request(
                    maxpagesize=maxpagesize,
                    last_modified_start_time=last_modified_start_time,
                    last_modified_end_time=last_modified_end_time,
                    test_profile_ids=test_profile_ids,
                    test_ids=test_ids,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TestProfile], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class LoadTestRunClientOperationsMixin(LoadTestRunClientMixinABC):

    @overload
    async def _begin_test_run(
        self,
        test_run_id: str,
        body: _models.TestRun,
        *,
        content_type: str = "application/merge-patch+json",
        old_test_run_id: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TestRun: ...
    @overload
    async def _begin_test_run(
        self,
        test_run_id: str,
        body: JSON,
        *,
        content_type: str = "application/merge-patch+json",
        old_test_run_id: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TestRun: ...
    @overload
    async def _begin_test_run(
        self,
        test_run_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        old_test_run_id: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TestRun: ...

    @distributed_trace_async
    async def _begin_test_run(
        self,
        test_run_id: str,
        body: Union[_models.TestRun, JSON, IO[bytes]],
        *,
        old_test_run_id: Optional[str] = None,
        **kwargs: Any
    ) -> _models.TestRun:
        """Create and start a new test run with the given test run Id.

        Create and start a new test run with the given test run Id.

        :param test_run_id: Unique test run identifier for the load test run, must contain only
         lower-case alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: The resource instance. Is one of the following types: TestRun, JSON, IO[bytes]
         Required.
        :type body: ~azure.developer.loadtesting.models.TestRun or JSON or IO[bytes]
        :keyword old_test_run_id: Existing test run identifier that should be rerun, if this is
         provided, the
         test will run with the JMX file, configuration and app components from the
         existing test run. You can override the configuration values for new test run
         in the request body. Default value is None.
        :paramtype old_test_run_id: str
        :return: TestRun. The TestRun is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRun
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TestRun] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_load_test_run_begin_test_run_request(
            test_run_id=test_run_id,
            old_test_run_id=old_test_run_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestRun, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_app_components(
        self,
        test_run_id: str,
        body: _models.TestRunAppComponents,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TestRunAppComponents:
        """Add an app component to a test run.

        Add an app component to a test run by providing the resource Id, name and type.

        :param test_run_id: Unique Id for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: App Component model. Required.
        :type body: ~azure.developer.loadtesting.models.TestRunAppComponents
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestRunAppComponents. The TestRunAppComponents is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunAppComponents
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_app_components(
        self, test_run_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TestRunAppComponents:
        """Add an app component to a test run.

        Add an app component to a test run by providing the resource Id, name and type.

        :param test_run_id: Unique Id for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: App Component model. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestRunAppComponents. The TestRunAppComponents is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunAppComponents
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_app_components(
        self, test_run_id: str, body: IO[bytes], *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TestRunAppComponents:
        """Add an app component to a test run.

        Add an app component to a test run by providing the resource Id, name and type.

        :param test_run_id: Unique Id for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: App Component model. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestRunAppComponents. The TestRunAppComponents is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunAppComponents
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_app_components(
        self, test_run_id: str, body: Union[_models.TestRunAppComponents, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.TestRunAppComponents:
        """Add an app component to a test run.

        Add an app component to a test run by providing the resource Id, name and type.

        :param test_run_id: Unique Id for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: App Component model. Is one of the following types: TestRunAppComponents, JSON,
         IO[bytes] Required.
        :type body: ~azure.developer.loadtesting.models.TestRunAppComponents or JSON or IO[bytes]
        :return: TestRunAppComponents. The TestRunAppComponents is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunAppComponents
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models.TestRunAppComponents] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_load_test_run_create_or_update_app_components_request(
            test_run_id=test_run_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestRunAppComponents, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_server_metrics_config(
        self,
        test_run_id: str,
        body: _models.TestRunServerMetricsConfiguration,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TestRunServerMetricsConfiguration:
        """Configure server metrics for a test run.

        Configure server metrics for a test run.

        :param test_run_id: Unique Id for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Server metric configuration model. Required.
        :type body: ~azure.developer.loadtesting.models.TestRunServerMetricsConfiguration
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestRunServerMetricsConfiguration. The TestRunServerMetricsConfiguration is compatible
         with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunServerMetricsConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_server_metrics_config(
        self, test_run_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TestRunServerMetricsConfiguration:
        """Configure server metrics for a test run.

        Configure server metrics for a test run.

        :param test_run_id: Unique Id for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Server metric configuration model. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestRunServerMetricsConfiguration. The TestRunServerMetricsConfiguration is compatible
         with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunServerMetricsConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_server_metrics_config(
        self, test_run_id: str, body: IO[bytes], *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TestRunServerMetricsConfiguration:
        """Configure server metrics for a test run.

        Configure server metrics for a test run.

        :param test_run_id: Unique Id for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Server metric configuration model. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: TestRunServerMetricsConfiguration. The TestRunServerMetricsConfiguration is compatible
         with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunServerMetricsConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_server_metrics_config(
        self, test_run_id: str, body: Union[_models.TestRunServerMetricsConfiguration, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.TestRunServerMetricsConfiguration:
        """Configure server metrics for a test run.

        Configure server metrics for a test run.

        :param test_run_id: Unique Id for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Server metric configuration model. Is one of the following types:
         TestRunServerMetricsConfiguration, JSON, IO[bytes] Required.
        :type body: ~azure.developer.loadtesting.models.TestRunServerMetricsConfiguration or JSON or
         IO[bytes]
        :return: TestRunServerMetricsConfiguration. The TestRunServerMetricsConfiguration is compatible
         with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunServerMetricsConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models.TestRunServerMetricsConfiguration] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_load_test_run_create_or_update_server_metrics_config_request(
            test_run_id=test_run_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestRunServerMetricsConfiguration, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_test_run(self, test_run_id: str, **kwargs: Any) -> None:
        """Delete an existing load test run.

        Delete an existing load test run by providing the testRunId.

        :param test_run_id: Unique test run identifier for the load test run, must contain only
         lower-case alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_load_test_run_delete_test_run_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_app_components(self, test_run_id: str, **kwargs: Any) -> _models.TestRunAppComponents:
        """Get associated app component (collection of azure resources) for the given test
        run.

        Get associated app component (collection of azure resources) for the given test
        run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: TestRunAppComponents. The TestRunAppComponents is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunAppComponents
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestRunAppComponents] = kwargs.pop("cls", None)

        _request = build_load_test_run_get_app_components_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestRunAppComponents, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_server_metrics_config(
        self, test_run_id: str, **kwargs: Any
    ) -> _models.TestRunServerMetricsConfiguration:
        """Get associated server metrics configuration for the given test run.

        Get associated server metrics configuration for the given test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: TestRunServerMetricsConfiguration. The TestRunServerMetricsConfiguration is compatible
         with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunServerMetricsConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestRunServerMetricsConfiguration] = kwargs.pop("cls", None)

        _request = build_load_test_run_get_server_metrics_config_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestRunServerMetricsConfiguration, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_test_run(self, test_run_id: str, **kwargs: Any) -> _models.TestRun:
        """Get test run details by test run Id.

        Get test run details by test run Id.

        :param test_run_id: Unique test run identifier for the load test run, must contain only
         lower-case alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: TestRun. The TestRun is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRun
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestRun] = kwargs.pop("cls", None)

        _request = build_load_test_run_get_test_run_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestRun, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_test_run_file(self, test_run_id: str, file_name: str, **kwargs: Any) -> _models.TestRunFileInfo:
        """Get test run file by file name.

        Get test run file by file name.

        :param test_run_id: Unique test run identifier for the load test run, must contain only
         lower-case alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param file_name: Name of the file. Required.
        :type file_name: str
        :return: TestRunFileInfo. The TestRunFileInfo is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRunFileInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestRunFileInfo] = kwargs.pop("cls", None)

        _request = build_load_test_run_get_test_run_file_request(
            test_run_id=test_run_id,
            file_name=file_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestRunFileInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_metric_dimension_values(
        self,
        test_run_id: str,
        name: str,
        *,
        metric_name: str,
        metric_namespace: str,
        time_interval: str,
        interval: Optional[Union[str, _models.TimeGrain]] = None,
        **kwargs: Any
    ) -> AsyncIterable[str]:
        """List the dimension values for the given metric dimension name.

        List the dimension values for the given metric dimension name.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param name: Dimension name. Required.
        :type name: str
        :keyword metric_name: Metric name. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :keyword time_interval: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'. Required.
        :paramtype time_interval: str
        :keyword interval: The interval (i.e. timegrain) of the query. Known values are: "PT5S",
         "PT10S", "PT1M", "PT5M", and "PT1H". Default value is None.
        :paramtype interval: str or ~azure.developer.loadtesting.models.TimeGrain
        :return: An iterator like instance of str
        :rtype: ~azure.core.async_paging.AsyncItemPaged[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[str]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_test_run_list_metric_dimension_values_request(
                    test_run_id=test_run_id,
                    name=name,
                    metric_name=metric_name,
                    metric_namespace=metric_namespace,
                    time_interval=time_interval,
                    interval=interval,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[str], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_metric_definitions(
        self, test_run_id: str, *, metric_namespace: str, **kwargs: Any
    ) -> _models.MetricDefinitionCollection:
        """List the metric definitions for a load test run.

        List the metric definitions for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :return: MetricDefinitionCollection. The MetricDefinitionCollection is compatible with
         MutableMapping
        :rtype: ~azure.developer.loadtesting.models.MetricDefinitionCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.MetricDefinitionCollection] = kwargs.pop("cls", None)

        _request = build_load_test_run_get_metric_definitions_request(
            test_run_id=test_run_id,
            metric_namespace=metric_namespace,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.MetricDefinitionCollection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_metric_namespaces(self, test_run_id: str, **kwargs: Any) -> _models.MetricNamespaceCollection:
        """List the metric namespaces for a load test run.

        List the metric namespaces for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: MetricNamespaceCollection. The MetricNamespaceCollection is compatible with
         MutableMapping
        :rtype: ~azure.developer.loadtesting.models.MetricNamespaceCollection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.MetricNamespaceCollection] = kwargs.pop("cls", None)

        _request = build_load_test_run_get_metric_namespaces_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.MetricNamespaceCollection, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def list_metrics(
        self,
        test_run_id: str,
        body: Optional[_models.MetricRequestPayload] = None,
        *,
        metric_name: str,
        metric_namespace: str,
        time_interval: str,
        aggregation: Optional[str] = None,
        interval: Optional[Union[str, _models.TimeGrain]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterable["_models.TimeSeriesElement"]:
        """List the metric values for a load test run.

        List the metric values for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Metric dimension filter. Default value is None.
        :type body: ~azure.developer.loadtesting.models.MetricRequestPayload
        :keyword metric_name: Metric name. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :keyword time_interval: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'. Required.
        :paramtype time_interval: str
        :keyword aggregation: The aggregation. Default value is None.
        :paramtype aggregation: str
        :keyword interval: The interval (i.e. timegrain) of the query. Known values are: "PT5S",
         "PT10S", "PT1M", "PT5M", and "PT1H". Default value is None.
        :paramtype interval: str or ~azure.developer.loadtesting.models.TimeGrain
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of TimeSeriesElement
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.developer.loadtesting.models.TimeSeriesElement]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def list_metrics(
        self,
        test_run_id: str,
        body: Optional[JSON] = None,
        *,
        metric_name: str,
        metric_namespace: str,
        time_interval: str,
        aggregation: Optional[str] = None,
        interval: Optional[Union[str, _models.TimeGrain]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterable["_models.TimeSeriesElement"]:
        """List the metric values for a load test run.

        List the metric values for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Metric dimension filter. Default value is None.
        :type body: JSON
        :keyword metric_name: Metric name. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :keyword time_interval: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'. Required.
        :paramtype time_interval: str
        :keyword aggregation: The aggregation. Default value is None.
        :paramtype aggregation: str
        :keyword interval: The interval (i.e. timegrain) of the query. Known values are: "PT5S",
         "PT10S", "PT1M", "PT5M", and "PT1H". Default value is None.
        :paramtype interval: str or ~azure.developer.loadtesting.models.TimeGrain
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of TimeSeriesElement
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.developer.loadtesting.models.TimeSeriesElement]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def list_metrics(
        self,
        test_run_id: str,
        body: Optional[IO[bytes]] = None,
        *,
        metric_name: str,
        metric_namespace: str,
        time_interval: str,
        aggregation: Optional[str] = None,
        interval: Optional[Union[str, _models.TimeGrain]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterable["_models.TimeSeriesElement"]:
        """List the metric values for a load test run.

        List the metric values for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Metric dimension filter. Default value is None.
        :type body: IO[bytes]
        :keyword metric_name: Metric name. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :keyword time_interval: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'. Required.
        :paramtype time_interval: str
        :keyword aggregation: The aggregation. Default value is None.
        :paramtype aggregation: str
        :keyword interval: The interval (i.e. timegrain) of the query. Known values are: "PT5S",
         "PT10S", "PT1M", "PT5M", and "PT1H". Default value is None.
        :paramtype interval: str or ~azure.developer.loadtesting.models.TimeGrain
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An iterator like instance of TimeSeriesElement
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.developer.loadtesting.models.TimeSeriesElement]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def list_metrics(
        self,
        test_run_id: str,
        body: Optional[Union[_models.MetricRequestPayload, JSON, IO[bytes]]] = None,
        *,
        metric_name: str,
        metric_namespace: str,
        time_interval: str,
        aggregation: Optional[str] = None,
        interval: Optional[Union[str, _models.TimeGrain]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.TimeSeriesElement"]:
        """List the metric values for a load test run.

        List the metric values for a load test run.

        :param test_run_id: Unique name for the load test run, must contain only lower-case alphabetic,
         numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :param body: Metric dimension filter. Is one of the following types: MetricRequestPayload,
         JSON, IO[bytes] Default value is None.
        :type body: ~azure.developer.loadtesting.models.MetricRequestPayload or JSON or IO[bytes]
        :keyword metric_name: Metric name. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Metric namespace to query metric definitions for. Required.
        :paramtype metric_namespace: str
        :keyword time_interval: The timespan of the query. It is a string with the following format
         'startDateTime_ISO/endDateTime_ISO'. Required.
        :paramtype time_interval: str
        :keyword aggregation: The aggregation. Default value is None.
        :paramtype aggregation: str
        :keyword interval: The interval (i.e. timegrain) of the query. Known values are: "PT5S",
         "PT10S", "PT1M", "PT5M", and "PT1H". Default value is None.
        :paramtype interval: str or ~azure.developer.loadtesting.models.TimeGrain
        :return: An iterator like instance of TimeSeriesElement
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.developer.loadtesting.models.TimeSeriesElement]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.TimeSeriesElement]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_test_run_list_metrics_request(
                    test_run_id=test_run_id,
                    metric_name=metric_name,
                    metric_namespace=metric_namespace,
                    time_interval=time_interval,
                    aggregation=aggregation,
                    interval=interval,
                    content_type=content_type,
                    api_version=self._config.api_version,
                    content=_content,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TimeSeriesElement], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_test_runs(
        self,
        *,
        orderby: Optional[str] = None,
        search: Optional[str] = None,
        test_id: Optional[str] = None,
        execution_from: Optional[datetime.datetime] = None,
        execution_to: Optional[datetime.datetime] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.TestRun"]:
        """Get all test runs for the given filters.

        Get all test runs for the given filters.

        :keyword orderby: Sort on the supported fields in (field asc/desc) format. eg: executedDateTime
         asc. Supported fields - executedDateTime. Default value is None.
        :paramtype orderby: str
        :keyword search: Prefix based, case sensitive search on searchable fields - description,
         executedUser. For example, to search for a test run, with description 500 VUs,
         the search parameter can be 500. Default value is None.
        :paramtype search: str
        :keyword test_id: Unique name of an existing load test. Default value is None.
        :paramtype test_id: str
        :keyword execution_from: Start DateTime(RFC 3339 literal format) of test-run execution time
         filter range. Default value is None.
        :paramtype execution_from: ~datetime.datetime
        :keyword execution_to: End DateTime(RFC 3339 literal format) of test-run execution time filter
         range. Default value is None.
        :paramtype execution_to: ~datetime.datetime
        :keyword status: Comma separated list of test run status. Default value is None.
        :paramtype status: str
        :return: An iterator like instance of TestRun
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.developer.loadtesting.models.TestRun]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.TestRun]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_test_run_list_test_runs_request(
                    orderby=orderby,
                    search=search,
                    test_id=test_id,
                    execution_from=execution_from,
                    execution_to=execution_to,
                    status=status,
                    maxpagesize=maxpagesize,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TestRun], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def stop_test_run(self, test_run_id: str, **kwargs: Any) -> _models.TestRun:
        """Stop test run by test run Id.

        Stop test run by test run Id.

        :param test_run_id: Unique test run identifier for the load test run, must contain only
         lower-case alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_run_id: str
        :return: TestRun. The TestRun is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestRun
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestRun] = kwargs.pop("cls", None)

        _request = build_load_test_run_stop_test_run_request(
            test_run_id=test_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestRun, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def _begin_test_profile_run(
        self,
        test_profile_run_id: str,
        body: _models.TestProfileRun,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TestProfileRun: ...
    @overload
    async def _begin_test_profile_run(
        self, test_profile_run_id: str, body: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.TestProfileRun: ...
    @overload
    async def _begin_test_profile_run(
        self,
        test_profile_run_id: str,
        body: IO[bytes],
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.TestProfileRun: ...

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2024-05-01-preview",
        params_added_on={"2024-05-01-preview": ["api_version", "test_profile_run_id", "content_type", "accept"]},
    )
    async def _begin_test_profile_run(
        self, test_profile_run_id: str, body: Union[_models.TestProfileRun, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.TestProfileRun:
        """Create and start a new test profile run.

        Create and start a new test profile run with the given test profile run Id.

        :param test_profile_run_id: Unique identifier for the test profile run, must contain only
         lower-case alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_profile_run_id: str
        :param body: The resource instance. Is one of the following types: TestProfileRun, JSON,
         IO[bytes] Required.
        :type body: ~azure.developer.loadtesting.models.TestProfileRun or JSON or IO[bytes]
        :return: TestProfileRun. The TestProfileRun is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestProfileRun
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TestProfileRun] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_load_test_run_begin_test_profile_run_request(
            test_profile_run_id=test_profile_run_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestProfileRun, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2024-05-01-preview",
        params_added_on={"2024-05-01-preview": ["api_version", "test_profile_run_id", "accept"]},
    )
    async def delete_test_profile_run(self, test_profile_run_id: str, **kwargs: Any) -> None:
        """Delete an existing load test profile run.

        Delete an existing load test profile run by providing the test profile run Id.

        :param test_profile_run_id: Unique identifier for the test profile run, must contain only
         lower-case alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_profile_run_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_load_test_run_delete_test_profile_run_request(
            test_profile_run_id=test_profile_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2024-05-01-preview",
        params_added_on={"2024-05-01-preview": ["api_version", "test_profile_run_id", "accept"]},
    )
    async def get_test_profile_run(self, test_profile_run_id: str, **kwargs: Any) -> _models.TestProfileRun:
        """Get test profile run details.

        Get test profile run details by test profile run Id.

        :param test_profile_run_id: Unique identifier for the test profile run, must contain only
         lower-case alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_profile_run_id: str
        :return: TestProfileRun. The TestProfileRun is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestProfileRun
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestProfileRun] = kwargs.pop("cls", None)

        _request = build_load_test_run_get_test_profile_run_request(
            test_profile_run_id=test_profile_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestProfileRun, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    @api_version_validation(
        method_added_on="2024-05-01-preview",
        params_added_on={
            "2024-05-01-preview": [
                "api_version",
                "maxpagesize",
                "min_start_date_time",
                "max_start_date_time",
                "min_end_date_time",
                "max_end_date_time",
                "created_date_start_time",
                "created_date_end_time",
                "test_profile_run_ids",
                "test_profile_ids",
                "statuses",
                "accept",
            ]
        },
    )
    def list_test_profile_runs(
        self,
        *,
        min_start_date_time: Optional[datetime.datetime] = None,
        max_start_date_time: Optional[datetime.datetime] = None,
        min_end_date_time: Optional[datetime.datetime] = None,
        max_end_date_time: Optional[datetime.datetime] = None,
        created_date_start_time: Optional[datetime.datetime] = None,
        created_date_end_time: Optional[datetime.datetime] = None,
        test_profile_run_ids: Optional[List[str]] = None,
        test_profile_ids: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.TestProfileRun"]:
        """List test profile runs.

        Get all test profile runs for the given filters.

        :keyword min_start_date_time: Minimum Start DateTime(RFC 3339 literal format) of the test
         profile runs to filter on. Default value is None.
        :paramtype min_start_date_time: ~datetime.datetime
        :keyword max_start_date_time: Maximum Start DateTime(RFC 3339 literal format) of the test
         profile runs to filter on. Default value is None.
        :paramtype max_start_date_time: ~datetime.datetime
        :keyword min_end_date_time: Minimum End DateTime(RFC 3339 literal format) of the test profile
         runs to filter on. Default value is None.
        :paramtype min_end_date_time: ~datetime.datetime
        :keyword max_end_date_time: Maximum End DateTime(RFC 3339 literal format) of the test profile
         runs to filter on. Default value is None.
        :paramtype max_end_date_time: ~datetime.datetime
        :keyword created_date_start_time: Start DateTime(RFC 3339 literal format) of the created time
         range to filter test profile runs. Default value is None.
        :paramtype created_date_start_time: ~datetime.datetime
        :keyword created_date_end_time: End DateTime(RFC 3339 literal format) of the created time range
         to filter test profile runs. Default value is None.
        :paramtype created_date_end_time: ~datetime.datetime
        :keyword test_profile_run_ids: Comma separated list of IDs of the test profile runs to filter.
         Default value is None.
        :paramtype test_profile_run_ids: list[str]
        :keyword test_profile_ids: Comma separated IDs of the test profiles which should be associated
         with the test profile runs to fetch. Default value is None.
        :paramtype test_profile_ids: list[str]
        :keyword statuses: Comma separated list of Statuses of the test profile runs to filter. Default
         value is None.
        :paramtype statuses: list[str]
        :return: An iterator like instance of TestProfileRun
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.developer.loadtesting.models.TestProfileRun]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.TestProfileRun]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_test_run_list_test_profile_runs_request(
                    maxpagesize=maxpagesize,
                    min_start_date_time=min_start_date_time,
                    max_start_date_time=max_start_date_time,
                    min_end_date_time=min_end_date_time,
                    max_end_date_time=max_end_date_time,
                    created_date_start_time=created_date_start_time,
                    created_date_end_time=created_date_end_time,
                    test_profile_run_ids=test_profile_run_ids,
                    test_profile_ids=test_profile_ids,
                    statuses=statuses,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TestProfileRun], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    @api_version_validation(
        method_added_on="2024-05-01-preview",
        params_added_on={"2024-05-01-preview": ["api_version", "test_profile_run_id", "accept"]},
    )
    async def stop_test_profile_run(self, test_profile_run_id: str, **kwargs: Any) -> _models.TestProfileRun:
        """Stop test profile run.

        Stop test profile run for the given test profile run Id.

        :param test_profile_run_id: Unique identifier for the test profile run, must contain only
         lower-case alphabetic, numeric, underscore or hyphen characters. Required.
        :type test_profile_run_id: str
        :return: TestProfileRun. The TestProfileRun is compatible with MutableMapping
        :rtype: ~azure.developer.loadtesting.models.TestProfileRun
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TestProfileRun] = kwargs.pop("cls", None)

        _request = build_load_test_run_stop_test_profile_run_request(
            test_profile_run_id=test_profile_run_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TestProfileRun, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
