# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementSyncMembersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sync_members_list_by_sync_group(self, resource_group):
        response = self.client.sync_members.list_by_sync_group(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sync_members_get(self, resource_group):
        response = self.client.sync_members.get(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            sync_member_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sync_members_begin_create_or_update(self, resource_group):
        response = self.client.sync_members.begin_create_or_update(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            sync_member_name="str",
            parameters={
                "databaseName": "str",
                "databaseType": "str",
                "id": "str",
                "name": "str",
                "password": "str",
                "privateEndpointName": "str",
                "serverName": "str",
                "sqlServerDatabaseId": "str",
                "syncAgentId": "str",
                "syncDirection": "str",
                "syncMemberAzureDatabaseResourceId": "str",
                "syncState": "str",
                "type": "str",
                "usePrivateLinkConnection": bool,
                "userName": "str",
            },
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sync_members_begin_delete(self, resource_group):
        response = self.client.sync_members.begin_delete(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            sync_member_name="str",
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sync_members_begin_update(self, resource_group):
        response = self.client.sync_members.begin_update(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            sync_member_name="str",
            parameters={
                "databaseName": "str",
                "databaseType": "str",
                "id": "str",
                "name": "str",
                "password": "str",
                "privateEndpointName": "str",
                "serverName": "str",
                "sqlServerDatabaseId": "str",
                "syncAgentId": "str",
                "syncDirection": "str",
                "syncMemberAzureDatabaseResourceId": "str",
                "syncState": "str",
                "type": "str",
                "usePrivateLinkConnection": bool,
                "userName": "str",
            },
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sync_members_begin_refresh_member_schema(self, resource_group):
        response = self.client.sync_members.begin_refresh_member_schema(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            sync_member_name="str",
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_sync_members_list_member_schemas(self, resource_group):
        response = self.client.sync_members.list_member_schemas(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            sync_group_name="str",
            sync_member_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
