# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementManagedInstanceVulnerabilityAssessmentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_instance_vulnerability_assessments_list_by_instance(self, resource_group):
        response = self.client.managed_instance_vulnerability_assessments.list_by_instance(
            resource_group_name=resource_group.name,
            managed_instance_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_instance_vulnerability_assessments_get(self, resource_group):
        response = self.client.managed_instance_vulnerability_assessments.get(
            resource_group_name=resource_group.name,
            managed_instance_name="str",
            vulnerability_assessment_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_instance_vulnerability_assessments_create_or_update(self, resource_group):
        response = self.client.managed_instance_vulnerability_assessments.create_or_update(
            resource_group_name=resource_group.name,
            managed_instance_name="str",
            vulnerability_assessment_name="str",
            parameters={
                "id": "str",
                "name": "str",
                "recurringScans": {"emailSubscriptionAdmins": True, "emails": ["str"], "isEnabled": bool},
                "storageAccountAccessKey": "str",
                "storageContainerPath": "str",
                "storageContainerSasKey": "str",
                "type": "str",
            },
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_instance_vulnerability_assessments_delete(self, resource_group):
        response = self.client.managed_instance_vulnerability_assessments.delete(
            resource_group_name=resource_group.name,
            managed_instance_name="str",
            vulnerability_assessment_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...
