# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementDiskAccessesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_begin_create_or_update(self, resource_group):
        response = self.client.disk_accesses.begin_create_or_update(
            resource_group_name=resource_group.name,
            disk_access_name="str",
            disk_access={
                "location": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "privateEndpointConnections": [
                    {
                        "id": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {
                            "actionsRequired": "str",
                            "description": "str",
                            "status": "str",
                        },
                        "provisioningState": "str",
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "tags": {"str": "str"},
                "timeCreated": "2020-02-20 00:00:00",
                "type": "str",
            },
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_begin_update(self, resource_group):
        response = self.client.disk_accesses.begin_update(
            resource_group_name=resource_group.name,
            disk_access_name="str",
            disk_access={"tags": {"str": "str"}},
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_get(self, resource_group):
        response = self.client.disk_accesses.get(
            resource_group_name=resource_group.name,
            disk_access_name="str",
            api_version="2023-10-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_begin_delete(self, resource_group):
        response = self.client.disk_accesses.begin_delete(
            resource_group_name=resource_group.name,
            disk_access_name="str",
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_list_by_resource_group(self, resource_group):
        response = self.client.disk_accesses.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-10-02",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_list(self, resource_group):
        response = self.client.disk_accesses.list(
            api_version="2023-10-02",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_get_private_link_resources(self, resource_group):
        response = self.client.disk_accesses.get_private_link_resources(
            resource_group_name=resource_group.name,
            disk_access_name="str",
            api_version="2023-10-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_begin_update_a_private_endpoint_connection(self, resource_group):
        response = self.client.disk_accesses.begin_update_a_private_endpoint_connection(
            resource_group_name=resource_group.name,
            disk_access_name="str",
            private_endpoint_connection_name="str",
            private_endpoint_connection={
                "id": "str",
                "name": "str",
                "privateEndpoint": {"id": "str"},
                "privateLinkServiceConnectionState": {"actionsRequired": "str", "description": "str", "status": "str"},
                "provisioningState": "str",
                "type": "str",
            },
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_get_a_private_endpoint_connection(self, resource_group):
        response = self.client.disk_accesses.get_a_private_endpoint_connection(
            resource_group_name=resource_group.name,
            disk_access_name="str",
            private_endpoint_connection_name="str",
            api_version="2023-10-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_begin_delete_a_private_endpoint_connection(self, resource_group):
        response = self.client.disk_accesses.begin_delete_a_private_endpoint_connection(
            resource_group_name=resource_group.name,
            disk_access_name="str",
            private_endpoint_connection_name="str",
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_accesses_list_private_endpoint_connections(self, resource_group):
        response = self.client.disk_accesses.list_private_endpoint_connections(
            resource_group_name=resource_group.name,
            disk_access_name="str",
            api_version="2023-10-02",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
