"""
Raw data imported from NIST https://www.nist.gov/pml/atomic-weights-and-isotopic-compositions-relative-atomic-masses
The atomic weights data were published by J. Meija et al in Atomic Weights of the Elements 2013, 
and the isotopic compositions data were published by M. Berglund and
M.E. Wieser in Isotopic Compositions of the Elements 2009.
The relative atomic masses of the isotopes data were published by M. Wang, G. Audi, A.H. Wapstra, F.G. Kondev,
M. MacCormick, X. Xu1, and B. Pfeiffer in The AME2012 Atomic Mass Evaluation.
"""

# flake8: noqa
# fmt: off
ATOMIC_WEIGHTS = {
    (1, 1):     1.00782503223,
    (1, 2):     2.01410177812,
    (1, 3):     3.0160492779,
    (1, 4):     4.02643,
    (1, 5):     5.035311,
    (1, 6):     6.04496,
    (1, 7):     7.0527,
    (2, 3):     3.0160293201,
    (2, 4):     4.00260325413,
    (2, 5):     5.012057,
    (2, 6):     6.018885891,
    (2, 7):     7.0279907,
    (2, 8):     8.03393439,
    (2, 9):     9.043946,
    (2, 10):    10.05279,
    (3, 3):     3.0308,
    (3, 4):     4.02719,
    (3, 5):     5.012538,
    (3, 6):     6.0151228874,
    (3, 7):     7.0160034366,
    (3, 8):     8.022486246,
    (3, 9):     9.02679019,
    (3, 10):    10.035483,
    (3, 11):    11.04372358,
    (3, 12):    12.052517,
    (3, 13):    13.06263,
    (4, 5):     5.0399,
    (4, 6):     6.0197264,
    (4, 7):     7.016928717,
    (4, 8):     8.005305102,
    (4, 9):     9.012183065,
    (4, 10):    10.013534695,
    (4, 11):    11.02166108,
    (4, 12):    12.0269221,
    (4, 13):    13.036135,
    (4, 14):    14.04289,
    (4, 15):    15.05342,
    (4, 16):    16.06167,
    (5, 6):     6.0508,
    (5, 7):     7.029712,
    (5, 8):     8.0246073,
    (5, 9):     9.01332965,
    (5, 10):    10.01293695,
    (5, 11):    11.00930536,
    (5, 12):    12.0143527,
    (5, 13):    13.0177802,
    (5, 14):    14.025404,
    (5, 15):    15.031088,
    (5, 16):    16.039842,
    (5, 17):    17.04699,
    (5, 18):    18.05566,
    (5, 19):    19.0631,
    (5, 20):    20.07207,
    (5, 21):    21.08129,
    (6, 8):     8.037643,
    (6, 9):     9.0310372,
    (6, 10):    10.01685331,
    (6, 11):    11.0114336,
    (6, 12):    12.0,
    (6, 13):    13.00335483507,
    (6, 14):    14.0032419884,
    (6, 15):    15.01059926,
    (6, 16):    16.0147013,
    (6, 17):    17.022577,
    (6, 18):    18.026751,
    (6, 19):    19.0348,
    (6, 20):    20.04032,
    (6, 21):    21.049,
    (6, 22):    22.05753,
    (6, 23):    23.0689,
    (7, 10):    10.04165,
    (7, 11):    11.026091,
    (7, 12):    12.0186132,
    (7, 13):    13.00573861,
    (7, 14):    14.00307400443,
    (7, 15):    15.00010889888,
    (7, 16):    16.0061019,
    (7, 17):    17.008449,
    (7, 18):    18.014078,
    (7, 19):    19.017022,
    (7, 20):    20.023366,
    (7, 21):    21.02711,
    (7, 22):    22.03439,
    (7, 23):    23.04114,
    (7, 24):    24.05039,
    (7, 25):    25.0601,
    (8, 12):    12.034262,
    (8, 13):    13.024815,
    (8, 14):    14.00859636,
    (8, 15):    15.00306562,
    (8, 16):    15.99491461957,
    (8, 17):    16.9991317565,
    (8, 18):    17.99915961286,
    (8, 19):    19.003578,
    (8, 20):    20.00407535,
    (8, 21):    21.008655,
    (8, 22):    22.009966,
    (8, 23):    23.015696,
    (8, 24):    24.01986,
    (8, 25):    25.02936,
    (8, 26):    26.03729,
    (8, 27):    27.04772,
    (8, 28):    28.05591,
    (9, 14):    14.034315,
    (9, 15):    15.018043,
    (9, 16):    16.0114657,
    (9, 17):    17.00209524,
    (9, 18):    18.00093733,
    (9, 19):    18.99840316273,
    (9, 20):    19.999981252,
    (9, 21):    20.9999489,
    (9, 22):    22.002999,
    (9, 23):    23.003557,
    (9, 24):    24.008115,
    (9, 25):    25.012199,
    (9, 26):    26.020038,
    (9, 27):    27.02644,
    (9, 28):    28.03534,
    (9, 29):    29.04254,
    (9, 30):    30.05165,
    (9, 31):    31.05971,
    (10, 16):   16.02575,
    (10, 17):   17.01771396,
    (10, 18):   18.0057087,
    (10, 19):   19.00188091,
    (10, 20):   19.9924401762,
    (10, 21):   20.993846685,
    (10, 22):   21.991385114,
    (10, 23):   22.99446691,
    (10, 24):   23.99361065,
    (10, 25):   24.997789,
    (10, 26):   26.000515,
    (10, 27):   27.007553,
    (10, 28):   28.01212,
    (10, 29):   29.01975,
    (10, 30):   30.02473,
    (10, 31):   31.0331,
    (10, 32):   32.03972,
    (10, 33):   33.04938,
    (10, 34):   34.05673,
    (11, 18):   18.02688,
    (11, 19):   19.01388,
    (11, 20):   20.0073544,
    (11, 21):   20.99765469,
    (11, 22):   21.99443741,
    (11, 23):   22.989769282,
    (11, 24):   23.99096295,
    (11, 25):   24.989954,
    (11, 26):   25.9926346,
    (11, 27):   26.9940765,
    (11, 28):   27.998939,
    (11, 29):   29.0028771,
    (11, 30):   30.0090979,
    (11, 31):   31.013163,
    (11, 32):   32.02019,
    (11, 33):   33.02573,
    (11, 34):   34.03359,
    (11, 35):   35.04062,
    (11, 36):   36.04929,
    (11, 37):   37.05705,
    (12, 19):   19.034169,
    (12, 20):   20.01885,
    (12, 21):   21.011716,
    (12, 22):   21.99957065,
    (12, 23):   22.99412421,
    (12, 24):   23.985041697,
    (12, 25):   24.985836976,
    (12, 26):   25.982592968,
    (12, 27):   26.984340624,
    (12, 28):   27.9838767,
    (12, 29):   28.988617,
    (12, 30):   29.9904629,
    (12, 31):   30.996648,
    (12, 32):   31.9991102,
    (12, 33):   33.0053271,
    (12, 34):   34.008935,
    (12, 35):   35.01679,
    (12, 36):   36.02188,
    (12, 37):   37.03037,
    (12, 38):   38.03658,
    (12, 39):   39.04538,
    (12, 40):   40.05218,
    (13, 21):   21.02897,
    (13, 22):   22.01954,
    (13, 23):   23.00724435,
    (13, 24):   23.9999489,
    (13, 25):   24.9904281,
    (13, 26):   25.986891904,
    (13, 27):   26.98153853,
    (13, 28):   27.98191021,
    (13, 29):   28.9804565,
    (13, 30):   29.98296,
    (13, 31):   30.983945,
    (13, 32):   31.988085,
    (13, 33):   32.990909,
    (13, 34):   33.996705,
    (13, 35):   34.999764,
    (13, 36):   36.00639,
    (13, 37):   37.01053,
    (13, 38):   38.0174,
    (13, 39):   39.02254,
    (13, 40):   40.03003,
    (13, 41):   41.03638,
    (13, 42):   42.04384,
    (13, 43):   43.05147,
    (14, 22):   22.03579,
    (14, 23):   23.02544,
    (14, 24):   24.011535,
    (14, 25):   25.004109,
    (14, 26):   25.99233384,
    (14, 27):   26.98670481,
    (14, 28):   27.97692653465,
    (14, 29):   28.9764946649,
    (14, 30):   29.973770136,
    (14, 31):   30.975363194,
    (14, 32):   31.97415154,
    (14, 33):   32.97797696,
    (14, 34):   33.978576,
    (14, 35):   34.984583,
    (14, 36):   35.986695,
    (14, 37):   36.992921,
    (14, 38):   37.995523,
    (14, 39):   39.002491,
    (14, 40):   40.00583,
    (14, 41):   41.01301,
    (14, 42):   42.01778,
    (14, 43):   43.0248,
    (14, 44):   44.03061,
    (14, 45):   45.03995,
    (15, 24):   24.03577,
    (15, 25):   25.02119,
    (15, 26):   26.01178,
    (15, 27):   26.999224,
    (15, 28):   27.9923266,
    (15, 29):   28.98180079,
    (15, 30):   29.97831375,
    (15, 31):   30.97376199842,
    (15, 32):   31.973907643,
    (15, 33):   32.9717257,
    (15, 34):   33.97364589,
    (15, 35):   34.9733141,
    (15, 36):   35.97826,
    (15, 37):   36.979607,
    (15, 38):   37.984252,
    (15, 39):   38.986227,
    (15, 40):   39.99133,
    (15, 41):   40.994654,
    (15, 42):   42.00108,
    (15, 43):   43.00502,
    (15, 44):   44.01121,
    (15, 45):   45.01645,
    (15, 46):   46.02446,
    (15, 47):   47.03139,
    (16, 26):   26.02907,
    (16, 27):   27.01828,
    (16, 28):   28.00437,
    (16, 29):   28.996611,
    (16, 30):   29.98490703,
    (16, 31):   30.97955701,
    (16, 32):   31.9720711744,
    (16, 33):   32.9714589098,
    (16, 34):   33.967867004,
    (16, 35):   34.96903231,
    (16, 36):   35.96708071,
    (16, 37):   36.97112551,
    (16, 38):   37.9711633,
    (16, 39):   38.975134,
    (16, 40):   39.9754826,
    (16, 41):   40.9795935,
    (16, 42):   41.9810651,
    (16, 43):   42.9869076,
    (16, 44):   43.9901188,
    (16, 45):   44.99572,
    (16, 46):   46.00004,
    (16, 47):   47.00795,
    (16, 48):   48.0137,
    (16, 49):   49.02276,
    (17, 28):   28.02954,
    (17, 29):   29.01478,
    (17, 30):   30.00477,
    (17, 31):   30.992414,
    (17, 32):   31.98568464,
    (17, 33):   32.97745199,
    (17, 34):   33.973762485,
    (17, 35):   34.968852682,
    (17, 36):   35.968306809,
    (17, 37):   36.965902602,
    (17, 38):   37.96801044,
    (17, 39):   38.9680082,
    (17, 40):   39.970415,
    (17, 41):   40.970685,
    (17, 42):   41.97325,
    (17, 43):   42.97389,
    (17, 44):   43.97787,
    (17, 45):   44.98029,
    (17, 46):   45.98517,
    (17, 47):   46.98916,
    (17, 48):   47.99564,
    (17, 49):   49.00123,
    (17, 50):   50.00905,
    (17, 51):   51.01554,
    (18, 30):   30.02307,
    (18, 31):   31.01212,
    (18, 32):   31.9976378,
    (18, 33):   32.98992555,
    (18, 34):   33.98027009,
    (18, 35):   34.97525759,
    (18, 36):   35.967545105,
    (18, 37):   36.96677633,
    (18, 38):   37.96273211,
    (18, 39):   38.964313,
    (18, 40):   39.9623831237,
    (18, 41):   40.96450057,
    (18, 42):   41.9630457,
    (18, 43):   42.9656361,
    (18, 44):   43.9649238,
    (18, 45):   44.96803973,
    (18, 46):   45.968083,
    (18, 47):   46.972935,
    (18, 48):   47.97591,
    (18, 49):   48.9819,
    (18, 50):   49.98613,
    (18, 51):   50.9937,
    (18, 52):   51.99896,
    (18, 53):   53.00729,
    (19, 32):   32.02265,
    (19, 33):   33.00756,
    (19, 34):   33.99869,
    (19, 35):   34.98800541,
    (19, 36):   35.98130201,
    (19, 37):   36.97337589,
    (19, 38):   37.96908112,
    (19, 39):   38.9637064864,
    (19, 40):   39.963998166,
    (19, 41):   40.9618252579,
    (19, 42):   41.96240231,
    (19, 43):   42.9607347,
    (19, 44):   43.96158699,
    (19, 45):   44.96069149,
    (19, 46):   45.96198159,
    (19, 47):   46.9616616,
    (19, 48):   47.96534119,
    (19, 49):   48.96821075,
    (19, 50):   49.97238,
    (19, 51):   50.975828,
    (19, 52):   51.98224,
    (19, 53):   52.98746,
    (19, 54):   53.99463,
    (19, 55):   55.00076,
    (19, 56):   56.00851,
    (20, 34):   34.01487,
    (20, 35):   35.00514,
    (20, 36):   35.993074,
    (20, 37):   36.98589785,
    (20, 38):   37.97631922,
    (20, 39):   38.97071081,
    (20, 40):   39.962590863,
    (20, 41):   40.96227792,
    (20, 42):   41.95861783,
    (20, 43):   42.95876644,
    (20, 44):   43.95548156,
    (20, 45):   44.95618635,
    (20, 46):   45.953689,
    (20, 47):   46.9545424,
    (20, 48):   47.95252276,
    (20, 49):   48.95566274,
    (20, 50):   49.9574992,
    (20, 51):   50.960989,
    (20, 52):   51.963217,
    (20, 53):   52.96945,
    (20, 54):   53.9734,
    (20, 55):   54.9803,
    (20, 56):   55.98508,
    (20, 57):   56.99262,
    (20, 58):   57.99794,
    (21, 36):   36.01648,
    (21, 37):   37.00374,
    (21, 38):   37.99512,
    (21, 39):   38.984785,
    (21, 40):   39.9779673,
    (21, 41):   40.969251105,
    (21, 42):   41.96551653,
    (21, 43):   42.9611505,
    (21, 44):   43.9594029,
    (21, 45):   44.95590828,
    (21, 46):   45.95516826,
    (21, 47):   46.9524037,
    (21, 48):   47.9522236,
    (21, 49):   48.9500146,
    (21, 50):   49.952176,
    (21, 51):   50.953592,
    (21, 52):   51.95688,
    (21, 53):   52.95909,
    (21, 54):   53.96393,
    (21, 55):   54.96782,
    (21, 56):   55.97345,
    (21, 57):   56.97777,
    (21, 58):   57.98403,
    (21, 59):   58.98894,
    (21, 60):   59.99565,
    (21, 61):   61.001,
    (22, 38):   38.01145,
    (22, 39):   39.00236,
    (22, 40):   39.9905,
    (22, 41):   40.983148,
    (22, 42):   41.97304903,
    (22, 43):   42.9685225,
    (22, 44):   43.95968995,
    (22, 45):   44.95812198,
    (22, 46):   45.95262772,
    (22, 47):   46.95175879,
    (22, 48):   47.94794198,
    (22, 49):   48.94786568,
    (22, 50):   49.94478689,
    (22, 51):   50.94661065,
    (22, 52):   51.946893,
    (22, 53):   52.94973,
    (22, 54):   53.95105,
    (22, 55):   54.95527,
    (22, 56):   55.95791,
    (22, 57):   56.96364,
    (22, 58):   57.9666,
    (22, 59):   58.97247,
    (22, 60):   59.97603,
    (22, 61):   60.98245,
    (22, 62):   61.98651,
    (22, 63):   62.99375,
    (23, 40):   40.01276,
    (23, 41):   41.00021,
    (23, 42):   41.99182,
    (23, 43):   42.980766,
    (23, 44):   43.97411,
    (23, 45):   44.9657748,
    (23, 46):   45.96019878,
    (23, 47):   46.95490491,
    (23, 48):   47.9522522,
    (23, 49):   48.9485118,
    (23, 50):   49.94715601,
    (23, 51):   50.94395704,
    (23, 52):   51.94477301,
    (23, 53):   52.9443367,
    (23, 54):   53.946439,
    (23, 55):   54.94724,
    (23, 56):   55.95048,
    (23, 57):   56.95252,
    (23, 58):   57.95672,
    (23, 59):   58.95939,
    (23, 60):   59.96431,
    (23, 61):   60.96725,
    (23, 62):   61.97265,
    (23, 63):   62.97639,
    (23, 64):   63.98264,
    (23, 65):   64.9875,
    (23, 66):   65.99398,
    (24, 42):   42.0067,
    (24, 43):   42.99753,
    (24, 44):   43.98536,
    (24, 45):   44.97905,
    (24, 46):   45.968359,
    (24, 47):   46.9628974,
    (24, 48):   47.9540291,
    (24, 49):   48.9513333,
    (24, 50):   49.94604183,
    (24, 51):   50.94476502,
    (24, 52):   51.94050623,
    (24, 53):   52.94064815,
    (24, 54):   53.93887916,
    (24, 55):   54.94083843,
    (24, 56):   55.9406531,
    (24, 57):   56.943613,
    (24, 58):   57.94435,
    (24, 59):   58.94859,
    (24, 60):   59.95008,
    (24, 61):   60.95442,
    (24, 62):   61.9561,
    (24, 63):   62.96165,
    (24, 64):   63.96408,
    (24, 65):   64.96996,
    (24, 66):   65.97366,
    (24, 67):   66.98016,
    (24, 68):   67.98403,
    (25, 44):   44.00715,
    (25, 45):   44.99449,
    (25, 46):   45.98609,
    (25, 47):   46.975775,
    (25, 48):   47.96852,
    (25, 49):   48.959595,
    (25, 50):   49.95423778,
    (25, 51):   50.94820847,
    (25, 52):   51.9455639,
    (25, 53):   52.94128889,
    (25, 54):   53.9403576,
    (25, 55):   54.93804391,
    (25, 56):   55.93890369,
    (25, 57):   56.9382861,
    (25, 58):   57.9400666,
    (25, 59):   58.9403911,
    (25, 60):   59.9431366,
    (25, 61):   60.9444525,
    (25, 62):   61.94795,
    (25, 63):   62.9496647,
    (25, 64):   63.9538494,
    (25, 65):   64.9560198,
    (25, 66):   65.960547,
    (25, 67):   66.96424,
    (25, 68):   67.96962,
    (25, 69):   68.97366,
    (25, 70):   69.97937,
    (25, 71):   70.98368,
    (26, 45):   45.01442,
    (26, 46):   46.00063,
    (26, 47):   46.99185,
    (26, 48):   47.98023,
    (26, 49):   48.973429,
    (26, 50):   49.962975,
    (26, 51):   50.956841,
    (26, 52):   51.9481131,
    (26, 53):   52.9453064,
    (26, 54):   53.93960899,
    (26, 55):   54.93829199,
    (26, 56):   55.93493633,
    (26, 57):   56.93539284,
    (26, 58):   57.93327443,
    (26, 59):   58.93487434,
    (26, 60):   59.9340711,
    (26, 61):   60.9367462,
    (26, 62):   61.9367918,
    (26, 63):   62.9402727,
    (26, 64):   63.9409878,
    (26, 65):   64.9450115,
    (26, 66):   65.94625,
    (26, 67):   66.95054,
    (26, 68):   67.95295,
    (26, 69):   68.95807,
    (26, 70):   69.96102,
    (26, 71):   70.96672,
    (26, 72):   71.96983,
    (26, 73):   72.97572,
    (26, 74):   73.97935,
    (27, 47):   47.01057,
    (27, 48):   48.00093,
    (27, 49):   48.98891,
    (27, 50):   49.98091,
    (27, 51):   50.970647,
    (27, 52):   51.96351,
    (27, 53):   52.9542041,
    (27, 54):   53.94845987,
    (27, 55):   54.9419972,
    (27, 56):   55.9398388,
    (27, 57):   56.93629057,
    (27, 58):   57.9357521,
    (27, 59):   58.93319429,
    (27, 60):   59.9338163,
    (27, 61):   60.93247662,
    (27, 62):   61.934059,
    (27, 63):   62.9336,
    (27, 64):   63.935811,
    (27, 65):   64.9364621,
    (27, 66):   65.939443,
    (27, 67):   66.9406096,
    (27, 68):   67.94426,
    (27, 69):   68.94614,
    (27, 70):   69.94963,
    (27, 71):   70.95237,
    (27, 72):   71.95729,
    (27, 73):   72.96039,
    (27, 74):   73.96515,
    (27, 75):   74.96876,
    (27, 76):   75.97413,
    (28, 48):   48.01769,
    (28, 49):   49.0077,
    (28, 50):   49.99474,
    (28, 51):   50.98611,
    (28, 52):   51.9748,
    (28, 53):   52.96819,
    (28, 54):   53.957892,
    (28, 55):   54.95133063,
    (28, 56):   55.94212855,
    (28, 57):   56.93979218,
    (28, 58):   57.93534241,
    (28, 59):   58.9343462,
    (28, 60):   59.93078588,
    (28, 61):   60.93105557,
    (28, 62):   61.92834537,
    (28, 63):   62.92966963,
    (28, 64):   63.92796682,
    (28, 65):   64.93008517,
    (28, 66):   65.9291393,
    (28, 67):   66.9315694,
    (28, 68):   67.9318688,
    (28, 69):   68.9356103,
    (28, 70):   69.9364313,
    (28, 71):   70.940519,
    (28, 72):   71.9417859,
    (28, 73):   72.9462067,
    (28, 74):   73.94798,
    (28, 75):   74.9525,
    (28, 76):   75.95533,
    (28, 77):   76.96055,
    (28, 78):   77.96336,
    (28, 79):   78.97025,
    (29, 52):   51.99671,
    (29, 53):   52.98459,
    (29, 54):   53.97666,
    (29, 55):   54.96604,
    (29, 56):   55.95895,
    (29, 57):   56.9492125,
    (29, 58):   57.94453305,
    (29, 59):   58.93949748,
    (29, 60):   59.9373645,
    (29, 61):   60.9334576,
    (29, 62):   61.93259541,
    (29, 63):   62.92959772,
    (29, 64):   63.92976434,
    (29, 65):   64.9277897,
    (29, 66):   65.92886903,
    (29, 67):   66.9277303,
    (29, 68):   67.9296109,
    (29, 69):   68.9294293,
    (29, 70):   69.9323921,
    (29, 71):   70.9326768,
    (29, 72):   71.9358203,
    (29, 73):   72.9366744,
    (29, 74):   73.9398749,
    (29, 75):   74.9415226,
    (29, 76):   75.945275,
    (29, 77):   76.94792,
    (29, 78):   77.95223,
    (29, 79):   78.95502,
    (29, 80):   79.96089,
    (29, 81):   80.96587,
    (29, 82):   81.97244,
    (30, 54):   53.99204,
    (30, 55):   54.98398,
    (30, 56):   55.97254,
    (30, 57):   56.96506,
    (30, 58):   57.954591,
    (30, 59):   58.94931266,
    (30, 60):   59.9418421,
    (30, 61):   60.939507,
    (30, 62):   61.93433397,
    (30, 63):   62.9332115,
    (30, 64):   63.92914201,
    (30, 65):   64.92924077,
    (30, 66):   65.92603381,
    (30, 67):   66.92712775,
    (30, 68):   67.92484455,
    (30, 69):   68.9265507,
    (30, 70):   69.9253192,
    (30, 71):   70.9277196,
    (30, 72):   71.9268428,
    (30, 73):   72.9295826,
    (30, 74):   73.9294073,
    (30, 75):   74.9328402,
    (30, 76):   75.933115,
    (30, 77):   76.9368872,
    (30, 78):   77.9382892,
    (30, 79):   78.9426381,
    (30, 80):   79.9445529,
    (30, 81):   80.9504026,
    (30, 82):   81.95426,
    (30, 83):   82.96056,
    (30, 84):   83.96521,
    (30, 85):   84.97226,
    (31, 56):   55.99536,
    (31, 57):   56.9832,
    (31, 58):   57.97478,
    (31, 59):   58.96353,
    (31, 60):   59.95729,
    (31, 61):   60.949399,
    (31, 62):   61.94419025,
    (31, 63):   62.9392942,
    (31, 64):   63.9368404,
    (31, 65):   64.93273459,
    (31, 66):   65.9315894,
    (31, 67):   66.9282025,
    (31, 68):   67.9279805,
    (31, 69):   68.9255735,
    (31, 70):   69.9260219,
    (31, 71):   70.92470258,
    (31, 72):   71.92636747,
    (31, 73):   72.9251747,
    (31, 74):   73.9269457,
    (31, 75):   74.9265002,
    (31, 76):   75.9288276,
    (31, 77):   76.9291543,
    (31, 78):   77.9316088,
    (31, 79):   78.9328523,
    (31, 80):   79.9364208,
    (31, 81):   80.9381338,
    (31, 82):   81.9431765,
    (31, 83):   82.9471203,
    (31, 84):   83.95246,
    (31, 85):   84.95699,
    (31, 86):   85.96301,
    (31, 87):   86.96824,
    (32, 58):   57.99172,
    (32, 59):   58.98249,
    (32, 60):   59.97036,
    (32, 61):   60.96379,
    (32, 62):   61.95502,
    (32, 63):   62.949628,
    (32, 64):   63.9416899,
    (32, 65):   64.9393681,
    (32, 66):   65.9338621,
    (32, 67):   66.9327339,
    (32, 68):   67.9280953,
    (32, 69):   68.9279645,
    (32, 70):   69.92424875,
    (32, 71):   70.92495233,
    (32, 72):   71.922075826,
    (32, 73):   72.923458956,
    (32, 74):   73.921177761,
    (32, 75):   74.92285837,
    (32, 76):   75.921402726,
    (32, 77):   76.923549843,
    (32, 78):   77.9228529,
    (32, 79):   78.92536,
    (32, 80):   79.9253508,
    (32, 81):   80.9288329,
    (32, 82):   81.929774,
    (32, 83):   82.9345391,
    (32, 84):   83.9375751,
    (32, 85):   84.9429697,
    (32, 86):   85.94658,
    (32, 87):   86.95268,
    (32, 88):   87.95691,
    (32, 89):   88.96379,
    (32, 90):   89.96863,
    (33, 60):   59.99388,
    (33, 61):   60.98112,
    (33, 62):   61.97361,
    (33, 63):   62.9639,
    (33, 64):   63.95743,
    (33, 65):   64.949611,
    (33, 66):   65.9441488,
    (33, 67):   66.93925111,
    (33, 68):   67.9367741,
    (33, 69):   68.932246,
    (33, 70):   69.930926,
    (33, 71):   70.9271138,
    (33, 72):   71.9267523,
    (33, 73):   72.9238291,
    (33, 74):   73.9239286,
    (33, 75):   74.92159457,
    (33, 76):   75.92239202,
    (33, 77):   76.9206476,
    (33, 78):   77.921828,
    (33, 79):   78.9209484,
    (33, 80):   79.9224746,
    (33, 81):   80.9221323,
    (33, 82):   81.9247412,
    (33, 83):   82.9252069,
    (33, 84):   83.9293033,
    (33, 85):   84.9321637,
    (33, 86):   85.9367015,
    (33, 87):   86.9402917,
    (33, 88):   87.94555,
    (33, 89):   88.94976,
    (33, 90):   89.95563,
    (33, 91):   90.96039,
    (33, 92):   91.96674,
    (34, 64):   63.97109,
    (34, 65):   64.9644,
    (34, 66):   65.95559,
    (34, 67):   66.949994,
    (34, 68):   67.94182524,
    (34, 69):   68.9394148,
    (34, 70):   69.9335155,
    (34, 71):   70.9322094,
    (34, 72):   71.9271405,
    (34, 73):   72.9267549,
    (34, 74):   73.922475934,
    (34, 75):   74.92252287,
    (34, 76):   75.919213704,
    (34, 77):   76.919914154,
    (34, 78):   77.91730928,
    (34, 79):   78.91849929,
    (34, 80):   79.9165218,
    (34, 81):   80.917993,
    (34, 82):   81.9166995,
    (34, 83):   82.9191186,
    (34, 84):   83.9184668,
    (34, 85):   84.9222608,
    (34, 86):   85.9243117,
    (34, 87):   86.9286886,
    (34, 88):   87.9314175,
    (34, 89):   88.9366691,
    (34, 90):   89.9401,
    (34, 91):   90.94596,
    (34, 92):   91.94984,
    (34, 93):   92.95629,
    (34, 94):   93.96049,
    (34, 95):   94.9673,
    (35, 67):   66.96465,
    (35, 68):   67.95873,
    (35, 69):   68.950497,
    (35, 70):   69.944792,
    (35, 71):   70.9393422,
    (35, 72):   71.9365886,
    (35, 73):   72.9316715,
    (35, 74):   73.9299102,
    (35, 75):   74.9258105,
    (35, 76):   75.924542,
    (35, 77):   76.9213792,
    (35, 78):   77.9211459,
    (35, 79):   78.9183376,
    (35, 80):   79.9185298,
    (35, 81):   80.9162897,
    (35, 82):   81.9168032,
    (35, 83):   82.9151756,
    (35, 84):   83.916496,
    (35, 85):   84.9156458,
    (35, 86):   85.9188054,
    (35, 87):   86.920674,
    (35, 88):   87.9240833,
    (35, 89):   88.9267046,
    (35, 90):   89.9312928,
    (35, 91):   90.9343986,
    (35, 92):   91.9396316,
    (35, 93):   92.94313,
    (35, 94):   93.9489,
    (35, 95):   94.95301,
    (35, 96):   95.95903,
    (35, 97):   96.96344,
    (35, 98):   97.96946,
    (36, 69):   68.96518,
    (36, 70):   69.95604,
    (36, 71):   70.95027,
    (36, 72):   71.9420924,
    (36, 73):   72.9392892,
    (36, 74):   73.933084,
    (36, 75):   74.9309457,
    (36, 76):   75.9259103,
    (36, 77):   76.92467,
    (36, 78):   77.92036494,
    (36, 79):   78.9200829,
    (36, 80):   79.91637808,
    (36, 81):   80.9165912,
    (36, 82):   81.91348273,
    (36, 83):   82.91412716,
    (36, 84):   83.9114977282,
    (36, 85):   84.9125273,
    (36, 86):   85.9106106269,
    (36, 87):   86.91335476,
    (36, 88):   87.9144479,
    (36, 89):   88.9178355,
    (36, 90):   89.9195279,
    (36, 91):   90.9238063,
    (36, 92):   91.9261731,
    (36, 93):   92.9311472,
    (36, 94):   93.93414,
    (36, 95):   94.939711,
    (36, 96):   95.943017,
    (36, 97):   96.94909,
    (36, 98):   97.95243,
    (36, 99):   98.95839,
    (36, 100):  99.96237,
    (36, 101):  100.96873,
    (37, 71):   70.96532,
    (37, 72):   71.95908,
    (37, 73):   72.95053,
    (37, 74):   73.9442659,
    (37, 75):   74.9385732,
    (37, 76):   75.935073,
    (37, 77):   76.9304016,
    (37, 78):   77.9281419,
    (37, 79):   78.9239899,
    (37, 80):   79.9225164,
    (37, 81):   80.9189939,
    (37, 82):   81.918209,
    (37, 83):   82.9151142,
    (37, 84):   83.9143752,
    (37, 85):   84.9117897379,
    (37, 86):   85.91116743,
    (37, 87):   86.909180531,
    (37, 88):   87.91131559,
    (37, 89):   88.9122783,
    (37, 90):   89.9147985,
    (37, 91):   90.9165372,
    (37, 92):   91.9197284,
    (37, 93):   92.9220393,
    (37, 94):   93.9263948,
    (37, 95):   94.92926,
    (37, 96):   95.9341334,
    (37, 97):   96.9371771,
    (37, 98):   97.9416869,
    (37, 99):   98.94503,
    (37, 100):  99.95003,
    (37, 101):  100.95404,
    (37, 102):  101.95952,
    (37, 103):  102.96392,
    (38, 73):   72.9657,
    (38, 74):   73.95617,
    (38, 75):   74.94995,
    (38, 76):   75.941763,
    (38, 77):   76.9379455,
    (38, 78):   77.93218,
    (38, 79):   78.9297077,
    (38, 80):   79.9245175,
    (38, 81):   80.9232114,
    (38, 82):   81.9183999,
    (38, 83):   82.9175544,
    (38, 84):   83.9134191,
    (38, 85):   84.912932,
    (38, 86):   85.9092606,
    (38, 87):   86.9088775,
    (38, 88):   87.9056125,
    (38, 89):   88.9074511,
    (38, 90):   89.90773,
    (38, 91):   90.9101954,
    (38, 92):   91.9110382,
    (38, 93):   92.9140242,
    (38, 94):   93.9153556,
    (38, 95):   94.9193529,
    (38, 96):   95.9217066,
    (38, 97):   96.926374,
    (38, 98):   97.9286888,
    (38, 99):   98.9328907,
    (38, 100):  99.93577,
    (38, 101):  100.940352,
    (38, 102):  101.943791,
    (38, 103):  102.94909,
    (38, 104):  103.95265,
    (38, 105):  104.95855,
    (38, 106):  105.96265,
    (38, 107):  106.96897,
    (39, 76):   75.95856,
    (39, 77):   76.949781,
    (39, 78):   77.94361,
    (39, 79):   78.93735,
    (39, 80):   79.9343561,
    (39, 81):   80.9294556,
    (39, 82):   81.9269314,
    (39, 83):   82.922485,
    (39, 84):   83.9206721,
    (39, 85):   84.916433,
    (39, 86):   85.914886,
    (39, 87):   86.9108761,
    (39, 88):   87.9095016,
    (39, 89):   88.9058403,
    (39, 90):   89.9071439,
    (39, 91):   90.9072974,
    (39, 92):   91.9089451,
    (39, 93):   92.909578,
    (39, 94):   93.9115906,
    (39, 95):   94.9128161,
    (39, 96):   95.9158968,
    (39, 97):   96.9182741,
    (39, 98):   97.9223821,
    (39, 99):   98.924148,
    (39, 100):  99.927715,
    (39, 101):  100.9301477,
    (39, 102):  101.9343277,
    (39, 103):  102.937243,
    (39, 104):  103.94196,
    (39, 105):  104.94544,
    (39, 106):  105.95056,
    (39, 107):  106.95452,
    (39, 108):  107.95996,
    (39, 109):  108.96436,
    (40, 78):   77.95566,
    (40, 79):   78.94948,
    (40, 80):   79.9404,
    (40, 81):   80.93731,
    (40, 82):   81.93135,
    (40, 83):   82.9292421,
    (40, 84):   83.9233269,
    (40, 85):   84.9214444,
    (40, 86):   85.9162972,
    (40, 87):   86.914818,
    (40, 88):   87.9102213,
    (40, 89):   88.9088814,
    (40, 90):   89.9046977,
    (40, 91):   90.9056396,
    (40, 92):   91.9050347,
    (40, 93):   92.9064699,
    (40, 94):   93.9063108,
    (40, 95):   94.9080385,
    (40, 96):   95.9082714,
    (40, 97):   96.9109512,
    (40, 98):   97.9127289,
    (40, 99):   98.916667,
    (40, 100):  99.9180006,
    (40, 101):  100.921448,
    (40, 102):  101.9231409,
    (40, 103):  102.927191,
    (40, 104):  103.929436,
    (40, 105):  104.934008,
    (40, 106):  105.93676,
    (40, 107):  106.94174,
    (40, 108):  107.94487,
    (40, 109):  108.95041,
    (40, 110):  109.95396,
    (40, 111):  110.95968,
    (40, 112):  111.9637,
    (41, 81):   80.9496,
    (41, 82):   81.94396,
    (41, 83):   82.93729,
    (41, 84):   83.93449,
    (41, 85):   84.9288458,
    (41, 86):   85.9257828,
    (41, 87):   86.9206937,
    (41, 88):   87.918222,
    (41, 89):   88.913445,
    (41, 90):   89.9112584,
    (41, 91):   90.9069897,
    (41, 92):   91.9071881,
    (41, 93):   92.906373,
    (41, 94):   93.9072788,
    (41, 95):   94.9068324,
    (41, 96):   95.9080973,
    (41, 97):   96.9080959,
    (41, 98):   97.9103265,
    (41, 99):   98.911613,
    (41, 100):  99.9143276,
    (41, 101):  100.9153103,
    (41, 102):  101.9180772,
    (41, 103):  102.9194572,
    (41, 104):  103.9228925,
    (41, 105):  104.9249465,
    (41, 106):  105.9289317,
    (41, 107):  106.9315937,
    (41, 108):  107.9360748,
    (41, 109):  108.93922,
    (41, 110):  109.94403,
    (41, 111):  110.94753,
    (41, 112):  111.95247,
    (41, 113):  112.95651,
    (41, 114):  113.96201,
    (41, 115):  114.96634,
    (42, 83):   82.94988,
    (42, 84):   83.94149,
    (42, 85):   84.938261,
    (42, 86):   85.9311748,
    (42, 87):   86.9281962,
    (42, 88):   87.9219678,
    (42, 89):   88.9194682,
    (42, 90):   89.9139309,
    (42, 91):   90.9117453,
    (42, 92):   91.90680796,
    (42, 93):   92.90680958,
    (42, 94):   93.9050849,
    (42, 95):   94.90583877,
    (42, 96):   95.90467612,
    (42, 97):   96.90601812,
    (42, 98):   97.90540482,
    (42, 99):   98.90770851,
    (42, 100):  99.9074718,
    (42, 101):  100.9103414,
    (42, 102):  101.9102834,
    (42, 103):  102.913079,
    (42, 104):  103.9137344,
    (42, 105):  104.916969,
    (42, 106):  105.918259,
    (42, 107):  106.922106,
    (42, 108):  107.924033,
    (42, 109):  108.928424,
    (42, 110):  109.930704,
    (42, 111):  110.935654,
    (42, 112):  111.93831,
    (42, 113):  112.94335,
    (42, 114):  113.94653,
    (42, 115):  114.95196,
    (42, 116):  115.95545,
    (42, 117):  116.96117,
    (43, 85):   84.95058,
    (43, 86):   85.94493,
    (43, 87):   86.9380672,
    (43, 88):   87.93378,
    (43, 89):   88.9276487,
    (43, 90):   89.9240739,
    (43, 91):   90.9184254,
    (43, 92):   91.9152698,
    (43, 93):   92.910246,
    (43, 94):   93.9096536,
    (43, 95):   94.9076536,
    (43, 96):   95.907868,
    (43, 97):   96.9063667,
    (43, 98):   97.9072124,
    (43, 99):   98.9062508,
    (43, 100):  99.9076539,
    (43, 101):  100.907309,
    (43, 102):  101.9092097,
    (43, 103):  102.909176,
    (43, 104):  103.911425,
    (43, 105):  104.911655,
    (43, 106):  105.914358,
    (43, 107):  106.9154606,
    (43, 108):  107.9184957,
    (43, 109):  108.920256,
    (43, 110):  109.923744,
    (43, 111):  110.925901,
    (43, 112):  111.9299458,
    (43, 113):  112.932569,
    (43, 114):  113.93691,
    (43, 115):  114.93998,
    (43, 116):  115.94476,
    (43, 117):  116.94806,
    (43, 118):  117.95299,
    (43, 119):  118.95666,
    (43, 120):  119.96187,
    (44, 87):   86.95069,
    (44, 88):   87.9416,
    (44, 89):   88.93762,
    (44, 90):   89.9303444,
    (44, 91):   90.9267419,
    (44, 92):   91.9202344,
    (44, 93):   92.9171044,
    (44, 94):   93.9113429,
    (44, 95):   94.910406,
    (44, 96):   95.90759025,
    (44, 97):   96.9075471,
    (44, 98):   97.9052868,
    (44, 99):   98.9059341,
    (44, 100):  99.9042143,
    (44, 101):  100.9055769,
    (44, 102):  101.9043441,
    (44, 103):  102.9063186,
    (44, 104):  103.9054275,
    (44, 105):  104.9077476,
    (44, 106):  105.9073291,
    (44, 107):  106.909972,
    (44, 108):  107.910188,
    (44, 109):  108.913326,
    (44, 110):  109.9140407,
    (44, 111):  110.91757,
    (44, 112):  111.918809,
    (44, 113):  112.922844,
    (44, 114):  113.9246136,
    (44, 115):  114.92882,
    (44, 116):  115.9312192,
    (44, 117):  116.9361,
    (44, 118):  117.93853,
    (44, 119):  118.94357,
    (44, 120):  119.94631,
    (44, 121):  120.95164,
    (44, 122):  121.95447,
    (44, 123):  122.95989,
    (44, 124):  123.96305,
    (45, 89):   88.95058,
    (45, 90):   89.94422,
    (45, 91):   90.93688,
    (45, 92):   91.9323677,
    (45, 93):   92.9259128,
    (45, 94):   93.9217305,
    (45, 95):   94.9158979,
    (45, 96):   95.914453,
    (45, 97):   96.911329,
    (45, 98):   97.910708,
    (45, 99):   98.9081282,
    (45, 100):  99.908117,
    (45, 101):  100.9061606,
    (45, 102):  101.9068374,
    (45, 103):  102.905498,
    (45, 104):  103.9066492,
    (45, 105):  104.9056885,
    (45, 106):  105.9072868,
    (45, 107):  106.906748,
    (45, 108):  107.908714,
    (45, 109):  108.9087488,
    (45, 110):  109.911079,
    (45, 111):  110.9116423,
    (45, 112):  111.914403,
    (45, 113):  112.9154393,
    (45, 114):  113.918718,
    (45, 115):  114.9203116,
    (45, 116):  115.924059,
    (45, 117):  116.9260354,
    (45, 118):  117.93034,
    (45, 119):  118.932557,
    (45, 120):  119.93686,
    (45, 121):  120.93942,
    (45, 122):  121.94399,
    (45, 123):  122.94685,
    (45, 124):  123.95151,
    (45, 125):  124.95469,
    (45, 126):  125.95946,
    (46, 91):   90.95032,
    (46, 92):   91.94088,
    (46, 93):   92.93651,
    (46, 94):   93.9290376,
    (46, 95):   94.9248898,
    (46, 96):   95.9182151,
    (46, 97):   96.916472,
    (46, 98):   97.9126983,
    (46, 99):   98.9117748,
    (46, 100):  99.908505,
    (46, 101):  100.9082864,
    (46, 102):  101.9056022,
    (46, 103):  102.9060809,
    (46, 104):  103.9040305,
    (46, 105):  104.9050796,
    (46, 106):  105.9034804,
    (46, 107):  106.9051282,
    (46, 108):  107.9038916,
    (46, 109):  108.9059504,
    (46, 110):  109.9051722,
    (46, 111):  110.90768968,
    (46, 112):  111.9073297,
    (46, 113):  112.910261,
    (46, 114):  113.9103686,
    (46, 115):  114.913659,
    (46, 116):  115.914297,
    (46, 117):  116.9179547,
    (46, 118):  117.9190667,
    (46, 119):  118.9233402,
    (46, 120):  119.9245511,
    (46, 121):  120.9289503,
    (46, 122):  121.930632,
    (46, 123):  122.93514,
    (46, 124):  123.93714,
    (46, 125):  124.94179,
    (46, 126):  125.94416,
    (46, 127):  126.94907,
    (46, 128):  127.95183,
    (47, 93):   92.95033,
    (47, 94):   93.94373,
    (47, 95):   94.93602,
    (47, 96):   95.930744,
    (47, 97):   96.92397,
    (47, 98):   97.92156,
    (47, 99):   98.9176458,
    (47, 100):  99.9161154,
    (47, 101):  100.912684,
    (47, 102):  101.9117047,
    (47, 103):  102.9089631,
    (47, 104):  103.9086239,
    (47, 105):  104.9065256,
    (47, 106):  105.9066636,
    (47, 107):  106.9050916,
    (47, 108):  107.9059503,
    (47, 109):  108.9047553,
    (47, 110):  109.9061102,
    (47, 111):  110.9052959,
    (47, 112):  111.9070486,
    (47, 113):  112.906573,
    (47, 114):  113.908823,
    (47, 115):  114.908767,
    (47, 116):  115.9113868,
    (47, 117):  116.911774,
    (47, 118):  117.9145955,
    (47, 119):  118.91557,
    (47, 120):  119.9187848,
    (47, 121):  120.920125,
    (47, 122):  121.923664,
    (47, 123):  122.925337,
    (47, 124):  123.92893,
    (47, 125):  124.93105,
    (47, 126):  125.93475,
    (47, 127):  126.93711,
    (47, 128):  127.94106,
    (47, 129):  128.94395,
    (47, 130):  129.9507,
    (48, 95):   94.94994,
    (48, 96):   95.94034,
    (48, 97):   96.9351,
    (48, 98):   97.927389,
    (48, 99):   98.9249258,
    (48, 100):  99.9203488,
    (48, 101):  100.9185862,
    (48, 102):  101.914482,
    (48, 103):  102.9134165,
    (48, 104):  103.9098564,
    (48, 105):  104.9094639,
    (48, 106):  105.9064599,
    (48, 107):  106.9066121,
    (48, 108):  107.9041834,
    (48, 109):  108.9049867,
    (48, 110):  109.90300661,
    (48, 111):  110.90418287,
    (48, 112):  111.90276287,
    (48, 113):  112.90440813,
    (48, 114):  113.90336509,
    (48, 115):  114.90543751,
    (48, 116):  115.90476315,
    (48, 117):  116.907226,
    (48, 118):  117.906922,
    (48, 119):  118.909847,
    (48, 120):  119.9098681,
    (48, 121):  120.9129637,
    (48, 122):  121.9134591,
    (48, 123):  122.9168925,
    (48, 124):  123.9176574,
    (48, 125):  124.9212576,
    (48, 126):  125.9224291,
    (48, 127):  126.926472,
    (48, 128):  127.9278129,
    (48, 129):  128.93182,
    (48, 130):  129.93394,
    (48, 131):  130.9406,
    (48, 132):  131.94604,
    (48, 133):  132.95285,
    (49, 97):   96.94934,
    (49, 98):   97.94214,
    (49, 99):   98.93411,
    (49, 100):  99.93096,
    (49, 101):  100.92634,
    (49, 102):  101.9241071,
    (49, 103):  102.9198819,
    (49, 104):  103.9182145,
    (49, 105):  104.914502,
    (49, 106):  105.913464,
    (49, 107):  106.91029,
    (49, 108):  107.9096935,
    (49, 109):  108.9071514,
    (49, 110):  109.90717,
    (49, 111):  110.9051085,
    (49, 112):  111.9055377,
    (49, 113):  112.90406184,
    (49, 114):  113.90491791,
    (49, 115):  114.903878776,
    (49, 116):  115.90525999,
    (49, 117):  116.9045157,
    (49, 118):  117.9063566,
    (49, 119):  118.9058507,
    (49, 120):  119.907967,
    (49, 121):  120.907851,
    (49, 122):  121.910281,
    (49, 123):  122.910434,
    (49, 124):  123.913182,
    (49, 125):  124.913605,
    (49, 126):  125.916507,
    (49, 127):  126.917446,
    (49, 128):  127.9204,
    (49, 129):  128.9218053,
    (49, 130):  129.924977,
    (49, 131):  130.9269715,
    (49, 132):  131.933001,
    (49, 133):  132.93831,
    (49, 134):  133.94454,
    (49, 135):  134.95005,
    (50, 99):   98.94853,
    (50, 100):  99.9385,
    (50, 101):  100.93526,
    (50, 102):  101.93029,
    (50, 103):  102.928105,
    (50, 104):  103.9231052,
    (50, 105):  104.9212684,
    (50, 106):  105.9169574,
    (50, 107):  106.9157137,
    (50, 108):  107.9118943,
    (50, 109):  108.9112921,
    (50, 110):  109.907845,
    (50, 111):  110.9077401,
    (50, 112):  111.90482387,
    (50, 113):  112.9051757,
    (50, 114):  113.9027827,
    (50, 115):  114.903344699,
    (50, 116):  115.9017428,
    (50, 117):  116.90295398,
    (50, 118):  117.90160657,
    (50, 119):  118.90331117,
    (50, 120):  119.90220163,
    (50, 121):  120.9042426,
    (50, 122):  121.9034438,
    (50, 123):  122.9057252,
    (50, 124):  123.9052766,
    (50, 125):  124.9077864,
    (50, 126):  125.907659,
    (50, 127):  126.91039,
    (50, 128):  127.910507,
    (50, 129):  128.913465,
    (50, 130):  129.9139738,
    (50, 131):  130.917045,
    (50, 132):  131.9178267,
    (50, 133):  132.9239134,
    (50, 134):  133.9286821,
    (50, 135):  134.9349086,
    (50, 136):  135.93999,
    (50, 137):  136.94655,
    (50, 138):  137.95184,
    (51, 103):  102.93969,
    (51, 104):  103.93648,
    (51, 105):  104.931276,
    (51, 106):  105.928638,
    (51, 107):  106.9241506,
    (51, 108):  107.9222267,
    (51, 109):  108.9181411,
    (51, 110):  109.9168543,
    (51, 111):  110.9132182,
    (51, 112):  111.9124,
    (51, 113):  112.909375,
    (51, 114):  113.90929,
    (51, 115):  114.906598,
    (51, 116):  115.9067931,
    (51, 117):  116.9048415,
    (51, 118):  117.9055321,
    (51, 119):  118.9039455,
    (51, 120):  119.9050794,
    (51, 121):  120.903812,
    (51, 122):  121.9051699,
    (51, 123):  122.9042132,
    (51, 124):  123.905935,
    (51, 125):  124.905253,
    (51, 126):  125.907253,
    (51, 127):  126.9069243,
    (51, 128):  127.909146,
    (51, 129):  128.909147,
    (51, 130):  129.911662,
    (51, 131):  130.9119888,
    (51, 132):  131.9145077,
    (51, 133):  132.9152732,
    (51, 134):  133.9205357,
    (51, 135):  134.9251851,
    (51, 136):  135.9307459,
    (51, 137):  136.93555,
    (51, 138):  137.94145,
    (51, 139):  138.94655,
    (51, 140):  139.95283,
    (52, 105):  104.9433,
    (52, 106):  105.9375,
    (52, 107):  106.935012,
    (52, 108):  107.9293805,
    (52, 109):  108.9273045,
    (52, 110):  109.9224581,
    (52, 111):  110.9210006,
    (52, 112):  111.9167279,
    (52, 113):  112.915891,
    (52, 114):  113.912089,
    (52, 115):  114.911902,
    (52, 116):  115.90846,
    (52, 117):  116.908646,
    (52, 118):  117.905854,
    (52, 119):  118.9064071,
    (52, 120):  119.9040593,
    (52, 121):  120.904944,
    (52, 122):  121.9030435,
    (52, 123):  122.9042698,
    (52, 124):  123.9028171,
    (52, 125):  124.9044299,
    (52, 126):  125.9033109,
    (52, 127):  126.9052257,
    (52, 128):  127.90446128,
    (52, 129):  128.90659646,
    (52, 130):  129.906222748,
    (52, 131):  130.908522213,
    (52, 132):  131.9085467,
    (52, 133):  132.9109688,
    (52, 134):  133.911394,
    (52, 135):  134.9165557,
    (52, 136):  135.9201006,
    (52, 137):  136.9255989,
    (52, 138):  137.9294722,
    (52, 139):  138.9353672,
    (52, 140):  139.939499,
    (52, 141):  140.9458,
    (52, 142):  141.95022,
    (52, 143):  142.95676,
    (53, 107):  106.94678,
    (53, 108):  107.94348,
    (53, 109):  108.9380853,
    (53, 110):  109.935089,
    (53, 111):  110.9302692,
    (53, 112):  111.928005,
    (53, 113):  112.9236501,
    (53, 114):  113.92185,
    (53, 115):  114.918048,
    (53, 116):  115.91681,
    (53, 117):  116.913648,
    (53, 118):  117.913074,
    (53, 119):  118.910074,
    (53, 120):  119.910087,
    (53, 121):  120.9074051,
    (53, 122):  121.9075888,
    (53, 123):  122.9055885,
    (53, 124):  123.906209,
    (53, 125):  124.9046294,
    (53, 126):  125.9056233,
    (53, 127):  126.9044719,
    (53, 128):  127.9058086,
    (53, 129):  128.9049837,
    (53, 130):  129.9066702,
    (53, 131):  130.9061263,
    (53, 132):  131.9079935,
    (53, 133):  132.907797,
    (53, 134):  133.9097588,
    (53, 135):  134.9100488,
    (53, 136):  135.914604,
    (53, 137):  136.9180282,
    (53, 138):  137.9227264,
    (53, 139):  138.926506,
    (53, 140):  139.93173,
    (53, 141):  140.93569,
    (53, 142):  141.9412,
    (53, 143):  142.94565,
    (53, 144):  143.95139,
    (53, 145):  144.95605,
    (54, 109):  108.95043,
    (54, 110):  109.94426,
    (54, 111):  110.941607,
    (54, 112):  111.935559,
    (54, 113):  112.9332217,
    (54, 114):  113.92798,
    (54, 115):  114.926294,
    (54, 116):  115.921581,
    (54, 117):  116.920359,
    (54, 118):  117.916179,
    (54, 119):  118.915411,
    (54, 120):  119.911784,
    (54, 121):  120.911453,
    (54, 122):  121.908368,
    (54, 123):  122.908482,
    (54, 124):  123.905892,
    (54, 125):  124.9063944,
    (54, 126):  125.9042983,
    (54, 127):  126.9051829,
    (54, 128):  127.903531,
    (54, 129):  128.9047808611,
    (54, 130):  129.903509349,
    (54, 131):  130.90508406,
    (54, 132):  131.9041550856,
    (54, 133):  132.9059108,
    (54, 134):  133.90539466,
    (54, 135):  134.9072278,
    (54, 136):  135.907214484,
    (54, 137):  136.91155778,
    (54, 138):  137.9141463,
    (54, 139):  138.9187922,
    (54, 140):  139.9216458,
    (54, 141):  140.9267872,
    (54, 142):  141.9299731,
    (54, 143):  142.9353696,
    (54, 144):  143.9389451,
    (54, 145):  144.94472,
    (54, 146):  145.948518,
    (54, 147):  146.95426,
    (54, 148):  147.95813,
    (55, 112):  111.950309,
    (55, 113):  112.9444291,
    (55, 114):  113.941296,
    (55, 115):  114.93591,
    (55, 116):  115.93337,
    (55, 117):  116.928617,
    (55, 118):  117.92656,
    (55, 119):  118.922377,
    (55, 120):  119.920677,
    (55, 121):  120.917227,
    (55, 122):  121.916108,
    (55, 123):  122.912996,
    (55, 124):  123.9122578,
    (55, 125):  124.909728,
    (55, 126):  125.909446,
    (55, 127):  126.9074174,
    (55, 128):  127.9077487,
    (55, 129):  128.9060657,
    (55, 130):  129.9067093,
    (55, 131):  130.9054649,
    (55, 132):  131.9064339,
    (55, 133):  132.905451961,
    (55, 134):  133.906718503,
    (55, 135):  134.905977,
    (55, 136):  135.9073114,
    (55, 137):  136.90708923,
    (55, 138):  137.9110171,
    (55, 139):  138.9133638,
    (55, 140):  139.9172831,
    (55, 141):  140.9200455,
    (55, 142):  141.924296,
    (55, 143):  142.927349,
    (55, 144):  143.932076,
    (55, 145):  144.935527,
    (55, 146):  145.940344,
    (55, 147):  146.944156,
    (55, 148):  147.94923,
    (55, 149):  148.95302,
    (55, 150):  149.95833,
    (55, 151):  150.96258,
    (56, 114):  113.95066,
    (56, 115):  114.94737,
    (56, 116):  115.94128,
    (56, 117):  116.93814,
    (56, 118):  117.93306,
    (56, 119):  118.93066,
    (56, 120):  119.92605,
    (56, 121):  120.92405,
    (56, 122):  121.919904,
    (56, 123):  122.918781,
    (56, 124):  123.915094,
    (56, 125):  124.914472,
    (56, 126):  125.91125,
    (56, 127):  126.911091,
    (56, 128):  127.908342,
    (56, 129):  128.908681,
    (56, 130):  129.9063207,
    (56, 131):  130.906941,
    (56, 132):  131.9050611,
    (56, 133):  132.9060074,
    (56, 134):  133.90450818,
    (56, 135):  134.90568838,
    (56, 136):  135.90457573,
    (56, 137):  136.90582714,
    (56, 138):  137.905247,
    (56, 139):  138.9088411,
    (56, 140):  139.9106057,
    (56, 141):  140.9144033,
    (56, 142):  141.9164324,
    (56, 143):  142.9206253,
    (56, 144):  143.9229549,
    (56, 145):  144.9275184,
    (56, 146):  145.930284,
    (56, 147):  146.935304,
    (56, 148):  147.938171,
    (56, 149):  148.94308,
    (56, 150):  149.94605,
    (56, 151):  150.95127,
    (56, 152):  151.95481,
    (56, 153):  152.96036,
    (57, 116):  115.9563,
    (57, 117):  116.94999,
    (57, 118):  117.94673,
    (57, 119):  118.94099,
    (57, 120):  119.93807,
    (57, 121):  120.93315,
    (57, 122):  121.93071,
    (57, 123):  122.9263,
    (57, 124):  123.924574,
    (57, 125):  124.920816,
    (57, 126):  125.919513,
    (57, 127):  126.916375,
    (57, 128):  127.915592,
    (57, 129):  128.912694,
    (57, 130):  129.912369,
    (57, 131):  130.91007,
    (57, 132):  131.910119,
    (57, 133):  132.908218,
    (57, 134):  133.908514,
    (57, 135):  134.906984,
    (57, 136):  135.907635,
    (57, 137):  136.9064504,
    (57, 138):  137.9071149,
    (57, 139):  138.9063563,
    (57, 140):  139.9094806,
    (57, 141):  140.910966,
    (57, 142):  141.9140909,
    (57, 143):  142.9160795,
    (57, 144):  143.919646,
    (57, 145):  144.921808,
    (57, 146):  145.925875,
    (57, 147):  146.928418,
    (57, 148):  147.932679,
    (57, 149):  148.93535,
    (57, 150):  149.93947,
    (57, 151):  150.94232,
    (57, 152):  151.94682,
    (57, 153):  152.95036,
    (57, 154):  153.95517,
    (57, 155):  154.95901,
    (58, 119):  118.95271,
    (58, 120):  119.94654,
    (58, 121):  120.94335,
    (58, 122):  121.93787,
    (58, 123):  122.93528,
    (58, 124):  123.93031,
    (58, 125):  124.92844,
    (58, 126):  125.923971,
    (58, 127):  126.922727,
    (58, 128):  127.918911,
    (58, 129):  128.918102,
    (58, 130):  129.914736,
    (58, 131):  130.914429,
    (58, 132):  131.911464,
    (58, 133):  132.91152,
    (58, 134):  133.908928,
    (58, 135):  134.909161,
    (58, 136):  135.90712921,
    (58, 137):  136.90776236,
    (58, 138):  137.905991,
    (58, 139):  138.9066551,
    (58, 140):  139.9054431,
    (58, 141):  140.9082807,
    (58, 142):  141.9092504,
    (58, 143):  142.9123921,
    (58, 144):  143.9136529,
    (58, 145):  144.917265,
    (58, 146):  145.918802,
    (58, 147):  146.9226899,
    (58, 148):  147.924424,
    (58, 149):  148.928427,
    (58, 150):  149.930384,
    (58, 151):  150.934272,
    (58, 152):  151.9366,
    (58, 153):  152.94093,
    (58, 154):  153.9438,
    (58, 155):  154.94855,
    (58, 156):  155.95183,
    (58, 157):  156.95705,
    (59, 121):  120.95532,
    (59, 122):  121.95175,
    (59, 123):  122.94596,
    (59, 124):  123.94294,
    (59, 125):  124.9377,
    (59, 126):  125.93524,
    (59, 127):  126.93071,
    (59, 128):  127.928791,
    (59, 129):  128.925095,
    (59, 130):  129.92359,
    (59, 131):  130.920235,
    (59, 132):  131.919255,
    (59, 133):  132.916331,
    (59, 134):  133.915697,
    (59, 135):  134.913112,
    (59, 136):  135.912677,
    (59, 137):  136.9106792,
    (59, 138):  137.910754,
    (59, 139):  138.9089408,
    (59, 140):  139.9090803,
    (59, 141):  140.9076576,
    (59, 142):  141.9100496,
    (59, 143):  142.9108228,
    (59, 144):  143.9133109,
    (59, 145):  144.9145182,
    (59, 146):  145.91768,
    (59, 147):  146.919008,
    (59, 148):  147.92213,
    (59, 149):  148.923736,
    (59, 150):  149.9266765,
    (59, 151):  150.928309,
    (59, 152):  151.931553,
    (59, 153):  152.933904,
    (59, 154):  153.93753,
    (59, 155):  154.940509,
    (59, 156):  155.94464,
    (59, 157):  156.94789,
    (59, 158):  157.95241,
    (59, 159):  158.95589,
    (60, 124):  123.9522,
    (60, 125):  124.9489,
    (60, 126):  125.94311,
    (60, 127):  126.94038,
    (60, 128):  127.93525,
    (60, 129):  128.9331,
    (60, 130):  129.928506,
    (60, 131):  130.927248,
    (60, 132):  131.923321,
    (60, 133):  132.922348,
    (60, 134):  133.91879,
    (60, 135):  134.918181,
    (60, 136):  135.914976,
    (60, 137):  136.914562,
    (60, 138):  137.91195,
    (60, 139):  138.911954,
    (60, 140):  139.90955,
    (60, 141):  140.9096147,
    (60, 142):  141.907729,
    (60, 143):  142.90982,
    (60, 144):  143.910093,
    (60, 145):  144.9125793,
    (60, 146):  145.9131226,
    (60, 147):  146.9161061,
    (60, 148):  147.9168993,
    (60, 149):  148.9201548,
    (60, 150):  149.9209022,
    (60, 151):  150.9238403,
    (60, 152):  151.924692,
    (60, 153):  152.927718,
    (60, 154):  153.92948,
    (60, 155):  154.9331357,
    (60, 156):  155.93508,
    (60, 157):  156.939386,
    (60, 158):  157.94197,
    (60, 159):  158.94653,
    (60, 160):  159.9494,
    (60, 161):  160.95428,
    (61, 126):  125.95792,
    (61, 127):  126.95192,
    (61, 128):  127.9487,
    (61, 129):  128.94323,
    (61, 130):  129.94053,
    (61, 131):  130.93567,
    (61, 132):  131.93384,
    (61, 133):  132.929782,
    (61, 134):  133.928353,
    (61, 135):  134.924823,
    (61, 136):  135.923585,
    (61, 137):  136.92048,
    (61, 138):  137.919548,
    (61, 139):  138.9168,
    (61, 140):  139.91604,
    (61, 141):  140.913555,
    (61, 142):  141.91289,
    (61, 143):  142.9109383,
    (61, 144):  143.9125964,
    (61, 145):  144.9127559,
    (61, 146):  145.9147024,
    (61, 147):  146.915145,
    (61, 148):  147.9174819,
    (61, 149):  148.9183423,
    (61, 150):  149.920991,
    (61, 151):  150.9212175,
    (61, 152):  151.923506,
    (61, 153):  152.9241567,
    (61, 154):  153.926472,
    (61, 155):  154.928137,
    (61, 156):  155.9311175,
    (61, 157):  156.9331214,
    (61, 158):  157.936565,
    (61, 159):  158.939287,
    (61, 160):  159.9431,
    (61, 161):  160.94607,
    (61, 162):  161.95022,
    (61, 163):  162.95357,
    (62, 128):  127.95842,
    (62, 129):  128.95476,
    (62, 130):  129.949,
    (62, 131):  130.94618,
    (62, 132):  131.94087,
    (62, 133):  132.93856,
    (62, 134):  133.93411,
    (62, 135):  134.93252,
    (62, 136):  135.928276,
    (62, 137):  136.926971,
    (62, 138):  137.923244,
    (62, 139):  138.922297,
    (62, 140):  139.918995,
    (62, 141):  140.9184816,
    (62, 142):  141.9152044,
    (62, 143):  142.9146353,
    (62, 144):  143.9120065,
    (62, 145):  144.9134173,
    (62, 146):  145.913047,
    (62, 147):  146.9149044,
    (62, 148):  147.9148292,
    (62, 149):  148.9171921,
    (62, 150):  149.9172829,
    (62, 151):  150.9199398,
    (62, 152):  151.9197397,
    (62, 153):  152.9221047,
    (62, 154):  153.9222169,
    (62, 155):  154.9246477,
    (62, 156):  155.925536,
    (62, 157):  156.9284187,
    (62, 158):  157.929951,
    (62, 159):  158.9332172,
    (62, 160):  159.9353353,
    (62, 161):  160.9391602,
    (62, 162):  161.94146,
    (62, 163):  162.94555,
    (62, 164):  163.94836,
    (62, 165):  164.95297,
    (63, 130):  129.96369,
    (63, 131):  130.95784,
    (63, 132):  131.95467,
    (63, 133):  132.94929,
    (63, 134):  133.9464,
    (63, 135):  134.94187,
    (63, 136):  135.93962,
    (63, 137):  136.93546,
    (63, 138):  137.933709,
    (63, 139):  138.929792,
    (63, 140):  139.928088,
    (63, 141):  140.924932,
    (63, 142):  141.923442,
    (63, 143):  142.920299,
    (63, 144):  143.91882,
    (63, 145):  144.9162726,
    (63, 146):  145.917211,
    (63, 147):  146.9167527,
    (63, 148):  147.918089,
    (63, 149):  148.9179378,
    (63, 150):  149.9197077,
    (63, 151):  150.9198578,
    (63, 152):  151.9217522,
    (63, 153):  152.921238,
    (63, 154):  153.922987,
    (63, 155):  154.9229011,
    (63, 156):  155.9247605,
    (63, 157):  156.9254334,
    (63, 158):  157.927799,
    (63, 159):  158.9291001,
    (63, 160):  159.931851,
    (63, 161):  160.933664,
    (63, 162):  161.936989,
    (63, 163):  162.939196,
    (63, 164):  163.94274,
    (63, 165):  164.94559,
    (63, 166):  165.94962,
    (63, 167):  166.95289,
    (64, 133):  132.96133,
    (64, 134):  133.95566,
    (64, 135):  134.95245,
    (64, 136):  135.9473,
    (64, 137):  136.94502,
    (64, 138):  137.94025,
    (64, 139):  138.93813,
    (64, 140):  139.933674,
    (64, 141):  140.932126,
    (64, 142):  141.928116,
    (64, 143):  142.92675,
    (64, 144):  143.922963,
    (64, 145):  144.921713,
    (64, 146):  145.9183188,
    (64, 147):  146.9191014,
    (64, 148):  147.9181215,
    (64, 149):  148.9193481,
    (64, 150):  149.9186644,
    (64, 151):  150.920356,
    (64, 152):  151.9197995,
    (64, 153):  152.921758,
    (64, 154):  153.9208741,
    (64, 155):  154.9226305,
    (64, 156):  155.9221312,
    (64, 157):  156.9239686,
    (64, 158):  157.9241123,
    (64, 159):  158.926397,
    (64, 160):  159.9270624,
    (64, 161):  160.9296775,
    (64, 162):  161.930993,
    (64, 163):  162.9341769,
    (64, 164):  163.93583,
    (64, 165):  164.93936,
    (64, 166):  165.94146,
    (64, 167):  166.94545,
    (64, 168):  167.94808,
    (64, 169):  168.9526,
    (65, 135):  134.96476,
    (65, 136):  135.96129,
    (65, 137):  136.95602,
    (65, 138):  137.95312,
    (65, 139):  138.94833,
    (65, 140):  139.94581,
    (65, 141):  140.94145,
    (65, 142):  141.93928,
    (65, 143):  142.935137,
    (65, 144):  143.933045,
    (65, 145):  144.92882,
    (65, 146):  145.927253,
    (65, 147):  146.9240548,
    (65, 148):  147.924282,
    (65, 149):  148.9232535,
    (65, 150):  149.9236649,
    (65, 151):  150.9231096,
    (65, 152):  151.924083,
    (65, 153):  152.9234424,
    (65, 154):  153.924685,
    (65, 155):  154.923511,
    (65, 156):  155.9247552,
    (65, 157):  156.924033,
    (65, 158):  157.9254209,
    (65, 159):  158.9253547,
    (65, 160):  159.9271756,
    (65, 161):  160.9275778,
    (65, 162):  161.929495,
    (65, 163):  162.9306547,
    (65, 164):  163.93336,
    (65, 165):  164.93498,
    (65, 166):  165.93786,
    (65, 167):  166.93996,
    (65, 168):  167.9434,
    (65, 169):  168.94597,
    (65, 170):  169.94984,
    (65, 171):  170.95273,
    (66, 138):  137.9625,
    (66, 139):  138.95959,
    (66, 140):  139.95402,
    (66, 141):  140.95128,
    (66, 142):  141.94619,
    (66, 143):  142.943994,
    (66, 144):  143.9392695,
    (66, 145):  144.937474,
    (66, 146):  145.9328445,
    (66, 147):  146.9310827,
    (66, 148):  147.927157,
    (66, 149):  148.927322,
    (66, 150):  149.9255933,
    (66, 151):  150.9261916,
    (66, 152):  151.9247253,
    (66, 153):  152.9257724,
    (66, 154):  153.9244293,
    (66, 155):  154.925759,
    (66, 156):  155.9242847,
    (66, 157):  156.9254707,
    (66, 158):  157.9244159,
    (66, 159):  158.925747,
    (66, 160):  159.9252046,
    (66, 161):  160.9269405,
    (66, 162):  161.9268056,
    (66, 163):  162.9287383,
    (66, 164):  163.9291819,
    (66, 165):  164.9317105,
    (66, 166):  165.9328139,
    (66, 167):  166.935661,
    (66, 168):  167.93713,
    (66, 169):  168.94031,
    (66, 170):  169.94239,
    (66, 171):  170.94612,
    (66, 172):  171.94846,
    (66, 173):  172.95283,
    (67, 140):  139.96859,
    (67, 141):  140.96311,
    (67, 142):  141.96001,
    (67, 143):  142.95486,
    (67, 144):  143.9521097,
    (67, 145):  144.9472674,
    (67, 146):  145.9449935,
    (67, 147):  146.9401423,
    (67, 148):  147.937744,
    (67, 149):  148.933803,
    (67, 150):  149.933498,
    (67, 151):  150.9316983,
    (67, 152):  151.931724,
    (67, 153):  152.9302064,
    (67, 154):  153.9306068,
    (67, 155):  154.929104,
    (67, 156):  155.929706,
    (67, 157):  156.928254,
    (67, 158):  157.928946,
    (67, 159):  158.9277197,
    (67, 160):  159.928737,
    (67, 161):  160.9278615,
    (67, 162):  161.9291023,
    (67, 163):  162.928741,
    (67, 164):  163.9302403,
    (67, 165):  164.9303288,
    (67, 166):  165.9322909,
    (67, 167):  166.9331385,
    (67, 168):  167.935522,
    (67, 169):  168.936878,
    (67, 170):  169.939625,
    (67, 171):  170.94147,
    (67, 172):  171.94473,
    (67, 173):  172.94702,
    (67, 174):  173.95095,
    (67, 175):  174.95362,
    (68, 142):  141.9701,
    (68, 143):  142.96662,
    (68, 144):  143.9607,
    (68, 145):  144.95805,
    (68, 146):  145.9524184,
    (68, 147):  146.949964,
    (68, 148):  147.944735,
    (68, 149):  148.942306,
    (68, 150):  149.937916,
    (68, 151):  150.937449,
    (68, 152):  151.935057,
    (68, 153):  152.93508,
    (68, 154):  153.9327908,
    (68, 155):  154.9332159,
    (68, 156):  155.931067,
    (68, 157):  156.931949,
    (68, 158):  157.929893,
    (68, 159):  158.9306918,
    (68, 160):  159.929077,
    (68, 161):  160.9300046,
    (68, 162):  161.9287884,
    (68, 163):  162.9300408,
    (68, 164):  163.9292088,
    (68, 165):  164.9307345,
    (68, 166):  165.9302995,
    (68, 167):  166.9320546,
    (68, 168):  167.9323767,
    (68, 169):  168.9345968,
    (68, 170):  169.9354702,
    (68, 171):  170.9380357,
    (68, 172):  171.9393619,
    (68, 173):  172.9424,
    (68, 174):  173.94423,
    (68, 175):  174.94777,
    (68, 176):  175.94994,
    (68, 177):  176.95399,
    (69, 144):  143.97628,
    (69, 145):  144.97039,
    (69, 146):  145.96684,
    (69, 147):  146.9613799,
    (69, 148):  147.958384,
    (69, 149):  148.95289,
    (69, 150):  149.95009,
    (69, 151):  150.945488,
    (69, 152):  151.944422,
    (69, 153):  152.94204,
    (69, 154):  153.94157,
    (69, 155):  154.93921,
    (69, 156):  155.938992,
    (69, 157):  156.936944,
    (69, 158):  157.93698,
    (69, 159):  158.934975,
    (69, 160):  159.935263,
    (69, 161):  160.933549,
    (69, 162):  161.934002,
    (69, 163):  162.9326592,
    (69, 164):  163.933544,
    (69, 165):  164.9324431,
    (69, 166):  165.933561,
    (69, 167):  166.9328562,
    (69, 168):  167.9341774,
    (69, 169):  168.9342179,
    (69, 170):  169.935806,
    (69, 171):  170.9364339,
    (69, 172):  171.9384055,
    (69, 173):  172.9396084,
    (69, 174):  173.942173,
    (69, 175):  174.943841,
    (69, 176):  175.947,
    (69, 177):  176.94904,
    (69, 178):  177.95264,
    (69, 179):  178.95534,
    (70, 148):  147.96758,
    (70, 149):  148.96436,
    (70, 150):  149.95852,
    (70, 151):  150.9554,
    (70, 152):  151.95027,
    (70, 153):  152.94932,
    (70, 154):  153.946396,
    (70, 155):  154.945783,
    (70, 156):  155.942825,
    (70, 157):  156.942645,
    (70, 158):  157.9398705,
    (70, 159):  158.940055,
    (70, 160):  159.937557,
    (70, 161):  160.937907,
    (70, 162):  161.935774,
    (70, 163):  162.93634,
    (70, 164):  163.934495,
    (70, 165):  164.93527,
    (70, 166):  165.9338747,
    (70, 167):  166.934953,
    (70, 168):  167.9338896,
    (70, 169):  168.9351825,
    (70, 170):  169.9347664,
    (70, 171):  170.9363302,
    (70, 172):  171.9363859,
    (70, 173):  172.9382151,
    (70, 174):  173.9388664,
    (70, 175):  174.9412808,
    (70, 176):  175.9425764,
    (70, 177):  176.9452656,
    (70, 178):  177.946651,
    (70, 179):  178.95004,
    (70, 180):  179.95212,
    (70, 181):  180.95589,
    (71, 150):  149.97355,
    (71, 151):  150.96768,
    (71, 152):  151.96412,
    (71, 153):  152.95875,
    (71, 154):  153.95736,
    (71, 155):  154.954321,
    (71, 156):  155.953033,
    (71, 157):  156.950127,
    (71, 158):  157.949316,
    (71, 159):  158.946636,
    (71, 160):  159.946033,
    (71, 161):  160.943572,
    (71, 162):  161.943283,
    (71, 163):  162.941179,
    (71, 164):  163.941339,
    (71, 165):  164.939407,
    (71, 166):  165.939859,
    (71, 167):  166.93827,
    (71, 168):  167.938736,
    (71, 169):  168.9376441,
    (71, 170):  169.938478,
    (71, 171):  170.937917,
    (71, 172):  171.9390891,
    (71, 173):  172.938934,
    (71, 174):  173.9403409,
    (71, 175):  174.9407752,
    (71, 176):  175.9426897,
    (71, 177):  176.9437615,
    (71, 178):  177.945958,
    (71, 179):  178.9473309,
    (71, 180):  179.949888,
    (71, 181):  180.95191,
    (71, 182):  181.95504,
    (71, 183):  182.957363,
    (71, 184):  183.96091,
    (71, 185):  184.96362,
    (72, 153):  152.97069,
    (72, 154):  153.96486,
    (72, 155):  154.96311,
    (72, 156):  155.95935,
    (72, 157):  156.95824,
    (72, 158):  157.954801,
    (72, 159):  158.953996,
    (72, 160):  159.950691,
    (72, 161):  160.950278,
    (72, 162):  161.9472148,
    (72, 163):  162.947113,
    (72, 164):  163.944371,
    (72, 165):  164.944567,
    (72, 166):  165.94218,
    (72, 167):  166.9426,
    (72, 168):  167.940568,
    (72, 169):  168.941259,
    (72, 170):  169.939609,
    (72, 171):  170.940492,
    (72, 172):  171.93945,
    (72, 173):  172.940513,
    (72, 174):  173.9400461,
    (72, 175):  174.9415092,
    (72, 176):  175.9414076,
    (72, 177):  176.9432277,
    (72, 178):  177.9437058,
    (72, 179):  178.9458232,
    (72, 180):  179.946557,
    (72, 181):  180.9491083,
    (72, 182):  181.9505612,
    (72, 183):  182.95353,
    (72, 184):  183.955446,
    (72, 185):  184.958862,
    (72, 186):  185.960897,
    (72, 187):  186.96477,
    (72, 188):  187.96685,
    (72, 189):  188.97084,
    (73, 155):  154.97424,
    (73, 156):  155.97203,
    (73, 157):  156.96818,
    (73, 158):  157.96654,
    (73, 159):  158.963023,
    (73, 160):  159.961488,
    (73, 161):  160.958452,
    (73, 162):  161.957294,
    (73, 163):  162.954337,
    (73, 164):  163.953534,
    (73, 165):  164.950781,
    (73, 166):  165.950512,
    (73, 167):  166.948093,
    (73, 168):  167.948047,
    (73, 169):  168.946011,
    (73, 170):  169.946175,
    (73, 171):  170.944476,
    (73, 172):  171.944895,
    (73, 173):  172.94375,
    (73, 174):  173.944454,
    (73, 175):  174.943737,
    (73, 176):  175.944857,
    (73, 177):  176.9444795,
    (73, 178):  177.945678,
    (73, 179):  178.9459366,
    (73, 180):  179.9474648,
    (73, 181):  180.9479958,
    (73, 182):  181.9501519,
    (73, 183):  182.9513726,
    (73, 184):  183.954008,
    (73, 185):  184.955559,
    (73, 186):  185.958551,
    (73, 187):  186.960386,
    (73, 188):  187.963916,
    (73, 189):  188.96583,
    (73, 190):  189.96939,
    (73, 191):  190.97156,
    (73, 192):  191.97514,
    (74, 157):  156.97884,
    (74, 158):  157.97456,
    (74, 159):  158.97264,
    (74, 160):  159.96846,
    (74, 161):  160.9672,
    (74, 162):  161.963499,
    (74, 163):  162.962524,
    (74, 164):  163.958961,
    (74, 165):  164.958281,
    (74, 166):  165.955031,
    (74, 167):  166.954805,
    (74, 168):  167.951806,
    (74, 169):  168.951779,
    (74, 170):  169.949232,
    (74, 171):  170.949451,
    (74, 172):  171.947292,
    (74, 173):  172.947689,
    (74, 174):  173.946079,
    (74, 175):  174.946717,
    (74, 176):  175.945634,
    (74, 177):  176.946643,
    (74, 178):  177.945883,
    (74, 179):  178.947077,
    (74, 180):  179.9467108,
    (74, 181):  180.9481978,
    (74, 182):  181.94820394,
    (74, 183):  182.95022275,
    (74, 184):  183.95093092,
    (74, 185):  184.95341897,
    (74, 186):  185.9543628,
    (74, 187):  186.9571588,
    (74, 188):  187.9584862,
    (74, 189):  188.961763,
    (74, 190):  189.963091,
    (74, 191):  190.966531,
    (74, 192):  191.96817,
    (74, 193):  192.97178,
    (74, 194):  193.97367,
    (75, 159):  158.98418,
    (75, 160):  159.98182,
    (75, 161):  160.97757,
    (75, 162):  161.97584,
    (75, 163):  162.97208,
    (75, 164):  163.970453,
    (75, 165):  164.967103,
    (75, 166):  165.965761,
    (75, 167):  166.962595,
    (75, 168):  167.961573,
    (75, 169):  168.958766,
    (75, 170):  169.95822,
    (75, 171):  170.955716,
    (75, 172):  171.95542,
    (75, 173):  172.953243,
    (75, 174):  173.953115,
    (75, 175):  174.951381,
    (75, 176):  175.951623,
    (75, 177):  176.950328,
    (75, 178):  177.950989,
    (75, 179):  178.949989,
    (75, 180):  179.950792,
    (75, 181):  180.950058,
    (75, 182):  181.95121,
    (75, 183):  182.9508196,
    (75, 184):  183.9525228,
    (75, 185):  184.9529545,
    (75, 186):  185.9549856,
    (75, 187):  186.9557501,
    (75, 188):  187.9581115,
    (75, 189):  188.959226,
    (75, 190):  189.961744,
    (75, 191):  190.963122,
    (75, 192):  191.966088,
    (75, 193):  192.967541,
    (75, 194):  193.97076,
    (75, 195):  194.97254,
    (75, 196):  195.9758,
    (75, 197):  196.97799,
    (75, 198):  197.9816,
    (76, 161):  160.98903,
    (76, 162):  161.98443,
    (76, 163):  162.98241,
    (76, 164):  163.97802,
    (76, 165):  164.9766,
    (76, 166):  165.972692,
    (76, 167):  166.971549,
    (76, 168):  167.967808,
    (76, 169):  168.967018,
    (76, 170):  169.963578,
    (76, 171):  170.963174,
    (76, 172):  171.960017,
    (76, 173):  172.959808,
    (76, 174):  173.957064,
    (76, 175):  174.956945,
    (76, 176):  175.954806,
    (76, 177):  176.954966,
    (76, 178):  177.953254,
    (76, 179):  178.953817,
    (76, 180):  179.952375,
    (76, 181):  180.953247,
    (76, 182):  181.95211,
    (76, 183):  182.953125,
    (76, 184):  183.9524885,
    (76, 185):  184.9540417,
    (76, 186):  185.953835,
    (76, 187):  186.9557474,
    (76, 188):  187.9558352,
    (76, 189):  188.9581442,
    (76, 190):  189.9584437,
    (76, 191):  190.9609264,
    (76, 192):  191.961477,
    (76, 193):  192.9641479,
    (76, 194):  193.9651772,
    (76, 195):  194.968318,
    (76, 196):  195.969641,
    (76, 197):  196.97283,
    (76, 198):  197.97441,
    (76, 199):  198.97801,
    (76, 200):  199.97984,
    (76, 201):  200.98364,
    (76, 202):  201.98595,
    (77, 164):  163.99191,
    (77, 165):  164.9875,
    (77, 166):  165.98566,
    (77, 167):  166.981666,
    (77, 168):  167.979907,
    (77, 169):  168.976298,
    (77, 170):  169.974922,
    (77, 171):  170.97164,
    (77, 172):  171.970607,
    (77, 173):  172.967506,
    (77, 174):  173.966861,
    (77, 175):  174.96415,
    (77, 176):  175.96365,
    (77, 177):  176.961301,
    (77, 178):  177.961082,
    (77, 179):  178.95912,
    (77, 180):  179.959229,
    (77, 181):  180.957625,
    (77, 182):  181.958076,
    (77, 183):  182.95684,
    (77, 184):  183.957476,
    (77, 185):  184.956698,
    (77, 186):  185.957944,
    (77, 187):  186.957542,
    (77, 188):  187.958828,
    (77, 189):  188.958715,
    (77, 190):  189.9605412,
    (77, 191):  190.9605893,
    (77, 192):  191.9626002,
    (77, 193):  192.9629216,
    (77, 194):  193.9650735,
    (77, 195):  194.9659747,
    (77, 196):  195.968397,
    (77, 197):  196.969655,
    (77, 198):  197.97228,
    (77, 199):  198.973805,
    (77, 200):  199.9768,
    (77, 201):  200.97864,
    (77, 202):  201.98199,
    (77, 203):  202.98423,
    (77, 204):  203.9896,
    (78, 166):  165.99486,
    (78, 167):  166.99269,
    (78, 168):  167.98813,
    (78, 169):  168.98657,
    (78, 170):  169.982496,
    (78, 171):  170.981245,
    (78, 172):  171.977351,
    (78, 173):  172.976443,
    (78, 174):  173.97282,
    (78, 175):  174.97241,
    (78, 176):  175.968938,
    (78, 177):  176.96847,
    (78, 178):  177.96565,
    (78, 179):  178.965359,
    (78, 180):  179.963032,
    (78, 181):  180.963098,
    (78, 182):  181.961172,
    (78, 183):  182.961597,
    (78, 184):  183.959915,
    (78, 185):  184.960614,
    (78, 186):  185.959351,
    (78, 187):  186.960617,
    (78, 188):  187.9593889,
    (78, 189):  188.960831,
    (78, 190):  189.9599297,
    (78, 191):  190.9616729,
    (78, 192):  191.9610387,
    (78, 193):  192.9629824,
    (78, 194):  193.9626809,
    (78, 195):  194.9647917,
    (78, 196):  195.96495209,
    (78, 197):  196.96734069,
    (78, 198):  197.9678949,
    (78, 199):  198.9705952,
    (78, 200):  199.971443,
    (78, 201):  200.974513,
    (78, 202):  201.975639,
    (78, 203):  202.97893,
    (78, 204):  203.98076,
    (78, 205):  204.98608,
    (78, 206):  205.98966,
    (79, 169):  168.99808,
    (79, 170):  169.99597,
    (79, 171):  170.991876,
    (79, 172):  171.989942,
    (79, 173):  172.986241,
    (79, 174):  173.984717,
    (79, 175):  174.981304,
    (79, 176):  175.98025,
    (79, 177):  176.97687,
    (79, 178):  177.976032,
    (79, 179):  178.973174,
    (79, 180):  179.972523,
    (79, 181):  180.970079,
    (79, 182):  181.969618,
    (79, 183):  182.967591,
    (79, 184):  183.967452,
    (79, 185):  184.96579,
    (79, 186):  185.965953,
    (79, 187):  186.964543,
    (79, 188):  187.965349,
    (79, 189):  188.963948,
    (79, 190):  189.964698,
    (79, 191):  190.963702,
    (79, 192):  191.964814,
    (79, 193):  192.9641373,
    (79, 194):  193.9654178,
    (79, 195):  194.9650352,
    (79, 196):  195.9665699,
    (79, 197):  196.96656879,
    (79, 198):  197.96824242,
    (79, 199):  198.96876528,
    (79, 200):  199.970756,
    (79, 201):  200.9716575,
    (79, 202):  201.973856,
    (79, 203):  202.9751544,
    (79, 204):  203.97783,
    (79, 205):  204.97985,
    (79, 206):  205.98474,
    (79, 207):  206.9884,
    (79, 208):  207.99345,
    (79, 209):  208.99735,
    (79, 210):  210.0025,
    (80, 171):  171.00353,
    (80, 172):  171.99881,
    (80, 173):  172.99709,
    (80, 174):  173.992865,
    (80, 175):  174.991441,
    (80, 176):  175.987361,
    (80, 177):  176.986277,
    (80, 178):  177.982484,
    (80, 179):  178.981831,
    (80, 180):  179.97826,
    (80, 181):  180.977819,
    (80, 182):  181.974689,
    (80, 183):  182.9744448,
    (80, 184):  183.971714,
    (80, 185):  184.971899,
    (80, 186):  185.969362,
    (80, 187):  186.969814,
    (80, 188):  187.967567,
    (80, 189):  188.968195,
    (80, 190):  189.966323,
    (80, 191):  190.967157,
    (80, 192):  191.965635,
    (80, 193):  192.966653,
    (80, 194):  193.9654491,
    (80, 195):  194.966721,
    (80, 196):  195.9658326,
    (80, 197):  196.9672128,
    (80, 198):  197.9667686,
    (80, 199):  198.96828064,
    (80, 200):  199.96832659,
    (80, 201):  200.97030284,
    (80, 202):  201.9706434,
    (80, 203):  202.9728728,
    (80, 204):  203.97349398,
    (80, 205):  204.9760734,
    (80, 206):  205.977514,
    (80, 207):  206.9823,
    (80, 208):  207.985759,
    (80, 209):  208.99072,
    (80, 210):  209.99424,
    (80, 211):  210.99933,
    (80, 212):  212.00296,
    (80, 213):  213.00823,
    (80, 214):  214.012,
    (80, 215):  215.0174,
    (80, 216):  216.02132,
    (81, 176):  176.000624,
    (81, 177):  176.996431,
    (81, 178):  177.99485,
    (81, 179):  178.991111,
    (81, 180):  179.990057,
    (81, 181):  180.98626,
    (81, 182):  181.985713,
    (81, 183):  182.982193,
    (81, 184):  183.981886,
    (81, 185):  184.978789,
    (81, 186):  185.978651,
    (81, 187):  186.9759063,
    (81, 188):  187.976021,
    (81, 189):  188.973588,
    (81, 190):  189.973828,
    (81, 191):  190.9717842,
    (81, 192):  191.972225,
    (81, 193):  192.970502,
    (81, 194):  193.971081,
    (81, 195):  194.969774,
    (81, 196):  195.970481,
    (81, 197):  196.969576,
    (81, 198):  197.970483,
    (81, 199):  198.969877,
    (81, 200):  199.9709633,
    (81, 201):  200.970822,
    (81, 202):  201.972102,
    (81, 203):  202.9723446,
    (81, 204):  203.9738639,
    (81, 205):  204.9744278,
    (81, 206):  205.9761106,
    (81, 207):  206.9774197,
    (81, 208):  207.982019,
    (81, 209):  208.9853594,
    (81, 210):  209.990074,
    (81, 211):  210.993475,
    (81, 212):  211.99834,
    (81, 213):  213.001915,
    (81, 214):  214.00694,
    (81, 215):  215.01064,
    (81, 216):  216.0158,
    (81, 217):  217.01966,
    (81, 218):  218.02479,
    (82, 178):  178.003831,
    (82, 179):  179.002201,
    (82, 180):  179.997928,
    (82, 181):  180.996653,
    (82, 182):  181.992672,
    (82, 183):  182.991872,
    (82, 184):  183.988136,
    (82, 185):  184.98761,
    (82, 186):  185.984238,
    (82, 187):  186.9839109,
    (82, 188):  187.980875,
    (82, 189):  188.980807,
    (82, 190):  189.978082,
    (82, 191):  190.978276,
    (82, 192):  191.975775,
    (82, 193):  192.976173,
    (82, 194):  193.974012,
    (82, 195):  194.974543,
    (82, 196):  195.972774,
    (82, 197):  196.9734312,
    (82, 198):  197.972034,
    (82, 199):  198.972913,
    (82, 200):  199.971819,
    (82, 201):  200.972883,
    (82, 202):  201.972152,
    (82, 203):  202.9733911,
    (82, 204):  203.973044,
    (82, 205):  204.9744822,
    (82, 206):  205.9744657,
    (82, 207):  206.9758973,
    (82, 208):  207.9766525,
    (82, 209):  208.9810905,
    (82, 210):  209.9841889,
    (82, 211):  210.9887371,
    (82, 212):  211.9918977,
    (82, 213):  212.9965629,
    (82, 214):  213.9998059,
    (82, 215):  215.00474,
    (82, 216):  216.00803,
    (82, 217):  217.01314,
    (82, 218):  218.01659,
    (82, 219):  219.02177,
    (82, 220):  220.02541,
    (83, 184):  184.001275,
    (83, 185):  184.9976,
    (83, 186):  185.996644,
    (83, 187):  186.993147,
    (83, 188):  187.992287,
    (83, 189):  188.989195,
    (83, 190):  189.988622,
    (83, 191):  190.9857866,
    (83, 192):  191.985469,
    (83, 193):  192.98296,
    (83, 194):  193.982785,
    (83, 195):  194.9806488,
    (83, 196):  195.980667,
    (83, 197):  196.9788651,
    (83, 198):  197.979206,
    (83, 199):  198.977673,
    (83, 200):  199.978131,
    (83, 201):  200.97701,
    (83, 202):  201.977734,
    (83, 203):  202.976893,
    (83, 204):  203.9778361,
    (83, 205):  204.9773867,
    (83, 206):  205.9784993,
    (83, 207):  206.978471,
    (83, 208):  207.9797425,
    (83, 209):  208.9803991,
    (83, 210):  209.9841207,
    (83, 211):  210.9872697,
    (83, 212):  211.991286,
    (83, 213):  212.9943851,
    (83, 214):  213.998712,
    (83, 215):  215.00177,
    (83, 216):  216.006306,
    (83, 217):  217.009372,
    (83, 218):  218.014188,
    (83, 219):  219.01748,
    (83, 220):  220.02235,
    (83, 221):  221.02587,
    (83, 222):  222.03078,
    (83, 223):  223.0345,
    (83, 224):  224.03947,
    (84, 186):  186.004393,
    (84, 187):  187.003041,
    (84, 188):  187.999416,
    (84, 189):  188.998473,
    (84, 190):  189.995101,
    (84, 191):  190.9945585,
    (84, 192):  191.991336,
    (84, 193):  192.991026,
    (84, 194):  193.988186,
    (84, 195):  194.988126,
    (84, 196):  195.985526,
    (84, 197):  196.98566,
    (84, 198):  197.983389,
    (84, 199):  198.983667,
    (84, 200):  199.981799,
    (84, 201):  200.9822598,
    (84, 202):  201.980758,
    (84, 203):  202.9814161,
    (84, 204):  203.98031,
    (84, 205):  204.981203,
    (84, 206):  205.980474,
    (84, 207):  206.9815938,
    (84, 208):  207.9812461,
    (84, 209):  208.9824308,
    (84, 210):  209.9828741,
    (84, 211):  210.9866536,
    (84, 212):  211.9888684,
    (84, 213):  212.9928576,
    (84, 214):  213.9952017,
    (84, 215):  214.9994201,
    (84, 216):  216.0019152,
    (84, 217):  217.0063182,
    (84, 218):  218.0089735,
    (84, 219):  219.013614,
    (84, 220):  220.016386,
    (84, 221):  221.021228,
    (84, 222):  222.02414,
    (84, 223):  223.02907,
    (84, 224):  224.03211,
    (84, 225):  225.03707,
    (84, 226):  226.04031,
    (84, 227):  227.04539,
    (85, 191):  191.004148,
    (85, 192):  192.003152,
    (85, 193):  192.999927,
    (85, 194):  193.999236,
    (85, 195):  194.9962685,
    (85, 196):  195.9958,
    (85, 197):  196.993189,
    (85, 198):  197.992784,
    (85, 199):  198.9905277,
    (85, 200):  199.990351,
    (85, 201):  200.9884171,
    (85, 202):  201.98863,
    (85, 203):  202.986943,
    (85, 204):  203.987251,
    (85, 205):  204.986076,
    (85, 206):  205.986657,
    (85, 207):  206.9858,
    (85, 208):  207.9866133,
    (85, 209):  208.9861702,
    (85, 210):  209.9871479,
    (85, 211):  210.9874966,
    (85, 212):  211.9907377,
    (85, 213):  212.992937,
    (85, 214):  213.9963721,
    (85, 215):  214.9986528,
    (85, 216):  216.0024236,
    (85, 217):  217.0047192,
    (85, 218):  218.008695,
    (85, 219):  219.0111618,
    (85, 220):  220.015433,
    (85, 221):  221.018017,
    (85, 222):  222.022494,
    (85, 223):  223.025151,
    (85, 224):  224.029749,
    (85, 225):  225.03263,
    (85, 226):  226.03716,
    (85, 227):  227.04024,
    (85, 228):  228.04475,
    (85, 229):  229.04812,
    (86, 193):  193.009708,
    (86, 194):  194.006144,
    (86, 195):  195.005422,
    (86, 196):  196.002116,
    (86, 197):  197.001585,
    (86, 198):  197.998679,
    (86, 199):  198.99839,
    (86, 200):  199.99569,
    (86, 201):  200.995628,
    (86, 202):  201.993264,
    (86, 203):  202.993388,
    (86, 204):  203.99143,
    (86, 205):  204.991719,
    (86, 206):  205.990214,
    (86, 207):  206.9907303,
    (86, 208):  207.989635,
    (86, 209):  208.990415,
    (86, 210):  209.9896891,
    (86, 211):  210.9906011,
    (86, 212):  211.9907039,
    (86, 213):  212.9938831,
    (86, 214):  213.995363,
    (86, 215):  214.9987459,
    (86, 216):  216.0002719,
    (86, 217):  217.003928,
    (86, 218):  218.0056016,
    (86, 219):  219.0094804,
    (86, 220):  220.0113941,
    (86, 221):  221.0155371,
    (86, 222):  222.0175782,
    (86, 223):  223.0218893,
    (86, 224):  224.024096,
    (86, 225):  225.028486,
    (86, 226):  226.030861,
    (86, 227):  227.035304,
    (86, 228):  228.037835,
    (86, 229):  229.042257,
    (86, 230):  230.04514,
    (86, 231):  231.04987,
    (87, 199):  199.007259,
    (87, 200):  200.006586,
    (87, 201):  201.003867,
    (87, 202):  202.00332,
    (87, 203):  203.0009407,
    (87, 204):  204.000652,
    (87, 205):  204.9985939,
    (87, 206):  205.998666,
    (87, 207):  206.996946,
    (87, 208):  207.997138,
    (87, 209):  208.995955,
    (87, 210):  209.996422,
    (87, 211):  210.995556,
    (87, 212):  211.9962257,
    (87, 213):  212.996186,
    (87, 214):  213.9989713,
    (87, 215):  215.0003418,
    (87, 216):  216.0031899,
    (87, 217):  217.0046323,
    (87, 218):  218.0075787,
    (87, 219):  219.0092524,
    (87, 220):  220.0123277,
    (87, 221):  221.0142552,
    (87, 222):  222.017552,
    (87, 223):  223.019736,
    (87, 224):  224.023398,
    (87, 225):  225.025573,
    (87, 226):  226.029566,
    (87, 227):  227.031869,
    (87, 228):  228.035823,
    (87, 229):  229.038298,
    (87, 230):  230.042416,
    (87, 231):  231.045158,
    (87, 232):  232.04937,
    (87, 233):  233.05264,
    (88, 201):  201.01271,
    (88, 202):  202.00976,
    (88, 203):  203.009304,
    (88, 204):  204.006492,
    (88, 205):  205.006268,
    (88, 206):  206.003828,
    (88, 207):  207.003799,
    (88, 208):  208.001841,
    (88, 209):  209.00199,
    (88, 210):  210.000494,
    (88, 211):  211.0008932,
    (88, 212):  211.999787,
    (88, 213):  213.000384,
    (88, 214):  214.0000997,
    (88, 215):  215.0027204,
    (88, 216):  216.0035334,
    (88, 217):  217.0063207,
    (88, 218):  218.007141,
    (88, 219):  219.0100855,
    (88, 220):  220.0110259,
    (88, 221):  221.0139177,
    (88, 222):  222.0153748,
    (88, 223):  223.0185023,
    (88, 224):  224.020212,
    (88, 225):  225.0236119,
    (88, 226):  226.0254103,
    (88, 227):  227.0291783,
    (88, 228):  228.0310707,
    (88, 229):  229.034942,
    (88, 230):  230.037055,
    (88, 231):  231.041027,
    (88, 232):  232.0434753,
    (88, 233):  233.047582,
    (88, 234):  234.050342,
    (88, 235):  235.05497,
    (89, 206):  206.014452,
    (89, 207):  207.011966,
    (89, 208):  208.01155,
    (89, 209):  209.009495,
    (89, 210):  210.009436,
    (89, 211):  211.007732,
    (89, 212):  212.007813,
    (89, 213):  213.006609,
    (89, 214):  214.006918,
    (89, 215):  215.006475,
    (89, 216):  216.008743,
    (89, 217):  217.009344,
    (89, 218):  218.011642,
    (89, 219):  219.012421,
    (89, 220):  220.0147549,
    (89, 221):  221.015592,
    (89, 222):  222.0178442,
    (89, 223):  223.0191377,
    (89, 224):  224.0217232,
    (89, 225):  225.02323,
    (89, 226):  226.0260984,
    (89, 227):  227.0277523,
    (89, 228):  228.0310215,
    (89, 229):  229.032956,
    (89, 230):  230.036327,
    (89, 231):  231.038393,
    (89, 232):  232.042034,
    (89, 233):  233.044346,
    (89, 234):  234.048139,
    (89, 235):  235.05084,
    (89, 236):  236.054988,
    (89, 237):  237.05827,
    (90, 208):  208.0179,
    (90, 209):  209.017753,
    (90, 210):  210.015094,
    (90, 211):  211.014929,
    (90, 212):  212.012988,
    (90, 213):  213.013009,
    (90, 214):  214.0115,
    (90, 215):  215.0117248,
    (90, 216):  216.011056,
    (90, 217):  217.013117,
    (90, 218):  218.013276,
    (90, 219):  219.015537,
    (90, 220):  220.015748,
    (90, 221):  221.018184,
    (90, 222):  222.018469,
    (90, 223):  223.0208119,
    (90, 224):  224.021464,
    (90, 225):  225.0239514,
    (90, 226):  226.0249034,
    (90, 227):  227.0277042,
    (90, 228):  228.0287413,
    (90, 229):  229.0317627,
    (90, 230):  230.0331341,
    (90, 231):  231.0363046,
    (90, 232):  232.0380558,
    (90, 233):  233.0415823,
    (90, 234):  234.0436014,
    (90, 235):  235.047255,
    (90, 236):  236.049657,
    (90, 237):  237.053629,
    (90, 238):  238.0565,
    (90, 239):  239.06077,
    (91, 212):  212.023203,
    (91, 213):  213.021109,
    (91, 214):  214.020918,
    (91, 215):  215.019183,
    (91, 216):  216.019109,
    (91, 217):  217.018325,
    (91, 218):  218.020059,
    (91, 219):  219.019904,
    (91, 220):  220.021705,
    (91, 221):  221.021875,
    (91, 222):  222.023784,
    (91, 223):  223.023963,
    (91, 224):  224.0256176,
    (91, 225):  225.026131,
    (91, 226):  226.027948,
    (91, 227):  227.0288054,
    (91, 228):  228.0310517,
    (91, 229):  229.0320972,
    (91, 230):  230.034541,
    (91, 231):  231.0358842,
    (91, 232):  232.0385917,
    (91, 233):  233.0402472,
    (91, 234):  234.0433072,
    (91, 235):  235.045399,
    (91, 236):  236.048668,
    (91, 237):  237.051023,
    (91, 238):  238.054637,
    (91, 239):  239.05726,
    (91, 240):  240.06098,
    (91, 241):  241.06408,
    (92, 217):  217.02466,
    (92, 218):  218.023523,
    (92, 219):  219.024999,
    (92, 220):  220.02462,
    (92, 221):  221.02628,
    (92, 222):  222.026,
    (92, 223):  223.027739,
    (92, 224):  224.027605,
    (92, 225):  225.029391,
    (92, 226):  226.029339,
    (92, 227):  227.031157,
    (92, 228):  228.031371,
    (92, 229):  229.0335063,
    (92, 230):  230.0339401,
    (92, 231):  231.0362939,
    (92, 232):  232.0371563,
    (92, 233):  233.0396355,
    (92, 234):  234.0409523,
    (92, 235):  235.0439301,
    (92, 236):  236.0455682,
    (92, 237):  237.0487304,
    (92, 238):  238.0507884,
    (92, 239):  239.0542935,
    (92, 240):  240.0565934,
    (92, 241):  241.06033,
    (92, 242):  242.06293,
    (92, 243):  243.06699,
    (93, 219):  219.03143,
    (93, 220):  220.03254,
    (93, 221):  221.03204,
    (93, 222):  222.0333,
    (93, 223):  223.03285,
    (93, 224):  224.03422,
    (93, 225):  225.033911,
    (93, 226):  226.035188,
    (93, 227):  227.034957,
    (93, 228):  228.036067,
    (93, 229):  229.036264,
    (93, 230):  230.037828,
    (93, 231):  231.038245,
    (93, 232):  232.04011,
    (93, 233):  233.040741,
    (93, 234):  234.0428953,
    (93, 235):  235.0440635,
    (93, 236):  236.04657,
    (93, 237):  237.0481736,
    (93, 238):  238.0509466,
    (93, 239):  239.0529392,
    (93, 240):  240.056165,
    (93, 241):  241.058253,
    (93, 242):  242.06164,
    (93, 243):  243.06428,
    (93, 244):  244.06785,
    (93, 245):  245.0708,
    (94, 228):  228.038732,
    (94, 229):  229.040144,
    (94, 230):  230.03965,
    (94, 231):  231.041102,
    (94, 232):  232.041185,
    (94, 233):  233.042998,
    (94, 234):  234.0433174,
    (94, 235):  235.045286,
    (94, 236):  236.0460581,
    (94, 237):  237.0484098,
    (94, 238):  238.0495601,
    (94, 239):  239.0521636,
    (94, 240):  240.0538138,
    (94, 241):  241.0568517,
    (94, 242):  242.0587428,
    (94, 243):  243.0620036,
    (94, 244):  244.0642053,
    (94, 245):  245.067826,
    (94, 246):  246.070205,
    (94, 247):  247.07419,
    (95, 230):  230.04609,
    (95, 231):  231.04556,
    (95, 232):  232.04645,
    (95, 233):  233.04644,
    (95, 234):  234.04773,
    (95, 235):  235.047908,
    (95, 236):  236.04943,
    (95, 237):  237.049996,
    (95, 238):  238.051985,
    (95, 239):  239.0530247,
    (95, 240):  240.0553,
    (95, 241):  241.0568293,
    (95, 242):  242.0595494,
    (95, 243):  243.0613813,
    (95, 244):  244.0642851,
    (95, 245):  245.0664548,
    (95, 246):  246.069775,
    (95, 247):  247.07209,
    (95, 248):  248.07575,
    (95, 249):  249.07848,
    (96, 232):  232.04982,
    (96, 233):  233.05077,
    (96, 234):  234.05016,
    (96, 235):  235.05154,
    (96, 236):  236.051374,
    (96, 237):  237.052869,
    (96, 238):  238.053081,
    (96, 239):  239.05491,
    (96, 240):  240.0555297,
    (96, 241):  241.0576532,
    (96, 242):  242.058836,
    (96, 243):  243.0613893,
    (96, 244):  244.0627528,
    (96, 245):  245.0654915,
    (96, 246):  246.0672238,
    (96, 247):  247.0703541,
    (96, 248):  248.0723499,
    (96, 249):  249.0759548,
    (96, 250):  250.078358,
    (96, 251):  251.082286,
    (96, 252):  252.08487,
    (97, 234):  234.05727,
    (97, 235):  235.05658,
    (97, 236):  236.05748,
    (97, 237):  237.0571,
    (97, 238):  238.0582,
    (97, 239):  239.05824,
    (97, 240):  240.05976,
    (97, 241):  241.06016,
    (97, 242):  242.06198,
    (97, 243):  243.0630078,
    (97, 244):  244.065181,
    (97, 245):  245.0663618,
    (97, 246):  246.068673,
    (97, 247):  247.0703073,
    (97, 248):  248.073088,
    (97, 249):  249.0749877,
    (97, 250):  250.0783167,
    (97, 251):  251.080762,
    (97, 252):  252.08431,
    (97, 253):  253.08688,
    (97, 254):  254.0906,
    (98, 237):  237.062198,
    (98, 238):  238.06149,
    (98, 239):  239.06253,
    (98, 240):  240.062256,
    (98, 241):  241.06369,
    (98, 242):  242.063754,
    (98, 243):  243.06548,
    (98, 244):  244.0660008,
    (98, 245):  245.0680487,
    (98, 246):  246.0688055,
    (98, 247):  247.070965,
    (98, 248):  248.0721851,
    (98, 249):  249.0748539,
    (98, 250):  250.0764062,
    (98, 251):  251.0795886,
    (98, 252):  252.0816272,
    (98, 253):  253.0851345,
    (98, 254):  254.087324,
    (98, 255):  255.09105,
    (98, 256):  256.09344,
    (99, 239):  239.06823,
    (99, 240):  240.06892,
    (99, 241):  241.06856,
    (99, 242):  242.06957,
    (99, 243):  243.06951,
    (99, 244):  244.07088,
    (99, 245):  245.07125,
    (99, 246):  246.0729,
    (99, 247):  247.073622,
    (99, 248):  248.075471,
    (99, 249):  249.076411,
    (99, 250):  250.07861,
    (99, 251):  251.0799936,
    (99, 252):  252.08298,
    (99, 253):  253.0848257,
    (99, 254):  254.0880222,
    (99, 255):  255.090275,
    (99, 256):  256.0936,
    (99, 257):  257.09598,
    (99, 258):  258.09952,
    (100, 241): 241.07421,
    (100, 242): 242.07343,
    (100, 243): 243.07446,
    (100, 244): 244.07404,
    (100, 245): 245.07535,
    (100, 246): 246.07535,
    (100, 247): 247.07694,
    (100, 248): 248.0771865,
    (100, 249): 249.0789275,
    (100, 250): 250.079521,
    (100, 251): 251.08154,
    (100, 252): 252.0824671,
    (100, 253): 253.0851846,
    (100, 254): 254.0868544,
    (100, 255): 255.089964,
    (100, 256): 256.0917745,
    (100, 257): 257.0951061,
    (100, 258): 258.09708,
    (100, 259): 259.1006,
    (100, 260): 260.10281,
    (101, 245): 245.08081,
    (101, 246): 246.08171,
    (101, 247): 247.08152,
    (101, 248): 248.08282,
    (101, 249): 249.08291,
    (101, 250): 250.08441,
    (101, 251): 251.084774,
    (101, 252): 252.08643,
    (101, 253): 253.087144,
    (101, 254): 254.08959,
    (101, 255): 255.0910841,
    (101, 256): 256.09389,
    (101, 257): 257.0955424,
    (101, 258): 258.0984315,
    (101, 259): 259.10051,
    (101, 260): 260.10365,
    (101, 261): 261.10583,
    (101, 262): 262.1091,
    (102, 248): 248.08655,
    (102, 249): 249.0878,
    (102, 250): 250.08756,
    (102, 251): 251.08894,
    (102, 252): 252.088967,
    (102, 253): 253.0905641,
    (102, 254): 254.090956,
    (102, 255): 255.093191,
    (102, 256): 256.0942829,
    (102, 257): 257.0968878,
    (102, 258): 258.09821,
    (102, 259): 259.10103,
    (102, 260): 260.10264,
    (102, 261): 261.1057,
    (102, 262): 262.10746,
    (102, 263): 263.11071,
    (102, 264): 264.11273,
    (103, 251): 251.09418,
    (103, 252): 252.09526,
    (103, 253): 253.09509,
    (103, 254): 254.09648,
    (103, 255): 255.096562,
    (103, 256): 256.098494,
    (103, 257): 257.099418,
    (103, 258): 258.10176,
    (103, 259): 259.102902,
    (103, 260): 260.1055,
    (103, 261): 261.10688,
    (103, 262): 262.10961,
    (103, 263): 263.11136,
    (103, 264): 264.1142,
    (103, 265): 265.11619,
    (103, 266): 266.11983,
    (104, 253): 253.10044,
    (104, 254): 254.10005,
    (104, 255): 255.10127,
    (104, 256): 256.101152,
    (104, 257): 257.102918,
    (104, 258): 258.103428,
    (104, 259): 259.105596,
    (104, 260): 260.10644,
    (104, 261): 261.108773,
    (104, 262): 262.10992,
    (104, 263): 263.11249,
    (104, 264): 264.11388,
    (104, 265): 265.11668,
    (104, 266): 266.11817,
    (104, 267): 267.12179,
    (104, 268): 268.12397,
    (105, 255): 255.10707,
    (105, 256): 256.10789,
    (105, 257): 257.10758,
    (105, 258): 258.10928,
    (105, 259): 259.109492,
    (105, 260): 260.1113,
    (105, 261): 261.11192,
    (105, 262): 262.11407,
    (105, 263): 263.11499,
    (105, 264): 264.11741,
    (105, 265): 265.11861,
    (105, 266): 266.12103,
    (105, 267): 267.12247,
    (105, 268): 268.12567,
    (105, 269): 269.12791,
    (105, 270): 270.13136,
    (106, 258): 258.11298,
    (106, 259): 259.1144,
    (106, 260): 260.114384,
    (106, 261): 261.115949,
    (106, 262): 262.116337,
    (106, 263): 263.11829,
    (106, 264): 264.11893,
    (106, 265): 265.12109,
    (106, 266): 266.12198,
    (106, 267): 267.12436,
    (106, 268): 268.12539,
    (106, 269): 269.12863,
    (106, 270): 270.13043,
    (106, 271): 271.13393,
    (106, 272): 272.13589,
    (106, 273): 273.13958,
    (107, 260): 260.12166,
    (107, 261): 261.12145,
    (107, 262): 262.12297,
    (107, 263): 263.12292,
    (107, 264): 264.12459,
    (107, 265): 265.12491,
    (107, 266): 266.12679,
    (107, 267): 267.1275,
    (107, 268): 268.12969,
    (107, 269): 269.13042,
    (107, 270): 270.13336,
    (107, 271): 271.13526,
    (107, 272): 272.13826,
    (107, 273): 273.14024,
    (107, 274): 274.14355,
    (107, 275): 275.14567,
    (108, 263): 263.12852,
    (108, 264): 264.128357,
    (108, 265): 265.129793,
    (108, 266): 266.130046,
    (108, 267): 267.13167,
    (108, 268): 268.13186,
    (108, 269): 269.13375,
    (108, 270): 270.13429,
    (108, 271): 271.13717,
    (108, 272): 272.1385,
    (108, 273): 273.14168,
    (108, 274): 274.1433,
    (108, 275): 275.14667,
    (108, 276): 276.14846,
    (108, 277): 277.1519,
    (109, 265): 265.136,
    (109, 266): 266.13737,
    (109, 267): 267.13719,
    (109, 268): 268.13865,
    (109, 269): 269.13882,
    (109, 270): 270.14033,
    (109, 271): 271.14074,
    (109, 272): 272.14341,
    (109, 273): 273.1444,
    (109, 274): 274.14724,
    (109, 275): 275.14882,
    (109, 276): 276.15159,
    (109, 277): 277.15327,
    (109, 278): 278.15631,
    (109, 279): 279.15808,
    (110, 267): 267.14377,
    (110, 268): 268.14348,
    (110, 269): 269.144752,
    (110, 270): 270.144584,
    (110, 271): 271.14595,
    (110, 272): 272.14602,
    (110, 273): 273.14856,
    (110, 274): 274.14941,
    (110, 275): 275.15203,
    (110, 276): 276.15303,
    (110, 277): 277.15591,
    (110, 278): 278.15704,
    (110, 279): 279.1601,
    (110, 280): 280.16131,
    (110, 281): 281.16451,
    (111, 272): 272.15327,
    (111, 273): 273.15313,
    (111, 274): 274.15525,
    (111, 275): 275.15594,
    (111, 276): 276.15833,
    (111, 277): 277.15907,
    (111, 278): 278.16149,
    (111, 279): 279.16272,
    (111, 280): 280.16514,
    (111, 281): 281.16636,
    (111, 282): 282.16912,
    (111, 283): 283.17054,
    (112, 276): 276.16141,
    (112, 277): 277.16364,
    (112, 278): 278.16416,
    (112, 279): 279.16654,
    (112, 280): 280.16715,
    (112, 281): 281.16975,
    (112, 282): 282.1705,
    (112, 283): 283.17327,
    (112, 284): 284.17416,
    (112, 285): 285.17712,
    (113, 278): 278.17058,
    (113, 279): 279.17095,
    (113, 280): 280.17293,
    (113, 281): 281.17348,
    (113, 282): 282.17567,
    (113, 283): 283.17657,
    (113, 284): 284.17873,
    (113, 285): 285.17973,
    (113, 286): 286.18221,
    (113, 287): 287.18339,
    (114, 285): 285.18364,
    (114, 286): 286.18423,
    (114, 287): 287.18678,
    (114, 288): 288.18757,
    (114, 289): 289.19042,
    (115, 287): 287.1907,
    (115, 288): 288.19274,
    (115, 289): 289.19363,
    (115, 290): 290.19598,
    (115, 291): 291.19707,
    (116, 289): 289.19816,
    (116, 290): 290.19864,
    (116, 291): 291.20108,
    (116, 292): 292.20174,
    (116, 293): 293.20449,
    (117, 291): 291.20553,
    (117, 292): 292.20746,
    (117, 293): 293.20824,
    (117, 294): 294.21046,
    (118, 293): 293.21356,
    (118, 294): 294.21392,
    (118, 295): 295.21624,
    'H':        1.0079407540557772,
    'D':        1.0079407540557772,
    'T':        1.0079407540557772,
    'He':       4.002602,
    'Li':       6.94003660291572,
    'Be':       9.0121831,
    'B':        10.811028046410001,
    'C':        12.010735896735248,
    'N':        14.006703211445798,
    'O':        15.999404924318277,
    'F':        18.998403163,
    'Ne':       20.1797,
    'Na':       22.98976928,
    'Mg':       24.3050516198371,
    'Al':       26.9815385,
    'Si':       28.085498705705955,
    'P':        30.973761998,
    'S':        32.06478740612706,
    'Cl':       35.452937582608,
    'Ar':       39.948,
    'K':        39.0983,
    'Ca':       40.078,
    'Sc':       44.955908,
    'Ti':       47.867,
    'V':        50.9415,
    'Cr':       51.9961,
    'Mn':       54.938044,
    'Fe':       55.845,
    'Co':       58.933194,
    'Ni':       58.6934,
    'Cu':       63.546,
    'Zn':       65.38,
    'Ga':       69.723,
    'Ge':       72.63,
    'As':       74.921595,
    'Se':       78.971,
    'Br':       79.90352778050999,
    'Kr':       83.798,
    'Rb':       85.4678,
    'Sr':       87.62,
    'Y':        88.90584,
    'Zr':       91.224,
    'Nb':       92.90637,
    'Mo':       95.95,
    'Tc':       None,
    'Ru':       101.07,
    'Rh':       102.9055,
    'Pd':       106.42,
    'Ag':       107.8682,
    'Cd':       112.414,
    'In':       114.818,
    'Sn':       118.71,
    'Sb':       121.76,
    'Te':       127.6,
    'I':        126.90447,
    'Xe':       131.293,
    'Cs':       132.90545196,
    'Ba':       137.327,
    'La':       138.90547,
    'Ce':       140.116,
    'Pr':       140.90766,
    'Nd':       144.242,
    'Pm':       None,
    'Sm':       150.36,
    'Eu':       151.964,
    'Gd':       157.25,
    'Tb':       158.92535,
    'Dy':       162.5,
    'Ho':       164.93033,
    'Er':       167.259,
    'Tm':       168.93422,
    'Yb':       173.054,
    'Lu':       174.9668,
    'Hf':       178.49,
    'Ta':       180.94788,
    'W':        183.84,
    'Re':       186.207,
    'Os':       190.23,
    'Ir':       192.217,
    'Pt':       195.084,
    'Au':       196.966569,
    'Hg':       200.592,
    'Tl':       204.38341283936,
    'Pb':       207.2,
    'Bi':       208.9804,
    'Po':       None,
    'At':       None,
    'Rn':       None,
    'Fr':       None,
    'Ra':       None,
    'Ac':       None,
    'Th':       232.0377,
    'Pa':       231.03588,
    'U':        238.02891,
    'Np':       None,
    'Pu':       None,
    'Am':       None,
    'Cm':       None,
    'Bk':       None,
    'Cf':       None,
    'Es':       None,
    'Fm':       None,
    'Md':       None,
    'No':       None,
    'Lr':       None,
    'Rf':       None,
    'Db':       None,
    'Sg':       None,
    'Bh':       None,
    'Hs':       None,
    'Mt':       None,
    'Ds':       None,
    'Rg':       None,
    'Cn':       None,
    'Nh':       None,
    'Fl':       None,
    'Mc':       None,
    'Uup':      None,
    'Lv':       None,
    'Ts':       None,
    'Uus':      None,
    'Og':       None
    }
ISOTOPE_ABUNDANCES = {
    (1, 1):     0.999885,
    (1, 2):     0.000115,
    (1, 3):     None,
    (1, 4):     None,
    (1, 5):     None,
    (1, 6):     None,
    (1, 7):     None,
    (2, 3):     1.34e-06,
    (2, 4):     0.99999866,
    (2, 5):     None,
    (2, 6):     None,
    (2, 7):     None,
    (2, 8):     None,
    (2, 9):     None,
    (2, 10):    None,
    (3, 3):     None,
    (3, 4):     None,
    (3, 5):     None,
    (3, 6):     0.0759,
    (3, 7):     0.9241,
    (3, 8):     None,
    (3, 9):     None,
    (3, 10):    None,
    (3, 11):    None,
    (3, 12):    None,
    (3, 13):    None,
    (4, 5):     None,
    (4, 6):     None,
    (4, 7):     None,
    (4, 8):     None,
    (4, 9):     1.0,
    (4, 10):    None,
    (4, 11):    None,
    (4, 12):    None,
    (4, 13):    None,
    (4, 14):    None,
    (4, 15):    None,
    (4, 16):    None,
    (5, 6):     None,
    (5, 7):     None,
    (5, 8):     None,
    (5, 9):     None,
    (5, 10):    0.199,
    (5, 11):    0.801,
    (5, 12):    None,
    (5, 13):    None,
    (5, 14):    None,
    (5, 15):    None,
    (5, 16):    None,
    (5, 17):    None,
    (5, 18):    None,
    (5, 19):    None,
    (5, 20):    None,
    (5, 21):    None,
    (6, 8):     None,
    (6, 9):     None,
    (6, 10):    None,
    (6, 11):    None,
    (6, 12):    0.9893,
    (6, 13):    0.0107,
    (6, 14):    None,
    (6, 15):    None,
    (6, 16):    None,
    (6, 17):    None,
    (6, 18):    None,
    (6, 19):    None,
    (6, 20):    None,
    (6, 21):    None,
    (6, 22):    None,
    (6, 23):    None,
    (7, 10):    None,
    (7, 11):    None,
    (7, 12):    None,
    (7, 13):    None,
    (7, 14):    0.99636,
    (7, 15):    0.00364,
    (7, 16):    None,
    (7, 17):    None,
    (7, 18):    None,
    (7, 19):    None,
    (7, 20):    None,
    (7, 21):    None,
    (7, 22):    None,
    (7, 23):    None,
    (7, 24):    None,
    (7, 25):    None,
    (8, 12):    None,
    (8, 13):    None,
    (8, 14):    None,
    (8, 15):    None,
    (8, 16):    0.99757,
    (8, 17):    0.00038,
    (8, 18):    0.00205,
    (8, 19):    None,
    (8, 20):    None,
    (8, 21):    None,
    (8, 22):    None,
    (8, 23):    None,
    (8, 24):    None,
    (8, 25):    None,
    (8, 26):    None,
    (8, 27):    None,
    (8, 28):    None,
    (9, 14):    None,
    (9, 15):    None,
    (9, 16):    None,
    (9, 17):    None,
    (9, 18):    None,
    (9, 19):    1.0,
    (9, 20):    None,
    (9, 21):    None,
    (9, 22):    None,
    (9, 23):    None,
    (9, 24):    None,
    (9, 25):    None,
    (9, 26):    None,
    (9, 27):    None,
    (9, 28):    None,
    (9, 29):    None,
    (9, 30):    None,
    (9, 31):    None,
    (10, 16):   None,
    (10, 17):   None,
    (10, 18):   None,
    (10, 19):   None,
    (10, 20):   0.9048,
    (10, 21):   0.0027,
    (10, 22):   0.0925,
    (10, 23):   None,
    (10, 24):   None,
    (10, 25):   None,
    (10, 26):   None,
    (10, 27):   None,
    (10, 28):   None,
    (10, 29):   None,
    (10, 30):   None,
    (10, 31):   None,
    (10, 32):   None,
    (10, 33):   None,
    (10, 34):   None,
    (11, 18):   None,
    (11, 19):   None,
    (11, 20):   None,
    (11, 21):   None,
    (11, 22):   None,
    (11, 23):   1.0,
    (11, 24):   None,
    (11, 25):   None,
    (11, 26):   None,
    (11, 27):   None,
    (11, 28):   None,
    (11, 29):   None,
    (11, 30):   None,
    (11, 31):   None,
    (11, 32):   None,
    (11, 33):   None,
    (11, 34):   None,
    (11, 35):   None,
    (11, 36):   None,
    (11, 37):   None,
    (12, 19):   None,
    (12, 20):   None,
    (12, 21):   None,
    (12, 22):   None,
    (12, 23):   None,
    (12, 24):   0.7899,
    (12, 25):   0.1,
    (12, 26):   0.1101,
    (12, 27):   None,
    (12, 28):   None,
    (12, 29):   None,
    (12, 30):   None,
    (12, 31):   None,
    (12, 32):   None,
    (12, 33):   None,
    (12, 34):   None,
    (12, 35):   None,
    (12, 36):   None,
    (12, 37):   None,
    (12, 38):   None,
    (12, 39):   None,
    (12, 40):   None,
    (13, 21):   None,
    (13, 22):   None,
    (13, 23):   None,
    (13, 24):   None,
    (13, 25):   None,
    (13, 26):   None,
    (13, 27):   1.0,
    (13, 28):   None,
    (13, 29):   None,
    (13, 30):   None,
    (13, 31):   None,
    (13, 32):   None,
    (13, 33):   None,
    (13, 34):   None,
    (13, 35):   None,
    (13, 36):   None,
    (13, 37):   None,
    (13, 38):   None,
    (13, 39):   None,
    (13, 40):   None,
    (13, 41):   None,
    (13, 42):   None,
    (13, 43):   None,
    (14, 22):   None,
    (14, 23):   None,
    (14, 24):   None,
    (14, 25):   None,
    (14, 26):   None,
    (14, 27):   None,
    (14, 28):   0.92223,
    (14, 29):   0.04685,
    (14, 30):   0.03092,
    (14, 31):   None,
    (14, 32):   None,
    (14, 33):   None,
    (14, 34):   None,
    (14, 35):   None,
    (14, 36):   None,
    (14, 37):   None,
    (14, 38):   None,
    (14, 39):   None,
    (14, 40):   None,
    (14, 41):   None,
    (14, 42):   None,
    (14, 43):   None,
    (14, 44):   None,
    (14, 45):   None,
    (15, 24):   None,
    (15, 25):   None,
    (15, 26):   None,
    (15, 27):   None,
    (15, 28):   None,
    (15, 29):   None,
    (15, 30):   None,
    (15, 31):   1.0,
    (15, 32):   None,
    (15, 33):   None,
    (15, 34):   None,
    (15, 35):   None,
    (15, 36):   None,
    (15, 37):   None,
    (15, 38):   None,
    (15, 39):   None,
    (15, 40):   None,
    (15, 41):   None,
    (15, 42):   None,
    (15, 43):   None,
    (15, 44):   None,
    (15, 45):   None,
    (15, 46):   None,
    (15, 47):   None,
    (16, 26):   None,
    (16, 27):   None,
    (16, 28):   None,
    (16, 29):   None,
    (16, 30):   None,
    (16, 31):   None,
    (16, 32):   0.9499,
    (16, 33):   0.0075,
    (16, 34):   0.0425,
    (16, 35):   None,
    (16, 36):   0.0001,
    (16, 37):   None,
    (16, 38):   None,
    (16, 39):   None,
    (16, 40):   None,
    (16, 41):   None,
    (16, 42):   None,
    (16, 43):   None,
    (16, 44):   None,
    (16, 45):   None,
    (16, 46):   None,
    (16, 47):   None,
    (16, 48):   None,
    (16, 49):   None,
    (17, 28):   None,
    (17, 29):   None,
    (17, 30):   None,
    (17, 31):   None,
    (17, 32):   None,
    (17, 33):   None,
    (17, 34):   None,
    (17, 35):   0.7576,
    (17, 36):   None,
    (17, 37):   0.2424,
    (17, 38):   None,
    (17, 39):   None,
    (17, 40):   None,
    (17, 41):   None,
    (17, 42):   None,
    (17, 43):   None,
    (17, 44):   None,
    (17, 45):   None,
    (17, 46):   None,
    (17, 47):   None,
    (17, 48):   None,
    (17, 49):   None,
    (17, 50):   None,
    (17, 51):   None,
    (18, 30):   None,
    (18, 31):   None,
    (18, 32):   None,
    (18, 33):   None,
    (18, 34):   None,
    (18, 35):   None,
    (18, 36):   0.003336,
    (18, 37):   None,
    (18, 38):   0.000629,
    (18, 39):   None,
    (18, 40):   0.996035,
    (18, 41):   None,
    (18, 42):   None,
    (18, 43):   None,
    (18, 44):   None,
    (18, 45):   None,
    (18, 46):   None,
    (18, 47):   None,
    (18, 48):   None,
    (18, 49):   None,
    (18, 50):   None,
    (18, 51):   None,
    (18, 52):   None,
    (18, 53):   None,
    (19, 32):   None,
    (19, 33):   None,
    (19, 34):   None,
    (19, 35):   None,
    (19, 36):   None,
    (19, 37):   None,
    (19, 38):   None,
    (19, 39):   0.932581,
    (19, 40):   0.000117,
    (19, 41):   0.067302,
    (19, 42):   None,
    (19, 43):   None,
    (19, 44):   None,
    (19, 45):   None,
    (19, 46):   None,
    (19, 47):   None,
    (19, 48):   None,
    (19, 49):   None,
    (19, 50):   None,
    (19, 51):   None,
    (19, 52):   None,
    (19, 53):   None,
    (19, 54):   None,
    (19, 55):   None,
    (19, 56):   None,
    (20, 34):   None,
    (20, 35):   None,
    (20, 36):   None,
    (20, 37):   None,
    (20, 38):   None,
    (20, 39):   None,
    (20, 40):   0.96941,
    (20, 41):   None,
    (20, 42):   0.00647,
    (20, 43):   0.00135,
    (20, 44):   0.02086,
    (20, 45):   None,
    (20, 46):   4e-05,
    (20, 47):   None,
    (20, 48):   0.00187,
    (20, 49):   None,
    (20, 50):   None,
    (20, 51):   None,
    (20, 52):   None,
    (20, 53):   None,
    (20, 54):   None,
    (20, 55):   None,
    (20, 56):   None,
    (20, 57):   None,
    (20, 58):   None,
    (21, 36):   None,
    (21, 37):   None,
    (21, 38):   None,
    (21, 39):   None,
    (21, 40):   None,
    (21, 41):   None,
    (21, 42):   None,
    (21, 43):   None,
    (21, 44):   None,
    (21, 45):   1.0,
    (21, 46):   None,
    (21, 47):   None,
    (21, 48):   None,
    (21, 49):   None,
    (21, 50):   None,
    (21, 51):   None,
    (21, 52):   None,
    (21, 53):   None,
    (21, 54):   None,
    (21, 55):   None,
    (21, 56):   None,
    (21, 57):   None,
    (21, 58):   None,
    (21, 59):   None,
    (21, 60):   None,
    (21, 61):   None,
    (22, 38):   None,
    (22, 39):   None,
    (22, 40):   None,
    (22, 41):   None,
    (22, 42):   None,
    (22, 43):   None,
    (22, 44):   None,
    (22, 45):   None,
    (22, 46):   0.0825,
    (22, 47):   0.0744,
    (22, 48):   0.7372,
    (22, 49):   0.0541,
    (22, 50):   0.0518,
    (22, 51):   None,
    (22, 52):   None,
    (22, 53):   None,
    (22, 54):   None,
    (22, 55):   None,
    (22, 56):   None,
    (22, 57):   None,
    (22, 58):   None,
    (22, 59):   None,
    (22, 60):   None,
    (22, 61):   None,
    (22, 62):   None,
    (22, 63):   None,
    (23, 40):   None,
    (23, 41):   None,
    (23, 42):   None,
    (23, 43):   None,
    (23, 44):   None,
    (23, 45):   None,
    (23, 46):   None,
    (23, 47):   None,
    (23, 48):   None,
    (23, 49):   None,
    (23, 50):   0.0025,
    (23, 51):   0.9975,
    (23, 52):   None,
    (23, 53):   None,
    (23, 54):   None,
    (23, 55):   None,
    (23, 56):   None,
    (23, 57):   None,
    (23, 58):   None,
    (23, 59):   None,
    (23, 60):   None,
    (23, 61):   None,
    (23, 62):   None,
    (23, 63):   None,
    (23, 64):   None,
    (23, 65):   None,
    (23, 66):   None,
    (24, 42):   None,
    (24, 43):   None,
    (24, 44):   None,
    (24, 45):   None,
    (24, 46):   None,
    (24, 47):   None,
    (24, 48):   None,
    (24, 49):   None,
    (24, 50):   0.04345,
    (24, 51):   None,
    (24, 52):   0.83789,
    (24, 53):   0.09501,
    (24, 54):   0.02365,
    (24, 55):   None,
    (24, 56):   None,
    (24, 57):   None,
    (24, 58):   None,
    (24, 59):   None,
    (24, 60):   None,
    (24, 61):   None,
    (24, 62):   None,
    (24, 63):   None,
    (24, 64):   None,
    (24, 65):   None,
    (24, 66):   None,
    (24, 67):   None,
    (24, 68):   None,
    (25, 44):   None,
    (25, 45):   None,
    (25, 46):   None,
    (25, 47):   None,
    (25, 48):   None,
    (25, 49):   None,
    (25, 50):   None,
    (25, 51):   None,
    (25, 52):   None,
    (25, 53):   None,
    (25, 54):   None,
    (25, 55):   1.0,
    (25, 56):   None,
    (25, 57):   None,
    (25, 58):   None,
    (25, 59):   None,
    (25, 60):   None,
    (25, 61):   None,
    (25, 62):   None,
    (25, 63):   None,
    (25, 64):   None,
    (25, 65):   None,
    (25, 66):   None,
    (25, 67):   None,
    (25, 68):   None,
    (25, 69):   None,
    (25, 70):   None,
    (25, 71):   None,
    (26, 45):   None,
    (26, 46):   None,
    (26, 47):   None,
    (26, 48):   None,
    (26, 49):   None,
    (26, 50):   None,
    (26, 51):   None,
    (26, 52):   None,
    (26, 53):   None,
    (26, 54):   0.05845,
    (26, 55):   None,
    (26, 56):   0.91754,
    (26, 57):   0.02119,
    (26, 58):   0.00282,
    (26, 59):   None,
    (26, 60):   None,
    (26, 61):   None,
    (26, 62):   None,
    (26, 63):   None,
    (26, 64):   None,
    (26, 65):   None,
    (26, 66):   None,
    (26, 67):   None,
    (26, 68):   None,
    (26, 69):   None,
    (26, 70):   None,
    (26, 71):   None,
    (26, 72):   None,
    (26, 73):   None,
    (26, 74):   None,
    (27, 47):   None,
    (27, 48):   None,
    (27, 49):   None,
    (27, 50):   None,
    (27, 51):   None,
    (27, 52):   None,
    (27, 53):   None,
    (27, 54):   None,
    (27, 55):   None,
    (27, 56):   None,
    (27, 57):   None,
    (27, 58):   None,
    (27, 59):   1.0,
    (27, 60):   None,
    (27, 61):   None,
    (27, 62):   None,
    (27, 63):   None,
    (27, 64):   None,
    (27, 65):   None,
    (27, 66):   None,
    (27, 67):   None,
    (27, 68):   None,
    (27, 69):   None,
    (27, 70):   None,
    (27, 71):   None,
    (27, 72):   None,
    (27, 73):   None,
    (27, 74):   None,
    (27, 75):   None,
    (27, 76):   None,
    (28, 48):   None,
    (28, 49):   None,
    (28, 50):   None,
    (28, 51):   None,
    (28, 52):   None,
    (28, 53):   None,
    (28, 54):   None,
    (28, 55):   None,
    (28, 56):   None,
    (28, 57):   None,
    (28, 58):   0.68077,
    (28, 59):   None,
    (28, 60):   0.26223,
    (28, 61):   0.011399,
    (28, 62):   0.036346,
    (28, 63):   None,
    (28, 64):   0.009255,
    (28, 65):   None,
    (28, 66):   None,
    (28, 67):   None,
    (28, 68):   None,
    (28, 69):   None,
    (28, 70):   None,
    (28, 71):   None,
    (28, 72):   None,
    (28, 73):   None,
    (28, 74):   None,
    (28, 75):   None,
    (28, 76):   None,
    (28, 77):   None,
    (28, 78):   None,
    (28, 79):   None,
    (29, 52):   None,
    (29, 53):   None,
    (29, 54):   None,
    (29, 55):   None,
    (29, 56):   None,
    (29, 57):   None,
    (29, 58):   None,
    (29, 59):   None,
    (29, 60):   None,
    (29, 61):   None,
    (29, 62):   None,
    (29, 63):   0.6915,
    (29, 64):   None,
    (29, 65):   0.3085,
    (29, 66):   None,
    (29, 67):   None,
    (29, 68):   None,
    (29, 69):   None,
    (29, 70):   None,
    (29, 71):   None,
    (29, 72):   None,
    (29, 73):   None,
    (29, 74):   None,
    (29, 75):   None,
    (29, 76):   None,
    (29, 77):   None,
    (29, 78):   None,
    (29, 79):   None,
    (29, 80):   None,
    (29, 81):   None,
    (29, 82):   None,
    (30, 54):   None,
    (30, 55):   None,
    (30, 56):   None,
    (30, 57):   None,
    (30, 58):   None,
    (30, 59):   None,
    (30, 60):   None,
    (30, 61):   None,
    (30, 62):   None,
    (30, 63):   None,
    (30, 64):   0.4917,
    (30, 65):   None,
    (30, 66):   0.2773,
    (30, 67):   0.0404,
    (30, 68):   0.1845,
    (30, 69):   None,
    (30, 70):   0.0061,
    (30, 71):   None,
    (30, 72):   None,
    (30, 73):   None,
    (30, 74):   None,
    (30, 75):   None,
    (30, 76):   None,
    (30, 77):   None,
    (30, 78):   None,
    (30, 79):   None,
    (30, 80):   None,
    (30, 81):   None,
    (30, 82):   None,
    (30, 83):   None,
    (30, 84):   None,
    (30, 85):   None,
    (31, 56):   None,
    (31, 57):   None,
    (31, 58):   None,
    (31, 59):   None,
    (31, 60):   None,
    (31, 61):   None,
    (31, 62):   None,
    (31, 63):   None,
    (31, 64):   None,
    (31, 65):   None,
    (31, 66):   None,
    (31, 67):   None,
    (31, 68):   None,
    (31, 69):   0.60108,
    (31, 70):   None,
    (31, 71):   0.39892,
    (31, 72):   None,
    (31, 73):   None,
    (31, 74):   None,
    (31, 75):   None,
    (31, 76):   None,
    (31, 77):   None,
    (31, 78):   None,
    (31, 79):   None,
    (31, 80):   None,
    (31, 81):   None,
    (31, 82):   None,
    (31, 83):   None,
    (31, 84):   None,
    (31, 85):   None,
    (31, 86):   None,
    (31, 87):   None,
    (32, 58):   None,
    (32, 59):   None,
    (32, 60):   None,
    (32, 61):   None,
    (32, 62):   None,
    (32, 63):   None,
    (32, 64):   None,
    (32, 65):   None,
    (32, 66):   None,
    (32, 67):   None,
    (32, 68):   None,
    (32, 69):   None,
    (32, 70):   0.2057,
    (32, 71):   None,
    (32, 72):   0.2745,
    (32, 73):   0.0775,
    (32, 74):   0.365,
    (32, 75):   None,
    (32, 76):   0.0773,
    (32, 77):   None,
    (32, 78):   None,
    (32, 79):   None,
    (32, 80):   None,
    (32, 81):   None,
    (32, 82):   None,
    (32, 83):   None,
    (32, 84):   None,
    (32, 85):   None,
    (32, 86):   None,
    (32, 87):   None,
    (32, 88):   None,
    (32, 89):   None,
    (32, 90):   None,
    (33, 60):   None,
    (33, 61):   None,
    (33, 62):   None,
    (33, 63):   None,
    (33, 64):   None,
    (33, 65):   None,
    (33, 66):   None,
    (33, 67):   None,
    (33, 68):   None,
    (33, 69):   None,
    (33, 70):   None,
    (33, 71):   None,
    (33, 72):   None,
    (33, 73):   None,
    (33, 74):   None,
    (33, 75):   1.0,
    (33, 76):   None,
    (33, 77):   None,
    (33, 78):   None,
    (33, 79):   None,
    (33, 80):   None,
    (33, 81):   None,
    (33, 82):   None,
    (33, 83):   None,
    (33, 84):   None,
    (33, 85):   None,
    (33, 86):   None,
    (33, 87):   None,
    (33, 88):   None,
    (33, 89):   None,
    (33, 90):   None,
    (33, 91):   None,
    (33, 92):   None,
    (34, 64):   None,
    (34, 65):   None,
    (34, 66):   None,
    (34, 67):   None,
    (34, 68):   None,
    (34, 69):   None,
    (34, 70):   None,
    (34, 71):   None,
    (34, 72):   None,
    (34, 73):   None,
    (34, 74):   0.0089,
    (34, 75):   None,
    (34, 76):   0.0937,
    (34, 77):   0.0763,
    (34, 78):   0.2377,
    (34, 79):   None,
    (34, 80):   0.4961,
    (34, 81):   None,
    (34, 82):   0.0873,
    (34, 83):   None,
    (34, 84):   None,
    (34, 85):   None,
    (34, 86):   None,
    (34, 87):   None,
    (34, 88):   None,
    (34, 89):   None,
    (34, 90):   None,
    (34, 91):   None,
    (34, 92):   None,
    (34, 93):   None,
    (34, 94):   None,
    (34, 95):   None,
    (35, 67):   None,
    (35, 68):   None,
    (35, 69):   None,
    (35, 70):   None,
    (35, 71):   None,
    (35, 72):   None,
    (35, 73):   None,
    (35, 74):   None,
    (35, 75):   None,
    (35, 76):   None,
    (35, 77):   None,
    (35, 78):   None,
    (35, 79):   0.5069,
    (35, 80):   None,
    (35, 81):   0.4931,
    (35, 82):   None,
    (35, 83):   None,
    (35, 84):   None,
    (35, 85):   None,
    (35, 86):   None,
    (35, 87):   None,
    (35, 88):   None,
    (35, 89):   None,
    (35, 90):   None,
    (35, 91):   None,
    (35, 92):   None,
    (35, 93):   None,
    (35, 94):   None,
    (35, 95):   None,
    (35, 96):   None,
    (35, 97):   None,
    (35, 98):   None,
    (36, 69):   None,
    (36, 70):   None,
    (36, 71):   None,
    (36, 72):   None,
    (36, 73):   None,
    (36, 74):   None,
    (36, 75):   None,
    (36, 76):   None,
    (36, 77):   None,
    (36, 78):   0.00355,
    (36, 79):   None,
    (36, 80):   0.02286,
    (36, 81):   None,
    (36, 82):   0.11593,
    (36, 83):   0.115,
    (36, 84):   0.56987,
    (36, 85):   None,
    (36, 86):   0.17279,
    (36, 87):   None,
    (36, 88):   None,
    (36, 89):   None,
    (36, 90):   None,
    (36, 91):   None,
    (36, 92):   None,
    (36, 93):   None,
    (36, 94):   None,
    (36, 95):   None,
    (36, 96):   None,
    (36, 97):   None,
    (36, 98):   None,
    (36, 99):   None,
    (36, 100):  None,
    (36, 101):  None,
    (37, 71):   None,
    (37, 72):   None,
    (37, 73):   None,
    (37, 74):   None,
    (37, 75):   None,
    (37, 76):   None,
    (37, 77):   None,
    (37, 78):   None,
    (37, 79):   None,
    (37, 80):   None,
    (37, 81):   None,
    (37, 82):   None,
    (37, 83):   None,
    (37, 84):   None,
    (37, 85):   0.7217,
    (37, 86):   None,
    (37, 87):   0.2783,
    (37, 88):   None,
    (37, 89):   None,
    (37, 90):   None,
    (37, 91):   None,
    (37, 92):   None,
    (37, 93):   None,
    (37, 94):   None,
    (37, 95):   None,
    (37, 96):   None,
    (37, 97):   None,
    (37, 98):   None,
    (37, 99):   None,
    (37, 100):  None,
    (37, 101):  None,
    (37, 102):  None,
    (37, 103):  None,
    (38, 73):   None,
    (38, 74):   None,
    (38, 75):   None,
    (38, 76):   None,
    (38, 77):   None,
    (38, 78):   None,
    (38, 79):   None,
    (38, 80):   None,
    (38, 81):   None,
    (38, 82):   None,
    (38, 83):   None,
    (38, 84):   0.0056,
    (38, 85):   None,
    (38, 86):   0.0986,
    (38, 87):   0.07,
    (38, 88):   0.8258,
    (38, 89):   None,
    (38, 90):   None,
    (38, 91):   None,
    (38, 92):   None,
    (38, 93):   None,
    (38, 94):   None,
    (38, 95):   None,
    (38, 96):   None,
    (38, 97):   None,
    (38, 98):   None,
    (38, 99):   None,
    (38, 100):  None,
    (38, 101):  None,
    (38, 102):  None,
    (38, 103):  None,
    (38, 104):  None,
    (38, 105):  None,
    (38, 106):  None,
    (38, 107):  None,
    (39, 76):   None,
    (39, 77):   None,
    (39, 78):   None,
    (39, 79):   None,
    (39, 80):   None,
    (39, 81):   None,
    (39, 82):   None,
    (39, 83):   None,
    (39, 84):   None,
    (39, 85):   None,
    (39, 86):   None,
    (39, 87):   None,
    (39, 88):   None,
    (39, 89):   1.0,
    (39, 90):   None,
    (39, 91):   None,
    (39, 92):   None,
    (39, 93):   None,
    (39, 94):   None,
    (39, 95):   None,
    (39, 96):   None,
    (39, 97):   None,
    (39, 98):   None,
    (39, 99):   None,
    (39, 100):  None,
    (39, 101):  None,
    (39, 102):  None,
    (39, 103):  None,
    (39, 104):  None,
    (39, 105):  None,
    (39, 106):  None,
    (39, 107):  None,
    (39, 108):  None,
    (39, 109):  None,
    (40, 78):   None,
    (40, 79):   None,
    (40, 80):   None,
    (40, 81):   None,
    (40, 82):   None,
    (40, 83):   None,
    (40, 84):   None,
    (40, 85):   None,
    (40, 86):   None,
    (40, 87):   None,
    (40, 88):   None,
    (40, 89):   None,
    (40, 90):   0.5145,
    (40, 91):   0.1122,
    (40, 92):   0.1715,
    (40, 93):   None,
    (40, 94):   0.1738,
    (40, 95):   None,
    (40, 96):   0.028,
    (40, 97):   None,
    (40, 98):   None,
    (40, 99):   None,
    (40, 100):  None,
    (40, 101):  None,
    (40, 102):  None,
    (40, 103):  None,
    (40, 104):  None,
    (40, 105):  None,
    (40, 106):  None,
    (40, 107):  None,
    (40, 108):  None,
    (40, 109):  None,
    (40, 110):  None,
    (40, 111):  None,
    (40, 112):  None,
    (41, 81):   None,
    (41, 82):   None,
    (41, 83):   None,
    (41, 84):   None,
    (41, 85):   None,
    (41, 86):   None,
    (41, 87):   None,
    (41, 88):   None,
    (41, 89):   None,
    (41, 90):   None,
    (41, 91):   None,
    (41, 92):   None,
    (41, 93):   1.0,
    (41, 94):   None,
    (41, 95):   None,
    (41, 96):   None,
    (41, 97):   None,
    (41, 98):   None,
    (41, 99):   None,
    (41, 100):  None,
    (41, 101):  None,
    (41, 102):  None,
    (41, 103):  None,
    (41, 104):  None,
    (41, 105):  None,
    (41, 106):  None,
    (41, 107):  None,
    (41, 108):  None,
    (41, 109):  None,
    (41, 110):  None,
    (41, 111):  None,
    (41, 112):  None,
    (41, 113):  None,
    (41, 114):  None,
    (41, 115):  None,
    (42, 83):   None,
    (42, 84):   None,
    (42, 85):   None,
    (42, 86):   None,
    (42, 87):   None,
    (42, 88):   None,
    (42, 89):   None,
    (42, 90):   None,
    (42, 91):   None,
    (42, 92):   0.1453,
    (42, 93):   None,
    (42, 94):   0.0915,
    (42, 95):   0.1584,
    (42, 96):   0.1667,
    (42, 97):   0.096,
    (42, 98):   0.2439,
    (42, 99):   None,
    (42, 100):  0.0982,
    (42, 101):  None,
    (42, 102):  None,
    (42, 103):  None,
    (42, 104):  None,
    (42, 105):  None,
    (42, 106):  None,
    (42, 107):  None,
    (42, 108):  None,
    (42, 109):  None,
    (42, 110):  None,
    (42, 111):  None,
    (42, 112):  None,
    (42, 113):  None,
    (42, 114):  None,
    (42, 115):  None,
    (42, 116):  None,
    (42, 117):  None,
    (43, 85):   None,
    (43, 86):   None,
    (43, 87):   None,
    (43, 88):   None,
    (43, 89):   None,
    (43, 90):   None,
    (43, 91):   None,
    (43, 92):   None,
    (43, 93):   None,
    (43, 94):   None,
    (43, 95):   None,
    (43, 96):   None,
    (43, 97):   None,
    (43, 98):   None,
    (43, 99):   None,
    (43, 100):  None,
    (43, 101):  None,
    (43, 102):  None,
    (43, 103):  None,
    (43, 104):  None,
    (43, 105):  None,
    (43, 106):  None,
    (43, 107):  None,
    (43, 108):  None,
    (43, 109):  None,
    (43, 110):  None,
    (43, 111):  None,
    (43, 112):  None,
    (43, 113):  None,
    (43, 114):  None,
    (43, 115):  None,
    (43, 116):  None,
    (43, 117):  None,
    (43, 118):  None,
    (43, 119):  None,
    (43, 120):  None,
    (44, 87):   None,
    (44, 88):   None,
    (44, 89):   None,
    (44, 90):   None,
    (44, 91):   None,
    (44, 92):   None,
    (44, 93):   None,
    (44, 94):   None,
    (44, 95):   None,
    (44, 96):   0.0554,
    (44, 97):   None,
    (44, 98):   0.0187,
    (44, 99):   0.1276,
    (44, 100):  0.126,
    (44, 101):  0.1706,
    (44, 102):  0.3155,
    (44, 103):  None,
    (44, 104):  0.1862,
    (44, 105):  None,
    (44, 106):  None,
    (44, 107):  None,
    (44, 108):  None,
    (44, 109):  None,
    (44, 110):  None,
    (44, 111):  None,
    (44, 112):  None,
    (44, 113):  None,
    (44, 114):  None,
    (44, 115):  None,
    (44, 116):  None,
    (44, 117):  None,
    (44, 118):  None,
    (44, 119):  None,
    (44, 120):  None,
    (44, 121):  None,
    (44, 122):  None,
    (44, 123):  None,
    (44, 124):  None,
    (45, 89):   None,
    (45, 90):   None,
    (45, 91):   None,
    (45, 92):   None,
    (45, 93):   None,
    (45, 94):   None,
    (45, 95):   None,
    (45, 96):   None,
    (45, 97):   None,
    (45, 98):   None,
    (45, 99):   None,
    (45, 100):  None,
    (45, 101):  None,
    (45, 102):  None,
    (45, 103):  1.0,
    (45, 104):  None,
    (45, 105):  None,
    (45, 106):  None,
    (45, 107):  None,
    (45, 108):  None,
    (45, 109):  None,
    (45, 110):  None,
    (45, 111):  None,
    (45, 112):  None,
    (45, 113):  None,
    (45, 114):  None,
    (45, 115):  None,
    (45, 116):  None,
    (45, 117):  None,
    (45, 118):  None,
    (45, 119):  None,
    (45, 120):  None,
    (45, 121):  None,
    (45, 122):  None,
    (45, 123):  None,
    (45, 124):  None,
    (45, 125):  None,
    (45, 126):  None,
    (46, 91):   None,
    (46, 92):   None,
    (46, 93):   None,
    (46, 94):   None,
    (46, 95):   None,
    (46, 96):   None,
    (46, 97):   None,
    (46, 98):   None,
    (46, 99):   None,
    (46, 100):  None,
    (46, 101):  None,
    (46, 102):  0.0102,
    (46, 103):  None,
    (46, 104):  0.1114,
    (46, 105):  0.2233,
    (46, 106):  0.2733,
    (46, 107):  None,
    (46, 108):  0.2646,
    (46, 109):  None,
    (46, 110):  0.1172,
    (46, 111):  None,
    (46, 112):  None,
    (46, 113):  None,
    (46, 114):  None,
    (46, 115):  None,
    (46, 116):  None,
    (46, 117):  None,
    (46, 118):  None,
    (46, 119):  None,
    (46, 120):  None,
    (46, 121):  None,
    (46, 122):  None,
    (46, 123):  None,
    (46, 124):  None,
    (46, 125):  None,
    (46, 126):  None,
    (46, 127):  None,
    (46, 128):  None,
    (47, 93):   None,
    (47, 94):   None,
    (47, 95):   None,
    (47, 96):   None,
    (47, 97):   None,
    (47, 98):   None,
    (47, 99):   None,
    (47, 100):  None,
    (47, 101):  None,
    (47, 102):  None,
    (47, 103):  None,
    (47, 104):  None,
    (47, 105):  None,
    (47, 106):  None,
    (47, 107):  0.51839,
    (47, 108):  None,
    (47, 109):  0.48161,
    (47, 110):  None,
    (47, 111):  None,
    (47, 112):  None,
    (47, 113):  None,
    (47, 114):  None,
    (47, 115):  None,
    (47, 116):  None,
    (47, 117):  None,
    (47, 118):  None,
    (47, 119):  None,
    (47, 120):  None,
    (47, 121):  None,
    (47, 122):  None,
    (47, 123):  None,
    (47, 124):  None,
    (47, 125):  None,
    (47, 126):  None,
    (47, 127):  None,
    (47, 128):  None,
    (47, 129):  None,
    (47, 130):  None,
    (48, 95):   None,
    (48, 96):   None,
    (48, 97):   None,
    (48, 98):   None,
    (48, 99):   None,
    (48, 100):  None,
    (48, 101):  None,
    (48, 102):  None,
    (48, 103):  None,
    (48, 104):  None,
    (48, 105):  None,
    (48, 106):  0.0125,
    (48, 107):  None,
    (48, 108):  0.0089,
    (48, 109):  None,
    (48, 110):  0.1249,
    (48, 111):  0.128,
    (48, 112):  0.2413,
    (48, 113):  0.1222,
    (48, 114):  0.2873,
    (48, 115):  None,
    (48, 116):  0.0749,
    (48, 117):  None,
    (48, 118):  None,
    (48, 119):  None,
    (48, 120):  None,
    (48, 121):  None,
    (48, 122):  None,
    (48, 123):  None,
    (48, 124):  None,
    (48, 125):  None,
    (48, 126):  None,
    (48, 127):  None,
    (48, 128):  None,
    (48, 129):  None,
    (48, 130):  None,
    (48, 131):  None,
    (48, 132):  None,
    (48, 133):  None,
    (49, 97):   None,
    (49, 98):   None,
    (49, 99):   None,
    (49, 100):  None,
    (49, 101):  None,
    (49, 102):  None,
    (49, 103):  None,
    (49, 104):  None,
    (49, 105):  None,
    (49, 106):  None,
    (49, 107):  None,
    (49, 108):  None,
    (49, 109):  None,
    (49, 110):  None,
    (49, 111):  None,
    (49, 112):  None,
    (49, 113):  0.0429,
    (49, 114):  None,
    (49, 115):  0.9571,
    (49, 116):  None,
    (49, 117):  None,
    (49, 118):  None,
    (49, 119):  None,
    (49, 120):  None,
    (49, 121):  None,
    (49, 122):  None,
    (49, 123):  None,
    (49, 124):  None,
    (49, 125):  None,
    (49, 126):  None,
    (49, 127):  None,
    (49, 128):  None,
    (49, 129):  None,
    (49, 130):  None,
    (49, 131):  None,
    (49, 132):  None,
    (49, 133):  None,
    (49, 134):  None,
    (49, 135):  None,
    (50, 99):   None,
    (50, 100):  None,
    (50, 101):  None,
    (50, 102):  None,
    (50, 103):  None,
    (50, 104):  None,
    (50, 105):  None,
    (50, 106):  None,
    (50, 107):  None,
    (50, 108):  None,
    (50, 109):  None,
    (50, 110):  None,
    (50, 111):  None,
    (50, 112):  0.0097,
    (50, 113):  None,
    (50, 114):  0.0066,
    (50, 115):  0.0034,
    (50, 116):  0.1454,
    (50, 117):  0.0768,
    (50, 118):  0.2422,
    (50, 119):  0.0859,
    (50, 120):  0.3258,
    (50, 121):  None,
    (50, 122):  0.0463,
    (50, 123):  None,
    (50, 124):  0.0579,
    (50, 125):  None,
    (50, 126):  None,
    (50, 127):  None,
    (50, 128):  None,
    (50, 129):  None,
    (50, 130):  None,
    (50, 131):  None,
    (50, 132):  None,
    (50, 133):  None,
    (50, 134):  None,
    (50, 135):  None,
    (50, 136):  None,
    (50, 137):  None,
    (50, 138):  None,
    (51, 103):  None,
    (51, 104):  None,
    (51, 105):  None,
    (51, 106):  None,
    (51, 107):  None,
    (51, 108):  None,
    (51, 109):  None,
    (51, 110):  None,
    (51, 111):  None,
    (51, 112):  None,
    (51, 113):  None,
    (51, 114):  None,
    (51, 115):  None,
    (51, 116):  None,
    (51, 117):  None,
    (51, 118):  None,
    (51, 119):  None,
    (51, 120):  None,
    (51, 121):  0.5721,
    (51, 122):  None,
    (51, 123):  0.4279,
    (51, 124):  None,
    (51, 125):  None,
    (51, 126):  None,
    (51, 127):  None,
    (51, 128):  None,
    (51, 129):  None,
    (51, 130):  None,
    (51, 131):  None,
    (51, 132):  None,
    (51, 133):  None,
    (51, 134):  None,
    (51, 135):  None,
    (51, 136):  None,
    (51, 137):  None,
    (51, 138):  None,
    (51, 139):  None,
    (51, 140):  None,
    (52, 105):  None,
    (52, 106):  None,
    (52, 107):  None,
    (52, 108):  None,
    (52, 109):  None,
    (52, 110):  None,
    (52, 111):  None,
    (52, 112):  None,
    (52, 113):  None,
    (52, 114):  None,
    (52, 115):  None,
    (52, 116):  None,
    (52, 117):  None,
    (52, 118):  None,
    (52, 119):  None,
    (52, 120):  0.0009,
    (52, 121):  None,
    (52, 122):  0.0255,
    (52, 123):  0.0089,
    (52, 124):  0.0474,
    (52, 125):  0.0707,
    (52, 126):  0.1884,
    (52, 127):  None,
    (52, 128):  0.3174,
    (52, 129):  None,
    (52, 130):  0.3408,
    (52, 131):  None,
    (52, 132):  None,
    (52, 133):  None,
    (52, 134):  None,
    (52, 135):  None,
    (52, 136):  None,
    (52, 137):  None,
    (52, 138):  None,
    (52, 139):  None,
    (52, 140):  None,
    (52, 141):  None,
    (52, 142):  None,
    (52, 143):  None,
    (53, 107):  None,
    (53, 108):  None,
    (53, 109):  None,
    (53, 110):  None,
    (53, 111):  None,
    (53, 112):  None,
    (53, 113):  None,
    (53, 114):  None,
    (53, 115):  None,
    (53, 116):  None,
    (53, 117):  None,
    (53, 118):  None,
    (53, 119):  None,
    (53, 120):  None,
    (53, 121):  None,
    (53, 122):  None,
    (53, 123):  None,
    (53, 124):  None,
    (53, 125):  None,
    (53, 126):  None,
    (53, 127):  1.0,
    (53, 128):  None,
    (53, 129):  None,
    (53, 130):  None,
    (53, 131):  None,
    (53, 132):  None,
    (53, 133):  None,
    (53, 134):  None,
    (53, 135):  None,
    (53, 136):  None,
    (53, 137):  None,
    (53, 138):  None,
    (53, 139):  None,
    (53, 140):  None,
    (53, 141):  None,
    (53, 142):  None,
    (53, 143):  None,
    (53, 144):  None,
    (53, 145):  None,
    (54, 109):  None,
    (54, 110):  None,
    (54, 111):  None,
    (54, 112):  None,
    (54, 113):  None,
    (54, 114):  None,
    (54, 115):  None,
    (54, 116):  None,
    (54, 117):  None,
    (54, 118):  None,
    (54, 119):  None,
    (54, 120):  None,
    (54, 121):  None,
    (54, 122):  None,
    (54, 123):  None,
    (54, 124):  0.000952,
    (54, 125):  None,
    (54, 126):  0.00089,
    (54, 127):  None,
    (54, 128):  0.019102,
    (54, 129):  0.264006,
    (54, 130):  0.04071,
    (54, 131):  0.212324,
    (54, 132):  0.269086,
    (54, 133):  None,
    (54, 134):  0.104357,
    (54, 135):  None,
    (54, 136):  0.088573,
    (54, 137):  None,
    (54, 138):  None,
    (54, 139):  None,
    (54, 140):  None,
    (54, 141):  None,
    (54, 142):  None,
    (54, 143):  None,
    (54, 144):  None,
    (54, 145):  None,
    (54, 146):  None,
    (54, 147):  None,
    (54, 148):  None,
    (55, 112):  None,
    (55, 113):  None,
    (55, 114):  None,
    (55, 115):  None,
    (55, 116):  None,
    (55, 117):  None,
    (55, 118):  None,
    (55, 119):  None,
    (55, 120):  None,
    (55, 121):  None,
    (55, 122):  None,
    (55, 123):  None,
    (55, 124):  None,
    (55, 125):  None,
    (55, 126):  None,
    (55, 127):  None,
    (55, 128):  None,
    (55, 129):  None,
    (55, 130):  None,
    (55, 131):  None,
    (55, 132):  None,
    (55, 133):  1.0,
    (55, 134):  None,
    (55, 135):  None,
    (55, 136):  None,
    (55, 137):  None,
    (55, 138):  None,
    (55, 139):  None,
    (55, 140):  None,
    (55, 141):  None,
    (55, 142):  None,
    (55, 143):  None,
    (55, 144):  None,
    (55, 145):  None,
    (55, 146):  None,
    (55, 147):  None,
    (55, 148):  None,
    (55, 149):  None,
    (55, 150):  None,
    (55, 151):  None,
    (56, 114):  None,
    (56, 115):  None,
    (56, 116):  None,
    (56, 117):  None,
    (56, 118):  None,
    (56, 119):  None,
    (56, 120):  None,
    (56, 121):  None,
    (56, 122):  None,
    (56, 123):  None,
    (56, 124):  None,
    (56, 125):  None,
    (56, 126):  None,
    (56, 127):  None,
    (56, 128):  None,
    (56, 129):  None,
    (56, 130):  0.00106,
    (56, 131):  None,
    (56, 132):  0.00101,
    (56, 133):  None,
    (56, 134):  0.02417,
    (56, 135):  0.06592,
    (56, 136):  0.07854,
    (56, 137):  0.11232,
    (56, 138):  0.71698,
    (56, 139):  None,
    (56, 140):  None,
    (56, 141):  None,
    (56, 142):  None,
    (56, 143):  None,
    (56, 144):  None,
    (56, 145):  None,
    (56, 146):  None,
    (56, 147):  None,
    (56, 148):  None,
    (56, 149):  None,
    (56, 150):  None,
    (56, 151):  None,
    (56, 152):  None,
    (56, 153):  None,
    (57, 116):  None,
    (57, 117):  None,
    (57, 118):  None,
    (57, 119):  None,
    (57, 120):  None,
    (57, 121):  None,
    (57, 122):  None,
    (57, 123):  None,
    (57, 124):  None,
    (57, 125):  None,
    (57, 126):  None,
    (57, 127):  None,
    (57, 128):  None,
    (57, 129):  None,
    (57, 130):  None,
    (57, 131):  None,
    (57, 132):  None,
    (57, 133):  None,
    (57, 134):  None,
    (57, 135):  None,
    (57, 136):  None,
    (57, 137):  None,
    (57, 138):  0.0008881,
    (57, 139):  0.9991119,
    (57, 140):  None,
    (57, 141):  None,
    (57, 142):  None,
    (57, 143):  None,
    (57, 144):  None,
    (57, 145):  None,
    (57, 146):  None,
    (57, 147):  None,
    (57, 148):  None,
    (57, 149):  None,
    (57, 150):  None,
    (57, 151):  None,
    (57, 152):  None,
    (57, 153):  None,
    (57, 154):  None,
    (57, 155):  None,
    (58, 119):  None,
    (58, 120):  None,
    (58, 121):  None,
    (58, 122):  None,
    (58, 123):  None,
    (58, 124):  None,
    (58, 125):  None,
    (58, 126):  None,
    (58, 127):  None,
    (58, 128):  None,
    (58, 129):  None,
    (58, 130):  None,
    (58, 131):  None,
    (58, 132):  None,
    (58, 133):  None,
    (58, 134):  None,
    (58, 135):  None,
    (58, 136):  0.00185,
    (58, 137):  None,
    (58, 138):  0.00251,
    (58, 139):  None,
    (58, 140):  0.8845,
    (58, 141):  None,
    (58, 142):  0.11114,
    (58, 143):  None,
    (58, 144):  None,
    (58, 145):  None,
    (58, 146):  None,
    (58, 147):  None,
    (58, 148):  None,
    (58, 149):  None,
    (58, 150):  None,
    (58, 151):  None,
    (58, 152):  None,
    (58, 153):  None,
    (58, 154):  None,
    (58, 155):  None,
    (58, 156):  None,
    (58, 157):  None,
    (59, 121):  None,
    (59, 122):  None,
    (59, 123):  None,
    (59, 124):  None,
    (59, 125):  None,
    (59, 126):  None,
    (59, 127):  None,
    (59, 128):  None,
    (59, 129):  None,
    (59, 130):  None,
    (59, 131):  None,
    (59, 132):  None,
    (59, 133):  None,
    (59, 134):  None,
    (59, 135):  None,
    (59, 136):  None,
    (59, 137):  None,
    (59, 138):  None,
    (59, 139):  None,
    (59, 140):  None,
    (59, 141):  1.0,
    (59, 142):  None,
    (59, 143):  None,
    (59, 144):  None,
    (59, 145):  None,
    (59, 146):  None,
    (59, 147):  None,
    (59, 148):  None,
    (59, 149):  None,
    (59, 150):  None,
    (59, 151):  None,
    (59, 152):  None,
    (59, 153):  None,
    (59, 154):  None,
    (59, 155):  None,
    (59, 156):  None,
    (59, 157):  None,
    (59, 158):  None,
    (59, 159):  None,
    (60, 124):  None,
    (60, 125):  None,
    (60, 126):  None,
    (60, 127):  None,
    (60, 128):  None,
    (60, 129):  None,
    (60, 130):  None,
    (60, 131):  None,
    (60, 132):  None,
    (60, 133):  None,
    (60, 134):  None,
    (60, 135):  None,
    (60, 136):  None,
    (60, 137):  None,
    (60, 138):  None,
    (60, 139):  None,
    (60, 140):  None,
    (60, 141):  None,
    (60, 142):  0.27152,
    (60, 143):  0.12174,
    (60, 144):  0.23798,
    (60, 145):  0.08293,
    (60, 146):  0.17189,
    (60, 147):  None,
    (60, 148):  0.05756,
    (60, 149):  None,
    (60, 150):  0.05638,
    (60, 151):  None,
    (60, 152):  None,
    (60, 153):  None,
    (60, 154):  None,
    (60, 155):  None,
    (60, 156):  None,
    (60, 157):  None,
    (60, 158):  None,
    (60, 159):  None,
    (60, 160):  None,
    (60, 161):  None,
    (61, 126):  None,
    (61, 127):  None,
    (61, 128):  None,
    (61, 129):  None,
    (61, 130):  None,
    (61, 131):  None,
    (61, 132):  None,
    (61, 133):  None,
    (61, 134):  None,
    (61, 135):  None,
    (61, 136):  None,
    (61, 137):  None,
    (61, 138):  None,
    (61, 139):  None,
    (61, 140):  None,
    (61, 141):  None,
    (61, 142):  None,
    (61, 143):  None,
    (61, 144):  None,
    (61, 145):  None,
    (61, 146):  None,
    (61, 147):  None,
    (61, 148):  None,
    (61, 149):  None,
    (61, 150):  None,
    (61, 151):  None,
    (61, 152):  None,
    (61, 153):  None,
    (61, 154):  None,
    (61, 155):  None,
    (61, 156):  None,
    (61, 157):  None,
    (61, 158):  None,
    (61, 159):  None,
    (61, 160):  None,
    (61, 161):  None,
    (61, 162):  None,
    (61, 163):  None,
    (62, 128):  None,
    (62, 129):  None,
    (62, 130):  None,
    (62, 131):  None,
    (62, 132):  None,
    (62, 133):  None,
    (62, 134):  None,
    (62, 135):  None,
    (62, 136):  None,
    (62, 137):  None,
    (62, 138):  None,
    (62, 139):  None,
    (62, 140):  None,
    (62, 141):  None,
    (62, 142):  None,
    (62, 143):  None,
    (62, 144):  0.0307,
    (62, 145):  None,
    (62, 146):  None,
    (62, 147):  0.1499,
    (62, 148):  0.1124,
    (62, 149):  0.1382,
    (62, 150):  0.0738,
    (62, 151):  None,
    (62, 152):  0.2675,
    (62, 153):  None,
    (62, 154):  0.2275,
    (62, 155):  None,
    (62, 156):  None,
    (62, 157):  None,
    (62, 158):  None,
    (62, 159):  None,
    (62, 160):  None,
    (62, 161):  None,
    (62, 162):  None,
    (62, 163):  None,
    (62, 164):  None,
    (62, 165):  None,
    (63, 130):  None,
    (63, 131):  None,
    (63, 132):  None,
    (63, 133):  None,
    (63, 134):  None,
    (63, 135):  None,
    (63, 136):  None,
    (63, 137):  None,
    (63, 138):  None,
    (63, 139):  None,
    (63, 140):  None,
    (63, 141):  None,
    (63, 142):  None,
    (63, 143):  None,
    (63, 144):  None,
    (63, 145):  None,
    (63, 146):  None,
    (63, 147):  None,
    (63, 148):  None,
    (63, 149):  None,
    (63, 150):  None,
    (63, 151):  0.4781,
    (63, 152):  None,
    (63, 153):  0.5219,
    (63, 154):  None,
    (63, 155):  None,
    (63, 156):  None,
    (63, 157):  None,
    (63, 158):  None,
    (63, 159):  None,
    (63, 160):  None,
    (63, 161):  None,
    (63, 162):  None,
    (63, 163):  None,
    (63, 164):  None,
    (63, 165):  None,
    (63, 166):  None,
    (63, 167):  None,
    (64, 133):  None,
    (64, 134):  None,
    (64, 135):  None,
    (64, 136):  None,
    (64, 137):  None,
    (64, 138):  None,
    (64, 139):  None,
    (64, 140):  None,
    (64, 141):  None,
    (64, 142):  None,
    (64, 143):  None,
    (64, 144):  None,
    (64, 145):  None,
    (64, 146):  None,
    (64, 147):  None,
    (64, 148):  None,
    (64, 149):  None,
    (64, 150):  None,
    (64, 151):  None,
    (64, 152):  0.002,
    (64, 153):  None,
    (64, 154):  0.0218,
    (64, 155):  0.148,
    (64, 156):  0.2047,
    (64, 157):  0.1565,
    (64, 158):  0.2484,
    (64, 159):  None,
    (64, 160):  0.2186,
    (64, 161):  None,
    (64, 162):  None,
    (64, 163):  None,
    (64, 164):  None,
    (64, 165):  None,
    (64, 166):  None,
    (64, 167):  None,
    (64, 168):  None,
    (64, 169):  None,
    (65, 135):  None,
    (65, 136):  None,
    (65, 137):  None,
    (65, 138):  None,
    (65, 139):  None,
    (65, 140):  None,
    (65, 141):  None,
    (65, 142):  None,
    (65, 143):  None,
    (65, 144):  None,
    (65, 145):  None,
    (65, 146):  None,
    (65, 147):  None,
    (65, 148):  None,
    (65, 149):  None,
    (65, 150):  None,
    (65, 151):  None,
    (65, 152):  None,
    (65, 153):  None,
    (65, 154):  None,
    (65, 155):  None,
    (65, 156):  None,
    (65, 157):  None,
    (65, 158):  None,
    (65, 159):  1.0,
    (65, 160):  None,
    (65, 161):  None,
    (65, 162):  None,
    (65, 163):  None,
    (65, 164):  None,
    (65, 165):  None,
    (65, 166):  None,
    (65, 167):  None,
    (65, 168):  None,
    (65, 169):  None,
    (65, 170):  None,
    (65, 171):  None,
    (66, 138):  None,
    (66, 139):  None,
    (66, 140):  None,
    (66, 141):  None,
    (66, 142):  None,
    (66, 143):  None,
    (66, 144):  None,
    (66, 145):  None,
    (66, 146):  None,
    (66, 147):  None,
    (66, 148):  None,
    (66, 149):  None,
    (66, 150):  None,
    (66, 151):  None,
    (66, 152):  None,
    (66, 153):  None,
    (66, 154):  None,
    (66, 155):  None,
    (66, 156):  0.00056,
    (66, 157):  None,
    (66, 158):  0.00095,
    (66, 159):  None,
    (66, 160):  0.02329,
    (66, 161):  0.18889,
    (66, 162):  0.25475,
    (66, 163):  0.24896,
    (66, 164):  0.2826,
    (66, 165):  None,
    (66, 166):  None,
    (66, 167):  None,
    (66, 168):  None,
    (66, 169):  None,
    (66, 170):  None,
    (66, 171):  None,
    (66, 172):  None,
    (66, 173):  None,
    (67, 140):  None,
    (67, 141):  None,
    (67, 142):  None,
    (67, 143):  None,
    (67, 144):  None,
    (67, 145):  None,
    (67, 146):  None,
    (67, 147):  None,
    (67, 148):  None,
    (67, 149):  None,
    (67, 150):  None,
    (67, 151):  None,
    (67, 152):  None,
    (67, 153):  None,
    (67, 154):  None,
    (67, 155):  None,
    (67, 156):  None,
    (67, 157):  None,
    (67, 158):  None,
    (67, 159):  None,
    (67, 160):  None,
    (67, 161):  None,
    (67, 162):  None,
    (67, 163):  None,
    (67, 164):  None,
    (67, 165):  1.0,
    (67, 166):  None,
    (67, 167):  None,
    (67, 168):  None,
    (67, 169):  None,
    (67, 170):  None,
    (67, 171):  None,
    (67, 172):  None,
    (67, 173):  None,
    (67, 174):  None,
    (67, 175):  None,
    (68, 142):  None,
    (68, 143):  None,
    (68, 144):  None,
    (68, 145):  None,
    (68, 146):  None,
    (68, 147):  None,
    (68, 148):  None,
    (68, 149):  None,
    (68, 150):  None,
    (68, 151):  None,
    (68, 152):  None,
    (68, 153):  None,
    (68, 154):  None,
    (68, 155):  None,
    (68, 156):  None,
    (68, 157):  None,
    (68, 158):  None,
    (68, 159):  None,
    (68, 160):  None,
    (68, 161):  None,
    (68, 162):  0.00139,
    (68, 163):  None,
    (68, 164):  0.01601,
    (68, 165):  None,
    (68, 166):  0.33503,
    (68, 167):  0.22869,
    (68, 168):  0.26978,
    (68, 169):  None,
    (68, 170):  0.1491,
    (68, 171):  None,
    (68, 172):  None,
    (68, 173):  None,
    (68, 174):  None,
    (68, 175):  None,
    (68, 176):  None,
    (68, 177):  None,
    (69, 144):  None,
    (69, 145):  None,
    (69, 146):  None,
    (69, 147):  None,
    (69, 148):  None,
    (69, 149):  None,
    (69, 150):  None,
    (69, 151):  None,
    (69, 152):  None,
    (69, 153):  None,
    (69, 154):  None,
    (69, 155):  None,
    (69, 156):  None,
    (69, 157):  None,
    (69, 158):  None,
    (69, 159):  None,
    (69, 160):  None,
    (69, 161):  None,
    (69, 162):  None,
    (69, 163):  None,
    (69, 164):  None,
    (69, 165):  None,
    (69, 166):  None,
    (69, 167):  None,
    (69, 168):  None,
    (69, 169):  1.0,
    (69, 170):  None,
    (69, 171):  None,
    (69, 172):  None,
    (69, 173):  None,
    (69, 174):  None,
    (69, 175):  None,
    (69, 176):  None,
    (69, 177):  None,
    (69, 178):  None,
    (69, 179):  None,
    (70, 148):  None,
    (70, 149):  None,
    (70, 150):  None,
    (70, 151):  None,
    (70, 152):  None,
    (70, 153):  None,
    (70, 154):  None,
    (70, 155):  None,
    (70, 156):  None,
    (70, 157):  None,
    (70, 158):  None,
    (70, 159):  None,
    (70, 160):  None,
    (70, 161):  None,
    (70, 162):  None,
    (70, 163):  None,
    (70, 164):  None,
    (70, 165):  None,
    (70, 166):  None,
    (70, 167):  None,
    (70, 168):  0.00123,
    (70, 169):  None,
    (70, 170):  0.02982,
    (70, 171):  0.1409,
    (70, 172):  0.2168,
    (70, 173):  0.16103,
    (70, 174):  0.32026,
    (70, 175):  None,
    (70, 176):  0.12996,
    (70, 177):  None,
    (70, 178):  None,
    (70, 179):  None,
    (70, 180):  None,
    (70, 181):  None,
    (71, 150):  None,
    (71, 151):  None,
    (71, 152):  None,
    (71, 153):  None,
    (71, 154):  None,
    (71, 155):  None,
    (71, 156):  None,
    (71, 157):  None,
    (71, 158):  None,
    (71, 159):  None,
    (71, 160):  None,
    (71, 161):  None,
    (71, 162):  None,
    (71, 163):  None,
    (71, 164):  None,
    (71, 165):  None,
    (71, 166):  None,
    (71, 167):  None,
    (71, 168):  None,
    (71, 169):  None,
    (71, 170):  None,
    (71, 171):  None,
    (71, 172):  None,
    (71, 173):  None,
    (71, 174):  None,
    (71, 175):  0.97401,
    (71, 176):  0.02599,
    (71, 177):  None,
    (71, 178):  None,
    (71, 179):  None,
    (71, 180):  None,
    (71, 181):  None,
    (71, 182):  None,
    (71, 183):  None,
    (71, 184):  None,
    (71, 185):  None,
    (72, 153):  None,
    (72, 154):  None,
    (72, 155):  None,
    (72, 156):  None,
    (72, 157):  None,
    (72, 158):  None,
    (72, 159):  None,
    (72, 160):  None,
    (72, 161):  None,
    (72, 162):  None,
    (72, 163):  None,
    (72, 164):  None,
    (72, 165):  None,
    (72, 166):  None,
    (72, 167):  None,
    (72, 168):  None,
    (72, 169):  None,
    (72, 170):  None,
    (72, 171):  None,
    (72, 172):  None,
    (72, 173):  None,
    (72, 174):  0.0016,
    (72, 175):  None,
    (72, 176):  0.0526,
    (72, 177):  0.186,
    (72, 178):  0.2728,
    (72, 179):  0.1362,
    (72, 180):  0.3508,
    (72, 181):  None,
    (72, 182):  None,
    (72, 183):  None,
    (72, 184):  None,
    (72, 185):  None,
    (72, 186):  None,
    (72, 187):  None,
    (72, 188):  None,
    (72, 189):  None,
    (73, 155):  None,
    (73, 156):  None,
    (73, 157):  None,
    (73, 158):  None,
    (73, 159):  None,
    (73, 160):  None,
    (73, 161):  None,
    (73, 162):  None,
    (73, 163):  None,
    (73, 164):  None,
    (73, 165):  None,
    (73, 166):  None,
    (73, 167):  None,
    (73, 168):  None,
    (73, 169):  None,
    (73, 170):  None,
    (73, 171):  None,
    (73, 172):  None,
    (73, 173):  None,
    (73, 174):  None,
    (73, 175):  None,
    (73, 176):  None,
    (73, 177):  None,
    (73, 178):  None,
    (73, 179):  None,
    (73, 180):  0.0001201,
    (73, 181):  0.9998799,
    (73, 182):  None,
    (73, 183):  None,
    (73, 184):  None,
    (73, 185):  None,
    (73, 186):  None,
    (73, 187):  None,
    (73, 188):  None,
    (73, 189):  None,
    (73, 190):  None,
    (73, 191):  None,
    (73, 192):  None,
    (74, 157):  None,
    (74, 158):  None,
    (74, 159):  None,
    (74, 160):  None,
    (74, 161):  None,
    (74, 162):  None,
    (74, 163):  None,
    (74, 164):  None,
    (74, 165):  None,
    (74, 166):  None,
    (74, 167):  None,
    (74, 168):  None,
    (74, 169):  None,
    (74, 170):  None,
    (74, 171):  None,
    (74, 172):  None,
    (74, 173):  None,
    (74, 174):  None,
    (74, 175):  None,
    (74, 176):  None,
    (74, 177):  None,
    (74, 178):  None,
    (74, 179):  None,
    (74, 180):  0.0012,
    (74, 181):  None,
    (74, 182):  0.265,
    (74, 183):  0.1431,
    (74, 184):  0.3064,
    (74, 185):  None,
    (74, 186):  0.2843,
    (74, 187):  None,
    (74, 188):  None,
    (74, 189):  None,
    (74, 190):  None,
    (74, 191):  None,
    (74, 192):  None,
    (74, 193):  None,
    (74, 194):  None,
    (75, 159):  None,
    (75, 160):  None,
    (75, 161):  None,
    (75, 162):  None,
    (75, 163):  None,
    (75, 164):  None,
    (75, 165):  None,
    (75, 166):  None,
    (75, 167):  None,
    (75, 168):  None,
    (75, 169):  None,
    (75, 170):  None,
    (75, 171):  None,
    (75, 172):  None,
    (75, 173):  None,
    (75, 174):  None,
    (75, 175):  None,
    (75, 176):  None,
    (75, 177):  None,
    (75, 178):  None,
    (75, 179):  None,
    (75, 180):  None,
    (75, 181):  None,
    (75, 182):  None,
    (75, 183):  None,
    (75, 184):  None,
    (75, 185):  0.374,
    (75, 186):  None,
    (75, 187):  0.626,
    (75, 188):  None,
    (75, 189):  None,
    (75, 190):  None,
    (75, 191):  None,
    (75, 192):  None,
    (75, 193):  None,
    (75, 194):  None,
    (75, 195):  None,
    (75, 196):  None,
    (75, 197):  None,
    (75, 198):  None,
    (76, 161):  None,
    (76, 162):  None,
    (76, 163):  None,
    (76, 164):  None,
    (76, 165):  None,
    (76, 166):  None,
    (76, 167):  None,
    (76, 168):  None,
    (76, 169):  None,
    (76, 170):  None,
    (76, 171):  None,
    (76, 172):  None,
    (76, 173):  None,
    (76, 174):  None,
    (76, 175):  None,
    (76, 176):  None,
    (76, 177):  None,
    (76, 178):  None,
    (76, 179):  None,
    (76, 180):  None,
    (76, 181):  None,
    (76, 182):  None,
    (76, 183):  None,
    (76, 184):  0.0002,
    (76, 185):  None,
    (76, 186):  0.0159,
    (76, 187):  0.0196,
    (76, 188):  0.1324,
    (76, 189):  0.1615,
    (76, 190):  0.2626,
    (76, 191):  None,
    (76, 192):  0.4078,
    (76, 193):  None,
    (76, 194):  None,
    (76, 195):  None,
    (76, 196):  None,
    (76, 197):  None,
    (76, 198):  None,
    (76, 199):  None,
    (76, 200):  None,
    (76, 201):  None,
    (76, 202):  None,
    (77, 164):  None,
    (77, 165):  None,
    (77, 166):  None,
    (77, 167):  None,
    (77, 168):  None,
    (77, 169):  None,
    (77, 170):  None,
    (77, 171):  None,
    (77, 172):  None,
    (77, 173):  None,
    (77, 174):  None,
    (77, 175):  None,
    (77, 176):  None,
    (77, 177):  None,
    (77, 178):  None,
    (77, 179):  None,
    (77, 180):  None,
    (77, 181):  None,
    (77, 182):  None,
    (77, 183):  None,
    (77, 184):  None,
    (77, 185):  None,
    (77, 186):  None,
    (77, 187):  None,
    (77, 188):  None,
    (77, 189):  None,
    (77, 190):  None,
    (77, 191):  0.373,
    (77, 192):  None,
    (77, 193):  0.627,
    (77, 194):  None,
    (77, 195):  None,
    (77, 196):  None,
    (77, 197):  None,
    (77, 198):  None,
    (77, 199):  None,
    (77, 200):  None,
    (77, 201):  None,
    (77, 202):  None,
    (77, 203):  None,
    (77, 204):  None,
    (78, 166):  None,
    (78, 167):  None,
    (78, 168):  None,
    (78, 169):  None,
    (78, 170):  None,
    (78, 171):  None,
    (78, 172):  None,
    (78, 173):  None,
    (78, 174):  None,
    (78, 175):  None,
    (78, 176):  None,
    (78, 177):  None,
    (78, 178):  None,
    (78, 179):  None,
    (78, 180):  None,
    (78, 181):  None,
    (78, 182):  None,
    (78, 183):  None,
    (78, 184):  None,
    (78, 185):  None,
    (78, 186):  None,
    (78, 187):  None,
    (78, 188):  None,
    (78, 189):  None,
    (78, 190):  0.00012,
    (78, 191):  None,
    (78, 192):  0.00782,
    (78, 193):  None,
    (78, 194):  0.3286,
    (78, 195):  0.3378,
    (78, 196):  0.2521,
    (78, 197):  None,
    (78, 198):  0.07356,
    (78, 199):  None,
    (78, 200):  None,
    (78, 201):  None,
    (78, 202):  None,
    (78, 203):  None,
    (78, 204):  None,
    (78, 205):  None,
    (78, 206):  None,
    (79, 169):  None,
    (79, 170):  None,
    (79, 171):  None,
    (79, 172):  None,
    (79, 173):  None,
    (79, 174):  None,
    (79, 175):  None,
    (79, 176):  None,
    (79, 177):  None,
    (79, 178):  None,
    (79, 179):  None,
    (79, 180):  None,
    (79, 181):  None,
    (79, 182):  None,
    (79, 183):  None,
    (79, 184):  None,
    (79, 185):  None,
    (79, 186):  None,
    (79, 187):  None,
    (79, 188):  None,
    (79, 189):  None,
    (79, 190):  None,
    (79, 191):  None,
    (79, 192):  None,
    (79, 193):  None,
    (79, 194):  None,
    (79, 195):  None,
    (79, 196):  None,
    (79, 197):  1.0,
    (79, 198):  None,
    (79, 199):  None,
    (79, 200):  None,
    (79, 201):  None,
    (79, 202):  None,
    (79, 203):  None,
    (79, 204):  None,
    (79, 205):  None,
    (79, 206):  None,
    (79, 207):  None,
    (79, 208):  None,
    (79, 209):  None,
    (79, 210):  None,
    (80, 171):  None,
    (80, 172):  None,
    (80, 173):  None,
    (80, 174):  None,
    (80, 175):  None,
    (80, 176):  None,
    (80, 177):  None,
    (80, 178):  None,
    (80, 179):  None,
    (80, 180):  None,
    (80, 181):  None,
    (80, 182):  None,
    (80, 183):  None,
    (80, 184):  None,
    (80, 185):  None,
    (80, 186):  None,
    (80, 187):  None,
    (80, 188):  None,
    (80, 189):  None,
    (80, 190):  None,
    (80, 191):  None,
    (80, 192):  None,
    (80, 193):  None,
    (80, 194):  None,
    (80, 195):  None,
    (80, 196):  0.0015,
    (80, 197):  None,
    (80, 198):  0.0997,
    (80, 199):  0.1687,
    (80, 200):  0.231,
    (80, 201):  0.1318,
    (80, 202):  0.2986,
    (80, 203):  None,
    (80, 204):  0.0687,
    (80, 205):  None,
    (80, 206):  None,
    (80, 207):  None,
    (80, 208):  None,
    (80, 209):  None,
    (80, 210):  None,
    (80, 211):  None,
    (80, 212):  None,
    (80, 213):  None,
    (80, 214):  None,
    (80, 215):  None,
    (80, 216):  None,
    (81, 176):  None,
    (81, 177):  None,
    (81, 178):  None,
    (81, 179):  None,
    (81, 180):  None,
    (81, 181):  None,
    (81, 182):  None,
    (81, 183):  None,
    (81, 184):  None,
    (81, 185):  None,
    (81, 186):  None,
    (81, 187):  None,
    (81, 188):  None,
    (81, 189):  None,
    (81, 190):  None,
    (81, 191):  None,
    (81, 192):  None,
    (81, 193):  None,
    (81, 194):  None,
    (81, 195):  None,
    (81, 196):  None,
    (81, 197):  None,
    (81, 198):  None,
    (81, 199):  None,
    (81, 200):  None,
    (81, 201):  None,
    (81, 202):  None,
    (81, 203):  0.2952,
    (81, 204):  None,
    (81, 205):  0.7048,
    (81, 206):  None,
    (81, 207):  None,
    (81, 208):  None,
    (81, 209):  None,
    (81, 210):  None,
    (81, 211):  None,
    (81, 212):  None,
    (81, 213):  None,
    (81, 214):  None,
    (81, 215):  None,
    (81, 216):  None,
    (81, 217):  None,
    (81, 218):  None,
    (82, 178):  None,
    (82, 179):  None,
    (82, 180):  None,
    (82, 181):  None,
    (82, 182):  None,
    (82, 183):  None,
    (82, 184):  None,
    (82, 185):  None,
    (82, 186):  None,
    (82, 187):  None,
    (82, 188):  None,
    (82, 189):  None,
    (82, 190):  None,
    (82, 191):  None,
    (82, 192):  None,
    (82, 193):  None,
    (82, 194):  None,
    (82, 195):  None,
    (82, 196):  None,
    (82, 197):  None,
    (82, 198):  None,
    (82, 199):  None,
    (82, 200):  None,
    (82, 201):  None,
    (82, 202):  None,
    (82, 203):  None,
    (82, 204):  0.014,
    (82, 205):  None,
    (82, 206):  0.241,
    (82, 207):  0.221,
    (82, 208):  0.524,
    (82, 209):  None,
    (82, 210):  None,
    (82, 211):  None,
    (82, 212):  None,
    (82, 213):  None,
    (82, 214):  None,
    (82, 215):  None,
    (82, 216):  None,
    (82, 217):  None,
    (82, 218):  None,
    (82, 219):  None,
    (82, 220):  None,
    (83, 184):  None,
    (83, 185):  None,
    (83, 186):  None,
    (83, 187):  None,
    (83, 188):  None,
    (83, 189):  None,
    (83, 190):  None,
    (83, 191):  None,
    (83, 192):  None,
    (83, 193):  None,
    (83, 194):  None,
    (83, 195):  None,
    (83, 196):  None,
    (83, 197):  None,
    (83, 198):  None,
    (83, 199):  None,
    (83, 200):  None,
    (83, 201):  None,
    (83, 202):  None,
    (83, 203):  None,
    (83, 204):  None,
    (83, 205):  None,
    (83, 206):  None,
    (83, 207):  None,
    (83, 208):  None,
    (83, 209):  1.0,
    (83, 210):  None,
    (83, 211):  None,
    (83, 212):  None,
    (83, 213):  None,
    (83, 214):  None,
    (83, 215):  None,
    (83, 216):  None,
    (83, 217):  None,
    (83, 218):  None,
    (83, 219):  None,
    (83, 220):  None,
    (83, 221):  None,
    (83, 222):  None,
    (83, 223):  None,
    (83, 224):  None,
    (84, 186):  None,
    (84, 187):  None,
    (84, 188):  None,
    (84, 189):  None,
    (84, 190):  None,
    (84, 191):  None,
    (84, 192):  None,
    (84, 193):  None,
    (84, 194):  None,
    (84, 195):  None,
    (84, 196):  None,
    (84, 197):  None,
    (84, 198):  None,
    (84, 199):  None,
    (84, 200):  None,
    (84, 201):  None,
    (84, 202):  None,
    (84, 203):  None,
    (84, 204):  None,
    (84, 205):  None,
    (84, 206):  None,
    (84, 207):  None,
    (84, 208):  None,
    (84, 209):  None,
    (84, 210):  None,
    (84, 211):  None,
    (84, 212):  None,
    (84, 213):  None,
    (84, 214):  None,
    (84, 215):  None,
    (84, 216):  None,
    (84, 217):  None,
    (84, 218):  None,
    (84, 219):  None,
    (84, 220):  None,
    (84, 221):  None,
    (84, 222):  None,
    (84, 223):  None,
    (84, 224):  None,
    (84, 225):  None,
    (84, 226):  None,
    (84, 227):  None,
    (85, 191):  None,
    (85, 192):  None,
    (85, 193):  None,
    (85, 194):  None,
    (85, 195):  None,
    (85, 196):  None,
    (85, 197):  None,
    (85, 198):  None,
    (85, 199):  None,
    (85, 200):  None,
    (85, 201):  None,
    (85, 202):  None,
    (85, 203):  None,
    (85, 204):  None,
    (85, 205):  None,
    (85, 206):  None,
    (85, 207):  None,
    (85, 208):  None,
    (85, 209):  None,
    (85, 210):  None,
    (85, 211):  None,
    (85, 212):  None,
    (85, 213):  None,
    (85, 214):  None,
    (85, 215):  None,
    (85, 216):  None,
    (85, 217):  None,
    (85, 218):  None,
    (85, 219):  None,
    (85, 220):  None,
    (85, 221):  None,
    (85, 222):  None,
    (85, 223):  None,
    (85, 224):  None,
    (85, 225):  None,
    (85, 226):  None,
    (85, 227):  None,
    (85, 228):  None,
    (85, 229):  None,
    (86, 193):  None,
    (86, 194):  None,
    (86, 195):  None,
    (86, 196):  None,
    (86, 197):  None,
    (86, 198):  None,
    (86, 199):  None,
    (86, 200):  None,
    (86, 201):  None,
    (86, 202):  None,
    (86, 203):  None,
    (86, 204):  None,
    (86, 205):  None,
    (86, 206):  None,
    (86, 207):  None,
    (86, 208):  None,
    (86, 209):  None,
    (86, 210):  None,
    (86, 211):  None,
    (86, 212):  None,
    (86, 213):  None,
    (86, 214):  None,
    (86, 215):  None,
    (86, 216):  None,
    (86, 217):  None,
    (86, 218):  None,
    (86, 219):  None,
    (86, 220):  None,
    (86, 221):  None,
    (86, 222):  None,
    (86, 223):  None,
    (86, 224):  None,
    (86, 225):  None,
    (86, 226):  None,
    (86, 227):  None,
    (86, 228):  None,
    (86, 229):  None,
    (86, 230):  None,
    (86, 231):  None,
    (87, 199):  None,
    (87, 200):  None,
    (87, 201):  None,
    (87, 202):  None,
    (87, 203):  None,
    (87, 204):  None,
    (87, 205):  None,
    (87, 206):  None,
    (87, 207):  None,
    (87, 208):  None,
    (87, 209):  None,
    (87, 210):  None,
    (87, 211):  None,
    (87, 212):  None,
    (87, 213):  None,
    (87, 214):  None,
    (87, 215):  None,
    (87, 216):  None,
    (87, 217):  None,
    (87, 218):  None,
    (87, 219):  None,
    (87, 220):  None,
    (87, 221):  None,
    (87, 222):  None,
    (87, 223):  None,
    (87, 224):  None,
    (87, 225):  None,
    (87, 226):  None,
    (87, 227):  None,
    (87, 228):  None,
    (87, 229):  None,
    (87, 230):  None,
    (87, 231):  None,
    (87, 232):  None,
    (87, 233):  None,
    (88, 201):  None,
    (88, 202):  None,
    (88, 203):  None,
    (88, 204):  None,
    (88, 205):  None,
    (88, 206):  None,
    (88, 207):  None,
    (88, 208):  None,
    (88, 209):  None,
    (88, 210):  None,
    (88, 211):  None,
    (88, 212):  None,
    (88, 213):  None,
    (88, 214):  None,
    (88, 215):  None,
    (88, 216):  None,
    (88, 217):  None,
    (88, 218):  None,
    (88, 219):  None,
    (88, 220):  None,
    (88, 221):  None,
    (88, 222):  None,
    (88, 223):  None,
    (88, 224):  None,
    (88, 225):  None,
    (88, 226):  None,
    (88, 227):  None,
    (88, 228):  None,
    (88, 229):  None,
    (88, 230):  None,
    (88, 231):  None,
    (88, 232):  None,
    (88, 233):  None,
    (88, 234):  None,
    (88, 235):  None,
    (89, 206):  None,
    (89, 207):  None,
    (89, 208):  None,
    (89, 209):  None,
    (89, 210):  None,
    (89, 211):  None,
    (89, 212):  None,
    (89, 213):  None,
    (89, 214):  None,
    (89, 215):  None,
    (89, 216):  None,
    (89, 217):  None,
    (89, 218):  None,
    (89, 219):  None,
    (89, 220):  None,
    (89, 221):  None,
    (89, 222):  None,
    (89, 223):  None,
    (89, 224):  None,
    (89, 225):  None,
    (89, 226):  None,
    (89, 227):  None,
    (89, 228):  None,
    (89, 229):  None,
    (89, 230):  None,
    (89, 231):  None,
    (89, 232):  None,
    (89, 233):  None,
    (89, 234):  None,
    (89, 235):  None,
    (89, 236):  None,
    (89, 237):  None,
    (90, 208):  None,
    (90, 209):  None,
    (90, 210):  None,
    (90, 211):  None,
    (90, 212):  None,
    (90, 213):  None,
    (90, 214):  None,
    (90, 215):  None,
    (90, 216):  None,
    (90, 217):  None,
    (90, 218):  None,
    (90, 219):  None,
    (90, 220):  None,
    (90, 221):  None,
    (90, 222):  None,
    (90, 223):  None,
    (90, 224):  None,
    (90, 225):  None,
    (90, 226):  None,
    (90, 227):  None,
    (90, 228):  None,
    (90, 229):  None,
    (90, 230):  None,
    (90, 231):  None,
    (90, 232):  1.0,
    (90, 233):  None,
    (90, 234):  None,
    (90, 235):  None,
    (90, 236):  None,
    (90, 237):  None,
    (90, 238):  None,
    (90, 239):  None,
    (91, 212):  None,
    (91, 213):  None,
    (91, 214):  None,
    (91, 215):  None,
    (91, 216):  None,
    (91, 217):  None,
    (91, 218):  None,
    (91, 219):  None,
    (91, 220):  None,
    (91, 221):  None,
    (91, 222):  None,
    (91, 223):  None,
    (91, 224):  None,
    (91, 225):  None,
    (91, 226):  None,
    (91, 227):  None,
    (91, 228):  None,
    (91, 229):  None,
    (91, 230):  None,
    (91, 231):  1.0,
    (91, 232):  None,
    (91, 233):  None,
    (91, 234):  None,
    (91, 235):  None,
    (91, 236):  None,
    (91, 237):  None,
    (91, 238):  None,
    (91, 239):  None,
    (91, 240):  None,
    (91, 241):  None,
    (92, 217):  None,
    (92, 218):  None,
    (92, 219):  None,
    (92, 220):  None,
    (92, 221):  None,
    (92, 222):  None,
    (92, 223):  None,
    (92, 224):  None,
    (92, 225):  None,
    (92, 226):  None,
    (92, 227):  None,
    (92, 228):  None,
    (92, 229):  None,
    (92, 230):  None,
    (92, 231):  None,
    (92, 232):  None,
    (92, 233):  None,
    (92, 234):  5.4e-05,
    (92, 235):  0.007204,
    (92, 236):  None,
    (92, 237):  None,
    (92, 238):  0.992742,
    (92, 239):  None,
    (92, 240):  None,
    (92, 241):  None,
    (92, 242):  None,
    (92, 243):  None,
    (93, 219):  None,
    (93, 220):  None,
    (93, 221):  None,
    (93, 222):  None,
    (93, 223):  None,
    (93, 224):  None,
    (93, 225):  None,
    (93, 226):  None,
    (93, 227):  None,
    (93, 228):  None,
    (93, 229):  None,
    (93, 230):  None,
    (93, 231):  None,
    (93, 232):  None,
    (93, 233):  None,
    (93, 234):  None,
    (93, 235):  None,
    (93, 236):  None,
    (93, 237):  None,
    (93, 238):  None,
    (93, 239):  None,
    (93, 240):  None,
    (93, 241):  None,
    (93, 242):  None,
    (93, 243):  None,
    (93, 244):  None,
    (93, 245):  None,
    (94, 228):  None,
    (94, 229):  None,
    (94, 230):  None,
    (94, 231):  None,
    (94, 232):  None,
    (94, 233):  None,
    (94, 234):  None,
    (94, 235):  None,
    (94, 236):  None,
    (94, 237):  None,
    (94, 238):  None,
    (94, 239):  None,
    (94, 240):  None,
    (94, 241):  None,
    (94, 242):  None,
    (94, 243):  None,
    (94, 244):  None,
    (94, 245):  None,
    (94, 246):  None,
    (94, 247):  None,
    (95, 230):  None,
    (95, 231):  None,
    (95, 232):  None,
    (95, 233):  None,
    (95, 234):  None,
    (95, 235):  None,
    (95, 236):  None,
    (95, 237):  None,
    (95, 238):  None,
    (95, 239):  None,
    (95, 240):  None,
    (95, 241):  None,
    (95, 242):  None,
    (95, 243):  None,
    (95, 244):  None,
    (95, 245):  None,
    (95, 246):  None,
    (95, 247):  None,
    (95, 248):  None,
    (95, 249):  None,
    (96, 232):  None,
    (96, 233):  None,
    (96, 234):  None,
    (96, 235):  None,
    (96, 236):  None,
    (96, 237):  None,
    (96, 238):  None,
    (96, 239):  None,
    (96, 240):  None,
    (96, 241):  None,
    (96, 242):  None,
    (96, 243):  None,
    (96, 244):  None,
    (96, 245):  None,
    (96, 246):  None,
    (96, 247):  None,
    (96, 248):  None,
    (96, 249):  None,
    (96, 250):  None,
    (96, 251):  None,
    (96, 252):  None,
    (97, 234):  None,
    (97, 235):  None,
    (97, 236):  None,
    (97, 237):  None,
    (97, 238):  None,
    (97, 239):  None,
    (97, 240):  None,
    (97, 241):  None,
    (97, 242):  None,
    (97, 243):  None,
    (97, 244):  None,
    (97, 245):  None,
    (97, 246):  None,
    (97, 247):  None,
    (97, 248):  None,
    (97, 249):  None,
    (97, 250):  None,
    (97, 251):  None,
    (97, 252):  None,
    (97, 253):  None,
    (97, 254):  None,
    (98, 237):  None,
    (98, 238):  None,
    (98, 239):  None,
    (98, 240):  None,
    (98, 241):  None,
    (98, 242):  None,
    (98, 243):  None,
    (98, 244):  None,
    (98, 245):  None,
    (98, 246):  None,
    (98, 247):  None,
    (98, 248):  None,
    (98, 249):  None,
    (98, 250):  None,
    (98, 251):  None,
    (98, 252):  None,
    (98, 253):  None,
    (98, 254):  None,
    (98, 255):  None,
    (98, 256):  None,
    (99, 239):  None,
    (99, 240):  None,
    (99, 241):  None,
    (99, 242):  None,
    (99, 243):  None,
    (99, 244):  None,
    (99, 245):  None,
    (99, 246):  None,
    (99, 247):  None,
    (99, 248):  None,
    (99, 249):  None,
    (99, 250):  None,
    (99, 251):  None,
    (99, 252):  None,
    (99, 253):  None,
    (99, 254):  None,
    (99, 255):  None,
    (99, 256):  None,
    (99, 257):  None,
    (99, 258):  None,
    (100, 241): None,
    (100, 242): None,
    (100, 243): None,
    (100, 244): None,
    (100, 245): None,
    (100, 246): None,
    (100, 247): None,
    (100, 248): None,
    (100, 249): None,
    (100, 250): None,
    (100, 251): None,
    (100, 252): None,
    (100, 253): None,
    (100, 254): None,
    (100, 255): None,
    (100, 256): None,
    (100, 257): None,
    (100, 258): None,
    (100, 259): None,
    (100, 260): None,
    (101, 245): None,
    (101, 246): None,
    (101, 247): None,
    (101, 248): None,
    (101, 249): None,
    (101, 250): None,
    (101, 251): None,
    (101, 252): None,
    (101, 253): None,
    (101, 254): None,
    (101, 255): None,
    (101, 256): None,
    (101, 257): None,
    (101, 258): None,
    (101, 259): None,
    (101, 260): None,
    (101, 261): None,
    (101, 262): None,
    (102, 248): None,
    (102, 249): None,
    (102, 250): None,
    (102, 251): None,
    (102, 252): None,
    (102, 253): None,
    (102, 254): None,
    (102, 255): None,
    (102, 256): None,
    (102, 257): None,
    (102, 258): None,
    (102, 259): None,
    (102, 260): None,
    (102, 261): None,
    (102, 262): None,
    (102, 263): None,
    (102, 264): None,
    (103, 251): None,
    (103, 252): None,
    (103, 253): None,
    (103, 254): None,
    (103, 255): None,
    (103, 256): None,
    (103, 257): None,
    (103, 258): None,
    (103, 259): None,
    (103, 260): None,
    (103, 261): None,
    (103, 262): None,
    (103, 263): None,
    (103, 264): None,
    (103, 265): None,
    (103, 266): None,
    (104, 253): None,
    (104, 254): None,
    (104, 255): None,
    (104, 256): None,
    (104, 257): None,
    (104, 258): None,
    (104, 259): None,
    (104, 260): None,
    (104, 261): None,
    (104, 262): None,
    (104, 263): None,
    (104, 264): None,
    (104, 265): None,
    (104, 266): None,
    (104, 267): None,
    (104, 268): None,
    (105, 255): None,
    (105, 256): None,
    (105, 257): None,
    (105, 258): None,
    (105, 259): None,
    (105, 260): None,
    (105, 261): None,
    (105, 262): None,
    (105, 263): None,
    (105, 264): None,
    (105, 265): None,
    (105, 266): None,
    (105, 267): None,
    (105, 268): None,
    (105, 269): None,
    (105, 270): None,
    (106, 258): None,
    (106, 259): None,
    (106, 260): None,
    (106, 261): None,
    (106, 262): None,
    (106, 263): None,
    (106, 264): None,
    (106, 265): None,
    (106, 266): None,
    (106, 267): None,
    (106, 268): None,
    (106, 269): None,
    (106, 270): None,
    (106, 271): None,
    (106, 272): None,
    (106, 273): None,
    (107, 260): None,
    (107, 261): None,
    (107, 262): None,
    (107, 263): None,
    (107, 264): None,
    (107, 265): None,
    (107, 266): None,
    (107, 267): None,
    (107, 268): None,
    (107, 269): None,
    (107, 270): None,
    (107, 271): None,
    (107, 272): None,
    (107, 273): None,
    (107, 274): None,
    (107, 275): None,
    (108, 263): None,
    (108, 264): None,
    (108, 265): None,
    (108, 266): None,
    (108, 267): None,
    (108, 268): None,
    (108, 269): None,
    (108, 270): None,
    (108, 271): None,
    (108, 272): None,
    (108, 273): None,
    (108, 274): None,
    (108, 275): None,
    (108, 276): None,
    (108, 277): None,
    (109, 265): None,
    (109, 266): None,
    (109, 267): None,
    (109, 268): None,
    (109, 269): None,
    (109, 270): None,
    (109, 271): None,
    (109, 272): None,
    (109, 273): None,
    (109, 274): None,
    (109, 275): None,
    (109, 276): None,
    (109, 277): None,
    (109, 278): None,
    (109, 279): None,
    (110, 267): None,
    (110, 268): None,
    (110, 269): None,
    (110, 270): None,
    (110, 271): None,
    (110, 272): None,
    (110, 273): None,
    (110, 274): None,
    (110, 275): None,
    (110, 276): None,
    (110, 277): None,
    (110, 278): None,
    (110, 279): None,
    (110, 280): None,
    (110, 281): None,
    (111, 272): None,
    (111, 273): None,
    (111, 274): None,
    (111, 275): None,
    (111, 276): None,
    (111, 277): None,
    (111, 278): None,
    (111, 279): None,
    (111, 280): None,
    (111, 281): None,
    (111, 282): None,
    (111, 283): None,
    (112, 276): None,
    (112, 277): None,
    (112, 278): None,
    (112, 279): None,
    (112, 280): None,
    (112, 281): None,
    (112, 282): None,
    (112, 283): None,
    (112, 284): None,
    (112, 285): None,
    (113, 278): None,
    (113, 279): None,
    (113, 280): None,
    (113, 281): None,
    (113, 282): None,
    (113, 283): None,
    (113, 284): None,
    (113, 285): None,
    (113, 286): None,
    (113, 287): None,
    (114, 285): None,
    (114, 286): None,
    (114, 287): None,
    (114, 288): None,
    (114, 289): None,
    (115, 287): None,
    (115, 288): None,
    (115, 289): None,
    (115, 290): None,
    (115, 291): None,
    (116, 289): None,
    (116, 290): None,
    (116, 291): None,
    (116, 292): None,
    (116, 293): None,
    (117, 291): None,
    (117, 292): None,
    (117, 293): None,
    (117, 294): None,
    (118, 293): None,
    (118, 294): None,
    (118, 295): None
    }
ELEMENT_CHARGES = {
    'D':   1,
    'T':   1,
    'H':   1,
    'He':  2,
    'Li':  3,
    'Be':  4,
    'B':   5,
    'C':   6,
    'N':   7,
    'O':   8,
    'F':   9,
    'Ne':  10,
    'Na':  11,
    'Mg':  12,
    'Al':  13,
    'Si':  14,
    'P':   15,
    'S':   16,
    'Cl':  17,
    'Ar':  18,
    'K':   19,
    'Ca':  20,
    'Sc':  21,
    'Ti':  22,
    'V':   23,
    'Cr':  24,
    'Mn':  25,
    'Fe':  26,
    'Co':  27,
    'Ni':  28,
    'Cu':  29,
    'Zn':  30,
    'Ga':  31,
    'Ge':  32,
    'As':  33,
    'Se':  34,
    'Br':  35,
    'Kr':  36,
    'Rb':  37,
    'Sr':  38,
    'Y':   39,
    'Zr':  40,
    'Nb':  41,
    'Mo':  42,
    'Tc':  43,
    'Ru':  44,
    'Rh':  45,
    'Pd':  46,
    'Ag':  47,
    'Cd':  48,
    'In':  49,
    'Sn':  50,
    'Sb':  51,
    'Te':  52,
    'I':   53,
    'Xe':  54,
    'Cs':  55,
    'Ba':  56,
    'La':  57,
    'Ce':  58,
    'Pr':  59,
    'Nd':  60,
    'Pm':  61,
    'Sm':  62,
    'Eu':  63,
    'Gd':  64,
    'Tb':  65,
    'Dy':  66,
    'Ho':  67,
    'Er':  68,
    'Tm':  69,
    'Yb':  70,
    'Lu':  71,
    'Hf':  72,
    'Ta':  73,
    'W':   74,
    'Re':  75,
    'Os':  76,
    'Ir':  77,
    'Pt':  78,
    'Au':  79,
    'Hg':  80,
    'Tl':  81,
    'Pb':  82,
    'Bi':  83,
    'Po':  84,
    'At':  85,
    'Rn':  86,
    'Fr':  87,
    'Ra':  88,
    'Ac':  89,
    'Th':  90,
    'Pa':  91,
    'U':   92,
    'Np':  93,
    'Pu':  94,
    'Am':  95,
    'Cm':  96,
    'Bk':  97,
    'Cf':  98,
    'Es':  99,
    'Fm':  100,
    'Md':  101,
    'No':  102,
    'Lr':  103,
    'Rf':  104,
    'Db':  105,
    'Sg':  106,
    'Bh':  107,
    'Hs':  108,
    'Mt':  109,
    'Ds':  110,
    'Rg':  111,
    'Cn':  112,
    'Nh':  113,
    'Fl':  114,
    'Mc':  115,
    'Uup': 115,
    'Lv':  116,
    'Ts':  117,
    'Uus': 117,
    'Og':  118
    }
ELEMENT_FULLNAMES = {
    'H':   'hydrogen',
    'D':   'deuterium',
    'T':   'tritium',
    'He':  'helium',
    'Li':  'lithium',
    'Be':  'beryllium',
    'B':   'boron',
    'C':   'carbon',
    'N':   'nitrogen',
    'O':   'oxygen',
    'F':   'fluorine',
    'Ne':  'neon',
    'Na':  'sodium',
    'Mg':  'magnesium',
    'Al':  'aluminum',
    'Si':  'silicon',
    'P':   'phosphorus',
    'S':   'sulfur',
    'Cl':  'chlorine',
    'Ar':  'argon',
    'K':   'potassium',
    'Ca':  'calcium',
    'Sc':  'scandium',
    'Ti':  'titanium',
    'V':   'vanadium',
    'Cr':  'chromium',
    'Mn':  'manganese',
    'Fe':  'iron',
    'Co':  'cobalt',
    'Ni':  'nickel',
    'Cu':  'copper',
    'Zn':  'zinc',
    'Ga':  'gallium',
    'Ge':  'germanium',
    'As':  'arsenic',
    'Se':  'selenium',
    'Br':  'bromine',
    'Kr':  'krypton',
    'Rb':  'rubidium',
    'Sr':  'strontium',
    'Y':   'yttrium',
    'Zr':  'zirconium',
    'Nb':  'niobium',
    'Mo':  'molybdenum',
    'Tc':  'technetium',
    'Ru':  'ruthenium',
    'Rh':  'rhodium',
    'Pd':  'palladium',
    'Ag':  'silver',
    'Cd':  'cadmium',
    'In':  'indium',
    'Sn':  'tin',
    'Sb':  'antimony',
    'Te':  'tellurium',
    'I':   'iodine',
    'Xe':  'xenon',
    'Cs':  'cesium',
    'Ba':  'barium',
    'La':  'lanthanum',
    'Ce':  'cerium',
    'Pr':  'praseodymium',
    'Nd':  'neodymium',
    'Pm':  'promethium',
    'Sm':  'samarium',
    'Eu':  'europium',
    'Gd':  'gadolinium',
    'Tb':  'terbium',
    'Dy':  'dysprosium',
    'Ho':  'holmium',
    'Er':  'erbium',
    'Tm':  'thulium',
    'Yb':  'ytterbium',
    'Lu':  'lutetium',
    'Hf':  'hafnium',
    'Ta':  'tantalum',
    'W':   'tungsten',
    'Re':  'rhenium',
    'Os':  'osmium',
    'Ir':  'iridium',
    'Pt':  'platinum',
    'Au':  'gold',
    'Hg':  'mercury',
    'Tl':  'thallium',
    'Pb':  'lead',
    'Bi':  'bismuth',
    'Po':  'polonium',
    'At':  'astatine',
    'Rn':  'radon',
    'Fr':  'francium',
    'Ra':  'radium',
    'Ac':  'actinium',
    'Th':  'thorium',
    'Pa':  'protactinium',
    'U':   'uranium',
    'Np':  'neptunium',
    'Pu':  'plutonium',
    'Am':  'americium',
    'Cm':  'curium',
    'Bk':  'berkelium',
    'Cf':  'californium',
    'Es':  'einsteinium',
    'Fm':  'fermium',
    'Md':  'mendelevium',
    'No':  'nobelium',
    'Lr':  'lawrencium',
    'Rf':  'rutherfordium',
    'Db':  'dubnium',
    'Sg':  'seaborgium',
    'Bh':  'bohrium',
    'Hs':  'hassium',
    'Mt':  'meitnerium',
    'Ds':  'darmstadtium',
    'Rg':  'roentgenium',
    'Cn':  'copernicium',
    'Nh':  'nihonium',
    'Fl':  'flerovium',
    'Mc':  'moscovium',
    'Uup': 'Uup',
    'Lv':  'livermorium',
    'Ts':  'tennessine',
    'Uus': 'Uus',
    'Og':  'oganesson'
    }
