C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_m11.F 
C> The nwxcm_c_m11 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_m11 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& 0.1325688999052018\,{\it t_3}+1.0\\\\ 
C>   {\it t_5} &=& \sqrt{{\it t_2}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_5}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.02414199311453321\,{\it t_6}
C>    +0.10186556948\right)+0.22308199064\right)+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{10}} &=& 1.0-{\it t_8}\,{\it t_9}\\\\ 
C>   {\it t_{11}} &=& {\it t_8}\,{\it t_9}+1.0\\\\ 
C>   {\it t_{12}} &=& 0.06901399211255826\,{\it t_3}+1.0\\\\ 
C>   {\it t_{13}} &=& \log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01321299881039884
C>    \,{\it t_6}+0.029729725188\right)+0.12236585478\right)
C>    +0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{14}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{11}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{10}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_8}^4\,\left(1.709920934161365\,\left(0.0621814
C>    \,{\it t_4}\,{\it t_7}-0.0310907\,\left(0.1274696188700087
C>    \,{\it t_3}+1.0\right)\,\log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01530901310039024
C>    \,{\it t_6}+0.10465751434\right)+0.19269083139\right)
C>    +0.43896648423}}+1.0\right)\right)-0.0337738\,{\it t_{12}}
C>    \,{\it t_{13}}\right)}\over{{\it t_1}^4}}+0.0337738\,{
C>    \it t_{12}}\,{\it t_{13}}\right)-0.0621814\,{\it t_4}\,{
C>    \it t_7}\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{16}} &=& 2.871234000188191\,{\it t_1}^{{{5}\over{3}}}\\\\ 
C>   {\it t_{17}} &=& -\tau_\beta-\tau_\alpha+{\it t_{16}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{\tau_\beta+\tau_\alpha+{
C>    \it t_{16}}}}\\\\ 
C>   {\it t_{19}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{20}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{21}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{22}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{23}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{29}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{30}} &=& 0.5\,{\it t_{11}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{10}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{31}} &=& {\it t_{30}}^{3.0}\\\\ 
C>   {\it t_{32}} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{{\it t_{30}}^{2.0}}}\\\\ 
C>   {\it t_{34}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{e^{{{32.16396844291483\,{
C>    \it t_{14}}}\over{{\it t_{31}}}}}}}-1.0\\\\ 
C>   {\it t_{36}} &=& {{0.1362107888567592\,{\it t_{32}}\,{
C>    \it t_{33}}\,{\it t_{34}}}\over{{\it t_{35}}}}\\\\ 
C>   {\it t_{37}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{38}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{39}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{40}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{41}} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{42}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{43}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{44}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(23\right)\\\\ 
C>   {\it t_{48}} &=& {\it param}\left(24\right)\\\\ 
C>   {\it t_{49}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{50}} &=& \sqrt{{\it t_{49}}}\\\\ 
C>   {\it t_{51}} &=& {{1}\over{{\it t_{50}}}}\\\\ 
C>   {\it t_{52}} &=& {{1}\over{{\it t_{49}}}}\\\\ 
C>   {\it t_{53}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{50}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{51}}+0.10186556948\right)
C>    \,{\it t_{51}}+0.22308199064\right)\,{\it t_{51}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{54}} &=& 0.1325688999052018\,{\it t_{52}}+1.0\\\\ 
C>   {\it t_{55}} &=& 0.9999999999999991\,\left(0.0621814\,{
C>    \it t_{53}}\,{\it t_{54}}-0.0310907\,\log 
C>    \left({{1.269642451250142\,{\it t_{50}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{51}}+0.10465751434\right)
C>    \,{\it t_{51}}+0.19269083139\right)\,{\it t_{51}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{52}}+1.0\right)\right)-0.0621814\,{\it t_{53}}\,{
C>    \it t_{54}}\\\\ 
C>   {\it t_{56}} &=& 2.871234000188191\,\rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{57}} &=& -\tau_{\bar s}-\tau_s+{\it t_{56}}\\\\ 
C>   {\it t_{58}} &=& {{1}\over{\tau_{\bar s}+\tau_s+{\it t_{56}}}}\\\\ 
C>   {\it t_{59}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{60}} &=& {{1}\over{e^{64.32793688582967\,{\it t_{55}}}}}
C>    -1.0\\\\ 
C>   {\it t_{61}} &=& {{0.2162211495206379\,{\it t_{59}}\,
C>    \sigma_{ss}}\over{{\it t_{60}}}}\\\\ 
C>   f &=& 1.0\,\left(0.03109069086965489\,{\it t_1}\,{\it t_{31}}
C>    \,\log \left({{0.1362107888567592\,{\it t_{32}}\,{\it t_{33}}
C>    \,{\it t_{34}}\,\left({\it t_{36}}+1.0\right)}
C>    \over{{{0.01855337900098064\,\left({\it t_{32}}\,{
C>    \it t_{34}}\right)^{2.0}}\over{{\it t_{30}}^{4.0}\,{
C>    \it t_{35}}^{2.0}}}+{\it t_{36}}+1.0}}+1.0\right)\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{48}}\,{\it t_{17}}\,{\it t_{18}}+{\it t_{47}}\right)
C>    +{\it t_{46}}\right)+{\it t_{45}}\right)+{\it t_{44}}\right)
C>    +{\it t_{43}}\right)+{\it t_{42}}\right)+{\it t_{41}}\right)
C>    +{\it t_{40}}\right)+{\it t_{39}}\right)+{\it t_{38}}\right)
C>    +{\it t_{37}}\right)+1.0\,{\it t_1}\,{\it t_{14}}\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{29}}\,{\it t_{17}}\,{\it t_{18}}+{\it t_{28}}\right)
C>    +{\it t_{27}}\right)+{\it t_{26}}\right)+{\it t_{25}}\right)
C>    +{\it t_{24}}\right)+{\it t_{23}}\right)+{\it t_{22}}\right)
C>    +{\it t_{21}}\right)+{\it t_{20}}\right)+{\it t_{19}}\right)
C>    +{\it t_{15}}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.01554534543482744\,\rho_s\,\log 
C>    \left({{0.2162211495206379\,{\it t_{59}}\,\sigma_{ss}\,
C>    \left({\it t_{61}}+1.0\right)}\over{{{0.04675158550002606
C>    \,\left({\it t_{59}}\,\sigma_{ss}\right)^{2.0}}\over{{
C>    \it t_{60}}^{2.0}}}+{\it t_{61}}+1.0}}+1.0\right)\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{48}}\,{\it t_{57}}\,{\it t_{58}}+{\it t_{47}}\right)
C>    +{\it t_{46}}\right)+{\it t_{45}}\right)+{\it t_{44}}\right)
C>    +{\it t_{43}}\right)+{\it t_{42}}\right)+{\it t_{41}}\right)
C>    +{\it t_{40}}\right)+{\it t_{39}}\right)+{\it t_{38}}\right)
C>    +{\it t_{37}}\right)+1.0\,{\it t_{55}}\,\rho_s\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{29}}\,{\it t_{57}}\,{\it t_{58}}+{\it t_{28}}\right)
C>    +{\it t_{27}}\right)+{\it t_{26}}\right)+{\it t_{25}}\right)
C>    +{\it t_{24}}\right)+{\it t_{23}}\right)+{\it t_{22}}\right)
C>    +{\it t_{21}}\right)+{\it t_{20}}\right)+{\it t_{19}}\right)
C>    +{\it t_{15}}\right)\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] R Peverati, DG Truhlar, J.Phys.Chem.Lett. 2, 2810 (2011)  , DOI: 
C> <a href="https://doi.org/10.1021/jz201170d "> 
C> 10.1021/jz201170d </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_m11(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3*(
     1         7.016926042943223d-1*(2.150807071909054d-2*t3+1.018655694
     2         8d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
            t5 = 1/t1
            t6 = 1.0522000558389215d-1*t5+1.0d+0
            t7 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t8 = t7-2*taua
            t9 = 2*taua+t7
            t10 = 1/t9
            t11 = param(12)
            t12 = t10*t11*t8+param(11)
            t13 = t10*t12*t8+param(10)
            t14 = t10*t13*t8+param(9)
            t15 = t10*t14*t8+param(8)
            t16 = t10*t15*t8+param(7)
            t17 = t10*t16*t8+param(6)
            t18 = t10*t17*t8+param(5)
            t19 = t10*t18*t8+param(4)
            t20 = t10*t19*t8+param(3)
            t21 = t10*t20*t8+param(2)
            t22 = t10*t21*t8+param(1)
            t23 = rhoa**1.1666666666666667d+0
            t24 = 1/t23**2.0d+0
            t25 = exp(2.0000005873362642d+0*t4*t6)-1.0d+0
            t26 = 1.0811057476031892d-1*gammaaa*t24/t25
            t27 = (gammaaa*t24)**2.0d+0
            t28 = param(24)
            t29 = t10*t28*t8+param(23)
            t30 = t10*t29*t8+param(22)
            t31 = t10*t30*t8+param(21)
            t32 = t10*t31*t8+param(20)
            t33 = t10*t32*t8+param(19)
            t34 = t10*t33*t8+param(18)
            t35 = t10*t34*t8+param(17)
            t36 = t10*t35*t8+param(16)
            t37 = t10*t36*t8+param(15)
            t38 = t10*t37*t8+param(14)
            t39 = t10*t38*t8+param(13)
            t40 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t41 = 7.016926042943222d-1*t3*t40+2.2308199064d-1
            t42 = 7.016926042943222d-1*t3*t41+4.7231125998d-1
            t43 = 1/t42
            t44 = 1.425125466450768d+0*t2*t43+1.0d+0
            t45 = log(t44)
            t46 = 1.0522000558389213d-1*t5+1.0d+0
            t47 = 1.5874010519681994d+0
            t48 = rhoa**6.666666666666666d-1
            t49 = 1/t9**2
            t50 = 1/t2**3
            t51 = 1/rhoa**6.666666666666667d-1
            t52 = 1.090454542535705d-3*t45/rhoa**1.3333333333333333d+0-6
     1         .21814d-2*t46*(1.1876045553756398d-1*t3*t43*t51-1.4251254
     2         66450768d+0*t2*(7.016926042943222d-1*t3*(-5.8474383691193
     3         52d-2*t40*t50*t51-1.2576711796854242d-3/rhoa**1.333333333
     4         3333336d+0)-5.847438369119352d-2*t41*t50*t51)/t42**2)/t44
            t53 = exp(2.0000005873362642d+0*t45*t46)
            t54 = t53-1.0d+0
            t55 = 1/t54
            t56 = 1.0811057476031893d-1*gammaaa*t24*t55
            t57 = t56+1.0d+0
            t58 = 1/t54**2.0d+0
            t59 = 1.168789637500651d-2*t27*t58+t56+1.0d+0
            t60 = 1/t59
            t61 = 1.0811057476031893d-1*gammaaa*t24*t57*t60+1.0d+0
            t62 = log(t61)
            t63 = 1/t61
            t64 = rhoa**1.6666666666666674d-1
            t65 = 1/t23**3.0d+0
            t66 = -1.2612900388703877d-1*gammaaa*t55*t64*t65
            t67 = 3.4772651149362827d+0*gammaaa*t24*t52*t53/t54**2
            t68 = 1/t59**2
            t69 = 1/t23**4.0d+0
            fnc(iq) = 1.0d+0*(6.218138173930978d-2*rhoa*log(1.0811057476
     1         031892d-1*gammaaa*t24*(t26+1.0d+0)/(1.1687896375006504d-2
     2         *t27/t25**2.0d+0+t26+1.0d+0)+1.0d+0)*t39-1.243628d-1*rhoa
     3         *t22*t4*t6)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(6.218138173930978d-2*rhoa*t62*(t10*
     1         t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t
     2         8*(t10*t8*(t10*t8*(4.785390000313652d+0*t10*t28*t47*t48-4
     3         .785390000313652d+0*t28*t47*t48*t49*t8)-4.785390000313652
     4         d+0*t29*t47*t48*t49*t8+4.785390000313652d+0*t10*t29*t47*t
     5         48)-4.785390000313652d+0*t30*t47*t48*t49*t8+4.78539000031
     6         3652d+0*t10*t30*t47*t48)-4.785390000313652d+0*t31*t47*t48
     7         *t49*t8+4.785390000313652d+0*t10*t31*t47*t48)-4.785390000
     8         313652d+0*t32*t47*t48*t49*t8+4.785390000313652d+0*t10*t32
     9         *t47*t48)-4.785390000313652d+0*t33*t47*t48*t49*t8+4.78539
     :         0000313652d+0*t10*t33*t47*t48)-4.785390000313652d+0*t34*t
     ;         47*t48*t49*t8+4.785390000313652d+0*t10*t34*t47*t48)-4.785
     <         390000313652d+0*t35*t47*t48*t49*t8+4.785390000313652d+0*t
     =         10*t35*t47*t48)-4.785390000313652d+0*t36*t47*t48*t49*t8+4
     >         .785390000313652d+0*t10*t36*t47*t48)-4.785390000313652d+0
     ?         *t37*t47*t48*t49*t8+4.785390000313652d+0*t10*t37*t47*t48)
     @         -4.785390000313652d+0*t38*t47*t48*t49*t8+4.78539000031365
     1         2d+0*t10*t38*t47*t48)-1.243628d-1*rhoa*t45*t46*(t10*t8*(t
     2         10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t1
     3         0*t8*(t10*t8*(4.785390000313652d+0*t10*t11*t47*t48-4.7853
     4         90000313652d+0*t11*t47*t48*t49*t8)-4.785390000313652d+0*t
     5         12*t47*t48*t49*t8+4.785390000313652d+0*t10*t12*t47*t48)-4
     6         .785390000313652d+0*t13*t47*t48*t49*t8+4.785390000313652d
     7         +0*t10*t13*t47*t48)-4.785390000313652d+0*t14*t47*t48*t49*
     8         t8+4.785390000313652d+0*t10*t14*t47*t48)-4.78539000031365
     9         2d+0*t15*t47*t48*t49*t8+4.785390000313652d+0*t10*t15*t47*
     :         t48)-4.785390000313652d+0*t16*t47*t48*t49*t8+4.7853900003
     ;         13652d+0*t10*t16*t47*t48)-4.785390000313652d+0*t17*t47*t4
     <         8*t49*t8+4.785390000313652d+0*t10*t17*t47*t48)-4.78539000
     =         0313652d+0*t18*t47*t48*t49*t8+4.785390000313652d+0*t10*t1
     >         8*t47*t48)-4.785390000313652d+0*t19*t47*t48*t49*t8+4.7853
     ?         90000313652d+0*t10*t19*t47*t48)-4.785390000313652d+0*t20*
     @         t47*t48*t49*t8+4.785390000313652d+0*t10*t20*t47*t48)-4.78
     1         5390000313652d+0*t21*t47*t48*t49*t8+4.785390000313652d+0*
     2         t10*t21*t47*t48)+6.218138173930978d-2*rhoa*t39*t63*(-1.08
     3         11057476031893d-1*gammaaa*t24*t57*(t67+t66-2.727175820834
     4         852d-2*gammaaa**2*t58*t64/t23**5.0d+0+7.518582603395361d-
     5         1*t27*t52*t53/t54**3.0d+0)*t68+1.0811057476031893d-1*gamm
     6         aaa*t24*t60*(t67+t66)-1.2612900388703877d-1*gammaaa*t57*t
     7         60*t64*t65)+3.109069086965489d-2*t39*t62+2.0d+0*rhoa*t22*
     8         t52-6.21814d-2*t22*t45*t46)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 6.218138173930978d-2*rhoa*t39*t63*(-1.0811
     1         057476031893d-1*gammaaa*t24*t57*t68*(5.843948187503255d-3
     2         *gammaaa*t58*t69+2.7027643690079733d-2*t24*t55)+2.9219740
     3         937516275d-3*gammaaa*t55*t60*t69+2.7027643690079733d-2*t2
     4         4*t57*t60)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 6.218138173930978d-2*rhoa*t39*t63*(-1.0811
     1         057476031893d-1*gammaaa*t24*t57*t68*(1.168789637500651d-2
     2         *gammaaa*t58*t69+5.405528738015947d-2*t24*t55)+5.84394818
     3         7503255d-3*gammaaa*t55*t60*t69+5.405528738015947d-2*t24*t
     4         57*t60)*wght+Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 1.0d+0*(6.218138173930978d-2*rhoa*t62*(t10*
     1         t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t
     2         8*(t10*t8*(t10*t8*(-t28*t49*t8-t10*t28)-t29*t49*t8-t10*t2
     3         9)-t30*t49*t8-t10*t30)-t31*t49*t8-t10*t31)-t32*t49*t8-t10
     4         *t32)-t33*t49*t8-t10*t33)-t34*t49*t8-t10*t34)-t35*t49*t8-
     5         t10*t35)-t36*t49*t8-t10*t36)-t37*t49*t8-t10*t37)-t38*t49*
     6         t8-t10*t38)-1.243628d-1*rhoa*t45*t46*(t10*t8*(t10*t8*(t10
     7         *t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*
     8         t8*(-t11*t49*t8-t10*t11)-t12*t49*t8-t10*t12)-t13*t49*t8-t
     9         10*t13)-t14*t49*t8-t10*t14)-t15*t49*t8-t10*t15)-t16*t49*t
     :         8-t10*t16)-t17*t49*t8-t10*t17)-t18*t49*t8-t10*t18)-t19*t4
     ;         9*t8-t10*t19)-t20*t49*t8-t10*t20)-t21*t49*t8-t10*t21))*wg
     <         ht+Mmat(iq,D1_TA)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = 1/t2
            t4 = 1.325688999052018d-1*t3+1.0d+0
            t5 = t2**5.0d-1
            t6 = 1/t5
            t7 = 2.4141993114533214d-2*t6+1.0186556948d-1
            t8 = 7.876233178997433d-1*t6*t7+2.2308199064d-1
            t9 = 7.876233178997433d-1*t6*t8+4.7231125998d-1
            t10 = 1/t9
            t11 = 1.269642451250142d+0*t10*t5+1.0d+0
            t12 = log(t11)
            t13 = rhoa-rhob
            t14 = 1/t1
            t15 = 1.0d+0-t13*t14
            t16 = t13*t14+1.0d+0
            t17 = 1.923661050931536d+0*t16**1.3333333333333333d+0+1.9236
     1         61050931536d+0*t15**1.3333333333333333d+0-3.8473221018630
     2         72d+0
            t18 = 6.901399211255826d-2*t3+1.0d+0
            t19 = 1.3212998810398843d-2*t6+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t6+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t6+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t22*t5+1.0d+0
            t24 = log(t23)
            t25 = t13**4
            t26 = 1/t1**4
            t27 = 1.2746961887000874d-1*t3+1.0d+0
            t28 = 1.530901310039024d-2*t6+1.0465751434d-1
            t29 = 7.876233178997433d-1*t28*t6+1.9269083139d-1
            t30 = 7.876233178997433d-1*t29*t6+4.3896648423d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t31*t5+1.0d+0
            t33 = log(t32)
            t34 = 1.709920934161365d+0*(6.21814d-2*t12*t4-3.10907d-2*t27
     1         *t33)-3.37738d-2*t18*t24
            t35 = t25*t26*t34+3.37738d-2*t18*t24
            t36 = 5.848223622634648d-1*t17*t35-6.21814d-2*t12*t4
            t37 = 2.871234000188191d+0*t1**1.6666666666666669d+0
            t38 = -taub-taua+t37
            t39 = taub+taua+t37
            t40 = 1/t39
            t41 = param(12)
            t42 = t38*t40*t41+param(11)
            t43 = t38*t40*t42+param(10)
            t44 = t38*t40*t43+param(9)
            t45 = t38*t40*t44+param(8)
            t46 = t38*t40*t45+param(7)
            t47 = t38*t40*t46+param(6)
            t48 = t38*t40*t47+param(5)
            t49 = t38*t40*t48+param(4)
            t50 = t38*t40*t49+param(3)
            t51 = t38*t40*t50+param(2)
            t52 = t38*t40*t51+param(1)
            t53 = 5.0d-1*t16**6.666666666666666d-1+5.0d-1*t15**6.6666666
     1         66666666d-1
            t54 = t53**3.0d+0
            t55 = gammabb+2.0d+0*gammaab+gammaaa
            t56 = t1**1.1666666666666667d+0
            t57 = 1/t56**2.0d+0
            t58 = t53**2.0d+0
            t59 = 1/t58
            t60 = 1/t54
            t61 = exp(-3.216396844291483d+1*t36*t60)
            t62 = t61-1.0d+0
            t63 = 1/t62
            t64 = 1.3621078885675922d-1*t55*t57*t59*t63
            t65 = t64+1.0d+0
            t66 = 1/t53**4.0d+0
            t67 = (t55*t57)**2.0d+0
            t68 = 1/t62**2.0d+0
            t69 = 1.855337900098064d-2*t66*t67*t68+t64+1.0d+0
            t70 = 1/t69
            t71 = 1.3621078885675922d-1*t55*t57*t59*t65*t70+1.0d+0
            t72 = log(t71)
            t73 = param(24)
            t74 = t38*t40*t73+param(23)
            t75 = t38*t40*t74+param(22)
            t76 = t38*t40*t75+param(21)
            t77 = t38*t40*t76+param(20)
            t78 = t38*t40*t77+param(19)
            t79 = t38*t40*t78+param(18)
            t80 = t38*t40*t79+param(17)
            t81 = t38*t40*t80+param(16)
            t82 = t38*t40*t81+param(15)
            t83 = t38*t40*t82+param(14)
            t84 = t38*t40*t83+param(13)
            t85 = t1**6.666666666666666d-1
            t86 = 1/t39**2
            t87 = 1.0d+0*t1*t36*(t38*t40*(t38*t40*(t38*t40*(t38*t40*(t38
     1         *t40*(t38*t40*(t38*t40*(t38*t40*(t38*t40*(t38*t40*(4.7853
     2         90000313652d+0*t40*t41*t85-4.785390000313652d+0*t38*t41*t
     3         85*t86)-4.785390000313652d+0*t38*t42*t85*t86+4.7853900003
     4         13652d+0*t40*t42*t85)-4.785390000313652d+0*t38*t43*t85*t8
     5         6+4.785390000313652d+0*t40*t43*t85)-4.785390000313652d+0*
     6         t38*t44*t85*t86+4.785390000313652d+0*t40*t44*t85)-4.78539
     7         0000313652d+0*t38*t45*t85*t86+4.785390000313652d+0*t40*t4
     8         5*t85)-4.785390000313652d+0*t38*t46*t85*t86+4.78539000031
     9         3652d+0*t40*t46*t85)-4.785390000313652d+0*t38*t47*t85*t86
     :         +4.785390000313652d+0*t40*t47*t85)-4.785390000313652d+0*t
     ;         38*t48*t85*t86+4.785390000313652d+0*t40*t48*t85)-4.785390
     <         000313652d+0*t38*t49*t85*t86+4.785390000313652d+0*t40*t49
     =         *t85)-4.785390000313652d+0*t38*t50*t85*t86+4.785390000313
     >         652d+0*t40*t50*t85)-4.785390000313652d+0*t38*t51*t85*t86+
     ?         4.785390000313652d+0*t40*t51*t85)
            t88 = 1/t1**1.3333333333333336d+0
            t89 = 1/t1**6.666666666666667d-1
            t90 = 1/t5**3
            t91 = 2.11607075208357d-1*t10*t6*t89-1.269642451250142d+0*t5
     1         *(7.876233178997433d-1*t6*(-1.3127055298329054d-1*t7*t89*
     2         t90-3.169132786263567d-3*t88)-1.3127055298329054d-1*t8*t8
     3         9*t90)/t9**2
            t92 = 1/t11
            t93 = -6.21814d-2*t4*t91*t92
            t94 = 1/t1**1.3333333333333333d+0
            t95 = 2.747773264188438d-3*t12*t94
            t96 = 2.11607075208357d-1*t22*t6*t89-1.269642451250142d+0*t5
     1         *(7.876233178997433d-1*t6*(-1.3127055298329054d-1*t19*t89
     2         *t90-1.7344776604086162d-3*t88)-1.3127055298329054d-1*t20
     3         *t89*t90)/t21**2
            t97 = 1/t23
            t98 = 3.37738d-2*t18*t96*t97
            t99 = -7.769549222703733d-4*t24*t94
            t100 = t25*t26*(-3.37738d-2*t18*t96*t97+1.709920934161365d+0
     1         *(1.3210398931339265d-3*t33*t94-2.747773264188438d-3*t12*
     2         t94+6.21814d-2*t4*t91*t92-3.10907d-2*t27*(2.1160707520835
     3         7d-1*t31*t6*t89-1.269642451250142d+0*t5*(7.87623317899743
     4         3d-1*t6*(-1.3127055298329054d-1*t28*t89*t90-2.00962261531
     5         66658d-3*t88)-1.3127055298329054d-1*t29*t89*t90)/t30**2)/
     6         t32)+7.769549222703733d-4*t24*t94)
            t101 = -4*t25*t34/t1**5
            t102 = t13**3
            t103 = 1/t1**2
            t104 = t103*t13
            t105 = -t14
            t106 = t105+t104
            t107 = t15**3.333333333333333d-1
            t108 = -t103*t13
            t109 = t14+t108
            t110 = t16**3.333333333333333d-1
            t111 = 5.848223622634648d-1*t17*(t99+t98+4*t102*t26*t34+t101
     1         +t100)+t95+t93+5.848223622634648d-1*(2.564881401242048d+0
     2         *t109*t110+2.564881401242048d+0*t106*t107)*t35
            t112 = 1.0d+0*t36*t52
            t113 = 3.109069086965489d-2*t1*t54*t72*(t38*t40*(t38*t40*(t3
     1         8*t40*(t38*t40*(t38*t40*(t38*t40*(t38*t40*(t38*t40*(t38*t
     2         40*(t38*t40*(4.785390000313652d+0*t40*t73*t85-4.785390000
     3         313652d+0*t38*t73*t85*t86)-4.785390000313652d+0*t38*t74*t
     4         85*t86+4.785390000313652d+0*t40*t74*t85)-4.78539000031365
     5         2d+0*t38*t75*t85*t86+4.785390000313652d+0*t40*t75*t85)-4.
     6         785390000313652d+0*t38*t76*t85*t86+4.785390000313652d+0*t
     7         40*t76*t85)-4.785390000313652d+0*t38*t77*t85*t86+4.785390
     8         000313652d+0*t40*t77*t85)-4.785390000313652d+0*t38*t78*t8
     9         5*t86+4.785390000313652d+0*t40*t78*t85)-4.785390000313652
     :         d+0*t38*t79*t85*t86+4.785390000313652d+0*t40*t79*t85)-4.7
     ;         85390000313652d+0*t38*t80*t85*t86+4.785390000313652d+0*t4
     <         0*t80*t85)-4.785390000313652d+0*t38*t81*t85*t86+4.7853900
     =         00313652d+0*t40*t81*t85)-4.785390000313652d+0*t38*t82*t85
     >         *t86+4.785390000313652d+0*t40*t82*t85)-4.785390000313652d
     ?         +0*t38*t83*t85*t86+4.785390000313652d+0*t40*t83*t85)
            t114 = 1/t71
            t115 = 1/t107
            t116 = 1/t110
            t117 = 3.333333333333333d-1*t109*t116+3.333333333333333d-1*t
     1         106*t115
            t118 = t1**1.6666666666666674d-1
            t119 = 1/t56**3.0d+0
            t120 = -3.1782517399910487d-1*t118*t119*t55*t59*t65*t70
            t121 = -2.7242157771351844d-1*t117*t55*t57*t60*t63
            t122 = -3.1782517399910487d-1*t118*t119*t55*t59*t63
            t123 = 1/t62**2
            t124 = 9.649190532874448d+1*t117*t36*t66-3.216396844291483d+
     1         1*t111*t60
            t125 = -1.3621078885675922d-1*t123*t124*t55*t57*t59*t61
            t126 = 1/t69**2
            t127 = -8.658243533790966d-2*t118*t55**2*t66*t68/t56**5.0d+0
            t128 = 1/t53**5.0d+0
            t129 = 1/t62**3.0d+0
            t130 = 3.109069086965489d-2*t54*t72*t84
            t131 = t14+t104
            t132 = t108+t105
            t133 = 5.848223622634648d-1*t17*(t99+t98-4*t102*t26*t34+t101
     1         +t100)+t95+t93+5.848223622634648d-1*(2.564881401242048d+0
     2         *t110*t132+2.564881401242048d+0*t107*t131)*t35
            t134 = 3.333333333333333d-1*t116*t132+3.333333333333333d-1*t
     1         115*t131
            t135 = -2.7242157771351844d-1*t134*t55*t57*t60*t63
            t136 = 9.649190532874448d+1*t134*t36*t66-3.216396844291483d+
     1         1*t133*t60
            t137 = -1.3621078885675922d-1*t123*t136*t55*t57*t59*t61
            t138 = 1/t56**4.0d+0
            t139 = 3.109069086965489d-2*t1*t114*t54*(1.855337900098064d-
     1         2*t138*t55*t63*t66*t70+1.3621078885675922d-1*t57*t59*t65*
     2         t70-1.3621078885675922d-1*t126*t55*t57*t59*t65*(3.7106758
     3         00196128d-2*t138*t55*t66*t68+1.3621078885675922d-1*t57*t5
     4         9*t63))*t84*wght
            t140 = 1.0d+0*(3.109069086965489d-2*t1*t54*t72*(t38*t40*(t38
     1         *t40*(t38*t40*(t38*t40*(t38*t40*(t38*t40*(t38*t40*(t38*t4
     2         0*(t38*t40*(t38*t40*(-t38*t73*t86-t40*t73)-t38*t74*t86-t4
     3         0*t74)-t38*t75*t86-t40*t75)-t38*t76*t86-t40*t76)-t38*t77*
     4         t86-t40*t77)-t38*t78*t86-t40*t78)-t38*t79*t86-t40*t79)-t3
     5         8*t80*t86-t40*t80)-t38*t81*t86-t40*t81)-t38*t82*t86-t40*t
     6         82)-t38*t83*t86-t40*t83)+1.0d+0*t1*t36*(t38*t40*(t38*t40*
     7         (t38*t40*(t38*t40*(t38*t40*(t38*t40*(t38*t40*(t38*t40*(t3
     8         8*t40*(t38*t40*(-t38*t41*t86-t40*t41)-t38*t42*t86-t40*t42
     9         )-t38*t43*t86-t40*t43)-t38*t44*t86-t40*t44)-t38*t45*t86-t
     :         40*t45)-t38*t46*t86-t40*t46)-t38*t47*t86-t40*t47)-t38*t48
     ;         *t86-t40*t48)-t38*t49*t86-t40*t49)-t38*t50*t86-t40*t50)-t
     <         38*t51*t86-t40*t51))*wght
            fnc(iq) = 1.0d+0*(3.109069086965489d-2*t1*t54*t72*t84+1.0d+0
     1         *t1*t36*t52)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(t87+9.327207260896466d-2*t1*t117*t5
     1         8*t72*t84+3.109069086965489d-2*t1*t114*t54*(-2.7242157771
     2         351844d-1*t117*t55*t57*t60*t65*t70+1.3621078885675922d-1*
     3         (t125+t122+t121)*t55*t57*t59*t70-1.3621078885675922d-1*t1
     4         26*t55*t57*t59*t65*(-7.421351600392256d-2*t117*t128*t67*t
     5         68-3.710675800196128d-2*t124*t129*t61*t66*t67+t127+t125+t
     6         122+t121)+t120)*t84+1.0d+0*t1*t111*t52+t130+t113+t112)*wg
     7         ht+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(t87+9.327207260896466d-2*t1*t134*t5
     1         8*t72*t84+3.109069086965489d-2*t1*t114*t54*(-2.7242157771
     2         351844d-1*t134*t55*t57*t60*t65*t70+1.3621078885675922d-1*
     3         (t137+t135+t122)*t55*t57*t59*t70-1.3621078885675922d-1*t1
     4         26*t55*t57*t59*t65*(-7.421351600392256d-2*t128*t134*t67*t
     5         68-3.710675800196128d-2*t129*t136*t61*t66*t67+t137+t135+t
     6         127+t122)+t120)*t84+1.0d+0*t1*t133*t52+t130+t113+t112)*wg
     7         ht+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t139+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 3.109069086965489d-2*t1*t114*t54*(3.710675
     1         800196128d-2*t138*t55*t63*t66*t70+2.7242157771351844d-1*t
     2         57*t59*t65*t70-1.3621078885675922d-1*t126*t55*t57*t59*t65
     3         *(7.421351600392256d-2*t138*t55*t66*t68+2.724215777135184
     4         4d-1*t57*t59*t63))*t84*wght+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t139+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = t140+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = t140+Mmat(iq,D1_TB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 9.999999999999991d-1*(6.21814d-2*t17*t18-3.10907d-2*t1
     1         1*t9)-6.21814d-2*t17*t18
            t20 = 2.871234000188191d+0*rhoa**1.6666666666666669d+0
            t21 = -taub-taua+t20
            t22 = taub+taua+t20
            t23 = 1/t22
            t24 = param(12)
            t25 = t21*t23*t24+param(11)
            t26 = t21*t23*t25+param(10)
            t27 = t21*t23*t26+param(9)
            t28 = t21*t23*t27+param(8)
            t29 = t21*t23*t28+param(7)
            t30 = t21*t23*t29+param(6)
            t31 = t21*t23*t30+param(5)
            t32 = t21*t23*t31+param(4)
            t33 = t21*t23*t32+param(3)
            t34 = t21*t23*t33+param(2)
            t35 = t21*t23*t34+param(1)
            t36 = rhoa**1.1666666666666667d+0
            t37 = 1/t36**2.0d+0
            t38 = exp(-6.432793688582967d+1*t19)
            t39 = t38-1.0d+0
            t40 = 1/t39
            t41 = 2.1622114952063792d-1*gammaaa*t37*t40
            t42 = t41+1.0d+0
            t43 = (gammaaa*t37)**2.0d+0
            t44 = 1/t39**2.0d+0
            t45 = 4.675158550002606d-2*t43*t44+t41+1.0d+0
            t46 = 1/t45
            t47 = 2.1622114952063792d-1*gammaaa*t37*t42*t46+1.0d+0
            t48 = log(t47)
            t49 = param(24)
            t50 = t21*t23*t49+param(23)
            t51 = t21*t23*t50+param(22)
            t52 = t21*t23*t51+param(21)
            t53 = t21*t23*t52+param(20)
            t54 = t21*t23*t53+param(19)
            t55 = t21*t23*t54+param(18)
            t56 = t21*t23*t55+param(17)
            t57 = t21*t23*t56+param(16)
            t58 = t21*t23*t57+param(15)
            t59 = t21*t23*t58+param(14)
            t60 = t21*t23*t59+param(13)
            t61 = rhoa**6.666666666666666d-1
            t62 = 1/t22**2
            t63 = 1/rhoa**1.3333333333333333d+0
            t64 = 1/rhoa**1.3333333333333336d+0
            t65 = 1/t2**3
            t66 = 1/rhoa**6.666666666666667d-1
            t67 = 1/t16
            t68 = 2.11607075208357d-1*t15*t3*t66-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t12*t65
     2         *t66-3.169132786263567d-3*t64)-1.3127055298329054d-1*t13*
     3         t65*t66)/t14**2
            t69 = 9.999999999999991d-1*(1.3210398931339265d-3*t63*t9-3.1
     1         0907d-2*t11*(2.11607075208357d-1*t3*t66*t7-1.269642451250
     2         142d+0*t2*(7.876233178997433d-1*t3*(-1.3127055298329054d-
     3         1*t4*t65*t66-2.0096226153166658d-3*t64)-1.312705529832905
     4         4d-1*t5*t65*t66)/t6**2)/t8+6.21814d-2*t18*t67*t68-2.74777
     5         3264188438d-3*t17*t63)-6.21814d-2*t18*t67*t68+2.747773264
     6         188438d-3*t17*t63
            t70 = 1/t47
            t71 = rhoa**1.6666666666666674d-1
            t72 = 1/t36**3.0d+0
            t73 = -5.045160155481552d-1*gammaaa*t40*t71*t72
            t74 = 1.3909060459745137d+1*gammaaa*t37*t38*t69/t39**2
            t75 = 1/t45**2
            t76 = 1/t36**4.0d+0
            t77 = 1.0d+0*(1.5545345434827443d-2*rhoa*t48*(t21*t23*(t21*t
     1         23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*
     2         (t21*t23*(t21*t23*(-t21*t49*t62-t23*t49)-t21*t50*t62-t23*
     3         t50)-t21*t51*t62-t23*t51)-t21*t52*t62-t23*t52)-t21*t53*t6
     4         2-t23*t53)-t21*t54*t62-t23*t54)-t21*t55*t62-t23*t55)-t21*
     5         t56*t62-t23*t56)-t21*t57*t62-t23*t57)-t21*t58*t62-t23*t58
     6         )-t21*t59*t62-t23*t59)+1.0d+0*rhoa*t19*(t21*t23*(t21*t23*
     7         (t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t2
     8         1*t23*(t21*t23*(-t21*t24*t62-t23*t24)-t21*t25*t62-t23*t25
     9         )-t21*t26*t62-t23*t26)-t21*t27*t62-t23*t27)-t21*t28*t62-t
     :         23*t28)-t21*t29*t62-t23*t29)-t21*t30*t62-t23*t30)-t21*t31
     ;         *t62-t23*t31)-t21*t32*t62-t23*t32)-t21*t33*t62-t23*t33)-t
     <         21*t34*t62-t23*t34))*wght
            fnc(iq) = 1.0d+0*(1.5545345434827443d-2*rhoa*t48*t60+1.0d+0*
     1         rhoa*t19*t35)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(1.5545345434827443d-2*rhoa*t60*t70*
     1         (-2.1622114952063792d-1*gammaaa*t37*t42*(t74+t73-2.181740
     2         656667883d-1*gammaaa**2*t44*t71/t36**5.0d+0+6.01486608271
     3         6293d+0*t38*t43*t69/t39**3.0d+0)*t75+2.1622114952063792d-
     4         1*gammaaa*t37*t46*(t74+t73)-5.045160155481552d-1*gammaaa*
     5         t42*t46*t71*t72)+1.0d+0*rhoa*t35*t69+1.5545345434827443d-
     6         2*rhoa*t48*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(
     7         t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(4.7853900003
     8         13652d+0*t23*t49*t61-4.785390000313652d+0*t21*t49*t61*t62
     9         )-4.785390000313652d+0*t21*t50*t61*t62+4.785390000313652d
     :         +0*t23*t50*t61)-4.785390000313652d+0*t21*t51*t61*t62+4.78
     ;         5390000313652d+0*t23*t51*t61)-4.785390000313652d+0*t21*t5
     <         2*t61*t62+4.785390000313652d+0*t23*t52*t61)-4.78539000031
     =         3652d+0*t21*t53*t61*t62+4.785390000313652d+0*t23*t53*t61)
     >         -4.785390000313652d+0*t21*t54*t61*t62+4.785390000313652d+
     ?         0*t23*t54*t61)-4.785390000313652d+0*t21*t55*t61*t62+4.785
     @         390000313652d+0*t23*t55*t61)-4.785390000313652d+0*t21*t56
     1         *t61*t62+4.785390000313652d+0*t23*t56*t61)-4.785390000313
     2         652d+0*t21*t57*t61*t62+4.785390000313652d+0*t23*t57*t61)-
     3         4.785390000313652d+0*t21*t58*t61*t62+4.785390000313652d+0
     4         *t23*t58*t61)-4.785390000313652d+0*t21*t59*t61*t62+4.7853
     5         90000313652d+0*t23*t59*t61)+1.0d+0*rhoa*t19*(t21*t23*(t21
     6         *t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t2
     7         3*(t21*t23*(t21*t23*(4.785390000313652d+0*t23*t24*t61-4.7
     8         85390000313652d+0*t21*t24*t61*t62)-4.785390000313652d+0*t
     9         21*t25*t61*t62+4.785390000313652d+0*t23*t25*t61)-4.785390
     :         000313652d+0*t21*t26*t61*t62+4.785390000313652d+0*t23*t26
     ;         *t61)-4.785390000313652d+0*t21*t27*t61*t62+4.785390000313
     <         652d+0*t23*t27*t61)-4.785390000313652d+0*t21*t28*t61*t62+
     =         4.785390000313652d+0*t23*t28*t61)-4.785390000313652d+0*t2
     >         1*t29*t61*t62+4.785390000313652d+0*t23*t29*t61)-4.7853900
     ?         00313652d+0*t21*t30*t61*t62+4.785390000313652d+0*t23*t30*
     @         t61)-4.785390000313652d+0*t21*t31*t61*t62+4.7853900003136
     1         52d+0*t23*t31*t61)-4.785390000313652d+0*t21*t32*t61*t62+4
     2         .785390000313652d+0*t23*t32*t61)-4.785390000313652d+0*t21
     3         *t33*t61*t62+4.785390000313652d+0*t23*t33*t61)-4.78539000
     4         0313652d+0*t21*t34*t61*t62+4.785390000313652d+0*t23*t34*t
     5         61)+1.5545345434827443d-2*t48*t60+1.0d+0*t19*t35)*wght+Am
     6         at(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.5545345434827443d-2*rhoa*t60*t70*(-2.162
     1         2114952063792d-1*gammaaa*t37*t42*t75*(9.350317100005212d-
     2         2*gammaaa*t44*t76+2.1622114952063792d-1*t37*t40)+4.675158
     3         550002606d-2*gammaaa*t40*t46*t76+2.1622114952063792d-1*t3
     4         7*t42*t46)*wght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = t77+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = t77+Mmat(iq,D1_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 9.999999999999991d-1*(6.21814d-2*t17*t18-3.10907d-2*t1
     1         1*t9)-6.21814d-2*t17*t18
            t20 = 2.871234000188191d+0*rhob**1.6666666666666669d+0
            t21 = -taub-taua+t20
            t22 = taub+taua+t20
            t23 = 1/t22
            t24 = param(12)
            t25 = t21*t23*t24+param(11)
            t26 = t21*t23*t25+param(10)
            t27 = t21*t23*t26+param(9)
            t28 = t21*t23*t27+param(8)
            t29 = t21*t23*t28+param(7)
            t30 = t21*t23*t29+param(6)
            t31 = t21*t23*t30+param(5)
            t32 = t21*t23*t31+param(4)
            t33 = t21*t23*t32+param(3)
            t34 = t21*t23*t33+param(2)
            t35 = t21*t23*t34+param(1)
            t36 = rhob**1.1666666666666667d+0
            t37 = 1/t36**2.0d+0
            t38 = exp(-6.432793688582967d+1*t19)
            t39 = t38-1.0d+0
            t40 = 1/t39
            t41 = 2.1622114952063792d-1*gammabb*t37*t40
            t42 = t41+1.0d+0
            t43 = (gammabb*t37)**2.0d+0
            t44 = 1/t39**2.0d+0
            t45 = 4.675158550002606d-2*t43*t44+t41+1.0d+0
            t46 = 1/t45
            t47 = 2.1622114952063792d-1*gammabb*t37*t42*t46+1.0d+0
            t48 = log(t47)
            t49 = param(24)
            t50 = t21*t23*t49+param(23)
            t51 = t21*t23*t50+param(22)
            t52 = t21*t23*t51+param(21)
            t53 = t21*t23*t52+param(20)
            t54 = t21*t23*t53+param(19)
            t55 = t21*t23*t54+param(18)
            t56 = t21*t23*t55+param(17)
            t57 = t21*t23*t56+param(16)
            t58 = t21*t23*t57+param(15)
            t59 = t21*t23*t58+param(14)
            t60 = t21*t23*t59+param(13)
            t61 = rhob**6.666666666666666d-1
            t62 = 1/t22**2
            t63 = 1/rhob**1.3333333333333333d+0
            t64 = 1/rhob**1.3333333333333336d+0
            t65 = 1/t2**3
            t66 = 1/rhob**6.666666666666667d-1
            t67 = 1/t16
            t68 = 2.11607075208357d-1*t15*t3*t66-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t12*t65
     2         *t66-3.169132786263567d-3*t64)-1.3127055298329054d-1*t13*
     3         t65*t66)/t14**2
            t69 = 9.999999999999991d-1*(1.3210398931339265d-3*t63*t9-3.1
     1         0907d-2*t11*(2.11607075208357d-1*t3*t66*t7-1.269642451250
     2         142d+0*t2*(7.876233178997433d-1*t3*(-1.3127055298329054d-
     3         1*t4*t65*t66-2.0096226153166658d-3*t64)-1.312705529832905
     4         4d-1*t5*t65*t66)/t6**2)/t8+6.21814d-2*t18*t67*t68-2.74777
     5         3264188438d-3*t17*t63)-6.21814d-2*t18*t67*t68+2.747773264
     6         188438d-3*t17*t63
            t70 = 1/t47
            t71 = rhob**1.6666666666666674d-1
            t72 = 1/t36**3.0d+0
            t73 = -5.045160155481552d-1*gammabb*t40*t71*t72
            t74 = 1.3909060459745137d+1*gammabb*t37*t38*t69/t39**2
            t75 = 1/t45**2
            t76 = 1/t36**4.0d+0
            t77 = 1.0d+0*(1.5545345434827443d-2*rhob*t48*(t21*t23*(t21*t
     1         23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*
     2         (t21*t23*(t21*t23*(-t21*t49*t62-t23*t49)-t21*t50*t62-t23*
     3         t50)-t21*t51*t62-t23*t51)-t21*t52*t62-t23*t52)-t21*t53*t6
     4         2-t23*t53)-t21*t54*t62-t23*t54)-t21*t55*t62-t23*t55)-t21*
     5         t56*t62-t23*t56)-t21*t57*t62-t23*t57)-t21*t58*t62-t23*t58
     6         )-t21*t59*t62-t23*t59)+1.0d+0*rhob*t19*(t21*t23*(t21*t23*
     7         (t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t2
     8         1*t23*(t21*t23*(-t21*t24*t62-t23*t24)-t21*t25*t62-t23*t25
     9         )-t21*t26*t62-t23*t26)-t21*t27*t62-t23*t27)-t21*t28*t62-t
     :         23*t28)-t21*t29*t62-t23*t29)-t21*t30*t62-t23*t30)-t21*t31
     ;         *t62-t23*t31)-t21*t32*t62-t23*t32)-t21*t33*t62-t23*t33)-t
     <         21*t34*t62-t23*t34))*wght
            fnc(iq) = 1.0d+0*(1.5545345434827443d-2*rhob*t48*t60+1.0d+0*
     1         rhob*t19*t35)*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*(1.5545345434827443d-2*rhob*t60*t70*
     1         (-2.1622114952063792d-1*gammabb*t37*t42*(t74+t73-2.181740
     2         656667883d-1*gammabb**2*t44*t71/t36**5.0d+0+6.01486608271
     3         6293d+0*t38*t43*t69/t39**3.0d+0)*t75+2.1622114952063792d-
     4         1*gammabb*t37*t46*(t74+t73)-5.045160155481552d-1*gammabb*
     5         t42*t46*t71*t72)+1.0d+0*rhob*t35*t69+1.5545345434827443d-
     6         2*rhob*t48*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(
     7         t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(4.7853900003
     8         13652d+0*t23*t49*t61-4.785390000313652d+0*t21*t49*t61*t62
     9         )-4.785390000313652d+0*t21*t50*t61*t62+4.785390000313652d
     :         +0*t23*t50*t61)-4.785390000313652d+0*t21*t51*t61*t62+4.78
     ;         5390000313652d+0*t23*t51*t61)-4.785390000313652d+0*t21*t5
     <         2*t61*t62+4.785390000313652d+0*t23*t52*t61)-4.78539000031
     =         3652d+0*t21*t53*t61*t62+4.785390000313652d+0*t23*t53*t61)
     >         -4.785390000313652d+0*t21*t54*t61*t62+4.785390000313652d+
     ?         0*t23*t54*t61)-4.785390000313652d+0*t21*t55*t61*t62+4.785
     @         390000313652d+0*t23*t55*t61)-4.785390000313652d+0*t21*t56
     1         *t61*t62+4.785390000313652d+0*t23*t56*t61)-4.785390000313
     2         652d+0*t21*t57*t61*t62+4.785390000313652d+0*t23*t57*t61)-
     3         4.785390000313652d+0*t21*t58*t61*t62+4.785390000313652d+0
     4         *t23*t58*t61)-4.785390000313652d+0*t21*t59*t61*t62+4.7853
     5         90000313652d+0*t23*t59*t61)+1.0d+0*rhob*t19*(t21*t23*(t21
     6         *t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t2
     7         3*(t21*t23*(t21*t23*(4.785390000313652d+0*t23*t24*t61-4.7
     8         85390000313652d+0*t21*t24*t61*t62)-4.785390000313652d+0*t
     9         21*t25*t61*t62+4.785390000313652d+0*t23*t25*t61)-4.785390
     :         000313652d+0*t21*t26*t61*t62+4.785390000313652d+0*t23*t26
     ;         *t61)-4.785390000313652d+0*t21*t27*t61*t62+4.785390000313
     <         652d+0*t23*t27*t61)-4.785390000313652d+0*t21*t28*t61*t62+
     =         4.785390000313652d+0*t23*t28*t61)-4.785390000313652d+0*t2
     >         1*t29*t61*t62+4.785390000313652d+0*t23*t29*t61)-4.7853900
     ?         00313652d+0*t21*t30*t61*t62+4.785390000313652d+0*t23*t30*
     @         t61)-4.785390000313652d+0*t21*t31*t61*t62+4.7853900003136
     1         52d+0*t23*t31*t61)-4.785390000313652d+0*t21*t32*t61*t62+4
     2         .785390000313652d+0*t23*t32*t61)-4.785390000313652d+0*t21
     3         *t33*t61*t62+4.785390000313652d+0*t23*t33*t61)-4.78539000
     4         0313652d+0*t21*t34*t61*t62+4.785390000313652d+0*t23*t34*t
     5         61)+1.5545345434827443d-2*t48*t60+1.0d+0*t19*t35)*wght+Am
     6         at(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.5545345434827443d-2*rhob*t60*t70*(-2.162
     1         2114952063792d-1*gammabb*t37*t42*t75*(9.350317100005212d-
     2         2*gammabb*t44*t76+2.1622114952063792d-1*t37*t40)+4.675158
     3         550002606d-2*gammabb*t40*t46*t76+2.1622114952063792d-1*t3
     4         7*t42*t46)*wght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = t77+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = t77+Mmat(iq,D1_TA)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_m11 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& 0.1325688999052018\,{\it t_3}+1.0\\\\ 
C>   {\it t_5} &=& \sqrt{{\it t_2}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_5}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.02414199311453321\,{\it t_6}
C>    +0.10186556948\right)+0.22308199064\right)+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{10}} &=& 1.0-{\it t_8}\,{\it t_9}\\\\ 
C>   {\it t_{11}} &=& {\it t_8}\,{\it t_9}+1.0\\\\ 
C>   {\it t_{12}} &=& 0.06901399211255826\,{\it t_3}+1.0\\\\ 
C>   {\it t_{13}} &=& \log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01321299881039884
C>    \,{\it t_6}+0.029729725188\right)+0.12236585478\right)
C>    +0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{14}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{11}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{10}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_8}^4\,\left(1.709920934161365\,\left(0.0621814
C>    \,{\it t_4}\,{\it t_7}-0.0310907\,\left(0.1274696188700087
C>    \,{\it t_3}+1.0\right)\,\log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01530901310039024
C>    \,{\it t_6}+0.10465751434\right)+0.19269083139\right)
C>    +0.43896648423}}+1.0\right)\right)-0.0337738\,{\it t_{12}}
C>    \,{\it t_{13}}\right)}\over{{\it t_1}^4}}+0.0337738\,{
C>    \it t_{12}}\,{\it t_{13}}\right)-0.0621814\,{\it t_4}\,{
C>    \it t_7}\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{16}} &=& 2.871234000188191\,{\it t_1}^{{{5}\over{3}}}\\\\ 
C>   {\it t_{17}} &=& -\tau_\beta-\tau_\alpha+{\it t_{16}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{\tau_\beta+\tau_\alpha+{
C>    \it t_{16}}}}\\\\ 
C>   {\it t_{19}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{20}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{21}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{22}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{23}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{29}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{30}} &=& 0.5\,{\it t_{11}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{10}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{31}} &=& {\it t_{30}}^{3.0}\\\\ 
C>   {\it t_{32}} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{{\it t_{30}}^{2.0}}}\\\\ 
C>   {\it t_{34}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{e^{{{32.16396844291483\,{
C>    \it t_{14}}}\over{{\it t_{31}}}}}}}-1.0\\\\ 
C>   {\it t_{36}} &=& {{0.1362107888567592\,{\it t_{32}}\,{
C>    \it t_{33}}\,{\it t_{34}}}\over{{\it t_{35}}}}\\\\ 
C>   {\it t_{37}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{38}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{39}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{40}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{41}} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{42}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{43}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{44}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(23\right)\\\\ 
C>   {\it t_{48}} &=& {\it param}\left(24\right)\\\\ 
C>   {\it t_{49}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{50}} &=& \sqrt{{\it t_{49}}}\\\\ 
C>   {\it t_{51}} &=& {{1}\over{{\it t_{50}}}}\\\\ 
C>   {\it t_{52}} &=& {{1}\over{{\it t_{49}}}}\\\\ 
C>   {\it t_{53}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{50}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{51}}+0.10186556948\right)
C>    \,{\it t_{51}}+0.22308199064\right)\,{\it t_{51}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{54}} &=& 0.1325688999052018\,{\it t_{52}}+1.0\\\\ 
C>   {\it t_{55}} &=& 0.9999999999999991\,\left(0.0621814\,{
C>    \it t_{53}}\,{\it t_{54}}-0.0310907\,\log 
C>    \left({{1.269642451250142\,{\it t_{50}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{51}}+0.10465751434\right)
C>    \,{\it t_{51}}+0.19269083139\right)\,{\it t_{51}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{52}}+1.0\right)\right)-0.0621814\,{\it t_{53}}\,{
C>    \it t_{54}}\\\\ 
C>   {\it t_{56}} &=& 2.871234000188191\,\rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{57}} &=& -\tau_{\bar s}-\tau_s+{\it t_{56}}\\\\ 
C>   {\it t_{58}} &=& {{1}\over{\tau_{\bar s}+\tau_s+{\it t_{56}}}}\\\\ 
C>   {\it t_{59}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{60}} &=& {{1}\over{e^{64.32793688582967\,{\it t_{55}}}}}
C>    -1.0\\\\ 
C>   {\it t_{61}} &=& {{0.2162211495206379\,{\it t_{59}}\,
C>    \sigma_{ss}}\over{{\it t_{60}}}}\\\\ 
C>   f &=& 1.0\,\left(0.03109069086965489\,{\it t_1}\,{\it t_{31}}
C>    \,\log \left({{0.1362107888567592\,{\it t_{32}}\,{\it t_{33}}
C>    \,{\it t_{34}}\,\left({\it t_{36}}+1.0\right)}
C>    \over{{{0.01855337900098064\,\left({\it t_{32}}\,{
C>    \it t_{34}}\right)^{2.0}}\over{{\it t_{30}}^{4.0}\,{
C>    \it t_{35}}^{2.0}}}+{\it t_{36}}+1.0}}+1.0\right)\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{48}}\,{\it t_{17}}\,{\it t_{18}}+{\it t_{47}}\right)
C>    +{\it t_{46}}\right)+{\it t_{45}}\right)+{\it t_{44}}\right)
C>    +{\it t_{43}}\right)+{\it t_{42}}\right)+{\it t_{41}}\right)
C>    +{\it t_{40}}\right)+{\it t_{39}}\right)+{\it t_{38}}\right)
C>    +{\it t_{37}}\right)+1.0\,{\it t_1}\,{\it t_{14}}\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{29}}\,{\it t_{17}}\,{\it t_{18}}+{\it t_{28}}\right)
C>    +{\it t_{27}}\right)+{\it t_{26}}\right)+{\it t_{25}}\right)
C>    +{\it t_{24}}\right)+{\it t_{23}}\right)+{\it t_{22}}\right)
C>    +{\it t_{21}}\right)+{\it t_{20}}\right)+{\it t_{19}}\right)
C>    +{\it t_{15}}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.01554534543482744\,\rho_s\,\log 
C>    \left({{0.2162211495206379\,{\it t_{59}}\,\sigma_{ss}\,
C>    \left({\it t_{61}}+1.0\right)}\over{{{0.04675158550002606
C>    \,\left({\it t_{59}}\,\sigma_{ss}\right)^{2.0}}\over{{
C>    \it t_{60}}^{2.0}}}+{\it t_{61}}+1.0}}+1.0\right)\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{48}}\,{\it t_{57}}\,{\it t_{58}}+{\it t_{47}}\right)
C>    +{\it t_{46}}\right)+{\it t_{45}}\right)+{\it t_{44}}\right)
C>    +{\it t_{43}}\right)+{\it t_{42}}\right)+{\it t_{41}}\right)
C>    +{\it t_{40}}\right)+{\it t_{39}}\right)+{\it t_{38}}\right)
C>    +{\it t_{37}}\right)+1.0\,{\it t_{55}}\,\rho_s\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{29}}\,{\it t_{57}}\,{\it t_{58}}+{\it t_{28}}\right)
C>    +{\it t_{27}}\right)+{\it t_{26}}\right)+{\it t_{25}}\right)
C>    +{\it t_{24}}\right)+{\it t_{23}}\right)+{\it t_{22}}\right)
C>    +{\it t_{21}}\right)+{\it t_{20}}\right)+{\it t_{19}}\right)
C>    +{\it t_{15}}\right)\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] R Peverati, DG Truhlar, J.Phys.Chem.Lett. 2, 2810 (2011)  , DOI: 
C> <a href="https://doi.org/10.1021/jz201170d "> 
C> 10.1021/jz201170d </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_m11_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3*(
     1         7.016926042943223d-1*(2.150807071909054d-2*t3+1.018655694
     2         8d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
            t5 = 1/t1
            t6 = 1.0522000558389215d-1*t5+1.0d+0
            t7 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t8 = t7-2*taua
            t9 = 2*taua+t7
            t10 = 1/t9
            t11 = param(12)
            t12 = t10*t11*t8+param(11)
            t13 = t10*t12*t8+param(10)
            t14 = t10*t13*t8+param(9)
            t15 = t10*t14*t8+param(8)
            t16 = t10*t15*t8+param(7)
            t17 = t10*t16*t8+param(6)
            t18 = t10*t17*t8+param(5)
            t19 = t10*t18*t8+param(4)
            t20 = t10*t19*t8+param(3)
            t21 = t10*t20*t8+param(2)
            t22 = t10*t21*t8+param(1)
            t23 = rhoa**1.1666666666666667d+0
            t24 = 1/t23**2.0d+0
            t25 = exp(2.0000005873362642d+0*t4*t6)-1.0d+0
            t26 = 1.0811057476031892d-1*gammaaa*t24/t25
            t27 = (gammaaa*t24)**2.0d+0
            t28 = param(14)
            t29 = param(24)
            t30 = t10*t29*t8+param(23)
            t31 = t10*t30*t8+param(22)
            t32 = t10*t31*t8+param(21)
            t33 = t10*t32*t8+param(20)
            t34 = t10*t33*t8+param(19)
            t35 = t10*t34*t8+param(18)
            t36 = t10*t35*t8+param(17)
            t37 = t10*t36*t8+param(16)
            t38 = t10*t37*t8+param(15)
            t39 = t10*t38*t8+t28
            t40 = t10*t39*t8+param(13)
            t41 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t42 = 7.016926042943222d-1*t3*t41+2.2308199064d-1
            t43 = 7.016926042943222d-1*t3*t42+4.7231125998d-1
            t44 = 1/t43
            t45 = 1.425125466450768d+0*t2*t44+1.0d+0
            t46 = log(t45)
            t47 = 1.0522000558389213d-1*t5+1.0d+0
            t48 = 1.5874010519681994d+0
            t49 = rhoa**6.666666666666666d-1
            t50 = 1/t9**2
            t51 = 4.785390000313652d+0*t10*t11*t48*t49-4.785390000313652
     1         d+0*t11*t48*t49*t50*t8
            t52 = t10*t51*t8-4.785390000313652d+0*t12*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t12*t48*t49
            t53 = t10*t52*t8-4.785390000313652d+0*t13*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t13*t48*t49
            t54 = t10*t53*t8-4.785390000313652d+0*t14*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t14*t48*t49
            t55 = t10*t54*t8-4.785390000313652d+0*t15*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t15*t48*t49
            t56 = t10*t55*t8-4.785390000313652d+0*t16*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t16*t48*t49
            t57 = t10*t56*t8-4.785390000313652d+0*t17*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t17*t48*t49
            t58 = t10*t57*t8-4.785390000313652d+0*t18*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t18*t48*t49
            t59 = t10*t58*t8-4.785390000313652d+0*t19*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t19*t48*t49
            t60 = t10*t59*t8-4.785390000313652d+0*t20*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t20*t48*t49
            t61 = t10*t60*t8-4.785390000313652d+0*t21*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t21*t48*t49
            t62 = 1/rhoa**1.3333333333333333d+0
            t63 = 1/t45
            t64 = 1/t43**2
            t65 = 1/rhoa**1.3333333333333336d+0
            t66 = 1/t2**3
            t67 = 1/rhoa**6.666666666666667d-1
            t68 = -5.847438369119352d-2*t41*t66*t67-1.2576711796854242d-
     1         3*t65
            t69 = 7.016926042943222d-1*t3*t68-5.847438369119352d-2*t42*t
     1         66*t67
            t70 = 1.1876045553756398d-1*t3*t44*t67-1.425125466450768d+0*
     1         t2*t64*t69
            t71 = 1.090454542535705d-3*t46*t62-6.21814d-2*t47*t63*t70
            t72 = exp(2.0000005873362642d+0*t46*t47)
            t73 = t72-1.0d+0
            t74 = 1/t73
            t75 = 1.0811057476031893d-1*gammaaa*t24*t74
            t76 = t75+1.0d+0
            t77 = 1/t73**2.0d+0
            t78 = 1.168789637500651d-2*t27*t77+t75+1.0d+0
            t79 = 1/t78
            t80 = 1.0811057476031893d-1*gammaaa*t24*t76*t79+1.0d+0
            t81 = log(t80)
            t82 = 4.785390000313652d+0*t10*t29*t48*t49-4.785390000313652
     1         d+0*t29*t48*t49*t50*t8
            t83 = t10*t8*t82-4.785390000313652d+0*t30*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t30*t48*t49
            t84 = t10*t8*t83-4.785390000313652d+0*t31*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t31*t48*t49
            t85 = t10*t8*t84-4.785390000313652d+0*t32*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t32*t48*t49
            t86 = t10*t8*t85-4.785390000313652d+0*t33*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t33*t48*t49
            t87 = t10*t8*t86-4.785390000313652d+0*t34*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t34*t48*t49
            t88 = t10*t8*t87-4.785390000313652d+0*t35*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t35*t48*t49
            t89 = t10*t8*t88-4.785390000313652d+0*t36*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t36*t48*t49
            t90 = t10*t8*t89-4.785390000313652d+0*t37*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t37*t48*t49
            t91 = t10*t8*t90-4.785390000313652d+0*t38*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t38*t48*t49
            t92 = t10*t8*t91-4.785390000313652d+0*t39*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t39*t48*t49
            t93 = 1/t80
            t94 = rhoa**1.6666666666666674d-1
            t95 = 1/t23**3.0d+0
            t96 = -1.2612900388703877d-1*gammaaa*t74*t94*t95
            t97 = 1/t73**2
            t98 = 3.4772651149362827d+0*gammaaa*t24*t71*t72*t97
            t99 = t98+t96
            t100 = 1/t78**2
            t101 = gammaaa**2
            t102 = 1/t23**5.0d+0
            t103 = 1/t73**3.0d+0
            t104 = t98+t96-2.727175820834852d-2*t101*t102*t77*t94+7.5185
     1         82603395361d-1*t103*t27*t71*t72
            t105 = 1.0811057476031893d-1*gammaaa*t24*t79*t99-1.261290038
     1         8703877d-1*gammaaa*t76*t79*t94*t95-1.0811057476031893d-1*
     2         gammaaa*t100*t104*t24*t76
            t106 = 1/t23**4.0d+0
            t107 = 5.843948187503255d-3*gammaaa*t106*t77+2.7027643690079
     1         733d-2*t24*t74
            t108 = 2.7027643690079733d-2*t24*t76*t79+2.9219740937516275d
     1         -3*gammaaa*t106*t74*t79-1.0811057476031893d-1*gammaaa*t10
     2         0*t107*t24*t76
            t109 = 1.168789637500651d-2*gammaaa*t106*t77+5.4055287380159
     1         47d-2*t24*t74
            t110 = 5.405528738015947d-2*t24*t76*t79+5.843948187503255d-3
     1         *gammaaa*t106*t74*t79-1.0811057476031893d-1*gammaaa*t100*
     2         t109*t24*t76
            t111 = -t11*t50*t8-t10*t11
            t112 = -t12*t50*t8+t10*t111*t8-t10*t12
            t113 = -t13*t50*t8+t10*t112*t8-t10*t13
            t114 = -t14*t50*t8+t10*t113*t8-t10*t14
            t115 = -t15*t50*t8+t10*t114*t8-t10*t15
            t116 = -t16*t50*t8+t10*t115*t8-t10*t16
            t117 = -t17*t50*t8+t10*t116*t8-t10*t17
            t118 = -t18*t50*t8+t10*t117*t8-t10*t18
            t119 = -t19*t50*t8+t10*t118*t8-t10*t19
            t120 = -t20*t50*t8+t10*t119*t8-t10*t20
            t121 = -t21*t50*t8+t10*t120*t8-t10*t21
            t122 = -t29*t50*t8-t10*t29
            t123 = -t30*t50*t8+t10*t122*t8-t10*t30
            t124 = -t31*t50*t8+t10*t123*t8-t10*t31
            t125 = -t32*t50*t8+t10*t124*t8-t10*t32
            t126 = -t33*t50*t8+t10*t125*t8-t10*t33
            t127 = -t34*t50*t8+t10*t126*t8-t10*t34
            t128 = -t35*t50*t8+t10*t127*t8-t10*t35
            t129 = -t36*t50*t8+t10*t128*t8-t10*t36
            t130 = -t37*t50*t8+t10*t129*t8-t10*t37
            t131 = -t38*t50*t8+t10*t130*t8-t10*t38
            t132 = -t39*t50*t8
            t133 = t10*t131*t8-t10*t39+t132
            t134 = 2.519842099789746d+0
            t135 = rhoa**1.3333333333333333d+0
            t136 = 1/t9**3
            t137 = 7.937005259840998d-1
            t138 = 1/rhoa**3.333333333333333d-1
            t139 = -1.243628d-1*rhoa*t46*t47*(t10*t8*(t10*t8*(t10*t8*(t1
     1         0*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(-3.
     2         190260000209101d+0*t11*t137*t138*t50*t8+4.579991491020378
     3         d+1*t11*t134*t135*t136*t8-4.579991491020378d+1*t11*t134*t
     4         135*t50+3.190260000209101d+0*t10*t11*t137*t138)-9.5707800
     5         00627304d+0*t48*t49*t50*t51*t8-3.190260000209101d+0*t12*t
     6         137*t138*t50*t8+4.579991491020378d+1*t12*t134*t135*t136*t
     7         8+9.570780000627304d+0*t10*t48*t49*t51-4.579991491020378d
     8         +1*t12*t134*t135*t50+3.190260000209101d+0*t10*t12*t137*t1
     9         38)-9.570780000627304d+0*t48*t49*t50*t52*t8-3.19026000020
     :         9101d+0*t13*t137*t138*t50*t8+4.579991491020378d+1*t13*t13
     ;         4*t135*t136*t8+9.570780000627304d+0*t10*t48*t49*t52-4.579
     <         991491020378d+1*t13*t134*t135*t50+3.190260000209101d+0*t1
     =         0*t13*t137*t138)-9.570780000627304d+0*t48*t49*t50*t53*t8-
     >         3.190260000209101d+0*t137*t138*t14*t50*t8+4.5799914910203
     ?         78d+1*t134*t135*t136*t14*t8+9.570780000627304d+0*t10*t48*
     @         t49*t53-4.579991491020378d+1*t134*t135*t14*t50+3.19026000
     1         0209101d+0*t10*t137*t138*t14)-9.570780000627304d+0*t48*t4
     2         9*t50*t54*t8-3.190260000209101d+0*t137*t138*t15*t50*t8+4.
     3         579991491020378d+1*t134*t135*t136*t15*t8+9.57078000062730
     4         4d+0*t10*t48*t49*t54-4.579991491020378d+1*t134*t135*t15*t
     5         50+3.190260000209101d+0*t10*t137*t138*t15)-9.570780000627
     6         304d+0*t48*t49*t50*t55*t8-3.190260000209101d+0*t137*t138*
     7         t16*t50*t8+4.579991491020378d+1*t134*t135*t136*t16*t8+9.5
     8         70780000627304d+0*t10*t48*t49*t55-4.579991491020378d+1*t1
     9         34*t135*t16*t50+3.190260000209101d+0*t10*t137*t138*t16)-9
     :         .570780000627304d+0*t48*t49*t50*t56*t8-3.190260000209101d
     ;         +0*t137*t138*t17*t50*t8+4.579991491020378d+1*t134*t135*t1
     <         36*t17*t8+9.570780000627304d+0*t10*t48*t49*t56-4.57999149
     =         1020378d+1*t134*t135*t17*t50+3.190260000209101d+0*t10*t13
     >         7*t138*t17)-9.570780000627304d+0*t48*t49*t50*t57*t8-3.190
     ?         260000209101d+0*t137*t138*t18*t50*t8+4.579991491020378d+1
     @         *t134*t135*t136*t18*t8+9.570780000627304d+0*t10*t48*t49*t
     1         57-4.579991491020378d+1*t134*t135*t18*t50+3.1902600002091
     2         01d+0*t10*t137*t138*t18)-9.570780000627304d+0*t48*t49*t50
     3         *t58*t8-3.190260000209101d+0*t137*t138*t19*t50*t8+4.57999
     4         1491020378d+1*t134*t135*t136*t19*t8+9.570780000627304d+0*
     5         t10*t48*t49*t58-4.579991491020378d+1*t134*t135*t19*t50+3.
     6         190260000209101d+0*t10*t137*t138*t19)-9.570780000627304d+
     7         0*t48*t49*t50*t59*t8-3.190260000209101d+0*t137*t138*t20*t
     8         50*t8+4.579991491020378d+1*t134*t135*t136*t20*t8+9.570780
     9         000627304d+0*t10*t48*t49*t59-4.579991491020378d+1*t134*t1
     :         35*t20*t50+3.190260000209101d+0*t10*t137*t138*t20)-9.5707
     ;         80000627304d+0*t48*t49*t50*t60*t8-3.190260000209101d+0*t1
     <         37*t138*t21*t50*t8+4.579991491020378d+1*t134*t135*t136*t2
     =         1*t8+9.570780000627304d+0*t10*t48*t49*t60-4.5799914910203
     >         78d+1*t134*t135*t21*t50+3.190260000209101d+0*t10*t137*t13
     ?         8*t21)
            t140 = -1.243628d-1*t46*t47*t61
            t141 = 4.0d+0*rhoa*t61*t71
            t142 = 2.0d+0*t22*t71
            t143 = -7.269696950238034d-4*t46/rhoa**2.333333333333333d+0
            t144 = log(1.425125466450768d+0*t2/(7.016926042943222d-1*t3*
     1         (7.016926042943222d-1*(1.1771443702974158d-2*t3+2.9729725
     2         188d-2)*t3+1.2236585478d-1)+3.497952466d-1)+1.0d+0)
            t145 = 5.477644184000001d-2*t5+1.0d+0
            t146 = 1/rhoa**2
            t147 = 2.18090908507141d-3*t62*t63*t70
            t148 = 6.21814d-2*t47*t70**2/t45**2
            t149 = 1/rhoa**1.6666666666666669d+0
            t150 = 1/t2**5
            t151 = -6.21814d-2*t47*t63*(2.850250932901536d+0*t2*t69**2/t
     1         43**3-2.3752091107512796d-1*t3*t64*t67*t69-1.425125466450
     2         768d+0*t2*t64*(-1.1694876738238703d-1*t66*t67*t68+7.01692
     3         6042943222d-1*t3*(1.949146123039784d-2*t149*t41*t66+1.461
     4         8595922798375d-2*t150*t41*t65+9.432533847640683d-4/rhoa**
     5         2.3333333333333334d+0)+1.949146123039784d-2*t149*t42*t66+
     6         1.4618595922798375d-2*t150*t42*t65)-9.896704628130328d-3*
     7         t44*t65*t66-3.9586818512521327d-2*t149*t3*t44)
            t152 = t151+t148+t147+8.443450000000001d-3*t144*t145*t146+t1
     1         43
            t153 = 6.218138173930978d-2*rhoa*t81*(-9.570780000627304d+0*
     1         t48*t49*t50*t8*t91+9.570780000627304d+0*t10*t48*t49*t91+t
     2         10*t8*(-9.570780000627304d+0*t48*t49*t50*t8*t90+9.5707800
     3         00627304d+0*t10*t48*t49*t90+t10*t8*(-9.570780000627304d+0
     4         *t48*t49*t50*t8*t89+9.570780000627304d+0*t10*t48*t49*t89+
     5         t10*t8*(-9.570780000627304d+0*t48*t49*t50*t8*t88+9.570780
     6         000627304d+0*t10*t48*t49*t88+t10*t8*(-9.570780000627304d+
     7         0*t48*t49*t50*t8*t87+9.570780000627304d+0*t10*t48*t49*t87
     8         +t10*t8*(-9.570780000627304d+0*t48*t49*t50*t8*t86+9.57078
     9         0000627304d+0*t10*t48*t49*t86+t10*t8*(-9.570780000627304d
     :         +0*t48*t49*t50*t8*t85+9.570780000627304d+0*t10*t48*t49*t8
     ;         5+t10*t8*(-9.570780000627304d+0*t48*t49*t50*t8*t84+9.5707
     <         80000627304d+0*t10*t48*t49*t84+t10*t8*(-9.570780000627304
     =         d+0*t48*t49*t50*t8*t83+9.570780000627304d+0*t10*t48*t49*t
     >         83+t10*t8*(-9.570780000627304d+0*t48*t49*t50*t8*t82+9.570
     ?         780000627304d+0*t10*t48*t49*t82+t10*t8*(-3.19026000020910
     @         1d+0*t137*t138*t29*t50*t8+4.579991491020378d+1*t134*t135*
     1         t136*t29*t8-4.579991491020378d+1*t134*t135*t29*t50+3.1902
     2         60000209101d+0*t10*t137*t138*t29)-3.190260000209101d+0*t1
     3         37*t138*t30*t50*t8+4.579991491020378d+1*t134*t135*t136*t3
     4         0*t8-4.579991491020378d+1*t134*t135*t30*t50+3.19026000020
     5         9101d+0*t10*t137*t138*t30)-3.190260000209101d+0*t137*t138
     6         *t31*t50*t8+4.579991491020378d+1*t134*t135*t136*t31*t8-4.
     7         579991491020378d+1*t134*t135*t31*t50+3.190260000209101d+0
     8         *t10*t137*t138*t31)-3.190260000209101d+0*t137*t138*t32*t5
     9         0*t8+4.579991491020378d+1*t134*t135*t136*t32*t8-4.5799914
     :         91020378d+1*t134*t135*t32*t50+3.190260000209101d+0*t10*t1
     ;         37*t138*t32)-3.190260000209101d+0*t137*t138*t33*t50*t8+4.
     <         579991491020378d+1*t134*t135*t136*t33*t8-4.57999149102037
     =         8d+1*t134*t135*t33*t50+3.190260000209101d+0*t10*t137*t138
     >         *t33)-3.190260000209101d+0*t137*t138*t34*t50*t8+4.5799914
     ?         91020378d+1*t134*t135*t136*t34*t8-4.579991491020378d+1*t1
     @         34*t135*t34*t50+3.190260000209101d+0*t10*t137*t138*t34)-3
     1         .190260000209101d+0*t137*t138*t35*t50*t8+4.57999149102037
     2         8d+1*t134*t135*t136*t35*t8-4.579991491020378d+1*t134*t135
     3         *t35*t50+3.190260000209101d+0*t10*t137*t138*t35)-3.190260
     4         000209101d+0*t137*t138*t36*t50*t8+4.579991491020378d+1*t1
     5         34*t135*t136*t36*t8-4.579991491020378d+1*t134*t135*t36*t5
     6         0+3.190260000209101d+0*t10*t137*t138*t36)-3.1902600002091
     7         01d+0*t137*t138*t37*t50*t8+4.579991491020378d+1*t134*t135
     8         *t136*t37*t8-4.579991491020378d+1*t134*t135*t37*t50+3.190
     9         260000209101d+0*t10*t137*t138*t37)-3.190260000209101d+0*t
     :         137*t138*t38*t50*t8+4.579991491020378d+1*t134*t135*t136*t
     ;         38*t8-4.579991491020378d+1*t134*t135*t38*t50+3.1902600002
     <         09101d+0*t10*t137*t138*t38)-3.190260000209101d+0*t137*t13
     =         8*t39*t50*t8+4.579991491020378d+1*t134*t135*t136*t39*t8-4
     >         .579991491020378d+1*t134*t135*t39*t50+3.190260000209101d+
     ?         0*t10*t137*t138*t39)
            t154 = 6.218138173930978d-2*t81*t92
            t155 = 1/t80**2
            t156 = -6.218138173930978d-2*rhoa*t105**2*t155*t40
            t157 = 1/rhoa
            t158 = 1.2436276347861956d-1*rhoa*t105*t92
            t159 = 6.218138173930978d-2*t105*t40
            t160 = rhoa**3.333333333333335d-1
            t161 = 2.2072575680231782d-1*gammaaa*t106*t160*t76*t79
            t162 = 1/rhoa**8.333333333333333d-1
            t163 = -1.0510750323919903d-2*gammaaa*t162*t76*t79*t95
            t164 = -2.5225800777407753d-1*gammaaa*t79*t94*t95*t99
            t165 = 2.5225800777407753d-1*gammaaa*t100*t104*t76*t94*t95
            t166 = -2.1622114952063787d-1*gammaaa*t100*t104*t24*t99
            t167 = 1/t78**3
            t168 = 2.1622114952063787d-1*gammaaa*t104**2*t167*t24*t76
            t169 = 2.2072575680231782d-1*gammaaa*t106*t160*t74
            t170 = -1.0510750323919903d-2*gammaaa*t162*t74*t95
            t171 = 1.2012286084479878d-2*gammaaa*t146*t24*t74
            t172 = -8.113618601517993d+0*gammaaa*t71*t72*t94*t95*t97
            t173 = t71**2
            t174 = -1.118426454244592d+2*gammaaa*t173*t24*t72*t97
            t175 = 3.3333343122271053d-1*t146*t46*t47-3.216396844291483d
     1         +1*t152
            t176 = -1.0811057476031893d-1*gammaaa*t175*t24*t72*t97
            t177 = 1/t73**3
            t178 = exp(4.0000011746725284d+0*t46*t47)
            t179 = 2.236852908489184d+2*gammaaa*t173*t177*t178*t24
            t180 = 1/t23**6.0d+0
            t181 = 7.95426281076832d-2*t101*t160*t180*t77
            t182 = -2.2726465173623778d-3*t101*t102*t162*t77
            t183 = -3.508671881584501d+0*t101*t102*t103*t71*t72*t94
            t184 = 7.254823607731703d+1*t173*t178*t27/t73**4.0d+0
            t185 = t151+t148+t147-8.44345d-3*t144*t145*t146+t143
            t186 = -1.201228608447988d-2*gammaaa*t146*t24*t74
            t187 = -1.1184264542445921d+2*gammaaa*t173*t24*t72*t97
            t188 = -3.3333343122271064d-1*t146*t46*t47-3.216396844291483
     1         d+1*t185
            t189 = -1.0811057476031893d-1*gammaaa*t188*t24*t72*t97
            t190 = 2.2368529084891842d+2*gammaaa*t173*t177*t178*t24
            t191 = -3.153225097175969d-2*t74*t94*t95
            t192 = 8.693162787340707d-1*t24*t71*t72*t97
            t193 = 1.0d+0*(t93*(6.218138173930978d-2*rhoa*t40*(2.7027643
     1         690079733d-2*t24*t79*t99-1.0811057476031893d-1*gammaaa*t1
     2         00*t107*t24*t99-3.153225097175969d-2*t76*t79*t94*t95+1.26
     3         12900388703877d-1*gammaaa*t100*t107*t76*t94*t95-1.0811057
     4         476031893d-1*gammaaa*t100*t24*t76*(-1.363587910417426d-2*
     5         gammaaa*t102*t77*t94+3.7592913016976803d-1*gammaaa*t103*t
     6         106*t71*t72+t192+t191)-3.408969776043566d-3*gammaaa*t102*
     7         t74*t79*t94+1.0811057476031893d-1*gammaaa*(t192+t191)*t24
     8         *t79+2.1622114952063787d-1*gammaaa*t104*t107*t167*t24*t76
     9         -2.7027643690079733d-2*t100*t104*t24*t76-2.92197409375162
     :         75d-3*gammaaa*t100*t104*t106*t74)+6.218138173930978d-2*rh
     ;         oa*t108*t92+3.109069086965489d-2*t108*t40)-6.218138173930
     <         978d-2*rhoa*t105*t108*t155*t40)*wght
            t194 = -6.306450194351938d-2*t74*t94*t95
            t195 = 1.7386325574681413d+0*t24*t71*t72*t97
            t196 = -5.405528738015947d-2*t100*t107*t24*t76
            t197 = -5.843948187503255d-3*gammaaa*t100*t106*t107*t74
            t198 = 6.218138173930978d-2*rhoa*t40*(1.4609870468758138d-3*
     1         t106*t74*t79-1.5794814935512527d-4*gammaaa*t100*t180*t76*
     2         t77+2.1622114952063787d-1*gammaaa*t107**2*t167*t24*t76+t1
     3         97+t196)*t93*wght-6.218138173930978d-2*rhoa*t108**2*t155*
     4         t40*wght
            t199 = t8**2
            t200 = 1/t9**4
            t201 = 1.0d+0*(6.218138173930978d-2*rhoa*t105*t133*t93+6.218
     1         138173930978d-2*rhoa*t81*(-t50*t8*t91-t10*t91+t10*t8*(-t5
     2         0*t8*t90-t10*t90+t10*t8*(-t50*t8*t89-t10*t89+t10*t8*(-t50
     3         *t8*t88-t10*t88+t10*t8*(-t50*t8*t87-t10*t87+t10*t8*(-t50*
     4         t8*t86-t10*t86+t10*t8*(-t50*t8*t85-t10*t85+t10*t8*(-t50*t
     5         8*t84-t10*t84+t10*t8*(-t50*t8*t83-t10*t83+t10*t8*(-t50*t8
     6         *t82-t10*t82-4.785390000313652d+0*t122*t48*t49*t50*t8+9.5
     7         70780000627304d+0*t136*t30*t48*t49*t8+9.570780000627304d+
     8         0*t199*t200*t29*t48*t49+4.785390000313652d+0*t10*t122*t48
     9         *t49)-4.785390000313652d+0*t123*t48*t49*t50*t8+9.57078000
     :         0627304d+0*t136*t31*t48*t49*t8+4.785390000313652d+0*t10*t
     ;         123*t48*t49)-4.785390000313652d+0*t124*t48*t49*t50*t8+9.5
     <         70780000627304d+0*t136*t32*t48*t49*t8+4.785390000313652d+
     =         0*t10*t124*t48*t49)-4.785390000313652d+0*t125*t48*t49*t50
     >         *t8+9.570780000627304d+0*t136*t33*t48*t49*t8+4.7853900003
     ?         13652d+0*t10*t125*t48*t49)-4.785390000313652d+0*t126*t48*
     @         t49*t50*t8+9.570780000627304d+0*t136*t34*t48*t49*t8+4.785
     1         390000313652d+0*t10*t126*t48*t49)-4.785390000313652d+0*t1
     2         27*t48*t49*t50*t8+9.570780000627304d+0*t136*t35*t48*t49*t
     3         8+4.785390000313652d+0*t10*t127*t48*t49)-4.78539000031365
     4         2d+0*t128*t48*t49*t50*t8+9.570780000627304d+0*t136*t36*t4
     5         8*t49*t8+4.785390000313652d+0*t10*t128*t48*t49)-4.7853900
     6         00313652d+0*t129*t48*t49*t50*t8+9.570780000627304d+0*t136
     7         *t37*t48*t49*t8+4.785390000313652d+0*t10*t129*t48*t49)-4.
     8         785390000313652d+0*t130*t48*t49*t50*t8+9.570780000627304d
     9         +0*t136*t38*t48*t49*t8+4.785390000313652d+0*t10*t130*t48*
     :         t49)-4.785390000313652d+0*t131*t48*t49*t50*t8+9.570780000
     ;         627304d+0*t136*t39*t48*t49*t8+4.785390000313652d+0*t10*t1
     <         31*t48*t49)+3.109069086965489d-2*t133*t81-1.243628d-1*rho
     =         a*t46*t47*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8
     >         *(t10*t8*(t10*t8*(t10*t8*(-t50*t51*t8-4.785390000313652d+
     ?         0*t111*t48*t49*t50*t8+9.570780000627304d+0*t12*t136*t48*t
     @         49*t8-t10*t51+9.570780000627304d+0*t11*t199*t200*t48*t49+
     1         4.785390000313652d+0*t10*t111*t48*t49)-t50*t52*t8-4.78539
     2         0000313652d+0*t112*t48*t49*t50*t8+9.570780000627304d+0*t1
     3         3*t136*t48*t49*t8-t10*t52+4.785390000313652d+0*t10*t112*t
     4         48*t49)-t50*t53*t8-4.785390000313652d+0*t113*t48*t49*t50*
     5         t8+9.570780000627304d+0*t136*t14*t48*t49*t8-t10*t53+4.785
     6         390000313652d+0*t10*t113*t48*t49)-t50*t54*t8-4.7853900003
     7         13652d+0*t114*t48*t49*t50*t8+9.570780000627304d+0*t136*t1
     8         5*t48*t49*t8-t10*t54+4.785390000313652d+0*t10*t114*t48*t4
     9         9)-t50*t55*t8-4.785390000313652d+0*t115*t48*t49*t50*t8+9.
     :         570780000627304d+0*t136*t16*t48*t49*t8-t10*t55+4.78539000
     ;         0313652d+0*t10*t115*t48*t49)-t50*t56*t8-4.785390000313652
     <         d+0*t116*t48*t49*t50*t8+9.570780000627304d+0*t136*t17*t48
     =         *t49*t8-t10*t56+4.785390000313652d+0*t10*t116*t48*t49)-t5
     >         0*t57*t8-4.785390000313652d+0*t117*t48*t49*t50*t8+9.57078
     ?         0000627304d+0*t136*t18*t48*t49*t8-t10*t57+4.7853900003136
     @         52d+0*t10*t117*t48*t49)-t50*t58*t8-4.785390000313652d+0*t
     1         118*t48*t49*t50*t8+9.570780000627304d+0*t136*t19*t48*t49*
     2         t8-t10*t58+4.785390000313652d+0*t10*t118*t48*t49)-t50*t59
     3         *t8-4.785390000313652d+0*t119*t48*t49*t50*t8+9.5707800006
     4         27304d+0*t136*t20*t48*t49*t8-t10*t59+4.785390000313652d+0
     5         *t10*t119*t48*t49)-t50*t60*t8-4.785390000313652d+0*t120*t
     6         48*t49*t50*t8+9.570780000627304d+0*t136*t21*t48*t49*t8-t1
     7         0*t60+4.785390000313652d+0*t10*t120*t48*t49)+2.0d+0*rhoa*
     8         t121*t71-6.21814d-2*t121*t46*t47)*wght
            t202 = t10*(-t10*t38*t8+t131*t8-t28)+t132
            t203 = 6.218138173930978d-2*rhoa*t108*t202*t93*wght
            t204 = 1.0d+0*(6.218138173930978d-2*rhoa*(t10*t8*(t10*t8*(t1
     1         0*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10
     2         *t8*(2*t136*t29*t8+2*t29*t50)-2*t122*t50*t8+2*t136*t30*t8
     3         +2*t30*t50-2*t10*t122)-2*t123*t50*t8+2*t136*t31*t8+2*t31*
     4         t50-2*t10*t123)-2*t124*t50*t8+2*t136*t32*t8+2*t32*t50-2*t
     5         10*t124)-2*t125*t50*t8+2*t136*t33*t8+2*t33*t50-2*t10*t125
     6         )-2*t126*t50*t8+2*t136*t34*t8+2*t34*t50-2*t10*t126)-2*t12
     7         7*t50*t8+2*t136*t35*t8+2*t35*t50-2*t10*t127)-2*t128*t50*t
     8         8+2*t136*t36*t8+2*t36*t50-2*t10*t128)-2*t129*t50*t8+2*t13
     9         6*t37*t8+2*t37*t50-2*t10*t129)-2*t130*t50*t8+2*t136*t38*t
     :         8+2*t38*t50-2*t10*t130)-2*t131*t50*t8+2*t136*t39*t8+2*t39
     ;         *t50-2*t10*t131)*t81-1.243628d-1*rhoa*t46*t47*(t10*t8*(t1
     <         0*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10
     =         *t8*(t10*t8*(2*t11*t136*t8+2*t11*t50)-2*t111*t50*t8+2*t12
     >         *t136*t8+2*t12*t50-2*t10*t111)-2*t112*t50*t8+2*t13*t136*t
     ?         8+2*t13*t50-2*t10*t112)-2*t113*t50*t8+2*t136*t14*t8+2*t14
     @         *t50-2*t10*t113)-2*t114*t50*t8+2*t136*t15*t8+2*t15*t50-2*
     1         t10*t114)-2*t115*t50*t8+2*t136*t16*t8+2*t16*t50-2*t10*t11
     2         5)-2*t116*t50*t8+2*t136*t17*t8+2*t17*t50-2*t10*t116)-2*t1
     3         17*t50*t8+2*t136*t18*t8+2*t18*t50-2*t10*t117)-2*t118*t50*
     4         t8+2*t136*t19*t8+2*t19*t50-2*t10*t118)-2*t119*t50*t8+2*t1
     5         36*t20*t8+2*t20*t50-2*t10*t119)-2*t120*t50*t8+2*t136*t21*
     6         t8+2*t21*t50-2*t10*t120))*wght
            fnc(iq) = 1.0d+0*(6.218138173930978d-2*rhoa*log(1.0811057476
     1         031892d-1*gammaaa*t24*(t26+1.0d+0)/(1.1687896375006504d-2
     2         *t27/t25**2.0d+0+t26+1.0d+0)+1.0d+0)*t40-1.243628d-1*rhoa
     3         *t22*t4*t6)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(6.218138173930978d-2*rhoa*t105*t40*
     1         t93+6.218138173930978d-2*rhoa*t81*t92+3.109069086965489d-
     2         2*t40*t81+2.0d+0*rhoa*t22*t71-1.243628d-1*rhoa*t46*t47*t6
     3         1-6.21814d-2*t22*t46*t47)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 6.218138173930978d-2*rhoa*t108*t40*t93*wgh
     1         t+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 6.218138173930978d-2*rhoa*t110*t40*t93*wgh
     1         t+Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 1.0d+0*(6.218138173930978d-2*rhoa*t133*t81-
     1         1.243628d-1*rhoa*t121*t46*t47)*wght+Mmat(iq,D1_TA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*((6.218138173930978d-2*rhoa*t40*
     1         (1.2012286084479878d-2*gammaaa*t146*t24*t76*t79+1.0811057
     2         476031893d-1*gammaaa*(t179+t176+t174+t172+t171+t170+t169)
     3         *t24*t79-1.0811057476031893d-1*gammaaa*t100*t24*t76*(2.59
     4         7310305557001d-3*t146*t27*t77-2.337579275001302d-2*t103*t
     5         175*t27*t72-2.4182745359105678d+1*t103*t173*t27*t72+t184+
     6         t183+t182+t181+t179+t176+t174+t172+t171+t170+t169)+t168+t
     7         166+t165+t164+t163+t161)+t159+t158)*t93-1.036356362321829
     8         4d-2*t157*t40*t81+2.0d+0*rhoa*t152*t22+t156+t154+t153+t14
     9         2+t141+t140+t139)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*((6.218138173930978d-2*rhoa*t40*
     1         (-1.201228608447988d-2*gammaaa*t146*t24*t76*t79+1.0811057
     2         476031893d-1*gammaaa*(t190+t189+t187+t186+t172+t170+t169)
     3         *t24*t79-1.0811057476031893d-1*gammaaa*t100*t24*t76*(-2.5
     4         973103055570024d-3*t146*t27*t77-2.337579275001302d-2*t103
     5         *t188*t27*t72-2.418274535910568d+1*t103*t173*t27*t72+t190
     6         +t189+t187+t186+t184+t183+t182+t181+t172+t170+t169)+t168+
     7         t166+t165+t164+t163+t161)+t159+t158)*t93+1.03635636232182
     8         96d-2*t157*t40*t81+2.0d+0*rhoa*t185*t22+t156+t154+t153+t1
     9         42+t141+t140+t139)*wght+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = t193+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = 1.0d+0*(t93*(6.218138173930978d-2*rhoa
     1         *t40*(5.405528738015947d-2*t24*t79*t99-1.0811057476031893
     2         d-1*gammaaa*t100*t109*t24*t99-6.306450194351938d-2*t76*t7
     3         9*t94*t95+1.2612900388703877d-1*gammaaa*t100*t109*t76*t94
     4         *t95-1.0811057476031893d-1*gammaaa*t100*t24*t76*(-2.72717
     5         5820834852d-2*gammaaa*t102*t77*t94+7.518582603395361d-1*g
     6         ammaaa*t103*t106*t71*t72+t195+t194)-6.817939552087132d-3*
     7         gammaaa*t102*t74*t79*t94+1.0811057476031893d-1*gammaaa*(t
     8         195+t194)*t24*t79+2.1622114952063787d-1*gammaaa*t104*t109
     9         *t167*t24*t76-5.405528738015947d-2*t100*t104*t24*t76-5.84
     :         3948187503255d-3*gammaaa*t100*t104*t106*t74)+6.2181381739
     ;         30978d-2*rhoa*t110*t92+3.109069086965489d-2*t110*t40)-6.2
     <         18138173930978d-2*rhoa*t105*t110*t155*t40)*wght+Cmat2(iq,
     =         D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t193+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = t198+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = 6.218138173930978d-2*rhoa*t40*(2.9219
     1         740937516275d-3*t106*t74*t79-3.1589629871025054d-4*gammaa
     2         a*t100*t180*t76*t77+2.1622114952063787d-1*gammaaa*t107*t1
     3         09*t167*t24*t76-2.7027643690079733d-2*t100*t109*t24*t76-2
     4         .9219740937516275d-3*gammaaa*t100*t106*t109*t74+t197+t196
     5         )*t93*wght-6.218138173930978d-2*rhoa*t108*t110*t155*t40*w
     6         ght+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t198+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 6.218138173930978d-2*rhoa*t40*(5.8439
     1         48187503255d-3*t106*t74*t79-6.317925974205011d-4*gammaaa*
     2         t100*t180*t76*t77+2.1622114952063787d-1*gammaaa*t109**2*t
     3         167*t24*t76-1.0811057476031893d-1*t100*t109*t24*t76-1.168
     4         789637500651d-2*gammaaa*t100*t106*t109*t74)*t93*wght-6.21
     5         8138173930978d-2*rhoa*t110**2*t155*t40*wght+Cmat2(iq,D2_G
     6         AB_GAB)
            Mmat2(iq,D2_RA_TA) = t201+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = t201+Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = t203+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = t203+Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = 6.218138173930978d-2*rhoa*t110*t202*t9
     1         3*wght+Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_TA_TA) = t204+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = t204+Mmat2(iq,D2_TA_TB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = 1/t2
            t4 = 1.325688999052018d-1*t3+1.0d+0
            t5 = t2**5.0d-1
            t6 = 1/t5
            t7 = 2.4141993114533214d-2*t6+1.0186556948d-1
            t8 = 7.876233178997433d-1*t6*t7+2.2308199064d-1
            t9 = 7.876233178997433d-1*t6*t8+4.7231125998d-1
            t10 = 1/t9
            t11 = 1.269642451250142d+0*t10*t5+1.0d+0
            t12 = log(t11)
            t13 = rhoa-rhob
            t14 = 1/t1
            t15 = 1.0d+0-t13*t14
            t16 = t15**1.3333333333333333d+0
            t17 = t13*t14+1.0d+0
            t18 = t17**1.3333333333333333d+0
            t19 = 1.923661050931536d+0*t18+1.923661050931536d+0*t16-3.84
     1         7322101863072d+0
            t20 = 6.901399211255826d-2*t3+1.0d+0
            t21 = 1.3212998810398843d-2*t6+2.9729725188d-2
            t22 = 7.876233178997433d-1*t21*t6+1.2236585478d-1
            t23 = 7.876233178997433d-1*t22*t6+3.497952466d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t24*t5+1.0d+0
            t26 = log(t25)
            t27 = t13**4
            t28 = 1/t1**4
            t29 = 1.2746961887000874d-1*t3+1.0d+0
            t30 = 1.530901310039024d-2*t6+1.0465751434d-1
            t31 = 7.876233178997433d-1*t30*t6+1.9269083139d-1
            t32 = 7.876233178997433d-1*t31*t6+4.3896648423d-1
            t33 = 1/t32
            t34 = 1.269642451250142d+0*t33*t5+1.0d+0
            t35 = log(t34)
            t36 = 1.709920934161365d+0*(6.21814d-2*t12*t4-3.10907d-2*t29
     1         *t35)-3.37738d-2*t20*t26
            t37 = t27*t28*t36+3.37738d-2*t20*t26
            t38 = 5.848223622634648d-1*t19*t37-6.21814d-2*t12*t4
            t39 = 2.871234000188191d+0*t1**1.6666666666666669d+0
            t40 = -taub-taua+t39
            t41 = taub+taua+t39
            t42 = 1/t41
            t43 = param(12)
            t44 = t40*t42*t43+param(11)
            t45 = t40*t42*t44+param(10)
            t46 = t40*t42*t45+param(9)
            t47 = t40*t42*t46+param(8)
            t48 = t40*t42*t47+param(7)
            t49 = t40*t42*t48+param(6)
            t50 = t40*t42*t49+param(5)
            t51 = t40*t42*t50+param(4)
            t52 = t40*t42*t51+param(3)
            t53 = t40*t42*t52+param(2)
            t54 = t40*t42*t53+param(1)
            t55 = t15**6.666666666666666d-1
            t56 = t17**6.666666666666666d-1
            t57 = 5.0d-1*t56+5.0d-1*t55
            t58 = t57**3.0d+0
            t59 = gammabb+2.0d+0*gammaab+gammaaa
            t60 = t1**1.1666666666666667d+0
            t61 = 1/t60**2.0d+0
            t62 = t57**2.0d+0
            t63 = 1/t62
            t64 = 1/t58
            t65 = exp(-3.216396844291483d+1*t38*t64)
            t66 = t65-1.0d+0
            t67 = 1/t66
            t68 = 1.3621078885675922d-1*t59*t61*t63*t67
            t69 = t68+1.0d+0
            t70 = 1/t57**4.0d+0
            t71 = (t59*t61)**2.0d+0
            t72 = 1/t66**2.0d+0
            t73 = 1.855337900098064d-2*t70*t71*t72+t68+1.0d+0
            t74 = 1/t73
            t75 = 1.3621078885675922d-1*t59*t61*t63*t69*t74+1.0d+0
            t76 = log(t75)
            t77 = param(14)
            t78 = param(24)
            t79 = t40*t42*t78+param(23)
            t80 = t40*t42*t79+param(22)
            t81 = t40*t42*t80+param(21)
            t82 = t40*t42*t81+param(20)
            t83 = t40*t42*t82+param(19)
            t84 = t40*t42*t83+param(18)
            t85 = t40*t42*t84+param(17)
            t86 = t40*t42*t85+param(16)
            t87 = t40*t42*t86+param(15)
            t88 = t40*t42*t87+t77
            t89 = t40*t42*t88+param(13)
            t90 = t1**6.666666666666666d-1
            t91 = 1/t41**2
            t92 = 4.785390000313652d+0*t42*t43*t90-4.785390000313652d+0*
     1         t40*t43*t90*t91
            t93 = t40*t42*t92-4.785390000313652d+0*t40*t44*t90*t91+4.785
     1         390000313652d+0*t42*t44*t90
            t94 = t40*t42*t93-4.785390000313652d+0*t40*t45*t90*t91+4.785
     1         390000313652d+0*t42*t45*t90
            t95 = t40*t42*t94-4.785390000313652d+0*t40*t46*t90*t91+4.785
     1         390000313652d+0*t42*t46*t90
            t96 = t40*t42*t95-4.785390000313652d+0*t40*t47*t90*t91+4.785
     1         390000313652d+0*t42*t47*t90
            t97 = t40*t42*t96-4.785390000313652d+0*t40*t48*t90*t91+4.785
     1         390000313652d+0*t42*t48*t90
            t98 = t40*t42*t97-4.785390000313652d+0*t40*t49*t90*t91+4.785
     1         390000313652d+0*t42*t49*t90
            t99 = t40*t42*t98-4.785390000313652d+0*t40*t50*t90*t91+4.785
     1         390000313652d+0*t42*t50*t90
            t100 = t40*t42*t99-4.785390000313652d+0*t40*t51*t90*t91+4.78
     1         5390000313652d+0*t42*t51*t90
            t101 = -4.785390000313652d+0*t40*t52*t90*t91+4.7853900003136
     1         52d+0*t42*t52*t90+t100*t40*t42
            t102 = -4.785390000313652d+0*t40*t53*t90*t91+4.7853900003136
     1         52d+0*t42*t53*t90+t101*t40*t42
            t103 = 1.0d+0*t1*t102*t38
            t104 = 1/t1**1.3333333333333336d+0
            t105 = 1/t1**6.666666666666667d-1
            t106 = 1/t5**3
            t107 = -1.3127055298329054d-1*t105*t106*t7-3.169132786263567
     1         d-3*t104
            t108 = 7.876233178997433d-1*t107*t6-1.3127055298329054d-1*t1
     1         05*t106*t8
            t109 = 1/t9**2
            t110 = 2.11607075208357d-1*t10*t105*t6-1.269642451250142d+0*
     1         t108*t109*t5
            t111 = 1/t11
            t112 = -6.21814d-2*t110*t111*t4
            t113 = 1/t1**1.3333333333333333d+0
            t114 = 2.747773264188438d-3*t113*t12
            t115 = -1.3127055298329054d-1*t105*t106*t21-1.73447766040861
     1         62d-3*t104
            t116 = 7.876233178997433d-1*t115*t6-1.3127055298329054d-1*t1
     1         05*t106*t22
            t117 = 1/t23**2
            t118 = 2.11607075208357d-1*t105*t24*t6-1.269642451250142d+0*
     1         t116*t117*t5
            t119 = 1/t25
            t120 = 3.37738d-2*t118*t119*t20
            t121 = -7.769549222703733d-4*t113*t26
            t122 = -1.3127055298329054d-1*t105*t106*t30-2.00962261531666
     1         58d-3*t104
            t123 = 7.876233178997433d-1*t122*t6-1.3127055298329054d-1*t1
     1         05*t106*t31
            t124 = 1/t32**2
            t125 = 2.11607075208357d-1*t105*t33*t6-1.269642451250142d+0*
     1         t123*t124*t5
            t126 = 1/t34
            t127 = 1.709920934161365d+0*(6.21814d-2*t110*t111*t4+1.32103
     1         98931339265d-3*t113*t35-3.10907d-2*t125*t126*t29-2.747773
     2         264188438d-3*t113*t12)+7.769549222703733d-4*t113*t26-3.37
     3         738d-2*t118*t119*t20
            t128 = t127*t27*t28
            t129 = 1/t1**5
            t130 = -4*t129*t27*t36
            t131 = t13**3
            t132 = 4*t131*t28*t36+t130+t128+t121+t120
            t133 = 1/t1**2
            t134 = t13*t133
            t135 = -t14
            t136 = t135+t134
            t137 = t15**3.333333333333333d-1
            t138 = -t13*t133
            t139 = t14+t138
            t140 = t17**3.333333333333333d-1
            t141 = 2.564881401242048d+0*t139*t140+2.564881401242048d+0*t
     1         136*t137
            t142 = 5.848223622634648d-1*t141*t37+5.848223622634648d-1*t1
     1         32*t19+t114+t112
            t143 = 1.0d+0*t38*t54
            t144 = 4.785390000313652d+0*t42*t78*t90-4.785390000313652d+0
     1         *t40*t78*t90*t91
            t145 = -4.785390000313652d+0*t40*t79*t90*t91+4.7853900003136
     1         52d+0*t42*t79*t90+t144*t40*t42
            t146 = -4.785390000313652d+0*t40*t80*t90*t91+4.7853900003136
     1         52d+0*t42*t80*t90+t145*t40*t42
            t147 = -4.785390000313652d+0*t40*t81*t90*t91+4.7853900003136
     1         52d+0*t42*t81*t90+t146*t40*t42
            t148 = -4.785390000313652d+0*t40*t82*t90*t91+4.7853900003136
     1         52d+0*t42*t82*t90+t147*t40*t42
            t149 = -4.785390000313652d+0*t40*t83*t90*t91+4.7853900003136
     1         52d+0*t42*t83*t90+t148*t40*t42
            t150 = -4.785390000313652d+0*t40*t84*t90*t91+4.7853900003136
     1         52d+0*t42*t84*t90+t149*t40*t42
            t151 = -4.785390000313652d+0*t40*t85*t90*t91+4.7853900003136
     1         52d+0*t42*t85*t90+t150*t40*t42
            t152 = -4.785390000313652d+0*t40*t86*t90*t91+4.7853900003136
     1         52d+0*t42*t86*t90+t151*t40*t42
            t153 = -4.785390000313652d+0*t40*t87*t90*t91+4.7853900003136
     1         52d+0*t42*t87*t90+t152*t40*t42
            t154 = -4.785390000313652d+0*t40*t88*t90*t91+4.7853900003136
     1         52d+0*t42*t88*t90+t153*t40*t42
            t155 = 3.109069086965489d-2*t1*t154*t58*t76
            t156 = 1/t75
            t157 = 1/t137
            t158 = 1/t140
            t159 = 3.333333333333333d-1*t139*t158+3.333333333333333d-1*t
     1         136*t157
            t160 = t1**1.6666666666666674d-1
            t161 = 1/t60**3.0d+0
            t162 = -3.1782517399910487d-1*t160*t161*t59*t63*t69*t74
            t163 = -2.7242157771351844d-1*t159*t59*t61*t64*t67
            t164 = -3.1782517399910487d-1*t160*t161*t59*t63*t67
            t165 = 1/t66**2
            t166 = 9.649190532874448d+1*t159*t38*t70-3.216396844291483d+
     1         1*t142*t64
            t167 = -1.3621078885675922d-1*t165*t166*t59*t61*t63*t65
            t168 = t167+t164+t163
            t169 = 1/t73**2
            t170 = t59**2
            t171 = 1/t60**5.0d+0
            t172 = -8.658243533790966d-2*t160*t170*t171*t70*t72
            t173 = 1/t57**5.0d+0
            t174 = 1/t66**3.0d+0
            t175 = -7.421351600392256d-2*t159*t173*t71*t72-3.71067580019
     1         6128d-2*t166*t174*t65*t70*t71+t172+t167+t164+t163
            t176 = -2.7242157771351844d-1*t159*t59*t61*t64*t69*t74+1.362
     1         1078885675922d-1*t168*t59*t61*t63*t74-1.3621078885675922d
     2         -1*t169*t175*t59*t61*t63*t69+t162
            t177 = 3.109069086965489d-2*t58*t76*t89
            t178 = -4*t131*t28*t36+t130+t128+t121+t120
            t179 = t14+t134
            t180 = t138+t135
            t181 = 2.564881401242048d+0*t140*t180+2.564881401242048d+0*t
     1         137*t179
            t182 = 5.848223622634648d-1*t181*t37+5.848223622634648d-1*t1
     1         78*t19+t114+t112
            t183 = 3.333333333333333d-1*t158*t180+3.333333333333333d-1*t
     1         157*t179
            t184 = -2.7242157771351844d-1*t183*t59*t61*t64*t67
            t185 = 9.649190532874448d+1*t183*t38*t70-3.216396844291483d+
     1         1*t182*t64
            t186 = -1.3621078885675922d-1*t165*t185*t59*t61*t63*t65
            t187 = t186+t184+t164
            t188 = -7.421351600392256d-2*t173*t183*t71*t72-3.71067580019
     1         6128d-2*t174*t185*t65*t70*t71+t186+t184+t172+t164
            t189 = -2.7242157771351844d-1*t183*t59*t61*t64*t69*t74+1.362
     1         1078885675922d-1*t187*t59*t61*t63*t74-1.3621078885675922d
     2         -1*t169*t188*t59*t61*t63*t69+t162
            t190 = 1/t60**4.0d+0
            t191 = 3.710675800196128d-2*t190*t59*t70*t72+1.3621078885675
     1         922d-1*t61*t63*t67
            t192 = 1.855337900098064d-2*t190*t59*t67*t70*t74+1.362107888
     1         5675922d-1*t61*t63*t69*t74-1.3621078885675922d-1*t169*t19
     2         1*t59*t61*t63*t69
            t193 = 3.109069086965489d-2*t1*t156*t192*t58*t89*wght
            t194 = 7.421351600392256d-2*t190*t59*t70*t72+2.7242157771351
     1         844d-1*t61*t63*t67
            t195 = 3.710675800196128d-2*t190*t59*t67*t70*t74+2.724215777
     1         1351844d-1*t61*t63*t69*t74-1.3621078885675922d-1*t169*t19
     2         4*t59*t61*t63*t69
            t196 = -t40*t43*t91-t42*t43
            t197 = -t40*t44*t91-t42*t44+t196*t40*t42
            t198 = -t40*t45*t91-t42*t45+t197*t40*t42
            t199 = -t40*t46*t91-t42*t46+t198*t40*t42
            t200 = -t40*t47*t91-t42*t47+t199*t40*t42
            t201 = -t40*t48*t91-t42*t48+t200*t40*t42
            t202 = -t40*t49*t91-t42*t49+t201*t40*t42
            t203 = -t40*t50*t91-t42*t50+t202*t40*t42
            t204 = -t40*t51*t91-t42*t51+t203*t40*t42
            t205 = -t40*t52*t91-t42*t52+t204*t40*t42
            t206 = -t40*t53*t91-t42*t53+t205*t40*t42
            t207 = -t40*t78*t91-t42*t78
            t208 = -t40*t79*t91-t42*t79+t207*t40*t42
            t209 = -t40*t80*t91-t42*t80+t208*t40*t42
            t210 = -t40*t81*t91-t42*t81+t209*t40*t42
            t211 = -t40*t82*t91-t42*t82+t210*t40*t42
            t212 = -t40*t83*t91-t42*t83+t211*t40*t42
            t213 = -t40*t84*t91-t42*t84+t212*t40*t42
            t214 = -t40*t85*t91-t42*t85+t213*t40*t42
            t215 = -t40*t86*t91-t42*t86+t214*t40*t42
            t216 = -t40*t87*t91-t42*t87+t215*t40*t42
            t217 = -t40*t88*t91
            t218 = -t42*t88+t216*t40*t42+t217
            t219 = 1.0d+0*(3.109069086965489d-2*t1*t218*t58*t76+1.0d+0*t
     1         1*t206*t38)*wght
            t220 = t1**1.3333333333333333d+0
            t221 = 1/t41**3
            t222 = 1/t1**3.333333333333333d-1
            t223 = 1.0d+0*t1*t38*(t40*t42*(t40*t42*(-9.570780000627304d+
     1         0*t40*t90*t91*t99+9.570780000627304d+0*t42*t90*t99+t40*t4
     2         2*(-9.570780000627304d+0*t40*t90*t91*t98+9.57078000062730
     3         4d+0*t42*t90*t98+t40*t42*(-9.570780000627304d+0*t40*t90*t
     4         91*t97+9.570780000627304d+0*t42*t90*t97+t40*t42*(-9.57078
     5         0000627304d+0*t40*t90*t91*t96+9.570780000627304d+0*t42*t9
     6         0*t96+t40*t42*(-9.570780000627304d+0*t40*t90*t91*t95+9.57
     7         0780000627304d+0*t42*t90*t95+t40*t42*(-9.570780000627304d
     8         +0*t40*t90*t91*t94+9.570780000627304d+0*t42*t90*t94+t40*t
     9         42*(-9.570780000627304d+0*t40*t90*t91*t93+9.5707800006273
     :         04d+0*t42*t90*t93+t40*t42*(-9.570780000627304d+0*t40*t90*
     ;         t91*t92+9.570780000627304d+0*t42*t90*t92+t40*t42*(-3.1902
     <         60000209101d+0*t222*t40*t43*t91-4.579991491020378d+1*t220
     =         *t43*t91+3.190260000209101d+0*t222*t42*t43+4.579991491020
     >         378d+1*t220*t221*t40*t43)-3.190260000209101d+0*t222*t40*t
     ?         44*t91-4.579991491020378d+1*t220*t44*t91+3.19026000020910
     @         1d+0*t222*t42*t44+4.579991491020378d+1*t220*t221*t40*t44)
     1         -3.190260000209101d+0*t222*t40*t45*t91-4.579991491020378d
     2         +1*t220*t45*t91+3.190260000209101d+0*t222*t42*t45+4.57999
     3         1491020378d+1*t220*t221*t40*t45)-3.190260000209101d+0*t22
     4         2*t40*t46*t91-4.579991491020378d+1*t220*t46*t91+3.1902600
     5         00209101d+0*t222*t42*t46+4.579991491020378d+1*t220*t221*t
     6         40*t46)-3.190260000209101d+0*t222*t40*t47*t91-4.579991491
     7         020378d+1*t220*t47*t91+3.190260000209101d+0*t222*t42*t47+
     8         4.579991491020378d+1*t220*t221*t40*t47)-3.190260000209101
     9         d+0*t222*t40*t48*t91-4.579991491020378d+1*t220*t48*t91+3.
     :         190260000209101d+0*t222*t42*t48+4.579991491020378d+1*t220
     ;         *t221*t40*t48)-3.190260000209101d+0*t222*t40*t49*t91-4.57
     <         9991491020378d+1*t220*t49*t91+3.190260000209101d+0*t222*t
     =         42*t49+4.579991491020378d+1*t220*t221*t40*t49)-3.19026000
     >         0209101d+0*t222*t40*t50*t91-4.579991491020378d+1*t220*t50
     ?         *t91+3.190260000209101d+0*t222*t42*t50+4.579991491020378d
     @         +1*t220*t221*t40*t50)-3.190260000209101d+0*t222*t40*t51*t
     1         91-4.579991491020378d+1*t220*t51*t91+3.190260000209101d+0
     2         *t222*t42*t51+4.579991491020378d+1*t220*t221*t40*t51)-9.5
     3         70780000627304d+0*t100*t40*t90*t91-3.190260000209101d+0*t
     4         222*t40*t52*t91-4.579991491020378d+1*t220*t52*t91+9.57078
     5         0000627304d+0*t100*t42*t90+3.190260000209101d+0*t222*t42*
     6         t52+4.579991491020378d+1*t220*t221*t40*t52)-9.57078000062
     7         7304d+0*t101*t40*t90*t91-3.190260000209101d+0*t222*t40*t5
     8         3*t91-4.579991491020378d+1*t220*t53*t91+9.570780000627304
     9         d+0*t101*t42*t90+3.190260000209101d+0*t222*t42*t53+4.5799
     :         91491020378d+1*t220*t221*t40*t53)
            t224 = 2.0d+0*t102*t38
            t225 = t110**2
            t226 = 1/t11**2
            t227 = 6.21814d-2*t225*t226*t4
            t228 = 1/t1**2.3333333333333334d+0
            t229 = 1/t5**5
            t230 = 1/t1**1.6666666666666669d+0
            t231 = 2.539284902500284d+0*t108**2*t5/t9**3-1.2696424512501
     1         42d+0*t109*t5*(8.751370198886037d-2*t106*t230*t8+6.563527
     2         649164527d-2*t104*t229*t8+7.876233178997433d-1*t6*(8.7513
     3         70198886037d-2*t106*t230*t7+6.563527649164527d-2*t104*t22
     4         9*t7+4.753699179395351d-3*t228)-2.625411059665811d-1*t105
     5         *t106*t107)-1.4107138347223802d-1*t10*t230*t6-4.232141504
     6         16714d-1*t105*t108*t109*t6-3.52678458680595d-2*t10*t104*t
     7         106
            t232 = -6.21814d-2*t111*t231*t4
            t233 = 5.495546528376876d-3*t110*t111*t113
            t234 = 1/t1**2.333333333333333d+0
            t235 = -3.663697685584584d-3*t12*t234
            t236 = t118**2
            t237 = 1/t25**2
            t238 = -3.37738d-2*t20*t236*t237
            t239 = -1.269642451250142d+0*t117*t5*(7.876233178997433d-1*(
     1         8.751370198886037d-2*t106*t21*t230+6.563527649164527d-2*t
     2         104*t21*t229+2.601716490612924d-3*t228)*t6+8.751370198886
     3         037d-2*t106*t22*t230+6.563527649164527d-2*t104*t22*t229-2
     4         .625411059665811d-1*t105*t106*t115)-1.4107138347223802d-1
     5         *t230*t24*t6-4.23214150416714d-1*t105*t116*t117*t6+2.5392
     6         84902500284d+0*t116**2*t5/t23**3-3.52678458680595d-2*t104
     7         *t106*t24
            t240 = 3.37738d-2*t119*t20*t239
            t241 = -1.5539098445407465d-3*t113*t118*t119
            t242 = 1.0359398963604977d-3*t234*t26
            t243 = t27*t28*(1.709920934161365d+0*(-3.10907d-2*t126*t29*(
     1         -1.269642451250142d+0*t124*t5*(7.876233178997433d-1*(8.75
     2         1370198886037d-2*t106*t230*t30+6.563527649164527d-2*t104*
     3         t229*t30+3.0144339229749983d-3*t228)*t6+8.751370198886037
     4         d-2*t106*t230*t31+6.563527649164527d-2*t104*t229*t31-2.62
     5         5411059665811d-1*t105*t106*t122)-1.4107138347223802d-1*t2
     6         30*t33*t6-4.23214150416714d-1*t105*t123*t124*t6+2.5392849
     7         02500284d+0*t123**2*t5/t32**3-3.52678458680595d-2*t104*t1
     8         06*t33)+6.21814d-2*t111*t231*t4-6.21814d-2*t225*t226*t4-1
     9         .7613865241785687d-3*t234*t35+3.10907d-2*t125**2*t29/t34*
     :         *2+3.663697685584584d-3*t12*t234+2.642079786267853d-3*t11
     ;         3*t125*t126-5.495546528376876d-3*t110*t111*t113)-1.035939
     <         8963604977d-3*t234*t26-3.37738d-2*t119*t20*t239+3.37738d-
     =         2*t20*t236*t237+1.5539098445407465d-3*t113*t118*t119)
            t244 = -8*t127*t129*t27
            t245 = 20*t27*t36/t1**6
            t246 = t13**2
            t247 = 12*t246*t28*t36
            t248 = t136**2
            t249 = 1/t55
            t250 = 1/t1**3
            t251 = -2*t13*t250
            t252 = 2*t133
            t253 = t252+t251
            t254 = t139**2
            t255 = 1/t56
            t256 = 2*t13*t250
            t257 = -2*t133
            t258 = t257+t256
            t259 = 5.848223622634648d-1*(2.564881401242048d+0*t140*t258+
     1         8.549604670806825d-1*t254*t255+2.564881401242048d+0*t137*
     2         t253+8.549604670806825d-1*t248*t249)*t37+5.84822362263464
     3         8d-1*t19*(-32*t129*t131*t36+8*t127*t131*t28+t247+t245+t24
     4         4+t243+t242+t241+t240+t238)+t235+t233+t232+t227+1.1696447
     5         245269297d+0*t132*t141
            t260 = 3.109069086965489d-2*t1*t58*t76*(t40*t42*(t40*t42*(t4
     1         0*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t
     2         42*(t40*t42*(-3.190260000209101d+0*t222*t40*t78*t91-4.579
     3         991491020378d+1*t220*t78*t91+3.190260000209101d+0*t222*t4
     4         2*t78+4.579991491020378d+1*t220*t221*t40*t78)-9.570780000
     5         627304d+0*t144*t40*t90*t91-3.190260000209101d+0*t222*t40*
     6         t79*t91-4.579991491020378d+1*t220*t79*t91+9.5707800006273
     7         04d+0*t144*t42*t90+3.190260000209101d+0*t222*t42*t79+4.57
     8         9991491020378d+1*t220*t221*t40*t79)-9.570780000627304d+0*
     9         t145*t40*t90*t91-3.190260000209101d+0*t222*t40*t80*t91-4.
     :         579991491020378d+1*t220*t80*t91+9.570780000627304d+0*t145
     ;         *t42*t90+3.190260000209101d+0*t222*t42*t80+4.579991491020
     <         378d+1*t220*t221*t40*t80)-9.570780000627304d+0*t146*t40*t
     =         90*t91-3.190260000209101d+0*t222*t40*t81*t91-4.5799914910
     >         20378d+1*t220*t81*t91+9.570780000627304d+0*t146*t42*t90+3
     ?         .190260000209101d+0*t222*t42*t81+4.579991491020378d+1*t22
     @         0*t221*t40*t81)-9.570780000627304d+0*t147*t40*t90*t91-3.1
     1         90260000209101d+0*t222*t40*t82*t91-4.579991491020378d+1*t
     2         220*t82*t91+9.570780000627304d+0*t147*t42*t90+3.190260000
     3         209101d+0*t222*t42*t82+4.579991491020378d+1*t220*t221*t40
     4         *t82)-9.570780000627304d+0*t148*t40*t90*t91-3.19026000020
     5         9101d+0*t222*t40*t83*t91-4.579991491020378d+1*t220*t83*t9
     6         1+9.570780000627304d+0*t148*t42*t90+3.190260000209101d+0*
     7         t222*t42*t83+4.579991491020378d+1*t220*t221*t40*t83)-9.57
     8         0780000627304d+0*t149*t40*t90*t91-3.190260000209101d+0*t2
     9         22*t40*t84*t91-4.579991491020378d+1*t220*t84*t91+9.570780
     :         000627304d+0*t149*t42*t90+3.190260000209101d+0*t222*t42*t
     ;         84+4.579991491020378d+1*t220*t221*t40*t84)-9.570780000627
     <         304d+0*t150*t40*t90*t91-3.190260000209101d+0*t222*t40*t85
     =         *t91-4.579991491020378d+1*t220*t85*t91+9.570780000627304d
     >         +0*t150*t42*t90+3.190260000209101d+0*t222*t42*t85+4.57999
     ?         1491020378d+1*t220*t221*t40*t85)-9.570780000627304d+0*t15
     @         1*t40*t90*t91-3.190260000209101d+0*t222*t40*t86*t91-4.579
     1         991491020378d+1*t220*t86*t91+9.570780000627304d+0*t151*t4
     2         2*t90+3.190260000209101d+0*t222*t42*t86+4.579991491020378
     3         d+1*t220*t221*t40*t86)-9.570780000627304d+0*t152*t40*t90*
     4         t91-3.190260000209101d+0*t222*t40*t87*t91-4.5799914910203
     5         78d+1*t220*t87*t91+9.570780000627304d+0*t152*t42*t90+3.19
     6         0260000209101d+0*t222*t42*t87+4.579991491020378d+1*t220*t
     7         221*t40*t87)-9.570780000627304d+0*t153*t40*t90*t91-3.1902
     8         60000209101d+0*t222*t40*t88*t91-4.579991491020378d+1*t220
     9         *t88*t91+9.570780000627304d+0*t153*t42*t90+3.190260000209
     :         101d+0*t222*t42*t88+4.579991491020378d+1*t220*t221*t40*t8
     ;         8)
            t261 = 6.218138173930978d-2*t154*t58*t76
            t262 = 1/t75**2
            t263 = t159**2
            t264 = 1/t16
            t265 = 1/t18
            t266 = -1.111111111111111d-1*t254*t265-1.111111111111111d-1*
     1         t248*t264+3.333333333333333d-1*t158*t258+3.33333333333333
     2         3d-1*t157*t253
            t267 = t1**3.333333333333335d-1
            t268 = 1.1123881089968671d+0*t190*t267*t59*t63*t69*t74
            t269 = 1/t1**8.333333333333333d-1
            t270 = -5.297086233318417d-2*t161*t269*t59*t63*t69*t74
            t271 = 8.172647331405554d-1*t263*t59*t61*t67*t70
            t272 = -2.7242157771351844d-1*t266*t59*t61*t64*t67
            t273 = 1.2713006959964196d+0*t159*t160*t161*t59*t64*t67
            t274 = 1.1123881089968671d+0*t190*t267*t59*t63*t67
            t275 = -5.297086233318417d-2*t161*t269*t59*t63*t67
            t276 = 9.649190532874448d+1*t266*t38*t70+1.9298381065748896d
     1         +2*t142*t159*t70-3.216396844291483d+1*t259*t64-3.85967621
     2         3149779d+2*t173*t263*t38
            t277 = -1.3621078885675922d-1*t165*t276*t59*t61*t63*t65
            t278 = 5.448431554270369d-1*t159*t165*t166*t59*t61*t64*t65
            t279 = 6.356503479982097d-1*t160*t161*t165*t166*t59*t63*t65
            t280 = exp(-6.432793688582966d+1*t38*t64)
            t281 = 1/t66**3
            t282 = t166**2
            t283 = 2.7242157771351844d-1*t280*t281*t282*t59*t61*t63
            t284 = -1.3621078885675922d-1*t165*t282*t59*t61*t63*t65
            t285 = 1/t60**6.0d+0
            t286 = 5.050642061378063d-1*t170*t267*t285*t70*t72
            t287 = -1.4430405889651615d-2*t170*t171*t269*t70*t72
            t288 = 1/t57**6.0d+0
            t289 = 1/t66**4.0d+0
            t290 = 1/t73**3
            t291 = 5.848223622634648d-1*(8.549604670806825d-1*t139*t180*
     1         t255+5.129762802484096d+0*t13*t140*t250-5.129762802484096
     2         d+0*t13*t137*t250+8.549604670806825d-1*t136*t179*t249)*t3
     3         7+5.848223622634648d-1*t19*(-12*t246*t28*t36+t245+t244+t2
     4         43+t242+t241+t240+t238)+t235+t233+t232+t227+5.84822362263
     5         4648d-1*t132*t181+5.848223622634648d-1*t141*t178
            t292 = -1.111111111111111d-1*t139*t180*t265-1.11111111111111
     1         1d-1*t136*t179*t264+6.666666666666666d-1*t13*t158*t250-6.
     2         666666666666666d-1*t13*t157*t250
            t293 = 8.172647331405554d-1*t159*t183*t59*t61*t67*t70
            t294 = -2.7242157771351844d-1*t292*t59*t61*t64*t67
            t295 = 6.356503479982097d-1*t160*t161*t183*t59*t64*t67
            t296 = 6.356503479982097d-1*t159*t160*t161*t59*t64*t67
            t297 = 9.649190532874448d+1*t292*t38*t70+9.649190532874448d+
     1         1*t142*t183*t70+9.649190532874448d+1*t159*t182*t70-3.2163
     2         96844291483d+1*t291*t64-3.859676213149779d+2*t159*t173*t1
     3         83*t38
            t298 = -1.3621078885675922d-1*t165*t297*t59*t61*t63*t65
            t299 = 2.7242157771351844d-1*t159*t165*t185*t59*t61*t64*t65
            t300 = 3.1782517399910487d-1*t160*t161*t165*t185*t59*t63*t65
            t301 = 2.7242157771351844d-1*t165*t166*t183*t59*t61*t64*t65
            t302 = 3.1782517399910487d-1*t160*t161*t165*t166*t59*t63*t65
            t303 = 2.7242157771351844d-1*t166*t185*t280*t281*t59*t61*t63
            t304 = -1.3621078885675922d-1*t165*t166*t185*t59*t61*t63*t65
            t305 = t179**2
            t306 = t257+t251
            t307 = t180**2
            t308 = t256+t252
            t309 = 5.848223622634648d-1*(2.564881401242048d+0*t140*t308+
     1         8.549604670806825d-1*t255*t307+2.564881401242048d+0*t137*
     2         t306+8.549604670806825d-1*t249*t305)*t37+5.84822362263464
     3         8d-1*t19*(32*t129*t131*t36-8*t127*t131*t28+t247+t245+t244
     4         +t243+t242+t241+t240+t238)+t235+t233+t232+t227+1.16964472
     5         45269297d+0*t178*t181
            t310 = t183**2
            t311 = 3.333333333333333d-1*t158*t308-1.111111111111111d-1*t
     1         265*t307+3.333333333333333d-1*t157*t306-1.111111111111111
     2         d-1*t264*t305
            t312 = 8.172647331405554d-1*t310*t59*t61*t67*t70
            t313 = -2.7242157771351844d-1*t311*t59*t61*t64*t67
            t314 = 1.2713006959964196d+0*t160*t161*t183*t59*t64*t67
            t315 = 9.649190532874448d+1*t311*t38*t70+1.9298381065748896d
     1         +2*t182*t183*t70-3.216396844291483d+1*t309*t64-3.85967621
     2         3149779d+2*t173*t310*t38
            t316 = -1.3621078885675922d-1*t165*t315*t59*t61*t63*t65
            t317 = 5.448431554270369d-1*t165*t183*t185*t59*t61*t64*t65
            t318 = 6.356503479982097d-1*t160*t161*t165*t185*t59*t63*t65
            t319 = t185**2
            t320 = 2.7242157771351844d-1*t280*t281*t319*t59*t61*t63
            t321 = -1.3621078885675922d-1*t165*t319*t59*t61*t63*t65
            t322 = 3.109069086965489d-2*t1*t154*t192*t58
            t323 = 3.109069086965489d-2*t192*t58*t89
            t324 = 3.1782517399910487d-1*t160*t161*t169*t191*t59*t63*t69
            t325 = -3.1782517399910487d-1*t160*t161*t63*t69*t74
            t326 = -4.3291217668954834d-2*t160*t171*t59*t67*t70*t74
            t327 = -2.7242157771351844d-1*t159*t61*t64*t67
            t328 = -3.1782517399910487d-1*t160*t161*t63*t67
            t329 = -1.3621078885675922d-1*t165*t166*t61*t63*t65
            t330 = -1.7316487067581932d-1*t160*t171*t59*t70*t72
            t331 = 1.0d+0*(t156*(3.109069086965489d-2*t1*t58*(-2.7242157
     1         771351844d-1*t159*t61*t64*t69*t74-3.710675800196128d-2*t1
     2         59*t173*t190*t59*t67*t74+1.3621078885675922d-1*(t329+t328
     3         +t327)*t59*t61*t63*t74+1.3621078885675922d-1*t168*t61*t63
     4         *t74-1.3621078885675922d-1*t169*t59*t61*t63*t69*(-1.48427
     5         03200784513d-1*t159*t173*t190*t59*t72-7.421351600392256d-
     6         2*t166*t174*t190*t59*t65*t70+t330+t329+t328+t327)-1.85533
     7         7900098064d-2*t169*t175*t190*t59*t67*t70+2.72421577713518
     8         44d-1*t159*t169*t191*t59*t61*t64*t69+2.7242157771351844d-
     9         1*t175*t191*t290*t59*t61*t63*t69-1.3621078885675922d-1*t1
     :         69*t175*t61*t63*t69-1.3621078885675922d-1*t168*t169*t191*
     ;         t59*t61*t63+t326+t325+t324)*t89+9.327207260896466d-2*t1*t
     <         159*t192*t62*t89+t323+t322)-3.109069086965489d-2*t1*t176*
     =         t192*t262*t58*t89)*wght
            t332 = 3.109069086965489d-2*t1*t154*t195*t58
            t333 = 3.109069086965489d-2*t195*t58*t89
            t334 = 3.1782517399910487d-1*t160*t161*t169*t194*t59*t63*t69
            t335 = -6.356503479982097d-1*t160*t161*t63*t69*t74
            t336 = -8.658243533790967d-2*t160*t171*t59*t67*t70*t74
            t337 = -5.448431554270369d-1*t159*t61*t64*t67
            t338 = -6.356503479982097d-1*t160*t161*t63*t67
            t339 = -2.7242157771351844d-1*t165*t166*t61*t63*t65
            t340 = -3.4632974135163863d-1*t160*t171*t59*t70*t72
            t341 = -2.7242157771351844d-1*t183*t61*t64*t67
            t342 = -1.3621078885675922d-1*t165*t185*t61*t63*t65
            t343 = 1.0d+0*(t156*(3.109069086965489d-2*t1*t58*(-2.7242157
     1         771351844d-1*t183*t61*t64*t69*t74-3.710675800196128d-2*t1
     2         73*t183*t190*t59*t67*t74+1.3621078885675922d-1*(t342+t341
     3         +t328)*t59*t61*t63*t74+1.3621078885675922d-1*t187*t61*t63
     4         *t74-1.3621078885675922d-1*t169*t59*t61*t63*t69*(-1.48427
     5         03200784513d-1*t173*t183*t190*t59*t72-7.421351600392256d-
     6         2*t174*t185*t190*t59*t65*t70+t342+t341+t330+t328)-1.85533
     7         7900098064d-2*t169*t188*t190*t59*t67*t70+2.72421577713518
     8         44d-1*t169*t183*t191*t59*t61*t64*t69+2.7242157771351844d-
     9         1*t188*t191*t290*t59*t61*t63*t69-1.3621078885675922d-1*t1
     :         69*t188*t61*t63*t69-1.3621078885675922d-1*t169*t187*t191*
     ;         t59*t61*t63+t326+t325+t324)*t89+9.327207260896466d-2*t1*t
     <         183*t192*t62*t89+t323+t322)-3.109069086965489d-2*t1*t189*
     =         t192*t262*t58*t89)*wght
            t344 = -5.448431554270369d-1*t183*t61*t64*t67
            t345 = -2.7242157771351844d-1*t165*t185*t61*t63*t65
            t346 = -2.7242157771351844d-1*t169*t191*t61*t63*t69
            t347 = -3.710675800196128d-2*t169*t190*t191*t59*t67*t70
            t348 = 3.109069086965489d-2*t1*t156*t58*(3.710675800196128d-
     1         2*t190*t67*t70*t74-5.054340779364009d-3*t169*t285*t288*t5
     2         9*t69*t72+2.7242157771351844d-1*t191**2*t290*t59*t61*t63*
     3         t69+t347+t346)*t89*wght-3.109069086965489d-2*t1*t192**2*t
     4         262*t58*t89*wght
            t349 = 3.109069086965489d-2*t1*t156*t58*(7.421351600392256d-
     1         2*t190*t67*t70*t74-1.0108681558728018d-2*t169*t285*t288*t
     2         59*t69*t72-1.855337900098064d-2*t169*t190*t194*t59*t67*t7
     3         0+2.7242157771351844d-1*t191*t194*t290*t59*t61*t63*t69-1.
     4         3621078885675922d-1*t169*t194*t61*t63*t69+t347+t346)*t89*
     5         wght-3.109069086965489d-2*t1*t192*t195*t262*t58*t89*wght
            t350 = t40**2
            t351 = 1/t41**4
            t352 = 1.0d+0*t1*t38*(t40*t42*(t40*t42*(-t40*t91*t99-t42*t99
     1         +t40*t42*(-t40*t91*t98-t42*t98+t40*t42*(-t40*t91*t97-t42*
     2         t97+t40*t42*(-t40*t91*t96-t42*t96+t40*t42*(-t40*t91*t95-t
     3         42*t95+t40*t42*(-t40*t91*t94-t42*t94+t40*t42*(-t40*t91*t9
     4         3-t42*t93+t40*t42*(-t40*t91*t92-t42*t92-4.785390000313652
     5         d+0*t196*t40*t90*t91+9.570780000627304d+0*t221*t40*t44*t9
     6         0+9.570780000627304d+0*t350*t351*t43*t90+4.78539000031365
     7         2d+0*t196*t42*t90)-4.785390000313652d+0*t197*t40*t90*t91+
     8         9.570780000627304d+0*t221*t40*t45*t90+4.785390000313652d+
     9         0*t197*t42*t90)-4.785390000313652d+0*t198*t40*t90*t91+9.5
     :         70780000627304d+0*t221*t40*t46*t90+4.785390000313652d+0*t
     ;         198*t42*t90)-4.785390000313652d+0*t199*t40*t90*t91+9.5707
     <         80000627304d+0*t221*t40*t47*t90+4.785390000313652d+0*t199
     =         *t42*t90)-4.785390000313652d+0*t200*t40*t90*t91+9.5707800
     >         00627304d+0*t221*t40*t48*t90+4.785390000313652d+0*t200*t4
     ?         2*t90)-4.785390000313652d+0*t201*t40*t90*t91+9.5707800006
     @         27304d+0*t221*t40*t49*t90+4.785390000313652d+0*t201*t42*t
     1         90)-4.785390000313652d+0*t202*t40*t90*t91+9.5707800006273
     2         04d+0*t221*t40*t50*t90+4.785390000313652d+0*t202*t42*t90)
     3         -4.785390000313652d+0*t203*t40*t90*t91+9.570780000627304d
     4         +0*t221*t40*t51*t90+4.785390000313652d+0*t203*t42*t90)-4.
     5         785390000313652d+0*t204*t40*t90*t91-t100*t40*t91+9.570780
     6         000627304d+0*t221*t40*t52*t90+4.785390000313652d+0*t204*t
     7         42*t90-t100*t42)-4.785390000313652d+0*t205*t40*t90*t91-t1
     8         01*t40*t91+9.570780000627304d+0*t221*t40*t53*t90+4.785390
     9         000313652d+0*t205*t42*t90-t101*t42)
            t353 = 1.0d+0*t206*t38
            t354 = 3.109069086965489d-2*t1*t58*t76*(t40*t42*(t40*t42*(t4
     1         0*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t
     2         42*(-4.785390000313652d+0*t207*t40*t90*t91-t144*t40*t91+9
     3         .570780000627304d+0*t221*t40*t79*t90+9.570780000627304d+0
     4         *t350*t351*t78*t90+4.785390000313652d+0*t207*t42*t90-t144
     5         *t42)-4.785390000313652d+0*t208*t40*t90*t91-t145*t40*t91+
     6         9.570780000627304d+0*t221*t40*t80*t90+4.785390000313652d+
     7         0*t208*t42*t90-t145*t42)-4.785390000313652d+0*t209*t40*t9
     8         0*t91-t146*t40*t91+9.570780000627304d+0*t221*t40*t81*t90+
     9         4.785390000313652d+0*t209*t42*t90-t146*t42)-4.78539000031
     :         3652d+0*t210*t40*t90*t91-t147*t40*t91+9.570780000627304d+
     ;         0*t221*t40*t82*t90+4.785390000313652d+0*t210*t42*t90-t147
     <         *t42)-4.785390000313652d+0*t211*t40*t90*t91-t148*t40*t91+
     =         9.570780000627304d+0*t221*t40*t83*t90+4.785390000313652d+
     >         0*t211*t42*t90-t148*t42)-4.785390000313652d+0*t212*t40*t9
     ?         0*t91-t149*t40*t91+9.570780000627304d+0*t221*t40*t84*t90+
     @         4.785390000313652d+0*t212*t42*t90-t149*t42)-4.78539000031
     1         3652d+0*t213*t40*t90*t91-t150*t40*t91+9.570780000627304d+
     2         0*t221*t40*t85*t90+4.785390000313652d+0*t213*t42*t90-t150
     3         *t42)-4.785390000313652d+0*t214*t40*t90*t91-t151*t40*t91+
     4         9.570780000627304d+0*t221*t40*t86*t90+4.785390000313652d+
     5         0*t214*t42*t90-t151*t42)-4.785390000313652d+0*t215*t40*t9
     6         0*t91-t152*t40*t91+9.570780000627304d+0*t221*t40*t87*t90+
     7         4.785390000313652d+0*t215*t42*t90-t152*t42)-4.78539000031
     8         3652d+0*t216*t40*t90*t91-t153*t40*t91+9.570780000627304d+
     9         0*t221*t40*t88*t90+4.785390000313652d+0*t216*t42*t90-t153
     :         *t42)
            t355 = 3.109069086965489d-2*t218*t58*t76
            t356 = 1.0d+0*(9.327207260896466d-2*t1*t159*t218*t62*t76+3.1
     1         09069086965489d-2*t1*t156*t176*t218*t58+t355+t354+t353+t3
     2         52+1.0d+0*t1*t142*t206)*wght
            t357 = 1.0d+0*(9.327207260896466d-2*t1*t183*t218*t62*t76+3.1
     1         09069086965489d-2*t1*t156*t189*t218*t58+t355+t354+t353+t3
     2         52+1.0d+0*t1*t182*t206)*wght
            t358 = t42*(-t40*t42*t87-t77+t216*t40)+t217
            t359 = 3.109069086965489d-2*t1*t156*t192*t358*t58*wght
            t360 = 3.109069086965489d-2*t1*t156*t195*t358*t58*wght
            t361 = 1.0d+0*(3.109069086965489d-2*t1*t58*t76*(t40*t42*(t40
     1         *t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t4
     2         2*(t40*t42*(t40*t42*(2*t78*t91+2*t221*t40*t78)+2*t79*t91-
     3         2*t207*t40*t91+2*t221*t40*t79-2*t207*t42)+2*t80*t91-2*t20
     4         8*t40*t91+2*t221*t40*t80-2*t208*t42)+2*t81*t91-2*t209*t40
     5         *t91+2*t221*t40*t81-2*t209*t42)+2*t82*t91-2*t210*t40*t91+
     6         2*t221*t40*t82-2*t210*t42)+2*t83*t91-2*t211*t40*t91+2*t22
     7         1*t40*t83-2*t211*t42)+2*t84*t91-2*t212*t40*t91+2*t221*t40
     8         *t84-2*t212*t42)+2*t85*t91-2*t213*t40*t91+2*t221*t40*t85-
     9         2*t213*t42)+2*t86*t91-2*t214*t40*t91+2*t221*t40*t86-2*t21
     :         4*t42)+2*t87*t91-2*t215*t40*t91+2*t221*t40*t87-2*t215*t42
     ;         )+2*t88*t91-2*t216*t40*t91+2*t221*t40*t88-2*t216*t42)+1.0
     <         d+0*t1*t38*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(
     =         t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(2*t43*t91+2*
     >         t221*t40*t43)+2*t44*t91-2*t196*t40*t91+2*t221*t40*t44-2*t
     ?         196*t42)+2*t45*t91-2*t197*t40*t91+2*t221*t40*t45-2*t197*t
     @         42)+2*t46*t91-2*t198*t40*t91+2*t221*t40*t46-2*t198*t42)+2
     1         *t47*t91-2*t199*t40*t91+2*t221*t40*t47-2*t199*t42)+2*t48*
     2         t91-2*t200*t40*t91+2*t221*t40*t48-2*t200*t42)+2*t49*t91-2
     3         *t201*t40*t91+2*t221*t40*t49-2*t201*t42)+2*t50*t91-2*t202
     4         *t40*t91+2*t221*t40*t50-2*t202*t42)+2*t51*t91-2*t203*t40*
     5         t91+2*t221*t40*t51-2*t203*t42)+2*t52*t91-2*t204*t40*t91+2
     6         *t221*t40*t52-2*t204*t42)+2*t53*t91-2*t205*t40*t91+2*t221
     7         *t40*t53-2*t205*t42))*wght
            fnc(iq) = 1.0d+0*(3.109069086965489d-2*t1*t58*t76*t89+1.0d+0
     1         *t1*t38*t54)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(9.327207260896466d-2*t1*t159*t62*t7
     1         6*t89+3.109069086965489d-2*t1*t156*t176*t58*t89+1.0d+0*t1
     2         *t142*t54+t177+t155+t143+t103)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(9.327207260896466d-2*t1*t183*t62*t7
     1         6*t89+3.109069086965489d-2*t1*t156*t189*t58*t89+1.0d+0*t1
     2         *t182*t54+t177+t155+t143+t103)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t193+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 3.109069086965489d-2*t1*t156*t195*t58*t89*
     1         wght+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t193+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = t219+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = t219+Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t156*(3.109069086965489d-2*t1*t
     1         58*(8.172647331405554d-1*t263*t59*t61*t69*t70*t74-2.72421
     2         57771351844d-1*t266*t59*t61*t64*t69*t74+1.271300695996419
     3         6d+0*t159*t160*t161*t59*t64*t69*t74-5.448431554270369d-1*
     4         t159*t168*t59*t61*t64*t74+1.3621078885675922d-1*(t284+t28
     5         3+t279+t278+t277+t275+t274+t273+t272+t271)*t59*t61*t63*t7
     6         4-6.356503479982097d-1*t160*t161*t168*t59*t63*t74-1.36210
     7         78885675922d-1*t169*t59*t61*t63*t69*(3.710675800196128d-1
     8         *t263*t288*t71*t72-7.421351600392256d-2*t173*t266*t71*t72
     9         +6.926594827032773d-1*t159*t160*t170*t171*t173*t72-3.7106
     :         75800196128d-2*t174*t282*t65*t70*t71-3.710675800196128d-2
     ;         *t174*t276*t65*t70*t71+1.1132027400588385d-1*t280*t282*t2
     <         89*t70*t71+2.9685406401569026d-1*t159*t166*t173*t174*t65*
     =         t71+3.4632974135163863d-1*t160*t166*t170*t171*t174*t65*t7
     >         0+t287+t286+t284+t283+t279+t278+t277+t275+t274+t273+t272+
     ?         t271)+5.448431554270369d-1*t159*t169*t175*t59*t61*t64*t69
     @         +2.7242157771351844d-1*t175**2*t290*t59*t61*t63*t69+6.356
     1         503479982097d-1*t160*t161*t169*t175*t59*t63*t69-2.7242157
     2         771351844d-1*t168*t169*t175*t59*t61*t63+t270+t268)*t89+1.
     3         8654414521792934d-1*t1*t159*t176*t62*t89+6.21813817393097
     4         8d-2*t176*t58*t89+6.218138173930978d-2*t1*t154*t176*t58)+
     5         9.327207260896466d-2*t1*t266*t62*t76*t89+1.86544145217929
     6         34d-1*t159*t62*t76*t89+1.8654414521792934d-1*t1*t263*t57*
     7         t76*t89-3.109069086965489d-2*t1*t176**2*t262*t58*t89+1.86
     8         54414521792934d-1*t1*t154*t159*t62*t76+1.0d+0*t1*t259*t54
     9         +2.0d+0*t142*t54+t261+t260+t224+t223+2.0d+0*t1*t102*t142)
     :         *wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*(t156*(3.109069086965489d-2*t1*t
     1         58*(8.172647331405554d-1*t159*t183*t59*t61*t69*t70*t74-2.
     2         7242157771351844d-1*t292*t59*t61*t64*t69*t74+6.3565034799
     3         82097d-1*t160*t161*t183*t59*t64*t69*t74+6.356503479982097
     4         d-1*t159*t160*t161*t59*t64*t69*t74-2.7242157771351844d-1*
     5         t159*t187*t59*t61*t64*t74-2.7242157771351844d-1*t168*t183
     6         *t59*t61*t64*t74+1.3621078885675922d-1*(t304+t303+t302+t3
     7         01+t300+t299+t298+t296+t295+t294+t293+t275+t274)*t59*t61*
     8         t63*t74-3.1782517399910487d-1*t160*t161*t187*t59*t63*t74-
     9         3.1782517399910487d-1*t160*t161*t168*t59*t63*t74-1.362107
     :         8885675922d-1*t169*t59*t61*t63*t69*(-7.421351600392256d-2
     ;         *t173*t292*t71*t72+3.710675800196128d-1*t159*t183*t288*t7
     <         1*t72+3.4632974135163863d-1*t160*t170*t171*t173*t183*t72+
     =         3.4632974135163863d-1*t159*t160*t170*t171*t173*t72-3.7106
     >         75800196128d-2*t174*t297*t65*t70*t71-3.710675800196128d-2
     ?         *t166*t174*t185*t65*t70*t71+1.1132027400588385d-1*t166*t1
     @         85*t280*t289*t70*t71+1.4842703200784513d-1*t159*t173*t174
     1         *t185*t65*t71+1.4842703200784513d-1*t166*t173*t174*t183*t
     2         65*t71+1.7316487067581932d-1*t160*t170*t171*t174*t185*t65
     3         *t70+1.7316487067581932d-1*t160*t166*t170*t171*t174*t65*t
     4         70+t304+t303+t302+t301+t300+t299+t298+t296+t295+t294+t293
     5         +t287+t286+t275+t274)+2.7242157771351844d-1*t159*t169*t18
     6         8*t59*t61*t64*t69+2.7242157771351844d-1*t169*t175*t183*t5
     7         9*t61*t64*t69+2.7242157771351844d-1*t175*t188*t290*t59*t6
     8         1*t63*t69+3.1782517399910487d-1*t160*t161*t169*t188*t59*t
     9         63*t69+3.1782517399910487d-1*t160*t161*t169*t175*t59*t63*
     :         t69-1.3621078885675922d-1*t168*t169*t188*t59*t61*t63-1.36
     ;         21078885675922d-1*t169*t175*t187*t59*t61*t63+t270+t268)*t
     <         89+9.327207260896466d-2*t1*t159*t189*t62*t89+9.3272072608
     =         96466d-2*t1*t176*t183*t62*t89+3.109069086965489d-2*t189*t
     >         58*t89+3.109069086965489d-2*t176*t58*t89+3.10906908696548
     ?         9d-2*t1*t154*t189*t58+3.109069086965489d-2*t1*t154*t176*t
     @         58)+9.327207260896466d-2*t1*t292*t62*t76*t89+9.3272072608
     1         96466d-2*t183*t62*t76*t89+9.327207260896466d-2*t159*t62*t
     2         76*t89+1.8654414521792934d-1*t1*t159*t183*t57*t76*t89-3.1
     3         09069086965489d-2*t1*t176*t189*t262*t58*t89+9.32720726089
     4         6466d-2*t1*t154*t183*t62*t76+9.327207260896466d-2*t1*t154
     5         *t159*t62*t76+1.0d+0*t1*t291*t54+1.0d+0*t182*t54+1.0d+0*t
     6         142*t54+t261+t260+t224+t223+1.0d+0*t1*t102*t182+1.0d+0*t1
     7         *t102*t142)*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(t156*(3.109069086965489d-2*t1*t
     1         58*(8.172647331405554d-1*t310*t59*t61*t69*t70*t74-2.72421
     2         57771351844d-1*t311*t59*t61*t64*t69*t74+1.271300695996419
     3         6d+0*t160*t161*t183*t59*t64*t69*t74-5.448431554270369d-1*
     4         t183*t187*t59*t61*t64*t74+1.3621078885675922d-1*(t321+t32
     5         0+t318+t317+t316+t314+t313+t312+t275+t274)*t59*t61*t63*t7
     6         4-6.356503479982097d-1*t160*t161*t187*t59*t63*t74-1.36210
     7         78885675922d-1*t169*t59*t61*t63*t69*(-7.421351600392256d-
     8         2*t173*t311*t71*t72+3.710675800196128d-1*t288*t310*t71*t7
     9         2+6.926594827032773d-1*t160*t170*t171*t173*t183*t72-3.710
     :         675800196128d-2*t174*t319*t65*t70*t71-3.710675800196128d-
     ;         2*t174*t315*t65*t70*t71+1.1132027400588385d-1*t280*t289*t
     <         319*t70*t71+2.9685406401569026d-1*t173*t174*t183*t185*t65
     =         *t71+3.4632974135163863d-1*t160*t170*t171*t174*t185*t65*t
     >         70+t321+t320+t318+t317+t316+t314+t313+t312+t287+t286+t275
     ?         +t274)+5.448431554270369d-1*t169*t183*t188*t59*t61*t64*t6
     @         9+2.7242157771351844d-1*t188**2*t290*t59*t61*t63*t69+6.35
     1         6503479982097d-1*t160*t161*t169*t188*t59*t63*t69-2.724215
     2         7771351844d-1*t169*t187*t188*t59*t61*t63+t270+t268)*t89+1
     3         .8654414521792934d-1*t1*t183*t189*t62*t89+6.2181381739309
     4         78d-2*t189*t58*t89+6.218138173930978d-2*t1*t154*t189*t58)
     5         +9.327207260896466d-2*t1*t311*t62*t76*t89+1.8654414521792
     6         934d-1*t183*t62*t76*t89+1.8654414521792934d-1*t1*t310*t57
     7         *t76*t89-3.109069086965489d-2*t1*t189**2*t262*t58*t89+1.8
     8         654414521792934d-1*t1*t154*t183*t62*t76+1.0d+0*t1*t309*t5
     9         4+2.0d+0*t182*t54+t261+t260+t224+t223+2.0d+0*t1*t102*t182
     :         )*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = t331+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = 1.0d+0*(t156*(3.109069086965489d-2*t1*
     1         t58*(-5.448431554270369d-1*t159*t61*t64*t69*t74-7.4213516
     2         00392256d-2*t159*t173*t190*t59*t67*t74+1.3621078885675922
     3         d-1*(t339+t338+t337)*t59*t61*t63*t74+2.7242157771351844d-
     4         1*t168*t61*t63*t74-1.3621078885675922d-1*t169*t59*t61*t63
     5         *t69*(-2.9685406401569026d-1*t159*t173*t190*t59*t72-1.484
     6         2703200784513d-1*t166*t174*t190*t59*t65*t70+t340+t339+t33
     7         8+t337)-3.710675800196128d-2*t169*t175*t190*t59*t67*t70+2
     8         .7242157771351844d-1*t159*t169*t194*t59*t61*t64*t69+2.724
     9         2157771351844d-1*t175*t194*t290*t59*t61*t63*t69-2.7242157
     :         771351844d-1*t169*t175*t61*t63*t69-1.3621078885675922d-1*
     ;         t168*t169*t194*t59*t61*t63+t336+t335+t334)*t89+9.32720726
     <         0896466d-2*t1*t159*t195*t62*t89+t333+t332)-3.109069086965
     =         489d-2*t1*t176*t195*t262*t58*t89)*wght+Cmat2(iq,D2_RA_GAB
     >         )
            Cmat2(iq,D2_RA_GBB) = t331+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = t343+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = 1.0d+0*(t156*(3.109069086965489d-2*t1*
     1         t58*(-5.448431554270369d-1*t183*t61*t64*t69*t74-7.4213516
     2         00392256d-2*t173*t183*t190*t59*t67*t74+1.3621078885675922
     3         d-1*(t345+t344+t338)*t59*t61*t63*t74+2.7242157771351844d-
     4         1*t187*t61*t63*t74-1.3621078885675922d-1*t169*t59*t61*t63
     5         *t69*(-2.9685406401569026d-1*t173*t183*t190*t59*t72-1.484
     6         2703200784513d-1*t174*t185*t190*t59*t65*t70+t345+t344+t34
     7         0+t338)-3.710675800196128d-2*t169*t188*t190*t59*t67*t70+2
     8         .7242157771351844d-1*t169*t183*t194*t59*t61*t64*t69+2.724
     9         2157771351844d-1*t188*t194*t290*t59*t61*t63*t69-2.7242157
     :         771351844d-1*t169*t188*t61*t63*t69-1.3621078885675922d-1*
     ;         t169*t187*t194*t59*t61*t63+t336+t335+t334)*t89+9.32720726
     <         0896466d-2*t1*t183*t195*t62*t89+t333+t332)-3.109069086965
     =         489d-2*t1*t189*t195*t262*t58*t89)*wght+Cmat2(iq,D2_RB_GAB
     >         )
            Cmat2(iq,D2_RB_GBB) = t343+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = t348+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = t349+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t348+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 3.109069086965489d-2*t1*t156*t58*(1.4
     1         842703200784513d-1*t190*t67*t70*t74-2.0217363117456036d-2
     2         *t169*t285*t288*t59*t69*t72-7.421351600392256d-2*t169*t19
     3         0*t194*t59*t67*t70+2.7242157771351844d-1*t194**2*t290*t59
     4         *t61*t63*t69-5.448431554270369d-1*t169*t194*t61*t63*t69)*
     5         t89*wght-3.109069086965489d-2*t1*t195**2*t262*t58*t89*wgh
     6         t+Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = t349+Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = t348+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RA_TA) = t356+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = t356+Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_RB_TA) = t357+Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = t357+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GAA_TA) = t359+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = t359+Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = t360+Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_GAB_TB) = t360+Mmat2(iq,D2_GAB_TB)
            Mmat2(iq,D2_GBB_TA) = t359+Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = t359+Mmat2(iq,D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = t361+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = t361+Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = t361+Mmat2(iq,D2_TB_TB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 9.999999999999991d-1*(6.21814d-2*t17*t18-3.10907d-2*t1
     1         1*t9)-6.21814d-2*t17*t18
            t20 = 2.871234000188191d+0*rhoa**1.6666666666666669d+0
            t21 = -taub-taua+t20
            t22 = taub+taua+t20
            t23 = 1/t22
            t24 = param(12)
            t25 = t21*t23*t24+param(11)
            t26 = t21*t23*t25+param(10)
            t27 = t21*t23*t26+param(9)
            t28 = t21*t23*t27+param(8)
            t29 = t21*t23*t28+param(7)
            t30 = t21*t23*t29+param(6)
            t31 = t21*t23*t30+param(5)
            t32 = t21*t23*t31+param(4)
            t33 = t21*t23*t32+param(3)
            t34 = t21*t23*t33+param(2)
            t35 = t21*t23*t34+param(1)
            t36 = rhoa**1.1666666666666667d+0
            t37 = 1/t36**2.0d+0
            t38 = exp(-6.432793688582967d+1*t19)
            t39 = t38-1.0d+0
            t40 = 1/t39
            t41 = 2.1622114952063792d-1*gammaaa*t37*t40
            t42 = t41+1.0d+0
            t43 = (gammaaa*t37)**2.0d+0
            t44 = 1/t39**2.0d+0
            t45 = 4.675158550002606d-2*t43*t44+t41+1.0d+0
            t46 = 1/t45
            t47 = 2.1622114952063792d-1*gammaaa*t37*t42*t46+1.0d+0
            t48 = log(t47)
            t49 = param(14)
            t50 = param(24)
            t51 = t21*t23*t50+param(23)
            t52 = t21*t23*t51+param(22)
            t53 = t21*t23*t52+param(21)
            t54 = t21*t23*t53+param(20)
            t55 = t21*t23*t54+param(19)
            t56 = t21*t23*t55+param(18)
            t57 = t21*t23*t56+param(17)
            t58 = t21*t23*t57+param(16)
            t59 = t21*t23*t58+param(15)
            t60 = t21*t23*t59+t49
            t61 = t21*t23*t60+param(13)
            t62 = rhoa**6.666666666666666d-1
            t63 = 1/t22**2
            t64 = 4.785390000313652d+0*t23*t24*t62-4.785390000313652d+0*
     1         t21*t24*t62*t63
            t65 = t21*t23*t64-4.785390000313652d+0*t21*t25*t62*t63+4.785
     1         390000313652d+0*t23*t25*t62
            t66 = t21*t23*t65-4.785390000313652d+0*t21*t26*t62*t63+4.785
     1         390000313652d+0*t23*t26*t62
            t67 = t21*t23*t66-4.785390000313652d+0*t21*t27*t62*t63+4.785
     1         390000313652d+0*t23*t27*t62
            t68 = t21*t23*t67-4.785390000313652d+0*t21*t28*t62*t63+4.785
     1         390000313652d+0*t23*t28*t62
            t69 = t21*t23*t68-4.785390000313652d+0*t21*t29*t62*t63+4.785
     1         390000313652d+0*t23*t29*t62
            t70 = t21*t23*t69-4.785390000313652d+0*t21*t30*t62*t63+4.785
     1         390000313652d+0*t23*t30*t62
            t71 = t21*t23*t70-4.785390000313652d+0*t21*t31*t62*t63+4.785
     1         390000313652d+0*t23*t31*t62
            t72 = t21*t23*t71-4.785390000313652d+0*t21*t32*t62*t63+4.785
     1         390000313652d+0*t23*t32*t62
            t73 = t21*t23*t72-4.785390000313652d+0*t21*t33*t62*t63+4.785
     1         390000313652d+0*t23*t33*t62
            t74 = t21*t23*t73-4.785390000313652d+0*t21*t34*t62*t63+4.785
     1         390000313652d+0*t23*t34*t62
            t75 = 1/rhoa**1.3333333333333333d+0
            t76 = 1/t8
            t77 = 1/t6**2
            t78 = 1/rhoa**1.3333333333333336d+0
            t79 = 1/t2**3
            t80 = 1/rhoa**6.666666666666667d-1
            t81 = -1.3127055298329054d-1*t4*t79*t80-2.0096226153166658d-
     1         3*t78
            t82 = 7.876233178997433d-1*t3*t81-1.3127055298329054d-1*t5*t
     1         79*t80
            t83 = 2.11607075208357d-1*t3*t7*t80-1.269642451250142d+0*t2*
     1         t77*t82
            t84 = 1/t16
            t85 = 1/t14**2
            t86 = -1.3127055298329054d-1*t12*t79*t80-3.169132786263567d-
     1         3*t78
            t87 = 7.876233178997433d-1*t3*t86-1.3127055298329054d-1*t13*
     1         t79*t80
            t88 = 2.11607075208357d-1*t15*t3*t80-1.269642451250142d+0*t2
     1         *t85*t87
            t89 = 9.999999999999991d-1*(1.3210398931339265d-3*t75*t9+6.2
     1         1814d-2*t18*t84*t88-3.10907d-2*t11*t76*t83-2.747773264188
     2         438d-3*t17*t75)-6.21814d-2*t18*t84*t88+2.747773264188438d
     3         -3*t17*t75
            t90 = 4.785390000313652d+0*t23*t50*t62-4.785390000313652d+0*
     1         t21*t50*t62*t63
            t91 = t21*t23*t90-4.785390000313652d+0*t21*t51*t62*t63+4.785
     1         390000313652d+0*t23*t51*t62
            t92 = t21*t23*t91-4.785390000313652d+0*t21*t52*t62*t63+4.785
     1         390000313652d+0*t23*t52*t62
            t93 = t21*t23*t92-4.785390000313652d+0*t21*t53*t62*t63+4.785
     1         390000313652d+0*t23*t53*t62
            t94 = t21*t23*t93-4.785390000313652d+0*t21*t54*t62*t63+4.785
     1         390000313652d+0*t23*t54*t62
            t95 = t21*t23*t94-4.785390000313652d+0*t21*t55*t62*t63+4.785
     1         390000313652d+0*t23*t55*t62
            t96 = t21*t23*t95-4.785390000313652d+0*t21*t56*t62*t63+4.785
     1         390000313652d+0*t23*t56*t62
            t97 = t21*t23*t96-4.785390000313652d+0*t21*t57*t62*t63+4.785
     1         390000313652d+0*t23*t57*t62
            t98 = t21*t23*t97-4.785390000313652d+0*t21*t58*t62*t63+4.785
     1         390000313652d+0*t23*t58*t62
            t99 = t21*t23*t98-4.785390000313652d+0*t21*t59*t62*t63+4.785
     1         390000313652d+0*t23*t59*t62
            t100 = t21*t23*t99-4.785390000313652d+0*t21*t60*t62*t63+4.78
     1         5390000313652d+0*t23*t60*t62
            t101 = 1/t47
            t102 = rhoa**1.6666666666666674d-1
            t103 = 1/t36**3.0d+0
            t104 = -5.045160155481552d-1*gammaaa*t102*t103*t40
            t105 = 1/t39**2
            t106 = 1.3909060459745137d+1*gammaaa*t105*t37*t38*t89
            t107 = t106+t104
            t108 = 1/t45**2
            t109 = gammaaa**2
            t110 = 1/t36**5.0d+0
            t111 = 1/t39**3.0d+0
            t112 = 6.014866082716293d+0*t111*t38*t43*t89-2.1817406566678
     1         83d-1*t102*t109*t110*t44+t106+t104
            t113 = -5.045160155481552d-1*gammaaa*t102*t103*t42*t46+2.162
     1         2114952063792d-1*gammaaa*t107*t37*t46-2.1622114952063792d
     2         -1*gammaaa*t108*t112*t37*t42
            t114 = 1/t36**4.0d+0
            t115 = 9.350317100005212d-2*gammaaa*t114*t44+2.1622114952063
     1         792d-1*t37*t40
            t116 = 2.1622114952063792d-1*t37*t42*t46+4.675158550002606d-
     1         2*gammaaa*t114*t40*t46-2.1622114952063792d-1*gammaaa*t108
     2         *t115*t37*t42
            t117 = -t21*t24*t63-t23*t24
            t118 = -t21*t25*t63-t23*t25+t117*t21*t23
            t119 = -t21*t26*t63-t23*t26+t118*t21*t23
            t120 = -t21*t27*t63-t23*t27+t119*t21*t23
            t121 = -t21*t28*t63-t23*t28+t120*t21*t23
            t122 = -t21*t29*t63-t23*t29+t121*t21*t23
            t123 = -t21*t30*t63-t23*t30+t122*t21*t23
            t124 = -t21*t31*t63-t23*t31+t123*t21*t23
            t125 = -t21*t32*t63-t23*t32+t124*t21*t23
            t126 = -t21*t33*t63-t23*t33+t125*t21*t23
            t127 = -t21*t34*t63-t23*t34+t126*t21*t23
            t128 = -t21*t50*t63-t23*t50
            t129 = -t21*t51*t63-t23*t51+t128*t21*t23
            t130 = -t21*t52*t63-t23*t52+t129*t21*t23
            t131 = -t21*t53*t63-t23*t53+t130*t21*t23
            t132 = -t21*t54*t63-t23*t54+t131*t21*t23
            t133 = -t21*t55*t63-t23*t55+t132*t21*t23
            t134 = -t21*t56*t63-t23*t56+t133*t21*t23
            t135 = -t21*t57*t63-t23*t57+t134*t21*t23
            t136 = -t21*t58*t63-t23*t58+t135*t21*t23
            t137 = -t21*t59*t63-t23*t59+t136*t21*t23
            t138 = -t21*t60*t63
            t139 = -t23*t60+t137*t21*t23+t138
            t140 = 1.0d+0*(1.5545345434827443d-2*rhoa*t139*t48+1.0d+0*rh
     1         oa*t127*t19)*wght
            t141 = rhoa**1.3333333333333333d+0
            t142 = 1/t22**3
            t143 = 1/rhoa**3.333333333333333d-1
            t144 = 1/rhoa**2.333333333333333d+0
            t145 = 1/rhoa**2.3333333333333334d+0
            t146 = 1/rhoa**1.6666666666666669d+0
            t147 = 1/t2**5
            t148 = 1/t16**2
            t149 = t88**2
            t150 = 2.539284902500284d+0*t2*t87**2/t14**3-4.2321415041671
     1         4d-1*t3*t80*t85*t87-1.269642451250142d+0*t2*t85*(-2.62541
     2         1059665811d-1*t79*t80*t86+7.876233178997433d-1*t3*(8.7513
     3         70198886037d-2*t12*t146*t79+6.563527649164527d-2*t12*t147
     4         *t78+4.753699179395351d-3*t145)+8.751370198886037d-2*t13*
     5         t146*t79+6.563527649164527d-2*t13*t147*t78)-3.52678458680
     6         595d-2*t15*t78*t79-1.4107138347223802d-1*t146*t15*t3
            t151 = 9.999999999999991d-1*(-1.7613865241785687d-3*t144*t9-
     1         5.495546528376876d-3*t75*t84*t88+6.21814d-2*t150*t18*t84+
     2         3.10907d-2*t11*t83**2/t8**2+2.642079786267853d-3*t75*t76*
     3         t83-3.10907d-2*t11*t76*(2.539284902500284d+0*t2*t82**2/t6
     4         **3-4.23214150416714d-1*t3*t77*t80*t82-1.269642451250142d
     5         +0*t2*t77*(-2.625411059665811d-1*t79*t80*t81+7.8762331789
     6         97433d-1*t3*(8.751370198886037d-2*t146*t4*t79+6.563527649
     7         164527d-2*t147*t4*t78+3.0144339229749983d-3*t145)+8.75137
     8         0198886037d-2*t146*t5*t79+6.563527649164527d-2*t147*t5*t7
     9         8)-3.52678458680595d-2*t7*t78*t79-1.4107138347223802d-1*t
     :         146*t3*t7)-6.21814d-2*t148*t149*t18+3.663697685584584d-3*
     ;         t144*t17)+5.495546528376876d-3*t75*t84*t88-6.21814d-2*t15
     <         0*t18*t84+6.21814d-2*t148*t149*t18-3.663697685584584d-3*t
     =         144*t17
            t152 = 1/t47**2
            t153 = rhoa**3.333333333333335d-1
            t154 = 1/rhoa**8.333333333333333d-1
            t155 = t89**2
            t156 = exp(-1.2865587377165935d+2*t19)
            t157 = 1.7894823267913484d+3*gammaaa*t155*t156*t37/t39**3
            t158 = 1.765806054418543d+0*gammaaa*t114*t153*t40
            t159 = -8.408600259135923d-2*gammaaa*t103*t154*t40
            t160 = -6.490894881214397d+1*gammaaa*t102*t103*t105*t38*t89
            t161 = -8.947411633956742d+2*gammaaa*t105*t155*t37*t38
            t162 = 1.3909060459745137d+1*gammaaa*t105*t151*t37*t38
            t163 = 1/t36**6.0d+0
            t164 = 1/t45**3
            t165 = -5.045160155481552d-1*t102*t103*t40
            t166 = 1.3909060459745137d+1*t105*t37*t38*t89
            t167 = t21**2
            t168 = 1/t22**4
            t169 = 1.0d+0*(1.5545345434827443d-2*rhoa*t48*(-t21*t63*t99-
     1         t23*t99+t21*t23*(-t21*t63*t98-t23*t98+t21*t23*(-t21*t63*t
     2         97-t23*t97+t21*t23*(-t21*t63*t96-t23*t96+t21*t23*(-t21*t6
     3         3*t95-t23*t95+t21*t23*(-t21*t63*t94-t23*t94+t21*t23*(-t21
     4         *t63*t93-t23*t93+t21*t23*(-t21*t63*t92-t23*t92+t21*t23*(-
     5         t21*t63*t91-t23*t91+t21*t23*(-t21*t63*t90-t23*t90-4.78539
     6         0000313652d+0*t128*t21*t62*t63+9.570780000627304d+0*t142*
     7         t21*t51*t62+9.570780000627304d+0*t167*t168*t50*t62+4.7853
     8         90000313652d+0*t128*t23*t62)-4.785390000313652d+0*t129*t2
     9         1*t62*t63+9.570780000627304d+0*t142*t21*t52*t62+4.7853900
     :         00313652d+0*t129*t23*t62)-4.785390000313652d+0*t130*t21*t
     ;         62*t63+9.570780000627304d+0*t142*t21*t53*t62+4.7853900003
     <         13652d+0*t130*t23*t62)-4.785390000313652d+0*t131*t21*t62*
     =         t63+9.570780000627304d+0*t142*t21*t54*t62+4.7853900003136
     >         52d+0*t131*t23*t62)-4.785390000313652d+0*t132*t21*t62*t63
     ?         +9.570780000627304d+0*t142*t21*t55*t62+4.785390000313652d
     @         +0*t132*t23*t62)-4.785390000313652d+0*t133*t21*t62*t63+9.
     1         570780000627304d+0*t142*t21*t56*t62+4.785390000313652d+0*
     2         t133*t23*t62)-4.785390000313652d+0*t134*t21*t62*t63+9.570
     3         780000627304d+0*t142*t21*t57*t62+4.785390000313652d+0*t13
     4         4*t23*t62)-4.785390000313652d+0*t135*t21*t62*t63+9.570780
     5         000627304d+0*t142*t21*t58*t62+4.785390000313652d+0*t135*t
     6         23*t62)-4.785390000313652d+0*t136*t21*t62*t63+9.570780000
     7         627304d+0*t142*t21*t59*t62+4.785390000313652d+0*t136*t23*
     8         t62)-4.785390000313652d+0*t137*t21*t62*t63+9.570780000627
     9         304d+0*t142*t21*t60*t62+4.785390000313652d+0*t137*t23*t62
     :         )+1.0d+0*rhoa*t127*t89+1.0d+0*rhoa*t19*(-t21*t63*t73-t23*
     ;         t73+t21*t23*(-t21*t63*t72-t23*t72+t21*t23*(-t21*t63*t71-t
     <         23*t71+t21*t23*(-t21*t63*t70-t23*t70+t21*t23*(-t21*t63*t6
     =         9-t23*t69+t21*t23*(-t21*t63*t68-t23*t68+t21*t23*(-t21*t63
     >         *t67-t23*t67+t21*t23*(-t21*t63*t66-t23*t66+t21*t23*(-t21*
     ?         t63*t65-t23*t65+t21*t23*(-t21*t63*t64-t23*t64-4.785390000
     @         313652d+0*t117*t21*t62*t63+9.570780000627304d+0*t142*t21*
     1         t25*t62+9.570780000627304d+0*t167*t168*t24*t62+4.78539000
     2         0313652d+0*t117*t23*t62)-4.785390000313652d+0*t118*t21*t6
     3         2*t63+9.570780000627304d+0*t142*t21*t26*t62+4.78539000031
     4         3652d+0*t118*t23*t62)-4.785390000313652d+0*t119*t21*t62*t
     5         63+9.570780000627304d+0*t142*t21*t27*t62+4.78539000031365
     6         2d+0*t119*t23*t62)-4.785390000313652d+0*t120*t21*t62*t63+
     7         9.570780000627304d+0*t142*t21*t28*t62+4.785390000313652d+
     8         0*t120*t23*t62)-4.785390000313652d+0*t121*t21*t62*t63+9.5
     9         70780000627304d+0*t142*t21*t29*t62+4.785390000313652d+0*t
     :         121*t23*t62)-4.785390000313652d+0*t122*t21*t62*t63+9.5707
     ;         80000627304d+0*t142*t21*t30*t62+4.785390000313652d+0*t122
     <         *t23*t62)-4.785390000313652d+0*t123*t21*t62*t63+9.5707800
     =         00627304d+0*t142*t21*t31*t62+4.785390000313652d+0*t123*t2
     >         3*t62)-4.785390000313652d+0*t124*t21*t62*t63+9.5707800006
     ?         27304d+0*t142*t21*t32*t62+4.785390000313652d+0*t124*t23*t
     @         62)-4.785390000313652d+0*t125*t21*t62*t63+9.5707800006273
     1         04d+0*t142*t21*t33*t62+4.785390000313652d+0*t125*t23*t62)
     2         -4.785390000313652d+0*t126*t21*t62*t63+9.570780000627304d
     3         +0*t142*t21*t34*t62+4.785390000313652d+0*t126*t23*t62)+1.
     4         5545345434827443d-2*t139*t48+1.0d+0*t127*t19+1.5545345434
     5         827443d-2*rhoa*t101*t113*t139)*wght
            t170 = 1.5545345434827443d-2*rhoa*t101*t116*(t23*(-t21*t23*t
     1         59-t49+t137*t21)+t138)*wght
            t171 = 1.0d+0*(1.5545345434827443d-2*rhoa*t48*(t21*t23*(t21*
     1         t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23
     2         *(t21*t23*(t21*t23*(2*t50*t63+2*t142*t21*t50)+2*t51*t63-2
     3         *t128*t21*t63+2*t142*t21*t51-2*t128*t23)+2*t52*t63-2*t129
     4         *t21*t63+2*t142*t21*t52-2*t129*t23)+2*t53*t63-2*t130*t21*
     5         t63+2*t142*t21*t53-2*t130*t23)+2*t54*t63-2*t131*t21*t63+2
     6         *t142*t21*t54-2*t131*t23)+2*t55*t63-2*t132*t21*t63+2*t142
     7         *t21*t55-2*t132*t23)+2*t56*t63-2*t133*t21*t63+2*t142*t21*
     8         t56-2*t133*t23)+2*t57*t63-2*t134*t21*t63+2*t142*t21*t57-2
     9         *t134*t23)+2*t58*t63-2*t135*t21*t63+2*t142*t21*t58-2*t135
     :         *t23)+2*t59*t63-2*t136*t21*t63+2*t142*t21*t59-2*t136*t23)
     ;         +2*t60*t63-2*t137*t21*t63+2*t142*t21*t60-2*t137*t23)+1.0d
     <         +0*rhoa*t19*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*
     =         (t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(2*t24*t63+2
     >         *t142*t21*t24)+2*t25*t63-2*t117*t21*t63+2*t142*t21*t25-2*
     ?         t117*t23)+2*t26*t63-2*t118*t21*t63+2*t142*t21*t26-2*t118*
     @         t23)+2*t27*t63-2*t119*t21*t63+2*t142*t21*t27-2*t119*t23)+
     1         2*t28*t63-2*t120*t21*t63+2*t142*t21*t28-2*t120*t23)+2*t29
     2         *t63-2*t121*t21*t63+2*t142*t21*t29-2*t121*t23)+2*t30*t63-
     3         2*t122*t21*t63+2*t142*t21*t30-2*t122*t23)+2*t31*t63-2*t12
     4         3*t21*t63+2*t142*t21*t31-2*t123*t23)+2*t32*t63-2*t124*t21
     5         *t63+2*t142*t21*t32-2*t124*t23)+2*t33*t63-2*t125*t21*t63+
     6         2*t142*t21*t33-2*t125*t23)+2*t34*t63-2*t126*t21*t63+2*t14
     7         2*t21*t34-2*t126*t23))*wght
            fnc(iq) = 1.0d+0*(1.5545345434827443d-2*rhoa*t48*t61+1.0d+0*
     1         rhoa*t19*t35)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(1.0d+0*rhoa*t35*t89+1.0d+0*rhoa*t19
     1         *t74+1.5545345434827443d-2*t48*t61+1.5545345434827443d-2*
     2         rhoa*t101*t113*t61+1.5545345434827443d-2*rhoa*t100*t48+1.
     3         0d+0*t19*t35)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.5545345434827443d-2*rhoa*t101*t116*t61*w
     1         ght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = t140+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = t140+Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(1.5545345434827443d-2*rhoa*t48*
     1         (-9.570780000627304d+0*t21*t62*t63*t99+9.570780000627304d
     2         +0*t23*t62*t99+t21*t23*(-9.570780000627304d+0*t21*t62*t63
     3         *t98+9.570780000627304d+0*t23*t62*t98+t21*t23*(-9.5707800
     4         00627304d+0*t21*t62*t63*t97+9.570780000627304d+0*t23*t62*
     5         t97+t21*t23*(-9.570780000627304d+0*t21*t62*t63*t96+9.5707
     6         80000627304d+0*t23*t62*t96+t21*t23*(-9.570780000627304d+0
     7         *t21*t62*t63*t95+9.570780000627304d+0*t23*t62*t95+t21*t23
     8         *(-9.570780000627304d+0*t21*t62*t63*t94+9.570780000627304
     9         d+0*t23*t62*t94+t21*t23*(-9.570780000627304d+0*t21*t62*t6
     :         3*t93+9.570780000627304d+0*t23*t62*t93+t21*t23*(-9.570780
     ;         000627304d+0*t21*t62*t63*t92+9.570780000627304d+0*t23*t62
     <         *t92+t21*t23*(-9.570780000627304d+0*t21*t62*t63*t91+9.570
     =         780000627304d+0*t23*t62*t91+t21*t23*(-9.570780000627304d+
     >         0*t21*t62*t63*t90+9.570780000627304d+0*t23*t62*t90+t21*t2
     ?         3*(-3.190260000209101d+0*t143*t21*t50*t63-4.5799914910203
     @         78d+1*t141*t50*t63+3.190260000209101d+0*t143*t23*t50+4.57
     1         9991491020378d+1*t141*t142*t21*t50)-3.190260000209101d+0*
     2         t143*t21*t51*t63-4.579991491020378d+1*t141*t51*t63+3.1902
     3         60000209101d+0*t143*t23*t51+4.579991491020378d+1*t141*t14
     4         2*t21*t51)-3.190260000209101d+0*t143*t21*t52*t63-4.579991
     5         491020378d+1*t141*t52*t63+3.190260000209101d+0*t143*t23*t
     6         52+4.579991491020378d+1*t141*t142*t21*t52)-3.190260000209
     7         101d+0*t143*t21*t53*t63-4.579991491020378d+1*t141*t53*t63
     8         +3.190260000209101d+0*t143*t23*t53+4.579991491020378d+1*t
     9         141*t142*t21*t53)-3.190260000209101d+0*t143*t21*t54*t63-4
     :         .579991491020378d+1*t141*t54*t63+3.190260000209101d+0*t14
     ;         3*t23*t54+4.579991491020378d+1*t141*t142*t21*t54)-3.19026
     <         0000209101d+0*t143*t21*t55*t63-4.579991491020378d+1*t141*
     =         t55*t63+3.190260000209101d+0*t143*t23*t55+4.5799914910203
     >         78d+1*t141*t142*t21*t55)-3.190260000209101d+0*t143*t21*t5
     ?         6*t63-4.579991491020378d+1*t141*t56*t63+3.190260000209101
     @         d+0*t143*t23*t56+4.579991491020378d+1*t141*t142*t21*t56)-
     1         3.190260000209101d+0*t143*t21*t57*t63-4.579991491020378d+
     2         1*t141*t57*t63+3.190260000209101d+0*t143*t23*t57+4.579991
     3         491020378d+1*t141*t142*t21*t57)-3.190260000209101d+0*t143
     4         *t21*t58*t63-4.579991491020378d+1*t141*t58*t63+3.19026000
     5         0209101d+0*t143*t23*t58+4.579991491020378d+1*t141*t142*t2
     6         1*t58)-3.190260000209101d+0*t143*t21*t59*t63-4.5799914910
     7         20378d+1*t141*t59*t63+3.190260000209101d+0*t143*t23*t59+4
     8         .579991491020378d+1*t141*t142*t21*t59)-3.190260000209101d
     9         +0*t143*t21*t60*t63-4.579991491020378d+1*t141*t60*t63+3.1
     :         90260000209101d+0*t143*t23*t60+4.579991491020378d+1*t141*
     ;         t142*t21*t60)+t101*(1.5545345434827443d-2*rhoa*t61*(-2.16
     <         22114952063792d-1*gammaaa*t108*t37*t42*(-5.61387501053520
     =         6d+1*t102*t109*t110*t111*t38*t89+1.272682049722932d+0*t10
     >         9*t153*t163*t44-3.6362344277798064d-2*t109*t110*t154*t44+
     ?         1.1607717772370736d+3*t155*t156*t43/t39**4.0d+0-3.8692392
     @         57456912d+2*t111*t155*t38*t43+6.014866082716293d+0*t111*t
     1         151*t38*t43+t162+t161+t160+t159+t158+t157)-8.408600259135
     2         923d-2*gammaaa*t103*t154*t42*t46+1.765806054418543d+0*gam
     3         maaa*t114*t153*t42*t46+2.1622114952063792d-1*gammaaa*(t16
     4         2+t161+t160+t159+t158+t157)*t37*t46-1.0090320310963104d+0
     5         *gammaaa*t102*t103*t107*t46+4.3244229904127585d-1*gammaaa
     6         *t112**2*t164*t37*t42+1.0090320310963104d+0*gammaaa*t102*
     7         t103*t108*t112*t42-4.3244229904127585d-1*gammaaa*t107*t10
     8         8*t112*t37)+3.1090690869654886d-2*t113*t61+3.109069086965
     9         4886d-2*rhoa*t100*t113)+2.0d+0*rhoa*t74*t89+2.0d+0*t35*t8
     :         9+2.0d+0*t19*t74+1.0d+0*rhoa*t19*(-9.570780000627304d+0*t
     ;         21*t62*t63*t73+9.570780000627304d+0*t23*t62*t73+t21*t23*(
     <         -9.570780000627304d+0*t21*t62*t63*t72+9.570780000627304d+
     =         0*t23*t62*t72+t21*t23*(-9.570780000627304d+0*t21*t62*t63*
     >         t71+9.570780000627304d+0*t23*t62*t71+t21*t23*(-9.57078000
     ?         0627304d+0*t21*t62*t63*t70+9.570780000627304d+0*t23*t62*t
     @         70+t21*t23*(-9.570780000627304d+0*t21*t62*t63*t69+9.57078
     1         0000627304d+0*t23*t62*t69+t21*t23*(-9.570780000627304d+0*
     2         t21*t62*t63*t68+9.570780000627304d+0*t23*t62*t68+t21*t23*
     3         (-9.570780000627304d+0*t21*t62*t63*t67+9.570780000627304d
     4         +0*t23*t62*t67+t21*t23*(-9.570780000627304d+0*t21*t62*t63
     5         *t66+9.570780000627304d+0*t23*t62*t66+t21*t23*(-9.5707800
     6         00627304d+0*t21*t62*t63*t65+9.570780000627304d+0*t23*t62*
     7         t65+t21*t23*(-9.570780000627304d+0*t21*t62*t63*t64+9.5707
     8         80000627304d+0*t23*t62*t64+t21*t23*(-3.190260000209101d+0
     9         *t143*t21*t24*t63-4.579991491020378d+1*t141*t24*t63+3.190
     :         260000209101d+0*t143*t23*t24+4.579991491020378d+1*t141*t1
     ;         42*t21*t24)-3.190260000209101d+0*t143*t21*t25*t63-4.57999
     <         1491020378d+1*t141*t25*t63+3.190260000209101d+0*t143*t23*
     =         t25+4.579991491020378d+1*t141*t142*t21*t25)-3.19026000020
     >         9101d+0*t143*t21*t26*t63-4.579991491020378d+1*t141*t26*t6
     ?         3+3.190260000209101d+0*t143*t23*t26+4.579991491020378d+1*
     @         t141*t142*t21*t26)-3.190260000209101d+0*t143*t21*t27*t63-
     1         4.579991491020378d+1*t141*t27*t63+3.190260000209101d+0*t1
     2         43*t23*t27+4.579991491020378d+1*t141*t142*t21*t27)-3.1902
     3         60000209101d+0*t143*t21*t28*t63-4.579991491020378d+1*t141
     4         *t28*t63+3.190260000209101d+0*t143*t23*t28+4.579991491020
     5         378d+1*t141*t142*t21*t28)-3.190260000209101d+0*t143*t21*t
     6         29*t63-4.579991491020378d+1*t141*t29*t63+3.19026000020910
     7         1d+0*t143*t23*t29+4.579991491020378d+1*t141*t142*t21*t29)
     8         -3.190260000209101d+0*t143*t21*t30*t63-4.579991491020378d
     9         +1*t141*t30*t63+3.190260000209101d+0*t143*t23*t30+4.57999
     :         1491020378d+1*t141*t142*t21*t30)-3.190260000209101d+0*t14
     ;         3*t21*t31*t63-4.579991491020378d+1*t141*t31*t63+3.1902600
     <         00209101d+0*t143*t23*t31+4.579991491020378d+1*t141*t142*t
     =         21*t31)-3.190260000209101d+0*t143*t21*t32*t63-4.579991491
     >         020378d+1*t141*t32*t63+3.190260000209101d+0*t143*t23*t32+
     ?         4.579991491020378d+1*t141*t142*t21*t32)-3.190260000209101
     @         d+0*t143*t21*t33*t63-4.579991491020378d+1*t141*t33*t63+3.
     1         190260000209101d+0*t143*t23*t33+4.579991491020378d+1*t141
     2         *t142*t21*t33)-3.190260000209101d+0*t143*t21*t34*t63-4.57
     3         9991491020378d+1*t141*t34*t63+3.190260000209101d+0*t143*t
     4         23*t34+4.579991491020378d+1*t141*t142*t21*t34)-1.55453454
     5         34827443d-2*rhoa*t113**2*t152*t61+3.1090690869654886d-2*t
     6         100*t48+1.0d+0*rhoa*t151*t35)*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(t101*(1.5545345434827443d-2*rh
     1         oa*t61*(-2.1622114952063792d-1*gammaaa*t108*t37*t42*(1.20
     2         29732165432584d+1*gammaaa*t111*t114*t38*t89-4.36348131333
     3         5766d-1*gammaaa*t102*t110*t44+t166+t165)-5.04516015548155
     4         2d-1*t102*t103*t42*t46-1.0908703283339415d-1*gammaaa*t102
     5         *t110*t40*t46+2.1622114952063792d-1*gammaaa*(t166+t165)*t
     6         37*t46+2.1622114952063792d-1*t107*t37*t46+4.3244229904127
     7         585d-1*gammaaa*t112*t115*t164*t37*t42-2.1622114952063792d
     8         -1*t108*t112*t37*t42+5.045160155481552d-1*gammaaa*t102*t1
     9         03*t108*t115*t42-4.675158550002606d-2*gammaaa*t108*t112*t
     :         114*t40-2.1622114952063792d-1*gammaaa*t107*t108*t115*t37)
     ;         +1.5545345434827443d-2*t116*t61+1.5545345434827443d-2*rho
     <         a*t100*t116)-1.5545345434827443d-2*rhoa*t113*t116*t152*t6
     =         1)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.5545345434827443d-2*rhoa*t101*(9.35
     1         0317100005212d-2*t114*t40*t46-2.0217363117456047d-2*gamma
     2         aa*t108*t163*t42*t44+4.3244229904127585d-1*gammaaa*t115**
     3         2*t164*t37*t42-4.3244229904127585d-1*t108*t115*t37*t42-9.
     4         350317100005212d-2*gammaaa*t108*t114*t115*t40)*t61*wght-1
     5         .5545345434827443d-2*rhoa*t116**2*t152*t61*wght+Cmat2(iq,
     6         D2_GAA_GAA)
            Mmat2(iq,D2_RA_TA) = t169+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = t169+Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = t170+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = t170+Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_TA_TA) = t171+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = t171+Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = t171+Mmat2(iq,D2_TB_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 9.999999999999991d-1*(6.21814d-2*t17*t18-3.10907d-2*t1
     1         1*t9)-6.21814d-2*t17*t18
            t20 = 2.871234000188191d+0*rhob**1.6666666666666669d+0
            t21 = -taub-taua+t20
            t22 = taub+taua+t20
            t23 = 1/t22
            t24 = param(12)
            t25 = t21*t23*t24+param(11)
            t26 = t21*t23*t25+param(10)
            t27 = t21*t23*t26+param(9)
            t28 = t21*t23*t27+param(8)
            t29 = t21*t23*t28+param(7)
            t30 = t21*t23*t29+param(6)
            t31 = t21*t23*t30+param(5)
            t32 = t21*t23*t31+param(4)
            t33 = t21*t23*t32+param(3)
            t34 = t21*t23*t33+param(2)
            t35 = t21*t23*t34+param(1)
            t36 = rhob**1.1666666666666667d+0
            t37 = 1/t36**2.0d+0
            t38 = exp(-6.432793688582967d+1*t19)
            t39 = t38-1.0d+0
            t40 = 1/t39
            t41 = 2.1622114952063792d-1*gammabb*t37*t40
            t42 = t41+1.0d+0
            t43 = (gammabb*t37)**2.0d+0
            t44 = 1/t39**2.0d+0
            t45 = 4.675158550002606d-2*t43*t44+t41+1.0d+0
            t46 = 1/t45
            t47 = 2.1622114952063792d-1*gammabb*t37*t42*t46+1.0d+0
            t48 = log(t47)
            t49 = param(14)
            t50 = param(24)
            t51 = t21*t23*t50+param(23)
            t52 = t21*t23*t51+param(22)
            t53 = t21*t23*t52+param(21)
            t54 = t21*t23*t53+param(20)
            t55 = t21*t23*t54+param(19)
            t56 = t21*t23*t55+param(18)
            t57 = t21*t23*t56+param(17)
            t58 = t21*t23*t57+param(16)
            t59 = t21*t23*t58+param(15)
            t60 = t21*t23*t59+t49
            t61 = t21*t23*t60+param(13)
            t62 = rhob**6.666666666666666d-1
            t63 = 1/t22**2
            t64 = 4.785390000313652d+0*t23*t24*t62-4.785390000313652d+0*
     1         t21*t24*t62*t63
            t65 = t21*t23*t64-4.785390000313652d+0*t21*t25*t62*t63+4.785
     1         390000313652d+0*t23*t25*t62
            t66 = t21*t23*t65-4.785390000313652d+0*t21*t26*t62*t63+4.785
     1         390000313652d+0*t23*t26*t62
            t67 = t21*t23*t66-4.785390000313652d+0*t21*t27*t62*t63+4.785
     1         390000313652d+0*t23*t27*t62
            t68 = t21*t23*t67-4.785390000313652d+0*t21*t28*t62*t63+4.785
     1         390000313652d+0*t23*t28*t62
            t69 = t21*t23*t68-4.785390000313652d+0*t21*t29*t62*t63+4.785
     1         390000313652d+0*t23*t29*t62
            t70 = t21*t23*t69-4.785390000313652d+0*t21*t30*t62*t63+4.785
     1         390000313652d+0*t23*t30*t62
            t71 = t21*t23*t70-4.785390000313652d+0*t21*t31*t62*t63+4.785
     1         390000313652d+0*t23*t31*t62
            t72 = t21*t23*t71-4.785390000313652d+0*t21*t32*t62*t63+4.785
     1         390000313652d+0*t23*t32*t62
            t73 = t21*t23*t72-4.785390000313652d+0*t21*t33*t62*t63+4.785
     1         390000313652d+0*t23*t33*t62
            t74 = t21*t23*t73-4.785390000313652d+0*t21*t34*t62*t63+4.785
     1         390000313652d+0*t23*t34*t62
            t75 = 1/rhob**1.3333333333333333d+0
            t76 = 1/t8
            t77 = 1/t6**2
            t78 = 1/rhob**1.3333333333333336d+0
            t79 = 1/t2**3
            t80 = 1/rhob**6.666666666666667d-1
            t81 = -1.3127055298329054d-1*t4*t79*t80-2.0096226153166658d-
     1         3*t78
            t82 = 7.876233178997433d-1*t3*t81-1.3127055298329054d-1*t5*t
     1         79*t80
            t83 = 2.11607075208357d-1*t3*t7*t80-1.269642451250142d+0*t2*
     1         t77*t82
            t84 = 1/t16
            t85 = 1/t14**2
            t86 = -1.3127055298329054d-1*t12*t79*t80-3.169132786263567d-
     1         3*t78
            t87 = 7.876233178997433d-1*t3*t86-1.3127055298329054d-1*t13*
     1         t79*t80
            t88 = 2.11607075208357d-1*t15*t3*t80-1.269642451250142d+0*t2
     1         *t85*t87
            t89 = 9.999999999999991d-1*(1.3210398931339265d-3*t75*t9+6.2
     1         1814d-2*t18*t84*t88-3.10907d-2*t11*t76*t83-2.747773264188
     2         438d-3*t17*t75)-6.21814d-2*t18*t84*t88+2.747773264188438d
     3         -3*t17*t75
            t90 = 4.785390000313652d+0*t23*t50*t62-4.785390000313652d+0*
     1         t21*t50*t62*t63
            t91 = t21*t23*t90-4.785390000313652d+0*t21*t51*t62*t63+4.785
     1         390000313652d+0*t23*t51*t62
            t92 = t21*t23*t91-4.785390000313652d+0*t21*t52*t62*t63+4.785
     1         390000313652d+0*t23*t52*t62
            t93 = t21*t23*t92-4.785390000313652d+0*t21*t53*t62*t63+4.785
     1         390000313652d+0*t23*t53*t62
            t94 = t21*t23*t93-4.785390000313652d+0*t21*t54*t62*t63+4.785
     1         390000313652d+0*t23*t54*t62
            t95 = t21*t23*t94-4.785390000313652d+0*t21*t55*t62*t63+4.785
     1         390000313652d+0*t23*t55*t62
            t96 = t21*t23*t95-4.785390000313652d+0*t21*t56*t62*t63+4.785
     1         390000313652d+0*t23*t56*t62
            t97 = t21*t23*t96-4.785390000313652d+0*t21*t57*t62*t63+4.785
     1         390000313652d+0*t23*t57*t62
            t98 = t21*t23*t97-4.785390000313652d+0*t21*t58*t62*t63+4.785
     1         390000313652d+0*t23*t58*t62
            t99 = t21*t23*t98-4.785390000313652d+0*t21*t59*t62*t63+4.785
     1         390000313652d+0*t23*t59*t62
            t100 = t21*t23*t99-4.785390000313652d+0*t21*t60*t62*t63+4.78
     1         5390000313652d+0*t23*t60*t62
            t101 = 1/t47
            t102 = rhob**1.6666666666666674d-1
            t103 = 1/t36**3.0d+0
            t104 = -5.045160155481552d-1*gammabb*t102*t103*t40
            t105 = 1/t39**2
            t106 = 1.3909060459745137d+1*gammabb*t105*t37*t38*t89
            t107 = t106+t104
            t108 = 1/t45**2
            t109 = gammabb**2
            t110 = 1/t36**5.0d+0
            t111 = 1/t39**3.0d+0
            t112 = 6.014866082716293d+0*t111*t38*t43*t89-2.1817406566678
     1         83d-1*t102*t109*t110*t44+t106+t104
            t113 = -5.045160155481552d-1*gammabb*t102*t103*t42*t46+2.162
     1         2114952063792d-1*gammabb*t107*t37*t46-2.1622114952063792d
     2         -1*gammabb*t108*t112*t37*t42
            t114 = 1/t36**4.0d+0
            t115 = 9.350317100005212d-2*gammabb*t114*t44+2.1622114952063
     1         792d-1*t37*t40
            t116 = 2.1622114952063792d-1*t37*t42*t46+4.675158550002606d-
     1         2*gammabb*t114*t40*t46-2.1622114952063792d-1*gammabb*t108
     2         *t115*t37*t42
            t117 = -t21*t24*t63-t23*t24
            t118 = -t21*t25*t63-t23*t25+t117*t21*t23
            t119 = -t21*t26*t63-t23*t26+t118*t21*t23
            t120 = -t21*t27*t63-t23*t27+t119*t21*t23
            t121 = -t21*t28*t63-t23*t28+t120*t21*t23
            t122 = -t21*t29*t63-t23*t29+t121*t21*t23
            t123 = -t21*t30*t63-t23*t30+t122*t21*t23
            t124 = -t21*t31*t63-t23*t31+t123*t21*t23
            t125 = -t21*t32*t63-t23*t32+t124*t21*t23
            t126 = -t21*t33*t63-t23*t33+t125*t21*t23
            t127 = -t21*t34*t63-t23*t34+t126*t21*t23
            t128 = -t21*t50*t63-t23*t50
            t129 = -t21*t51*t63-t23*t51+t128*t21*t23
            t130 = -t21*t52*t63-t23*t52+t129*t21*t23
            t131 = -t21*t53*t63-t23*t53+t130*t21*t23
            t132 = -t21*t54*t63-t23*t54+t131*t21*t23
            t133 = -t21*t55*t63-t23*t55+t132*t21*t23
            t134 = -t21*t56*t63-t23*t56+t133*t21*t23
            t135 = -t21*t57*t63-t23*t57+t134*t21*t23
            t136 = -t21*t58*t63-t23*t58+t135*t21*t23
            t137 = -t21*t59*t63-t23*t59+t136*t21*t23
            t138 = -t21*t60*t63
            t139 = -t23*t60+t137*t21*t23+t138
            t140 = 1.0d+0*(1.5545345434827443d-2*rhob*t139*t48+1.0d+0*rh
     1         ob*t127*t19)*wght
            t141 = rhob**1.3333333333333333d+0
            t142 = 1/t22**3
            t143 = 1/rhob**3.333333333333333d-1
            t144 = 1/rhob**2.333333333333333d+0
            t145 = 1/rhob**2.3333333333333334d+0
            t146 = 1/rhob**1.6666666666666669d+0
            t147 = 1/t2**5
            t148 = 1/t16**2
            t149 = t88**2
            t150 = 2.539284902500284d+0*t2*t87**2/t14**3-4.2321415041671
     1         4d-1*t3*t80*t85*t87-1.269642451250142d+0*t2*t85*(-2.62541
     2         1059665811d-1*t79*t80*t86+7.876233178997433d-1*t3*(8.7513
     3         70198886037d-2*t12*t146*t79+6.563527649164527d-2*t12*t147
     4         *t78+4.753699179395351d-3*t145)+8.751370198886037d-2*t13*
     5         t146*t79+6.563527649164527d-2*t13*t147*t78)-3.52678458680
     6         595d-2*t15*t78*t79-1.4107138347223802d-1*t146*t15*t3
            t151 = 9.999999999999991d-1*(-1.7613865241785687d-3*t144*t9-
     1         5.495546528376876d-3*t75*t84*t88+6.21814d-2*t150*t18*t84+
     2         3.10907d-2*t11*t83**2/t8**2+2.642079786267853d-3*t75*t76*
     3         t83-3.10907d-2*t11*t76*(2.539284902500284d+0*t2*t82**2/t6
     4         **3-4.23214150416714d-1*t3*t77*t80*t82-1.269642451250142d
     5         +0*t2*t77*(-2.625411059665811d-1*t79*t80*t81+7.8762331789
     6         97433d-1*t3*(8.751370198886037d-2*t146*t4*t79+6.563527649
     7         164527d-2*t147*t4*t78+3.0144339229749983d-3*t145)+8.75137
     8         0198886037d-2*t146*t5*t79+6.563527649164527d-2*t147*t5*t7
     9         8)-3.52678458680595d-2*t7*t78*t79-1.4107138347223802d-1*t
     :         146*t3*t7)-6.21814d-2*t148*t149*t18+3.663697685584584d-3*
     ;         t144*t17)+5.495546528376876d-3*t75*t84*t88-6.21814d-2*t15
     <         0*t18*t84+6.21814d-2*t148*t149*t18-3.663697685584584d-3*t
     =         144*t17
            t152 = 1/t47**2
            t153 = rhob**3.333333333333335d-1
            t154 = 1/rhob**8.333333333333333d-1
            t155 = t89**2
            t156 = exp(-1.2865587377165935d+2*t19)
            t157 = 1.7894823267913484d+3*gammabb*t155*t156*t37/t39**3
            t158 = 1.765806054418543d+0*gammabb*t114*t153*t40
            t159 = -8.408600259135923d-2*gammabb*t103*t154*t40
            t160 = -6.490894881214397d+1*gammabb*t102*t103*t105*t38*t89
            t161 = -8.947411633956742d+2*gammabb*t105*t155*t37*t38
            t162 = 1.3909060459745137d+1*gammabb*t105*t151*t37*t38
            t163 = 1/t36**6.0d+0
            t164 = 1/t45**3
            t165 = -5.045160155481552d-1*t102*t103*t40
            t166 = 1.3909060459745137d+1*t105*t37*t38*t89
            t167 = t21**2
            t168 = 1/t22**4
            t169 = 1.0d+0*(1.5545345434827443d-2*rhob*t48*(-t21*t63*t99-
     1         t23*t99+t21*t23*(-t21*t63*t98-t23*t98+t21*t23*(-t21*t63*t
     2         97-t23*t97+t21*t23*(-t21*t63*t96-t23*t96+t21*t23*(-t21*t6
     3         3*t95-t23*t95+t21*t23*(-t21*t63*t94-t23*t94+t21*t23*(-t21
     4         *t63*t93-t23*t93+t21*t23*(-t21*t63*t92-t23*t92+t21*t23*(-
     5         t21*t63*t91-t23*t91+t21*t23*(-t21*t63*t90-t23*t90-4.78539
     6         0000313652d+0*t128*t21*t62*t63+9.570780000627304d+0*t142*
     7         t21*t51*t62+9.570780000627304d+0*t167*t168*t50*t62+4.7853
     8         90000313652d+0*t128*t23*t62)-4.785390000313652d+0*t129*t2
     9         1*t62*t63+9.570780000627304d+0*t142*t21*t52*t62+4.7853900
     :         00313652d+0*t129*t23*t62)-4.785390000313652d+0*t130*t21*t
     ;         62*t63+9.570780000627304d+0*t142*t21*t53*t62+4.7853900003
     <         13652d+0*t130*t23*t62)-4.785390000313652d+0*t131*t21*t62*
     =         t63+9.570780000627304d+0*t142*t21*t54*t62+4.7853900003136
     >         52d+0*t131*t23*t62)-4.785390000313652d+0*t132*t21*t62*t63
     ?         +9.570780000627304d+0*t142*t21*t55*t62+4.785390000313652d
     @         +0*t132*t23*t62)-4.785390000313652d+0*t133*t21*t62*t63+9.
     1         570780000627304d+0*t142*t21*t56*t62+4.785390000313652d+0*
     2         t133*t23*t62)-4.785390000313652d+0*t134*t21*t62*t63+9.570
     3         780000627304d+0*t142*t21*t57*t62+4.785390000313652d+0*t13
     4         4*t23*t62)-4.785390000313652d+0*t135*t21*t62*t63+9.570780
     5         000627304d+0*t142*t21*t58*t62+4.785390000313652d+0*t135*t
     6         23*t62)-4.785390000313652d+0*t136*t21*t62*t63+9.570780000
     7         627304d+0*t142*t21*t59*t62+4.785390000313652d+0*t136*t23*
     8         t62)-4.785390000313652d+0*t137*t21*t62*t63+9.570780000627
     9         304d+0*t142*t21*t60*t62+4.785390000313652d+0*t137*t23*t62
     :         )+1.0d+0*rhob*t127*t89+1.0d+0*rhob*t19*(-t21*t63*t73-t23*
     ;         t73+t21*t23*(-t21*t63*t72-t23*t72+t21*t23*(-t21*t63*t71-t
     <         23*t71+t21*t23*(-t21*t63*t70-t23*t70+t21*t23*(-t21*t63*t6
     =         9-t23*t69+t21*t23*(-t21*t63*t68-t23*t68+t21*t23*(-t21*t63
     >         *t67-t23*t67+t21*t23*(-t21*t63*t66-t23*t66+t21*t23*(-t21*
     ?         t63*t65-t23*t65+t21*t23*(-t21*t63*t64-t23*t64-4.785390000
     @         313652d+0*t117*t21*t62*t63+9.570780000627304d+0*t142*t21*
     1         t25*t62+9.570780000627304d+0*t167*t168*t24*t62+4.78539000
     2         0313652d+0*t117*t23*t62)-4.785390000313652d+0*t118*t21*t6
     3         2*t63+9.570780000627304d+0*t142*t21*t26*t62+4.78539000031
     4         3652d+0*t118*t23*t62)-4.785390000313652d+0*t119*t21*t62*t
     5         63+9.570780000627304d+0*t142*t21*t27*t62+4.78539000031365
     6         2d+0*t119*t23*t62)-4.785390000313652d+0*t120*t21*t62*t63+
     7         9.570780000627304d+0*t142*t21*t28*t62+4.785390000313652d+
     8         0*t120*t23*t62)-4.785390000313652d+0*t121*t21*t62*t63+9.5
     9         70780000627304d+0*t142*t21*t29*t62+4.785390000313652d+0*t
     :         121*t23*t62)-4.785390000313652d+0*t122*t21*t62*t63+9.5707
     ;         80000627304d+0*t142*t21*t30*t62+4.785390000313652d+0*t122
     <         *t23*t62)-4.785390000313652d+0*t123*t21*t62*t63+9.5707800
     =         00627304d+0*t142*t21*t31*t62+4.785390000313652d+0*t123*t2
     >         3*t62)-4.785390000313652d+0*t124*t21*t62*t63+9.5707800006
     ?         27304d+0*t142*t21*t32*t62+4.785390000313652d+0*t124*t23*t
     @         62)-4.785390000313652d+0*t125*t21*t62*t63+9.5707800006273
     1         04d+0*t142*t21*t33*t62+4.785390000313652d+0*t125*t23*t62)
     2         -4.785390000313652d+0*t126*t21*t62*t63+9.570780000627304d
     3         +0*t142*t21*t34*t62+4.785390000313652d+0*t126*t23*t62)+1.
     4         5545345434827443d-2*t139*t48+1.0d+0*t127*t19+1.5545345434
     5         827443d-2*rhob*t101*t113*t139)*wght
            t170 = 1.5545345434827443d-2*rhob*t101*t116*(t23*(-t21*t23*t
     1         59-t49+t137*t21)+t138)*wght
            t171 = 1.0d+0*(1.5545345434827443d-2*rhob*t48*(t21*t23*(t21*
     1         t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23
     2         *(t21*t23*(t21*t23*(2*t50*t63+2*t142*t21*t50)+2*t51*t63-2
     3         *t128*t21*t63+2*t142*t21*t51-2*t128*t23)+2*t52*t63-2*t129
     4         *t21*t63+2*t142*t21*t52-2*t129*t23)+2*t53*t63-2*t130*t21*
     5         t63+2*t142*t21*t53-2*t130*t23)+2*t54*t63-2*t131*t21*t63+2
     6         *t142*t21*t54-2*t131*t23)+2*t55*t63-2*t132*t21*t63+2*t142
     7         *t21*t55-2*t132*t23)+2*t56*t63-2*t133*t21*t63+2*t142*t21*
     8         t56-2*t133*t23)+2*t57*t63-2*t134*t21*t63+2*t142*t21*t57-2
     9         *t134*t23)+2*t58*t63-2*t135*t21*t63+2*t142*t21*t58-2*t135
     :         *t23)+2*t59*t63-2*t136*t21*t63+2*t142*t21*t59-2*t136*t23)
     ;         +2*t60*t63-2*t137*t21*t63+2*t142*t21*t60-2*t137*t23)+1.0d
     <         +0*rhob*t19*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*
     =         (t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(2*t24*t63+2
     >         *t142*t21*t24)+2*t25*t63-2*t117*t21*t63+2*t142*t21*t25-2*
     ?         t117*t23)+2*t26*t63-2*t118*t21*t63+2*t142*t21*t26-2*t118*
     @         t23)+2*t27*t63-2*t119*t21*t63+2*t142*t21*t27-2*t119*t23)+
     1         2*t28*t63-2*t120*t21*t63+2*t142*t21*t28-2*t120*t23)+2*t29
     2         *t63-2*t121*t21*t63+2*t142*t21*t29-2*t121*t23)+2*t30*t63-
     3         2*t122*t21*t63+2*t142*t21*t30-2*t122*t23)+2*t31*t63-2*t12
     4         3*t21*t63+2*t142*t21*t31-2*t123*t23)+2*t32*t63-2*t124*t21
     5         *t63+2*t142*t21*t32-2*t124*t23)+2*t33*t63-2*t125*t21*t63+
     6         2*t142*t21*t33-2*t125*t23)+2*t34*t63-2*t126*t21*t63+2*t14
     7         2*t21*t34-2*t126*t23))*wght
            fnc(iq) = 1.0d+0*(1.5545345434827443d-2*rhob*t48*t61+1.0d+0*
     1         rhob*t19*t35)*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*(1.0d+0*rhob*t35*t89+1.0d+0*rhob*t19
     1         *t74+1.5545345434827443d-2*t48*t61+1.5545345434827443d-2*
     2         rhob*t101*t113*t61+1.5545345434827443d-2*rhob*t100*t48+1.
     3         0d+0*t19*t35)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.5545345434827443d-2*rhob*t101*t116*t61*w
     1         ght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = t140+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = t140+Mmat(iq,D1_TA)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(1.5545345434827443d-2*rhob*t48*
     1         (-9.570780000627304d+0*t21*t62*t63*t99+9.570780000627304d
     2         +0*t23*t62*t99+t21*t23*(-9.570780000627304d+0*t21*t62*t63
     3         *t98+9.570780000627304d+0*t23*t62*t98+t21*t23*(-9.5707800
     4         00627304d+0*t21*t62*t63*t97+9.570780000627304d+0*t23*t62*
     5         t97+t21*t23*(-9.570780000627304d+0*t21*t62*t63*t96+9.5707
     6         80000627304d+0*t23*t62*t96+t21*t23*(-9.570780000627304d+0
     7         *t21*t62*t63*t95+9.570780000627304d+0*t23*t62*t95+t21*t23
     8         *(-9.570780000627304d+0*t21*t62*t63*t94+9.570780000627304
     9         d+0*t23*t62*t94+t21*t23*(-9.570780000627304d+0*t21*t62*t6
     :         3*t93+9.570780000627304d+0*t23*t62*t93+t21*t23*(-9.570780
     ;         000627304d+0*t21*t62*t63*t92+9.570780000627304d+0*t23*t62
     <         *t92+t21*t23*(-9.570780000627304d+0*t21*t62*t63*t91+9.570
     =         780000627304d+0*t23*t62*t91+t21*t23*(-9.570780000627304d+
     >         0*t21*t62*t63*t90+9.570780000627304d+0*t23*t62*t90+t21*t2
     ?         3*(-3.190260000209101d+0*t143*t21*t50*t63-4.5799914910203
     @         78d+1*t141*t50*t63+3.190260000209101d+0*t143*t23*t50+4.57
     1         9991491020378d+1*t141*t142*t21*t50)-3.190260000209101d+0*
     2         t143*t21*t51*t63-4.579991491020378d+1*t141*t51*t63+3.1902
     3         60000209101d+0*t143*t23*t51+4.579991491020378d+1*t141*t14
     4         2*t21*t51)-3.190260000209101d+0*t143*t21*t52*t63-4.579991
     5         491020378d+1*t141*t52*t63+3.190260000209101d+0*t143*t23*t
     6         52+4.579991491020378d+1*t141*t142*t21*t52)-3.190260000209
     7         101d+0*t143*t21*t53*t63-4.579991491020378d+1*t141*t53*t63
     8         +3.190260000209101d+0*t143*t23*t53+4.579991491020378d+1*t
     9         141*t142*t21*t53)-3.190260000209101d+0*t143*t21*t54*t63-4
     :         .579991491020378d+1*t141*t54*t63+3.190260000209101d+0*t14
     ;         3*t23*t54+4.579991491020378d+1*t141*t142*t21*t54)-3.19026
     <         0000209101d+0*t143*t21*t55*t63-4.579991491020378d+1*t141*
     =         t55*t63+3.190260000209101d+0*t143*t23*t55+4.5799914910203
     >         78d+1*t141*t142*t21*t55)-3.190260000209101d+0*t143*t21*t5
     ?         6*t63-4.579991491020378d+1*t141*t56*t63+3.190260000209101
     @         d+0*t143*t23*t56+4.579991491020378d+1*t141*t142*t21*t56)-
     1         3.190260000209101d+0*t143*t21*t57*t63-4.579991491020378d+
     2         1*t141*t57*t63+3.190260000209101d+0*t143*t23*t57+4.579991
     3         491020378d+1*t141*t142*t21*t57)-3.190260000209101d+0*t143
     4         *t21*t58*t63-4.579991491020378d+1*t141*t58*t63+3.19026000
     5         0209101d+0*t143*t23*t58+4.579991491020378d+1*t141*t142*t2
     6         1*t58)-3.190260000209101d+0*t143*t21*t59*t63-4.5799914910
     7         20378d+1*t141*t59*t63+3.190260000209101d+0*t143*t23*t59+4
     8         .579991491020378d+1*t141*t142*t21*t59)-3.190260000209101d
     9         +0*t143*t21*t60*t63-4.579991491020378d+1*t141*t60*t63+3.1
     :         90260000209101d+0*t143*t23*t60+4.579991491020378d+1*t141*
     ;         t142*t21*t60)+t101*(1.5545345434827443d-2*rhob*t61*(-2.16
     <         22114952063792d-1*gammabb*t108*t37*t42*(-5.61387501053520
     =         6d+1*t102*t109*t110*t111*t38*t89+1.272682049722932d+0*t10
     >         9*t153*t163*t44-3.6362344277798064d-2*t109*t110*t154*t44+
     ?         1.1607717772370736d+3*t155*t156*t43/t39**4.0d+0-3.8692392
     @         57456912d+2*t111*t155*t38*t43+6.014866082716293d+0*t111*t
     1         151*t38*t43+t162+t161+t160+t159+t158+t157)-8.408600259135
     2         923d-2*gammabb*t103*t154*t42*t46+1.765806054418543d+0*gam
     3         mabb*t114*t153*t42*t46+2.1622114952063792d-1*gammabb*(t16
     4         2+t161+t160+t159+t158+t157)*t37*t46-1.0090320310963104d+0
     5         *gammabb*t102*t103*t107*t46+4.3244229904127585d-1*gammabb
     6         *t112**2*t164*t37*t42+1.0090320310963104d+0*gammabb*t102*
     7         t103*t108*t112*t42-4.3244229904127585d-1*gammabb*t107*t10
     8         8*t112*t37)+3.1090690869654886d-2*t113*t61+3.109069086965
     9         4886d-2*rhob*t100*t113)+2.0d+0*rhob*t74*t89+2.0d+0*t35*t8
     :         9+2.0d+0*t19*t74+1.0d+0*rhob*t19*(-9.570780000627304d+0*t
     ;         21*t62*t63*t73+9.570780000627304d+0*t23*t62*t73+t21*t23*(
     <         -9.570780000627304d+0*t21*t62*t63*t72+9.570780000627304d+
     =         0*t23*t62*t72+t21*t23*(-9.570780000627304d+0*t21*t62*t63*
     >         t71+9.570780000627304d+0*t23*t62*t71+t21*t23*(-9.57078000
     ?         0627304d+0*t21*t62*t63*t70+9.570780000627304d+0*t23*t62*t
     @         70+t21*t23*(-9.570780000627304d+0*t21*t62*t63*t69+9.57078
     1         0000627304d+0*t23*t62*t69+t21*t23*(-9.570780000627304d+0*
     2         t21*t62*t63*t68+9.570780000627304d+0*t23*t62*t68+t21*t23*
     3         (-9.570780000627304d+0*t21*t62*t63*t67+9.570780000627304d
     4         +0*t23*t62*t67+t21*t23*(-9.570780000627304d+0*t21*t62*t63
     5         *t66+9.570780000627304d+0*t23*t62*t66+t21*t23*(-9.5707800
     6         00627304d+0*t21*t62*t63*t65+9.570780000627304d+0*t23*t62*
     7         t65+t21*t23*(-9.570780000627304d+0*t21*t62*t63*t64+9.5707
     8         80000627304d+0*t23*t62*t64+t21*t23*(-3.190260000209101d+0
     9         *t143*t21*t24*t63-4.579991491020378d+1*t141*t24*t63+3.190
     :         260000209101d+0*t143*t23*t24+4.579991491020378d+1*t141*t1
     ;         42*t21*t24)-3.190260000209101d+0*t143*t21*t25*t63-4.57999
     <         1491020378d+1*t141*t25*t63+3.190260000209101d+0*t143*t23*
     =         t25+4.579991491020378d+1*t141*t142*t21*t25)-3.19026000020
     >         9101d+0*t143*t21*t26*t63-4.579991491020378d+1*t141*t26*t6
     ?         3+3.190260000209101d+0*t143*t23*t26+4.579991491020378d+1*
     @         t141*t142*t21*t26)-3.190260000209101d+0*t143*t21*t27*t63-
     1         4.579991491020378d+1*t141*t27*t63+3.190260000209101d+0*t1
     2         43*t23*t27+4.579991491020378d+1*t141*t142*t21*t27)-3.1902
     3         60000209101d+0*t143*t21*t28*t63-4.579991491020378d+1*t141
     4         *t28*t63+3.190260000209101d+0*t143*t23*t28+4.579991491020
     5         378d+1*t141*t142*t21*t28)-3.190260000209101d+0*t143*t21*t
     6         29*t63-4.579991491020378d+1*t141*t29*t63+3.19026000020910
     7         1d+0*t143*t23*t29+4.579991491020378d+1*t141*t142*t21*t29)
     8         -3.190260000209101d+0*t143*t21*t30*t63-4.579991491020378d
     9         +1*t141*t30*t63+3.190260000209101d+0*t143*t23*t30+4.57999
     :         1491020378d+1*t141*t142*t21*t30)-3.190260000209101d+0*t14
     ;         3*t21*t31*t63-4.579991491020378d+1*t141*t31*t63+3.1902600
     <         00209101d+0*t143*t23*t31+4.579991491020378d+1*t141*t142*t
     =         21*t31)-3.190260000209101d+0*t143*t21*t32*t63-4.579991491
     >         020378d+1*t141*t32*t63+3.190260000209101d+0*t143*t23*t32+
     ?         4.579991491020378d+1*t141*t142*t21*t32)-3.190260000209101
     @         d+0*t143*t21*t33*t63-4.579991491020378d+1*t141*t33*t63+3.
     1         190260000209101d+0*t143*t23*t33+4.579991491020378d+1*t141
     2         *t142*t21*t33)-3.190260000209101d+0*t143*t21*t34*t63-4.57
     3         9991491020378d+1*t141*t34*t63+3.190260000209101d+0*t143*t
     4         23*t34+4.579991491020378d+1*t141*t142*t21*t34)-1.55453454
     5         34827443d-2*rhob*t113**2*t152*t61+3.1090690869654886d-2*t
     6         100*t48+1.0d+0*rhob*t151*t35)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(t101*(1.5545345434827443d-2*rh
     1         ob*t61*(-2.1622114952063792d-1*gammabb*t108*t37*t42*(1.20
     2         29732165432584d+1*gammabb*t111*t114*t38*t89-4.36348131333
     3         5766d-1*gammabb*t102*t110*t44+t166+t165)-5.04516015548155
     4         2d-1*t102*t103*t42*t46-1.0908703283339415d-1*gammabb*t102
     5         *t110*t40*t46+2.1622114952063792d-1*gammabb*(t166+t165)*t
     6         37*t46+2.1622114952063792d-1*t107*t37*t46+4.3244229904127
     7         585d-1*gammabb*t112*t115*t164*t37*t42-2.1622114952063792d
     8         -1*t108*t112*t37*t42+5.045160155481552d-1*gammabb*t102*t1
     9         03*t108*t115*t42-4.675158550002606d-2*gammabb*t108*t112*t
     :         114*t40-2.1622114952063792d-1*gammabb*t107*t108*t115*t37)
     ;         +1.5545345434827443d-2*t116*t61+1.5545345434827443d-2*rho
     <         b*t100*t116)-1.5545345434827443d-2*rhob*t113*t116*t152*t6
     =         1)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.5545345434827443d-2*rhob*t101*(9.35
     1         0317100005212d-2*t114*t40*t46-2.0217363117456047d-2*gamma
     2         bb*t108*t163*t42*t44+4.3244229904127585d-1*gammabb*t115**
     3         2*t164*t37*t42-4.3244229904127585d-1*t108*t115*t37*t42-9.
     4         350317100005212d-2*gammabb*t108*t114*t115*t40)*t61*wght-1
     5         .5545345434827443d-2*rhob*t116**2*t152*t61*wght+Cmat2(iq,
     6         D2_GBB_GBB)
            Mmat2(iq,D2_RB_TA) = t169+Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = t169+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GBB_TA) = t170+Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = t170+Mmat2(iq,D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = t171+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = t171+Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = t171+Mmat2(iq,D2_TB_TB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_m11 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& 0.1325688999052018\,{\it t_3}+1.0\\\\ 
C>   {\it t_5} &=& \sqrt{{\it t_2}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_5}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.02414199311453321\,{\it t_6}
C>    +0.10186556948\right)+0.22308199064\right)+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{10}} &=& 1.0-{\it t_8}\,{\it t_9}\\\\ 
C>   {\it t_{11}} &=& {\it t_8}\,{\it t_9}+1.0\\\\ 
C>   {\it t_{12}} &=& 0.06901399211255826\,{\it t_3}+1.0\\\\ 
C>   {\it t_{13}} &=& \log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01321299881039884
C>    \,{\it t_6}+0.029729725188\right)+0.12236585478\right)
C>    +0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{14}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{11}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{10}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_8}^4\,\left(1.709920934161365\,\left(0.0621814
C>    \,{\it t_4}\,{\it t_7}-0.0310907\,\left(0.1274696188700087
C>    \,{\it t_3}+1.0\right)\,\log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01530901310039024
C>    \,{\it t_6}+0.10465751434\right)+0.19269083139\right)
C>    +0.43896648423}}+1.0\right)\right)-0.0337738\,{\it t_{12}}
C>    \,{\it t_{13}}\right)}\over{{\it t_1}^4}}+0.0337738\,{
C>    \it t_{12}}\,{\it t_{13}}\right)-0.0621814\,{\it t_4}\,{
C>    \it t_7}\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{16}} &=& 2.871234000188191\,{\it t_1}^{{{5}\over{3}}}\\\\ 
C>   {\it t_{17}} &=& -\tau_\beta-\tau_\alpha+{\it t_{16}}\\\\ 
C>   {\it t_{18}} &=& {{1}\over{\tau_\beta+\tau_\alpha+{
C>    \it t_{16}}}}\\\\ 
C>   {\it t_{19}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{20}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{21}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{22}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{23}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{29}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{30}} &=& 0.5\,{\it t_{11}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{10}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{31}} &=& {\it t_{30}}^{3.0}\\\\ 
C>   {\it t_{32}} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{{\it t_{30}}^{2.0}}}\\\\ 
C>   {\it t_{34}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{e^{{{32.16396844291483\,{
C>    \it t_{14}}}\over{{\it t_{31}}}}}}}-1.0\\\\ 
C>   {\it t_{36}} &=& {{0.1362107888567592\,{\it t_{32}}\,{
C>    \it t_{33}}\,{\it t_{34}}}\over{{\it t_{35}}}}\\\\ 
C>   {\it t_{37}} &=& {\it param}\left(13\right)\\\\ 
C>   {\it t_{38}} &=& {\it param}\left(14\right)\\\\ 
C>   {\it t_{39}} &=& {\it param}\left(15\right)\\\\ 
C>   {\it t_{40}} &=& {\it param}\left(16\right)\\\\ 
C>   {\it t_{41}} &=& {\it param}\left(17\right)\\\\ 
C>   {\it t_{42}} &=& {\it param}\left(18\right)\\\\ 
C>   {\it t_{43}} &=& {\it param}\left(19\right)\\\\ 
C>   {\it t_{44}} &=& {\it param}\left(20\right)\\\\ 
C>   {\it t_{45}} &=& {\it param}\left(21\right)\\\\ 
C>   {\it t_{46}} &=& {\it param}\left(22\right)\\\\ 
C>   {\it t_{47}} &=& {\it param}\left(23\right)\\\\ 
C>   {\it t_{48}} &=& {\it param}\left(24\right)\\\\ 
C>   {\it t_{49}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{50}} &=& \sqrt{{\it t_{49}}}\\\\ 
C>   {\it t_{51}} &=& {{1}\over{{\it t_{50}}}}\\\\ 
C>   {\it t_{52}} &=& {{1}\over{{\it t_{49}}}}\\\\ 
C>   {\it t_{53}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{50}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{51}}+0.10186556948\right)
C>    \,{\it t_{51}}+0.22308199064\right)\,{\it t_{51}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{54}} &=& 0.1325688999052018\,{\it t_{52}}+1.0\\\\ 
C>   {\it t_{55}} &=& 0.9999999999999991\,\left(0.0621814\,{
C>    \it t_{53}}\,{\it t_{54}}-0.0310907\,\log 
C>    \left({{1.269642451250142\,{\it t_{50}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{51}}+0.10465751434\right)
C>    \,{\it t_{51}}+0.19269083139\right)\,{\it t_{51}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{52}}+1.0\right)\right)-0.0621814\,{\it t_{53}}\,{
C>    \it t_{54}}\\\\ 
C>   {\it t_{56}} &=& 2.871234000188191\,\rho_s^{{{5}\over{3}}}\\\\ 
C>   {\it t_{57}} &=& -\tau_{\bar s}-\tau_s+{\it t_{56}}\\\\ 
C>   {\it t_{58}} &=& {{1}\over{\tau_{\bar s}+\tau_s+{\it t_{56}}}}\\\\ 
C>   {\it t_{59}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{60}} &=& {{1}\over{e^{64.32793688582967\,{\it t_{55}}}}}
C>    -1.0\\\\ 
C>   {\it t_{61}} &=& {{0.2162211495206379\,{\it t_{59}}\,
C>    \sigma_{ss}}\over{{\it t_{60}}}}\\\\ 
C>   f &=& 1.0\,\left(0.03109069086965489\,{\it t_1}\,{\it t_{31}}
C>    \,\log \left({{0.1362107888567592\,{\it t_{32}}\,{\it t_{33}}
C>    \,{\it t_{34}}\,\left({\it t_{36}}+1.0\right)}
C>    \over{{{0.01855337900098064\,\left({\it t_{32}}\,{
C>    \it t_{34}}\right)^{2.0}}\over{{\it t_{30}}^{4.0}\,{
C>    \it t_{35}}^{2.0}}}+{\it t_{36}}+1.0}}+1.0\right)\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{48}}\,{\it t_{17}}\,{\it t_{18}}+{\it t_{47}}\right)
C>    +{\it t_{46}}\right)+{\it t_{45}}\right)+{\it t_{44}}\right)
C>    +{\it t_{43}}\right)+{\it t_{42}}\right)+{\it t_{41}}\right)
C>    +{\it t_{40}}\right)+{\it t_{39}}\right)+{\it t_{38}}\right)
C>    +{\it t_{37}}\right)+1.0\,{\it t_1}\,{\it t_{14}}\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}
C>    \,\left({\it t_{17}}\,{\it t_{18}}\,\left({\it t_{17}}\,{
C>    \it t_{18}}\,\left({\it t_{17}}\,{\it t_{18}}\,\left({
C>    \it t_{29}}\,{\it t_{17}}\,{\it t_{18}}+{\it t_{28}}\right)
C>    +{\it t_{27}}\right)+{\it t_{26}}\right)+{\it t_{25}}\right)
C>    +{\it t_{24}}\right)+{\it t_{23}}\right)+{\it t_{22}}\right)
C>    +{\it t_{21}}\right)+{\it t_{20}}\right)+{\it t_{19}}\right)
C>    +{\it t_{15}}\right)\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.01554534543482744\,\rho_s\,\log 
C>    \left({{0.2162211495206379\,{\it t_{59}}\,\sigma_{ss}\,
C>    \left({\it t_{61}}+1.0\right)}\over{{{0.04675158550002606
C>    \,\left({\it t_{59}}\,\sigma_{ss}\right)^{2.0}}\over{{
C>    \it t_{60}}^{2.0}}}+{\it t_{61}}+1.0}}+1.0\right)\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{48}}\,{\it t_{57}}\,{\it t_{58}}+{\it t_{47}}\right)
C>    +{\it t_{46}}\right)+{\it t_{45}}\right)+{\it t_{44}}\right)
C>    +{\it t_{43}}\right)+{\it t_{42}}\right)+{\it t_{41}}\right)
C>    +{\it t_{40}}\right)+{\it t_{39}}\right)+{\it t_{38}}\right)
C>    +{\it t_{37}}\right)+1.0\,{\it t_{55}}\,\rho_s\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}
C>    \,\left({\it t_{57}}\,{\it t_{58}}\,\left({\it t_{57}}\,{
C>    \it t_{58}}\,\left({\it t_{57}}\,{\it t_{58}}\,\left({
C>    \it t_{29}}\,{\it t_{57}}\,{\it t_{58}}+{\it t_{28}}\right)
C>    +{\it t_{27}}\right)+{\it t_{26}}\right)+{\it t_{25}}\right)
C>    +{\it t_{24}}\right)+{\it t_{23}}\right)+{\it t_{22}}\right)
C>    +{\it t_{21}}\right)+{\it t_{20}}\right)+{\it t_{19}}\right)
C>    +{\it t_{15}}\right)\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] R Peverati, DG Truhlar, J.Phys.Chem.Lett. 2, 2810 (2011)  , DOI: 
C> <a href="https://doi.org/10.1021/jz201170d "> 
C> 10.1021/jz201170d </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_m11_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3*(
     1         7.016926042943223d-1*(2.150807071909054d-2*t3+1.018655694
     2         8d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
            t5 = 1/t1
            t6 = 1.0522000558389215d-1*t5+1.0d+0
            t7 = 9.115599744691192d+0*rhoa**1.6666666666666669d+0
            t8 = t7-2*taua
            t9 = 2*taua+t7
            t10 = 1/t9
            t11 = param(12)
            t12 = t10*t11*t8+param(11)
            t13 = t10*t12*t8+param(10)
            t14 = t10*t13*t8+param(9)
            t15 = t10*t14*t8+param(8)
            t16 = t10*t15*t8+param(7)
            t17 = t10*t16*t8+param(6)
            t18 = t10*t17*t8+param(5)
            t19 = t10*t18*t8+param(4)
            t20 = t10*t19*t8+param(3)
            t21 = t10*t20*t8+param(2)
            t22 = t10*t21*t8+param(1)
            t23 = rhoa**1.1666666666666667d+0
            t24 = 1/t23**2.0d+0
            t25 = exp(2.0000005873362642d+0*t4*t6)-1.0d+0
            t26 = 1.0811057476031892d-1*gammaaa*t24/t25
            t27 = (gammaaa*t24)**2.0d+0
            t28 = param(14)
            t29 = param(24)
            t30 = t10*t29*t8+param(23)
            t31 = t10*t30*t8+param(22)
            t32 = t10*t31*t8+param(21)
            t33 = t10*t32*t8+param(20)
            t34 = t10*t33*t8+param(19)
            t35 = t10*t34*t8+param(18)
            t36 = t10*t35*t8+param(17)
            t37 = t10*t36*t8+param(16)
            t38 = t10*t37*t8+param(15)
            t39 = t10*t38*t8+t28
            t40 = t10*t39*t8+param(13)
            t41 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t42 = 7.016926042943222d-1*t3*t41+2.2308199064d-1
            t43 = 7.016926042943222d-1*t3*t42+4.7231125998d-1
            t44 = 1/t43
            t45 = 1.425125466450768d+0*t2*t44+1.0d+0
            t46 = log(t45)
            t47 = 1.0522000558389213d-1*t5+1.0d+0
            t48 = 1.5874010519681994d+0
            t49 = rhoa**6.666666666666666d-1
            t50 = 1/t9**2
            t51 = 4.785390000313652d+0*t10*t11*t48*t49-4.785390000313652
     1         d+0*t11*t48*t49*t50*t8
            t52 = t10*t51*t8-4.785390000313652d+0*t12*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t12*t48*t49
            t53 = t10*t52*t8-4.785390000313652d+0*t13*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t13*t48*t49
            t54 = t10*t53*t8-4.785390000313652d+0*t14*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t14*t48*t49
            t55 = t10*t54*t8-4.785390000313652d+0*t15*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t15*t48*t49
            t56 = t10*t55*t8-4.785390000313652d+0*t16*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t16*t48*t49
            t57 = t10*t56*t8-4.785390000313652d+0*t17*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t17*t48*t49
            t58 = t10*t57*t8-4.785390000313652d+0*t18*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t18*t48*t49
            t59 = t10*t58*t8-4.785390000313652d+0*t19*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t19*t48*t49
            t60 = t10*t59*t8-4.785390000313652d+0*t20*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t20*t48*t49
            t61 = t10*t60*t8-4.785390000313652d+0*t21*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t21*t48*t49
            t62 = 1/rhoa**1.3333333333333333d+0
            t63 = 1/t45
            t64 = 1/t43**2
            t65 = 1/rhoa**1.3333333333333336d+0
            t66 = 1/t2**3
            t67 = 1/rhoa**6.666666666666667d-1
            t68 = -5.847438369119352d-2*t41*t66*t67-1.2576711796854242d-
     1         3*t65
            t69 = 7.016926042943222d-1*t3*t68-5.847438369119352d-2*t42*t
     1         66*t67
            t70 = 1.1876045553756398d-1*t3*t44*t67-1.425125466450768d+0*
     1         t2*t64*t69
            t71 = 1.090454542535705d-3*t46*t62-6.21814d-2*t47*t63*t70
            t72 = exp(2.0000005873362642d+0*t46*t47)
            t73 = t72-1.0d+0
            t74 = 1/t73
            t75 = 1.0811057476031893d-1*gammaaa*t24*t74
            t76 = t75+1.0d+0
            t77 = 1/t73**2.0d+0
            t78 = 1.168789637500651d-2*t27*t77+t75+1.0d+0
            t79 = 1/t78
            t80 = 1.0811057476031893d-1*gammaaa*t24*t76*t79+1.0d+0
            t81 = log(t80)
            t82 = 4.785390000313652d+0*t10*t29*t48*t49-4.785390000313652
     1         d+0*t29*t48*t49*t50*t8
            t83 = t10*t8*t82-4.785390000313652d+0*t30*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t30*t48*t49
            t84 = t10*t8*t83-4.785390000313652d+0*t31*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t31*t48*t49
            t85 = t10*t8*t84-4.785390000313652d+0*t32*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t32*t48*t49
            t86 = t10*t8*t85-4.785390000313652d+0*t33*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t33*t48*t49
            t87 = t10*t8*t86-4.785390000313652d+0*t34*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t34*t48*t49
            t88 = t10*t8*t87-4.785390000313652d+0*t35*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t35*t48*t49
            t89 = t10*t8*t88-4.785390000313652d+0*t36*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t36*t48*t49
            t90 = t10*t8*t89-4.785390000313652d+0*t37*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t37*t48*t49
            t91 = t10*t8*t90-4.785390000313652d+0*t38*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t38*t48*t49
            t92 = t10*t8*t91-4.785390000313652d+0*t39*t48*t49*t50*t8+4.7
     1         85390000313652d+0*t10*t39*t48*t49
            t93 = 1/t80
            t94 = rhoa**1.6666666666666674d-1
            t95 = 1/t23**3.0d+0
            t96 = -1.2612900388703877d-1*gammaaa*t74*t94*t95
            t97 = 1/t73**2
            t98 = 3.4772651149362827d+0*gammaaa*t24*t71*t72*t97
            t99 = t98+t96
            t100 = 1/t78**2
            t101 = gammaaa**2
            t102 = 1/t23**5.0d+0
            t103 = 1/t73**3.0d+0
            t104 = t98+t96-2.727175820834852d-2*t101*t102*t77*t94+7.5185
     1         82603395361d-1*t103*t27*t71*t72
            t105 = 1.0811057476031893d-1*gammaaa*t24*t79*t99-1.261290038
     1         8703877d-1*gammaaa*t76*t79*t94*t95-1.0811057476031893d-1*
     2         gammaaa*t100*t104*t24*t76
            t106 = 1/t23**4.0d+0
            t107 = 5.843948187503255d-3*gammaaa*t106*t77+2.7027643690079
     1         733d-2*t24*t74
            t108 = 2.7027643690079733d-2*t24*t76*t79+2.9219740937516275d
     1         -3*gammaaa*t106*t74*t79-1.0811057476031893d-1*gammaaa*t10
     2         0*t107*t24*t76
            t109 = 1.168789637500651d-2*gammaaa*t106*t77+5.4055287380159
     1         47d-2*t24*t74
            t110 = 5.405528738015947d-2*t24*t76*t79+5.843948187503255d-3
     1         *gammaaa*t106*t74*t79-1.0811057476031893d-1*gammaaa*t100*
     2         t109*t24*t76
            t111 = -t11*t50*t8-t10*t11
            t112 = -t12*t50*t8+t10*t111*t8-t10*t12
            t113 = -t13*t50*t8+t10*t112*t8-t10*t13
            t114 = -t14*t50*t8+t10*t113*t8-t10*t14
            t115 = -t15*t50*t8+t10*t114*t8-t10*t15
            t116 = -t16*t50*t8+t10*t115*t8-t10*t16
            t117 = -t17*t50*t8+t10*t116*t8-t10*t17
            t118 = -t18*t50*t8+t10*t117*t8-t10*t18
            t119 = -t19*t50*t8+t10*t118*t8-t10*t19
            t120 = -t20*t50*t8+t10*t119*t8-t10*t20
            t121 = -t21*t50*t8+t10*t120*t8-t10*t21
            t122 = -t29*t50*t8-t10*t29
            t123 = -t30*t50*t8+t10*t122*t8-t10*t30
            t124 = -t31*t50*t8+t10*t123*t8-t10*t31
            t125 = -t32*t50*t8+t10*t124*t8-t10*t32
            t126 = -t33*t50*t8+t10*t125*t8-t10*t33
            t127 = -t34*t50*t8+t10*t126*t8-t10*t34
            t128 = -t35*t50*t8+t10*t127*t8-t10*t35
            t129 = -t36*t50*t8+t10*t128*t8-t10*t36
            t130 = -t37*t50*t8+t10*t129*t8-t10*t37
            t131 = -t38*t50*t8+t10*t130*t8-t10*t38
            t132 = -t39*t50*t8
            t133 = t10*t131*t8-t10*t39+t132
            t134 = 2.519842099789746d+0
            t135 = rhoa**1.3333333333333333d+0
            t136 = 1/t9**3
            t137 = 1.2599210498948732d+0
            t138 = 1/t137
            t139 = rhoa**3.333333333333333d-1
            t140 = 1/t139
            t141 = -3.190260000209101d+0*t11*t138*t140*t50*t8+4.57999149
     1         1020378d+1*t11*t134*t135*t136*t8-4.579991491020378d+1*t11
     2         *t134*t135*t50+3.190260000209101d+0*t10*t11*t138*t140
            t142 = -9.570780000627304d+0*t48*t49*t50*t51*t8-3.1902600002
     1         09101d+0*t12*t138*t140*t50*t8+t10*t141*t8+4.5799914910203
     2         78d+1*t12*t134*t135*t136*t8+9.570780000627304d+0*t10*t48*
     3         t49*t51-4.579991491020378d+1*t12*t134*t135*t50+3.19026000
     4         0209101d+0*t10*t12*t138*t140
            t143 = -9.570780000627304d+0*t48*t49*t50*t52*t8-3.1902600002
     1         09101d+0*t13*t138*t140*t50*t8+t10*t142*t8+4.5799914910203
     2         78d+1*t13*t134*t135*t136*t8+9.570780000627304d+0*t10*t48*
     3         t49*t52-4.579991491020378d+1*t13*t134*t135*t50+3.19026000
     4         0209101d+0*t10*t13*t138*t140
            t144 = -9.570780000627304d+0*t48*t49*t50*t53*t8-3.1902600002
     1         09101d+0*t138*t14*t140*t50*t8+t10*t143*t8+4.5799914910203
     2         78d+1*t134*t135*t136*t14*t8+9.570780000627304d+0*t10*t48*
     3         t49*t53-4.579991491020378d+1*t134*t135*t14*t50+3.19026000
     4         0209101d+0*t10*t138*t14*t140
            t145 = -9.570780000627304d+0*t48*t49*t50*t54*t8-3.1902600002
     1         09101d+0*t138*t140*t15*t50*t8+4.579991491020378d+1*t134*t
     2         135*t136*t15*t8+t10*t144*t8+9.570780000627304d+0*t10*t48*
     3         t49*t54-4.579991491020378d+1*t134*t135*t15*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t15
            t146 = -9.570780000627304d+0*t48*t49*t50*t55*t8-3.1902600002
     1         09101d+0*t138*t140*t16*t50*t8+4.579991491020378d+1*t134*t
     2         135*t136*t16*t8+t10*t145*t8+9.570780000627304d+0*t10*t48*
     3         t49*t55-4.579991491020378d+1*t134*t135*t16*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t16
            t147 = -9.570780000627304d+0*t48*t49*t50*t56*t8-3.1902600002
     1         09101d+0*t138*t140*t17*t50*t8+4.579991491020378d+1*t134*t
     2         135*t136*t17*t8+t10*t146*t8+9.570780000627304d+0*t10*t48*
     3         t49*t56-4.579991491020378d+1*t134*t135*t17*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t17
            t148 = -9.570780000627304d+0*t48*t49*t50*t57*t8-3.1902600002
     1         09101d+0*t138*t140*t18*t50*t8+4.579991491020378d+1*t134*t
     2         135*t136*t18*t8+t10*t147*t8+9.570780000627304d+0*t10*t48*
     3         t49*t57-4.579991491020378d+1*t134*t135*t18*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t18
            t149 = -9.570780000627304d+0*t48*t49*t50*t58*t8-3.1902600002
     1         09101d+0*t138*t140*t19*t50*t8+4.579991491020378d+1*t134*t
     2         135*t136*t19*t8+t10*t148*t8+9.570780000627304d+0*t10*t48*
     3         t49*t58-4.579991491020378d+1*t134*t135*t19*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t19
            t150 = -9.570780000627304d+0*t48*t49*t50*t59*t8-3.1902600002
     1         09101d+0*t138*t140*t20*t50*t8+4.579991491020378d+1*t134*t
     2         135*t136*t20*t8+t10*t149*t8+9.570780000627304d+0*t10*t48*
     3         t49*t59-4.579991491020378d+1*t134*t135*t20*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t20
            t151 = -9.570780000627304d+0*t48*t49*t50*t60*t8-3.1902600002
     1         09101d+0*t138*t140*t21*t50*t8+4.579991491020378d+1*t134*t
     2         135*t136*t21*t8+t10*t150*t8+9.570780000627304d+0*t10*t48*
     3         t49*t60-4.579991491020378d+1*t134*t135*t21*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t21
            t152 = -1.243628d-1*rhoa*t151*t46*t47
            t153 = -1.243628d-1*t46*t47*t61
            t154 = 4.0d+0*rhoa*t61*t71
            t155 = 2.0d+0*t22*t71
            t156 = 1/rhoa**2.333333333333333d+0
            t157 = -7.269696950238034d-4*t156*t46
            t158 = 1.1771443702974158d-2*t3+2.9729725188d-2
            t159 = 7.016926042943222d-1*t158*t3+1.2236585478d-1
            t160 = 7.016926042943222d-1*t159*t3+3.497952466d-1
            t161 = 1/t160
            t162 = 1.425125466450768d+0*t161*t2+1.0d+0
            t163 = log(t162)
            t164 = 5.477644184000001d-2*t5+1.0d+0
            t165 = rhoa**2
            t166 = 1/t165
            t167 = 2.18090908507141d-3*t62*t63*t70
            t168 = 1/t45**2
            t169 = t70**2
            t170 = 6.21814d-2*t168*t169*t47
            t171 = 1/t43**3
            t172 = t69**2
            t173 = 1/rhoa**2.3333333333333334d+0
            t174 = 1/rhoa**1.6666666666666669d+0
            t175 = 1/t2**5
            t176 = 1.949146123039784d-2*t174*t41*t66+1.4618595922798375d
     1         -2*t175*t41*t65+9.432533847640683d-4*t173
            t177 = -1.1694876738238703d-1*t66*t67*t68+1.949146123039784d
     1         -2*t174*t42*t66+1.4618595922798375d-2*t175*t42*t65+7.0169
     2         26042943222d-1*t176*t3
            t178 = -2.3752091107512796d-1*t3*t64*t67*t69-9.8967046281303
     1         28d-3*t44*t65*t66-1.425125466450768d+0*t177*t2*t64-3.9586
     2         818512521327d-2*t174*t3*t44+2.850250932901536d+0*t171*t17
     3         2*t2
            t179 = -6.21814d-2*t178*t47*t63
            t180 = t179+t170+t167+8.443450000000001d-3*t163*t164*t166+t1
     1         57
            t181 = -3.190260000209101d+0*t138*t140*t29*t50*t8+4.57999149
     1         1020378d+1*t134*t135*t136*t29*t8-4.579991491020378d+1*t13
     2         4*t135*t29*t50+3.190260000209101d+0*t10*t138*t140*t29
            t182 = -9.570780000627304d+0*t48*t49*t50*t8*t82+9.5707800006
     1         27304d+0*t10*t48*t49*t82-3.190260000209101d+0*t138*t140*t
     2         30*t50*t8+4.579991491020378d+1*t134*t135*t136*t30*t8+t10*
     3         t181*t8-4.579991491020378d+1*t134*t135*t30*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t30
            t183 = -9.570780000627304d+0*t48*t49*t50*t8*t83+9.5707800006
     1         27304d+0*t10*t48*t49*t83-3.190260000209101d+0*t138*t140*t
     2         31*t50*t8+4.579991491020378d+1*t134*t135*t136*t31*t8+t10*
     3         t182*t8-4.579991491020378d+1*t134*t135*t31*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t31
            t184 = -9.570780000627304d+0*t48*t49*t50*t8*t84+9.5707800006
     1         27304d+0*t10*t48*t49*t84-3.190260000209101d+0*t138*t140*t
     2         32*t50*t8+4.579991491020378d+1*t134*t135*t136*t32*t8+t10*
     3         t183*t8-4.579991491020378d+1*t134*t135*t32*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t32
            t185 = -9.570780000627304d+0*t48*t49*t50*t8*t85+9.5707800006
     1         27304d+0*t10*t48*t49*t85-3.190260000209101d+0*t138*t140*t
     2         33*t50*t8+4.579991491020378d+1*t134*t135*t136*t33*t8+t10*
     3         t184*t8-4.579991491020378d+1*t134*t135*t33*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t33
            t186 = -9.570780000627304d+0*t48*t49*t50*t8*t86+9.5707800006
     1         27304d+0*t10*t48*t49*t86-3.190260000209101d+0*t138*t140*t
     2         34*t50*t8+4.579991491020378d+1*t134*t135*t136*t34*t8+t10*
     3         t185*t8-4.579991491020378d+1*t134*t135*t34*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t34
            t187 = -9.570780000627304d+0*t48*t49*t50*t8*t87+9.5707800006
     1         27304d+0*t10*t48*t49*t87-3.190260000209101d+0*t138*t140*t
     2         35*t50*t8+4.579991491020378d+1*t134*t135*t136*t35*t8+t10*
     3         t186*t8-4.579991491020378d+1*t134*t135*t35*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t35
            t188 = -9.570780000627304d+0*t48*t49*t50*t8*t88+9.5707800006
     1         27304d+0*t10*t48*t49*t88-3.190260000209101d+0*t138*t140*t
     2         36*t50*t8+4.579991491020378d+1*t134*t135*t136*t36*t8+t10*
     3         t187*t8-4.579991491020378d+1*t134*t135*t36*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t36
            t189 = -9.570780000627304d+0*t48*t49*t50*t8*t89+9.5707800006
     1         27304d+0*t10*t48*t49*t89-3.190260000209101d+0*t138*t140*t
     2         37*t50*t8+4.579991491020378d+1*t134*t135*t136*t37*t8+t10*
     3         t188*t8-4.579991491020378d+1*t134*t135*t37*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t37
            t190 = -9.570780000627304d+0*t48*t49*t50*t8*t90+9.5707800006
     1         27304d+0*t10*t48*t49*t90-3.190260000209101d+0*t138*t140*t
     2         38*t50*t8+4.579991491020378d+1*t134*t135*t136*t38*t8+t10*
     3         t189*t8-4.579991491020378d+1*t134*t135*t38*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t38
            t191 = -9.570780000627304d+0*t48*t49*t50*t8*t91+9.5707800006
     1         27304d+0*t10*t48*t49*t91-3.190260000209101d+0*t138*t140*t
     2         39*t50*t8+4.579991491020378d+1*t134*t135*t136*t39*t8+t10*
     3         t190*t8-4.579991491020378d+1*t134*t135*t39*t50+3.19026000
     4         0209101d+0*t10*t138*t140*t39
            t192 = 6.218138173930978d-2*rhoa*t191*t81
            t193 = 6.218138173930978d-2*t81*t92
            t194 = 1/t80**2
            t195 = t105**2
            t196 = -6.218138173930978d-2*rhoa*t194*t195*t40
            t197 = 1/rhoa
            t198 = 1.2436276347861956d-1*rhoa*t105*t92
            t199 = 6.218138173930978d-2*t105*t40
            t200 = rhoa**3.333333333333335d-1
            t201 = 2.2072575680231782d-1*gammaaa*t106*t200*t76*t79
            t202 = 1/rhoa**8.333333333333333d-1
            t203 = -1.0510750323919903d-2*gammaaa*t202*t76*t79*t95
            t204 = -2.5225800777407753d-1*gammaaa*t79*t94*t95*t99
            t205 = 2.5225800777407753d-1*gammaaa*t100*t104*t76*t94*t95
            t206 = -2.1622114952063787d-1*gammaaa*t100*t104*t24*t99
            t207 = 1/t78**3
            t208 = t104**2
            t209 = 2.1622114952063787d-1*gammaaa*t207*t208*t24*t76
            t210 = 2.2072575680231782d-1*gammaaa*t106*t200*t74
            t211 = -1.0510750323919903d-2*gammaaa*t202*t74*t95
            t212 = 1.2012286084479878d-2*gammaaa*t166*t24*t74
            t213 = -8.113618601517993d+0*gammaaa*t71*t72*t94*t95*t97
            t214 = t71**2
            t215 = -1.118426454244592d+2*gammaaa*t214*t24*t72*t97
            t216 = 3.3333343122271053d-1*t166*t46*t47-3.216396844291483d
     1         +1*t180
            t217 = -1.0811057476031893d-1*gammaaa*t216*t24*t72*t97
            t218 = 1/t73**3
            t219 = exp(4.0000011746725284d+0*t46*t47)
            t220 = 2.236852908489184d+2*gammaaa*t214*t218*t219*t24
            t221 = t220+t217+t215+t213+t212+t211+t210
            t222 = 1/t23**6.0d+0
            t223 = 7.95426281076832d-2*t101*t200*t222*t77
            t224 = -2.2726465173623778d-3*t101*t102*t202*t77
            t225 = -3.508671881584501d+0*t101*t102*t103*t71*t72*t94
            t226 = 1/t73**4.0d+0
            t227 = 7.254823607731703d+1*t214*t219*t226*t27
            t228 = 2.597310305557001d-3*t166*t27*t77-2.337579275001302d-
     1         2*t103*t216*t27*t72-2.4182745359105678d+1*t103*t214*t27*t
     2         72+t227+t225+t224+t223+t220+t217+t215+t213+t212+t211+t210
            t229 = 1.2012286084479878d-2*gammaaa*t166*t24*t76*t79+1.0811
     1         057476031893d-1*gammaaa*t221*t24*t79-1.0811057476031893d-
     2         1*gammaaa*t100*t228*t24*t76+t209+t206+t205+t204+t203+t201
            t230 = 6.218138173930978d-2*rhoa*t229*t40+t199+t198
            t231 = t179+t170+t167-8.44345d-3*t163*t164*t166+t157
            t232 = -1.201228608447988d-2*gammaaa*t166*t24*t74
            t233 = -1.1184264542445921d+2*gammaaa*t214*t24*t72*t97
            t234 = -3.3333343122271064d-1*t166*t46*t47-3.216396844291483
     1         d+1*t231
            t235 = -1.0811057476031893d-1*gammaaa*t234*t24*t72*t97
            t236 = 2.2368529084891842d+2*gammaaa*t214*t218*t219*t24
            t237 = t236+t235+t233+t232+t213+t211+t210
            t238 = -2.5973103055570024d-3*t166*t27*t77-2.337579275001302
     1         d-2*t103*t234*t27*t72-2.418274535910568d+1*t103*t214*t27*
     2         t72+t236+t235+t233+t232+t227+t225+t224+t223+t213+t211+t21
     3         0
            t239 = -1.201228608447988d-2*gammaaa*t166*t24*t76*t79+1.0811
     1         057476031893d-1*gammaaa*t237*t24*t79-1.0811057476031893d-
     2         1*gammaaa*t100*t238*t24*t76+t209+t206+t205+t204+t203+t201
            t240 = 6.218138173930978d-2*rhoa*t239*t40+t199+t198
            t241 = -3.153225097175969d-2*t74*t94*t95
            t242 = 8.693162787340707d-1*t24*t71*t72*t97
            t243 = t242+t241
            t244 = -1.363587910417426d-2*gammaaa*t102*t77*t94+3.75929130
     1         16976803d-1*gammaaa*t103*t106*t71*t72+t242+t241
            t245 = 2.7027643690079733d-2*t24*t79*t99-1.0811057476031893d
     1         -1*gammaaa*t100*t107*t24*t99-3.153225097175969d-2*t76*t79
     2         *t94*t95+1.2612900388703877d-1*gammaaa*t100*t107*t76*t94*
     3         t95-3.408969776043566d-3*gammaaa*t102*t74*t79*t94+1.08110
     4         57476031893d-1*gammaaa*t24*t243*t79-1.0811057476031893d-1
     5         *gammaaa*t100*t24*t244*t76+2.1622114952063787d-1*gammaaa*
     6         t104*t107*t207*t24*t76-2.7027643690079733d-2*t100*t104*t2
     7         4*t76-2.9219740937516275d-3*gammaaa*t100*t104*t106*t74
            t246 = 6.218138173930978d-2*rhoa*t108*t92+6.218138173930978d
     1         -2*rhoa*t245*t40+3.109069086965489d-2*t108*t40
            t247 = 1.0d+0*(t246*t93-6.218138173930978d-2*rhoa*t105*t108*
     1         t194*t40)*wght
            t248 = -6.306450194351938d-2*t74*t94*t95
            t249 = 1.7386325574681413d+0*t24*t71*t72*t97
            t250 = t249+t248
            t251 = -2.727175820834852d-2*gammaaa*t102*t77*t94+7.51858260
     1         3395361d-1*gammaaa*t103*t106*t71*t72+t249+t248
            t252 = 5.405528738015947d-2*t24*t79*t99-1.0811057476031893d-
     1         1*gammaaa*t100*t109*t24*t99-6.306450194351938d-2*t76*t79*
     2         t94*t95+1.2612900388703877d-1*gammaaa*t100*t109*t76*t94*t
     3         95-6.817939552087132d-3*gammaaa*t102*t74*t79*t94+1.081105
     4         7476031893d-1*gammaaa*t24*t250*t79-1.0811057476031893d-1*
     5         gammaaa*t100*t24*t251*t76+2.1622114952063787d-1*gammaaa*t
     6         104*t109*t207*t24*t76-5.405528738015947d-2*t100*t104*t24*
     7         t76-5.843948187503255d-3*gammaaa*t100*t104*t106*t74
            t253 = 6.218138173930978d-2*rhoa*t110*t92+6.218138173930978d
     1         -2*rhoa*t252*t40+3.109069086965489d-2*t110*t40
            t254 = t108**2
            t255 = t107**2
            t256 = -5.405528738015947d-2*t100*t107*t24*t76
            t257 = -5.843948187503255d-3*gammaaa*t100*t106*t107*t74
            t258 = 1.4609870468758138d-3*t106*t74*t79-1.5794814935512527
     1         d-4*gammaaa*t100*t222*t76*t77+2.1622114952063787d-1*gamma
     2         aa*t207*t24*t255*t76+t257+t256
            t259 = 6.218138173930978d-2*rhoa*t258*t40*t93*wght-6.2181381
     1         73930978d-2*rhoa*t194*t254*t40*wght
            t260 = 2.9219740937516275d-3*t106*t74*t79-3.1589629871025054
     1         d-4*gammaaa*t100*t222*t76*t77+2.1622114952063787d-1*gamma
     2         aa*t107*t109*t207*t24*t76-2.7027643690079733d-2*t100*t109
     3         *t24*t76-2.9219740937516275d-3*gammaaa*t100*t106*t109*t74
     4         +t257+t256
            t261 = t110**2
            t262 = t109**2
            t263 = 5.843948187503255d-3*t106*t74*t79-6.317925974205011d-
     1         4*gammaaa*t100*t222*t76*t77+2.1622114952063787d-1*gammaaa
     2         *t207*t24*t262*t76-1.0811057476031893d-1*t100*t109*t24*t7
     3         6-1.168789637500651d-2*gammaaa*t100*t106*t109*t74
            t264 = t8**2
            t265 = 1/t9**4
            t266 = -t50*t51*t8-4.785390000313652d+0*t111*t48*t49*t50*t8+
     1         9.570780000627304d+0*t12*t136*t48*t49*t8-t10*t51+9.570780
     2         000627304d+0*t11*t264*t265*t48*t49+4.785390000313652d+0*t
     3         10*t111*t48*t49
            t267 = -t50*t52*t8-4.785390000313652d+0*t112*t48*t49*t50*t8+
     1         9.570780000627304d+0*t13*t136*t48*t49*t8+t10*t266*t8-t10*
     2         t52+4.785390000313652d+0*t10*t112*t48*t49
            t268 = -t50*t53*t8-4.785390000313652d+0*t113*t48*t49*t50*t8+
     1         9.570780000627304d+0*t136*t14*t48*t49*t8+t10*t267*t8-t10*
     2         t53+4.785390000313652d+0*t10*t113*t48*t49
            t269 = -t50*t54*t8-4.785390000313652d+0*t114*t48*t49*t50*t8+
     1         9.570780000627304d+0*t136*t15*t48*t49*t8+t10*t268*t8-t10*
     2         t54+4.785390000313652d+0*t10*t114*t48*t49
            t270 = -t50*t55*t8-4.785390000313652d+0*t115*t48*t49*t50*t8+
     1         9.570780000627304d+0*t136*t16*t48*t49*t8+t10*t269*t8-t10*
     2         t55+4.785390000313652d+0*t10*t115*t48*t49
            t271 = -t50*t56*t8-4.785390000313652d+0*t116*t48*t49*t50*t8+
     1         9.570780000627304d+0*t136*t17*t48*t49*t8+t10*t270*t8-t10*
     2         t56+4.785390000313652d+0*t10*t116*t48*t49
            t272 = -t50*t57*t8-4.785390000313652d+0*t117*t48*t49*t50*t8+
     1         9.570780000627304d+0*t136*t18*t48*t49*t8+t10*t271*t8-t10*
     2         t57+4.785390000313652d+0*t10*t117*t48*t49
            t273 = -t50*t58*t8-4.785390000313652d+0*t118*t48*t49*t50*t8+
     1         9.570780000627304d+0*t136*t19*t48*t49*t8+t10*t272*t8-t10*
     2         t58+4.785390000313652d+0*t10*t118*t48*t49
            t274 = -t50*t59*t8-4.785390000313652d+0*t119*t48*t49*t50*t8+
     1         9.570780000627304d+0*t136*t20*t48*t49*t8+t10*t273*t8-t10*
     2         t59+4.785390000313652d+0*t10*t119*t48*t49
            t275 = -t50*t60*t8-4.785390000313652d+0*t120*t48*t49*t50*t8+
     1         9.570780000627304d+0*t136*t21*t48*t49*t8+t10*t274*t8-t10*
     2         t60+4.785390000313652d+0*t10*t120*t48*t49
            t276 = -t50*t8*t82-t10*t82-4.785390000313652d+0*t122*t48*t49
     1         *t50*t8+9.570780000627304d+0*t136*t30*t48*t49*t8+9.570780
     2         000627304d+0*t264*t265*t29*t48*t49+4.785390000313652d+0*t
     3         10*t122*t48*t49
            t277 = -t50*t8*t83-t10*t83-4.785390000313652d+0*t123*t48*t49
     1         *t50*t8+9.570780000627304d+0*t136*t31*t48*t49*t8+t10*t276
     2         *t8+4.785390000313652d+0*t10*t123*t48*t49
            t278 = -t50*t8*t84-t10*t84-4.785390000313652d+0*t124*t48*t49
     1         *t50*t8+9.570780000627304d+0*t136*t32*t48*t49*t8+t10*t277
     2         *t8+4.785390000313652d+0*t10*t124*t48*t49
            t279 = -t50*t8*t85-t10*t85-4.785390000313652d+0*t125*t48*t49
     1         *t50*t8+9.570780000627304d+0*t136*t33*t48*t49*t8+t10*t278
     2         *t8+4.785390000313652d+0*t10*t125*t48*t49
            t280 = -t50*t8*t86-t10*t86-4.785390000313652d+0*t126*t48*t49
     1         *t50*t8+9.570780000627304d+0*t136*t34*t48*t49*t8+t10*t279
     2         *t8+4.785390000313652d+0*t10*t126*t48*t49
            t281 = -t50*t8*t87-t10*t87-4.785390000313652d+0*t127*t48*t49
     1         *t50*t8+9.570780000627304d+0*t136*t35*t48*t49*t8+t10*t280
     2         *t8+4.785390000313652d+0*t10*t127*t48*t49
            t282 = -t50*t8*t88-t10*t88-4.785390000313652d+0*t128*t48*t49
     1         *t50*t8+9.570780000627304d+0*t136*t36*t48*t49*t8+t10*t281
     2         *t8+4.785390000313652d+0*t10*t128*t48*t49
            t283 = -t50*t8*t89-t10*t89-4.785390000313652d+0*t129*t48*t49
     1         *t50*t8+9.570780000627304d+0*t136*t37*t48*t49*t8+t10*t282
     2         *t8+4.785390000313652d+0*t10*t129*t48*t49
            t284 = -t50*t8*t90-t10*t90-4.785390000313652d+0*t130*t48*t49
     1         *t50*t8+9.570780000627304d+0*t136*t38*t48*t49*t8+t10*t283
     2         *t8+4.785390000313652d+0*t10*t130*t48*t49
            t285 = -t50*t8*t91-t10*t91-4.785390000313652d+0*t131*t48*t49
     1         *t50*t8+9.570780000627304d+0*t136*t39*t48*t49*t8+t10*t284
     2         *t8+4.785390000313652d+0*t10*t131*t48*t49
            t286 = 1.0d+0*(6.218138173930978d-2*rhoa*t105*t133*t93+6.218
     1         138173930978d-2*rhoa*t285*t81+3.109069086965489d-2*t133*t
     2         81+2.0d+0*rhoa*t121*t71-1.243628d-1*rhoa*t275*t46*t47-6.2
     3         1814d-2*t121*t46*t47)*wght
            t287 = t10*(-t10*t38*t8+t131*t8-t28)+t132
            t288 = 6.218138173930978d-2*rhoa*t108*t287*t93*wght
            t289 = 2*t11*t136*t8+2*t11*t50
            t290 = -2*t111*t50*t8+t10*t289*t8+2*t12*t136*t8+2*t12*t50-2*
     1         t10*t111
            t291 = -2*t112*t50*t8+t10*t290*t8+2*t13*t136*t8+2*t13*t50-2*
     1         t10*t112
            t292 = -2*t113*t50*t8+t10*t291*t8+2*t136*t14*t8+2*t14*t50-2*
     1         t10*t113
            t293 = -2*t114*t50*t8+t10*t292*t8+2*t136*t15*t8+2*t15*t50-2*
     1         t10*t114
            t294 = -2*t115*t50*t8+t10*t293*t8+2*t136*t16*t8+2*t16*t50-2*
     1         t10*t115
            t295 = -2*t116*t50*t8+t10*t294*t8+2*t136*t17*t8+2*t17*t50-2*
     1         t10*t116
            t296 = -2*t117*t50*t8+t10*t295*t8+2*t136*t18*t8+2*t18*t50-2*
     1         t10*t117
            t297 = -2*t118*t50*t8+t10*t296*t8+2*t136*t19*t8+2*t19*t50-2*
     1         t10*t118
            t298 = -2*t119*t50*t8+t10*t297*t8+2*t136*t20*t8+2*t20*t50-2*
     1         t10*t119
            t299 = 2*t136*t29*t8+2*t29*t50
            t300 = -2*t122*t50*t8+2*t136*t30*t8+t10*t299*t8+2*t30*t50-2*
     1         t10*t122
            t301 = -2*t123*t50*t8+2*t136*t31*t8+t10*t300*t8+2*t31*t50-2*
     1         t10*t123
            t302 = -2*t124*t50*t8+2*t136*t32*t8+t10*t301*t8+2*t32*t50-2*
     1         t10*t124
            t303 = -2*t125*t50*t8+2*t136*t33*t8+t10*t302*t8+2*t33*t50-2*
     1         t10*t125
            t304 = -2*t126*t50*t8+2*t136*t34*t8+t10*t303*t8+2*t34*t50-2*
     1         t10*t126
            t305 = -2*t127*t50*t8+2*t136*t35*t8+t10*t304*t8+2*t35*t50-2*
     1         t10*t127
            t306 = -2*t128*t50*t8+2*t136*t36*t8+t10*t305*t8+2*t36*t50-2*
     1         t10*t128
            t307 = -2*t129*t50*t8+2*t136*t37*t8+t10*t306*t8+2*t37*t50-2*
     1         t10*t129
            t308 = -2*t130*t50*t8+2*t136*t38*t8+t10*t307*t8+2*t38*t50-2*
     1         t10*t130
            t309 = 1.0d+0*(6.218138173930978d-2*rhoa*(-2*t131*t50*t8+2*t
     1         136*t39*t8+t10*t308*t8+2*t39*t50-2*t10*t131)*t81-1.243628
     2         d-1*rhoa*t46*t47*(-2*t120*t50*t8+t10*t298*t8+2*t136*t21*t
     3         8+2*t21*t50-2*t10*t120))*wght
            t310 = 1/t134
            t311 = 1/t135
            t312 = -1.243628d-1*rhoa*t46*t47*(t10*t8*(t10*t8*(t10*t8*(t1
     1         0*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(1.0
     2         634200000697003d+0*t11*t310*t311*t50*t8-2.630045457918064
     3         d+3*t11*t165*t265*t8+9.159982982040756d+1*t11*t136*t137*t
     4         139*t8-9.159982982040756d+1*t11*t137*t139*t50-1.063420000
     5         0697003d+0*t10*t11*t310*t311+2.630045457918064d+3*t11*t13
     6         6*t165)-9.570780000627304d+0*t138*t140*t50*t51*t8+1.37399
     7         74473061137d+2*t134*t135*t136*t51*t8-1.4356170000940957d+
     8         1*t141*t48*t49*t50*t8+1.0634200000697003d+0*t12*t310*t311
     9         *t50*t8-2.630045457918064d+3*t12*t165*t265*t8+9.159982982
     :         040756d+1*t12*t136*t137*t139*t8-1.3739974473061137d+2*t13
     ;         4*t135*t50*t51+9.570780000627304d+0*t10*t138*t140*t51-9.1
     <         59982982040756d+1*t12*t137*t139*t50+1.4356170000940957d+1
     =         *t10*t141*t48*t49-1.0634200000697003d+0*t10*t12*t310*t311
     >         +2.630045457918064d+3*t12*t136*t165)-9.570780000627304d+0
     ?         *t138*t140*t50*t52*t8+1.3739974473061137d+2*t134*t135*t13
     @         6*t52*t8-1.4356170000940957d+1*t142*t48*t49*t50*t8+1.0634
     1         200000697003d+0*t13*t310*t311*t50*t8-2.630045457918064d+3
     2         *t13*t165*t265*t8+9.159982982040756d+1*t13*t136*t137*t139
     3         *t8-1.3739974473061137d+2*t134*t135*t50*t52+9.57078000062
     4         7304d+0*t10*t138*t140*t52-9.159982982040756d+1*t13*t137*t
     5         139*t50+1.4356170000940957d+1*t10*t142*t48*t49-1.06342000
     6         00697003d+0*t10*t13*t310*t311+2.630045457918064d+3*t13*t1
     7         36*t165)-9.570780000627304d+0*t138*t140*t50*t53*t8+1.3739
     8         974473061137d+2*t134*t135*t136*t53*t8-1.4356170000940957d
     9         +1*t143*t48*t49*t50*t8+1.0634200000697003d+0*t14*t310*t31
     :         1*t50*t8-2.630045457918064d+3*t14*t165*t265*t8+9.15998298
     ;         2040756d+1*t136*t137*t139*t14*t8-1.3739974473061137d+2*t1
     <         34*t135*t50*t53+9.570780000627304d+0*t10*t138*t140*t53-9.
     =         159982982040756d+1*t137*t139*t14*t50+1.4356170000940957d+
     >         1*t10*t143*t48*t49-1.0634200000697003d+0*t10*t14*t310*t31
     ?         1+2.630045457918064d+3*t136*t14*t165)-9.570780000627304d+
     @         0*t138*t140*t50*t54*t8+1.3739974473061137d+2*t134*t135*t1
     1         36*t54*t8-1.4356170000940957d+1*t144*t48*t49*t50*t8+1.063
     2         4200000697003d+0*t15*t310*t311*t50*t8-2.630045457918064d+
     3         3*t15*t165*t265*t8+9.159982982040756d+1*t136*t137*t139*t1
     4         5*t8-1.3739974473061137d+2*t134*t135*t50*t54+9.5707800006
     5         27304d+0*t10*t138*t140*t54-9.159982982040756d+1*t137*t139
     6         *t15*t50+1.4356170000940957d+1*t10*t144*t48*t49-1.0634200
     7         000697003d+0*t10*t15*t310*t311+2.630045457918064d+3*t136*
     8         t15*t165)-9.570780000627304d+0*t138*t140*t50*t55*t8+1.373
     9         9974473061137d+2*t134*t135*t136*t55*t8-1.4356170000940957
     :         d+1*t145*t48*t49*t50*t8+1.0634200000697003d+0*t16*t310*t3
     ;         11*t50*t8-2.630045457918064d+3*t16*t165*t265*t8+9.1599829
     <         82040756d+1*t136*t137*t139*t16*t8-1.3739974473061137d+2*t
     =         134*t135*t50*t55+9.570780000627304d+0*t10*t138*t140*t55-9
     >         .159982982040756d+1*t137*t139*t16*t50+1.4356170000940957d
     ?         +1*t10*t145*t48*t49-1.0634200000697003d+0*t10*t16*t310*t3
     @         11+2.630045457918064d+3*t136*t16*t165)-9.570780000627304d
     1         +0*t138*t140*t50*t56*t8+1.3739974473061137d+2*t134*t135*t
     2         136*t56*t8-1.4356170000940957d+1*t146*t48*t49*t50*t8+1.06
     3         34200000697003d+0*t17*t310*t311*t50*t8-2.630045457918064d
     4         +3*t165*t17*t265*t8+9.159982982040756d+1*t136*t137*t139*t
     5         17*t8-1.3739974473061137d+2*t134*t135*t50*t56+9.570780000
     6         627304d+0*t10*t138*t140*t56-9.159982982040756d+1*t137*t13
     7         9*t17*t50+1.4356170000940957d+1*t10*t146*t48*t49-1.063420
     8         0000697003d+0*t10*t17*t310*t311+2.630045457918064d+3*t136
     9         *t165*t17)-9.570780000627304d+0*t138*t140*t50*t57*t8+1.37
     :         39974473061137d+2*t134*t135*t136*t57*t8-1.435617000094095
     ;         7d+1*t147*t48*t49*t50*t8+1.0634200000697003d+0*t18*t310*t
     <         311*t50*t8-2.630045457918064d+3*t165*t18*t265*t8+9.159982
     =         982040756d+1*t136*t137*t139*t18*t8-1.3739974473061137d+2*
     >         t134*t135*t50*t57+9.570780000627304d+0*t10*t138*t140*t57-
     ?         9.159982982040756d+1*t137*t139*t18*t50+1.4356170000940957
     @         d+1*t10*t147*t48*t49-1.0634200000697003d+0*t10*t18*t310*t
     1         311+2.630045457918064d+3*t136*t165*t18)-9.570780000627304
     2         d+0*t138*t140*t50*t58*t8+1.3739974473061137d+2*t134*t135*
     3         t136*t58*t8-1.4356170000940957d+1*t148*t48*t49*t50*t8+1.0
     4         634200000697003d+0*t19*t310*t311*t50*t8-2.630045457918064
     5         d+3*t165*t19*t265*t8+9.159982982040756d+1*t136*t137*t139*
     6         t19*t8-1.3739974473061137d+2*t134*t135*t50*t58+9.57078000
     7         0627304d+0*t10*t138*t140*t58-9.159982982040756d+1*t137*t1
     8         39*t19*t50+1.4356170000940957d+1*t10*t148*t48*t49-1.06342
     9         00000697003d+0*t10*t19*t310*t311+2.630045457918064d+3*t13
     :         6*t165*t19)-9.570780000627304d+0*t138*t140*t50*t59*t8+1.3
     ;         739974473061137d+2*t134*t135*t136*t59*t8-1.43561700009409
     <         57d+1*t149*t48*t49*t50*t8+1.0634200000697003d+0*t20*t310*
     =         t311*t50*t8-2.630045457918064d+3*t165*t20*t265*t8+9.15998
     >         2982040756d+1*t136*t137*t139*t20*t8-1.3739974473061137d+2
     ?         *t134*t135*t50*t59+9.570780000627304d+0*t10*t138*t140*t59
     @         -9.159982982040756d+1*t137*t139*t20*t50+1.435617000094095
     1         7d+1*t10*t149*t48*t49-1.0634200000697003d+0*t10*t20*t310*
     2         t311+2.630045457918064d+3*t136*t165*t20)-9.57078000062730
     3         4d+0*t138*t140*t50*t60*t8+1.3739974473061137d+2*t134*t135
     4         *t136*t60*t8-1.4356170000940957d+1*t150*t48*t49*t50*t8+1.
     5         0634200000697003d+0*t21*t310*t311*t50*t8-2.63004545791806
     6         4d+3*t165*t21*t265*t8+9.159982982040756d+1*t136*t137*t139
     7         *t21*t8-1.3739974473061137d+2*t134*t135*t50*t60+9.5707800
     8         00627304d+0*t10*t138*t140*t60-9.159982982040756d+1*t137*t
     9         139*t21*t50+1.4356170000940957d+1*t10*t150*t48*t49-1.0634
     :         200000697003d+0*t10*t21*t310*t311+2.630045457918064d+3*t1
     ;         36*t165*t21)
            t313 = -1.865442d-1*t151*t46*t47
            t314 = 6.0d+0*rhoa*t151*t71
            t315 = 6.0d+0*t61*t71
            t316 = 8.48131310861104d-4*t46/rhoa**3.333333333333333d+0
            t317 = 1/rhoa**3
            t318 = -2.1809090850714105d-3*t156*t63*t70
            t319 = 3.37738d-2*t164*(1.1876045553756398d-1*t161*t3*t67-1.
     1         425125466450768d+0*t2*(7.016926042943222d-1*t3*(-5.847438
     2         369119352d-2*t158*t66*t67-6.883279156869946d-4*t65)-5.847
     3         438369119352d-2*t159*t66*t67)/t160**2)/t162-3.08334765235
     4         9653d-4*t163*t62
            t320 = -3.2713636276071156d-3*t168*t169*t62
            t321 = 3.2713636276071156d-3*t178*t62*t63
            t322 = -1.243628d-1*t47*t70**3/t45**3
            t323 = 1.865442d-1*t168*t178*t47*t70
            t324 = 1/rhoa**2.666666666666667d+0
            t325 = 1/t2**7
            t326 = 1/rhoa**2.0d+0
            t327 = -6.21814d-2*t47*t63*(-8.550752798704606d+0*t2*t69**3/
     1         t43**4+2.969011388439098d-2*t64*t65*t66*t69+1.18760455537
     2         56398d-1*t174*t3*t64*t69+8.550752798704606d+0*t171*t177*t
     3         2*t69-1.425125466450768d+0*t2*t64*(5.847438369119352d-2*t
     4         174*t66*t68+4.385578776839513d-2*t175*t65*t68-1.754231510
     5         7358056d-1*t176*t66*t67+7.016926042943222d-1*t3*(-1.62428
     6         84358664864d-2*t324*t41*t66-6.091081634499322d-3*t325*t32
     7         6*t41-1.4618595922798375d-2*t173*t175*t41-1.1615990756816
     8         77d-3/rhoa**3.3333333333333337d+0)-1.6242884358664864d-2*
     9         t324*t42*t66-6.091081634499322d-3*t325*t326*t42-1.4618595
     :         922798375d-2*t173*t175*t42)-3.5628136661269194d-1*t177*t3
     ;         *t64*t67+7.125627332253839d-1*t171*t172*t3*t67+9.89670462
     <         813033d-3*t173*t44*t66+2.474176157032582d-3*t175*t326*t44
     =         +3.29890154271011d-2*t3*t324*t44)
            t328 = t327+t323+t322+t321+t320+7.500000000000002d-1*t166*t3
     1         19+t318-2.533035d-2*t163*t164*t317+t316
            t329 = 6.218138173930978d-2*rhoa*t81*(-9.570780000627304d+0*
     1         t138*t140*t50*t8*t91+1.3739974473061137d+2*t134*t135*t136
     2         *t8*t91-1.3739974473061137d+2*t134*t135*t50*t91+9.5707800
     3         00627304d+0*t10*t138*t140*t91+t10*t8*(-9.570780000627304d
     4         +0*t138*t140*t50*t8*t90+1.3739974473061137d+2*t134*t135*t
     5         136*t8*t90-1.3739974473061137d+2*t134*t135*t50*t90+9.5707
     6         80000627304d+0*t10*t138*t140*t90+t10*t8*(-9.5707800006273
     7         04d+0*t138*t140*t50*t8*t89+1.3739974473061137d+2*t134*t13
     8         5*t136*t8*t89-1.3739974473061137d+2*t134*t135*t50*t89+9.5
     9         70780000627304d+0*t10*t138*t140*t89+t10*t8*(-9.5707800006
     :         27304d+0*t138*t140*t50*t8*t88+1.3739974473061137d+2*t134*
     ;         t135*t136*t8*t88-1.3739974473061137d+2*t134*t135*t50*t88+
     <         9.570780000627304d+0*t10*t138*t140*t88+t10*t8*(-9.5707800
     =         00627304d+0*t138*t140*t50*t8*t87+1.3739974473061137d+2*t1
     >         34*t135*t136*t8*t87-1.3739974473061137d+2*t134*t135*t50*t
     ?         87+9.570780000627304d+0*t10*t138*t140*t87+t10*t8*(-9.5707
     @         80000627304d+0*t138*t140*t50*t8*t86+1.3739974473061137d+2
     1         *t134*t135*t136*t8*t86-1.3739974473061137d+2*t134*t135*t5
     2         0*t86+9.570780000627304d+0*t10*t138*t140*t86+t10*t8*(-9.5
     3         70780000627304d+0*t138*t140*t50*t8*t85+1.3739974473061137
     4         d+2*t134*t135*t136*t8*t85-1.3739974473061137d+2*t134*t135
     5         *t50*t85+9.570780000627304d+0*t10*t138*t140*t85+t10*t8*(-
     6         9.570780000627304d+0*t138*t140*t50*t8*t84+1.3739974473061
     7         137d+2*t134*t135*t136*t8*t84-1.3739974473061137d+2*t134*t
     8         135*t50*t84+9.570780000627304d+0*t10*t138*t140*t84+t10*t8
     9         *(-9.570780000627304d+0*t138*t140*t50*t8*t83+1.3739974473
     :         061137d+2*t134*t135*t136*t8*t83-1.3739974473061137d+2*t13
     ;         4*t135*t50*t83+9.570780000627304d+0*t10*t138*t140*t83+t10
     <         *t8*(-9.570780000627304d+0*t138*t140*t50*t8*t82+1.3739974
     =         473061137d+2*t134*t135*t136*t8*t82-1.3739974473061137d+2*
     >         t134*t135*t50*t82+9.570780000627304d+0*t10*t138*t140*t82+
     ?         t10*t8*(1.0634200000697003d+0*t29*t310*t311*t50*t8-2.6300
     @         45457918064d+3*t165*t265*t29*t8+9.159982982040756d+1*t136
     1         *t137*t139*t29*t8-9.159982982040756d+1*t137*t139*t29*t50-
     2         1.0634200000697003d+0*t10*t29*t310*t311+2.630045457918064
     3         d+3*t136*t165*t29)-1.4356170000940957d+1*t181*t48*t49*t50
     4         *t8+1.0634200000697003d+0*t30*t310*t311*t50*t8-2.63004545
     5         7918064d+3*t165*t265*t30*t8+9.159982982040756d+1*t136*t13
     6         7*t139*t30*t8-9.159982982040756d+1*t137*t139*t30*t50+1.43
     7         56170000940957d+1*t10*t181*t48*t49-1.0634200000697003d+0*
     8         t10*t30*t310*t311+2.630045457918064d+3*t136*t165*t30)-1.4
     9         356170000940957d+1*t182*t48*t49*t50*t8+1.0634200000697003
     :         d+0*t31*t310*t311*t50*t8-2.630045457918064d+3*t165*t265*t
     ;         31*t8+9.159982982040756d+1*t136*t137*t139*t31*t8-9.159982
     <         982040756d+1*t137*t139*t31*t50+1.4356170000940957d+1*t10*
     =         t182*t48*t49-1.0634200000697003d+0*t10*t31*t310*t311+2.63
     >         0045457918064d+3*t136*t165*t31)-1.4356170000940957d+1*t18
     ?         3*t48*t49*t50*t8+1.0634200000697003d+0*t310*t311*t32*t50*
     @         t8-2.630045457918064d+3*t165*t265*t32*t8+9.15998298204075
     1         6d+1*t136*t137*t139*t32*t8-9.159982982040756d+1*t137*t139
     2         *t32*t50+1.4356170000940957d+1*t10*t183*t48*t49-1.0634200
     3         000697003d+0*t10*t310*t311*t32+2.630045457918064d+3*t136*
     4         t165*t32)-1.4356170000940957d+1*t184*t48*t49*t50*t8+1.063
     5         4200000697003d+0*t310*t311*t33*t50*t8-2.630045457918064d+
     6         3*t165*t265*t33*t8+9.159982982040756d+1*t136*t137*t139*t3
     7         3*t8-9.159982982040756d+1*t137*t139*t33*t50+1.43561700009
     8         40957d+1*t10*t184*t48*t49-1.0634200000697003d+0*t10*t310*
     9         t311*t33+2.630045457918064d+3*t136*t165*t33)-1.4356170000
     :         940957d+1*t185*t48*t49*t50*t8+1.0634200000697003d+0*t310*
     ;         t311*t34*t50*t8-2.630045457918064d+3*t165*t265*t34*t8+9.1
     <         59982982040756d+1*t136*t137*t139*t34*t8-9.159982982040756
     =         d+1*t137*t139*t34*t50+1.4356170000940957d+1*t10*t185*t48*
     >         t49-1.0634200000697003d+0*t10*t310*t311*t34+2.63004545791
     ?         8064d+3*t136*t165*t34)-1.4356170000940957d+1*t186*t48*t49
     @         *t50*t8+1.0634200000697003d+0*t310*t311*t35*t50*t8-2.6300
     1         45457918064d+3*t165*t265*t35*t8+9.159982982040756d+1*t136
     2         *t137*t139*t35*t8-9.159982982040756d+1*t137*t139*t35*t50+
     3         1.4356170000940957d+1*t10*t186*t48*t49-1.0634200000697003
     4         d+0*t10*t310*t311*t35+2.630045457918064d+3*t136*t165*t35)
     5         -1.4356170000940957d+1*t187*t48*t49*t50*t8+1.063420000069
     6         7003d+0*t310*t311*t36*t50*t8-2.630045457918064d+3*t165*t2
     7         65*t36*t8+9.159982982040756d+1*t136*t137*t139*t36*t8-9.15
     8         9982982040756d+1*t137*t139*t36*t50+1.4356170000940957d+1*
     9         t10*t187*t48*t49-1.0634200000697003d+0*t10*t310*t311*t36+
     :         2.630045457918064d+3*t136*t165*t36)-1.4356170000940957d+1
     ;         *t188*t48*t49*t50*t8+1.0634200000697003d+0*t310*t311*t37*
     <         t50*t8-2.630045457918064d+3*t165*t265*t37*t8+9.1599829820
     =         40756d+1*t136*t137*t139*t37*t8-9.159982982040756d+1*t137*
     >         t139*t37*t50+1.4356170000940957d+1*t10*t188*t48*t49-1.063
     ?         4200000697003d+0*t10*t310*t311*t37+2.630045457918064d+3*t
     @         136*t165*t37)-1.4356170000940957d+1*t189*t48*t49*t50*t8+1
     1         .0634200000697003d+0*t310*t311*t38*t50*t8-2.6300454579180
     2         64d+3*t165*t265*t38*t8+9.159982982040756d+1*t136*t137*t13
     3         9*t38*t8-9.159982982040756d+1*t137*t139*t38*t50+1.4356170
     4         000940957d+1*t10*t189*t48*t49-1.0634200000697003d+0*t10*t
     5         310*t311*t38+2.630045457918064d+3*t136*t165*t38)-1.435617
     6         0000940957d+1*t190*t48*t49*t50*t8+1.0634200000697003d+0*t
     7         310*t311*t39*t50*t8-2.630045457918064d+3*t165*t265*t39*t8
     8         +9.159982982040756d+1*t136*t137*t139*t39*t8-9.15998298204
     9         0756d+1*t137*t139*t39*t50+1.4356170000940957d+1*t10*t190*
     :         t48*t49-1.0634200000697003d+0*t10*t310*t311*t39+2.6300454
     ;         57918064d+3*t136*t165*t39)
            t330 = 9.327207260896466d-2*t191*t81
            t331 = 1/t80**3
            t332 = 1.2436276347861956d-1*rhoa*t105**3*t331*t40
            t333 = 1.8654414521792934d-1*rhoa*t105*t191
            t334 = 1.8654414521792934d-1*t105*t92
            t335 = rhoa**5.000000000000002d-1
            t336 = -5.150267658720751d-1*gammaaa*t102*t335*t76*t79
            t337 = 1/rhoa**6.666666666666665d-1
            t338 = 5.518143920057951d-2*gammaaa*t106*t337*t76*t79
            t339 = 1/rhoa**1.8333333333333332d+0
            t340 = 7.567740233222326d-1*gammaaa*t100*t104*t94*t95*t99
            t341 = -7.567740233222326d-1*gammaaa*t207*t208*t76*t94*t95
            t342 = 6.486634485619136d-1*gammaaa*t207*t208*t24*t99
            t343 = 1/t78**4
            t344 = -6.486634485619136d-1*gammaaa*t104**3*t24*t343*t76
            t345 = -5.150267658720751d-1*gammaaa*t102*t335*t74
            t346 = 5.518143920057951d-2*gammaaa*t106*t337*t74
            t347 = -3.766352199404629d-2*gammaaa*t339*t74*t95
            t348 = -3.603685825343965d-2*gammaaa*t24*t317*t74
            t349 = 2.1298248828984737d+1*gammaaa*t106*t200*t71*t72*t97
            t350 = -1.0142023251897499d+0*gammaaa*t202*t71*t72*t95*t97
            t351 = 3.9144925898560723d+2*gammaaa*t214*t72*t94*t95*t97
            t352 = 3.783870116611163d-1*gammaaa*t216*t72*t94*t95*t97
            t353 = t71**3
            t354 = 3.597303318004418d+3*gammaaa*t24*t353*t72*t97
            t355 = 1.1590883716454273d+0*gammaaa*t166*t24*t71*t72*t97
            t356 = -1.608198422145741d+1*t166*t71-1.0000002936681321d+0*
     1         t317*t46*t47-3.216396844291483d+1*t328
            t357 = -1.0811057476031893d-1*gammaaa*t24*t356*t72*t97
            t358 = 1.0431795344808847d+1*gammaaa*t216*t24*t71*t72*t97
            t359 = -7.828985179712145d+2*gammaaa*t214*t218*t219*t94*t95
            t360 = -2.1583819908026508d+4*gammaaa*t218*t219*t24*t353
            t361 = -2.0863590689617695d+1*gammaaa*t216*t218*t219*t24*t71
            t362 = exp(6.000001762008792d+0*t46*t47)
            t363 = 2.1583819908026508d+4*gammaaa*t24*t353*t362/t73**4
            t364 = 1/t23**7.0d+0
            t365 = -2.783991983768912d-1*t101*t335*t364*t77
            t366 = 1.9885657026920814d-2*t101*t222*t337*t77
            t367 = 1.5350439481932196d+1*t101*t103*t200*t222*t71*t72
            t368 = 1.6927921751373973d+2*t101*t102*t103*t214*t72*t94
            t369 = 7.778130585933201d+2*t103*t27*t353*t72
            t370 = -5.078376525412192d+2*t101*t102*t214*t219*t226*t94
            t371 = -7.000317527339879d+3*t219*t226*t27*t353
            t372 = 9.33375670311984d+3*t27*t353*t362/t73**5.0d+0
            t373 = -6.218138173930978d-2*rhoa*t195*t92
            t374 = -3.109069086965489d-2*t195*t40
            t375 = -t105*t230
            t376 = t327+t323+t322+t321+t320-2.4999999999999994d-1*t166*t
     1         319+t318+8.44345d-3*t163*t164*t317+t316
            t377 = 1.8393813066859827d-2*gammaaa*t339*t74*t95
            t378 = 1.2012286084479884d-2*gammaaa*t24*t317*t74
            t379 = 2.1298248828984734d+1*gammaaa*t106*t200*t71*t72*t97
            t380 = -1.0142023251897496d+0*gammaaa*t202*t71*t72*t95*t97
            t381 = 2.5225800777407753d-1*gammaaa*t234*t72*t94*t95*t97
            t382 = 1.2612900388703877d-1*gammaaa*t216*t72*t94*t95*t97
            t383 = -3.8636279054847583d-1*gammaaa*t166*t24*t71*t72*t97
            t384 = 5.360661407152473d+0*t166*t71+3.333334312227107d-1*t3
     1         17*t46*t47-3.216396844291483d+1*t376
            t385 = -1.0811057476031893d-1*gammaaa*t24*t384*t72*t97
            t386 = 6.954530229872565d+0*gammaaa*t234*t24*t71*t72*t97
            t387 = 3.4772651149362827d+0*gammaaa*t216*t24*t71*t72*t97
            t388 = -1.3909060459745132d+1*gammaaa*t218*t219*t234*t24*t71
            t389 = -6.954530229872565d+0*gammaaa*t216*t218*t219*t24*t71
            t390 = 1.2436276347861956d-1*rhoa*t108*t195*t331*t40
            t391 = 6.218138173930978d-2*rhoa*t108*t191
            t392 = 6.218138173930978d-2*t108*t92
            t393 = 1.2436276347861956d-1*rhoa*t245*t92
            t394 = 6.218138173930978d-2*t245*t40
            t395 = -2.2072575680231782d-1*gammaaa*t100*t106*t107*t200*t7
     1         6
            t396 = 1.0510750323919903d-2*gammaaa*t100*t107*t202*t76*t95
            t397 = 5.518143920057945d-2*t106*t200*t76*t79
            t398 = -2.6276875809799755d-3*t202*t76*t79*t95
            t399 = 5.96569710807624d-3*gammaaa*t200*t222*t74*t79
            t400 = -2.840808146702972d-4*gammaaa*t102*t202*t74*t79
            t401 = -2.5225800777407753d-1*gammaaa*t243*t79*t94*t95
            t402 = 2.5225800777407753d-1*gammaaa*t100*t244*t76*t94*t95
            t403 = 2.5225800777407753d-1*gammaaa*t100*t107*t94*t95*t99
            t404 = -6.306450194351938d-2*t79*t94*t95*t99
            t405 = -2.1622114952063787d-1*gammaaa*t100*t24*t244*t99
            t406 = -5.045160155481551d-1*gammaaa*t104*t107*t207*t76*t94*
     1         t95
            t407 = 6.306450194351938d-2*t100*t104*t76*t94*t95
            t408 = 6.817939552087132d-3*gammaaa*t100*t102*t104*t74*t94
            t409 = -2.1622114952063787d-1*gammaaa*t100*t104*t24*t243
            t410 = 4.3244229904127574d-1*gammaaa*t104*t207*t24*t244*t76
            t411 = 4.3244229904127574d-1*gammaaa*t104*t107*t207*t24*t99
            t412 = -5.405528738015947d-2*t100*t104*t24*t99
            t413 = -6.486634485619136d-1*gammaaa*t107*t208*t24*t343*t76
            t414 = 5.405528738015947d-2*t207*t208*t24*t76
            t415 = 5.843948187503255d-3*gammaaa*t106*t207*t208*t74
            t416 = 5.518143920057945d-2*t106*t200*t74
            t417 = -2.6276875809799755d-3*t202*t74*t95
            t418 = 3.00307152111997d-3*t166*t24*t74
            t419 = -2.0284046503794984d+0*t71*t72*t94*t95*t97
            t420 = -2.7960661356114797d+1*t214*t24*t72*t97
            t421 = -2.7027643690079733d-2*t216*t24*t72*t97
            t422 = 5.592132271222959d+1*t214*t218*t219*t24
            t423 = 3.97713140538416d-2*gammaaa*t200*t222*t77
            t424 = -1.1363232586811889d-3*gammaaa*t102*t202*t77
            t425 = -1.7543359407922504d+0*gammaaa*t102*t103*t71*t72*t94
            t426 = 3.6274118038658515d+1*gammaaa*t106*t214*t219*t226
            t427 = -1.2436276347861956d-1*rhoa*t105*t245*t40
            t428 = 1.0d+0*((6.218138173930978d-2*rhoa*t40*(3.00307152111
     1         997d-3*t166*t24*t76*t79+3.2466378819462516d-4*gammaaa*t10
     2         6*t166*t74*t79+1.0811057476031893d-1*gammaaa*t24*(t422+t4
     3         21+t420+t419+t418+t417+t416)*t79+2.7027643690079733d-2*t2
     4         21*t24*t79-1.0811057476031893d-1*gammaaa*t100*t24*t76*(1.
     5         2986551527785006d-3*gammaaa*t106*t166*t77-1.1687896375006
     6         51d-2*gammaaa*t103*t106*t216*t72-1.2091372679552839d+1*ga
     7         mmaaa*t103*t106*t214*t72+t426+t425+t424+t423+t422+t421+t4
     8         20+t419+t418+t417+t416)+2.1622114952063787d-1*gammaaa*t10
     9         7*t207*t228*t24*t76-2.7027643690079733d-2*t100*t228*t24*t
     :         76-1.2012286084479878d-2*gammaaa*t100*t107*t166*t24*t76-2
     ;         .9219740937516275d-3*gammaaa*t100*t106*t228*t74+t415+t414
     <         +t413+t412+t411+t410+t409+t408+t407+t406+t405+t404+t403+t
     =         402+t401+t400+t399+t398+t397+t396+t395-1.0811057476031893
     >         d-1*gammaaa*t100*t107*t221*t24)-1.0363563623218294d-2*t10
     ?         8*t197*t40+t394+t393+t392+t391)*t93+t194*(t427-t108*t230)
     @         +t390)*wght
            t429 = 1.2436276347861956d-1*rhoa*t110*t195*t331*t40
            t430 = 6.218138173930978d-2*rhoa*t110*t191
            t431 = 6.218138173930978d-2*t110*t92
            t432 = 1.2436276347861956d-1*rhoa*t252*t92
            t433 = 6.218138173930978d-2*t252*t40
            t434 = -2.2072575680231782d-1*gammaaa*t100*t106*t109*t200*t7
     1         6
            t435 = 1.0510750323919903d-2*gammaaa*t100*t109*t202*t76*t95
            t436 = 1.1036287840115891d-1*t106*t200*t76*t79
            t437 = -5.255375161959951d-3*t202*t76*t79*t95
            t438 = 1.1931394216152481d-2*gammaaa*t200*t222*t74*t79
            t439 = -5.681616293405944d-4*gammaaa*t102*t202*t74*t79
            t440 = -2.5225800777407753d-1*gammaaa*t250*t79*t94*t95
            t441 = 2.5225800777407753d-1*gammaaa*t100*t251*t76*t94*t95
            t442 = 2.5225800777407753d-1*gammaaa*t100*t109*t94*t95*t99
            t443 = -1.2612900388703877d-1*t79*t94*t95*t99
            t444 = -2.1622114952063787d-1*gammaaa*t100*t24*t251*t99
            t445 = -5.045160155481551d-1*gammaaa*t104*t109*t207*t76*t94*
     1         t95
            t446 = 1.2612900388703877d-1*t100*t104*t76*t94*t95
            t447 = 1.3635879104174264d-2*gammaaa*t100*t102*t104*t74*t94
            t448 = -2.1622114952063787d-1*gammaaa*t100*t104*t24*t250
            t449 = 4.3244229904127574d-1*gammaaa*t104*t207*t24*t251*t76
            t450 = 4.3244229904127574d-1*gammaaa*t104*t109*t207*t24*t99
            t451 = -1.0811057476031893d-1*t100*t104*t24*t99
            t452 = -6.486634485619136d-1*gammaaa*t109*t208*t24*t343*t76
            t453 = 1.0811057476031893d-1*t207*t208*t24*t76
            t454 = 1.168789637500651d-2*gammaaa*t106*t207*t208*t74
            t455 = 1.1036287840115891d-1*t106*t200*t74
            t456 = -5.255375161959951d-3*t202*t74*t95
            t457 = 6.00614304223994d-3*t166*t24*t74
            t458 = -4.0568093007589967d+0*t71*t72*t94*t95*t97
            t459 = -5.592132271222959d+1*t214*t24*t72*t97
            t460 = -5.405528738015947d-2*t216*t24*t72*t97
            t461 = 1.118426454244592d+2*t214*t218*t219*t24
            t462 = 7.95426281076832d-2*gammaaa*t200*t222*t77
            t463 = -2.2726465173623778d-3*gammaaa*t102*t202*t77
            t464 = -3.508671881584501d+0*gammaaa*t102*t103*t71*t72*t94
            t465 = 7.254823607731703d+1*gammaaa*t106*t214*t219*t226
            t466 = -1.2436276347861956d-1*rhoa*t105*t252*t40
            t467 = -3.00307152111997d-3*t166*t24*t74
            t468 = -2.79606613561148d+1*t214*t24*t72*t97
            t469 = -2.7027643690079733d-2*t234*t24*t72*t97
            t470 = 5.59213227122296d+1*t214*t218*t219*t24
            t471 = -6.00614304223994d-3*t166*t24*t74
            t472 = -5.59213227122296d+1*t214*t24*t72*t97
            t473 = -5.405528738015947d-2*t234*t24*t72*t97
            t474 = 1.1184264542445921d+2*t214*t218*t219*t24
            t475 = 6.306450194351938d-2*t100*t107*t76*t94*t95
            t476 = 6.817939552087132d-3*gammaaa*t100*t102*t107*t74*t94
            t477 = 5.405528738015947d-2*t24*t243*t79
            t478 = -5.405528738015947d-2*t100*t24*t244*t76
            t479 = -5.843948187503255d-3*gammaaa*t100*t106*t244*t74
            t480 = -5.405528738015947d-2*t100*t107*t24*t99
            t481 = 1.0811057476031893d-1*t104*t107*t207*t24*t76
            t482 = 1.168789637500651d-2*gammaaa*t104*t106*t107*t207*t74
            t483 = 1.0d+0*(t93*(6.218138173930978d-2*rhoa*t40*(-1.579481
     1         4935512527d-4*gammaaa*t100*t222*t77*t99+2.162211495206378
     2         7d-1*gammaaa*t207*t24*t255*t99-2.5225800777407753d-1*gamm
     3         aaa*t207*t255*t76*t94*t95-1.0811057476031893d-1*gammaaa*t
     4         100*t24*t76*(9.398228254244201d-2*t103*t106*t71*t72-3.408
     5         969776043565d-3*t102*t77*t94)-1.704484888021783d-3*t102*t
     6         74*t79*t94+1.8427284091431279d-4*gammaaa*t100*t364*t76*t7
     7         7*t94+3.1589629871025054d-4*gammaaa*t104*t207*t222*t76*t7
     8         7-6.486634485619136d-1*gammaaa*t104*t24*t255*t343*t76+4.3
     9         244229904127574d-1*gammaaa*t107*t207*t24*t244*t76-1.46098
     :         70468758138d-3*t100*t104*t106*t74+t482+t481+t480+t479+t47
     ;         8+t477+t476+t475-2.1622114952063787d-1*gammaaa*t100*t107*
     <         t24*t243)+6.218138173930978d-2*rhoa*t258*t92+3.1090690869
     =         65489d-2*t258*t40)+t194*(-6.218138173930978d-2*rhoa*t105*
     >         t258*t40-6.218138173930978d-2*rhoa*t108*t245*t40-t108*t24
     ?         6)+1.2436276347861956d-1*rhoa*t105*t254*t331*t40)*wght
            t484 = 1.2436276347861956d-1*rhoa*t105*t108*t110*t331*t40
            t485 = t93*(6.218138173930978d-2*rhoa*t40*(-3.15896298710250
     1         54d-4*gammaaa*t100*t222*t77*t99+2.1622114952063787d-1*gam
     2         maaa*t107*t109*t207*t24*t99-2.7027643690079733d-2*t100*t1
     3         09*t24*t99-2.5225800777407753d-1*gammaaa*t107*t109*t207*t
     4         76*t94*t95+3.153225097175969d-2*t100*t109*t76*t94*t95-1.0
     5         811057476031893d-1*gammaaa*t100*t24*t76*(1.87964565084884
     6         02d-1*t103*t106*t71*t72-6.81793955208713d-3*t102*t77*t94)
     7         -3.408969776043566d-3*t102*t74*t79*t94+3.6854568182862557
     8         d-4*gammaaa*t100*t364*t76*t77*t94+3.408969776043566d-3*ga
     9         mmaaa*t100*t102*t109*t74*t94+2.7027643690079733d-2*t24*t2
     :         50*t79+6.317925974205011d-4*gammaaa*t104*t207*t222*t76*t7
     ;         7-6.486634485619136d-1*gammaaa*t104*t107*t109*t24*t343*t7
     <         6+2.1622114952063787d-1*gammaaa*t107*t207*t24*t251*t76-2.
     =         7027643690079733d-2*t100*t24*t251*t76+2.1622114952063787d
     >         -1*gammaaa*t109*t207*t24*t244*t76+5.405528738015947d-2*t1
     ?         04*t109*t207*t24*t76-2.9219740937516275d-3*gammaaa*t100*t
     @         106*t251*t74+5.843948187503255d-3*gammaaa*t104*t106*t109*
     1         t207*t74-2.9219740937516275d-3*t100*t104*t106*t74+t482+t4
     2         81+t480+t479+t478+t477+t476+t475-1.0811057476031893d-1*ga
     3         mmaaa*t100*t107*t24*t250-1.0811057476031893d-1*gammaaa*t1
     4         00*t109*t24*t243)+6.218138173930978d-2*rhoa*t260*t92+3.10
     5         9069086965489d-2*t260*t40)
            t486 = -6.218138173930978d-2*rhoa*t105*t260*t40
            t487 = 1/t23**8.0d+0
            t488 = 6.218138173930978d-2*rhoa*t40*(9.476888961307518d-4*g
     1         ammaaa*t107*t207*t222*t76*t77-1.1846111201634398d-4*t100*
     2         t222*t76*t77-6.486634485619136d-1*gammaaa*t107**3*t24*t34
     3         3*t76+1.621658621404784d-1*t207*t24*t255*t76+1.7531844562
     4         509763d-2*gammaaa*t106*t207*t255*t74-4.3829611406274405d-
     5         3*t100*t106*t107*t74-1.2806898906833467d-5*gammaaa*t100*t
     6         103*t487)*t93*wght+1.2436276347861956d-1*rhoa*t108**3*t33
     7         1*t40*wght-1.8654414521792934d-1*rhoa*t108*t194*t258*t40*
     8         wght
            t489 = 1.2635851948410023d-3*gammaaa*t107*t207*t222*t76*t77
            t490 = -5.843948187503255d-3*t100*t106*t107*t74
            t491 = t194*(-1.2436276347861956d-1*rhoa*t108*t260*t40*wght-
     1         6.218138173930978d-2*rhoa*t110*t258*t40*wght)+6.218138173
     2         930978d-2*rhoa*t40*(3.1589629871025054d-4*gammaaa*t109*t2
     3         07*t222*t76*t77-2.3692222403268795d-4*t100*t222*t76*t77-6
     4         .486634485619136d-1*gammaaa*t109*t24*t255*t343*t76+1.0811
     5         057476031893d-1*t207*t24*t255*t76+1.0811057476031893d-1*t
     6         107*t109*t207*t24*t76+1.168789637500651d-2*gammaaa*t106*t
     7         207*t255*t74+1.168789637500651d-2*gammaaa*t106*t107*t109*
     8         t207*t74-1.4609870468758138d-3*t100*t106*t109*t74+t490+t4
     9         89-2.5613797813666933d-5*gammaaa*t100*t103*t487)*t93*wght
     :         +1.2436276347861956d-1*rhoa*t110*t254*t331*t40*wght
            t492 = 1/t9**5
            t493 = -1.243628d-1*rhoa*t46*t47*(t10*t8*(t10*t8*(t10*t8*(t1
     1         0*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(-1.
     2         3739974473061137d+2*t11*t134*t135*t265*t8+6.3805200004182
     3         02d+0*t11*t136*t138*t140*t8+4.579991491020378d+1*t11*t134
     4         *t135*t136)+1.9141560001254607d+1*t136*t48*t49*t51*t8-t14
     5         1*t50*t8-3.190260000209101d+0*t111*t138*t140*t50*t8-1.373
     6         9974473061137d+2*t12*t134*t135*t265*t8+9.159982982040756d
     7         +1*t11*t134*t135*t265*t8+6.380520000418202d+0*t12*t136*t1
     8         38*t140*t8+4.579991491020378d+1*t111*t134*t135*t136*t8-4.
     9         579991491020378d+1*t111*t134*t135*t50-9.159982982040756d+
     :         1*t11*t134*t135*t264*t492-t10*t141+3.190260000209101d+0*t
     ;         10*t111*t138*t140+4.579991491020378d+1*t12*t134*t135*t136
     <         )+1.9141560001254607d+1*t136*t48*t49*t52*t8-9.57078000062
     =         7304d+0*t266*t48*t49*t50*t8-t142*t50*t8-3.190260000209101
     >         d+0*t112*t138*t140*t50*t8-1.3739974473061137d+2*t13*t134*
     ?         t135*t265*t8+6.380520000418202d+0*t13*t136*t138*t140*t8+4
     @         .579991491020378d+1*t112*t134*t135*t136*t8-4.579991491020
     1         378d+1*t112*t134*t135*t50+9.570780000627304d+0*t10*t266*t
     2         48*t49-t10*t142+3.190260000209101d+0*t10*t112*t138*t140+4
     3         .579991491020378d+1*t13*t134*t135*t136)+1.914156000125460
     4         7d+1*t136*t48*t49*t53*t8-9.570780000627304d+0*t267*t48*t4
     5         9*t50*t8-t143*t50*t8-3.190260000209101d+0*t113*t138*t140*
     6         t50*t8-1.3739974473061137d+2*t134*t135*t14*t265*t8+6.3805
     7         20000418202d+0*t136*t138*t14*t140*t8+4.579991491020378d+1
     8         *t113*t134*t135*t136*t8-4.579991491020378d+1*t113*t134*t1
     9         35*t50+9.570780000627304d+0*t10*t267*t48*t49-t10*t143+3.1
     :         90260000209101d+0*t10*t113*t138*t140+4.579991491020378d+1
     ;         *t134*t135*t136*t14)+1.9141560001254607d+1*t136*t48*t49*t
     <         54*t8-9.570780000627304d+0*t268*t48*t49*t50*t8-t144*t50*t
     =         8-3.190260000209101d+0*t114*t138*t140*t50*t8-1.3739974473
     >         061137d+2*t134*t135*t15*t265*t8+6.380520000418202d+0*t136
     ?         *t138*t140*t15*t8+4.579991491020378d+1*t114*t134*t135*t13
     @         6*t8-4.579991491020378d+1*t114*t134*t135*t50+9.5707800006
     1         27304d+0*t10*t268*t48*t49+4.579991491020378d+1*t134*t135*
     2         t136*t15-t10*t144+3.190260000209101d+0*t10*t114*t138*t140
     3         )+1.9141560001254607d+1*t136*t48*t49*t55*t8-9.57078000062
     4         7304d+0*t269*t48*t49*t50*t8-t145*t50*t8-3.190260000209101
     5         d+0*t115*t138*t140*t50*t8-1.3739974473061137d+2*t134*t135
     6         *t16*t265*t8+6.380520000418202d+0*t136*t138*t140*t16*t8+4
     7         .579991491020378d+1*t115*t134*t135*t136*t8-4.579991491020
     8         378d+1*t115*t134*t135*t50+9.570780000627304d+0*t10*t269*t
     9         48*t49+4.579991491020378d+1*t134*t135*t136*t16-t10*t145+3
     :         .190260000209101d+0*t10*t115*t138*t140)+1.914156000125460
     ;         7d+1*t136*t48*t49*t56*t8-9.570780000627304d+0*t270*t48*t4
     <         9*t50*t8-t146*t50*t8-3.190260000209101d+0*t116*t138*t140*
     =         t50*t8-1.3739974473061137d+2*t134*t135*t17*t265*t8+6.3805
     >         20000418202d+0*t136*t138*t140*t17*t8+4.579991491020378d+1
     ?         *t116*t134*t135*t136*t8-4.579991491020378d+1*t116*t134*t1
     @         35*t50+9.570780000627304d+0*t10*t270*t48*t49+4.5799914910
     1         20378d+1*t134*t135*t136*t17-t10*t146+3.190260000209101d+0
     2         *t10*t116*t138*t140)+1.9141560001254607d+1*t136*t48*t49*t
     3         57*t8-9.570780000627304d+0*t271*t48*t49*t50*t8-t147*t50*t
     4         8-3.190260000209101d+0*t117*t138*t140*t50*t8-1.3739974473
     5         061137d+2*t134*t135*t18*t265*t8+6.380520000418202d+0*t136
     6         *t138*t140*t18*t8+4.579991491020378d+1*t117*t134*t135*t13
     7         6*t8-4.579991491020378d+1*t117*t134*t135*t50+9.5707800006
     8         27304d+0*t10*t271*t48*t49+4.579991491020378d+1*t134*t135*
     9         t136*t18-t10*t147+3.190260000209101d+0*t10*t117*t138*t140
     :         )+1.9141560001254607d+1*t136*t48*t49*t58*t8-9.57078000062
     ;         7304d+0*t272*t48*t49*t50*t8-t148*t50*t8-3.190260000209101
     <         d+0*t118*t138*t140*t50*t8-1.3739974473061137d+2*t134*t135
     =         *t19*t265*t8+6.380520000418202d+0*t136*t138*t140*t19*t8+4
     >         .579991491020378d+1*t118*t134*t135*t136*t8-4.579991491020
     ?         378d+1*t118*t134*t135*t50+9.570780000627304d+0*t10*t272*t
     @         48*t49+4.579991491020378d+1*t134*t135*t136*t19-t10*t148+3
     1         .190260000209101d+0*t10*t118*t138*t140)+1.914156000125460
     2         7d+1*t136*t48*t49*t59*t8-9.570780000627304d+0*t273*t48*t4
     3         9*t50*t8-t149*t50*t8-3.190260000209101d+0*t119*t138*t140*
     4         t50*t8-1.3739974473061137d+2*t134*t135*t20*t265*t8+6.3805
     5         20000418202d+0*t136*t138*t140*t20*t8+4.579991491020378d+1
     6         *t119*t134*t135*t136*t8-4.579991491020378d+1*t119*t134*t1
     7         35*t50+9.570780000627304d+0*t10*t273*t48*t49+4.5799914910
     8         20378d+1*t134*t135*t136*t20-t10*t149+3.190260000209101d+0
     9         *t10*t119*t138*t140)+1.9141560001254607d+1*t136*t48*t49*t
     :         60*t8-9.570780000627304d+0*t274*t48*t49*t50*t8-t150*t50*t
     ;         8-3.190260000209101d+0*t120*t138*t140*t50*t8-1.3739974473
     <         061137d+2*t134*t135*t21*t265*t8+6.380520000418202d+0*t136
     =         *t138*t140*t21*t8+4.579991491020378d+1*t120*t134*t135*t13
     >         6*t8-4.579991491020378d+1*t120*t134*t135*t50+9.5707800006
     ?         27304d+0*t10*t274*t48*t49+4.579991491020378d+1*t134*t135*
     @         t136*t21-t10*t150+3.190260000209101d+0*t10*t120*t138*t140
     1         )
            t494 = -1.243628d-1*t275*t46*t47
            t495 = 4.0d+0*rhoa*t275*t71
            t496 = 2.0d+0*t121*t71
            t497 = 6.218138173930978d-2*rhoa*t81*(1.9141560001254607d+1*
     1         t136*t48*t49*t8*t91+t10*t8*(1.9141560001254607d+1*t136*t4
     2         8*t49*t8*t90+t10*t8*(1.9141560001254607d+1*t136*t48*t49*t
     3         8*t89+t10*t8*(1.9141560001254607d+1*t136*t48*t49*t8*t88+t
     4         10*t8*(1.9141560001254607d+1*t136*t48*t49*t8*t87+t10*t8*(
     5         1.9141560001254607d+1*t136*t48*t49*t8*t86+t10*t8*(1.91415
     6         60001254607d+1*t136*t48*t49*t8*t85+t10*t8*(1.914156000125
     7         4607d+1*t136*t48*t49*t8*t84+t10*t8*(1.9141560001254607d+1
     8         *t136*t48*t49*t8*t83+t10*t8*(1.9141560001254607d+1*t136*t
     9         48*t49*t8*t82+t10*t8*(-1.3739974473061137d+2*t134*t135*t2
     :         65*t29*t8+6.380520000418202d+0*t136*t138*t140*t29*t8+4.57
     ;         9991491020378d+1*t134*t135*t136*t29)-t181*t50*t8-3.190260
     <         000209101d+0*t122*t138*t140*t50*t8-1.3739974473061137d+2*
     =         t134*t135*t265*t30*t8+6.380520000418202d+0*t136*t138*t140
     >         *t30*t8+9.159982982040756d+1*t134*t135*t265*t29*t8+4.5799
     ?         91491020378d+1*t122*t134*t135*t136*t8-4.579991491020378d+
     @         1*t122*t134*t135*t50-9.159982982040756d+1*t134*t135*t264*
     1         t29*t492+4.579991491020378d+1*t134*t135*t136*t30-t10*t181
     2         +3.190260000209101d+0*t10*t122*t138*t140)-9.5707800006273
     3         04d+0*t276*t48*t49*t50*t8-t182*t50*t8-3.190260000209101d+
     4         0*t123*t138*t140*t50*t8-1.3739974473061137d+2*t134*t135*t
     5         265*t31*t8+6.380520000418202d+0*t136*t138*t140*t31*t8+4.5
     6         79991491020378d+1*t123*t134*t135*t136*t8-4.57999149102037
     7         8d+1*t123*t134*t135*t50+9.570780000627304d+0*t10*t276*t48
     8         *t49+4.579991491020378d+1*t134*t135*t136*t31-t10*t182+3.1
     9         90260000209101d+0*t10*t123*t138*t140)-9.570780000627304d+
     :         0*t277*t48*t49*t50*t8-t183*t50*t8-3.190260000209101d+0*t1
     ;         24*t138*t140*t50*t8-1.3739974473061137d+2*t134*t135*t265*
     <         t32*t8+6.380520000418202d+0*t136*t138*t140*t32*t8+4.57999
     =         1491020378d+1*t124*t134*t135*t136*t8-4.579991491020378d+1
     >         *t124*t134*t135*t50+9.570780000627304d+0*t10*t277*t48*t49
     ?         +4.579991491020378d+1*t134*t135*t136*t32-t10*t183+3.19026
     @         0000209101d+0*t10*t124*t138*t140)-9.570780000627304d+0*t2
     1         78*t48*t49*t50*t8-t184*t50*t8-3.190260000209101d+0*t125*t
     2         138*t140*t50*t8-1.3739974473061137d+2*t134*t135*t265*t33*
     3         t8+6.380520000418202d+0*t136*t138*t140*t33*t8+4.579991491
     4         020378d+1*t125*t134*t135*t136*t8-4.579991491020378d+1*t12
     5         5*t134*t135*t50+9.570780000627304d+0*t10*t278*t48*t49+4.5
     6         79991491020378d+1*t134*t135*t136*t33-t10*t184+3.190260000
     7         209101d+0*t10*t125*t138*t140)-9.570780000627304d+0*t279*t
     8         48*t49*t50*t8-t185*t50*t8-3.190260000209101d+0*t126*t138*
     9         t140*t50*t8-1.3739974473061137d+2*t134*t135*t265*t34*t8+6
     :         .380520000418202d+0*t136*t138*t140*t34*t8+4.5799914910203
     ;         78d+1*t126*t134*t135*t136*t8-4.579991491020378d+1*t126*t1
     <         34*t135*t50+9.570780000627304d+0*t10*t279*t48*t49+4.57999
     =         1491020378d+1*t134*t135*t136*t34-t10*t185+3.1902600002091
     >         01d+0*t10*t126*t138*t140)-9.570780000627304d+0*t280*t48*t
     ?         49*t50*t8-t186*t50*t8-3.190260000209101d+0*t127*t138*t140
     @         *t50*t8-1.3739974473061137d+2*t134*t135*t265*t35*t8+6.380
     1         520000418202d+0*t136*t138*t140*t35*t8+4.579991491020378d+
     2         1*t127*t134*t135*t136*t8-4.579991491020378d+1*t127*t134*t
     3         135*t50+9.570780000627304d+0*t10*t280*t48*t49+4.579991491
     4         020378d+1*t134*t135*t136*t35-t10*t186+3.190260000209101d+
     5         0*t10*t127*t138*t140)-9.570780000627304d+0*t281*t48*t49*t
     6         50*t8-t187*t50*t8-3.190260000209101d+0*t128*t138*t140*t50
     7         *t8-1.3739974473061137d+2*t134*t135*t265*t36*t8+6.3805200
     8         00418202d+0*t136*t138*t140*t36*t8+4.579991491020378d+1*t1
     9         28*t134*t135*t136*t8-4.579991491020378d+1*t128*t134*t135*
     :         t50+9.570780000627304d+0*t10*t281*t48*t49+4.5799914910203
     ;         78d+1*t134*t135*t136*t36-t10*t187+3.190260000209101d+0*t1
     <         0*t128*t138*t140)-9.570780000627304d+0*t282*t48*t49*t50*t
     =         8-t188*t50*t8-3.190260000209101d+0*t129*t138*t140*t50*t8-
     >         1.3739974473061137d+2*t134*t135*t265*t37*t8+6.38052000041
     ?         8202d+0*t136*t138*t140*t37*t8+4.579991491020378d+1*t129*t
     @         134*t135*t136*t8-4.579991491020378d+1*t129*t134*t135*t50+
     1         9.570780000627304d+0*t10*t282*t48*t49+4.579991491020378d+
     2         1*t134*t135*t136*t37-t10*t188+3.190260000209101d+0*t10*t1
     3         29*t138*t140)-9.570780000627304d+0*t283*t48*t49*t50*t8-t1
     4         89*t50*t8-3.190260000209101d+0*t130*t138*t140*t50*t8-1.37
     5         39974473061137d+2*t134*t135*t265*t38*t8+6.380520000418202
     6         d+0*t136*t138*t140*t38*t8+4.579991491020378d+1*t130*t134*
     7         t135*t136*t8-4.579991491020378d+1*t130*t134*t135*t50+9.57
     8         0780000627304d+0*t10*t283*t48*t49+4.579991491020378d+1*t1
     9         34*t135*t136*t38-t10*t189+3.190260000209101d+0*t10*t130*t
     :         138*t140)-9.570780000627304d+0*t284*t48*t49*t50*t8-t190*t
     ;         50*t8-3.190260000209101d+0*t131*t138*t140*t50*t8-1.373997
     <         4473061137d+2*t134*t135*t265*t39*t8+6.380520000418202d+0*
     =         t136*t138*t140*t39*t8+4.579991491020378d+1*t131*t134*t135
     >         *t136*t8-4.579991491020378d+1*t131*t134*t135*t50+9.570780
     ?         000627304d+0*t10*t284*t48*t49+4.579991491020378d+1*t134*t
     @         135*t136*t39-t10*t190+3.190260000209101d+0*t10*t131*t138*
     1         t140)
            t498 = 6.218138173930978d-2*t285*t81
            t499 = -6.218138173930978d-2*rhoa*t133*t194*t195
            t500 = 1.2436276347861956d-1*rhoa*t105*t285
            t501 = 6.218138173930978d-2*t105*t133
            t502 = 1.0d+0*((t501+t500+6.218138173930978d-2*rhoa*t133*t22
     1         9)*t93-1.0363563623218294d-2*t133*t197*t81+t499+t498+t497
     2         +t496+t495+t494+t493+2.0d+0*rhoa*t121*t180)*wght
            t503 = 1.0d+0*((6.218138173930978d-2*rhoa*t108*t285+6.218138
     1         173930978d-2*rhoa*t133*t245+3.109069086965489d-2*t108*t13
     2         3)*t93-6.218138173930978d-2*rhoa*t105*t108*t133*t194)*wgh
     3         t
            t504 = 1.0d+0*((6.218138173930978d-2*rhoa*t110*t285+6.218138
     1         173930978d-2*rhoa*t133*t252+3.109069086965489d-2*t110*t13
     2         3)*t93-6.218138173930978d-2*rhoa*t105*t110*t133*t194)*wgh
     3         t
            t505 = 6.218138173930978d-2*rhoa*t133*t258*t93*wght-6.218138
     1         173930978d-2*rhoa*t133*t194*t254*wght
            t506 = 6.218138173930978d-2*rhoa*t133*t260*t93*wght-6.218138
     1         173930978d-2*rhoa*t108*t110*t133*t194*wght
            t507 = 1.0d+0*(6.218138173930978d-2*rhoa*(t10*t8*(t10*t8*(t1
     1         0*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10
     2         *t8*(-6*t265*t29*t8-6*t136*t29)-3*t299*t50*t8-6*t265*t30*
     3         t8+6*t122*t136*t8+6*t122*t50-6*t136*t30-3*t10*t299)-3*t30
     4         0*t50*t8-6*t265*t31*t8+6*t123*t136*t8+6*t123*t50-6*t136*t
     5         31-3*t10*t300)-3*t301*t50*t8-6*t265*t32*t8+6*t124*t136*t8
     6         +6*t124*t50-6*t136*t32-3*t10*t301)-3*t302*t50*t8-6*t265*t
     7         33*t8+6*t125*t136*t8+6*t125*t50-6*t136*t33-3*t10*t302)-3*
     8         t303*t50*t8-6*t265*t34*t8+6*t126*t136*t8+6*t126*t50-6*t13
     9         6*t34-3*t10*t303)-3*t304*t50*t8-6*t265*t35*t8+6*t127*t136
     :         *t8+6*t127*t50-6*t136*t35-3*t10*t304)-3*t305*t50*t8-6*t26
     ;         5*t36*t8+6*t128*t136*t8+6*t128*t50-6*t136*t36-3*t10*t305)
     <         -3*t306*t50*t8-6*t265*t37*t8+6*t129*t136*t8+6*t129*t50-6*
     =         t136*t37-3*t10*t306)-3*t307*t50*t8-6*t265*t38*t8+6*t130*t
     >         136*t8+6*t130*t50-6*t136*t38-3*t10*t307)-3*t308*t50*t8-6*
     ?         t265*t39*t8+6*t131*t136*t8+6*t131*t50-6*t136*t39-3*t10*t3
     @         08)*t81-1.243628d-1*rhoa*t46*t47*(t10*t8*(t10*t8*(t10*t8*
     1         (t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(t10*t8*(
     2         -6*t11*t265*t8-6*t11*t136)-3*t289*t50*t8-6*t12*t265*t8+6*
     3         t111*t136*t8+6*t111*t50-3*t10*t289-6*t12*t136)-3*t290*t50
     4         *t8-6*t13*t265*t8+6*t112*t136*t8+6*t112*t50-3*t10*t290-6*
     5         t13*t136)-3*t291*t50*t8-6*t14*t265*t8+6*t113*t136*t8+6*t1
     6         13*t50-3*t10*t291-6*t136*t14)-3*t292*t50*t8-6*t15*t265*t8
     7         +6*t114*t136*t8+6*t114*t50-3*t10*t292-6*t136*t15)-3*t293*
     8         t50*t8-6*t16*t265*t8+6*t115*t136*t8+6*t115*t50-3*t10*t293
     9         -6*t136*t16)-3*t294*t50*t8-6*t17*t265*t8+6*t116*t136*t8+6
     :         *t116*t50-3*t10*t294-6*t136*t17)-3*t295*t50*t8-6*t18*t265
     ;         *t8+6*t117*t136*t8+6*t117*t50-3*t10*t295-6*t136*t18)-3*t2
     <         96*t50*t8-6*t19*t265*t8+6*t118*t136*t8+6*t118*t50-3*t10*t
     =         296-6*t136*t19)-3*t297*t50*t8-6*t20*t265*t8+6*t119*t136*t
     >         8+6*t119*t50-3*t10*t297-6*t136*t20)-3*t298*t50*t8-6*t21*t
     ?         265*t8+6*t120*t136*t8+6*t120*t50-3*t10*t298-6*t136*t21))*
     @         wght
            fnc(iq) = 1.0d+0*(6.218138173930978d-2*rhoa*log(1.0811057476
     1         031892d-1*gammaaa*t24*(t26+1.0d+0)/(1.1687896375006504d-2
     2         *t27/t25**2.0d+0+t26+1.0d+0)+1.0d+0)*t40-1.243628d-1*rhoa
     3         *t22*t4*t6)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(6.218138173930978d-2*rhoa*t105*t40*
     1         t93+6.218138173930978d-2*rhoa*t81*t92+3.109069086965489d-
     2         2*t40*t81+2.0d+0*rhoa*t22*t71-1.243628d-1*rhoa*t46*t47*t6
     3         1-6.21814d-2*t22*t46*t47)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 6.218138173930978d-2*rhoa*t108*t40*t93*wgh
     1         t+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 6.218138173930978d-2*rhoa*t110*t40*t93*wgh
     1         t+Cmat(iq,D1_GAB)
            Mmat(iq,D1_TA) = 1.0d+0*(6.218138173930978d-2*rhoa*t133*t81-
     1         1.243628d-1*rhoa*t121*t46*t47)*wght+Mmat(iq,D1_TA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(t230*t93-1.0363563623218294d-2*
     1         t197*t40*t81+2.0d+0*rhoa*t180*t22+t196+t193+t192+t155+t15
     2         4+t153+t152)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*(t240*t93+1.0363563623218296d-2*
     1         t197*t40*t81+2.0d+0*rhoa*t22*t231+t196+t193+t192+t155+t15
     2         4+t153+t152)*wght+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = t247+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = 1.0d+0*(t253*t93-6.218138173930978d-2*
     1         rhoa*t105*t110*t194*t40)*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t247+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = t259+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = 6.218138173930978d-2*rhoa*t260*t40*t9
     1         3*wght-6.218138173930978d-2*rhoa*t108*t110*t194*t40*wght+
     2         Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t259+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 6.218138173930978d-2*rhoa*t263*t40*t9
     1         3*wght-6.218138173930978d-2*rhoa*t194*t261*t40*wght+Cmat2
     2         (iq,D2_GAB_GAB)
            Mmat2(iq,D2_RA_TA) = t286+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = t286+Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = t288+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = t288+Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = 6.218138173930978d-2*rhoa*t110*t287*t9
     1         3*wght+Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_TA_TA) = t309+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = t309+Mmat2(iq,D2_TA_TB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(t93*(6.218138173930978d-2*rh
     1         oa*t40*(-3.153225097175971d-2*gammaaa*t202*t79*t95*t99+3.
     2         6036858253439635d-2*gammaaa*t166*t24*t79*t99+6.6217727040
     3         69536d-1*gammaaa*t106*t200*t79*t99-3.243317242809568d-1*g
     4         ammaaa*t100*t228*t24*t99-3.783870116611163d-1*gammaaa*t22
     5         1*t79*t94*t95+3.783870116611163d-1*gammaaa*t100*t228*t76*
     6         t94*t95-3.766352199404629d-2*gammaaa*t339*t76*t79*t95+3.1
     7         53225097175971d-2*gammaaa*t100*t104*t202*t76*t95-1.081105
     8         7476031893d-1*gammaaa*t100*t24*t76*(1.6363054925009113d-1
     9         *t101*t102*t103*t216*t72*t94-1.723423608999802d-2*t101*t1
     :         02*t339*t77-7.791930916671007d-3*t27*t317*t77+2.255574781
     ;         0186078d+0*t103*t216*t27*t71*t72+5.012388402263571d-1*t10
     <         3*t166*t27*t71*t72-4.385839851980629d-1*t101*t102*t103*t2
     =         02*t71*t72-2.337579275001302d-2*t103*t27*t356*t72-6.76672
     >         4343055823d+0*t216*t219*t226*t27*t71+t372+t371+t370+t369+
     ?         t368+t367+t366+t365+t363+t361+t360+t359+t358+t357+t355+t3
     @         54+t352+t351+t350+t349+t348+t347+t346+t345)-3.60368582534
     1         3965d-2*gammaaa*t24*t317*t76*t79+1.0811057476031893d-1*ga
     2         mmaaa*t24*(t363+t361+t360+t359+t358+t357+t355+t354+t352+t
     3         351+t350+t349+t348+t347+t346+t345)*t79+6.486634485619136d
     4         -1*gammaaa*t104*t207*t228*t24*t76-3.6036858253439635d-2*g
     5         ammaaa*t100*t104*t166*t24*t76-6.621772704069536d-1*gammaa
     6         a*t100*t104*t106*t200*t76+t344+t342+t341+t340+t338+t336-3
     7         .243317242809568d-1*gammaaa*t100*t104*t221*t24)+1.8654414
     8         521792934d-1*rhoa*t229*t92+9.327207260896466d-2*t229*t40-
     9         3.1090690869654886d-2*t105*t197*t40+t334+t333)-3.10906908
     :         69654886d-2*t197*t81*t92+1.554534543482745d-2*t166*t40*t8
     ;         1+6.0d+0*rhoa*t180*t61+t194*(-1.2436276347861956d-1*rhoa*
     <         t105*t229*t40+t375+t374+t373)+t332+t330+t329+2.0d+0*rhoa*
     =         t22*t328+t315+t314+t313+t312+3.0d+0*t180*t22)*wght+Amat3(
     >         iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*(t93*(6.218138173930978d-2*rh
     1         oa*t40*(-3.1532250971759707d-2*gammaaa*t202*t79*t95*t99-1
     2         .2012286084479881d-2*gammaaa*t166*t24*t79*t99+6.621772704
     3         069535d-1*gammaaa*t106*t200*t79*t99-2.1622114952063787d-1
     4         *gammaaa*t100*t238*t24*t99-1.0811057476031893d-1*gammaaa*
     5         t100*t228*t24*t99-2.5225800777407753d-1*gammaaa*t237*t79*
     6         t94*t95-1.2612900388703877d-1*gammaaa*t221*t79*t94*t95+2.
     7         5225800777407753d-1*gammaaa*t100*t238*t76*t94*t95+1.26129
     8         00388703877d-1*gammaaa*t100*t228*t76*t94*t95+1.8393813066
     9         859827d-2*gammaaa*t339*t76*t79*t95+3.1532250971759707d-2*
     :         gammaaa*t100*t104*t202*t76*t95-1.0811057476031893d-1*gamm
     ;         aaa*t100*t24*t76*(1.0908703283339408d-1*t101*t102*t103*t2
     <         34*t72*t94+5.454351641669704d-2*t101*t102*t103*t216*t72*t
     =         94+7.00732676186733d-3*t101*t102*t339*t77+2.5973103055570
     >         03d-3*t27*t317*t77+1.503716520679072d+0*t103*t234*t27*t71
     ?         *t72+7.518582603395361d-1*t103*t216*t27*t71*t72-1.6707961
     @         340878583d-1*t103*t166*t27*t71*t72-4.3858398519806285d-1*
     1         t101*t102*t103*t202*t71*t72-2.337579275001302d-2*t103*t27
     2         *t384*t72-4.5111495620372155d+0*t219*t226*t234*t27*t71-2.
     3         2555747810186078d+0*t216*t219*t226*t27*t71+t389+t388+t387
     4         +t386+t385+t383+t382+t381+t380+t379+t378+t377+t372+t371+t
     5         370+t369+t368+t367+t366+t365+t363+t360+t359+t354+t351+t34
     6         6+t345)+1.2012286084479884d-2*gammaaa*t24*t317*t76*t79+1.
     7         0811057476031893d-1*gammaaa*t24*(t389+t388+t387+t386+t385
     8         +t383+t382+t381+t380+t379+t378+t377+t363+t360+t359+t354+t
     9         351+t346+t345)*t79+4.3244229904127574d-1*gammaaa*t104*t20
     :         7*t238*t24*t76+2.1622114952063787d-1*gammaaa*t104*t207*t2
     ;         28*t24*t76+1.2012286084479881d-2*gammaaa*t100*t104*t166*t
     <         24*t76-6.621772704069535d-1*gammaaa*t100*t104*t106*t200*t
     =         76+t344+t342+t341+t340+t338+t336-2.1622114952063787d-1*ga
     >         mmaaa*t100*t104*t237*t24-1.0811057476031893d-1*gammaaa*t1
     ?         00*t104*t221*t24)+1.2436276347861956d-1*rhoa*t239*t92+6.2
     @         18138173930978d-2*rhoa*t229*t92+6.218138173930978d-2*t239
     1         *t40+3.109069086965489d-2*t229*t40+1.0363563623218297d-2*
     2         t105*t197*t40+t334+t333)+1.0363563623218297d-2*t197*t81*t
     3         92-5.181781811609151d-3*t166*t40*t81+4.0d+0*rhoa*t231*t61
     4         +2.0d+0*rhoa*t180*t61+t194*(-1.2436276347861956d-1*rhoa*t
     5         105*t239*t40+t375+t374+t373)+2.0d+0*rhoa*t22*t376+t332+t3
     6         30+t329+t315+t314+t313+t312+2.0d+0*t22*t231+1.0d+0*t180*t
     7         22)*wght+Amat3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = t428+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = 1.0d+0*((6.218138173930978d-2*rhoa*
     1         t40*(6.00614304223994d-3*t166*t24*t76*t79+6.4932757638925
     2         03d-4*gammaaa*t106*t166*t74*t79+1.0811057476031893d-1*gam
     3         maaa*t24*(t461+t460+t459+t458+t457+t456+t455)*t79+5.40552
     4         8738015947d-2*t221*t24*t79-1.0811057476031893d-1*gammaaa*
     5         t100*t24*t76*(2.597310305557001d-3*gammaaa*t106*t166*t77-
     6         2.337579275001302d-2*gammaaa*t103*t106*t216*t72-2.4182745
     7         359105678d+1*gammaaa*t103*t106*t214*t72+t465+t464+t463+t4
     8         62+t461+t460+t459+t458+t457+t456+t455)+2.1622114952063787
     9         d-1*gammaaa*t109*t207*t228*t24*t76-5.405528738015947d-2*t
     :         100*t228*t24*t76-1.2012286084479878d-2*gammaaa*t100*t109*
     ;         t166*t24*t76-5.843948187503255d-3*gammaaa*t100*t106*t228*
     <         t74+t454+t453+t452+t451+t450+t449+t448+t447+t446+t445+t44
     =         4+t443+t442+t441+t440+t439+t438+t437+t436+t435+t434-1.081
     >         1057476031893d-1*gammaaa*t100*t109*t221*t24)+t433+t432+t4
     ?         31+t430-1.0363563623218294d-2*t110*t197*t40)*t93+t194*(t4
     @         66-t110*t230)+t429)*wght+Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = t428+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = 1.0d+0*((6.218138173930978d-2*rhoa*
     1         t40*(-3.00307152111997d-3*t166*t24*t76*t79-3.246637881946
     2         2527d-4*gammaaa*t106*t166*t74*t79+1.0811057476031893d-1*g
     3         ammaaa*t24*(t470+t469+t468+t467+t419+t417+t416)*t79+2.702
     4         7643690079733d-2*t237*t24*t79-1.0811057476031893d-1*gamma
     5         aa*t100*t24*t76*(-1.2986551527785012d-3*gammaaa*t106*t166
     6         *t77-1.168789637500651d-2*gammaaa*t103*t106*t234*t72-1.20
     7         9137267955284d+1*gammaaa*t103*t106*t214*t72+t470+t469+t46
     8         8+t467+t426+t425+t424+t423+t419+t417+t416)+2.162211495206
     9         3787d-1*gammaaa*t107*t207*t238*t24*t76-2.7027643690079733
     :         d-2*t100*t238*t24*t76+1.201228608447988d-2*gammaaa*t100*t
     ;         107*t166*t24*t76-2.9219740937516275d-3*gammaaa*t100*t106*
     <         t238*t74+t415+t414+t413+t412+t411+t410+t409+t408+t407+t40
     =         6+t405+t404+t403+t402+t401+t400+t399+t398+t397+t396+t395-
     >         1.0811057476031893d-1*gammaaa*t100*t107*t237*t24)+1.03635
     ?         63623218296d-2*t108*t197*t40+t394+t393+t392+t391)*t93+t19
     @         4*(t427-t108*t240)+t390)*wght+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = 1.0d+0*((6.218138173930978d-2*rhoa*
     1         t40*(-6.00614304223994d-3*t166*t24*t76*t79-6.493275763892
     2         505d-4*gammaaa*t106*t166*t74*t79+1.0811057476031893d-1*ga
     3         mmaaa*t24*(t474+t473+t472+t471+t458+t456+t455)*t79+5.4055
     4         28738015947d-2*t237*t24*t79-1.0811057476031893d-1*gammaaa
     5         *t100*t24*t76*(-2.5973103055570024d-3*gammaaa*t106*t166*t
     6         77-2.337579275001302d-2*gammaaa*t103*t106*t234*t72-2.4182
     7         74535910568d+1*gammaaa*t103*t106*t214*t72+t474+t473+t472+
     8         t471+t465+t464+t463+t462+t458+t456+t455)+2.16221149520637
     9         87d-1*gammaaa*t109*t207*t238*t24*t76-5.405528738015947d-2
     :         *t100*t238*t24*t76+1.201228608447988d-2*gammaaa*t100*t109
     ;         *t166*t24*t76-5.843948187503255d-3*gammaaa*t100*t106*t238
     <         *t74+t454+t453+t452+t451+t450+t449+t448+t447+t446+t445+t4
     =         44+t443+t442+t441+t440+t439+t438+t437+t436+t435+t434-1.08
     >         11057476031893d-1*gammaaa*t100*t109*t237*t24)+t433+t432+t
     ?         431+t430+1.0363563623218296d-2*t110*t197*t40)*t93+t194*(t
     @         466-t110*t240)+t429)*wght+Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = t483+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = 1.0d+0*(t194*(t486-6.2181381739309
     1         78d-2*rhoa*t108*t252*t40-t110*t246)+t485+t484)*wght+Cmat3
     2         (iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = t483+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = 1.0d+0*(t93*(6.218138173930978d-2*
     1         rhoa*t40*(-6.317925974205011d-4*gammaaa*t100*t222*t77*t99
     2         +2.1622114952063787d-1*gammaaa*t207*t24*t262*t99-1.081105
     3         7476031893d-1*t100*t109*t24*t99-2.5225800777407753d-1*gam
     4         maaa*t207*t262*t76*t94*t95+1.2612900388703877d-1*t100*t10
     5         9*t76*t94*t95-1.0811057476031893d-1*gammaaa*t100*t24*t76*
     6         (3.7592913016976803d-1*t103*t106*t71*t72-1.36358791041742
     7         6d-2*t102*t77*t94)-6.817939552087132d-3*t102*t74*t79*t94+
     8         7.370913636572511d-4*gammaaa*t100*t364*t76*t77*t94+1.3635
     9         879104174264d-2*gammaaa*t100*t102*t109*t74*t94+1.08110574
     :         76031893d-1*t24*t250*t79+1.2635851948410023d-3*gammaaa*t1
     ;         04*t207*t222*t76*t77-6.486634485619136d-1*gammaaa*t104*t2
     <         4*t262*t343*t76+4.3244229904127574d-1*gammaaa*t109*t207*t
     =         24*t251*t76-1.0811057476031893d-1*t100*t24*t251*t76+2.162
     >         2114952063787d-1*t104*t109*t207*t24*t76-1.168789637500651
     ?         d-2*gammaaa*t100*t106*t251*t74+2.337579275001302d-2*gamma
     @         aa*t104*t106*t109*t207*t74-5.843948187503255d-3*t100*t104
     1         *t106*t74-2.1622114952063787d-1*gammaaa*t100*t109*t24*t25
     2         0)+6.218138173930978d-2*rhoa*t263*t92+3.109069086965489d-
     3         2*t263*t40)+t194*(-6.218138173930978d-2*rhoa*t105*t263*t4
     4         0-6.218138173930978d-2*rhoa*t110*t252*t40-t110*t253)+1.24
     5         36276347861956d-1*rhoa*t105*t261*t331*t40)*wght+Cmat3(iq,
     6         D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = 1.0d+0*(t194*(t486-6.2181381739309
     1         78d-2*rhoa*t110*t245*t40-t108*t253)+t485+t484)*wght+Cmat3
     2         (iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = t483+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = t488+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t491+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t488+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = t194*(-6.218138173930978d-2*rhoa*
     1         t108*t263*t40*wght-1.2436276347861956d-1*rhoa*t110*t260*t
     2         40*wght)+6.218138173930978d-2*rhoa*t40*(1.263585194841002
     3         3d-3*gammaaa*t109*t207*t222*t76*t77-4.738444480653759d-4*
     4         t100*t222*t76*t77-6.486634485619136d-1*gammaaa*t107*t24*t
     5         262*t343*t76+5.405528738015947d-2*t207*t24*t262*t76+2.162
     6         2114952063787d-1*t107*t109*t207*t24*t76+5.843948187503255
     7         d-3*gammaaa*t106*t207*t262*t74+2.337579275001302d-2*gamma
     8         aa*t106*t107*t109*t207*t74-5.843948187503255d-3*t100*t106
     9         *t109*t74+t490+t489-5.122759562733387d-5*gammaaa*t100*t10
     :         3*t487)*t93*wght+1.2436276347861956d-1*rhoa*t108*t261*t33
     ;         1*t40*wght+Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = t491+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = 6.218138173930978d-2*rhoa*t40*(3.
     1         7907555845230073d-3*gammaaa*t109*t207*t222*t76*t77-9.4768
     2         88961307518d-4*t100*t222*t76*t77-6.486634485619136d-1*gam
     3         maaa*t109**3*t24*t343*t76+3.243317242809568d-1*t207*t24*t
     4         262*t76+3.5063689125019526d-2*gammaaa*t106*t207*t262*t74-
     5         1.7531844562509763d-2*t100*t106*t109*t74-1.02455191254667
     6         73d-4*gammaaa*t100*t103*t487)*t93*wght+1.2436276347861956
     7         d-1*rhoa*t110**3*t331*t40*wght-1.8654414521792934d-1*rhoa
     8         *t110*t194*t263*t40*wght+Cmat3(iq,D3_GAB_GAB_GAB)
            Mmat3(iq,D3_RA_RA_TA) = t502+Mmat3(iq,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = t502+Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_RB_TA) = 1.0d+0*((t501+t500+6.218138173930978
     1         d-2*rhoa*t133*t239)*t93+1.0363563623218296d-2*t133*t197*t
     2         81+t499+t498+t497+t496+t495+t494+t493+2.0d+0*rhoa*t121*t2
     3         31)*wght+Mmat3(iq,D3_RA_RB_TA)
            Mmat3(iq,D3_RA_GAA_TA) = t503+Mmat3(iq,D3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = t503+Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_RA_GAB_TA) = t504+Mmat3(iq,D3_RA_GAB_TA)
            Mmat3(iq,D3_RA_GAB_TB) = t504+Mmat3(iq,D3_RA_GAB_TB)
            Mmat3(iq,D3_RA_GBB_TA) = t503+Mmat3(iq,D3_RA_GBB_TA)
            Mmat3(iq,D3_RA_GBB_TB) = t503+Mmat3(iq,D3_RA_GBB_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = t505+Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = t505+Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_GAA_GAB_TA) = t506+Mmat3(iq,D3_GAA_GAB_TA)
            Mmat3(iq,D3_GAA_GAB_TB) = t506+Mmat3(iq,D3_GAA_GAB_TB)
            Mmat3(iq,D3_GAA_GBB_TA) = t505+Mmat3(iq,D3_GAA_GBB_TA)
            Mmat3(iq,D3_GAB_GAB_TA) = 6.218138173930978d-2*rhoa*t133*t26
     1         3*t93*wght-6.218138173930978d-2*rhoa*t133*t194*t261*wght+
     2         Mmat3(iq,D3_GAB_GAB_TA)
            Mmat3(iq,D3_TA_TA_TA) = t507+Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = t507+Mmat3(iq,D3_TA_TA_TB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = 1/t2
            t4 = 1.325688999052018d-1*t3+1.0d+0
            t5 = t2**5.0d-1
            t6 = 1/t5
            t7 = 2.4141993114533214d-2*t6+1.0186556948d-1
            t8 = 7.876233178997433d-1*t6*t7+2.2308199064d-1
            t9 = 7.876233178997433d-1*t6*t8+4.7231125998d-1
            t10 = 1/t9
            t11 = 1.269642451250142d+0*t10*t5+1.0d+0
            t12 = log(t11)
            t13 = rhoa-rhob
            t14 = 1/t1
            t15 = 1.0d+0-t13*t14
            t16 = t15**1.3333333333333333d+0
            t17 = t13*t14+1.0d+0
            t18 = t17**1.3333333333333333d+0
            t19 = 1.923661050931536d+0*t18+1.923661050931536d+0*t16-3.84
     1         7322101863072d+0
            t20 = 6.901399211255826d-2*t3+1.0d+0
            t21 = 1.3212998810398843d-2*t6+2.9729725188d-2
            t22 = 7.876233178997433d-1*t21*t6+1.2236585478d-1
            t23 = 7.876233178997433d-1*t22*t6+3.497952466d-1
            t24 = 1/t23
            t25 = 1.269642451250142d+0*t24*t5+1.0d+0
            t26 = log(t25)
            t27 = t13**4
            t28 = 1/t1**4
            t29 = 1.2746961887000874d-1*t3+1.0d+0
            t30 = 1.530901310039024d-2*t6+1.0465751434d-1
            t31 = 7.876233178997433d-1*t30*t6+1.9269083139d-1
            t32 = 7.876233178997433d-1*t31*t6+4.3896648423d-1
            t33 = 1/t32
            t34 = 1.269642451250142d+0*t33*t5+1.0d+0
            t35 = log(t34)
            t36 = 1.709920934161365d+0*(6.21814d-2*t12*t4-3.10907d-2*t29
     1         *t35)-3.37738d-2*t20*t26
            t37 = t27*t28*t36+3.37738d-2*t20*t26
            t38 = 5.848223622634648d-1*t19*t37-6.21814d-2*t12*t4
            t39 = 2.871234000188191d+0*t1**1.6666666666666669d+0
            t40 = -taub-taua+t39
            t41 = taub+taua+t39
            t42 = 1/t41
            t43 = param(12)
            t44 = t40*t42*t43+param(11)
            t45 = t40*t42*t44+param(10)
            t46 = t40*t42*t45+param(9)
            t47 = t40*t42*t46+param(8)
            t48 = t40*t42*t47+param(7)
            t49 = t40*t42*t48+param(6)
            t50 = t40*t42*t49+param(5)
            t51 = t40*t42*t50+param(4)
            t52 = t40*t42*t51+param(3)
            t53 = t40*t42*t52+param(2)
            t54 = t40*t42*t53+param(1)
            t55 = t15**6.666666666666666d-1
            t56 = t17**6.666666666666666d-1
            t57 = 5.0d-1*t56+5.0d-1*t55
            t58 = t57**3.0d+0
            t59 = gammabb+2.0d+0*gammaab+gammaaa
            t60 = t1**1.1666666666666667d+0
            t61 = 1/t60**2.0d+0
            t62 = t57**2.0d+0
            t63 = 1/t62
            t64 = 1/t58
            t65 = exp(-3.216396844291483d+1*t38*t64)
            t66 = t65-1.0d+0
            t67 = 1/t66
            t68 = 1.3621078885675922d-1*t59*t61*t63*t67
            t69 = t68+1.0d+0
            t70 = 1/t57**4.0d+0
            t71 = (t59*t61)**2.0d+0
            t72 = 1/t66**2.0d+0
            t73 = 1.855337900098064d-2*t70*t71*t72+t68+1.0d+0
            t74 = 1/t73
            t75 = 1.3621078885675922d-1*t59*t61*t63*t69*t74+1.0d+0
            t76 = log(t75)
            t77 = param(14)
            t78 = param(24)
            t79 = t40*t42*t78+param(23)
            t80 = t40*t42*t79+param(22)
            t81 = t40*t42*t80+param(21)
            t82 = t40*t42*t81+param(20)
            t83 = t40*t42*t82+param(19)
            t84 = t40*t42*t83+param(18)
            t85 = t40*t42*t84+param(17)
            t86 = t40*t42*t85+param(16)
            t87 = t40*t42*t86+param(15)
            t88 = t40*t42*t87+t77
            t89 = t40*t42*t88+param(13)
            t90 = t1**6.666666666666666d-1
            t91 = 1/t41**2
            t92 = 4.785390000313652d+0*t42*t43*t90-4.785390000313652d+0*
     1         t40*t43*t90*t91
            t93 = t40*t42*t92-4.785390000313652d+0*t40*t44*t90*t91+4.785
     1         390000313652d+0*t42*t44*t90
            t94 = t40*t42*t93-4.785390000313652d+0*t40*t45*t90*t91+4.785
     1         390000313652d+0*t42*t45*t90
            t95 = t40*t42*t94-4.785390000313652d+0*t40*t46*t90*t91+4.785
     1         390000313652d+0*t42*t46*t90
            t96 = t40*t42*t95-4.785390000313652d+0*t40*t47*t90*t91+4.785
     1         390000313652d+0*t42*t47*t90
            t97 = t40*t42*t96-4.785390000313652d+0*t40*t48*t90*t91+4.785
     1         390000313652d+0*t42*t48*t90
            t98 = t40*t42*t97-4.785390000313652d+0*t40*t49*t90*t91+4.785
     1         390000313652d+0*t42*t49*t90
            t99 = t40*t42*t98-4.785390000313652d+0*t40*t50*t90*t91+4.785
     1         390000313652d+0*t42*t50*t90
            t100 = t40*t42*t99-4.785390000313652d+0*t40*t51*t90*t91+4.78
     1         5390000313652d+0*t42*t51*t90
            t101 = -4.785390000313652d+0*t40*t52*t90*t91+4.7853900003136
     1         52d+0*t42*t52*t90+t100*t40*t42
            t102 = -4.785390000313652d+0*t40*t53*t90*t91+4.7853900003136
     1         52d+0*t42*t53*t90+t101*t40*t42
            t103 = 1.0d+0*t1*t102*t38
            t104 = 1/t1**1.3333333333333336d+0
            t105 = 1/t1**6.666666666666667d-1
            t106 = 1/t5**3
            t107 = -1.3127055298329054d-1*t105*t106*t7-3.169132786263567
     1         d-3*t104
            t108 = 7.876233178997433d-1*t107*t6-1.3127055298329054d-1*t1
     1         05*t106*t8
            t109 = 1/t9**2
            t110 = 2.11607075208357d-1*t10*t105*t6-1.269642451250142d+0*
     1         t108*t109*t5
            t111 = 1/t11
            t112 = -6.21814d-2*t110*t111*t4
            t113 = 1/t1**1.3333333333333333d+0
            t114 = 2.747773264188438d-3*t113*t12
            t115 = -1.3127055298329054d-1*t105*t106*t21-1.73447766040861
     1         62d-3*t104
            t116 = 7.876233178997433d-1*t115*t6-1.3127055298329054d-1*t1
     1         05*t106*t22
            t117 = 1/t23**2
            t118 = 2.11607075208357d-1*t105*t24*t6-1.269642451250142d+0*
     1         t116*t117*t5
            t119 = 1/t25
            t120 = 3.37738d-2*t118*t119*t20
            t121 = -7.769549222703733d-4*t113*t26
            t122 = -1.3127055298329054d-1*t105*t106*t30-2.00962261531666
     1         58d-3*t104
            t123 = 7.876233178997433d-1*t122*t6-1.3127055298329054d-1*t1
     1         05*t106*t31
            t124 = 1/t32**2
            t125 = 2.11607075208357d-1*t105*t33*t6-1.269642451250142d+0*
     1         t123*t124*t5
            t126 = 1/t34
            t127 = 1.709920934161365d+0*(6.21814d-2*t110*t111*t4+1.32103
     1         98931339265d-3*t113*t35-3.10907d-2*t125*t126*t29-2.747773
     2         264188438d-3*t113*t12)+7.769549222703733d-4*t113*t26-3.37
     3         738d-2*t118*t119*t20
            t128 = t127*t27*t28
            t129 = 1/t1**5
            t130 = -4*t129*t27*t36
            t131 = t13**3
            t132 = 4*t131*t28*t36+t130+t128+t121+t120
            t133 = t1**2
            t134 = 1/t133
            t135 = t13*t134
            t136 = -t14
            t137 = t136+t135
            t138 = t15**3.333333333333333d-1
            t139 = -t13*t134
            t140 = t14+t139
            t141 = t17**3.333333333333333d-1
            t142 = 2.564881401242048d+0*t140*t141+2.564881401242048d+0*t
     1         137*t138
            t143 = 5.848223622634648d-1*t142*t37+5.848223622634648d-1*t1
     1         32*t19+t114+t112
            t144 = 1.0d+0*t38*t54
            t145 = 4.785390000313652d+0*t42*t78*t90-4.785390000313652d+0
     1         *t40*t78*t90*t91
            t146 = -4.785390000313652d+0*t40*t79*t90*t91+4.7853900003136
     1         52d+0*t42*t79*t90+t145*t40*t42
            t147 = -4.785390000313652d+0*t40*t80*t90*t91+4.7853900003136
     1         52d+0*t42*t80*t90+t146*t40*t42
            t148 = -4.785390000313652d+0*t40*t81*t90*t91+4.7853900003136
     1         52d+0*t42*t81*t90+t147*t40*t42
            t149 = -4.785390000313652d+0*t40*t82*t90*t91+4.7853900003136
     1         52d+0*t42*t82*t90+t148*t40*t42
            t150 = -4.785390000313652d+0*t40*t83*t90*t91+4.7853900003136
     1         52d+0*t42*t83*t90+t149*t40*t42
            t151 = -4.785390000313652d+0*t40*t84*t90*t91+4.7853900003136
     1         52d+0*t42*t84*t90+t150*t40*t42
            t152 = -4.785390000313652d+0*t40*t85*t90*t91+4.7853900003136
     1         52d+0*t42*t85*t90+t151*t40*t42
            t153 = -4.785390000313652d+0*t40*t86*t90*t91+4.7853900003136
     1         52d+0*t42*t86*t90+t152*t40*t42
            t154 = -4.785390000313652d+0*t40*t87*t90*t91+4.7853900003136
     1         52d+0*t42*t87*t90+t153*t40*t42
            t155 = -4.785390000313652d+0*t40*t88*t90*t91+4.7853900003136
     1         52d+0*t42*t88*t90+t154*t40*t42
            t156 = 3.109069086965489d-2*t1*t155*t58*t76
            t157 = 1/t75
            t158 = 1/t138
            t159 = 1/t141
            t160 = 3.333333333333333d-1*t140*t159+3.333333333333333d-1*t
     1         137*t158
            t161 = t1**1.6666666666666674d-1
            t162 = 1/t60**3.0d+0
            t163 = -3.1782517399910487d-1*t161*t162*t59*t63*t69*t74
            t164 = -2.7242157771351844d-1*t160*t59*t61*t64*t67
            t165 = -3.1782517399910487d-1*t161*t162*t59*t63*t67
            t166 = 1/t66**2
            t167 = 9.649190532874448d+1*t160*t38*t70-3.216396844291483d+
     1         1*t143*t64
            t168 = -1.3621078885675922d-1*t166*t167*t59*t61*t63*t65
            t169 = t168+t165+t164
            t170 = 1/t73**2
            t171 = t59**2
            t172 = 1/t60**5.0d+0
            t173 = -8.658243533790966d-2*t161*t171*t172*t70*t72
            t174 = 1/t57**5.0d+0
            t175 = 1/t66**3.0d+0
            t176 = -7.421351600392256d-2*t160*t174*t71*t72-3.71067580019
     1         6128d-2*t167*t175*t65*t70*t71+t173+t168+t165+t164
            t177 = -2.7242157771351844d-1*t160*t59*t61*t64*t69*t74+1.362
     1         1078885675922d-1*t169*t59*t61*t63*t74-1.3621078885675922d
     2         -1*t170*t176*t59*t61*t63*t69+t163
            t178 = 3.109069086965489d-2*t58*t76*t89
            t179 = -4*t131*t28*t36+t130+t128+t121+t120
            t180 = t14+t135
            t181 = t139+t136
            t182 = 2.564881401242048d+0*t141*t181+2.564881401242048d+0*t
     1         138*t180
            t183 = 5.848223622634648d-1*t182*t37+5.848223622634648d-1*t1
     1         79*t19+t114+t112
            t184 = 3.333333333333333d-1*t159*t181+3.333333333333333d-1*t
     1         158*t180
            t185 = -2.7242157771351844d-1*t184*t59*t61*t64*t67
            t186 = 9.649190532874448d+1*t184*t38*t70-3.216396844291483d+
     1         1*t183*t64
            t187 = -1.3621078885675922d-1*t166*t186*t59*t61*t63*t65
            t188 = t187+t185+t165
            t189 = -7.421351600392256d-2*t174*t184*t71*t72-3.71067580019
     1         6128d-2*t175*t186*t65*t70*t71+t187+t185+t173+t165
            t190 = -2.7242157771351844d-1*t184*t59*t61*t64*t69*t74+1.362
     1         1078885675922d-1*t188*t59*t61*t63*t74-1.3621078885675922d
     2         -1*t170*t189*t59*t61*t63*t69+t163
            t191 = 1/t60**4.0d+0
            t192 = 3.710675800196128d-2*t191*t59*t70*t72+1.3621078885675
     1         922d-1*t61*t63*t67
            t193 = 1.855337900098064d-2*t191*t59*t67*t70*t74+1.362107888
     1         5675922d-1*t61*t63*t69*t74-1.3621078885675922d-1*t170*t19
     2         2*t59*t61*t63*t69
            t194 = 3.109069086965489d-2*t1*t157*t193*t58*t89*wght
            t195 = 7.421351600392256d-2*t191*t59*t70*t72+2.7242157771351
     1         844d-1*t61*t63*t67
            t196 = 3.710675800196128d-2*t191*t59*t67*t70*t74+2.724215777
     1         1351844d-1*t61*t63*t69*t74-1.3621078885675922d-1*t170*t19
     2         5*t59*t61*t63*t69
            t197 = -t40*t43*t91-t42*t43
            t198 = -t40*t44*t91-t42*t44+t197*t40*t42
            t199 = -t40*t45*t91-t42*t45+t198*t40*t42
            t200 = -t40*t46*t91-t42*t46+t199*t40*t42
            t201 = -t40*t47*t91-t42*t47+t200*t40*t42
            t202 = -t40*t48*t91-t42*t48+t201*t40*t42
            t203 = -t40*t49*t91-t42*t49+t202*t40*t42
            t204 = -t40*t50*t91-t42*t50+t203*t40*t42
            t205 = -t40*t51*t91-t42*t51+t204*t40*t42
            t206 = -t40*t52*t91-t42*t52+t205*t40*t42
            t207 = -t40*t53*t91-t42*t53+t206*t40*t42
            t208 = -t40*t78*t91-t42*t78
            t209 = -t40*t79*t91-t42*t79+t208*t40*t42
            t210 = -t40*t80*t91-t42*t80+t209*t40*t42
            t211 = -t40*t81*t91-t42*t81+t210*t40*t42
            t212 = -t40*t82*t91-t42*t82+t211*t40*t42
            t213 = -t40*t83*t91-t42*t83+t212*t40*t42
            t214 = -t40*t84*t91-t42*t84+t213*t40*t42
            t215 = -t40*t85*t91-t42*t85+t214*t40*t42
            t216 = -t40*t86*t91-t42*t86+t215*t40*t42
            t217 = -t40*t87*t91-t42*t87+t216*t40*t42
            t218 = -t40*t88*t91
            t219 = -t42*t88+t217*t40*t42+t218
            t220 = 1.0d+0*(3.109069086965489d-2*t1*t219*t58*t76+1.0d+0*t
     1         1*t207*t38)*wght
            t221 = t1**1.3333333333333333d+0
            t222 = 1/t41**3
            t223 = t1**3.333333333333333d-1
            t224 = 1/t223
            t225 = -3.190260000209101d+0*t224*t40*t43*t91-4.579991491020
     1         378d+1*t221*t43*t91+3.190260000209101d+0*t224*t42*t43+4.5
     2         79991491020378d+1*t221*t222*t40*t43
            t226 = -9.570780000627304d+0*t40*t90*t91*t92+9.5707800006273
     1         04d+0*t42*t90*t92-3.190260000209101d+0*t224*t40*t44*t91-4
     2         .579991491020378d+1*t221*t44*t91+3.190260000209101d+0*t22
     3         4*t42*t44+4.579991491020378d+1*t221*t222*t40*t44+t225*t40
     4         *t42
            t227 = -9.570780000627304d+0*t40*t90*t91*t93+9.5707800006273
     1         04d+0*t42*t90*t93-3.190260000209101d+0*t224*t40*t45*t91-4
     2         .579991491020378d+1*t221*t45*t91+3.190260000209101d+0*t22
     3         4*t42*t45+4.579991491020378d+1*t221*t222*t40*t45+t226*t40
     4         *t42
            t228 = -9.570780000627304d+0*t40*t90*t91*t94+9.5707800006273
     1         04d+0*t42*t90*t94-3.190260000209101d+0*t224*t40*t46*t91-4
     2         .579991491020378d+1*t221*t46*t91+3.190260000209101d+0*t22
     3         4*t42*t46+4.579991491020378d+1*t221*t222*t40*t46+t227*t40
     4         *t42
            t229 = -9.570780000627304d+0*t40*t90*t91*t95+9.5707800006273
     1         04d+0*t42*t90*t95-3.190260000209101d+0*t224*t40*t47*t91-4
     2         .579991491020378d+1*t221*t47*t91+3.190260000209101d+0*t22
     3         4*t42*t47+4.579991491020378d+1*t221*t222*t40*t47+t228*t40
     4         *t42
            t230 = -9.570780000627304d+0*t40*t90*t91*t96+9.5707800006273
     1         04d+0*t42*t90*t96-3.190260000209101d+0*t224*t40*t48*t91-4
     2         .579991491020378d+1*t221*t48*t91+3.190260000209101d+0*t22
     3         4*t42*t48+4.579991491020378d+1*t221*t222*t40*t48+t229*t40
     4         *t42
            t231 = -9.570780000627304d+0*t40*t90*t91*t97+9.5707800006273
     1         04d+0*t42*t90*t97-3.190260000209101d+0*t224*t40*t49*t91-4
     2         .579991491020378d+1*t221*t49*t91+3.190260000209101d+0*t22
     3         4*t42*t49+4.579991491020378d+1*t221*t222*t40*t49+t230*t40
     4         *t42
            t232 = -9.570780000627304d+0*t40*t90*t91*t98+9.5707800006273
     1         04d+0*t42*t90*t98-3.190260000209101d+0*t224*t40*t50*t91-4
     2         .579991491020378d+1*t221*t50*t91+3.190260000209101d+0*t22
     3         4*t42*t50+4.579991491020378d+1*t221*t222*t40*t50+t231*t40
     4         *t42
            t233 = -9.570780000627304d+0*t40*t90*t91*t99+9.5707800006273
     1         04d+0*t42*t90*t99-3.190260000209101d+0*t224*t40*t51*t91-4
     2         .579991491020378d+1*t221*t51*t91+3.190260000209101d+0*t22
     3         4*t42*t51+4.579991491020378d+1*t221*t222*t40*t51+t232*t40
     4         *t42
            t234 = -9.570780000627304d+0*t100*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t52*t91-4.579991491020378d+1*t221*t52*t91
     2         +9.570780000627304d+0*t100*t42*t90+3.190260000209101d+0*t
     3         224*t42*t52+4.579991491020378d+1*t221*t222*t40*t52+t233*t
     4         40*t42
            t235 = -9.570780000627304d+0*t101*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t53*t91-4.579991491020378d+1*t221*t53*t91
     2         +9.570780000627304d+0*t101*t42*t90+3.190260000209101d+0*t
     3         224*t42*t53+4.579991491020378d+1*t221*t222*t40*t53+t234*t
     4         40*t42
            t236 = 1.0d+0*t1*t235*t38
            t237 = 2.0d+0*t102*t38
            t238 = t110**2
            t239 = 1/t11**2
            t240 = 6.21814d-2*t238*t239*t4
            t241 = t108**2
            t242 = 1/t9**3
            t243 = 1/t1**2.3333333333333334d+0
            t244 = 1/t5**5
            t245 = 1/t1**1.6666666666666669d+0
            t246 = 8.751370198886037d-2*t106*t245*t7+6.563527649164527d-
     1         2*t104*t244*t7+4.753699179395351d-3*t243
            t247 = 8.751370198886037d-2*t106*t245*t8+6.563527649164527d-
     1         2*t104*t244*t8+7.876233178997433d-1*t246*t6-2.62541105966
     2         5811d-1*t105*t106*t107
            t248 = -1.4107138347223802d-1*t10*t245*t6-4.23214150416714d-
     1         1*t105*t108*t109*t6-1.269642451250142d+0*t109*t247*t5+2.5
     2         39284902500284d+0*t241*t242*t5-3.52678458680595d-2*t10*t1
     3         04*t106
            t249 = -6.21814d-2*t111*t248*t4
            t250 = 5.495546528376876d-3*t110*t111*t113
            t251 = 1/t1**2.333333333333333d+0
            t252 = -3.663697685584584d-3*t12*t251
            t253 = t118**2
            t254 = 1/t25**2
            t255 = -3.37738d-2*t20*t253*t254
            t256 = t116**2
            t257 = 1/t23**3
            t258 = 8.751370198886037d-2*t106*t21*t245+6.563527649164527d
     1         -2*t104*t21*t244+2.601716490612924d-3*t243
            t259 = 7.876233178997433d-1*t258*t6+8.751370198886037d-2*t10
     1         6*t22*t245+6.563527649164527d-2*t104*t22*t244-2.625411059
     2         665811d-1*t105*t106*t115
            t260 = -1.4107138347223802d-1*t24*t245*t6-4.23214150416714d-
     1         1*t105*t116*t117*t6-1.269642451250142d+0*t117*t259*t5+2.5
     2         39284902500284d+0*t256*t257*t5-3.52678458680595d-2*t104*t
     3         106*t24
            t261 = 3.37738d-2*t119*t20*t260
            t262 = -1.5539098445407465d-3*t113*t118*t119
            t263 = 1.0359398963604977d-3*t251*t26
            t264 = t125**2
            t265 = 1/t34**2
            t266 = t123**2
            t267 = 1/t32**3
            t268 = 8.751370198886037d-2*t106*t245*t30+6.563527649164527d
     1         -2*t104*t244*t30+3.0144339229749983d-3*t243
            t269 = 7.876233178997433d-1*t268*t6+8.751370198886037d-2*t10
     1         6*t245*t31+6.563527649164527d-2*t104*t244*t31-2.625411059
     2         665811d-1*t105*t106*t122
            t270 = -1.4107138347223802d-1*t245*t33*t6-4.23214150416714d-
     1         1*t105*t123*t124*t6-1.269642451250142d+0*t124*t269*t5+2.5
     2         39284902500284d+0*t266*t267*t5-3.52678458680595d-2*t104*t
     3         106*t33
            t271 = 1.709920934161365d+0*(6.21814d-2*t111*t248*t4-6.21814
     1         d-2*t238*t239*t4-1.7613865241785687d-3*t251*t35-3.10907d-
     2         2*t126*t270*t29+3.10907d-2*t264*t265*t29+3.66369768558458
     3         4d-3*t12*t251+2.642079786267853d-3*t113*t125*t126-5.49554
     4         6528376876d-3*t110*t111*t113)-3.37738d-2*t119*t20*t260-1.
     5         0359398963604977d-3*t251*t26+3.37738d-2*t20*t253*t254+1.5
     6         539098445407465d-3*t113*t118*t119
            t272 = t27*t271*t28
            t273 = -8*t127*t129*t27
            t274 = 1/t1**6
            t275 = 20*t27*t274*t36
            t276 = t13**2
            t277 = 12*t276*t28*t36
            t278 = -32*t129*t131*t36+8*t127*t131*t28+t277+t275+t273+t272
     1         +t263+t262+t261+t255
            t279 = t137**2
            t280 = 1/t55
            t281 = 1/t1**3
            t282 = -2*t13*t281
            t283 = 2*t134
            t284 = t283+t282
            t285 = t140**2
            t286 = 1/t56
            t287 = 2*t13*t281
            t288 = -2*t134
            t289 = t288+t287
            t290 = 2.564881401242048d+0*t141*t289+8.549604670806825d-1*t
     1         285*t286+2.564881401242048d+0*t138*t284+8.549604670806825
     2         d-1*t279*t280
            t291 = 5.848223622634648d-1*t290*t37+5.848223622634648d-1*t1
     1         9*t278+t252+t250+t249+t240+1.1696447245269297d+0*t132*t14
     2         2
            t292 = -3.190260000209101d+0*t224*t40*t78*t91-4.579991491020
     1         378d+1*t221*t78*t91+3.190260000209101d+0*t224*t42*t78+4.5
     2         79991491020378d+1*t221*t222*t40*t78
            t293 = -9.570780000627304d+0*t145*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t79*t91-4.579991491020378d+1*t221*t79*t91
     2         +9.570780000627304d+0*t145*t42*t90+3.190260000209101d+0*t
     3         224*t42*t79+4.579991491020378d+1*t221*t222*t40*t79+t292*t
     4         40*t42
            t294 = -9.570780000627304d+0*t146*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t80*t91-4.579991491020378d+1*t221*t80*t91
     2         +9.570780000627304d+0*t146*t42*t90+3.190260000209101d+0*t
     3         224*t42*t80+4.579991491020378d+1*t221*t222*t40*t80+t293*t
     4         40*t42
            t295 = -9.570780000627304d+0*t147*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t81*t91-4.579991491020378d+1*t221*t81*t91
     2         +9.570780000627304d+0*t147*t42*t90+3.190260000209101d+0*t
     3         224*t42*t81+4.579991491020378d+1*t221*t222*t40*t81+t294*t
     4         40*t42
            t296 = -9.570780000627304d+0*t148*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t82*t91-4.579991491020378d+1*t221*t82*t91
     2         +9.570780000627304d+0*t148*t42*t90+3.190260000209101d+0*t
     3         224*t42*t82+4.579991491020378d+1*t221*t222*t40*t82+t295*t
     4         40*t42
            t297 = -9.570780000627304d+0*t149*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t83*t91-4.579991491020378d+1*t221*t83*t91
     2         +9.570780000627304d+0*t149*t42*t90+3.190260000209101d+0*t
     3         224*t42*t83+4.579991491020378d+1*t221*t222*t40*t83+t296*t
     4         40*t42
            t298 = -9.570780000627304d+0*t150*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t84*t91-4.579991491020378d+1*t221*t84*t91
     2         +9.570780000627304d+0*t150*t42*t90+3.190260000209101d+0*t
     3         224*t42*t84+4.579991491020378d+1*t221*t222*t40*t84+t297*t
     4         40*t42
            t299 = -9.570780000627304d+0*t151*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t85*t91-4.579991491020378d+1*t221*t85*t91
     2         +9.570780000627304d+0*t151*t42*t90+3.190260000209101d+0*t
     3         224*t42*t85+4.579991491020378d+1*t221*t222*t40*t85+t298*t
     4         40*t42
            t300 = -9.570780000627304d+0*t152*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t86*t91-4.579991491020378d+1*t221*t86*t91
     2         +9.570780000627304d+0*t152*t42*t90+3.190260000209101d+0*t
     3         224*t42*t86+4.579991491020378d+1*t221*t222*t40*t86+t299*t
     4         40*t42
            t301 = -9.570780000627304d+0*t153*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t87*t91-4.579991491020378d+1*t221*t87*t91
     2         +9.570780000627304d+0*t153*t42*t90+3.190260000209101d+0*t
     3         224*t42*t87+4.579991491020378d+1*t221*t222*t40*t87+t300*t
     4         40*t42
            t302 = -9.570780000627304d+0*t154*t40*t90*t91-3.190260000209
     1         101d+0*t224*t40*t88*t91-4.579991491020378d+1*t221*t88*t91
     2         +9.570780000627304d+0*t154*t42*t90+3.190260000209101d+0*t
     3         224*t42*t88+4.579991491020378d+1*t221*t222*t40*t88+t301*t
     4         40*t42
            t303 = 3.109069086965489d-2*t1*t302*t58*t76
            t304 = 6.218138173930978d-2*t155*t58*t76
            t305 = 1/t75**2
            t306 = t177**2
            t307 = t160**2
            t308 = 1/t16
            t309 = 1/t18
            t310 = -1.111111111111111d-1*t285*t309-1.111111111111111d-1*
     1         t279*t308+3.333333333333333d-1*t159*t289+3.33333333333333
     2         3d-1*t158*t284
            t311 = t1**3.333333333333335d-1
            t312 = 1.1123881089968671d+0*t191*t311*t59*t63*t69*t74
            t313 = 1/t1**8.333333333333333d-1
            t314 = -5.297086233318417d-2*t162*t313*t59*t63*t69*t74
            t315 = 8.172647331405554d-1*t307*t59*t61*t67*t70
            t316 = -2.7242157771351844d-1*t310*t59*t61*t64*t67
            t317 = 1.2713006959964196d+0*t160*t161*t162*t59*t64*t67
            t318 = 1.1123881089968671d+0*t191*t311*t59*t63*t67
            t319 = -5.297086233318417d-2*t162*t313*t59*t63*t67
            t320 = 9.649190532874448d+1*t310*t38*t70+1.9298381065748896d
     1         +2*t143*t160*t70-3.216396844291483d+1*t291*t64-3.85967621
     2         3149779d+2*t174*t307*t38
            t321 = -1.3621078885675922d-1*t166*t320*t59*t61*t63*t65
            t322 = 5.448431554270369d-1*t160*t166*t167*t59*t61*t64*t65
            t323 = 6.356503479982097d-1*t161*t162*t166*t167*t59*t63*t65
            t324 = exp(-6.432793688582966d+1*t38*t64)
            t325 = 1/t66**3
            t326 = t167**2
            t327 = 2.7242157771351844d-1*t324*t325*t326*t59*t61*t63
            t328 = -1.3621078885675922d-1*t166*t326*t59*t61*t63*t65
            t329 = t328+t327+t323+t322+t321+t319+t318+t317+t316+t315
            t330 = 1/t60**6.0d+0
            t331 = 5.050642061378063d-1*t171*t311*t330*t70*t72
            t332 = -1.4430405889651615d-2*t171*t172*t313*t70*t72
            t333 = 1/t57**6.0d+0
            t334 = 1/t66**4.0d+0
            t335 = 3.710675800196128d-1*t307*t333*t71*t72-7.421351600392
     1         256d-2*t174*t310*t71*t72+6.926594827032773d-1*t160*t161*t
     2         171*t172*t174*t72-3.710675800196128d-2*t175*t326*t65*t70*
     3         t71-3.710675800196128d-2*t175*t320*t65*t70*t71+1.11320274
     4         00588385d-1*t324*t326*t334*t70*t71+2.9685406401569026d-1*
     5         t160*t167*t174*t175*t65*t71+3.4632974135163863d-1*t161*t1
     6         67*t171*t172*t175*t65*t70+t332+t331+t328+t327+t323+t322+t
     7         321+t319+t318+t317+t316+t315
            t336 = 1/t73**3
            t337 = t176**2
            t338 = 8.172647331405554d-1*t307*t59*t61*t69*t70*t74-2.72421
     1         57771351844d-1*t310*t59*t61*t64*t69*t74+1.271300695996419
     2         6d+0*t160*t161*t162*t59*t64*t69*t74-5.448431554270369d-1*
     3         t160*t169*t59*t61*t64*t74+1.3621078885675922d-1*t329*t59*
     4         t61*t63*t74-6.356503479982097d-1*t161*t162*t169*t59*t63*t
     5         74+5.448431554270369d-1*t160*t170*t176*t59*t61*t64*t69+2.
     6         7242157771351844d-1*t336*t337*t59*t61*t63*t69-1.362107888
     7         5675922d-1*t170*t335*t59*t61*t63*t69+6.356503479982097d-1
     8         *t161*t162*t170*t176*t59*t63*t69-2.7242157771351844d-1*t1
     9         69*t170*t176*t59*t61*t63+t314+t312
            t339 = 1.8654414521792934d-1*t1*t160*t177*t62*t89+3.10906908
     1         6965489d-2*t1*t338*t58*t89+6.218138173930978d-2*t177*t58*
     2         t89+6.218138173930978d-2*t1*t155*t177*t58
            t340 = -12*t276*t28*t36+t275+t273+t272+t263+t262+t261+t255
            t341 = 8.549604670806825d-1*t140*t181*t286+5.129762802484096
     1         d+0*t13*t141*t281-5.129762802484096d+0*t13*t138*t281+8.54
     2         9604670806825d-1*t137*t180*t280
            t342 = 5.848223622634648d-1*t341*t37+5.848223622634648d-1*t1
     1         9*t340+t252+t250+t249+t240+5.848223622634648d-1*t132*t182
     2         +5.848223622634648d-1*t142*t179
            t343 = -1.111111111111111d-1*t140*t181*t309-1.11111111111111
     1         1d-1*t137*t180*t308+6.666666666666666d-1*t13*t159*t281-6.
     2         666666666666666d-1*t13*t158*t281
            t344 = 8.172647331405554d-1*t160*t184*t59*t61*t67*t70
            t345 = -2.7242157771351844d-1*t343*t59*t61*t64*t67
            t346 = 6.356503479982097d-1*t161*t162*t184*t59*t64*t67
            t347 = 6.356503479982097d-1*t160*t161*t162*t59*t64*t67
            t348 = 9.649190532874448d+1*t343*t38*t70+9.649190532874448d+
     1         1*t143*t184*t70+9.649190532874448d+1*t160*t183*t70-3.2163
     2         96844291483d+1*t342*t64-3.859676213149779d+2*t160*t174*t1
     3         84*t38
            t349 = -1.3621078885675922d-1*t166*t348*t59*t61*t63*t65
            t350 = 2.7242157771351844d-1*t160*t166*t186*t59*t61*t64*t65
            t351 = 3.1782517399910487d-1*t161*t162*t166*t186*t59*t63*t65
            t352 = 2.7242157771351844d-1*t166*t167*t184*t59*t61*t64*t65
            t353 = 3.1782517399910487d-1*t161*t162*t166*t167*t59*t63*t65
            t354 = 2.7242157771351844d-1*t167*t186*t324*t325*t59*t61*t63
            t355 = -1.3621078885675922d-1*t166*t167*t186*t59*t61*t63*t65
            t356 = t355+t354+t353+t352+t351+t350+t349+t347+t346+t345+t34
     1         4+t319+t318
            t357 = -7.421351600392256d-2*t174*t343*t71*t72+3.71067580019
     1         6128d-1*t160*t184*t333*t71*t72+3.4632974135163863d-1*t161
     2         *t171*t172*t174*t184*t72+3.4632974135163863d-1*t160*t161*
     3         t171*t172*t174*t72-3.710675800196128d-2*t175*t348*t65*t70
     4         *t71-3.710675800196128d-2*t167*t175*t186*t65*t70*t71+1.11
     5         32027400588385d-1*t167*t186*t324*t334*t70*t71+1.484270320
     6         0784513d-1*t160*t174*t175*t186*t65*t71+1.4842703200784513
     7         d-1*t167*t174*t175*t184*t65*t71+1.7316487067581932d-1*t16
     8         1*t171*t172*t175*t186*t65*t70+1.7316487067581932d-1*t161*
     9         t167*t171*t172*t175*t65*t70+t355+t354+t353+t352+t351+t350
     :         +t349+t347+t346+t345+t344+t332+t331+t319+t318
            t358 = 8.172647331405554d-1*t160*t184*t59*t61*t69*t70*t74-2.
     1         7242157771351844d-1*t343*t59*t61*t64*t69*t74+6.3565034799
     2         82097d-1*t161*t162*t184*t59*t64*t69*t74+6.356503479982097
     3         d-1*t160*t161*t162*t59*t64*t69*t74-2.7242157771351844d-1*
     4         t160*t188*t59*t61*t64*t74-2.7242157771351844d-1*t169*t184
     5         *t59*t61*t64*t74+1.3621078885675922d-1*t356*t59*t61*t63*t
     6         74-3.1782517399910487d-1*t161*t162*t188*t59*t63*t74-3.178
     7         2517399910487d-1*t161*t162*t169*t59*t63*t74+2.72421577713
     8         51844d-1*t160*t170*t189*t59*t61*t64*t69+2.724215777135184
     9         4d-1*t170*t176*t184*t59*t61*t64*t69-1.3621078885675922d-1
     :         *t170*t357*t59*t61*t63*t69+2.7242157771351844d-1*t176*t18
     ;         9*t336*t59*t61*t63*t69+3.1782517399910487d-1*t161*t162*t1
     <         70*t189*t59*t63*t69+3.1782517399910487d-1*t161*t162*t170*
     =         t176*t59*t63*t69-1.3621078885675922d-1*t169*t170*t189*t59
     >         *t61*t63-1.3621078885675922d-1*t170*t176*t188*t59*t61*t63
     ?         +t314+t312
            t359 = 9.327207260896466d-2*t1*t160*t190*t62*t89+9.327207260
     1         896466d-2*t1*t177*t184*t62*t89+3.109069086965489d-2*t1*t3
     2         58*t58*t89+3.109069086965489d-2*t190*t58*t89+3.1090690869
     3         65489d-2*t177*t58*t89+3.109069086965489d-2*t1*t155*t190*t
     4         58+3.109069086965489d-2*t1*t155*t177*t58
            t360 = 32*t129*t131*t36-8*t127*t131*t28+t277+t275+t273+t272+
     1         t263+t262+t261+t255
            t361 = t180**2
            t362 = t288+t282
            t363 = t181**2
            t364 = t287+t283
            t365 = 2.564881401242048d+0*t141*t364+8.549604670806825d-1*t
     1         286*t363+2.564881401242048d+0*t138*t362+8.549604670806825
     2         d-1*t280*t361
            t366 = 5.848223622634648d-1*t365*t37+5.848223622634648d-1*t1
     1         9*t360+t252+t250+t249+t240+1.1696447245269297d+0*t179*t18
     2         2
            t367 = t190**2
            t368 = t184**2
            t369 = 3.333333333333333d-1*t159*t364-1.111111111111111d-1*t
     1         309*t363+3.333333333333333d-1*t158*t362-1.111111111111111
     2         d-1*t308*t361
            t370 = 8.172647331405554d-1*t368*t59*t61*t67*t70
            t371 = -2.7242157771351844d-1*t369*t59*t61*t64*t67
            t372 = 1.2713006959964196d+0*t161*t162*t184*t59*t64*t67
            t373 = 9.649190532874448d+1*t369*t38*t70+1.9298381065748896d
     1         +2*t183*t184*t70-3.216396844291483d+1*t366*t64-3.85967621
     2         3149779d+2*t174*t368*t38
            t374 = -1.3621078885675922d-1*t166*t373*t59*t61*t63*t65
            t375 = 5.448431554270369d-1*t166*t184*t186*t59*t61*t64*t65
            t376 = 6.356503479982097d-1*t161*t162*t166*t186*t59*t63*t65
            t377 = t186**2
            t378 = 2.7242157771351844d-1*t324*t325*t377*t59*t61*t63
            t379 = -1.3621078885675922d-1*t166*t377*t59*t61*t63*t65
            t380 = t379+t378+t376+t375+t374+t372+t371+t370+t319+t318
            t381 = -7.421351600392256d-2*t174*t369*t71*t72+3.71067580019
     1         6128d-1*t333*t368*t71*t72+6.926594827032773d-1*t161*t171*
     2         t172*t174*t184*t72-3.710675800196128d-2*t175*t377*t65*t70
     3         *t71-3.710675800196128d-2*t175*t373*t65*t70*t71+1.1132027
     4         400588385d-1*t324*t334*t377*t70*t71+2.9685406401569026d-1
     5         *t174*t175*t184*t186*t65*t71+3.4632974135163863d-1*t161*t
     6         171*t172*t175*t186*t65*t70+t379+t378+t376+t375+t374+t372+
     7         t371+t370+t332+t331+t319+t318
            t382 = t189**2
            t383 = 8.172647331405554d-1*t368*t59*t61*t69*t70*t74-2.72421
     1         57771351844d-1*t369*t59*t61*t64*t69*t74+1.271300695996419
     2         6d+0*t161*t162*t184*t59*t64*t69*t74-5.448431554270369d-1*
     3         t184*t188*t59*t61*t64*t74+1.3621078885675922d-1*t380*t59*
     4         t61*t63*t74-6.356503479982097d-1*t161*t162*t188*t59*t63*t
     5         74+5.448431554270369d-1*t170*t184*t189*t59*t61*t64*t69+2.
     6         7242157771351844d-1*t336*t382*t59*t61*t63*t69-1.362107888
     7         5675922d-1*t170*t381*t59*t61*t63*t69+6.356503479982097d-1
     8         *t161*t162*t170*t189*t59*t63*t69-2.7242157771351844d-1*t1
     9         70*t188*t189*t59*t61*t63+t314+t312
            t384 = 1.8654414521792934d-1*t1*t184*t190*t62*t89+3.10906908
     1         6965489d-2*t1*t383*t58*t89+6.218138173930978d-2*t190*t58*
     2         t89+6.218138173930978d-2*t1*t155*t190*t58
            t385 = 3.109069086965489d-2*t1*t155*t193*t58
            t386 = 3.109069086965489d-2*t193*t58*t89
            t387 = 3.1782517399910487d-1*t161*t162*t170*t192*t59*t63*t69
            t388 = -3.1782517399910487d-1*t161*t162*t63*t69*t74
            t389 = -4.3291217668954834d-2*t161*t172*t59*t67*t70*t74
            t390 = -2.7242157771351844d-1*t160*t61*t64*t67
            t391 = -3.1782517399910487d-1*t161*t162*t63*t67
            t392 = -1.3621078885675922d-1*t166*t167*t61*t63*t65
            t393 = t392+t391+t390
            t394 = -1.7316487067581932d-1*t161*t172*t59*t70*t72
            t395 = -1.4842703200784513d-1*t160*t174*t191*t59*t72-7.42135
     1         1600392256d-2*t167*t175*t191*t59*t65*t70+t394+t392+t391+t
     2         390
            t396 = -2.7242157771351844d-1*t160*t61*t64*t69*t74-3.7106758
     1         00196128d-2*t160*t174*t191*t59*t67*t74+1.3621078885675922
     2         d-1*t393*t59*t61*t63*t74+1.3621078885675922d-1*t169*t61*t
     3         63*t74-1.855337900098064d-2*t170*t176*t191*t59*t67*t70+2.
     4         7242157771351844d-1*t160*t170*t192*t59*t61*t64*t69-1.3621
     5         078885675922d-1*t170*t395*t59*t61*t63*t69+2.7242157771351
     6         844d-1*t176*t192*t336*t59*t61*t63*t69-1.3621078885675922d
     7         -1*t170*t176*t61*t63*t69-1.3621078885675922d-1*t169*t170*
     8         t192*t59*t61*t63+t389+t388+t387
            t397 = 9.327207260896466d-2*t1*t160*t193*t62*t89+3.109069086
     1         965489d-2*t1*t396*t58*t89+t386+t385
            t398 = 1.0d+0*(t157*t397-3.109069086965489d-2*t1*t177*t193*t
     1         305*t58*t89)*wght
            t399 = 3.109069086965489d-2*t1*t155*t196*t58
            t400 = 3.109069086965489d-2*t196*t58*t89
            t401 = 3.1782517399910487d-1*t161*t162*t170*t195*t59*t63*t69
            t402 = -6.356503479982097d-1*t161*t162*t63*t69*t74
            t403 = -8.658243533790967d-2*t161*t172*t59*t67*t70*t74
            t404 = -5.448431554270369d-1*t160*t61*t64*t67
            t405 = -6.356503479982097d-1*t161*t162*t63*t67
            t406 = -2.7242157771351844d-1*t166*t167*t61*t63*t65
            t407 = t406+t405+t404
            t408 = -3.4632974135163863d-1*t161*t172*t59*t70*t72
            t409 = -2.9685406401569026d-1*t160*t174*t191*t59*t72-1.48427
     1         03200784513d-1*t167*t175*t191*t59*t65*t70+t408+t406+t405+
     2         t404
            t410 = -5.448431554270369d-1*t160*t61*t64*t69*t74-7.42135160
     1         0392256d-2*t160*t174*t191*t59*t67*t74+1.3621078885675922d
     2         -1*t407*t59*t61*t63*t74+2.7242157771351844d-1*t169*t61*t6
     3         3*t74-3.710675800196128d-2*t170*t176*t191*t59*t67*t70+2.7
     4         242157771351844d-1*t160*t170*t195*t59*t61*t64*t69-1.36210
     5         78885675922d-1*t170*t409*t59*t61*t63*t69+2.72421577713518
     6         44d-1*t176*t195*t336*t59*t61*t63*t69-2.7242157771351844d-
     7         1*t170*t176*t61*t63*t69-1.3621078885675922d-1*t169*t170*t
     8         195*t59*t61*t63+t403+t402+t401
            t411 = 9.327207260896466d-2*t1*t160*t196*t62*t89+3.109069086
     1         965489d-2*t1*t410*t58*t89+t400+t399
            t412 = -2.7242157771351844d-1*t184*t61*t64*t67
            t413 = -1.3621078885675922d-1*t166*t186*t61*t63*t65
            t414 = t413+t412+t391
            t415 = -1.4842703200784513d-1*t174*t184*t191*t59*t72-7.42135
     1         1600392256d-2*t175*t186*t191*t59*t65*t70+t413+t412+t394+t
     2         391
            t416 = -2.7242157771351844d-1*t184*t61*t64*t69*t74-3.7106758
     1         00196128d-2*t174*t184*t191*t59*t67*t74+1.3621078885675922
     2         d-1*t414*t59*t61*t63*t74+1.3621078885675922d-1*t188*t61*t
     3         63*t74-1.855337900098064d-2*t170*t189*t191*t59*t67*t70+2.
     4         7242157771351844d-1*t170*t184*t192*t59*t61*t64*t69-1.3621
     5         078885675922d-1*t170*t415*t59*t61*t63*t69+2.7242157771351
     6         844d-1*t189*t192*t336*t59*t61*t63*t69-1.3621078885675922d
     7         -1*t170*t189*t61*t63*t69-1.3621078885675922d-1*t170*t188*
     8         t192*t59*t61*t63+t389+t388+t387
            t417 = 9.327207260896466d-2*t1*t184*t193*t62*t89+3.109069086
     1         965489d-2*t1*t416*t58*t89+t386+t385
            t418 = 1.0d+0*(t157*t417-3.109069086965489d-2*t1*t190*t193*t
     1         305*t58*t89)*wght
            t419 = -5.448431554270369d-1*t184*t61*t64*t67
            t420 = -2.7242157771351844d-1*t166*t186*t61*t63*t65
            t421 = t420+t419+t405
            t422 = -2.9685406401569026d-1*t174*t184*t191*t59*t72-1.48427
     1         03200784513d-1*t175*t186*t191*t59*t65*t70+t420+t419+t408+
     2         t405
            t423 = -5.448431554270369d-1*t184*t61*t64*t69*t74-7.42135160
     1         0392256d-2*t174*t184*t191*t59*t67*t74+1.3621078885675922d
     2         -1*t421*t59*t61*t63*t74+2.7242157771351844d-1*t188*t61*t6
     3         3*t74-3.710675800196128d-2*t170*t189*t191*t59*t67*t70+2.7
     4         242157771351844d-1*t170*t184*t195*t59*t61*t64*t69-1.36210
     5         78885675922d-1*t170*t422*t59*t61*t63*t69+2.72421577713518
     6         44d-1*t189*t195*t336*t59*t61*t63*t69-2.7242157771351844d-
     7         1*t170*t189*t61*t63*t69-1.3621078885675922d-1*t170*t188*t
     8         195*t59*t61*t63+t403+t402+t401
            t424 = 9.327207260896466d-2*t1*t184*t196*t62*t89+3.109069086
     1         965489d-2*t1*t423*t58*t89+t400+t399
            t425 = t193**2
            t426 = t192**2
            t427 = -2.7242157771351844d-1*t170*t192*t61*t63*t69
            t428 = -3.710675800196128d-2*t170*t191*t192*t59*t67*t70
            t429 = 3.710675800196128d-2*t191*t67*t70*t74-5.0543407793640
     1         09d-3*t170*t330*t333*t59*t69*t72+2.7242157771351844d-1*t3
     2         36*t426*t59*t61*t63*t69+t428+t427
            t430 = 3.109069086965489d-2*t1*t157*t429*t58*t89*wght-3.1090
     1         69086965489d-2*t1*t305*t425*t58*t89*wght
            t431 = 7.421351600392256d-2*t191*t67*t70*t74-1.0108681558728
     1         018d-2*t170*t330*t333*t59*t69*t72-1.855337900098064d-2*t1
     2         70*t191*t195*t59*t67*t70+2.7242157771351844d-1*t192*t195*
     3         t336*t59*t61*t63*t69-1.3621078885675922d-1*t170*t195*t61*
     4         t63*t69+t428+t427
            t432 = 3.109069086965489d-2*t1*t157*t431*t58*t89*wght-3.1090
     1         69086965489d-2*t1*t193*t196*t305*t58*t89*wght
            t433 = t196**2
            t434 = t195**2
            t435 = 1.4842703200784513d-1*t191*t67*t70*t74-2.021736311745
     1         6036d-2*t170*t330*t333*t59*t69*t72-7.421351600392256d-2*t
     2         170*t191*t195*t59*t67*t70+2.7242157771351844d-1*t336*t434
     3         *t59*t61*t63*t69-5.448431554270369d-1*t170*t195*t61*t63*t
     4         69
            t436 = t40**2
            t437 = 1/t41**4
            t438 = -t40*t91*t92-t42*t92-4.785390000313652d+0*t197*t40*t9
     1         0*t91+9.570780000627304d+0*t222*t40*t44*t90+9.57078000062
     2         7304d+0*t43*t436*t437*t90+4.785390000313652d+0*t197*t42*t
     3         90
            t439 = -t40*t91*t93-t42*t93-4.785390000313652d+0*t198*t40*t9
     1         0*t91+9.570780000627304d+0*t222*t40*t45*t90+4.78539000031
     2         3652d+0*t198*t42*t90+t40*t42*t438
            t440 = -t40*t91*t94-t42*t94-4.785390000313652d+0*t199*t40*t9
     1         0*t91+9.570780000627304d+0*t222*t40*t46*t90+4.78539000031
     2         3652d+0*t199*t42*t90+t40*t42*t439
            t441 = -t40*t91*t95-t42*t95-4.785390000313652d+0*t200*t40*t9
     1         0*t91+9.570780000627304d+0*t222*t40*t47*t90+4.78539000031
     2         3652d+0*t200*t42*t90+t40*t42*t440
            t442 = -t40*t91*t96-t42*t96-4.785390000313652d+0*t201*t40*t9
     1         0*t91+9.570780000627304d+0*t222*t40*t48*t90+4.78539000031
     2         3652d+0*t201*t42*t90+t40*t42*t441
            t443 = -t40*t91*t97-t42*t97-4.785390000313652d+0*t202*t40*t9
     1         0*t91+9.570780000627304d+0*t222*t40*t49*t90+4.78539000031
     2         3652d+0*t202*t42*t90+t40*t42*t442
            t444 = -t40*t91*t98-t42*t98-4.785390000313652d+0*t203*t40*t9
     1         0*t91+9.570780000627304d+0*t222*t40*t50*t90+4.78539000031
     2         3652d+0*t203*t42*t90+t40*t42*t443
            t445 = -t40*t91*t99-t42*t99-4.785390000313652d+0*t204*t40*t9
     1         0*t91+9.570780000627304d+0*t222*t40*t51*t90+4.78539000031
     2         3652d+0*t204*t42*t90+t40*t42*t444
            t446 = -4.785390000313652d+0*t205*t40*t90*t91-t100*t40*t91+9
     1         .570780000627304d+0*t222*t40*t52*t90+4.785390000313652d+0
     2         *t205*t42*t90+t40*t42*t445-t100*t42
            t447 = -4.785390000313652d+0*t206*t40*t90*t91-t101*t40*t91+9
     1         .570780000627304d+0*t222*t40*t53*t90+4.785390000313652d+0
     2         *t206*t42*t90+t40*t42*t446-t101*t42
            t448 = 1.0d+0*t1*t38*t447
            t449 = 1.0d+0*t207*t38
            t450 = -4.785390000313652d+0*t208*t40*t90*t91-t145*t40*t91+9
     1         .570780000627304d+0*t222*t40*t79*t90+9.570780000627304d+0
     2         *t436*t437*t78*t90+4.785390000313652d+0*t208*t42*t90-t145
     3         *t42
            t451 = -4.785390000313652d+0*t209*t40*t90*t91-t146*t40*t91+9
     1         .570780000627304d+0*t222*t40*t80*t90+4.785390000313652d+0
     2         *t209*t42*t90+t40*t42*t450-t146*t42
            t452 = -4.785390000313652d+0*t210*t40*t90*t91-t147*t40*t91+9
     1         .570780000627304d+0*t222*t40*t81*t90+4.785390000313652d+0
     2         *t210*t42*t90+t40*t42*t451-t147*t42
            t453 = -4.785390000313652d+0*t211*t40*t90*t91-t148*t40*t91+9
     1         .570780000627304d+0*t222*t40*t82*t90+4.785390000313652d+0
     2         *t211*t42*t90+t40*t42*t452-t148*t42
            t454 = -4.785390000313652d+0*t212*t40*t90*t91-t149*t40*t91+9
     1         .570780000627304d+0*t222*t40*t83*t90+4.785390000313652d+0
     2         *t212*t42*t90+t40*t42*t453-t149*t42
            t455 = -4.785390000313652d+0*t213*t40*t90*t91-t150*t40*t91+9
     1         .570780000627304d+0*t222*t40*t84*t90+4.785390000313652d+0
     2         *t213*t42*t90+t40*t42*t454-t150*t42
            t456 = -4.785390000313652d+0*t214*t40*t90*t91-t151*t40*t91+9
     1         .570780000627304d+0*t222*t40*t85*t90+4.785390000313652d+0
     2         *t214*t42*t90+t40*t42*t455-t151*t42
            t457 = -4.785390000313652d+0*t215*t40*t90*t91-t152*t40*t91+9
     1         .570780000627304d+0*t222*t40*t86*t90+4.785390000313652d+0
     2         *t215*t42*t90+t40*t42*t456-t152*t42
            t458 = -4.785390000313652d+0*t216*t40*t90*t91-t153*t40*t91+9
     1         .570780000627304d+0*t222*t40*t87*t90+4.785390000313652d+0
     2         *t216*t42*t90+t40*t42*t457-t153*t42
            t459 = -4.785390000313652d+0*t217*t40*t90*t91-t154*t40*t91+9
     1         .570780000627304d+0*t222*t40*t88*t90+4.785390000313652d+0
     2         *t217*t42*t90+t40*t42*t458-t154*t42
            t460 = 3.109069086965489d-2*t1*t459*t58*t76
            t461 = 3.109069086965489d-2*t219*t58*t76
            t462 = 1.0d+0*(9.327207260896466d-2*t1*t160*t219*t62*t76+3.1
     1         09069086965489d-2*t1*t157*t177*t219*t58+t461+t460+t449+t4
     2         48+1.0d+0*t1*t143*t207)*wght
            t463 = 1.0d+0*(9.327207260896466d-2*t1*t184*t219*t62*t76+3.1
     1         09069086965489d-2*t1*t157*t190*t219*t58+t461+t460+t449+t4
     2         48+1.0d+0*t1*t183*t207)*wght
            t464 = t42*(-t40*t42*t87-t77+t217*t40)+t218
            t465 = 3.109069086965489d-2*t1*t157*t193*t464*t58*wght
            t466 = 3.109069086965489d-2*t1*t157*t196*t464*t58*wght
            t467 = 2*t43*t91+2*t222*t40*t43
            t468 = 2*t44*t91-2*t197*t40*t91+t40*t42*t467+2*t222*t40*t44-
     1         2*t197*t42
            t469 = 2*t45*t91-2*t198*t40*t91+t40*t42*t468+2*t222*t40*t45-
     1         2*t198*t42
            t470 = 2*t46*t91-2*t199*t40*t91+t40*t42*t469+2*t222*t40*t46-
     1         2*t199*t42
            t471 = 2*t47*t91-2*t200*t40*t91+t40*t42*t470+2*t222*t40*t47-
     1         2*t200*t42
            t472 = 2*t48*t91-2*t201*t40*t91+2*t222*t40*t48+t40*t42*t471-
     1         2*t201*t42
            t473 = 2*t49*t91-2*t202*t40*t91+2*t222*t40*t49+t40*t42*t472-
     1         2*t202*t42
            t474 = 2*t50*t91-2*t203*t40*t91+2*t222*t40*t50+t40*t42*t473-
     1         2*t203*t42
            t475 = 2*t51*t91-2*t204*t40*t91+2*t222*t40*t51+t40*t42*t474-
     1         2*t204*t42
            t476 = 2*t52*t91-2*t205*t40*t91+2*t222*t40*t52+t40*t42*t475-
     1         2*t205*t42
            t477 = 2*t78*t91+2*t222*t40*t78
            t478 = 2*t79*t91-2*t208*t40*t91+2*t222*t40*t79+t40*t42*t477-
     1         2*t208*t42
            t479 = 2*t80*t91-2*t209*t40*t91+2*t222*t40*t80+t40*t42*t478-
     1         2*t209*t42
            t480 = 2*t81*t91-2*t210*t40*t91+2*t222*t40*t81+t40*t42*t479-
     1         2*t210*t42
            t481 = 2*t82*t91-2*t211*t40*t91+2*t222*t40*t82+t40*t42*t480-
     1         2*t211*t42
            t482 = 2*t83*t91-2*t212*t40*t91+2*t222*t40*t83+t40*t42*t481-
     1         2*t212*t42
            t483 = 2*t84*t91-2*t213*t40*t91+2*t222*t40*t84+t40*t42*t482-
     1         2*t213*t42
            t484 = 2*t85*t91-2*t214*t40*t91+2*t222*t40*t85+t40*t42*t483-
     1         2*t214*t42
            t485 = 2*t86*t91-2*t215*t40*t91+2*t222*t40*t86+t40*t42*t484-
     1         2*t215*t42
            t486 = 2*t87*t91-2*t216*t40*t91+2*t222*t40*t87+t40*t42*t485-
     1         2*t216*t42
            t487 = 2*t222*t40*t88
            t488 = 1.0d+0*(3.109069086965489d-2*t1*t58*t76*(2*t88*t91-2*
     1         t217*t40*t91+t487+t40*t42*t486-2*t217*t42)+1.0d+0*t1*t38*
     2         (2*t53*t91-2*t206*t40*t91+2*t222*t40*t53+t40*t42*t476-2*t
     3         206*t42))*wght
            t489 = 1/t221
            t490 = 1.0d+0*t1*t38*(t40*t42*(t40*t42*(-9.570780000627304d+
     1         0*t224*t40*t91*t99-1.3739974473061137d+2*t221*t91*t99+9.5
     2         70780000627304d+0*t224*t42*t99+1.3739974473061137d+2*t221
     3         *t222*t40*t99+t40*t42*(-9.570780000627304d+0*t224*t40*t91
     4         *t98-1.3739974473061137d+2*t221*t91*t98+9.570780000627304
     5         d+0*t224*t42*t98+1.3739974473061137d+2*t221*t222*t40*t98+
     6         t40*t42*(-9.570780000627304d+0*t224*t40*t91*t97-1.3739974
     7         473061137d+2*t221*t91*t97+9.570780000627304d+0*t224*t42*t
     8         97+1.3739974473061137d+2*t221*t222*t40*t97+t40*t42*(-9.57
     9         0780000627304d+0*t224*t40*t91*t96-1.3739974473061137d+2*t
     :         221*t91*t96+9.570780000627304d+0*t224*t42*t96+1.373997447
     ;         3061137d+2*t221*t222*t40*t96+t40*t42*(-9.570780000627304d
     <         +0*t224*t40*t91*t95-1.3739974473061137d+2*t221*t91*t95+9.
     =         570780000627304d+0*t224*t42*t95+1.3739974473061137d+2*t22
     >         1*t222*t40*t95+t40*t42*(-9.570780000627304d+0*t224*t40*t9
     ?         1*t94-1.3739974473061137d+2*t221*t91*t94+9.57078000062730
     @         4d+0*t224*t42*t94+1.3739974473061137d+2*t221*t222*t40*t94
     1         +t40*t42*(-9.570780000627304d+0*t224*t40*t91*t93-1.373997
     2         4473061137d+2*t221*t91*t93+9.570780000627304d+0*t224*t42*
     3         t93+1.3739974473061137d+2*t221*t222*t40*t93+t40*t42*(-9.5
     4         70780000627304d+0*t224*t40*t91*t92-1.3739974473061137d+2*
     5         t221*t91*t92+9.570780000627304d+0*t224*t42*t92+1.37399744
     6         73061137d+2*t221*t222*t40*t92+t40*t42*(1.0634200000697003
     7         d+0*t40*t43*t489*t91-9.159982982040756d+1*t223*t43*t91-1.
     8         0634200000697003d+0*t42*t43*t489-6.57511364479516d+2*t133
     9         *t40*t43*t437+9.159982982040756d+1*t222*t223*t40*t43+6.57
     :         511364479516d+2*t133*t222*t43)-1.4356170000940957d+1*t225
     ;         *t40*t90*t91+1.0634200000697003d+0*t40*t44*t489*t91-9.159
     <         982982040756d+1*t223*t44*t91+1.4356170000940957d+1*t225*t
     =         42*t90-1.0634200000697003d+0*t42*t44*t489-6.5751136447951
     >         6d+2*t133*t40*t437*t44+9.159982982040756d+1*t222*t223*t40
     ?         *t44+6.57511364479516d+2*t133*t222*t44)-1.435617000094095
     @         7d+1*t226*t40*t90*t91+1.0634200000697003d+0*t40*t45*t489*
     1         t91-9.159982982040756d+1*t223*t45*t91+1.4356170000940957d
     2         +1*t226*t42*t90-1.0634200000697003d+0*t42*t45*t489-6.5751
     3         1364479516d+2*t133*t40*t437*t45+9.159982982040756d+1*t222
     4         *t223*t40*t45+6.57511364479516d+2*t133*t222*t45)-1.435617
     5         0000940957d+1*t227*t40*t90*t91+1.0634200000697003d+0*t40*
     6         t46*t489*t91-9.159982982040756d+1*t223*t46*t91+1.43561700
     7         00940957d+1*t227*t42*t90-1.0634200000697003d+0*t42*t46*t4
     8         89-6.57511364479516d+2*t133*t40*t437*t46+9.15998298204075
     9         6d+1*t222*t223*t40*t46+6.57511364479516d+2*t133*t222*t46)
     :         -1.4356170000940957d+1*t228*t40*t90*t91+1.063420000069700
     ;         3d+0*t40*t47*t489*t91-9.159982982040756d+1*t223*t47*t91+1
     <         .4356170000940957d+1*t228*t42*t90-1.0634200000697003d+0*t
     =         42*t47*t489-6.57511364479516d+2*t133*t40*t437*t47+9.15998
     >         2982040756d+1*t222*t223*t40*t47+6.57511364479516d+2*t133*
     ?         t222*t47)-1.4356170000940957d+1*t229*t40*t90*t91+1.063420
     @         0000697003d+0*t40*t48*t489*t91-9.159982982040756d+1*t223*
     1         t48*t91+1.4356170000940957d+1*t229*t42*t90-1.063420000069
     2         7003d+0*t42*t48*t489-6.57511364479516d+2*t133*t40*t437*t4
     3         8+9.159982982040756d+1*t222*t223*t40*t48+6.57511364479516
     4         d+2*t133*t222*t48)-1.4356170000940957d+1*t230*t40*t90*t91
     5         +1.0634200000697003d+0*t40*t489*t49*t91-9.159982982040756
     6         d+1*t223*t49*t91+1.4356170000940957d+1*t230*t42*t90-1.063
     7         4200000697003d+0*t42*t489*t49-6.57511364479516d+2*t133*t4
     8         0*t437*t49+9.159982982040756d+1*t222*t223*t40*t49+6.57511
     9         364479516d+2*t133*t222*t49)-1.4356170000940957d+1*t231*t4
     :         0*t90*t91+1.0634200000697003d+0*t40*t489*t50*t91-9.159982
     ;         982040756d+1*t223*t50*t91+1.4356170000940957d+1*t231*t42*
     <         t90-1.0634200000697003d+0*t42*t489*t50-6.57511364479516d+
     =         2*t133*t40*t437*t50+9.159982982040756d+1*t222*t223*t40*t5
     >         0+6.57511364479516d+2*t133*t222*t50)-1.4356170000940957d+
     ?         1*t232*t40*t90*t91+1.0634200000697003d+0*t40*t489*t51*t91
     @         -9.159982982040756d+1*t223*t51*t91+1.4356170000940957d+1*
     1         t232*t42*t90-1.0634200000697003d+0*t42*t489*t51-6.5751136
     2         4479516d+2*t133*t40*t437*t51+9.159982982040756d+1*t222*t2
     3         23*t40*t51+6.57511364479516d+2*t133*t222*t51)-1.435617000
     4         0940957d+1*t233*t40*t90*t91+1.0634200000697003d+0*t40*t48
     5         9*t52*t91-9.159982982040756d+1*t223*t52*t91-9.57078000062
     6         7304d+0*t100*t224*t40*t91-1.3739974473061137d+2*t100*t221
     7         *t91+1.4356170000940957d+1*t233*t42*t90-1.063420000069700
     8         3d+0*t42*t489*t52-6.57511364479516d+2*t133*t40*t437*t52+9
     9         .159982982040756d+1*t222*t223*t40*t52+6.57511364479516d+2
     :         *t133*t222*t52+9.570780000627304d+0*t100*t224*t42+1.37399
     ;         74473061137d+2*t100*t221*t222*t40)-1.4356170000940957d+1*
     <         t234*t40*t90*t91+1.0634200000697003d+0*t40*t489*t53*t91-9
     =         .159982982040756d+1*t223*t53*t91-9.570780000627304d+0*t10
     >         1*t224*t40*t91-1.3739974473061137d+2*t101*t221*t91+1.4356
     ?         170000940957d+1*t234*t42*t90-1.0634200000697003d+0*t42*t4
     @         89*t53-6.57511364479516d+2*t133*t40*t437*t53+9.1599829820
     1         40756d+1*t222*t223*t40*t53+6.57511364479516d+2*t133*t222*
     2         t53+9.570780000627304d+0*t101*t224*t42+1.3739974473061137
     3         d+2*t101*t221*t222*t40)
            t491 = 3.0d+0*t235*t38
            t492 = t110**3
            t493 = 1/t11**3
            t494 = -1.243628d-1*t4*t492*t493
            t495 = 1.865442d-1*t110*t239*t248*t4
            t496 = -8.243319792565315d-3*t113*t238*t239
            t497 = 1/t1**3.3333333333333337d+0
            t498 = 1/t1**2.0d+0
            t499 = 1/t5**7
            t500 = 1/t1**2.666666666666667d+0
            t501 = -7.617854707500852d+0*t108**3*t5/t9**4-1.269642451250
     1         142d+0*t109*t5*(-1.4585616998143394d-1*t106*t500*t8-5.469
     2         606374303773d-2*t498*t499*t8-1.3127055298329054d-1*t243*t
     3         244*t8+7.876233178997433d-1*t6*(-1.4585616998143394d-1*t1
     4         06*t500*t7-5.469606374303773d-2*t498*t499*t7-1.3127055298
     5         329054d-1*t243*t244*t7-1.1708185015918181d-2*t497)-3.9381
     6         165894987163d-1*t105*t106*t246+2.625411059665811d-1*t106*
     7         t107*t245+1.9690582947493582d-1*t104*t107*t244)+2.3511897
     8         245373004d-1*t10*t500*t6-6.34821225625071d-1*t105*t109*t2
     9         47*t6+4.2321415041671406d-1*t108*t109*t245*t6+1.269642451
     :         250142d+0*t105*t241*t242*t6+7.617854707500852d+0*t108*t24
     ;         2*t247*t5+1.763392293402975d-2*t10*t244*t498+7.0535691736
     <         11901d-2*t10*t106*t243+1.0580353760417849d-1*t104*t106*t1
     =         08*t109
            t502 = -6.21814d-2*t111*t4*t501
            t503 = 8.243319792565315d-3*t111*t113*t248
            t504 = -1.0991093056753751d-2*t110*t111*t251
            t505 = 1/t1**3.333333333333333d+0
            t506 = 8.548627933030694d-3*t12*t505
            t507 = t137**3
            t508 = 1/t15**1.6666666666666669d+0
            t509 = 6*t13*t28
            t510 = -6*t281
            t511 = t510+t509
            t512 = t140**3
            t513 = 1/t17**1.6666666666666669d+0
            t514 = -6*t13*t28
            t515 = 6*t281
            t516 = t515+t514
            t517 = t118**3
            t518 = 1/t25**3
            t519 = 6.75476d-2*t20*t517*t518
            t520 = -1.013214d-1*t118*t20*t254*t260
            t521 = 2.33086476681112d-3*t113*t253*t254
            t522 = -1.269642451250142d+0*t117*t5*(7.876233178997433d-1*(
     1         -1.4585616998143394d-1*t106*t21*t500-5.469606374303773d-2
     2         *t21*t498*t499-6.407931356509611d-3*t497-1.31270552983290
     3         54d-1*t21*t243*t244)*t6-1.4585616998143394d-1*t106*t22*t5
     4         00-5.469606374303773d-2*t22*t498*t499-3.9381165894987163d
     5         -1*t105*t106*t258+2.625411059665811d-1*t106*t115*t245-1.3
     6         127055298329054d-1*t22*t243*t244+1.9690582947493582d-1*t1
     7         04*t115*t244)+2.3511897245373004d-1*t24*t500*t6-6.3482122
     8         5625071d-1*t105*t117*t259*t6+1.269642451250142d+0*t105*t2
     9         56*t257*t6+4.2321415041671406d-1*t116*t117*t245*t6+7.6178
     :         54707500852d+0*t116*t257*t259*t5-7.617854707500852d+0*t11
     ;         6**3*t5/t23**4+1.763392293402975d-2*t24*t244*t498+7.05356
     <         9173611901d-2*t106*t24*t243+1.0580353760417849d-1*t104*t1
     =         06*t116*t117
            t523 = 3.37738d-2*t119*t20*t522
            t524 = -2.33086476681112d-3*t113*t119*t260
            t525 = 3.107819689081493d-3*t118*t119*t251
            t526 = -2.4171930915078277d-3*t26*t505
            t527 = t27*t28*(1.709920934161365d+0*(-3.10907d-2*t126*t29*(
     1         -1.269642451250142d+0*t124*t5*(7.876233178997433d-1*(-1.4
     2         585616998143394d-1*t106*t30*t500-5.469606374303773d-2*t30
     3         *t498*t499-7.424439106586571d-3*t497-1.3127055298329054d-
     4         1*t243*t244*t30)*t6-1.4585616998143394d-1*t106*t31*t500-5
     5         .469606374303773d-2*t31*t498*t499-1.3127055298329054d-1*t
     6         243*t244*t31-3.9381165894987163d-1*t105*t106*t268+2.62541
     7         1059665811d-1*t106*t122*t245+1.9690582947493582d-1*t104*t
     8         122*t244)+2.3511897245373004d-1*t33*t500*t6-6.34821225625
     9         071d-1*t105*t124*t269*t6+1.269642451250142d+0*t105*t266*t
     :         267*t6+4.2321415041671406d-1*t123*t124*t245*t6-7.61785470
     ;         7500852d+0*t123**3*t5/t32**4+7.617854707500852d+0*t123*t2
     <         67*t269*t5+1.763392293402975d-2*t244*t33*t498+7.053569173
     =         611901d-2*t106*t243*t33+1.0580353760417849d-1*t104*t106*t
     >         123*t124)+4.1099018897499934d-3*t35*t505-8.54862793303069
     ?         4d-3*t12*t505+6.21814d-2*t111*t4*t501+1.243628d-1*t4*t492
     @         *t493-1.865442d-1*t110*t239*t248*t4-6.21814d-2*t125**3*t2
     1         9/t34**3+9.327209999999999d-2*t125*t265*t270*t29+3.963119
     2         67940178d-3*t113*t126*t270-3.96311967940178d-3*t113*t264*
     3         t265-5.284159572535706d-3*t125*t126*t251+1.09910930567537
     4         51d-2*t110*t111*t251-8.243319792565315d-3*t111*t113*t248+
     5         8.243319792565315d-3*t113*t238*t239)-3.37738d-2*t119*t20*
     6         t522-6.75476d-2*t20*t517*t518+2.4171930915078277d-3*t26*t
     7         505+1.013214d-1*t118*t20*t254*t260+2.33086476681112d-3*t1
     8         13*t119*t260-2.33086476681112d-3*t113*t253*t254-3.1078196
     9         89081493d-3*t118*t119*t251)
            t528 = -12*t129*t27*t271
            t529 = 60*t127*t27*t274
            t530 = 36*t127*t276*t28
            t531 = -120*t27*t36/t1**7
            t532 = -144*t129*t276*t36
            t533 = 24*t13*t28*t36
            t534 = 5.848223622634648d-1*t19*(t533+t532+t531+t530+t529+t5
     1         28+t527+t526+t525+t524+t523+t521+t520+t519+240*t131*t274*
     2         t36+12*t131*t271*t28-96*t127*t129*t131)+5.848223622634648
     3         d-1*t37*(2.564881401242048d+0*t141*t516-5.69973644720455d
     4         -1*t512*t513+2.564881401242048d+0*t138*t511-5.69973644720
     5         455d-1*t507*t508+2.5648814012420473d+0*t140*t286*t289+2.5
     6         648814012420473d+0*t137*t280*t284)+t506+t504+t503+t502+t4
     7         96+t495+t494+1.7544670867903944d+0*t132*t290+1.7544670867
     8         903944d+0*t142*t278
            t535 = 3.109069086965489d-2*t1*t58*t76*(t40*t42*(t40*t42*(t4
     1         0*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t
     2         42*(t40*t42*(1.0634200000697003d+0*t40*t489*t78*t91-9.159
     3         982982040756d+1*t223*t78*t91-1.0634200000697003d+0*t42*t4
     4         89*t78-6.57511364479516d+2*t133*t40*t437*t78+9.1599829820
     5         40756d+1*t222*t223*t40*t78+6.57511364479516d+2*t133*t222*
     6         t78)-1.4356170000940957d+1*t292*t40*t90*t91+1.06342000006
     7         97003d+0*t40*t489*t79*t91-9.159982982040756d+1*t223*t79*t
     8         91-9.570780000627304d+0*t145*t224*t40*t91-1.3739974473061
     9         137d+2*t145*t221*t91+1.4356170000940957d+1*t292*t42*t90-1
     :         .0634200000697003d+0*t42*t489*t79-6.57511364479516d+2*t13
     ;         3*t40*t437*t79+9.159982982040756d+1*t222*t223*t40*t79+6.5
     <         7511364479516d+2*t133*t222*t79+9.570780000627304d+0*t145*
     =         t224*t42+1.3739974473061137d+2*t145*t221*t222*t40)-1.4356
     >         170000940957d+1*t293*t40*t90*t91+1.0634200000697003d+0*t4
     ?         0*t489*t80*t91-9.159982982040756d+1*t223*t80*t91-9.570780
     @         000627304d+0*t146*t224*t40*t91-1.3739974473061137d+2*t146
     1         *t221*t91+1.4356170000940957d+1*t293*t42*t90-1.0634200000
     2         697003d+0*t42*t489*t80-6.57511364479516d+2*t133*t40*t437*
     3         t80+9.159982982040756d+1*t222*t223*t40*t80+6.575113644795
     4         16d+2*t133*t222*t80+9.570780000627304d+0*t146*t224*t42+1.
     5         3739974473061137d+2*t146*t221*t222*t40)-1.435617000094095
     6         7d+1*t294*t40*t90*t91+1.0634200000697003d+0*t40*t489*t81*
     7         t91-9.159982982040756d+1*t223*t81*t91-9.570780000627304d+
     8         0*t147*t224*t40*t91-1.3739974473061137d+2*t147*t221*t91+1
     9         .4356170000940957d+1*t294*t42*t90-1.0634200000697003d+0*t
     :         42*t489*t81-6.57511364479516d+2*t133*t40*t437*t81+9.15998
     ;         2982040756d+1*t222*t223*t40*t81+6.57511364479516d+2*t133*
     <         t222*t81+9.570780000627304d+0*t147*t224*t42+1.37399744730
     =         61137d+2*t147*t221*t222*t40)-1.4356170000940957d+1*t295*t
     >         40*t90*t91+1.0634200000697003d+0*t40*t489*t82*t91-9.15998
     ?         2982040756d+1*t223*t82*t91-9.570780000627304d+0*t148*t224
     @         *t40*t91-1.3739974473061137d+2*t148*t221*t91+1.4356170000
     1         940957d+1*t295*t42*t90-1.0634200000697003d+0*t42*t489*t82
     2         -6.57511364479516d+2*t133*t40*t437*t82+9.159982982040756d
     3         +1*t222*t223*t40*t82+6.57511364479516d+2*t133*t222*t82+9.
     4         570780000627304d+0*t148*t224*t42+1.3739974473061137d+2*t1
     5         48*t221*t222*t40)-1.4356170000940957d+1*t296*t40*t90*t91+
     6         1.0634200000697003d+0*t40*t489*t83*t91-9.159982982040756d
     7         +1*t223*t83*t91-9.570780000627304d+0*t149*t224*t40*t91-1.
     8         3739974473061137d+2*t149*t221*t91+1.4356170000940957d+1*t
     9         296*t42*t90-1.0634200000697003d+0*t42*t489*t83-6.57511364
     :         479516d+2*t133*t40*t437*t83+9.159982982040756d+1*t222*t22
     ;         3*t40*t83+6.57511364479516d+2*t133*t222*t83+9.57078000062
     <         7304d+0*t149*t224*t42+1.3739974473061137d+2*t149*t221*t22
     =         2*t40)-1.4356170000940957d+1*t297*t40*t90*t91+1.063420000
     >         0697003d+0*t40*t489*t84*t91-9.159982982040756d+1*t223*t84
     ?         *t91-9.570780000627304d+0*t150*t224*t40*t91-1.37399744730
     @         61137d+2*t150*t221*t91+1.4356170000940957d+1*t297*t42*t90
     1         -1.0634200000697003d+0*t42*t489*t84-6.57511364479516d+2*t
     2         133*t40*t437*t84+9.159982982040756d+1*t222*t223*t40*t84+6
     3         .57511364479516d+2*t133*t222*t84+9.570780000627304d+0*t15
     4         0*t224*t42+1.3739974473061137d+2*t150*t221*t222*t40)-1.43
     5         56170000940957d+1*t298*t40*t90*t91+1.0634200000697003d+0*
     6         t40*t489*t85*t91-9.159982982040756d+1*t223*t85*t91-9.5707
     7         80000627304d+0*t151*t224*t40*t91-1.3739974473061137d+2*t1
     8         51*t221*t91+1.4356170000940957d+1*t298*t42*t90-1.06342000
     9         00697003d+0*t42*t489*t85-6.57511364479516d+2*t133*t40*t43
     :         7*t85+9.159982982040756d+1*t222*t223*t40*t85+6.5751136447
     ;         9516d+2*t133*t222*t85+9.570780000627304d+0*t151*t224*t42+
     <         1.3739974473061137d+2*t151*t221*t222*t40)-1.4356170000940
     =         957d+1*t299*t40*t90*t91+1.0634200000697003d+0*t40*t489*t8
     >         6*t91-9.159982982040756d+1*t223*t86*t91-9.570780000627304
     ?         d+0*t152*t224*t40*t91-1.3739974473061137d+2*t152*t221*t91
     @         +1.4356170000940957d+1*t299*t42*t90-1.0634200000697003d+0
     1         *t42*t489*t86-6.57511364479516d+2*t133*t40*t437*t86+9.159
     2         982982040756d+1*t222*t223*t40*t86+6.57511364479516d+2*t13
     3         3*t222*t86+9.570780000627304d+0*t152*t224*t42+1.373997447
     4         3061137d+2*t152*t221*t222*t40)-1.4356170000940957d+1*t300
     5         *t40*t90*t91+1.0634200000697003d+0*t40*t489*t87*t91-9.159
     6         982982040756d+1*t223*t87*t91-9.570780000627304d+0*t153*t2
     7         24*t40*t91-1.3739974473061137d+2*t153*t221*t91+1.43561700
     8         00940957d+1*t300*t42*t90-1.0634200000697003d+0*t42*t489*t
     9         87-6.57511364479516d+2*t133*t40*t437*t87+9.15998298204075
     :         6d+1*t222*t223*t40*t87+6.57511364479516d+2*t133*t222*t87+
     ;         9.570780000627304d+0*t153*t224*t42+1.3739974473061137d+2*
     <         t153*t221*t222*t40)-1.4356170000940957d+1*t301*t40*t90*t9
     =         1+1.0634200000697003d+0*t40*t489*t88*t91-9.15998298204075
     >         6d+1*t223*t88*t91-9.570780000627304d+0*t154*t224*t40*t91-
     ?         1.3739974473061137d+2*t154*t221*t91+1.4356170000940957d+1
     @         *t301*t42*t90-1.0634200000697003d+0*t42*t489*t88-6.575113
     1         64479516d+2*t133*t40*t437*t88+9.159982982040756d+1*t222*t
     2         223*t40*t88+6.57511364479516d+2*t133*t222*t88+9.570780000
     3         627304d+0*t154*t224*t42+1.3739974473061137d+2*t154*t221*t
     4         222*t40)
            t536 = 9.327207260896466d-2*t302*t58*t76
            t537 = 1/t75**3
            t538 = t160**3
            t539 = 1/t15**2.3333333333333334d+0
            t540 = 1/t17**2.3333333333333334d+0
            t541 = 1.4814814814814814d-1*t512*t540+1.4814814814814814d-1
     1         *t507*t539+3.333333333333333d-1*t159*t516+3.3333333333333
     2         33d-1*t158*t511-3.333333333333333d-1*t140*t289*t309-3.333
     3         333333333333d-1*t137*t284*t308
            t542 = t1**5.000000000000002d-1
            t543 = -5.191144508652046d+0*t172*t542*t59*t63*t69*t74
            t544 = 1/t1**6.666666666666665d-1
            t545 = 5.561940544984338d-1*t191*t544*t59*t63*t69*t74
            t546 = 1/t1**1.8333333333333332d+0
            t547 = 4.414238527765347d-2*t162*t546*t59*t63*t69*t74
            t548 = -3.2690589325622216d+0*t174*t538*t59*t61*t67
            t549 = 2.4517941994216663d+0*t160*t310*t59*t61*t67*t70
            t550 = -5.720853131983887d+0*t161*t162*t307*t59*t67*t70
            t551 = -2.7242157771351844d-1*t541*t59*t61*t64*t67
            t552 = 1.906951043994629d+0*t161*t162*t310*t59*t64*t67
            t553 = -6.674328653981203d+0*t160*t191*t311*t59*t64*t67
            t554 = 3.1782517399910504d-1*t160*t162*t313*t59*t64*t67
            t555 = -5.191144508652046d+0*t172*t542*t59*t63*t67
            t556 = 5.561940544984338d-1*t191*t544*t59*t63*t67
            t557 = 4.414238527765347d-2*t162*t546*t59*t63*t67
            t558 = 8.172647331405554d-1*t160*t166*t320*t59*t61*t64*t65
            t559 = 9.534755219973146d-1*t161*t162*t166*t320*t59*t63*t65
            t560 = -2.4517941994216663d+0*t166*t167*t307*t59*t61*t65*t70
            t561 = 8.172647331405554d-1*t166*t167*t310*t59*t61*t64*t65
            t562 = -3.813902087989258d+0*t160*t161*t162*t166*t167*t59*t6
     1         4*t65
            t563 = -3.3371643269906015d+0*t166*t167*t191*t311*t59*t63*t6
     1         5
            t564 = 1.5891258699955252d-1*t162*t166*t167*t313*t59*t63*t65
            t565 = 8.172647331405554d-1*t167*t320*t324*t325*t59*t61*t63
            t566 = -4.086323665702777d-1*t166*t167*t320*t59*t61*t63*t65
            t567 = 1.9298381065748896d+2*t160*t38*t70-6.432793688582966d
     1         +1*t143*t64
            t568 = 2.7242157771351844d-1*t324*t325*t326*t567*t59*t61*t63
            t569 = 9.649190532874448d+1*t38*t541*t70+2.8947571598623345d
     1         +2*t143*t310*t70+2.8947571598623345d+2*t160*t291*t70-3.21
     2         6396844291483d+1*t534*t64+1.9298381065748896d+3*t333*t38*
     3         t538-1.1579028639449339d+3*t160*t174*t310*t38-1.157902863
     4         9449339d+3*t143*t174*t307
            t570 = -1.3621078885675922d-1*t166*t569*t59*t61*t63*t65
            t571 = -1.6345294662811108d+0*t160*t324*t325*t326*t59*t61*t6
     1         4
            t572 = -1.906951043994629d+0*t161*t162*t324*t325*t326*t59*t6
     1         3
            t573 = 8.172647331405554d-1*t160*t166*t326*t59*t61*t64*t65
            t574 = 9.534755219973146d-1*t161*t162*t166*t326*t59*t63*t65
            t575 = exp(-9.649190532874448d+1*t38*t64)
            t576 = 1/t66**4
            t577 = t167**3
            t578 = -8.172647331405554d-1*t575*t576*t577*t59*t61*t63
            t579 = 2.7242157771351844d-1*t324*t325*t577*t59*t61*t63
            t580 = -1.3621078885675922d-1*t166*t577*t59*t61*t63*t65
            t581 = 1/t60**7.0d+0
            t582 = -3.5354494429646444d+0*t171*t542*t581*t70*t72
            t583 = 2.525321030689033d-1*t171*t330*t544*t70*t72
            t584 = 1.2025338241376346d-2*t171*t172*t546*t70*t72
            t585 = 1/t57**7.0d+0
            t586 = 1/t66**5.0d+0
            t587 = 1/t73**4
            t588 = -3.109069086965489d-2*t1*t155*t306*t58
            t589 = -3.109069086965489d-2*t306*t58*t89
            t590 = 2.0d+0*t1*t102*t342
            t591 = 2.0d+0*t342*t54
            t592 = t509-2*t281
            t593 = t514+2*t281
            t594 = -12*t127*t276*t28
            t595 = 48*t129*t276*t36
            t596 = -24*t13*t28*t36
            t597 = 5.848223622634648d-1*t19*(t596+t595+t594+t531+t529+t5
     1         28+t527+t526+t525+t524+t523+t521+t520+t519+80*t131*t274*t
     2         36+4*t131*t271*t28-32*t127*t129*t131)+5.848223622634648d-
     3         1*t37*(2.564881401242048d+0*t141*t593+2.564881401242048d+
     4         0*t138*t592-5.69973644720455d-1*t181*t285*t513-5.69973644
     5         720455d-1*t180*t279*t508+8.549604670806825d-1*t181*t286*t
     6         289+3.41984186832273d+0*t13*t140*t281*t286+8.549604670806
     7         825d-1*t180*t280*t284-3.41984186832273d+0*t13*t137*t280*t
     8         281)+t506+t504+t503+t502+t496+t495+t494+1.169644724526929
     9         7d+0*t132*t341+1.1696447245269297d+0*t142*t340+5.84822362
     :         2634648d-1*t179*t290+5.848223622634648d-1*t182*t278
            t598 = 3.7308829043585867d-1*t1*t155*t160*t184*t57*t76
            t599 = 1.8654414521792934d-1*t1*t155*t343*t62*t76
            t600 = 3.7308829043585867d-1*t160*t184*t57*t76*t89
            t601 = 1.8654414521792934d-1*t343*t62*t76*t89
            t602 = 3.333333333333333d-1*t159*t593+3.333333333333333d-1*t
     1         158*t592+1.4814814814814814d-1*t181*t285*t540+1.481481481
     2         4814814d-1*t180*t279*t539-1.111111111111111d-1*t181*t289*
     3         t309-4.444444444444444d-1*t13*t140*t281*t309-1.1111111111
     4         11111d-1*t180*t284*t308+4.444444444444444d-1*t13*t137*t28
     5         1*t308
            t603 = 1.8654414521792934d-1*t1*t155*t160*t190*t62
            t604 = 1.8654414521792934d-1*t1*t155*t177*t184*t62
            t605 = 6.218138173930978d-2*t1*t155*t358*t58
            t606 = 1.8654414521792934d-1*t160*t190*t62*t89
            t607 = 1.8654414521792934d-1*t177*t184*t62*t89
            t608 = 6.218138173930978d-2*t358*t58*t89
            t609 = -3.813902087989258d+0*t160*t161*t162*t184*t59*t69*t70
     1         *t74
            t610 = 1.2713006959964196d+0*t161*t162*t343*t59*t64*t69*t74
            t611 = 1.2713006959964196d+0*t160*t161*t162*t188*t59*t64*t74
            t612 = -1.2713006959964196d+0*t160*t161*t162*t170*t189*t59*t
     1         64*t69
            t613 = 1.2713006959964196d+0*t161*t162*t169*t184*t59*t64*t74
            t614 = 6.356503479982097d-1*t161*t162*t169*t170*t189*t59*t63
            t615 = -1.2713006959964196d+0*t161*t162*t170*t176*t184*t59*t
     1         64*t69
            t616 = 6.356503479982097d-1*t161*t162*t170*t176*t188*t59*t63
            t617 = -1.2713006959964196d+0*t161*t162*t176*t189*t336*t59*t
     1         63*t69
            t618 = -6.356503479982097d-1*t161*t162*t356*t59*t63*t74
            t619 = 6.356503479982097d-1*t161*t162*t170*t357*t59*t63*t69
            t620 = -3.2690589325622216d+0*t174*t184*t307*t59*t61*t67
            t621 = 8.172647331405554d-1*t184*t310*t59*t61*t67*t70
            t622 = 1.6345294662811108d+0*t160*t343*t59*t61*t67*t70
            t623 = -3.813902087989258d+0*t160*t161*t162*t184*t59*t67*t70
            t624 = -1.9069510439946294d+0*t161*t162*t307*t59*t67*t70
            t625 = 1.2713006959964196d+0*t161*t162*t343*t59*t64*t67
            t626 = -2.7242157771351844d-1*t59*t602*t61*t64*t67
            t627 = 6.356503479982097d-1*t161*t162*t310*t59*t64*t67
            t628 = -2.2247762179937342d+0*t184*t191*t311*t59*t64*t67
            t629 = 1.0594172466636834d-1*t162*t184*t313*t59*t64*t67
            t630 = -4.4495524359874683d+0*t160*t191*t311*t59*t64*t67
            t631 = 2.1188344933273667d-1*t160*t162*t313*t59*t64*t67
            t632 = 5.448431554270369d-1*t160*t166*t348*t59*t61*t64*t65
            t633 = 6.356503479982097d-1*t161*t162*t166*t348*t59*t63*t65
            t634 = 2.7242157771351844d-1*t166*t184*t320*t59*t61*t64*t65
            t635 = 3.1782517399910487d-1*t161*t162*t166*t320*t59*t63*t65
            t636 = -8.172647331405554d-1*t166*t186*t307*t59*t61*t65*t70
            t637 = 2.7242157771351844d-1*t166*t186*t310*t59*t61*t64*t65
            t638 = -1.2713006959964196d+0*t160*t161*t162*t166*t186*t59*t
     1         64*t65
            t639 = -1.1123881089968671d+0*t166*t186*t191*t311*t59*t63*t6
     1         5
            t640 = 5.297086233318417d-2*t162*t166*t186*t313*t59*t63*t65
            t641 = 2.7242157771351844d-1*t186*t320*t324*t325*t59*t61*t63
            t642 = -1.3621078885675922d-1*t166*t186*t320*t59*t61*t63*t65
            t643 = -1.6345294662811108d+0*t160*t166*t167*t184*t59*t61*t6
     1         5*t70
            t644 = 5.448431554270369d-1*t166*t167*t343*t59*t61*t64*t65
            t645 = -1.2713006959964196d+0*t161*t162*t166*t167*t184*t59*t
     1         64*t65
            t646 = -1.2713006959964196d+0*t160*t161*t162*t166*t167*t59*t
     1         64*t65
            t647 = -2.2247762179937342d+0*t166*t167*t191*t311*t59*t63*t6
     1         5
            t648 = 1.0594172466636834d-1*t162*t166*t167*t313*t59*t63*t65
            t649 = 5.448431554270369d-1*t167*t324*t325*t348*t59*t61*t63
            t650 = -2.7242157771351844d-1*t166*t167*t348*t59*t61*t63*t65
            t651 = -1.0896863108540737d+0*t160*t167*t186*t324*t325*t59*t
     1         61*t64
            t652 = -1.2713006959964196d+0*t161*t162*t167*t186*t324*t325*
     1         t59*t63
            t653 = 5.448431554270369d-1*t160*t166*t167*t186*t59*t61*t64*
     1         t65
            t654 = 6.356503479982097d-1*t161*t162*t166*t167*t186*t59*t63
     1         *t65
            t655 = 9.649190532874448d+1*t38*t602*t70+1.9298381065748896d
     1         +2*t143*t343*t70+1.9298381065748896d+2*t160*t342*t70+9.64
     2         9190532874448d+1*t183*t310*t70+9.649190532874448d+1*t184*
     3         t291*t70-3.216396844291483d+1*t597*t64-7.719352426299558d
     4         +2*t160*t174*t343*t38+1.9298381065748896d+3*t184*t307*t33
     5         3*t38-3.859676213149779d+2*t174*t184*t310*t38-3.859676213
     6         149779d+2*t174*t183*t307-7.719352426299558d+2*t143*t160*t
     7         174*t184
            t656 = -1.3621078885675922d-1*t166*t59*t61*t63*t65*t655
            t657 = -5.448431554270369d-1*t184*t324*t325*t326*t59*t61*t64
            t658 = -6.356503479982097d-1*t161*t162*t324*t325*t326*t59*t6
     1         3
            t659 = 2.7242157771351844d-1*t166*t184*t326*t59*t61*t64*t65
            t660 = 3.1782517399910487d-1*t161*t162*t166*t326*t59*t63*t65
            t661 = -8.172647331405554d-1*t186*t326*t575*t576*t59*t61*t63
            t662 = 2.7242157771351844d-1*t186*t324*t325*t326*t59*t61*t63
            t663 = -1.3621078885675922d-1*t166*t186*t326*t59*t61*t63*t65
            t664 = 1.9298381065748896d+2*t184*t38*t70-6.432793688582966d
     1         +1*t183*t64
            t665 = 2.7242157771351844d-1*t324*t325*t326*t59*t61*t63*t664
            t666 = -3.4632974135163863d+0*t160*t161*t171*t172*t184*t333*
     1         t72
            t667 = 6.926594827032773d-1*t161*t171*t172*t174*t343*t72
            t668 = 3.4632974135163863d-1*t161*t171*t172*t175*t348*t65*t7
     1         0
            t669 = -1.3853189654065545d+0*t160*t161*t171*t172*t174*t175*
     1         t186*t65
            t670 = -1.3853189654065545d+0*t161*t167*t171*t172*t174*t175*
     1         t184*t65
            t671 = -1.0389892240549159d+0*t161*t167*t171*t172*t186*t324*
     1         t334*t70
            t672 = 3.4632974135163863d-1*t161*t167*t171*t172*t175*t186*t
     1         65*t70
            t673 = 5.848223622634648d-1*t19*(t595+t594+t533+t531+t529+t5
     1         28+t527+t526+t525+t524+t523+t521+t520+t519-80*t131*t274*t
     2         36-4*t131*t271*t28+32*t127*t129*t131)+5.848223622634648d-
     3         1*t37*(-5.69973644720455d-1*t140*t363*t513-5.699736447204
     4         55d-1*t137*t361*t508+8.549604670806825d-1*t140*t286*t364+
     5         8.549604670806825d-1*t137*t280*t362+3.41984186832273d+0*t
     6         13*t181*t281*t286-3.41984186832273d+0*t13*t180*t280*t281-
     7         5.129762802484096d+0*t141*t281+5.129762802484096d+0*t138*
     8         t281-1.5389288407452287d+1*t13*t141*t28+1.538928840745228
     9         7d+1*t13*t138*t28)+t506+t504+t503+t502+t496+t495+t494+5.8
     :         48223622634648d-1*t132*t365+5.848223622634648d-1*t142*t36
     ;         0+1.1696447245269297d+0*t179*t341+1.1696447245269297d+0*t
     <         182*t340
            t674 = 1.4814814814814814d-1*t140*t363*t540+1.48148148148148
     1         14d-1*t137*t361*t539-1.111111111111111d-1*t140*t309*t364-
     2         1.111111111111111d-1*t137*t308*t362-4.444444444444444d-1*
     3         t13*t181*t281*t309+4.444444444444444d-1*t13*t180*t281*t30
     4         8-6.666666666666666d-1*t159*t281+6.666666666666666d-1*t15
     5         8*t281-2.0d+0*t13*t159*t28+2.0d+0*t13*t158*t28
            t675 = -3.2690589325622216d+0*t160*t174*t368*t59*t61*t67
            t676 = 1.6345294662811108d+0*t184*t343*t59*t61*t67*t70
            t677 = 8.172647331405554d-1*t160*t369*t59*t61*t67*t70
            t678 = -1.906951043994629d+0*t161*t162*t368*t59*t67*t70
            t679 = -2.7242157771351844d-1*t59*t61*t64*t67*t674
            t680 = 6.356503479982097d-1*t161*t162*t369*t59*t64*t67
            t681 = -4.4495524359874683d+0*t184*t191*t311*t59*t64*t67
            t682 = 2.1188344933273667d-1*t162*t184*t313*t59*t64*t67
            t683 = -2.2247762179937342d+0*t160*t191*t311*t59*t64*t67
            t684 = 1.0594172466636834d-1*t160*t162*t313*t59*t64*t67
            t685 = 5.448431554270369d-1*t166*t184*t348*t59*t61*t64*t65
            t686 = 2.7242157771351844d-1*t160*t166*t373*t59*t61*t64*t65
            t687 = 3.1782517399910487d-1*t161*t162*t166*t373*t59*t63*t65
            t688 = -1.6345294662811108d+0*t160*t166*t184*t186*t59*t61*t6
     1         5*t70
            t689 = 5.448431554270369d-1*t166*t186*t343*t59*t61*t64*t65
            t690 = -1.2713006959964196d+0*t161*t162*t166*t184*t186*t59*t
     1         64*t65
            t691 = -2.2247762179937342d+0*t166*t186*t191*t311*t59*t63*t6
     1         5
            t692 = 1.0594172466636834d-1*t162*t166*t186*t313*t59*t63*t65
            t693 = 5.448431554270369d-1*t186*t324*t325*t348*t59*t61*t63
            t694 = -2.7242157771351844d-1*t166*t186*t348*t59*t61*t63*t65
            t695 = -8.172647331405554d-1*t166*t167*t368*t59*t61*t65*t70
            t696 = 2.7242157771351844d-1*t166*t167*t369*t59*t61*t64*t65
            t697 = -1.1123881089968671d+0*t166*t167*t191*t311*t59*t63*t6
     1         5
            t698 = 5.297086233318417d-2*t162*t166*t167*t313*t59*t63*t65
            t699 = 2.7242157771351844d-1*t167*t324*t325*t373*t59*t61*t63
            t700 = -1.3621078885675922d-1*t166*t167*t373*t59*t61*t63*t65
            t701 = -1.0896863108540737d+0*t167*t184*t186*t324*t325*t59*t
     1         61*t64
            t702 = 5.448431554270369d-1*t166*t167*t184*t186*t59*t61*t64*
     1         t65
            t703 = 2.7242157771351844d-1*t167*t186*t324*t325*t59*t61*t63
     1         *t664
            t704 = -8.172647331405554d-1*t167*t377*t575*t576*t59*t61*t63
            t705 = 2.7242157771351844d-1*t167*t324*t325*t377*t59*t61*t63
            t706 = -1.3621078885675922d-1*t166*t167*t377*t59*t61*t63*t65
            t707 = 9.649190532874448d+1*t38*t674*t70+9.649190532874448d+
     1         1*t143*t369*t70+9.649190532874448d+1*t160*t366*t70+1.9298
     2         381065748896d+2*t183*t343*t70+1.9298381065748896d+2*t184*
     3         t342*t70-3.216396844291483d+1*t64*t673-3.859676213149779d
     4         +2*t160*t174*t369*t38+1.9298381065748896d+3*t160*t333*t36
     5         8*t38-7.719352426299558d+2*t174*t184*t343*t38-3.859676213
     6         149779d+2*t143*t174*t368-7.719352426299558d+2*t160*t174*t
     7         183*t184
            t708 = -1.3621078885675922d-1*t166*t59*t61*t63*t65*t707
            t709 = -5.448431554270369d-1*t160*t324*t325*t377*t59*t61*t64
            t710 = -6.356503479982097d-1*t161*t162*t324*t325*t377*t59*t6
     1         3
            t711 = 2.7242157771351844d-1*t160*t166*t377*t59*t61*t64*t65
            t712 = 3.1782517399910487d-1*t161*t162*t166*t377*t59*t63*t65
            t713 = t180**3
            t714 = t515+t509
            t715 = t181**3
            t716 = t514+t510
            t717 = 5.848223622634648d-1*t37*(2.564881401242048d+0*t141*t
     1         716-5.69973644720455d-1*t513*t715+2.564881401242048d+0*t1
     2         38*t714-5.69973644720455d-1*t508*t713+2.5648814012420473d
     3         +0*t181*t286*t364+2.5648814012420473d+0*t180*t280*t362)+5
     4         .848223622634648d-1*t19*(t596+t532+t531+t530+t529+t528+t5
     5         27+t526+t525+t524+t523+t521+t520+t519-240*t131*t274*t36-1
     6         2*t131*t271*t28+96*t127*t129*t131)+t506+t504+t503+t502+t4
     7         96+t495+t494+1.7544670867903944d+0*t179*t365+1.7544670867
     8         903944d+0*t182*t360
            t718 = t184**3
            t719 = 3.333333333333333d-1*t159*t716+1.4814814814814814d-1*
     1         t540*t715+3.333333333333333d-1*t158*t714+1.48148148148148
     2         14d-1*t539*t713-3.333333333333333d-1*t181*t309*t364-3.333
     3         333333333333d-1*t180*t308*t362
            t720 = -3.2690589325622216d+0*t174*t59*t61*t67*t718
            t721 = 2.4517941994216663d+0*t184*t369*t59*t61*t67*t70
            t722 = -5.720853131983887d+0*t161*t162*t368*t59*t67*t70
            t723 = -2.7242157771351844d-1*t59*t61*t64*t67*t719
            t724 = 1.906951043994629d+0*t161*t162*t369*t59*t64*t67
            t725 = -6.674328653981203d+0*t184*t191*t311*t59*t64*t67
            t726 = 3.1782517399910504d-1*t162*t184*t313*t59*t64*t67
            t727 = 8.172647331405554d-1*t166*t184*t373*t59*t61*t64*t65
            t728 = 9.534755219973146d-1*t161*t162*t166*t373*t59*t63*t65
            t729 = -2.4517941994216663d+0*t166*t186*t368*t59*t61*t65*t70
            t730 = 8.172647331405554d-1*t166*t186*t369*t59*t61*t64*t65
            t731 = -3.813902087989258d+0*t161*t162*t166*t184*t186*t59*t6
     1         4*t65
            t732 = -3.3371643269906015d+0*t166*t186*t191*t311*t59*t63*t6
     1         5
            t733 = 1.5891258699955252d-1*t162*t166*t186*t313*t59*t63*t65
            t734 = 8.172647331405554d-1*t186*t324*t325*t373*t59*t61*t63
            t735 = -4.086323665702777d-1*t166*t186*t373*t59*t61*t63*t65
            t736 = 2.7242157771351844d-1*t324*t325*t377*t59*t61*t63*t664
            t737 = 9.649190532874448d+1*t38*t70*t719+1.9298381065748896d
     1         +3*t333*t38*t718-3.216396844291483d+1*t64*t717+2.89475715
     2         98623345d+2*t183*t369*t70+2.8947571598623345d+2*t184*t366
     3         *t70-1.1579028639449339d+3*t174*t184*t369*t38-1.157902863
     4         9449339d+3*t174*t183*t368
            t738 = -1.3621078885675922d-1*t166*t59*t61*t63*t65*t737
            t739 = -1.6345294662811108d+0*t184*t324*t325*t377*t59*t61*t6
     1         4
            t740 = -1.906951043994629d+0*t161*t162*t324*t325*t377*t59*t6
     1         3
            t741 = 8.172647331405554d-1*t166*t184*t377*t59*t61*t64*t65
            t742 = 9.534755219973146d-1*t161*t162*t166*t377*t59*t63*t65
            t743 = t186**3
            t744 = -8.172647331405554d-1*t575*t576*t59*t61*t63*t743
            t745 = 2.7242157771351844d-1*t324*t325*t59*t61*t63*t743
            t746 = -1.3621078885675922d-1*t166*t59*t61*t63*t65*t743
            t747 = 3.109069086965489d-2*t1*t193*t302*t58
            t748 = 6.218138173930978d-2*t155*t193*t58
            t749 = -1.1123881089968671d+0*t170*t191*t192*t311*t59*t63*t6
     1         9
            t750 = 5.297086233318417d-2*t162*t170*t192*t313*t59*t63*t69
            t751 = 1.2713006959964196d+0*t160*t161*t162*t64*t69*t74
            t752 = 1.1123881089968671d+0*t191*t311*t63*t69*t74
            t753 = -5.297086233318417d-2*t162*t313*t63*t69*t74
            t754 = 1.7316487067581934d-1*t160*t161*t172*t174*t59*t67*t74
            t755 = 1.515192618413419d-1*t311*t330*t59*t67*t70*t74
            t756 = -7.215202944825808d-3*t172*t313*t59*t67*t70*t74
            t757 = -6.356503479982097d-1*t161*t162*t169*t63*t74
            t758 = 6.356503479982097d-1*t161*t162*t170*t176*t63*t69
            t759 = 8.658243533790967d-2*t161*t170*t172*t176*t59*t67*t70
            t760 = 8.172647331405554d-1*t307*t61*t67*t70
            t761 = -2.7242157771351844d-1*t310*t61*t64*t67
            t762 = 1.2713006959964196d+0*t160*t161*t162*t64*t67
            t763 = 1.1123881089968671d+0*t191*t311*t63*t67
            t764 = -5.297086233318417d-2*t162*t313*t63*t67
            t765 = -1.3621078885675922d-1*t166*t320*t61*t63*t65
            t766 = 5.448431554270369d-1*t160*t166*t167*t61*t64*t65
            t767 = 6.356503479982097d-1*t161*t162*t166*t167*t63*t65
            t768 = 2.7242157771351844d-1*t324*t325*t326*t61*t63
            t769 = -1.3621078885675922d-1*t166*t326*t61*t63*t65
            t770 = 1.3853189654065545d+0*t160*t161*t172*t174*t59*t72
            t771 = 1.0101284122756127d+0*t311*t330*t59*t70*t72
            t772 = -2.886081177930323d-2*t172*t313*t59*t70*t72
            t773 = 6.926594827032773d-1*t161*t167*t172*t175*t59*t65*t70
            t774 = 1.0d+0*(t157*(3.109069086965489d-2*t1*t58*(-1.3621078
     1         885675922d-1*t170*t59*t61*t63*t69*(t773+t772+t771+t770+t7
     2         69+t768+t767+t766+t765+t764+t763+t762+t761+t760+7.4213516
     3         00392256d-1*t191*t307*t333*t59*t72-1.4842703200784513d-1*
     4         t174*t191*t310*t59*t72-7.421351600392256d-2*t175*t191*t32
     5         6*t59*t65*t70-7.421351600392256d-2*t175*t191*t320*t59*t65
     6         *t70+2.226405480117677d-1*t191*t324*t326*t334*t59*t70+5.9
     7         37081280313805d-1*t160*t167*t174*t175*t191*t59*t65)+1.362
     8         1078885675922d-1*t59*t61*t63*t74*(t769+t768+t767+t766+t76
     9         5+t764+t763+t762+t761+t760)+t759+t758+t757+t756+t755+t754
     :         +t753+t752+t751+t750+t749+8.172647331405554d-1*t307*t61*t
     ;         69*t70*t74-2.7242157771351844d-1*t310*t61*t64*t69*t74+1.1
     <         132027400588386d-1*t191*t307*t333*t59*t67*t74-3.710675800
     =         196128d-2*t174*t191*t310*t59*t67*t74-5.448431554270369d-1
     >         *t160*t393*t59*t61*t64*t74-5.448431554270369d-1*t160*t169
     ?         *t61*t64*t74+1.3621078885675922d-1*t329*t61*t63*t74-6.356
     @         503479982097d-1*t161*t162*t393*t59*t63*t74-8.172647331405
     1         554d-1*t170*t192*t307*t59*t61*t69*t70+3.710675800196128d-
     2         2*t191*t336*t337*t59*t67*t70-1.855337900098064d-2*t170*t1
     3         91*t335*t59*t67*t70+5.448431554270369d-1*t160*t170*t395*t
     4         59*t61*t64*t69-1.0896863108540737d+0*t160*t176*t192*t336*
     5         t59*t61*t64*t69+2.7242157771351844d-1*t170*t192*t310*t59*
     6         t61*t64*t69+5.448431554270369d-1*t160*t170*t176*t61*t64*t
     7         69-1.2713006959964196d+0*t160*t161*t162*t170*t192*t59*t64
     8         *t69-8.172647331405554d-1*t192*t337*t587*t59*t61*t63*t69+
     9         5.448431554270369d-1*t176*t336*t395*t59*t61*t63*t69+2.724
     :         2157771351844d-1*t192*t335*t336*t59*t61*t63*t69+2.7242157
     ;         771351844d-1*t336*t337*t61*t63*t69-1.3621078885675922d-1*
     <         t170*t335*t61*t63*t69+6.356503479982097d-1*t161*t162*t170
     =         *t395*t59*t63*t69-1.2713006959964196d+0*t161*t162*t176*t1
     >         92*t336*t59*t63*t69+7.421351600392256d-2*t160*t170*t174*t
     ?         176*t191*t59*t67+5.448431554270369d-1*t160*t169*t170*t192
     @         *t59*t61*t64-2.7242157771351844d-1*t169*t170*t395*t59*t61
     1         *t63-2.7242157771351844d-1*t170*t176*t393*t59*t61*t63+5.4
     2         48431554270369d-1*t169*t176*t192*t336*t59*t61*t63-1.36210
     3         78885675922d-1*t170*t192*t329*t59*t61*t63-2.7242157771351
     4         844d-1*t169*t170*t176*t61*t63+6.356503479982097d-1*t161*t
     5         162*t169*t170*t192*t59*t63)*t89+1.8654414521792934d-1*t1*
     6         t160*t396*t62*t89+9.327207260896466d-2*t1*t193*t310*t62*t
     7         89+1.8654414521792934d-1*t160*t193*t62*t89+6.218138173930
     8         978d-2*t396*t58*t89+1.8654414521792934d-1*t1*t193*t307*t5
     9         7*t89+t748+t747+1.8654414521792934d-1*t1*t155*t160*t193*t
     :         62+6.218138173930978d-2*t1*t155*t396*t58)+t305*(-6.218138
     ;         173930978d-2*t1*t177*t396*t58*t89-t193*t339)+6.2181381739
     <         30978d-2*t1*t193*t306*t537*t58*t89)*wght
            t775 = 3.109069086965489d-2*t1*t196*t302*t58
            t776 = 6.218138173930978d-2*t155*t196*t58
            t777 = -1.1123881089968671d+0*t170*t191*t195*t311*t59*t63*t6
     1         9
            t778 = 5.297086233318417d-2*t162*t170*t195*t313*t59*t63*t69
            t779 = 2.2247762179937342d+0*t191*t311*t63*t69*t74
            t780 = -1.0594172466636834d-1*t162*t313*t63*t69*t74
            t781 = 3.030385236826838d-1*t311*t330*t59*t67*t70*t74
            t782 = -1.4430405889651615d-2*t172*t313*t59*t67*t70*t74
            t783 = 1.6345294662811108d+0*t307*t61*t67*t70
            t784 = -5.448431554270369d-1*t310*t61*t64*t67
            t785 = 2.542601391992839d+0*t160*t161*t162*t64*t67
            t786 = 2.2247762179937342d+0*t191*t311*t63*t67
            t787 = -1.0594172466636834d-1*t162*t313*t63*t67
            t788 = -2.7242157771351844d-1*t166*t320*t61*t63*t65
            t789 = 1.0896863108540737d+0*t160*t166*t167*t61*t64*t65
            t790 = 1.2713006959964196d+0*t161*t162*t166*t167*t63*t65
            t791 = 5.448431554270369d-1*t324*t325*t326*t61*t63
            t792 = -2.7242157771351844d-1*t166*t326*t61*t63*t65
            t793 = 2.0202568245512253d+0*t311*t330*t59*t70*t72
            t794 = -5.772162355860646d-2*t172*t313*t59*t70*t72
            t795 = 8.172647331405554d-1*t160*t184*t61*t67*t70
            t796 = -2.7242157771351844d-1*t343*t61*t64*t67
            t797 = 6.356503479982097d-1*t161*t162*t184*t64*t67
            t798 = 6.356503479982097d-1*t160*t161*t162*t64*t67
            t799 = -1.3621078885675922d-1*t166*t348*t61*t63*t65
            t800 = 2.7242157771351844d-1*t160*t166*t186*t61*t64*t65
            t801 = 3.1782517399910487d-1*t161*t162*t166*t186*t63*t65
            t802 = 2.7242157771351844d-1*t166*t167*t184*t61*t64*t65
            t803 = 3.1782517399910487d-1*t161*t162*t166*t167*t63*t65
            t804 = 2.7242157771351844d-1*t167*t186*t324*t325*t61*t63
            t805 = -1.3621078885675922d-1*t166*t167*t186*t61*t63*t65
            t806 = 1.0d+0*(t157*(3.109069086965489d-2*t1*t58*(-1.3621078
     1         885675922d-1*t170*t59*t61*t63*t69*(t805+t804+t803+t802+t8
     2         01+t800+t799+t798+t797+t796+t795+t772+t771+t764+t763-1.48
     3         42703200784513d-1*t174*t191*t343*t59*t72+7.42135160039225
     4         6d-1*t160*t184*t191*t333*t59*t72+6.926594827032773d-1*t16
     5         1*t172*t174*t184*t59*t72+6.926594827032773d-1*t160*t161*t
     6         172*t174*t59*t72-7.421351600392256d-2*t175*t191*t348*t59*
     7         t65*t70-7.421351600392256d-2*t167*t175*t186*t191*t59*t65*
     8         t70+3.4632974135163863d-1*t161*t172*t175*t186*t59*t65*t70
     9         +3.4632974135163863d-1*t161*t167*t172*t175*t59*t65*t70+2.
     :         226405480117677d-1*t167*t186*t191*t324*t334*t59*t70+2.968
     ;         5406401569026d-1*t160*t174*t175*t186*t191*t59*t65+2.96854
     <         06401569026d-1*t167*t174*t175*t184*t191*t59*t65)+1.362107
     =         8885675922d-1*t59*t61*t63*t74*(t805+t804+t803+t802+t801+t
     >         800+t799+t798+t797+t796+t795+t764+t763)+t756+t755+t753+t7
     ?         52+t750+t749+8.172647331405554d-1*t160*t184*t61*t69*t70*t
     @         74-2.7242157771351844d-1*t343*t61*t64*t69*t74+6.356503479
     1         982097d-1*t161*t162*t184*t64*t69*t74+6.356503479982097d-1
     2         *t160*t161*t162*t64*t69*t74-3.710675800196128d-2*t174*t19
     3         1*t343*t59*t67*t74+1.1132027400588386d-1*t160*t184*t191*t
     4         333*t59*t67*t74+8.658243533790967d-2*t161*t172*t174*t184*
     5         t59*t67*t74+8.658243533790967d-2*t160*t161*t172*t174*t59*
     6         t67*t74-2.7242157771351844d-1*t160*t414*t59*t61*t64*t74-2
     7         .7242157771351844d-1*t184*t393*t59*t61*t64*t74-2.72421577
     8         71351844d-1*t160*t188*t61*t64*t74-2.7242157771351844d-1*t
     9         169*t184*t61*t64*t74+1.3621078885675922d-1*t356*t61*t63*t
     :         74-3.1782517399910487d-1*t161*t162*t414*t59*t63*t74-3.178
     ;         2517399910487d-1*t161*t162*t393*t59*t63*t74-3.17825173999
     <         10487d-1*t161*t162*t188*t63*t74-3.1782517399910487d-1*t16
     =         1*t162*t169*t63*t74-8.172647331405554d-1*t160*t170*t184*t
     >         192*t59*t61*t69*t70-1.855337900098064d-2*t170*t191*t357*t
     ?         59*t67*t70+3.710675800196128d-2*t176*t189*t191*t336*t59*t
     @         67*t70+4.3291217668954834d-2*t161*t170*t172*t189*t59*t67*
     1         t70+4.3291217668954834d-2*t161*t170*t172*t176*t59*t67*t70
     2         +2.7242157771351844d-1*t160*t170*t415*t59*t61*t64*t69+2.7
     3         242157771351844d-1*t170*t184*t395*t59*t61*t64*t69+2.72421
     4         57771351844d-1*t170*t192*t343*t59*t61*t64*t69-5.448431554
     5         270369d-1*t160*t189*t192*t336*t59*t61*t64*t69-5.448431554
     6         270369d-1*t176*t184*t192*t336*t59*t61*t64*t69+2.724215777
     7         1351844d-1*t160*t170*t189*t61*t64*t69+2.7242157771351844d
     8         -1*t170*t176*t184*t61*t64*t69-6.356503479982097d-1*t161*t
     9         162*t170*t184*t192*t59*t64*t69-6.356503479982097d-1*t160*
     :         t161*t162*t170*t192*t59*t64*t69-8.172647331405554d-1*t176
     ;         *t189*t192*t587*t59*t61*t63*t69+2.7242157771351844d-1*t17
     <         6*t336*t415*t59*t61*t63*t69+2.7242157771351844d-1*t189*t3
     =         36*t395*t59*t61*t63*t69+2.7242157771351844d-1*t192*t336*t
     >         357*t59*t61*t63*t69-1.3621078885675922d-1*t170*t357*t61*t
     ?         63*t69+2.7242157771351844d-1*t176*t189*t336*t61*t63*t69+3
     @         .1782517399910487d-1*t161*t162*t170*t415*t59*t63*t69+3.17
     1         82517399910487d-1*t161*t162*t170*t395*t59*t63*t69-6.35650
     2         3479982097d-1*t161*t162*t189*t192*t336*t59*t63*t69-6.3565
     3         03479982097d-1*t161*t162*t176*t192*t336*t59*t63*t69+3.178
     4         2517399910487d-1*t161*t162*t170*t189*t63*t69+3.1782517399
     5         910487d-1*t161*t162*t170*t176*t63*t69+3.710675800196128d-
     6         2*t160*t170*t174*t189*t191*t59*t67+3.710675800196128d-2*t
     7         170*t174*t176*t184*t191*t59*t67+2.7242157771351844d-1*t16
     8         0*t170*t188*t192*t59*t61*t64+2.7242157771351844d-1*t169*t
     9         170*t184*t192*t59*t61*t64-1.3621078885675922d-1*t169*t170
     :         *t415*t59*t61*t63-1.3621078885675922d-1*t170*t176*t414*t5
     ;         9*t61*t63-1.3621078885675922d-1*t170*t188*t395*t59*t61*t6
     <         3-1.3621078885675922d-1*t170*t189*t393*t59*t61*t63-1.3621
     =         078885675922d-1*t170*t192*t356*t59*t61*t63+2.724215777135
     >         1844d-1*t169*t189*t192*t336*t59*t61*t63+2.724215777135184
     ?         4d-1*t176*t188*t192*t336*t59*t61*t63-1.3621078885675922d-
     @         1*t169*t170*t189*t61*t63-1.3621078885675922d-1*t170*t176*
     1         t188*t61*t63+3.1782517399910487d-1*t161*t162*t170*t188*t1
     2         92*t59*t63+3.1782517399910487d-1*t161*t162*t169*t170*t192
     3         *t59*t63)*t89+9.327207260896466d-2*t1*t160*t416*t62*t89+9
     4         .327207260896466d-2*t1*t184*t396*t62*t89+9.32720726089646
     5         6d-2*t1*t193*t343*t62*t89+9.327207260896466d-2*t184*t193*
     6         t62*t89+9.327207260896466d-2*t160*t193*t62*t89+3.10906908
     7         6965489d-2*t416*t58*t89+3.109069086965489d-2*t396*t58*t89
     8         +1.8654414521792934d-1*t1*t160*t184*t193*t57*t89+t748+t74
     9         7+9.327207260896466d-2*t1*t155*t184*t193*t62+9.3272072608
     :         96466d-2*t1*t155*t160*t193*t62+3.109069086965489d-2*t1*t1
     ;         55*t416*t58+3.109069086965489d-2*t1*t155*t396*t58)+t305*(
     <         -3.109069086965489d-2*t1*t177*t416*t58*t89-3.109069086965
     =         489d-2*t1*t190*t396*t58*t89-t193*t359)+6.218138173930978d
     >         -2*t1*t177*t190*t193*t537*t58*t89)*wght
            t807 = 1.2713006959964196d+0*t161*t162*t184*t64*t69*t74
            t808 = 1.7316487067581934d-1*t161*t172*t174*t184*t59*t67*t74
            t809 = -6.356503479982097d-1*t161*t162*t188*t63*t74
            t810 = 6.356503479982097d-1*t161*t162*t170*t189*t63*t69
            t811 = 8.658243533790967d-2*t161*t170*t172*t189*t59*t67*t70
            t812 = 1.6345294662811108d+0*t160*t184*t61*t67*t70
            t813 = -5.448431554270369d-1*t343*t61*t64*t67
            t814 = 1.2713006959964196d+0*t161*t162*t184*t64*t67
            t815 = -2.7242157771351844d-1*t166*t348*t61*t63*t65
            t816 = 5.448431554270369d-1*t160*t166*t186*t61*t64*t65
            t817 = 6.356503479982097d-1*t161*t162*t166*t186*t63*t65
            t818 = 5.448431554270369d-1*t166*t167*t184*t61*t64*t65
            t819 = 5.448431554270369d-1*t167*t186*t324*t325*t61*t63
            t820 = -2.7242157771351844d-1*t166*t167*t186*t61*t63*t65
            t821 = 1.3853189654065545d+0*t161*t172*t174*t184*t59*t72
            t822 = 6.926594827032773d-1*t161*t172*t175*t186*t59*t65*t70
            t823 = 8.172647331405554d-1*t368*t61*t67*t70
            t824 = -2.7242157771351844d-1*t369*t61*t64*t67
            t825 = -1.3621078885675922d-1*t166*t373*t61*t63*t65
            t826 = 5.448431554270369d-1*t166*t184*t186*t61*t64*t65
            t827 = 2.7242157771351844d-1*t324*t325*t377*t61*t63
            t828 = -1.3621078885675922d-1*t166*t377*t61*t63*t65
            t829 = 1.0d+0*(t157*(3.109069086965489d-2*t1*t58*(-1.3621078
     1         885675922d-1*t170*t59*t61*t63*t69*(t828+t827+t826+t825+t8
     2         24+t823+t822+t821+t817+t814+t772+t771+t764+t763-1.4842703
     3         200784513d-1*t174*t191*t369*t59*t72+7.421351600392256d-1*
     4         t191*t333*t368*t59*t72-7.421351600392256d-2*t175*t191*t37
     5         7*t59*t65*t70-7.421351600392256d-2*t175*t191*t373*t59*t65
     6         *t70+2.226405480117677d-1*t191*t324*t334*t377*t59*t70+5.9
     7         37081280313805d-1*t174*t175*t184*t186*t191*t59*t65)+1.362
     8         1078885675922d-1*t59*t61*t63*t74*(t828+t827+t826+t825+t82
     9         4+t823+t817+t814+t764+t763)+t811+t810+t809+t808+t807+t756
     :         +t755+t753+t752+t750+t749+8.172647331405554d-1*t368*t61*t
     ;         69*t70*t74-2.7242157771351844d-1*t369*t61*t64*t69*t74-3.7
     <         10675800196128d-2*t174*t191*t369*t59*t67*t74+1.1132027400
     =         588386d-1*t191*t333*t368*t59*t67*t74-5.448431554270369d-1
     >         *t184*t414*t59*t61*t64*t74-5.448431554270369d-1*t184*t188
     ?         *t61*t64*t74+1.3621078885675922d-1*t380*t61*t63*t74-6.356
     @         503479982097d-1*t161*t162*t414*t59*t63*t74-8.172647331405
     1         554d-1*t170*t192*t368*t59*t61*t69*t70+3.710675800196128d-
     2         2*t191*t336*t382*t59*t67*t70-1.855337900098064d-2*t170*t1
     3         91*t381*t59*t67*t70+5.448431554270369d-1*t170*t184*t415*t
     4         59*t61*t64*t69+2.7242157771351844d-1*t170*t192*t369*t59*t
     5         61*t64*t69-1.0896863108540737d+0*t184*t189*t192*t336*t59*
     6         t61*t64*t69+5.448431554270369d-1*t170*t184*t189*t61*t64*t
     7         69-1.2713006959964196d+0*t161*t162*t170*t184*t192*t59*t64
     8         *t69-8.172647331405554d-1*t192*t382*t587*t59*t61*t63*t69+
     9         5.448431554270369d-1*t189*t336*t415*t59*t61*t63*t69+2.724
     :         2157771351844d-1*t192*t336*t381*t59*t61*t63*t69+2.7242157
     ;         771351844d-1*t336*t382*t61*t63*t69-1.3621078885675922d-1*
     <         t170*t381*t61*t63*t69+6.356503479982097d-1*t161*t162*t170
     =         *t415*t59*t63*t69-1.2713006959964196d+0*t161*t162*t189*t1
     >         92*t336*t59*t63*t69+7.421351600392256d-2*t170*t174*t184*t
     ?         189*t191*t59*t67+5.448431554270369d-1*t170*t184*t188*t192
     @         *t59*t61*t64-2.7242157771351844d-1*t170*t188*t415*t59*t61
     1         *t63-2.7242157771351844d-1*t170*t189*t414*t59*t61*t63-1.3
     2         621078885675922d-1*t170*t192*t380*t59*t61*t63+5.448431554
     3         270369d-1*t188*t189*t192*t336*t59*t61*t63-2.7242157771351
     4         844d-1*t170*t188*t189*t61*t63+6.356503479982097d-1*t161*t
     5         162*t170*t188*t192*t59*t63)*t89+1.8654414521792934d-1*t1*
     6         t184*t416*t62*t89+9.327207260896466d-2*t1*t193*t369*t62*t
     7         89+1.8654414521792934d-1*t184*t193*t62*t89+6.218138173930
     8         978d-2*t416*t58*t89+1.8654414521792934d-1*t1*t193*t368*t5
     9         7*t89+t748+t747+1.8654414521792934d-1*t1*t155*t184*t193*t
     :         62+6.218138173930978d-2*t1*t155*t416*t58)+t305*(-6.218138
     ;         173930978d-2*t1*t190*t416*t58*t89-t193*t384)+6.2181381739
     <         30978d-2*t1*t193*t367*t537*t58*t89)*wght
            t830 = 1.6345294662811108d+0*t368*t61*t67*t70
            t831 = -5.448431554270369d-1*t369*t61*t64*t67
            t832 = 2.542601391992839d+0*t161*t162*t184*t64*t67
            t833 = -2.7242157771351844d-1*t166*t373*t61*t63*t65
            t834 = 1.0896863108540737d+0*t166*t184*t186*t61*t64*t65
            t835 = 1.2713006959964196d+0*t161*t162*t166*t186*t63*t65
            t836 = 5.448431554270369d-1*t324*t325*t377*t61*t63
            t837 = -2.7242157771351844d-1*t166*t377*t61*t63*t65
            t838 = 3.109069086965489d-2*t1*t155*t429*t58
            t839 = 3.109069086965489d-2*t429*t58*t89
            t840 = -6.356503479982097d-1*t161*t162*t336*t426*t59*t63*t69
            t841 = 5.448431554270369d-1*t160*t170*t192*t61*t64*t69
            t842 = 6.356503479982097d-1*t161*t162*t170*t192*t63*t69
            t843 = 1.1793461818516023d-2*t161*t170*t333*t581*t59*t69*t72
            t844 = 7.421351600392256d-2*t160*t170*t174*t191*t192*t59*t67
            t845 = 8.658243533790967d-2*t161*t170*t172*t192*t59*t67*t70
            t846 = -8.658243533790967d-2*t161*t172*t67*t70*t74
            t847 = -1.7316487067581932d-1*t161*t172*t70*t72
            t848 = 2.7242157771351844d-1*t393*t61*t63*t74
            t849 = -2.7242157771351844d-1*t170*t395*t61*t63*t69
            t850 = -3.710675800196128d-2*t170*t191*t395*t59*t67*t70
            t851 = -2.7242157771351844d-1*t169*t170*t192*t61*t63
            t852 = 5.448431554270369d-1*t176*t192*t336*t61*t63*t69
            t853 = 7.421351600392256d-2*t176*t191*t192*t336*t59*t67*t70
            t854 = 1.0d+0*(t157*(3.109069086965489d-2*t1*t58*(t853+t852+
     1         t851+t850+t849+t848-1.3621078885675922d-1*t170*t59*t61*t6
     2         3*t69*(t847-1.4842703200784513d-1*t160*t174*t191*t72-7.42
     3         1351600392256d-2*t167*t175*t191*t65*t70)+t846+t845+t844+t
     4         843+t842+t841+t840-7.421351600392256d-2*t160*t174*t191*t6
     5         7*t74+1.0108681558728018d-2*t160*t170*t330*t585*t59*t69*t
     6         72+1.0108681558728018d-2*t176*t330*t333*t336*t59*t69*t72-
     7         5.054340779364009d-3*t169*t170*t330*t333*t59*t72-3.710675
     8         800196128d-2*t170*t176*t191*t67*t70-5.448431554270369d-1*
     9         t160*t336*t426*t59*t61*t64*t69-8.172647331405554d-1*t176*
     :         t426*t587*t59*t61*t63*t69+5.448431554270369d-1*t192*t336*
     ;         t395*t59*t61*t63*t69+2.7242157771351844d-1*t169*t336*t426
     <         *t59*t61*t63-2.7242157771351844d-1*t170*t192*t393*t59*t61
     =         *t63)*t89+9.327207260896466d-2*t1*t160*t429*t62*t89+t839+
     >         t838)+t305*(-3.109069086965489d-2*t1*t177*t429*t58*t89-3.
     ?         109069086965489d-2*t1*t193*t396*t58*t89-t193*t397)+6.2181
     @         38173930978d-2*t1*t177*t425*t537*t58*t89)*wght
            t855 = 6.218138173930978d-2*t1*t177*t193*t196*t537*t58*t89
            t856 = 3.109069086965489d-2*t1*t155*t431*t58
            t857 = 3.109069086965489d-2*t431*t58*t89
            t858 = -6.356503479982097d-1*t161*t162*t192*t195*t336*t59*t6
     1         3*t69
            t859 = 3.1782517399910487d-1*t161*t162*t170*t195*t63*t69
            t860 = 2.3586923637032045d-2*t161*t170*t333*t581*t59*t69*t72
            t861 = 4.3291217668954834d-2*t161*t170*t172*t195*t59*t67*t70
            t862 = -1.7316487067581934d-1*t161*t172*t67*t70*t74
            t863 = -3.4632974135163863d-1*t161*t172*t70*t72
            t864 = t157*(3.109069086965489d-2*t1*t58*(-1.362107888567592
     1         2d-1*t170*t59*t61*t63*t69*(t863-2.9685406401569026d-1*t16
     2         0*t174*t191*t72-1.4842703200784513d-1*t167*t175*t191*t65*
     3         t70)+t862+t861+t860+t859+t858+t853+t852+t851+t850+t849+t8
     4         48+t845+t844+t842+t841-1.4842703200784513d-1*t160*t174*t1
     5         91*t67*t74+1.3621078885675922d-1*t407*t61*t63*t74+2.02173
     6         63117456036d-2*t160*t170*t330*t585*t59*t69*t72+2.02173631
     7         17456036d-2*t176*t330*t333*t336*t59*t69*t72-1.01086815587
     8         28018d-2*t169*t170*t330*t333*t59*t72-1.855337900098064d-2
     9         *t170*t191*t409*t59*t67*t70+3.710675800196128d-2*t176*t19
     :         1*t195*t336*t59*t67*t70-7.421351600392256d-2*t170*t176*t1
     ;         91*t67*t70-5.448431554270369d-1*t160*t192*t195*t336*t59*t
     <         61*t64*t69+2.7242157771351844d-1*t160*t170*t195*t61*t64*t
     =         69-8.172647331405554d-1*t176*t192*t195*t587*t59*t61*t63*t
     >         69+2.7242157771351844d-1*t192*t336*t409*t59*t61*t63*t69+2
     ?         .7242157771351844d-1*t195*t336*t395*t59*t61*t63*t69-1.362
     @         1078885675922d-1*t170*t409*t61*t63*t69+2.7242157771351844
     1         d-1*t176*t195*t336*t61*t63*t69+3.710675800196128d-2*t160*
     2         t170*t174*t191*t195*t59*t67-1.3621078885675922d-1*t170*t1
     3         92*t407*t59*t61*t63-1.3621078885675922d-1*t170*t195*t393*
     4         t59*t61*t63+2.7242157771351844d-1*t169*t192*t195*t336*t59
     5         *t61*t63-1.3621078885675922d-1*t169*t170*t195*t61*t63)*t8
     6         9+9.327207260896466d-2*t1*t160*t431*t62*t89+t857+t856)
            t865 = -3.109069086965489d-2*t1*t177*t431*t58*t89
            t866 = 3.109069086965489d-2*t1*t155*t435*t58
            t867 = 3.109069086965489d-2*t435*t58*t89
            t868 = -6.356503479982097d-1*t161*t162*t336*t434*t59*t63*t69
            t869 = 1.2713006959964196d+0*t161*t162*t170*t195*t63*t69
            t870 = 4.717384727406409d-2*t161*t170*t333*t581*t59*t69*t72
            t871 = 1.7316487067581934d-1*t161*t170*t172*t195*t59*t67*t70
            t872 = -3.463297413516387d-1*t161*t172*t67*t70*t74
            t873 = -6.926594827032773d-1*t161*t172*t70*t72
            t874 = 5.448431554270369d-1*t170*t184*t192*t61*t64*t69
            t875 = 7.421351600392256d-2*t170*t174*t184*t191*t192*t59*t67
            t876 = 2.7242157771351844d-1*t414*t61*t63*t74
            t877 = -2.7242157771351844d-1*t170*t415*t61*t63*t69
            t878 = -3.710675800196128d-2*t170*t191*t415*t59*t67*t70
            t879 = -2.7242157771351844d-1*t170*t188*t192*t61*t63
            t880 = 5.448431554270369d-1*t189*t192*t336*t61*t63*t69
            t881 = 7.421351600392256d-2*t189*t191*t192*t336*t59*t67*t70
            t882 = 1.0d+0*(t157*(3.109069086965489d-2*t1*t58*(t881+t880+
     1         t879+t878+t877+t876+t875+t874-1.3621078885675922d-1*t170*
     2         t59*t61*t63*t69*(t847-1.4842703200784513d-1*t174*t184*t19
     3         1*t72-7.421351600392256d-2*t175*t186*t191*t65*t70)+t846+t
     4         845+t843+t842+t840-7.421351600392256d-2*t174*t184*t191*t6
     5         7*t74+1.0108681558728018d-2*t170*t184*t330*t585*t59*t69*t
     6         72+1.0108681558728018d-2*t189*t330*t333*t336*t59*t69*t72-
     7         5.054340779364009d-3*t170*t188*t330*t333*t59*t72-3.710675
     8         800196128d-2*t170*t189*t191*t67*t70-5.448431554270369d-1*
     9         t184*t336*t426*t59*t61*t64*t69-8.172647331405554d-1*t189*
     :         t426*t587*t59*t61*t63*t69+5.448431554270369d-1*t192*t336*
     ;         t415*t59*t61*t63*t69+2.7242157771351844d-1*t188*t336*t426
     <         *t59*t61*t63-2.7242157771351844d-1*t170*t192*t414*t59*t61
     =         *t63)*t89+9.327207260896466d-2*t1*t184*t429*t62*t89+t839+
     >         t838)+t305*(-3.109069086965489d-2*t1*t190*t429*t58*t89-3.
     ?         109069086965489d-2*t1*t193*t416*t58*t89-t193*t417)+6.2181
     @         38173930978d-2*t1*t190*t425*t537*t58*t89)*wght
            t883 = 6.218138173930978d-2*t1*t190*t193*t196*t537*t58*t89
            t884 = t157*(3.109069086965489d-2*t1*t58*(t881+t880+t879+t87
     1         8+t877+t876+t875+t874-1.3621078885675922d-1*t170*t59*t61*
     2         t63*t69*(t863-2.9685406401569026d-1*t174*t184*t191*t72-1.
     3         4842703200784513d-1*t175*t186*t191*t65*t70)+t862+t861+t86
     4         0+t859+t858+t845+t842-1.4842703200784513d-1*t174*t184*t19
     5         1*t67*t74+1.3621078885675922d-1*t421*t61*t63*t74+2.021736
     6         3117456036d-2*t170*t184*t330*t585*t59*t69*t72+2.021736311
     7         7456036d-2*t189*t330*t333*t336*t59*t69*t72-1.010868155872
     8         8018d-2*t170*t188*t330*t333*t59*t72-1.855337900098064d-2*
     9         t170*t191*t422*t59*t67*t70+3.710675800196128d-2*t189*t191
     :         *t195*t336*t59*t67*t70-7.421351600392256d-2*t170*t189*t19
     ;         1*t67*t70-5.448431554270369d-1*t184*t192*t195*t336*t59*t6
     <         1*t64*t69+2.7242157771351844d-1*t170*t184*t195*t61*t64*t6
     =         9-8.172647331405554d-1*t189*t192*t195*t587*t59*t61*t63*t6
     >         9+2.7242157771351844d-1*t192*t336*t422*t59*t61*t63*t69+2.
     ?         7242157771351844d-1*t195*t336*t415*t59*t61*t63*t69-1.3621
     @         078885675922d-1*t170*t422*t61*t63*t69+2.7242157771351844d
     1         -1*t189*t195*t336*t61*t63*t69+3.710675800196128d-2*t170*t
     2         174*t184*t191*t195*t59*t67-1.3621078885675922d-1*t170*t19
     3         2*t421*t59*t61*t63-1.3621078885675922d-1*t170*t195*t414*t
     4         59*t61*t63+2.7242157771351844d-1*t188*t192*t195*t336*t59*
     5         t61*t63-1.3621078885675922d-1*t170*t188*t195*t61*t63)*t89
     6         +9.327207260896466d-2*t1*t184*t431*t62*t89+t857+t856)
            t885 = -3.109069086965489d-2*t1*t190*t431*t58*t89
            t886 = 1/t60**8.0d+0
            t887 = 1/t57**8.0d+0
            t888 = 3.109069086965489d-2*t1*t157*t58*(-2.0653672341241763
     1         d-3*t170*t175*t59*t886*t887+3.0326044676184055d-2*t192*t3
     2         30*t333*t336*t59*t69*t72-1.5163022338092028d-2*t170*t330*
     3         t333*t69*t72+1.1132027400588385d-1*t191*t336*t426*t59*t67
     4         *t70-1.1132027400588385d-1*t170*t191*t192*t67*t70-8.17264
     5         7331405554d-1*t192**3*t587*t59*t61*t63*t69+8.172647331405
     6         554d-1*t336*t426*t61*t63*t69)*t89*wght+6.218138173930978d
     7         -2*t1*t193**3*t537*t58*t89*wght-9.327207260896466d-2*t1*t
     8         193*t305*t429*t58*t89*wght
            t889 = 4.043472623491207d-2*t192*t330*t333*t336*t59*t69*t72
            t890 = -1.4842703200784513d-1*t170*t191*t192*t67*t70
            t891 = t305*(-6.218138173930978d-2*t1*t193*t431*t58*t89*wght
     1         -3.109069086965489d-2*t1*t196*t429*t58*t89*wght)+3.109069
     2         086965489d-2*t1*t157*t58*t89*(t890+t889-4.130734468248352
     3         7d-3*t170*t175*t59*t886*t887+1.0108681558728018d-2*t195*t
     4         330*t333*t336*t59*t69*t72-3.0326044676184055d-2*t170*t330
     5         *t333*t69*t72+7.421351600392256d-2*t191*t336*t426*t59*t67
     6         *t70+7.421351600392256d-2*t191*t192*t195*t336*t59*t67*t70
     7         -3.710675800196128d-2*t170*t191*t195*t67*t70-8.1726473314
     8         05554d-1*t195*t426*t587*t59*t61*t63*t69+5.448431554270369
     9         d-1*t336*t426*t61*t63*t69+5.448431554270369d-1*t192*t195*
     :         t336*t61*t63*t69)*wght+6.218138173930978d-2*t1*t196*t425*
     ;         t537*t58*t89*wght
            t892 = t305*(-3.109069086965489d-2*t1*t193*t435*t58*t89*wght
     1         -6.218138173930978d-2*t1*t196*t431*t58*t89*wght)+3.109069
     2         086965489d-2*t1*t157*t58*t89*(t890+t889-8.261468936496705
     3         d-3*t170*t175*t59*t886*t887+4.043472623491207d-2*t195*t33
     4         0*t333*t336*t59*t69*t72-6.065208935236811d-2*t170*t330*t3
     5         33*t69*t72+3.710675800196128d-2*t191*t336*t434*t59*t67*t7
     6         0+1.4842703200784513d-1*t191*t192*t195*t336*t59*t67*t70-1
     7         .4842703200784513d-1*t170*t191*t195*t67*t70-8.17264733140
     8         5554d-1*t192*t434*t587*t59*t61*t63*t69+2.7242157771351844
     9         d-1*t336*t434*t61*t63*t69+1.0896863108540737d+0*t192*t195
     :         *t336*t61*t63*t69)*wght+6.218138173930978d-2*t1*t193*t433
     ;         *t537*t58*t89*wght
            t893 = 1/t41**5
            t894 = 1.0d+0*t1*t38*(t40*t42*(t40*t42*(1.9141560001254607d+
     1         1*t222*t40*t90*t99+t40*t42*(1.9141560001254607d+1*t222*t4
     2         0*t90*t98+t40*t42*(1.9141560001254607d+1*t222*t40*t90*t97
     3         +t40*t42*(1.9141560001254607d+1*t222*t40*t90*t96+t40*t42*
     4         (1.9141560001254607d+1*t222*t40*t90*t95+t40*t42*(1.914156
     5         0001254607d+1*t222*t40*t90*t94+t40*t42*(1.914156000125460
     6         7d+1*t222*t40*t90*t93+t40*t42*(1.9141560001254607d+1*t222
     7         *t40*t90*t92-t225*t40*t91-3.190260000209101d+0*t197*t224*
     8         t40*t91-4.579991491020378d+1*t197*t221*t91-9.159982982040
     9         756d+1*t221*t43*t436*t893-1.3739974473061137d+2*t221*t40*
     :         t437*t44+6.380520000418202d+0*t222*t224*t40*t44+4.5799914
     ;         91020378d+1*t221*t222*t44+t40*t42*(-1.3739974473061137d+2
     <         *t221*t40*t43*t437+6.380520000418202d+0*t222*t224*t40*t43
     =         +4.579991491020378d+1*t221*t222*t43)+9.159982982040756d+1
     >         *t221*t40*t43*t437-t225*t42+3.190260000209101d+0*t197*t22
     ?         4*t42+4.579991491020378d+1*t197*t221*t222*t40)-9.57078000
     @         0627304d+0*t40*t438*t90*t91-t226*t40*t91-3.19026000020910
     1         1d+0*t198*t224*t40*t91-4.579991491020378d+1*t198*t221*t91
     2         +9.570780000627304d+0*t42*t438*t90-1.3739974473061137d+2*
     3         t221*t40*t437*t45+6.380520000418202d+0*t222*t224*t40*t45+
     4         4.579991491020378d+1*t221*t222*t45-t226*t42+3.19026000020
     5         9101d+0*t198*t224*t42+4.579991491020378d+1*t198*t221*t222
     6         *t40)-9.570780000627304d+0*t40*t439*t90*t91-t227*t40*t91-
     7         3.190260000209101d+0*t199*t224*t40*t91-4.579991491020378d
     8         +1*t199*t221*t91+9.570780000627304d+0*t42*t439*t90-1.3739
     9         974473061137d+2*t221*t40*t437*t46+6.380520000418202d+0*t2
     :         22*t224*t40*t46+4.579991491020378d+1*t221*t222*t46-t227*t
     ;         42+3.190260000209101d+0*t199*t224*t42+4.579991491020378d+
     <         1*t199*t221*t222*t40)-9.570780000627304d+0*t40*t440*t90*t
     =         91-t228*t40*t91-3.190260000209101d+0*t200*t224*t40*t91-4.
     >         579991491020378d+1*t200*t221*t91+9.570780000627304d+0*t42
     ?         *t440*t90-1.3739974473061137d+2*t221*t40*t437*t47+6.38052
     @         0000418202d+0*t222*t224*t40*t47+4.579991491020378d+1*t221
     1         *t222*t47-t228*t42+3.190260000209101d+0*t200*t224*t42+4.5
     2         79991491020378d+1*t200*t221*t222*t40)-9.570780000627304d+
     3         0*t40*t441*t90*t91-t229*t40*t91-3.190260000209101d+0*t201
     4         *t224*t40*t91-4.579991491020378d+1*t201*t221*t91+9.570780
     5         000627304d+0*t42*t441*t90-1.3739974473061137d+2*t221*t40*
     6         t437*t48+6.380520000418202d+0*t222*t224*t40*t48+4.5799914
     7         91020378d+1*t221*t222*t48-t229*t42+3.190260000209101d+0*t
     8         201*t224*t42+4.579991491020378d+1*t201*t221*t222*t40)-9.5
     9         70780000627304d+0*t40*t442*t90*t91-t230*t40*t91-3.1902600
     :         00209101d+0*t202*t224*t40*t91-4.579991491020378d+1*t202*t
     ;         221*t91+9.570780000627304d+0*t42*t442*t90-1.3739974473061
     <         137d+2*t221*t40*t437*t49+6.380520000418202d+0*t222*t224*t
     =         40*t49+4.579991491020378d+1*t221*t222*t49-t230*t42+3.1902
     >         60000209101d+0*t202*t224*t42+4.579991491020378d+1*t202*t2
     ?         21*t222*t40)-9.570780000627304d+0*t40*t443*t90*t91-t231*t
     @         40*t91-3.190260000209101d+0*t203*t224*t40*t91-4.579991491
     1         020378d+1*t203*t221*t91+9.570780000627304d+0*t42*t443*t90
     2         -1.3739974473061137d+2*t221*t40*t437*t50+6.38052000041820
     3         2d+0*t222*t224*t40*t50+4.579991491020378d+1*t221*t222*t50
     4         -t231*t42+3.190260000209101d+0*t203*t224*t42+4.5799914910
     5         20378d+1*t203*t221*t222*t40)-9.570780000627304d+0*t40*t44
     6         4*t90*t91-t232*t40*t91-3.190260000209101d+0*t204*t224*t40
     7         *t91-4.579991491020378d+1*t204*t221*t91+9.570780000627304
     8         d+0*t42*t444*t90-1.3739974473061137d+2*t221*t40*t437*t51+
     9         6.380520000418202d+0*t222*t224*t40*t51+4.579991491020378d
     :         +1*t221*t222*t51-t232*t42+3.190260000209101d+0*t204*t224*
     ;         t42+4.579991491020378d+1*t204*t221*t222*t40)-9.5707800006
     <         27304d+0*t40*t445*t90*t91-t233*t40*t91-3.190260000209101d
     =         +0*t205*t224*t40*t91-4.579991491020378d+1*t205*t221*t91+9
     >         .570780000627304d+0*t42*t445*t90+1.9141560001254607d+1*t1
     ?         00*t222*t40*t90-1.3739974473061137d+2*t221*t40*t437*t52+6
     @         .380520000418202d+0*t222*t224*t40*t52+4.579991491020378d+
     1         1*t221*t222*t52-t233*t42+3.190260000209101d+0*t205*t224*t
     2         42+4.579991491020378d+1*t205*t221*t222*t40)-9.57078000062
     3         7304d+0*t40*t446*t90*t91-t234*t40*t91-3.190260000209101d+
     4         0*t206*t224*t40*t91-4.579991491020378d+1*t206*t221*t91+9.
     5         570780000627304d+0*t42*t446*t90+1.9141560001254607d+1*t10
     6         1*t222*t40*t90-1.3739974473061137d+2*t221*t40*t437*t53+6.
     7         380520000418202d+0*t222*t224*t40*t53+4.579991491020378d+1
     8         *t221*t222*t53-t234*t42+3.190260000209101d+0*t206*t224*t4
     9         2+4.579991491020378d+1*t206*t221*t222*t40)
            t895 = 2.0d+0*t38*t447
            t896 = 3.109069086965489d-2*t1*t58*t76*(t40*t42*(t40*t42*(t4
     1         0*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t
     2         42*(-t292*t40*t91-3.190260000209101d+0*t208*t224*t40*t91-
     3         4.579991491020378d+1*t208*t221*t91+1.9141560001254607d+1*
     4         t145*t222*t40*t90-9.159982982040756d+1*t221*t436*t78*t893
     5         -1.3739974473061137d+2*t221*t40*t437*t79+6.38052000041820
     6         2d+0*t222*t224*t40*t79+4.579991491020378d+1*t221*t222*t79
     7         +t40*t42*(-1.3739974473061137d+2*t221*t40*t437*t78+6.3805
     8         20000418202d+0*t222*t224*t40*t78+4.579991491020378d+1*t22
     9         1*t222*t78)+9.159982982040756d+1*t221*t40*t437*t78-t292*t
     :         42+3.190260000209101d+0*t208*t224*t42+4.579991491020378d+
     ;         1*t208*t221*t222*t40)-9.570780000627304d+0*t40*t450*t90*t
     <         91-t293*t40*t91-3.190260000209101d+0*t209*t224*t40*t91-4.
     =         579991491020378d+1*t209*t221*t91+9.570780000627304d+0*t42
     >         *t450*t90+1.9141560001254607d+1*t146*t222*t40*t90-1.37399
     ?         74473061137d+2*t221*t40*t437*t80+6.380520000418202d+0*t22
     @         2*t224*t40*t80+4.579991491020378d+1*t221*t222*t80-t293*t4
     1         2+3.190260000209101d+0*t209*t224*t42+4.579991491020378d+1
     2         *t209*t221*t222*t40)-9.570780000627304d+0*t40*t451*t90*t9
     3         1-t294*t40*t91-3.190260000209101d+0*t210*t224*t40*t91-4.5
     4         79991491020378d+1*t210*t221*t91+9.570780000627304d+0*t42*
     5         t451*t90+1.9141560001254607d+1*t147*t222*t40*t90-1.373997
     6         4473061137d+2*t221*t40*t437*t81+6.380520000418202d+0*t222
     7         *t224*t40*t81+4.579991491020378d+1*t221*t222*t81-t294*t42
     8         +3.190260000209101d+0*t210*t224*t42+4.579991491020378d+1*
     9         t210*t221*t222*t40)-9.570780000627304d+0*t40*t452*t90*t91
     :         -t295*t40*t91-3.190260000209101d+0*t211*t224*t40*t91-4.57
     ;         9991491020378d+1*t211*t221*t91+9.570780000627304d+0*t42*t
     <         452*t90+1.9141560001254607d+1*t148*t222*t40*t90-1.3739974
     =         473061137d+2*t221*t40*t437*t82+6.380520000418202d+0*t222*
     >         t224*t40*t82+4.579991491020378d+1*t221*t222*t82-t295*t42+
     ?         3.190260000209101d+0*t211*t224*t42+4.579991491020378d+1*t
     @         211*t221*t222*t40)-9.570780000627304d+0*t40*t453*t90*t91-
     1         t296*t40*t91-3.190260000209101d+0*t212*t224*t40*t91-4.579
     2         991491020378d+1*t212*t221*t91+9.570780000627304d+0*t42*t4
     3         53*t90+1.9141560001254607d+1*t149*t222*t40*t90-1.37399744
     4         73061137d+2*t221*t40*t437*t83+6.380520000418202d+0*t222*t
     5         224*t40*t83+4.579991491020378d+1*t221*t222*t83-t296*t42+3
     6         .190260000209101d+0*t212*t224*t42+4.579991491020378d+1*t2
     7         12*t221*t222*t40)-9.570780000627304d+0*t40*t454*t90*t91-t
     8         297*t40*t91-3.190260000209101d+0*t213*t224*t40*t91-4.5799
     9         91491020378d+1*t213*t221*t91+9.570780000627304d+0*t42*t45
     :         4*t90+1.9141560001254607d+1*t150*t222*t40*t90-1.373997447
     ;         3061137d+2*t221*t40*t437*t84+6.380520000418202d+0*t222*t2
     <         24*t40*t84+4.579991491020378d+1*t221*t222*t84-t297*t42+3.
     =         190260000209101d+0*t213*t224*t42+4.579991491020378d+1*t21
     >         3*t221*t222*t40)-9.570780000627304d+0*t40*t455*t90*t91-t2
     ?         98*t40*t91-3.190260000209101d+0*t214*t224*t40*t91-4.57999
     @         1491020378d+1*t214*t221*t91+9.570780000627304d+0*t42*t455
     1         *t90+1.9141560001254607d+1*t151*t222*t40*t90-1.3739974473
     2         061137d+2*t221*t40*t437*t85+6.380520000418202d+0*t222*t22
     3         4*t40*t85+4.579991491020378d+1*t221*t222*t85-t298*t42+3.1
     4         90260000209101d+0*t214*t224*t42+4.579991491020378d+1*t214
     5         *t221*t222*t40)-9.570780000627304d+0*t40*t456*t90*t91-t29
     6         9*t40*t91-3.190260000209101d+0*t215*t224*t40*t91-4.579991
     7         491020378d+1*t215*t221*t91+9.570780000627304d+0*t42*t456*
     8         t90+1.9141560001254607d+1*t152*t222*t40*t90-1.37399744730
     9         61137d+2*t221*t40*t437*t86+6.380520000418202d+0*t222*t224
     :         *t40*t86+4.579991491020378d+1*t221*t222*t86-t299*t42+3.19
     ;         0260000209101d+0*t215*t224*t42+4.579991491020378d+1*t215*
     <         t221*t222*t40)-9.570780000627304d+0*t40*t457*t90*t91-t300
     =         *t40*t91-3.190260000209101d+0*t216*t224*t40*t91-4.5799914
     >         91020378d+1*t216*t221*t91+9.570780000627304d+0*t42*t457*t
     ?         90+1.9141560001254607d+1*t153*t222*t40*t90-1.373997447306
     @         1137d+2*t221*t40*t437*t87+6.380520000418202d+0*t222*t224*
     1         t40*t87+4.579991491020378d+1*t221*t222*t87-t300*t42+3.190
     2         260000209101d+0*t216*t224*t42+4.579991491020378d+1*t216*t
     3         221*t222*t40)-9.570780000627304d+0*t40*t458*t90*t91-t301*
     4         t40*t91-3.190260000209101d+0*t217*t224*t40*t91-4.57999149
     5         1020378d+1*t217*t221*t91+9.570780000627304d+0*t42*t458*t9
     6         0+1.9141560001254607d+1*t154*t222*t40*t90-1.3739974473061
     7         137d+2*t221*t40*t437*t88+6.380520000418202d+0*t222*t224*t
     8         40*t88+4.579991491020378d+1*t221*t222*t88-t301*t42+3.1902
     9         60000209101d+0*t217*t224*t42+4.579991491020378d+1*t217*t2
     :         21*t222*t40)
            t897 = 6.218138173930978d-2*t459*t58*t76
            t898 = 1.0d+0*(t897+t896+t895+t894+1.8654414521792934d-1*t1*
     1         t160*t459*t62*t76+9.327207260896466d-2*t1*t219*t310*t62*t
     2         76+1.8654414521792934d-1*t160*t219*t62*t76+1.865441452179
     3         2934d-1*t1*t219*t307*t57*t76+t157*(1.8654414521792934d-1*
     4         t1*t160*t177*t219*t62+6.218138173930978d-2*t1*t177*t459*t
     5         58+3.109069086965489d-2*t1*t219*t338*t58+6.21813817393097
     6         8d-2*t177*t219*t58)-3.109069086965489d-2*t1*t219*t305*t30
     7         6*t58+2.0d+0*t1*t143*t447+1.0d+0*t1*t207*t291+2.0d+0*t143
     8         *t207)*wght
            t899 = 1.0d+0*(t897+t896+t895+t894+9.327207260896466d-2*t1*t
     1         184*t459*t62*t76+9.327207260896466d-2*t1*t160*t459*t62*t7
     2         6+9.327207260896466d-2*t1*t219*t343*t62*t76+9.32720726089
     3         6466d-2*t184*t219*t62*t76+9.327207260896466d-2*t160*t219*
     4         t62*t76+1.8654414521792934d-1*t1*t160*t184*t219*t57*t76+t
     5         157*(9.327207260896466d-2*t1*t160*t190*t219*t62+9.3272072
     6         60896466d-2*t1*t177*t184*t219*t62+3.109069086965489d-2*t1
     7         *t190*t459*t58+3.109069086965489d-2*t1*t177*t459*t58+3.10
     8         9069086965489d-2*t1*t219*t358*t58+3.109069086965489d-2*t1
     9         90*t219*t58+3.109069086965489d-2*t177*t219*t58)-3.1090690
     :         86965489d-2*t1*t177*t190*t219*t305*t58+1.0d+0*t1*t183*t44
     ;         7+1.0d+0*t1*t143*t447+1.0d+0*t1*t207*t342+1.0d+0*t183*t20
     <         7+1.0d+0*t143*t207)*wght
            t900 = 1.0d+0*(t897+t896+t895+t894+1.8654414521792934d-1*t1*
     1         t184*t459*t62*t76+9.327207260896466d-2*t1*t219*t369*t62*t
     2         76+1.8654414521792934d-1*t184*t219*t62*t76+1.865441452179
     3         2934d-1*t1*t219*t368*t57*t76+t157*(1.8654414521792934d-1*
     4         t1*t184*t190*t219*t62+6.218138173930978d-2*t1*t190*t459*t
     5         58+3.109069086965489d-2*t1*t219*t383*t58+6.21813817393097
     6         8d-2*t190*t219*t58)-3.109069086965489d-2*t1*t219*t305*t36
     7         7*t58+2.0d+0*t1*t183*t447+1.0d+0*t1*t207*t366+2.0d+0*t183
     8         *t207)*wght
            t901 = 3.109069086965489d-2*t1*t193*t459*t58
            t902 = 3.109069086965489d-2*t193*t219*t58
            t903 = 1.0d+0*(t157*(t902+t901+9.327207260896466d-2*t1*t160*
     1         t193*t219*t62+3.109069086965489d-2*t1*t219*t396*t58)-3.10
     2         9069086965489d-2*t1*t177*t193*t219*t305*t58)*wght
            t904 = 3.109069086965489d-2*t1*t196*t459*t58
            t905 = 3.109069086965489d-2*t196*t219*t58
            t906 = 1.0d+0*(t157*(t905+t904+9.327207260896466d-2*t1*t160*
     1         t196*t219*t62+3.109069086965489d-2*t1*t219*t410*t58)-3.10
     2         9069086965489d-2*t1*t177*t196*t219*t305*t58)*wght
            t907 = 1.0d+0*(t157*(t902+t901+9.327207260896466d-2*t1*t184*
     1         t193*t219*t62+3.109069086965489d-2*t1*t219*t416*t58)-3.10
     2         9069086965489d-2*t1*t190*t193*t219*t305*t58)*wght
            t908 = 1.0d+0*(t157*(t905+t904+9.327207260896466d-2*t1*t184*
     1         t196*t219*t62+3.109069086965489d-2*t1*t219*t423*t58)-3.10
     2         9069086965489d-2*t1*t190*t196*t219*t305*t58)*wght
            t909 = 3.109069086965489d-2*t1*t157*t219*t429*t58*wght-3.109
     1         069086965489d-2*t1*t219*t305*t425*t58*wght
            t910 = 3.109069086965489d-2*t1*t157*t219*t431*t58*wght-3.109
     1         069086965489d-2*t1*t193*t196*t219*t305*t58*wght
            t911 = 3.109069086965489d-2*t1*t157*t219*t435*t58*wght-3.109
     1         069086965489d-2*t1*t219*t305*t433*t58*wght
            t912 = t42*(2*t40*t87*t91+2*t42*t87+t40*t486-2*t216*t40*t42)
     1         +(2*t40*t42*t87+2*t77-2*t217*t40)*t91+t487
            t913 = 3.109069086965489d-2*t1*t157*t193*t58*t912*wght
            t914 = 3.109069086965489d-2*t1*t157*t196*t58*t912*wght
            t915 = 1.0d+0*(3.109069086965489d-2*t1*t58*t76*(t40*t42*(t40
     1         *t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t4
     2         2*(t40*t42*(-3*t40*t477*t91+6*t208*t91-6*t40*t437*t79-6*t
     3         222*t79+t40*t42*(-6*t40*t437*t78-6*t222*t78)-3*t42*t477+6
     4         *t208*t222*t40)-3*t40*t478*t91+6*t209*t91-6*t40*t437*t80-
     5         6*t222*t80-3*t42*t478+6*t209*t222*t40)-3*t40*t479*t91+6*t
     6         210*t91-6*t40*t437*t81-6*t222*t81-3*t42*t479+6*t210*t222*
     7         t40)-3*t40*t480*t91+6*t211*t91-6*t40*t437*t82-6*t222*t82-
     8         3*t42*t480+6*t211*t222*t40)-3*t40*t481*t91+6*t212*t91-6*t
     9         40*t437*t83-6*t222*t83-3*t42*t481+6*t212*t222*t40)-3*t40*
     :         t482*t91+6*t213*t91-6*t40*t437*t84-6*t222*t84-3*t42*t482+
     ;         6*t213*t222*t40)-3*t40*t483*t91+6*t214*t91-6*t40*t437*t85
     <         -6*t222*t85-3*t42*t483+6*t214*t222*t40)-3*t40*t484*t91+6*
     =         t215*t91-6*t40*t437*t86-6*t222*t86-3*t42*t484+6*t215*t222
     >         *t40)-3*t40*t485*t91+6*t216*t91-6*t40*t437*t87-6*t222*t87
     ?         -3*t42*t485+6*t216*t222*t40)-3*t40*t486*t91+6*t217*t91-6*
     @         t40*t437*t88-6*t222*t88-3*t42*t486+6*t217*t222*t40)+1.0d+
     1         0*t1*t38*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t40*t42*(t4
     2         0*t42*(t40*t42*(t40*t42*(t40*t42*(-3*t40*t467*t91+6*t197*
     3         t91-3*t42*t467-6*t40*t437*t44-6*t222*t44+t40*t42*(-6*t40*
     4         t43*t437-6*t222*t43)+6*t197*t222*t40)-3*t40*t468*t91+6*t1
     5         98*t91-3*t42*t468-6*t40*t437*t45-6*t222*t45+6*t198*t222*t
     6         40)-3*t40*t469*t91+6*t199*t91-3*t42*t469-6*t40*t437*t46-6
     7         *t222*t46+6*t199*t222*t40)-3*t40*t470*t91+6*t200*t91-3*t4
     8         2*t470-6*t40*t437*t47-6*t222*t47+6*t200*t222*t40)-3*t40*t
     9         471*t91+6*t201*t91-6*t40*t437*t48-6*t222*t48-3*t42*t471+6
     :         *t201*t222*t40)-3*t40*t472*t91+6*t202*t91-6*t40*t437*t49-
     ;         6*t222*t49-3*t42*t472+6*t202*t222*t40)-3*t40*t473*t91+6*t
     <         203*t91-6*t40*t437*t50-6*t222*t50-3*t42*t473+6*t203*t222*
     =         t40)-3*t40*t474*t91+6*t204*t91-6*t40*t437*t51-6*t222*t51-
     >         3*t42*t474+6*t204*t222*t40)-3*t40*t475*t91+6*t205*t91-6*t
     ?         40*t437*t52-6*t222*t52-3*t42*t475+6*t205*t222*t40)-3*t40*
     @         t476*t91+6*t206*t91-6*t40*t437*t53-6*t222*t53-3*t42*t476+
     1         6*t206*t222*t40))*wght
            fnc(iq) = 1.0d+0*(3.109069086965489d-2*t1*t58*t76*t89+1.0d+0
     1         *t1*t38*t54)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(9.327207260896466d-2*t1*t160*t62*t7
     1         6*t89+3.109069086965489d-2*t1*t157*t177*t58*t89+1.0d+0*t1
     2         *t143*t54+t178+t156+t144+t103)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*(9.327207260896466d-2*t1*t184*t62*t7
     1         6*t89+3.109069086965489d-2*t1*t157*t190*t58*t89+1.0d+0*t1
     2         *t183*t54+t178+t156+t144+t103)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t194+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 3.109069086965489d-2*t1*t157*t196*t58*t89*
     1         wght+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t194+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TA) = t220+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = t220+Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(9.327207260896466d-2*t1*t310*t6
     1         2*t76*t89+1.8654414521792934d-1*t160*t62*t76*t89+1.865441
     2         4521792934d-1*t1*t307*t57*t76*t89-3.109069086965489d-2*t1
     3         *t305*t306*t58*t89+1.8654414521792934d-1*t1*t155*t160*t62
     4         *t76+1.0d+0*t1*t291*t54+2.0d+0*t143*t54+t157*t339+t304+t3
     5         03+t237+t236+2.0d+0*t1*t102*t143)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*(9.327207260896466d-2*t1*t343*t6
     1         2*t76*t89+9.327207260896466d-2*t184*t62*t76*t89+9.3272072
     2         60896466d-2*t160*t62*t76*t89+1.8654414521792934d-1*t1*t16
     3         0*t184*t57*t76*t89-3.109069086965489d-2*t1*t177*t190*t305
     4         *t58*t89+9.327207260896466d-2*t1*t155*t184*t62*t76+9.3272
     5         07260896466d-2*t1*t155*t160*t62*t76+1.0d+0*t1*t342*t54+1.
     6         0d+0*t183*t54+1.0d+0*t143*t54+t157*t359+t304+t303+t237+t2
     7         36+1.0d+0*t1*t102*t183+1.0d+0*t1*t102*t143)*wght+Amat2(iq
     8         ,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(9.327207260896466d-2*t1*t369*t6
     1         2*t76*t89+1.8654414521792934d-1*t184*t62*t76*t89+1.865441
     2         4521792934d-1*t1*t368*t57*t76*t89-3.109069086965489d-2*t1
     3         *t305*t367*t58*t89+1.8654414521792934d-1*t1*t155*t184*t62
     4         *t76+1.0d+0*t1*t366*t54+2.0d+0*t183*t54+t157*t384+t304+t3
     5         03+t237+t236+2.0d+0*t1*t102*t183)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = t398+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = 1.0d+0*(t157*t411-3.109069086965489d-2
     1         *t1*t177*t196*t305*t58*t89)*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t398+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = t418+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = 1.0d+0*(t157*t424-3.109069086965489d-2
     1         *t1*t190*t196*t305*t58*t89)*wght+Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = t418+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = t430+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = t432+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t430+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 3.109069086965489d-2*t1*t157*t435*t58
     1         *t89*wght-3.109069086965489d-2*t1*t305*t433*t58*t89*wght+
     2         Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = t432+Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = t430+Cmat2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RA_TA) = t462+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = t462+Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_RB_TA) = t463+Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = t463+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GAA_TA) = t465+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = t465+Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_GAB_TA) = t466+Mmat2(iq,D2_GAB_TA)
            Mmat2(iq,D2_GAB_TB) = t466+Mmat2(iq,D2_GAB_TB)
            Mmat2(iq,D2_GBB_TA) = t465+Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = t465+Mmat2(iq,D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = t488+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = t488+Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = t488+Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(t157*(3.109069086965489d-2*t
     1         1*t58*(2.4517941994216663d+0*t160*t310*t59*t61*t69*t70*t7
     2         4-5.720853131983887d+0*t161*t162*t307*t59*t69*t70*t74+2.4
     3         517941994216663d+0*t169*t307*t59*t61*t70*t74-2.7242157771
     4         351844d-1*t541*t59*t61*t64*t69*t74+3.1782517399910504d-1*
     5         t160*t162*t313*t59*t64*t69*t74-6.674328653981203d+0*t160*
     6         t191*t311*t59*t64*t69*t74+1.906951043994629d+0*t161*t162*
     7         t310*t59*t64*t69*t74-3.2690589325622216d+0*t174*t538*t59*
     8         t61*t69*t74-8.172647331405554d-1*t160*t329*t59*t61*t64*t7
     9         4-8.172647331405554d-1*t169*t310*t59*t61*t64*t74+3.813902
     :         087989258d+0*t160*t161*t162*t169*t59*t64*t74+1.3621078885
     ;         675922d-1*(t580+t579+t578+t574+t573+t572+t571+t570+t568+t
     <         566+t565+t564+t563+t562+t561+t560+t559+t558+t557+t556+t55
     =         5+t554+t553+t552+t551+t550+t549+t548)*t59*t61*t63*t74-9.5
     >         34755219973146d-1*t161*t162*t329*t59*t63*t74-1.5891258699
     ?         955252d-1*t162*t169*t313*t59*t63*t74+3.3371643269906015d+
     @         0*t169*t191*t311*t59*t63*t74-1.3621078885675922d-1*t170*t
     1         59*t61*t63*t69*(-2.226405480117677d+0*t538*t585*t71*t72-7
     2         .421351600392256d-2*t174*t541*t71*t72+1.1132027400588385d
     3         +0*t160*t310*t333*t71*t72-5.19494612027458d+0*t161*t171*t
     4         172*t307*t333*t72-6.060770473653676d+0*t160*t171*t174*t31
     5         1*t330*t72+1.731648706758194d-1*t160*t171*t172*t174*t313*
     6         t72+1.0389892240549159d+0*t161*t171*t172*t174*t310*t72-3.
     7         710675800196128d-2*t175*t577*t65*t70*t71-3.71067580019612
     8         8d-2*t175*t569*t65*t70*t71-1.1132027400588385d-1*t167*t17
     9         5*t320*t65*t70*t71-4.452810960235354d-1*t575*t577*t586*t7
     :         0*t71+1.1132027400588385d-1*t324*t334*t577*t70*t71+1.1132
     ;         027400588385d-1*t324*t326*t334*t567*t70*t71+3.33960822017
     <         65154d-1*t167*t320*t324*t334*t70*t71-2.226405480117677d+0
     =         *t167*t175*t307*t333*t65*t71+4.452810960235354d-1*t160*t1
     >         74*t175*t326*t65*t71+4.452810960235354d-1*t160*t174*t175*
     ?         t320*t65*t71+4.452810960235354d-1*t167*t174*t175*t310*t65
     @         *t71-1.3358432880706061d+0*t160*t174*t324*t326*t334*t71-3
     1         .030385236826838d+0*t167*t171*t175*t311*t330*t65*t70+5.19
     2         494612027458d-1*t161*t171*t172*t175*t326*t65*t70+5.194946
     3         12027458d-1*t161*t171*t172*t175*t320*t65*t70+8.6582435337
     4         9097d-2*t167*t171*t172*t175*t313*t65*t70-1.55848383608237
     5         38d+0*t161*t171*t172*t324*t326*t334*t70-4.155956896219663
     6         6d+0*t160*t161*t167*t171*t172*t174*t175*t65+t584+t583+t58
     7         2+t580+t579+t578+t574+t573+t572+t571+t570+t568+t566+t565+
     8         t564+t563+t562+t561+t560+t559+t558+t557+t556+t555+t554+t5
     9         53+t552+t551+t550+t549+t548)-2.4517941994216663d+0*t170*t
     :         176*t307*t59*t61*t69*t70-1.6345294662811108d+0*t160*t336*
     ;         t337*t59*t61*t64*t69+8.172647331405554d-1*t160*t170*t335*
     <         t59*t61*t64*t69+8.172647331405554d-1*t170*t176*t310*t59*t
     =         61*t64*t69-3.813902087989258d+0*t160*t161*t162*t170*t176*
     >         t59*t64*t69-8.172647331405554d-1*t176**3*t587*t59*t61*t63
     ?         *t69+8.172647331405554d-1*t176*t335*t336*t59*t61*t63*t69-
     @         1.906951043994629d+0*t161*t162*t336*t337*t59*t63*t69+9.53
     1         4755219973146d-1*t161*t162*t170*t335*t59*t63*t69+1.589125
     2         8699955252d-1*t162*t170*t176*t313*t59*t63*t69-3.337164326
     3         9906015d+0*t170*t176*t191*t311*t59*t63*t69+1.634529466281
     4         1108d+0*t160*t169*t170*t176*t59*t61*t64+8.172647331405554
     5         d-1*t169*t336*t337*t59*t61*t63-4.086323665702777d-1*t169*
     6         t170*t335*t59*t61*t63-4.086323665702777d-1*t170*t176*t329
     7         *t59*t61*t63+1.906951043994629d+0*t161*t162*t169*t170*t17
     8         6*t59*t63+t547+t545+t543)*t89+2.7981621782689403d-1*t1*t1
     9         60*t338*t62*t89+2.7981621782689403d-1*t1*t177*t310*t62*t8
     :         9+5.596324356537881d-1*t160*t177*t62*t89+9.32720726089646
     ;         6d-2*t338*t58*t89+5.596324356537881d-1*t1*t177*t307*t57*t
     <         89+5.596324356537881d-1*t1*t155*t160*t177*t62+9.327207260
     =         896466d-2*t1*t155*t338*t58+9.327207260896466d-2*t1*t177*t
     >         302*t58+1.8654414521792934d-1*t155*t177*t58)+t305*(-9.327
     ?         207260896466d-2*t1*t160*t306*t62*t89-6.218138173930978d-2
     @         *t1*t177*t338*t58*t89+t589+t588-t177*t339)+9.327207260896
     1         466d-2*t1*t541*t62*t76*t89+2.7981621782689403d-1*t310*t62
     2         *t76*t89+5.596324356537881d-1*t1*t160*t310*t57*t76*t89+5.
     3         596324356537881d-1*t307*t57*t76*t89+1.8654414521792934d-1
     4         *t1*t538*t76*t89+6.218138173930978d-2*t1*t177**3*t537*t58
     5         *t89+2.7981621782689403d-1*t1*t155*t310*t62*t76+2.7981621
     6         782689403d-1*t1*t160*t302*t62*t76+5.596324356537881d-1*t1
     7         55*t160*t62*t76+5.596324356537881d-1*t1*t155*t307*t57*t76
     8         +1.0d+0*t1*t534*t54+3.0d+0*t291*t54+t536+t535+t491+t490+3
     9         .0d+0*t1*t102*t291+3.0d+0*t1*t143*t235+6.0d+0*t102*t143)*
     :         wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*(t157*(3.109069086965489d-2*t
     1         1*t58*(1.6345294662811108d+0*t160*t343*t59*t61*t69*t70*t7
     2         4+8.172647331405554d-1*t184*t310*t59*t61*t69*t70*t74-1.90
     3         69510439946294d+0*t161*t162*t307*t59*t69*t70*t74+8.172647
     4         331405554d-1*t188*t307*t59*t61*t70*t74+1.6345294662811108
     5         d+0*t160*t169*t184*t59*t61*t70*t74-2.7242157771351844d-1*
     6         t59*t602*t61*t64*t69*t74+1.0594172466636834d-1*t162*t184*
     7         t313*t59*t64*t69*t74+2.1188344933273667d-1*t160*t162*t313
     8         *t59*t64*t69*t74-2.2247762179937342d+0*t184*t191*t311*t59
     9         *t64*t69*t74-4.4495524359874683d+0*t160*t191*t311*t59*t64
     :         *t69*t74+6.356503479982097d-1*t161*t162*t310*t59*t64*t69*
     ;         t74-3.2690589325622216d+0*t174*t184*t307*t59*t61*t69*t74+
     <         1.3621078885675922d-1*t59*t61*t63*(t665+t663+t662+t661+t6
     =         60+t659+t658+t657+t656+t654+t653+t652+t651+t650+t649+t648
     >         +t647+t646+t645+t644+t643+t642+t641+t640+t639+t638+t637+t
     ?         636+t635+t634+t633+t632+t631+t630+t629+t628+t627+t626+t62
     @         5+t624+t623+t622+t621+t620+t557+t556+t555)*t74-5.44843155
     1         4270369d-1*t160*t356*t59*t61*t64*t74-5.448431554270369d-1
     2         *t169*t343*t59*t61*t64*t74-2.7242157771351844d-1*t184*t32
     3         9*t59*t61*t64*t74-2.7242157771351844d-1*t188*t310*t59*t61
     4         *t64*t74+1.2713006959964196d+0*t160*t161*t162*t169*t59*t6
     5         4*t74-3.1782517399910487d-1*t161*t162*t329*t59*t63*t74-5.
     6         297086233318417d-2*t162*t188*t313*t59*t63*t74-1.059417246
     7         6636834d-1*t162*t169*t313*t59*t63*t74+1.1123881089968671d
     8         +0*t188*t191*t311*t59*t63*t74+2.2247762179937342d+0*t169*
     9         t191*t311*t59*t63*t74-1.3621078885675922d-1*t170*t59*t61*
     :         t63*t69*(-7.421351600392256d-2*t174*t602*t71*t72-2.226405
     ;         480117677d+0*t184*t307*t585*t71*t72+7.421351600392256d-1*
     <         t160*t333*t343*t71*t72+3.710675800196128d-1*t184*t310*t33
     =         3*t71*t72-1.7316487067581932d+0*t161*t171*t172*t307*t333*
     >         t72-2.0202568245512253d+0*t171*t174*t184*t311*t330*t72-4.
     ?         0405136491024507d+0*t160*t171*t174*t311*t330*t72+5.772162
     @         355860646d-2*t171*t172*t174*t184*t313*t72+1.1544324711721
     1         293d-1*t160*t171*t172*t174*t313*t72+3.4632974135163863d-1
     2         *t161*t171*t172*t174*t310*t72+1.1132027400588385d-1*t324*
     3         t326*t334*t664*t70*t71-3.710675800196128d-2*t175*t65*t655
     4         *t70*t71-7.421351600392256d-2*t167*t175*t348*t65*t70*t71-
     5         3.710675800196128d-2*t175*t186*t326*t65*t70*t71-3.7106758
     6         00196128d-2*t175*t186*t320*t65*t70*t71-4.452810960235354d
     7         -1*t186*t326*t575*t586*t70*t71+2.226405480117677d-1*t167*
     8         t324*t334*t348*t70*t71+1.1132027400588385d-1*t186*t324*t3
     9         26*t334*t70*t71+1.1132027400588385d-1*t186*t320*t324*t334
     :         *t70*t71+2.9685406401569026d-1*t160*t174*t175*t348*t65*t7
     ;         1+2.9685406401569026d-1*t167*t174*t175*t343*t65*t71-7.421
     <         351600392256d-1*t175*t186*t307*t333*t65*t71-1.48427032007
     =         84513d+0*t160*t167*t175*t184*t333*t65*t71+1.4842703200784
     >         513d-1*t174*t175*t184*t326*t65*t71+1.4842703200784513d-1*
     ?         t174*t175*t184*t320*t65*t71+1.4842703200784513d-1*t174*t1
     @         75*t186*t310*t65*t71+2.9685406401569026d-1*t160*t167*t174
     1         *t175*t186*t65*t71-4.452810960235354d-1*t174*t184*t324*t3
     2         26*t334*t71-8.905621920470708d-1*t160*t167*t174*t186*t324
     3         *t334*t71-1.0101284122756127d+0*t171*t175*t186*t311*t330*
     4         t65*t70-2.0202568245512253d+0*t167*t171*t175*t311*t330*t6
     5         5*t70+1.7316487067581932d-1*t161*t171*t172*t175*t326*t65*
     6         t70+1.7316487067581932d-1*t161*t171*t172*t175*t320*t65*t7
     7         0+2.886081177930323d-2*t171*t172*t175*t186*t313*t65*t70+5
     8         .772162355860646d-2*t167*t171*t172*t175*t313*t65*t70-5.19
     9         494612027458d-1*t161*t171*t172*t324*t326*t334*t70+t672+t6
     :         71+t670+t669+t668+t667+t666+t665+t663+t662+t661+t660+t659
     ;         +t658+t657+t656+t654+t653+t652+t651+t650-1.38531896540655
     <         45d+0*t160*t161*t167*t171*t172*t174*t175*t65+t649+t648+t6
     =         47+t646+t645+t644+t643+t642+t641+t640+t639+t638+t637+t636
     >         +t635+t634+t633+t632+t631+t630+t629+t628+t627+t626+t625+t
     ?         624+t623+t622+t621+t620+t584+t583+t582+t557+t556+t555)-8.
     @         172647331405554d-1*t170*t189*t307*t59*t61*t69*t70-1.63452
     1         94662811108d+0*t160*t170*t176*t184*t59*t61*t69*t70+5.4484
     2         31554270369d-1*t160*t170*t357*t59*t61*t64*t69+5.448431554
     3         270369d-1*t170*t176*t343*t59*t61*t64*t69-5.44843155427036
     4         9d-1*t184*t336*t337*t59*t61*t64*t69-1.0896863108540737d+0
     5         *t160*t176*t189*t336*t59*t61*t64*t69+2.7242157771351844d-
     6         1*t170*t184*t335*t59*t61*t64*t69+2.7242157771351844d-1*t1
     7         70*t189*t310*t59*t61*t64*t69-1.2713006959964196d+0*t160*t
     8         161*t162*t170*t176*t59*t64*t69-8.172647331405554d-1*t189*
     9         t337*t587*t59*t61*t63*t69+5.448431554270369d-1*t176*t336*
     :         t357*t59*t61*t63*t69+2.7242157771351844d-1*t189*t335*t336
     ;         *t59*t61*t63*t69-6.356503479982097d-1*t161*t162*t336*t337
     <         *t59*t63*t69+3.1782517399910487d-1*t161*t162*t170*t335*t5
     =         9*t63*t69+5.297086233318417d-2*t162*t170*t189*t313*t59*t6
     >         3*t69+1.0594172466636834d-1*t162*t170*t176*t313*t59*t63*t
     ?         69-1.1123881089968671d+0*t170*t189*t191*t311*t59*t63*t69-
     @         2.2247762179937342d+0*t170*t176*t191*t311*t59*t63*t69+5.4
     1         48431554270369d-1*t160*t169*t170*t189*t59*t61*t64+5.44843
     2         1554270369d-1*t160*t170*t176*t188*t59*t61*t64+5.448431554
     3         270369d-1*t169*t170*t176*t184*t59*t61*t64-2.7242157771351
     4         844d-1*t169*t170*t357*t59*t61*t63-2.7242157771351844d-1*t
     5         170*t176*t356*t59*t61*t63+2.7242157771351844d-1*t188*t336
     6         *t337*t59*t61*t63+5.448431554270369d-1*t169*t176*t189*t33
     7         6*t59*t61*t63-1.3621078885675922d-1*t170*t188*t335*t59*t6
     8         1*t63-1.3621078885675922d-1*t170*t189*t329*t59*t61*t63+6.
     9         356503479982097d-1*t161*t162*t169*t170*t176*t59*t63+t619+
     :         t618+t617+t616+t615+t614+t613+t612+t611+t610+t609+t547+t5
     ;         45+t543)*t89+1.8654414521792934d-1*t1*t160*t358*t62*t89+1
     <         .8654414521792934d-1*t1*t177*t343*t62*t89+9.3272072608964
     =         66d-2*t1*t184*t338*t62*t89+9.327207260896466d-2*t1*t190*t
     >         310*t62*t89+1.8654414521792934d-1*t160*t177*t62*t89+3.109
     ?         069086965489d-2*t338*t58*t89+1.8654414521792934d-1*t1*t19
     @         0*t307*t57*t89+3.7308829043585867d-1*t1*t160*t177*t184*t5
     1         7*t89+1.8654414521792934d-1*t1*t155*t160*t177*t62+t608+t6
     2         07+t606+t605+t604+t603+3.109069086965489d-2*t1*t155*t338*
     3         t58+3.109069086965489d-2*t1*t190*t302*t58+6.2181381739309
     4         78d-2*t1*t177*t302*t58+6.218138173930978d-2*t155*t190*t58
     5         +1.2436276347861956d-1*t155*t177*t58)+t305*(-9.3272072608
     6         96466d-2*t1*t184*t306*t62*t89-6.218138173930978d-2*t1*t17
     7         7*t358*t58*t89+t589+t588-t190*t339)+9.327207260896466d-2*
     8         t1*t602*t62*t76*t89+9.327207260896466d-2*t310*t62*t76*t89
     9         +3.7308829043585867d-1*t1*t160*t343*t57*t76*t89+1.8654414
     :         521792934d-1*t1*t184*t310*t57*t76*t89+1.8654414521792934d
     ;         -1*t307*t57*t76*t89+1.8654414521792934d-1*t1*t184*t307*t7
     <         6*t89+6.218138173930978d-2*t1*t190*t306*t537*t58*t89+9.32
     =         7207260896466d-2*t1*t155*t310*t62*t76+9.327207260896466d-
     >         2*t1*t184*t302*t62*t76+1.8654414521792934d-1*t1*t160*t302
     ?         *t62*t76+1.8654414521792934d-1*t155*t184*t62*t76+3.730882
     @         9043585867d-1*t155*t160*t62*t76+1.8654414521792934d-1*t1*
     1         t155*t307*t57*t76+t601+t600+t599+t598+1.0d+0*t1*t54*t597+
     2         t591+t590+1.0d+0*t291*t54+t536+t535+t491+t490+1.0d+0*t1*t
     3         102*t291+1.0d+0*t1*t183*t235+2.0d+0*t1*t143*t235+2.0d+0*t
     4         102*t183+4.0d+0*t102*t143)*wght+Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = 1.0d+0*(t157*(3.109069086965489d-2*t
     1         1*t58*(1.3621078885675922d-1*t59*t61*t63*(t712+t711+t710+
     2         t709+t708+t706+t705+t704+t703+t702+t701+t700+t699+t698+t6
     3         97+t696+t695+t694+t693+t692+t691+t690+t689+t688+t687+t686
     4         +t685+t684+t683+t682+t681+t680+t679+t678+t677+t676+t675+t
     5         654+t652+t645+t638+t633+t625+t623+t557+t556+t555)*t74+8.1
     6         72647331405554d-1*t160*t369*t59*t61*t69*t70*t74+1.6345294
     7         662811108d+0*t184*t343*t59*t61*t69*t70*t74-1.906951043994
     8         629d+0*t161*t162*t368*t59*t69*t70*t74+8.172647331405554d-
     9         1*t169*t368*t59*t61*t70*t74+1.6345294662811108d+0*t160*t1
     :         84*t188*t59*t61*t70*t74-2.7242157771351844d-1*t59*t61*t64
     ;         *t674*t69*t74+6.356503479982097d-1*t161*t162*t369*t59*t64
     <         *t69*t74+2.1188344933273667d-1*t162*t184*t313*t59*t64*t69
     =         *t74+1.0594172466636834d-1*t160*t162*t313*t59*t64*t69*t74
     >         -4.4495524359874683d+0*t184*t191*t311*t59*t64*t69*t74-2.2
     ?         247762179937342d+0*t160*t191*t311*t59*t64*t69*t74-3.26905
     @         89325622216d+0*t160*t174*t368*t59*t61*t69*t74-2.724215777
     1         1351844d-1*t160*t380*t59*t61*t64*t74-2.7242157771351844d-
     2         1*t169*t369*t59*t61*t64*t74-5.448431554270369d-1*t184*t35
     3         6*t59*t61*t64*t74-5.448431554270369d-1*t188*t343*t59*t61*
     4         t64*t74+1.2713006959964196d+0*t161*t162*t184*t188*t59*t64
     5         *t74-3.1782517399910487d-1*t161*t162*t380*t59*t63*t74-1.0
     6         594172466636834d-1*t162*t188*t313*t59*t63*t74-5.297086233
     7         318417d-2*t162*t169*t313*t59*t63*t74+2.2247762179937342d+
     8         0*t188*t191*t311*t59*t63*t74+1.1123881089968671d+0*t169*t
     9         191*t311*t59*t63*t74-1.3621078885675922d-1*t170*t59*t61*t
     :         63*t69*(-7.421351600392256d-2*t174*t674*t71*t72-2.2264054
     ;         80117677d+0*t160*t368*t585*t71*t72+3.710675800196128d-1*t
     <         160*t333*t369*t71*t72+7.421351600392256d-1*t184*t333*t343
     =         *t71*t72+3.4632974135163863d-1*t161*t171*t172*t174*t369*t
     >         72-1.7316487067581932d+0*t161*t171*t172*t333*t368*t72-4.0
     ?         405136491024507d+0*t171*t174*t184*t311*t330*t72-2.0202568
     @         245512253d+0*t160*t171*t174*t311*t330*t72+1.1544324711721
     1         293d-1*t171*t172*t174*t184*t313*t72+5.772162355860646d-2*
     2         t160*t171*t172*t174*t313*t72+t712+t711+t710-3.71067580019
     3         6128d-2*t175*t65*t70*t707*t71+1.1132027400588385d-1*t167*
     4         t186*t324*t334*t664*t70*t71-3.710675800196128d-2*t167*t17
     5         5*t377*t65*t70*t71-3.710675800196128d-2*t167*t175*t373*t6
     6         5*t70*t71-7.421351600392256d-2*t175*t186*t348*t65*t70*t71
     7         -4.452810960235354d-1*t167*t377*t575*t586*t70*t71+1.11320
     8         27400588385d-1*t167*t324*t334*t377*t70*t71+1.113202740058
     9         8385d-1*t167*t324*t334*t373*t70*t71+2.226405480117677d-1*
     :         t186*t324*t334*t348*t70*t71+1.4842703200784513d-1*t160*t1
     ;         74*t175*t377*t65*t71+1.4842703200784513d-1*t160*t174*t175
     <         *t373*t65*t71+1.4842703200784513d-1*t167*t174*t175*t369*t
     =         65*t71-7.421351600392256d-1*t167*t175*t333*t368*t65*t71+2
     >         .9685406401569026d-1*t174*t175*t184*t348*t65*t71+2.968540
     ?         6401569026d-1*t174*t175*t186*t343*t65*t71-1.4842703200784
     @         513d+0*t160*t175*t184*t186*t333*t65*t71+2.968540640156902
     1         6d-1*t167*t174*t175*t184*t186*t65*t71-4.452810960235354d-
     2         1*t160*t174*t324*t334*t377*t71-8.905621920470708d-1*t167*
     3         t174*t184*t186*t324*t334*t71+t709+t708+t706+t705+t704+t70
     4         3+t702+t701+t700+1.7316487067581932d-1*t161*t171*t172*t17
     5         5*t377*t65*t70+1.7316487067581932d-1*t161*t171*t172*t175*
     6         t373*t65*t70-2.0202568245512253d+0*t171*t175*t186*t311*t3
     7         30*t65*t70-1.0101284122756127d+0*t167*t171*t175*t311*t330
     8         *t65*t70+5.772162355860646d-2*t171*t172*t175*t186*t313*t6
     9         5*t70+2.886081177930323d-2*t167*t171*t172*t175*t313*t65*t
     :         70-5.19494612027458d-1*t161*t171*t172*t324*t334*t377*t70+
     ;         t699+t698+t697+t696+t695+t694+t693+t692+t691+t690+t689+t6
     <         88+t687+t686+t685+t684+t683+t682+t681+t680+t679+t678+t677
     =         +t676+t675+t672+t671+t670+t669+t668+t667+t666+t654+t652-1
     >         .3853189654065545d+0*t161*t171*t172*t174*t175*t184*t186*t
     ?         65+t645+t638+t633+t625+t623+t584+t583+t582+t557+t556+t555
     @         )-8.172647331405554d-1*t170*t176*t368*t59*t61*t69*t70-1.6
     1         345294662811108d+0*t160*t170*t184*t189*t59*t61*t69*t70-5.
     2         448431554270369d-1*t160*t336*t382*t59*t61*t64*t69+2.72421
     3         57771351844d-1*t160*t170*t381*t59*t61*t64*t69+2.724215777
     4         1351844d-1*t170*t176*t369*t59*t61*t64*t69+5.4484315542703
     5         69d-1*t170*t184*t357*t59*t61*t64*t69+5.448431554270369d-1
     6         *t170*t189*t343*t59*t61*t64*t69-1.0896863108540737d+0*t17
     7         6*t184*t189*t336*t59*t61*t64*t69-1.2713006959964196d+0*t1
     8         61*t162*t170*t184*t189*t59*t64*t69-8.172647331405554d-1*t
     9         176*t382*t587*t59*t61*t63*t69+2.7242157771351844d-1*t176*
     :         t336*t381*t59*t61*t63*t69+5.448431554270369d-1*t189*t336*
     ;         t357*t59*t61*t63*t69-6.356503479982097d-1*t161*t162*t336*
     <         t382*t59*t63*t69+3.1782517399910487d-1*t161*t162*t170*t38
     =         1*t59*t63*t69+1.0594172466636834d-1*t162*t170*t189*t313*t
     >         59*t63*t69+5.297086233318417d-2*t162*t170*t176*t313*t59*t
     ?         63*t69-2.2247762179937342d+0*t170*t189*t191*t311*t59*t63*
     @         t69-1.1123881089968671d+0*t170*t176*t191*t311*t59*t63*t69
     1         +5.448431554270369d-1*t160*t170*t188*t189*t59*t61*t64+5.4
     2         48431554270369d-1*t169*t170*t184*t189*t59*t61*t64+5.44843
     3         1554270369d-1*t170*t176*t184*t188*t59*t61*t64+2.724215777
     4         1351844d-1*t169*t336*t382*t59*t61*t63-1.3621078885675922d
     5         -1*t169*t170*t381*t59*t61*t63-1.3621078885675922d-1*t170*
     6         t176*t380*t59*t61*t63-2.7242157771351844d-1*t170*t188*t35
     7         7*t59*t61*t63-2.7242157771351844d-1*t170*t189*t356*t59*t6
     8         1*t63+5.448431554270369d-1*t176*t188*t189*t336*t59*t61*t6
     9         3+6.356503479982097d-1*t161*t162*t170*t188*t189*t59*t63+t
     :         619+t618+t617+t616+t615+t614+t613+t612+t611+t610+t609+t54
     ;         7+t545+t543)*t89+9.327207260896466d-2*t1*t160*t383*t62*t8
     <         9+9.327207260896466d-2*t1*t177*t369*t62*t89+1.86544145217
     =         92934d-1*t1*t184*t358*t62*t89+1.8654414521792934d-1*t1*t1
     >         90*t343*t62*t89+1.8654414521792934d-1*t184*t190*t62*t89+3
     ?         .109069086965489d-2*t383*t58*t89+1.8654414521792934d-1*t1
     @         *t177*t368*t57*t89+3.7308829043585867d-1*t1*t160*t184*t19
     1         0*t57*t89+1.8654414521792934d-1*t1*t155*t184*t190*t62+t60
     2         8+t607+t606+t605+t604+t603+3.109069086965489d-2*t1*t155*t
     3         383*t58+6.218138173930978d-2*t1*t190*t302*t58+3.109069086
     4         965489d-2*t1*t177*t302*t58+1.2436276347861956d-1*t155*t19
     5         0*t58+6.218138173930978d-2*t155*t177*t58)+t305*(-9.327207
     6         260896466d-2*t1*t177*t184*t190*t62*t89-3.109069086965489d
     7         -2*t1*t177*t383*t58*t89-3.109069086965489d-2*t1*t190*t358
     8         *t58*t89-3.109069086965489d-2*t177*t190*t58*t89-3.1090690
     9         86965489d-2*t1*t155*t177*t190*t58-t190*t359)+9.3272072608
     :         96466d-2*t1*t62*t674*t76*t89+9.327207260896466d-2*t369*t6
     ;         2*t76*t89+1.8654414521792934d-1*t1*t160*t369*t57*t76*t89+
     <         1.8654414521792934d-1*t368*t57*t76*t89+3.7308829043585867
     =         d-1*t1*t184*t343*t57*t76*t89+1.8654414521792934d-1*t1*t16
     >         0*t368*t76*t89+6.218138173930978d-2*t1*t177*t367*t537*t58
     ?         *t89+9.327207260896466d-2*t1*t155*t369*t62*t76+1.86544145
     @         21792934d-1*t1*t184*t302*t62*t76+9.327207260896466d-2*t1*
     1         t160*t302*t62*t76+3.7308829043585867d-1*t155*t184*t62*t76
     2         +1.8654414521792934d-1*t155*t160*t62*t76+1.86544145217929
     3         34d-1*t1*t155*t368*t57*t76+1.0d+0*t1*t54*t673+t601+t600+t
     4         599+t598+t591+t590+1.0d+0*t366*t54+t536+t535+t491+t490+1.
     5         0d+0*t1*t102*t366+2.0d+0*t1*t183*t235+1.0d+0*t1*t143*t235
     6         +4.0d+0*t102*t183+2.0d+0*t102*t143)*wght+Amat3(iq,D3_RA_R
     7         B_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*(t157*(3.109069086965489d-2*t
     1         1*t58*(-1.3621078885675922d-1*t170*t59*t61*t63*t69*(t746+
     2         t745+t744-3.710675800196128d-2*t175*t65*t70*t71*t743-4.45
     3         2810960235354d-1*t575*t586*t70*t71*t743+1.113202740058838
     4         5d-1*t324*t334*t70*t71*t743+t742+t741+t740+t739+t738-3.71
     5         0675800196128d-2*t175*t65*t70*t71*t737+t736+t735+t734+t73
     6         3+t732+t731+t730+t729+t728+t727+t726+t725+t724+t723+t722+
     7         t721+t720-7.421351600392256d-2*t174*t71*t719*t72-2.226405
     8         480117677d+0*t585*t71*t718*t72+1.1132027400588385d+0*t184
     9         *t333*t369*t71*t72+1.0389892240549159d+0*t161*t171*t172*t
     :         174*t369*t72-5.19494612027458d+0*t161*t171*t172*t333*t368
     ;         *t72-6.060770473653676d+0*t171*t174*t184*t311*t330*t72+1.
     <         731648706758194d-1*t171*t172*t174*t184*t313*t72+1.1132027
     =         400588385d-1*t324*t334*t377*t664*t70*t71-1.11320274005883
     >         85d-1*t175*t186*t373*t65*t70*t71+3.3396082201765154d-1*t1
     ?         86*t324*t334*t373*t70*t71+4.452810960235354d-1*t174*t175*
     @         t184*t377*t65*t71+4.452810960235354d-1*t174*t175*t184*t37
     1         3*t65*t71+4.452810960235354d-1*t174*t175*t186*t369*t65*t7
     2         1-2.226405480117677d+0*t175*t186*t333*t368*t65*t71-1.3358
     3         432880706061d+0*t174*t184*t324*t334*t377*t71+5.1949461202
     4         7458d-1*t161*t171*t172*t175*t377*t65*t70+5.19494612027458
     5         d-1*t161*t171*t172*t175*t373*t65*t70-3.030385236826838d+0
     6         *t171*t175*t186*t311*t330*t65*t70+8.65824353379097d-2*t17
     7         1*t172*t175*t186*t313*t65*t70-1.5584838360823738d+0*t161*
     8         t171*t172*t324*t334*t377*t70-4.1559568962196636d+0*t161*t
     9         171*t172*t174*t175*t184*t186*t65+t584+t583+t582+t557+t556
     :         +t555)+1.3621078885675922d-1*t59*t61*t63*t74*(t746+t745+t
     ;         744+t742+t741+t740+t739+t738+t736+t735+t734+t733+t732+t73
     <         1+t730+t729+t728+t727+t726+t725+t724+t723+t722+t721+t720+
     =         t557+t556+t555)-2.7242157771351844d-1*t59*t61*t64*t69*t71
     >         9*t74-3.2690589325622216d+0*t174*t59*t61*t69*t718*t74+2.4
     ?         517941994216663d+0*t184*t369*t59*t61*t69*t70*t74-5.720853
     @         131983887d+0*t161*t162*t368*t59*t69*t70*t74+2.45179419942
     1         16663d+0*t188*t368*t59*t61*t70*t74+1.906951043994629d+0*t
     2         161*t162*t369*t59*t64*t69*t74+3.1782517399910504d-1*t162*
     3         t184*t313*t59*t64*t69*t74-6.674328653981203d+0*t184*t191*
     4         t311*t59*t64*t69*t74-8.172647331405554d-1*t184*t380*t59*t
     5         61*t64*t74-8.172647331405554d-1*t188*t369*t59*t61*t64*t74
     6         +3.813902087989258d+0*t161*t162*t184*t188*t59*t64*t74-9.5
     7         34755219973146d-1*t161*t162*t380*t59*t63*t74-1.5891258699
     8         955252d-1*t162*t188*t313*t59*t63*t74+3.3371643269906015d+
     9         0*t188*t191*t311*t59*t63*t74-2.4517941994216663d+0*t170*t
     :         189*t368*t59*t61*t69*t70-1.6345294662811108d+0*t184*t336*
     ;         t382*t59*t61*t64*t69+8.172647331405554d-1*t170*t184*t381*
     <         t59*t61*t64*t69+8.172647331405554d-1*t170*t189*t369*t59*t
     =         61*t64*t69-3.813902087989258d+0*t161*t162*t170*t184*t189*
     >         t59*t64*t69-8.172647331405554d-1*t189**3*t587*t59*t61*t63
     ?         *t69+8.172647331405554d-1*t189*t336*t381*t59*t61*t63*t69-
     @         1.906951043994629d+0*t161*t162*t336*t382*t59*t63*t69+9.53
     1         4755219973146d-1*t161*t162*t170*t381*t59*t63*t69+1.589125
     2         8699955252d-1*t162*t170*t189*t313*t59*t63*t69-3.337164326
     3         9906015d+0*t170*t189*t191*t311*t59*t63*t69+1.634529466281
     4         1108d+0*t170*t184*t188*t189*t59*t61*t64+8.172647331405554
     5         d-1*t188*t336*t382*t59*t61*t63-4.086323665702777d-1*t170*
     6         t188*t381*t59*t61*t63-4.086323665702777d-1*t170*t189*t380
     7         *t59*t61*t63+1.906951043994629d+0*t161*t162*t170*t188*t18
     8         9*t59*t63+t547+t545+t543)*t89+2.7981621782689403d-1*t1*t1
     9         84*t383*t62*t89+2.7981621782689403d-1*t1*t190*t369*t62*t8
     :         9+5.596324356537881d-1*t184*t190*t62*t89+9.32720726089646
     ;         6d-2*t383*t58*t89+5.596324356537881d-1*t1*t190*t368*t57*t
     <         89+5.596324356537881d-1*t1*t155*t184*t190*t62+9.327207260
     =         896466d-2*t1*t155*t383*t58+9.327207260896466d-2*t1*t190*t
     >         302*t58+1.8654414521792934d-1*t155*t190*t58)+t305*(-9.327
     ?         207260896466d-2*t1*t184*t367*t62*t89-6.218138173930978d-2
     @         *t1*t190*t383*t58*t89-3.109069086965489d-2*t367*t58*t89-3
     1         .109069086965489d-2*t1*t155*t367*t58-t190*t384)+9.3272072
     2         60896466d-2*t1*t62*t719*t76*t89+1.8654414521792934d-1*t1*
     3         t718*t76*t89+2.7981621782689403d-1*t369*t62*t76*t89+5.596
     4         324356537881d-1*t1*t184*t369*t57*t76*t89+5.59632435653788
     5         1d-1*t368*t57*t76*t89+6.218138173930978d-2*t1*t190**3*t53
     6         7*t58*t89+2.7981621782689403d-1*t1*t155*t369*t62*t76+2.79
     7         81621782689403d-1*t1*t184*t302*t62*t76+5.596324356537881d
     8         -1*t155*t184*t62*t76+5.596324356537881d-1*t1*t155*t368*t5
     9         7*t76+1.0d+0*t1*t54*t717+3.0d+0*t366*t54+t536+t535+t491+t
     :         490+3.0d+0*t1*t102*t366+3.0d+0*t1*t183*t235+6.0d+0*t102*t
     ;         183)*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = t774+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = 1.0d+0*(t157*(3.109069086965489d-2*
     1         t1*t58*(-1.3621078885675922d-1*t170*t59*t61*t63*t69*(t794
     2         +t793+t792+t791+t790+t789+t788+t787+t786+t785+t784+t783+1
     3         .4842703200784513d+0*t191*t307*t333*t59*t72-2.96854064015
     4         69026d-1*t174*t191*t310*t59*t72+2.770637930813109d+0*t160
     5         *t161*t172*t174*t59*t72-1.4842703200784513d-1*t175*t191*t
     6         326*t59*t65*t70-1.4842703200784513d-1*t175*t191*t320*t59*
     7         t65*t70+1.3853189654065545d+0*t161*t167*t172*t175*t59*t65
     8         *t70+4.452810960235354d-1*t191*t324*t326*t334*t59*t70+1.1
     9         87416256062761d+0*t160*t167*t174*t175*t191*t59*t65)+1.362
     :         1078885675922d-1*t59*t61*t63*t74*(t792+t791+t790+t789+t78
     ;         8+t787+t786+t785+t784+t783)+t782+t781+t780+t779+t778+t777
     <         +1.6345294662811108d+0*t307*t61*t69*t70*t74-5.44843155427
     =         0369d-1*t310*t61*t64*t69*t74+2.542601391992839d+0*t160*t1
     >         61*t162*t64*t69*t74+2.2264054801176772d-1*t191*t307*t333*
     ?         t59*t67*t74-7.421351600392256d-2*t174*t191*t310*t59*t67*t
     @         74+3.463297413516387d-1*t160*t161*t172*t174*t59*t67*t74-5
     1         .448431554270369d-1*t160*t407*t59*t61*t64*t74-1.089686310
     2         8540737d+0*t160*t169*t61*t64*t74+2.7242157771351844d-1*t3
     3         29*t61*t63*t74-6.356503479982097d-1*t161*t162*t407*t59*t6
     4         3*t74-1.2713006959964196d+0*t161*t162*t169*t63*t74-8.1726
     5         47331405554d-1*t170*t195*t307*t59*t61*t69*t70+7.421351600
     6         392256d-2*t191*t336*t337*t59*t67*t70-3.710675800196128d-2
     7         *t170*t191*t335*t59*t67*t70+1.7316487067581934d-1*t161*t1
     8         70*t172*t176*t59*t67*t70+5.448431554270369d-1*t160*t170*t
     9         409*t59*t61*t64*t69-1.0896863108540737d+0*t160*t176*t195*
     :         t336*t59*t61*t64*t69+2.7242157771351844d-1*t170*t195*t310
     ;         *t59*t61*t64*t69+1.0896863108540737d+0*t160*t170*t176*t61
     <         *t64*t69-1.2713006959964196d+0*t160*t161*t162*t170*t195*t
     =         59*t64*t69-8.172647331405554d-1*t195*t337*t587*t59*t61*t6
     >         3*t69+5.448431554270369d-1*t176*t336*t409*t59*t61*t63*t69
     ?         +2.7242157771351844d-1*t195*t335*t336*t59*t61*t63*t69+5.4
     @         48431554270369d-1*t336*t337*t61*t63*t69-2.724215777135184
     1         4d-1*t170*t335*t61*t63*t69+6.356503479982097d-1*t161*t162
     2         *t170*t409*t59*t63*t69-1.2713006959964196d+0*t161*t162*t1
     3         76*t195*t336*t59*t63*t69+1.2713006959964196d+0*t161*t162*
     4         t170*t176*t63*t69+1.4842703200784513d-1*t160*t170*t174*t1
     5         76*t191*t59*t67+5.448431554270369d-1*t160*t169*t170*t195*
     6         t59*t61*t64-2.7242157771351844d-1*t169*t170*t409*t59*t61*
     7         t63-2.7242157771351844d-1*t170*t176*t407*t59*t61*t63+5.44
     8         8431554270369d-1*t169*t176*t195*t336*t59*t61*t63-1.362107
     9         8885675922d-1*t170*t195*t329*t59*t61*t63-5.44843155427036
     :         9d-1*t169*t170*t176*t61*t63+6.356503479982097d-1*t161*t16
     ;         2*t169*t170*t195*t59*t63)*t89+1.8654414521792934d-1*t1*t1
     <         60*t410*t62*t89+9.327207260896466d-2*t1*t196*t310*t62*t89
     =         +1.8654414521792934d-1*t160*t196*t62*t89+6.21813817393097
     >         8d-2*t410*t58*t89+1.8654414521792934d-1*t1*t196*t307*t57*
     ?         t89+t776+t775+1.8654414521792934d-1*t1*t155*t160*t196*t62
     @         +6.218138173930978d-2*t1*t155*t410*t58)+t305*(-6.21813817
     1         3930978d-2*t1*t177*t410*t58*t89-t196*t339)+6.218138173930
     2         978d-2*t1*t196*t306*t537*t58*t89)*wght+Cmat3(iq,D3_RA_RA_
     3         GAB)
            Cmat3(iq,D3_RA_RA_GBB) = t774+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = t806+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = 1.0d+0*(t157*(3.109069086965489d-2*
     1         t1*t58*(-1.3621078885675922d-1*t170*t59*t61*t63*t69*(t822
     2         +t821+t820+t819+t818+t817+t816+t815+t814+t813+t812+t794+t
     3         793+t787+t786+t773+t770+t767+t762-2.9685406401569026d-1*t
     4         174*t191*t343*t59*t72+1.4842703200784513d+0*t160*t184*t19
     5         1*t333*t59*t72-1.4842703200784513d-1*t175*t191*t348*t59*t
     6         65*t70-1.4842703200784513d-1*t167*t175*t186*t191*t59*t65*
     7         t70+4.452810960235354d-1*t167*t186*t191*t324*t334*t59*t70
     8         +5.937081280313805d-1*t160*t174*t175*t186*t191*t59*t65+5.
     9         937081280313805d-1*t167*t174*t175*t184*t191*t59*t65)+1.36
     :         21078885675922d-1*t59*t61*t63*t74*(t820+t819+t818+t817+t8
     ;         16+t815+t814+t813+t812+t787+t786+t767+t762)+t811+t810+t80
     <         9+t808+t807+t782+t781+t780+t779+t778+t777+t759+t758+t757+
     =         t754+t751+1.6345294662811108d+0*t160*t184*t61*t69*t70*t74
     >         -5.448431554270369d-1*t343*t61*t64*t69*t74-7.421351600392
     ?         256d-2*t174*t191*t343*t59*t67*t74+2.2264054801176772d-1*t
     @         160*t184*t191*t333*t59*t67*t74-2.7242157771351844d-1*t160
     1         *t421*t59*t61*t64*t74-2.7242157771351844d-1*t184*t407*t59
     2         *t61*t64*t74-5.448431554270369d-1*t160*t188*t61*t64*t74-5
     3         .448431554270369d-1*t169*t184*t61*t64*t74+2.7242157771351
     4         844d-1*t356*t61*t63*t74-3.1782517399910487d-1*t161*t162*t
     5         421*t59*t63*t74-3.1782517399910487d-1*t161*t162*t407*t59*
     6         t63*t74-8.172647331405554d-1*t160*t170*t184*t195*t59*t61*
     7         t69*t70-3.710675800196128d-2*t170*t191*t357*t59*t67*t70+7
     8         .421351600392256d-2*t176*t189*t191*t336*t59*t67*t70+2.724
     9         2157771351844d-1*t160*t170*t422*t59*t61*t64*t69+2.7242157
     :         771351844d-1*t170*t184*t409*t59*t61*t64*t69+2.72421577713
     ;         51844d-1*t170*t195*t343*t59*t61*t64*t69-5.448431554270369
     <         d-1*t160*t189*t195*t336*t59*t61*t64*t69-5.448431554270369
     =         d-1*t176*t184*t195*t336*t59*t61*t64*t69+5.448431554270369
     >         d-1*t160*t170*t189*t61*t64*t69+5.448431554270369d-1*t170*
     ?         t176*t184*t61*t64*t69-6.356503479982097d-1*t161*t162*t170
     @         *t184*t195*t59*t64*t69-6.356503479982097d-1*t160*t161*t16
     1         2*t170*t195*t59*t64*t69-8.172647331405554d-1*t176*t189*t1
     2         95*t587*t59*t61*t63*t69+2.7242157771351844d-1*t176*t336*t
     3         422*t59*t61*t63*t69+2.7242157771351844d-1*t189*t336*t409*
     4         t59*t61*t63*t69+2.7242157771351844d-1*t195*t336*t357*t59*
     5         t61*t63*t69-2.7242157771351844d-1*t170*t357*t61*t63*t69+5
     6         .448431554270369d-1*t176*t189*t336*t61*t63*t69+3.17825173
     7         99910487d-1*t161*t162*t170*t422*t59*t63*t69+3.17825173999
     8         10487d-1*t161*t162*t170*t409*t59*t63*t69-6.35650347998209
     9         7d-1*t161*t162*t189*t195*t336*t59*t63*t69-6.3565034799820
     :         97d-1*t161*t162*t176*t195*t336*t59*t63*t69+7.421351600392
     ;         256d-2*t160*t170*t174*t189*t191*t59*t67+7.421351600392256
     <         d-2*t170*t174*t176*t184*t191*t59*t67+2.7242157771351844d-
     =         1*t160*t170*t188*t195*t59*t61*t64+2.7242157771351844d-1*t
     >         169*t170*t184*t195*t59*t61*t64-1.3621078885675922d-1*t169
     ?         *t170*t422*t59*t61*t63-1.3621078885675922d-1*t170*t176*t4
     @         21*t59*t61*t63-1.3621078885675922d-1*t170*t188*t409*t59*t
     1         61*t63-1.3621078885675922d-1*t170*t189*t407*t59*t61*t63-1
     2         .3621078885675922d-1*t170*t195*t356*t59*t61*t63+2.7242157
     3         771351844d-1*t169*t189*t195*t336*t59*t61*t63+2.7242157771
     4         351844d-1*t176*t188*t195*t336*t59*t61*t63-2.7242157771351
     5         844d-1*t169*t170*t189*t61*t63-2.7242157771351844d-1*t170*
     6         t176*t188*t61*t63+3.1782517399910487d-1*t161*t162*t170*t1
     7         88*t195*t59*t63+3.1782517399910487d-1*t161*t162*t169*t170
     8         *t195*t59*t63)*t89+9.327207260896466d-2*t1*t160*t423*t62*
     9         t89+9.327207260896466d-2*t1*t184*t410*t62*t89+9.327207260
     :         896466d-2*t1*t196*t343*t62*t89+9.327207260896466d-2*t184*
     ;         t196*t62*t89+9.327207260896466d-2*t160*t196*t62*t89+3.109
     <         069086965489d-2*t423*t58*t89+3.109069086965489d-2*t410*t5
     =         8*t89+1.8654414521792934d-1*t1*t160*t184*t196*t57*t89+t77
     >         6+t775+9.327207260896466d-2*t1*t155*t184*t196*t62+9.32720
     ?         7260896466d-2*t1*t155*t160*t196*t62+3.109069086965489d-2*
     @         t1*t155*t423*t58+3.109069086965489d-2*t1*t155*t410*t58)+t
     1         305*(-3.109069086965489d-2*t1*t177*t423*t58*t89-3.1090690
     2         86965489d-2*t1*t190*t410*t58*t89-t196*t359)+6.21813817393
     3         0978d-2*t1*t177*t190*t196*t537*t58*t89)*wght+Cmat3(iq,D3_
     4         RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = t806+Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = t829+Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = 1.0d+0*(t157*(3.109069086965489d-2*
     1         t1*t58*(-1.3621078885675922d-1*t170*t59*t61*t63*t69*(t837
     2         +t836+t835+t834+t833+t832+t831+t830+t794+t793+t787+t786-2
     3         .9685406401569026d-1*t174*t191*t369*t59*t72+1.48427032007
     4         84513d+0*t191*t333*t368*t59*t72+2.770637930813109d+0*t161
     5         *t172*t174*t184*t59*t72-1.4842703200784513d-1*t175*t191*t
     6         377*t59*t65*t70-1.4842703200784513d-1*t175*t191*t373*t59*
     7         t65*t70+1.3853189654065545d+0*t161*t172*t175*t186*t59*t65
     8         *t70+4.452810960235354d-1*t191*t324*t334*t377*t59*t70+1.1
     9         87416256062761d+0*t174*t175*t184*t186*t191*t59*t65)+1.362
     :         1078885675922d-1*t59*t61*t63*t74*(t837+t836+t835+t834+t83
     ;         3+t832+t831+t830+t787+t786)+t782+t781+t780+t779+t778+t777
     <         +1.6345294662811108d+0*t368*t61*t69*t70*t74-5.44843155427
     =         0369d-1*t369*t61*t64*t69*t74+2.542601391992839d+0*t161*t1
     >         62*t184*t64*t69*t74-7.421351600392256d-2*t174*t191*t369*t
     ?         59*t67*t74+2.2264054801176772d-1*t191*t333*t368*t59*t67*t
     @         74+3.463297413516387d-1*t161*t172*t174*t184*t59*t67*t74-5
     1         .448431554270369d-1*t184*t421*t59*t61*t64*t74-1.089686310
     2         8540737d+0*t184*t188*t61*t64*t74+2.7242157771351844d-1*t3
     3         80*t61*t63*t74-6.356503479982097d-1*t161*t162*t421*t59*t6
     4         3*t74-1.2713006959964196d+0*t161*t162*t188*t63*t74-8.1726
     5         47331405554d-1*t170*t195*t368*t59*t61*t69*t70+7.421351600
     6         392256d-2*t191*t336*t382*t59*t67*t70-3.710675800196128d-2
     7         *t170*t191*t381*t59*t67*t70+1.7316487067581934d-1*t161*t1
     8         70*t172*t189*t59*t67*t70+5.448431554270369d-1*t170*t184*t
     9         422*t59*t61*t64*t69+2.7242157771351844d-1*t170*t195*t369*
     :         t59*t61*t64*t69-1.0896863108540737d+0*t184*t189*t195*t336
     ;         *t59*t61*t64*t69+1.0896863108540737d+0*t170*t184*t189*t61
     <         *t64*t69-1.2713006959964196d+0*t161*t162*t170*t184*t195*t
     =         59*t64*t69-8.172647331405554d-1*t195*t382*t587*t59*t61*t6
     >         3*t69+5.448431554270369d-1*t189*t336*t422*t59*t61*t63*t69
     ?         +2.7242157771351844d-1*t195*t336*t381*t59*t61*t63*t69+5.4
     @         48431554270369d-1*t336*t382*t61*t63*t69-2.724215777135184
     1         4d-1*t170*t381*t61*t63*t69+6.356503479982097d-1*t161*t162
     2         *t170*t422*t59*t63*t69-1.2713006959964196d+0*t161*t162*t1
     3         89*t195*t336*t59*t63*t69+1.2713006959964196d+0*t161*t162*
     4         t170*t189*t63*t69+1.4842703200784513d-1*t170*t174*t184*t1
     5         89*t191*t59*t67+5.448431554270369d-1*t170*t184*t188*t195*
     6         t59*t61*t64-2.7242157771351844d-1*t170*t188*t422*t59*t61*
     7         t63-2.7242157771351844d-1*t170*t189*t421*t59*t61*t63-1.36
     8         21078885675922d-1*t170*t195*t380*t59*t61*t63+5.4484315542
     9         70369d-1*t188*t189*t195*t336*t59*t61*t63-5.44843155427036
     :         9d-1*t170*t188*t189*t61*t63+6.356503479982097d-1*t161*t16
     ;         2*t170*t188*t195*t59*t63)*t89+1.8654414521792934d-1*t1*t1
     <         84*t423*t62*t89+9.327207260896466d-2*t1*t196*t369*t62*t89
     =         +1.8654414521792934d-1*t184*t196*t62*t89+6.21813817393097
     >         8d-2*t423*t58*t89+1.8654414521792934d-1*t1*t196*t368*t57*
     ?         t89+t776+t775+1.8654414521792934d-1*t1*t155*t184*t196*t62
     @         +6.218138173930978d-2*t1*t155*t423*t58)+t305*(-6.21813817
     1         3930978d-2*t1*t190*t423*t58*t89-t196*t384)+6.218138173930
     2         978d-2*t1*t196*t367*t537*t58*t89)*wght+Cmat3(iq,D3_RB_RB_
     3         GAB)
            Cmat3(iq,D3_RB_RB_GBB) = t829+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = t854+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = 1.0d+0*(t305*(-3.109069086965489d-
     1         2*t1*t193*t410*t58*t89+t865-t196*t397)+t864+t855)*wght+Cm
     2         at3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = t854+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = 1.0d+0*(t157*(3.109069086965489d-2
     1         *t1*t58*(-1.3621078885675922d-1*t170*t59*t61*t63*t69*(t87
     2         3-5.937081280313805d-1*t160*t174*t191*t72-2.9685406401569
     3         026d-1*t167*t175*t191*t65*t70)+t872+t871+t870+t869+t868-2
     4         .9685406401569026d-1*t160*t174*t191*t67*t74+5.44843155427
     5         0369d-1*t407*t61*t63*t74+4.043472623491207d-2*t160*t170*t
     6         330*t585*t59*t69*t72+4.043472623491207d-2*t176*t330*t333*
     7         t336*t59*t69*t72-2.0217363117456036d-2*t169*t170*t330*t33
     8         3*t59*t72-7.421351600392256d-2*t170*t191*t409*t59*t67*t70
     9         +1.4842703200784513d-1*t176*t191*t195*t336*t59*t67*t70-1.
     :         4842703200784513d-1*t170*t176*t191*t67*t70-5.448431554270
     ;         369d-1*t160*t336*t434*t59*t61*t64*t69+1.0896863108540737d
     <         +0*t160*t170*t195*t61*t64*t69-8.172647331405554d-1*t176*t
     =         434*t587*t59*t61*t63*t69+5.448431554270369d-1*t195*t336*t
     >         409*t59*t61*t63*t69-5.448431554270369d-1*t170*t409*t61*t6
     ?         3*t69+1.0896863108540737d+0*t176*t195*t336*t61*t63*t69+1.
     @         4842703200784513d-1*t160*t170*t174*t191*t195*t59*t67+2.72
     1         42157771351844d-1*t169*t336*t434*t59*t61*t63-2.7242157771
     2         351844d-1*t170*t195*t407*t59*t61*t63-5.448431554270369d-1
     3         *t169*t170*t195*t61*t63)*t89+9.327207260896466d-2*t1*t160
     4         *t435*t62*t89+t867+t866)+t305*(-3.109069086965489d-2*t1*t
     5         177*t435*t58*t89-3.109069086965489d-2*t1*t196*t410*t58*t8
     6         9-t196*t411)+6.218138173930978d-2*t1*t177*t433*t537*t58*t
     7         89)*wght+Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = 1.0d+0*(t305*(-3.109069086965489d-
     1         2*t1*t196*t396*t58*t89+t865-t193*t411)+t864+t855)*wght+Cm
     2         at3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = t854+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = t882+Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = 1.0d+0*(t305*(-3.109069086965489d-
     1         2*t1*t193*t423*t58*t89+t885-t196*t417)+t884+t883)*wght+Cm
     2         at3(iq,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = t882+Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = 1.0d+0*(t157*(3.109069086965489d-2
     1         *t1*t58*(-1.3621078885675922d-1*t170*t59*t61*t63*t69*(t87
     2         3-5.937081280313805d-1*t174*t184*t191*t72-2.9685406401569
     3         026d-1*t175*t186*t191*t65*t70)+t872+t871+t870+t869+t868-2
     4         .9685406401569026d-1*t174*t184*t191*t67*t74+5.44843155427
     5         0369d-1*t421*t61*t63*t74+4.043472623491207d-2*t170*t184*t
     6         330*t585*t59*t69*t72+4.043472623491207d-2*t189*t330*t333*
     7         t336*t59*t69*t72-2.0217363117456036d-2*t170*t188*t330*t33
     8         3*t59*t72-7.421351600392256d-2*t170*t191*t422*t59*t67*t70
     9         +1.4842703200784513d-1*t189*t191*t195*t336*t59*t67*t70-1.
     :         4842703200784513d-1*t170*t189*t191*t67*t70-5.448431554270
     ;         369d-1*t184*t336*t434*t59*t61*t64*t69+1.0896863108540737d
     <         +0*t170*t184*t195*t61*t64*t69-8.172647331405554d-1*t189*t
     =         434*t587*t59*t61*t63*t69+5.448431554270369d-1*t195*t336*t
     >         422*t59*t61*t63*t69-5.448431554270369d-1*t170*t422*t61*t6
     ?         3*t69+1.0896863108540737d+0*t189*t195*t336*t61*t63*t69+1.
     @         4842703200784513d-1*t170*t174*t184*t191*t195*t59*t67+2.72
     1         42157771351844d-1*t188*t336*t434*t59*t61*t63-2.7242157771
     2         351844d-1*t170*t195*t421*t59*t61*t63-5.448431554270369d-1
     3         *t170*t188*t195*t61*t63)*t89+9.327207260896466d-2*t1*t184
     4         *t435*t62*t89+t867+t866)+t305*(-3.109069086965489d-2*t1*t
     5         190*t435*t58*t89-3.109069086965489d-2*t1*t196*t423*t58*t8
     6         9-t196*t424)+6.218138173930978d-2*t1*t190*t433*t537*t58*t
     7         89)*wght+Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = 1.0d+0*(t305*(-3.109069086965489d-
     1         2*t1*t196*t416*t58*t89+t885-t193*t424)+t884+t883)*wght+Cm
     2         at3(iq,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = t882+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = t888+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t891+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t888+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = t892+Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = t891+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = t888+Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = 3.109069086965489d-2*t1*t157*t58*
     1         (-1.6522937872993412d-2*t170*t175*t59*t886*t887+1.2130417
     2         870473623d-1*t195*t330*t333*t336*t59*t69*t72-1.2130417870
     3         473623d-1*t170*t330*t333*t69*t72+2.226405480117677d-1*t19
     4         1*t336*t434*t59*t67*t70-4.452810960235354d-1*t170*t191*t1
     5         95*t67*t70-8.172647331405554d-1*t195**3*t587*t59*t61*t63*
     6         t69+1.6345294662811108d+0*t336*t434*t61*t63*t69)*t89*wght
     7         +6.218138173930978d-2*t1*t196**3*t537*t58*t89*wght-9.3272
     8         07260896466d-2*t1*t196*t305*t435*t58*t89*wght+Cmat3(iq,D3
     9         _GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = t892+Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = t891+Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = t888+Cmat3(iq,D3_GBB_GBB_GBB)
            Mmat3(iq,D3_RA_RA_TA) = t898+Mmat3(iq,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = t898+Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_RB_TA) = t899+Mmat3(iq,D3_RA_RB_TA)
            Mmat3(iq,D3_RA_RB_TB) = t899+Mmat3(iq,D3_RA_RB_TB)
            Mmat3(iq,D3_RB_RB_TA) = t900+Mmat3(iq,D3_RB_RB_TA)
            Mmat3(iq,D3_RB_RB_TB) = t900+Mmat3(iq,D3_RB_RB_TB)
            Mmat3(iq,D3_RA_GAA_TA) = t903+Mmat3(iq,D3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = t903+Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_RA_GAB_TA) = t906+Mmat3(iq,D3_RA_GAB_TA)
            Mmat3(iq,D3_RA_GAB_TB) = t906+Mmat3(iq,D3_RA_GAB_TB)
            Mmat3(iq,D3_RA_GBB_TA) = t903+Mmat3(iq,D3_RA_GBB_TA)
            Mmat3(iq,D3_RA_GBB_TB) = t903+Mmat3(iq,D3_RA_GBB_TB)
            Mmat3(iq,D3_RB_GAA_TA) = t907+Mmat3(iq,D3_RB_GAA_TA)
            Mmat3(iq,D3_RB_GAA_TB) = t907+Mmat3(iq,D3_RB_GAA_TB)
            Mmat3(iq,D3_RB_GAB_TA) = t908+Mmat3(iq,D3_RB_GAB_TA)
            Mmat3(iq,D3_RB_GAB_TB) = t908+Mmat3(iq,D3_RB_GAB_TB)
            Mmat3(iq,D3_RB_GBB_TA) = t907+Mmat3(iq,D3_RB_GBB_TA)
            Mmat3(iq,D3_RB_GBB_TB) = t907+Mmat3(iq,D3_RB_GBB_TB)
            Mmat3(iq,D3_RA_TA_TA) = t909+Mmat3(iq,D3_RA_TA_TA)
            Mmat3(iq,D3_RA_TA_TB) = t909+Mmat3(iq,D3_RA_TA_TB)
            Mmat3(iq,D3_RA_TB_TB) = t910+Mmat3(iq,D3_RA_TB_TB)
            Mmat3(iq,D3_RB_TA_TA) = t910+Mmat3(iq,D3_RB_TA_TA)
            Mmat3(iq,D3_RB_TA_TB) = t909+Mmat3(iq,D3_RB_TA_TB)
            Mmat3(iq,D3_RB_TB_TB) = t909+Mmat3(iq,D3_RB_TB_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = t911+Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = t911+Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_GAA_GAB_TA) = t910+Mmat3(iq,D3_GAA_GAB_TA)
            Mmat3(iq,D3_GAA_GAB_TB) = t910+Mmat3(iq,D3_GAA_GAB_TB)
            Mmat3(iq,D3_GAA_GBB_TA) = t909+Mmat3(iq,D3_GAA_GBB_TA)
            Mmat3(iq,D3_GAA_GBB_TB) = t909+Mmat3(iq,D3_GAA_GBB_TB)
            Mmat3(iq,D3_GAB_GAB_TA) = t913+Mmat3(iq,D3_GAB_GAB_TA)
            Mmat3(iq,D3_GAB_GAB_TB) = t913+Mmat3(iq,D3_GAB_GAB_TB)
            Mmat3(iq,D3_GAB_GBB_TA) = t913+Mmat3(iq,D3_GAB_GBB_TA)
            Mmat3(iq,D3_GAB_GBB_TB) = t914+Mmat3(iq,D3_GAB_GBB_TB)
            Mmat3(iq,D3_GBB_GBB_TA) = t914+Mmat3(iq,D3_GBB_GBB_TA)
            Mmat3(iq,D3_GBB_GBB_TB) = t914+Mmat3(iq,D3_GBB_GBB_TB)
            Mmat3(iq,D3_GAA_TA_TA) = t913+Mmat3(iq,D3_GAA_TA_TA)
            Mmat3(iq,D3_GAA_TA_TB) = t913+Mmat3(iq,D3_GAA_TA_TB)
            Mmat3(iq,D3_GAA_TB_TB) = t913+Mmat3(iq,D3_GAA_TB_TB)
            Mmat3(iq,D3_GAB_TA_TA) = t915+Mmat3(iq,D3_GAB_TA_TA)
            Mmat3(iq,D3_GAB_TA_TB) = t915+Mmat3(iq,D3_GAB_TA_TB)
            Mmat3(iq,D3_GAB_TB_TB) = t915+Mmat3(iq,D3_GAB_TB_TB)
            Mmat3(iq,D3_GBB_TA_TA) = t915+Mmat3(iq,D3_GBB_TA_TA)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 9.999999999999991d-1*(6.21814d-2*t17*t18-3.10907d-2*t1
     1         1*t9)-6.21814d-2*t17*t18
            t20 = 2.871234000188191d+0*rhoa**1.6666666666666669d+0
            t21 = -taub-taua+t20
            t22 = taub+taua+t20
            t23 = 1/t22
            t24 = param(12)
            t25 = t21*t23*t24+param(11)
            t26 = t21*t23*t25+param(10)
            t27 = t21*t23*t26+param(9)
            t28 = t21*t23*t27+param(8)
            t29 = t21*t23*t28+param(7)
            t30 = t21*t23*t29+param(6)
            t31 = t21*t23*t30+param(5)
            t32 = t21*t23*t31+param(4)
            t33 = t21*t23*t32+param(3)
            t34 = t21*t23*t33+param(2)
            t35 = t21*t23*t34+param(1)
            t36 = rhoa**1.1666666666666667d+0
            t37 = 1/t36**2.0d+0
            t38 = exp(-6.432793688582967d+1*t19)
            t39 = t38-1.0d+0
            t40 = 1/t39
            t41 = 2.1622114952063792d-1*gammaaa*t37*t40
            t42 = t41+1.0d+0
            t43 = (gammaaa*t37)**2.0d+0
            t44 = 1/t39**2.0d+0
            t45 = 4.675158550002606d-2*t43*t44+t41+1.0d+0
            t46 = 1/t45
            t47 = 2.1622114952063792d-1*gammaaa*t37*t42*t46+1.0d+0
            t48 = log(t47)
            t49 = param(14)
            t50 = param(24)
            t51 = t21*t23*t50+param(23)
            t52 = t21*t23*t51+param(22)
            t53 = t21*t23*t52+param(21)
            t54 = t21*t23*t53+param(20)
            t55 = t21*t23*t54+param(19)
            t56 = t21*t23*t55+param(18)
            t57 = t21*t23*t56+param(17)
            t58 = t21*t23*t57+param(16)
            t59 = t21*t23*t58+param(15)
            t60 = t21*t23*t59+t49
            t61 = t21*t23*t60+param(13)
            t62 = rhoa**6.666666666666666d-1
            t63 = 1/t22**2
            t64 = 4.785390000313652d+0*t23*t24*t62-4.785390000313652d+0*
     1         t21*t24*t62*t63
            t65 = t21*t23*t64-4.785390000313652d+0*t21*t25*t62*t63+4.785
     1         390000313652d+0*t23*t25*t62
            t66 = t21*t23*t65-4.785390000313652d+0*t21*t26*t62*t63+4.785
     1         390000313652d+0*t23*t26*t62
            t67 = t21*t23*t66-4.785390000313652d+0*t21*t27*t62*t63+4.785
     1         390000313652d+0*t23*t27*t62
            t68 = t21*t23*t67-4.785390000313652d+0*t21*t28*t62*t63+4.785
     1         390000313652d+0*t23*t28*t62
            t69 = t21*t23*t68-4.785390000313652d+0*t21*t29*t62*t63+4.785
     1         390000313652d+0*t23*t29*t62
            t70 = t21*t23*t69-4.785390000313652d+0*t21*t30*t62*t63+4.785
     1         390000313652d+0*t23*t30*t62
            t71 = t21*t23*t70-4.785390000313652d+0*t21*t31*t62*t63+4.785
     1         390000313652d+0*t23*t31*t62
            t72 = t21*t23*t71-4.785390000313652d+0*t21*t32*t62*t63+4.785
     1         390000313652d+0*t23*t32*t62
            t73 = t21*t23*t72-4.785390000313652d+0*t21*t33*t62*t63+4.785
     1         390000313652d+0*t23*t33*t62
            t74 = t21*t23*t73-4.785390000313652d+0*t21*t34*t62*t63+4.785
     1         390000313652d+0*t23*t34*t62
            t75 = 1/rhoa**1.3333333333333333d+0
            t76 = 1/t8
            t77 = 1/t6**2
            t78 = 1/rhoa**1.3333333333333336d+0
            t79 = 1/t2**3
            t80 = 1/rhoa**6.666666666666667d-1
            t81 = -1.3127055298329054d-1*t4*t79*t80-2.0096226153166658d-
     1         3*t78
            t82 = 7.876233178997433d-1*t3*t81-1.3127055298329054d-1*t5*t
     1         79*t80
            t83 = 2.11607075208357d-1*t3*t7*t80-1.269642451250142d+0*t2*
     1         t77*t82
            t84 = 1/t16
            t85 = 1/t14**2
            t86 = -1.3127055298329054d-1*t12*t79*t80-3.169132786263567d-
     1         3*t78
            t87 = 7.876233178997433d-1*t3*t86-1.3127055298329054d-1*t13*
     1         t79*t80
            t88 = 2.11607075208357d-1*t15*t3*t80-1.269642451250142d+0*t2
     1         *t85*t87
            t89 = 9.999999999999991d-1*(1.3210398931339265d-3*t75*t9+6.2
     1         1814d-2*t18*t84*t88-3.10907d-2*t11*t76*t83-2.747773264188
     2         438d-3*t17*t75)-6.21814d-2*t18*t84*t88+2.747773264188438d
     3         -3*t17*t75
            t90 = 4.785390000313652d+0*t23*t50*t62-4.785390000313652d+0*
     1         t21*t50*t62*t63
            t91 = t21*t23*t90-4.785390000313652d+0*t21*t51*t62*t63+4.785
     1         390000313652d+0*t23*t51*t62
            t92 = t21*t23*t91-4.785390000313652d+0*t21*t52*t62*t63+4.785
     1         390000313652d+0*t23*t52*t62
            t93 = t21*t23*t92-4.785390000313652d+0*t21*t53*t62*t63+4.785
     1         390000313652d+0*t23*t53*t62
            t94 = t21*t23*t93-4.785390000313652d+0*t21*t54*t62*t63+4.785
     1         390000313652d+0*t23*t54*t62
            t95 = t21*t23*t94-4.785390000313652d+0*t21*t55*t62*t63+4.785
     1         390000313652d+0*t23*t55*t62
            t96 = t21*t23*t95-4.785390000313652d+0*t21*t56*t62*t63+4.785
     1         390000313652d+0*t23*t56*t62
            t97 = t21*t23*t96-4.785390000313652d+0*t21*t57*t62*t63+4.785
     1         390000313652d+0*t23*t57*t62
            t98 = t21*t23*t97-4.785390000313652d+0*t21*t58*t62*t63+4.785
     1         390000313652d+0*t23*t58*t62
            t99 = t21*t23*t98-4.785390000313652d+0*t21*t59*t62*t63+4.785
     1         390000313652d+0*t23*t59*t62
            t100 = t21*t23*t99-4.785390000313652d+0*t21*t60*t62*t63+4.78
     1         5390000313652d+0*t23*t60*t62
            t101 = 1/t47
            t102 = rhoa**1.6666666666666674d-1
            t103 = 1/t36**3.0d+0
            t104 = -5.045160155481552d-1*gammaaa*t102*t103*t40
            t105 = 1/t39**2
            t106 = 1.3909060459745137d+1*gammaaa*t105*t37*t38*t89
            t107 = t106+t104
            t108 = 1/t45**2
            t109 = gammaaa**2
            t110 = 1/t36**5.0d+0
            t111 = 1/t39**3.0d+0
            t112 = 6.014866082716293d+0*t111*t38*t43*t89-2.1817406566678
     1         83d-1*t102*t109*t110*t44+t106+t104
            t113 = -5.045160155481552d-1*gammaaa*t102*t103*t42*t46+2.162
     1         2114952063792d-1*gammaaa*t107*t37*t46-2.1622114952063792d
     2         -1*gammaaa*t108*t112*t37*t42
            t114 = 1/t36**4.0d+0
            t115 = 9.350317100005212d-2*gammaaa*t114*t44+2.1622114952063
     1         792d-1*t37*t40
            t116 = 2.1622114952063792d-1*t37*t42*t46+4.675158550002606d-
     1         2*gammaaa*t114*t40*t46-2.1622114952063792d-1*gammaaa*t108
     2         *t115*t37*t42
            t117 = -t21*t24*t63-t23*t24
            t118 = -t21*t25*t63-t23*t25+t117*t21*t23
            t119 = -t21*t26*t63-t23*t26+t118*t21*t23
            t120 = -t21*t27*t63-t23*t27+t119*t21*t23
            t121 = -t21*t28*t63-t23*t28+t120*t21*t23
            t122 = -t21*t29*t63-t23*t29+t121*t21*t23
            t123 = -t21*t30*t63-t23*t30+t122*t21*t23
            t124 = -t21*t31*t63-t23*t31+t123*t21*t23
            t125 = -t21*t32*t63-t23*t32+t124*t21*t23
            t126 = -t21*t33*t63-t23*t33+t125*t21*t23
            t127 = -t21*t34*t63-t23*t34+t126*t21*t23
            t128 = -t21*t50*t63-t23*t50
            t129 = -t21*t51*t63-t23*t51+t128*t21*t23
            t130 = -t21*t52*t63-t23*t52+t129*t21*t23
            t131 = -t21*t53*t63-t23*t53+t130*t21*t23
            t132 = -t21*t54*t63-t23*t54+t131*t21*t23
            t133 = -t21*t55*t63-t23*t55+t132*t21*t23
            t134 = -t21*t56*t63-t23*t56+t133*t21*t23
            t135 = -t21*t57*t63-t23*t57+t134*t21*t23
            t136 = -t21*t58*t63-t23*t58+t135*t21*t23
            t137 = -t21*t59*t63-t23*t59+t136*t21*t23
            t138 = -t21*t60*t63
            t139 = -t23*t60+t137*t21*t23+t138
            t140 = 1.0d+0*(1.5545345434827443d-2*rhoa*t139*t48+1.0d+0*rh
     1         oa*t127*t19)*wght
            t141 = rhoa**1.3333333333333333d+0
            t142 = 1/t22**3
            t143 = rhoa**3.333333333333333d-1
            t144 = 1/t143
            t145 = -3.190260000209101d+0*t144*t21*t24*t63-4.579991491020
     1         378d+1*t141*t24*t63+3.190260000209101d+0*t144*t23*t24+4.5
     2         79991491020378d+1*t141*t142*t21*t24
            t146 = -9.570780000627304d+0*t21*t62*t63*t64+9.5707800006273
     1         04d+0*t23*t62*t64-3.190260000209101d+0*t144*t21*t25*t63-4
     2         .579991491020378d+1*t141*t25*t63+3.190260000209101d+0*t14
     3         4*t23*t25+4.579991491020378d+1*t141*t142*t21*t25+t145*t21
     4         *t23
            t147 = -9.570780000627304d+0*t21*t62*t63*t65+9.5707800006273
     1         04d+0*t23*t62*t65-3.190260000209101d+0*t144*t21*t26*t63-4
     2         .579991491020378d+1*t141*t26*t63+3.190260000209101d+0*t14
     3         4*t23*t26+4.579991491020378d+1*t141*t142*t21*t26+t146*t21
     4         *t23
            t148 = -9.570780000627304d+0*t21*t62*t63*t66+9.5707800006273
     1         04d+0*t23*t62*t66-3.190260000209101d+0*t144*t21*t27*t63-4
     2         .579991491020378d+1*t141*t27*t63+3.190260000209101d+0*t14
     3         4*t23*t27+4.579991491020378d+1*t141*t142*t21*t27+t147*t21
     4         *t23
            t149 = -9.570780000627304d+0*t21*t62*t63*t67+9.5707800006273
     1         04d+0*t23*t62*t67-3.190260000209101d+0*t144*t21*t28*t63-4
     2         .579991491020378d+1*t141*t28*t63+3.190260000209101d+0*t14
     3         4*t23*t28+4.579991491020378d+1*t141*t142*t21*t28+t148*t21
     4         *t23
            t150 = -9.570780000627304d+0*t21*t62*t63*t68+9.5707800006273
     1         04d+0*t23*t62*t68-3.190260000209101d+0*t144*t21*t29*t63-4
     2         .579991491020378d+1*t141*t29*t63+3.190260000209101d+0*t14
     3         4*t23*t29+4.579991491020378d+1*t141*t142*t21*t29+t149*t21
     4         *t23
            t151 = -9.570780000627304d+0*t21*t62*t63*t69+9.5707800006273
     1         04d+0*t23*t62*t69-3.190260000209101d+0*t144*t21*t30*t63-4
     2         .579991491020378d+1*t141*t30*t63+3.190260000209101d+0*t14
     3         4*t23*t30+4.579991491020378d+1*t141*t142*t21*t30+t150*t21
     4         *t23
            t152 = -9.570780000627304d+0*t21*t62*t63*t70+9.5707800006273
     1         04d+0*t23*t62*t70-3.190260000209101d+0*t144*t21*t31*t63-4
     2         .579991491020378d+1*t141*t31*t63+3.190260000209101d+0*t14
     3         4*t23*t31+4.579991491020378d+1*t141*t142*t21*t31+t151*t21
     4         *t23
            t153 = -9.570780000627304d+0*t21*t62*t63*t71+9.5707800006273
     1         04d+0*t23*t62*t71-3.190260000209101d+0*t144*t21*t32*t63-4
     2         .579991491020378d+1*t141*t32*t63+3.190260000209101d+0*t14
     3         4*t23*t32+4.579991491020378d+1*t141*t142*t21*t32+t152*t21
     4         *t23
            t154 = -9.570780000627304d+0*t21*t62*t63*t72+9.5707800006273
     1         04d+0*t23*t62*t72-3.190260000209101d+0*t144*t21*t33*t63-4
     2         .579991491020378d+1*t141*t33*t63+3.190260000209101d+0*t14
     3         4*t23*t33+4.579991491020378d+1*t141*t142*t21*t33+t153*t21
     4         *t23
            t155 = -9.570780000627304d+0*t21*t62*t63*t73+9.5707800006273
     1         04d+0*t23*t62*t73-3.190260000209101d+0*t144*t21*t34*t63-4
     2         .579991491020378d+1*t141*t34*t63+3.190260000209101d+0*t14
     3         4*t23*t34+4.579991491020378d+1*t141*t142*t21*t34+t154*t21
     4         *t23
            t156 = 1/rhoa**2.333333333333333d+0
            t157 = 1/t8**2
            t158 = t83**2
            t159 = 1/t6**3
            t160 = t82**2
            t161 = 1/rhoa**2.3333333333333334d+0
            t162 = 1/rhoa**1.6666666666666669d+0
            t163 = 1/t2**5
            t164 = 8.751370198886037d-2*t162*t4*t79+6.563527649164527d-2
     1         *t163*t4*t78+3.0144339229749983d-3*t161
            t165 = -2.625411059665811d-1*t79*t80*t81+8.751370198886037d-
     1         2*t162*t5*t79+6.563527649164527d-2*t163*t5*t78+7.87623317
     2         8997433d-1*t164*t3
            t166 = -4.23214150416714d-1*t3*t77*t80*t82-3.52678458680595d
     1         -2*t7*t78*t79-1.269642451250142d+0*t165*t2*t77-1.41071383
     2         47223802d-1*t162*t3*t7+2.539284902500284d+0*t159*t160*t2
            t167 = 1/t16**2
            t168 = t88**2
            t169 = 1/t14**3
            t170 = t87**2
            t171 = 8.751370198886037d-2*t12*t162*t79+6.563527649164527d-
     1         2*t12*t163*t78+4.753699179395351d-3*t161
            t172 = -2.625411059665811d-1*t79*t80*t86+8.751370198886037d-
     1         2*t13*t162*t79+6.563527649164527d-2*t13*t163*t78+7.876233
     2         178997433d-1*t171*t3
            t173 = -4.23214150416714d-1*t3*t80*t85*t87-1.269642451250142
     1         d+0*t172*t2*t85-3.52678458680595d-2*t15*t78*t79-1.4107138
     2         347223802d-1*t15*t162*t3+2.539284902500284d+0*t169*t170*t
     3         2
            t174 = 9.999999999999991d-1*(-1.7613865241785687d-3*t156*t9-
     1         5.495546528376876d-3*t75*t84*t88+6.21814d-2*t173*t18*t84+
     2         2.642079786267853d-3*t75*t76*t83-3.10907d-2*t11*t166*t76-
     3         6.21814d-2*t167*t168*t18+3.663697685584584d-3*t156*t17+3.
     4         10907d-2*t11*t157*t158)+5.495546528376876d-3*t75*t84*t88-
     5         6.21814d-2*t173*t18*t84+6.21814d-2*t167*t168*t18-3.663697
     6         685584584d-3*t156*t17
            t175 = -3.190260000209101d+0*t144*t21*t50*t63-4.579991491020
     1         378d+1*t141*t50*t63+3.190260000209101d+0*t144*t23*t50+4.5
     2         79991491020378d+1*t141*t142*t21*t50
            t176 = -9.570780000627304d+0*t21*t62*t63*t90+9.5707800006273
     1         04d+0*t23*t62*t90-3.190260000209101d+0*t144*t21*t51*t63-4
     2         .579991491020378d+1*t141*t51*t63+3.190260000209101d+0*t14
     3         4*t23*t51+4.579991491020378d+1*t141*t142*t21*t51+t175*t21
     4         *t23
            t177 = -9.570780000627304d+0*t21*t62*t63*t91+9.5707800006273
     1         04d+0*t23*t62*t91-3.190260000209101d+0*t144*t21*t52*t63-4
     2         .579991491020378d+1*t141*t52*t63+3.190260000209101d+0*t14
     3         4*t23*t52+4.579991491020378d+1*t141*t142*t21*t52+t176*t21
     4         *t23
            t178 = -9.570780000627304d+0*t21*t62*t63*t92+9.5707800006273
     1         04d+0*t23*t62*t92-3.190260000209101d+0*t144*t21*t53*t63-4
     2         .579991491020378d+1*t141*t53*t63+3.190260000209101d+0*t14
     3         4*t23*t53+4.579991491020378d+1*t141*t142*t21*t53+t177*t21
     4         *t23
            t179 = -9.570780000627304d+0*t21*t62*t63*t93+9.5707800006273
     1         04d+0*t23*t62*t93-3.190260000209101d+0*t144*t21*t54*t63-4
     2         .579991491020378d+1*t141*t54*t63+3.190260000209101d+0*t14
     3         4*t23*t54+4.579991491020378d+1*t141*t142*t21*t54+t178*t21
     4         *t23
            t180 = -9.570780000627304d+0*t21*t62*t63*t94+9.5707800006273
     1         04d+0*t23*t62*t94-3.190260000209101d+0*t144*t21*t55*t63-4
     2         .579991491020378d+1*t141*t55*t63+3.190260000209101d+0*t14
     3         4*t23*t55+4.579991491020378d+1*t141*t142*t21*t55+t179*t21
     4         *t23
            t181 = -9.570780000627304d+0*t21*t62*t63*t95+9.5707800006273
     1         04d+0*t23*t62*t95-3.190260000209101d+0*t144*t21*t56*t63-4
     2         .579991491020378d+1*t141*t56*t63+3.190260000209101d+0*t14
     3         4*t23*t56+4.579991491020378d+1*t141*t142*t21*t56+t180*t21
     4         *t23
            t182 = -9.570780000627304d+0*t21*t62*t63*t96+9.5707800006273
     1         04d+0*t23*t62*t96-3.190260000209101d+0*t144*t21*t57*t63-4
     2         .579991491020378d+1*t141*t57*t63+3.190260000209101d+0*t14
     3         4*t23*t57+4.579991491020378d+1*t141*t142*t21*t57+t181*t21
     4         *t23
            t183 = -9.570780000627304d+0*t21*t62*t63*t97+9.5707800006273
     1         04d+0*t23*t62*t97-3.190260000209101d+0*t144*t21*t58*t63-4
     2         .579991491020378d+1*t141*t58*t63+3.190260000209101d+0*t14
     3         4*t23*t58+4.579991491020378d+1*t141*t142*t21*t58+t182*t21
     4         *t23
            t184 = -9.570780000627304d+0*t21*t62*t63*t98+9.5707800006273
     1         04d+0*t23*t62*t98-3.190260000209101d+0*t144*t21*t59*t63-4
     2         .579991491020378d+1*t141*t59*t63+3.190260000209101d+0*t14
     3         4*t23*t59+4.579991491020378d+1*t141*t142*t21*t59+t183*t21
     4         *t23
            t185 = -9.570780000627304d+0*t21*t62*t63*t99+9.5707800006273
     1         04d+0*t23*t62*t99-3.190260000209101d+0*t144*t21*t60*t63-4
     2         .579991491020378d+1*t141*t60*t63+3.190260000209101d+0*t14
     3         4*t23*t60+4.579991491020378d+1*t141*t142*t21*t60+t184*t21
     4         *t23
            t186 = 1/t47**2
            t187 = t113**2
            t188 = rhoa**3.333333333333335d-1
            t189 = 1/rhoa**8.333333333333333d-1
            t190 = t89**2
            t191 = exp(-1.2865587377165935d+2*t19)
            t192 = 1/t39**3
            t193 = 1.7894823267913484d+3*gammaaa*t190*t191*t192*t37
            t194 = 1.765806054418543d+0*gammaaa*t114*t188*t40
            t195 = -8.408600259135923d-2*gammaaa*t103*t189*t40
            t196 = -6.490894881214397d+1*gammaaa*t102*t103*t105*t38*t89
            t197 = -8.947411633956742d+2*gammaaa*t105*t190*t37*t38
            t198 = 1.3909060459745137d+1*gammaaa*t105*t174*t37*t38
            t199 = t198+t197+t196+t195+t194+t193
            t200 = 1/t39**4.0d+0
            t201 = 1/t36**6.0d+0
            t202 = -5.613875010535206d+1*t102*t109*t110*t111*t38*t89+1.2
     1         72682049722932d+0*t109*t188*t201*t44-3.6362344277798064d-
     2         2*t109*t110*t189*t44-3.869239257456912d+2*t111*t190*t38*t
     3         43+6.014866082716293d+0*t111*t174*t38*t43+1.1607717772370
     4         736d+3*t190*t191*t200*t43+t198+t197+t196+t195+t194+t193
            t203 = 1/t45**3
            t204 = t112**2
            t205 = -8.408600259135923d-2*gammaaa*t103*t189*t42*t46+1.765
     1         806054418543d+0*gammaaa*t114*t188*t42*t46+2.1622114952063
     2         792d-1*gammaaa*t199*t37*t46-1.0090320310963104d+0*gammaaa
     3         *t102*t103*t107*t46+4.3244229904127585d-1*gammaaa*t203*t2
     4         04*t37*t42-2.1622114952063792d-1*gammaaa*t108*t202*t37*t4
     5         2+1.0090320310963104d+0*gammaaa*t102*t103*t108*t112*t42-4
     6         .3244229904127585d-1*gammaaa*t107*t108*t112*t37
            t206 = 1.5545345434827443d-2*rhoa*t205*t61+3.109069086965488
     1         6d-2*t113*t61+3.1090690869654886d-2*rhoa*t100*t113
            t207 = -5.045160155481552d-1*t102*t103*t40
            t208 = 1.3909060459745137d+1*t105*t37*t38*t89
            t209 = t208+t207
            t210 = 1.2029732165432584d+1*gammaaa*t111*t114*t38*t89-4.363
     1         481313335766d-1*gammaaa*t102*t110*t44+t208+t207
            t211 = -5.045160155481552d-1*t102*t103*t42*t46-1.09087032833
     1         39415d-1*gammaaa*t102*t110*t40*t46+2.1622114952063792d-1*
     2         gammaaa*t209*t37*t46+2.1622114952063792d-1*t107*t37*t46-2
     3         .1622114952063792d-1*gammaaa*t108*t210*t37*t42+4.32442299
     4         04127585d-1*gammaaa*t112*t115*t203*t37*t42-2.162211495206
     5         3792d-1*t108*t112*t37*t42+5.045160155481552d-1*gammaaa*t1
     6         02*t103*t108*t115*t42-4.675158550002606d-2*gammaaa*t108*t
     7         112*t114*t40-2.1622114952063792d-1*gammaaa*t107*t108*t115
     8         *t37
            t212 = 1.5545345434827443d-2*rhoa*t211*t61+1.554534543482744
     1         3d-2*t116*t61+1.5545345434827443d-2*rhoa*t100*t116
            t213 = t116**2
            t214 = t115**2
            t215 = 9.350317100005212d-2*t114*t40*t46-2.0217363117456047d
     1         -2*gammaaa*t108*t201*t42*t44+4.3244229904127585d-1*gammaa
     2         a*t203*t214*t37*t42-4.3244229904127585d-1*t108*t115*t37*t
     3         42-9.350317100005212d-2*gammaaa*t108*t114*t115*t40
            t216 = t21**2
            t217 = 1/t22**4
            t218 = -t21*t63*t64-t23*t64-4.785390000313652d+0*t117*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t25*t62+9.57078000062
     2         7304d+0*t216*t217*t24*t62+4.785390000313652d+0*t117*t23*t
     3         62
            t219 = -t21*t63*t65-t23*t65-4.785390000313652d+0*t118*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t26*t62+4.78539000031
     2         3652d+0*t118*t23*t62+t21*t218*t23
            t220 = -t21*t63*t66-t23*t66-4.785390000313652d+0*t119*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t27*t62+4.78539000031
     2         3652d+0*t119*t23*t62+t21*t219*t23
            t221 = -t21*t63*t67-t23*t67-4.785390000313652d+0*t120*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t28*t62+4.78539000031
     2         3652d+0*t120*t23*t62+t21*t220*t23
            t222 = -t21*t63*t68-t23*t68-4.785390000313652d+0*t121*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t29*t62+4.78539000031
     2         3652d+0*t121*t23*t62+t21*t221*t23
            t223 = -t21*t63*t69-t23*t69-4.785390000313652d+0*t122*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t30*t62+4.78539000031
     2         3652d+0*t122*t23*t62+t21*t222*t23
            t224 = -t21*t63*t70-t23*t70-4.785390000313652d+0*t123*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t31*t62+4.78539000031
     2         3652d+0*t123*t23*t62+t21*t223*t23
            t225 = -t21*t63*t71-t23*t71-4.785390000313652d+0*t124*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t32*t62+4.78539000031
     2         3652d+0*t124*t23*t62+t21*t224*t23
            t226 = -t21*t63*t72-t23*t72-4.785390000313652d+0*t125*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t33*t62+4.78539000031
     2         3652d+0*t125*t23*t62+t21*t225*t23
            t227 = -t21*t63*t73-t23*t73-4.785390000313652d+0*t126*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t34*t62+4.78539000031
     2         3652d+0*t126*t23*t62+t21*t226*t23
            t228 = -t21*t63*t90-t23*t90-4.785390000313652d+0*t128*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t51*t62+9.57078000062
     2         7304d+0*t216*t217*t50*t62+4.785390000313652d+0*t128*t23*t
     3         62
            t229 = -t21*t63*t91-t23*t91-4.785390000313652d+0*t129*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t52*t62+4.78539000031
     2         3652d+0*t129*t23*t62+t21*t228*t23
            t230 = -t21*t63*t92-t23*t92-4.785390000313652d+0*t130*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t53*t62+4.78539000031
     2         3652d+0*t130*t23*t62+t21*t229*t23
            t231 = -t21*t63*t93-t23*t93-4.785390000313652d+0*t131*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t54*t62+4.78539000031
     2         3652d+0*t131*t23*t62+t21*t23*t230
            t232 = -t21*t63*t94-t23*t94-4.785390000313652d+0*t132*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t55*t62+4.78539000031
     2         3652d+0*t132*t23*t62+t21*t23*t231
            t233 = -t21*t63*t95-t23*t95-4.785390000313652d+0*t133*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t56*t62+4.78539000031
     2         3652d+0*t133*t23*t62+t21*t23*t232
            t234 = -t21*t63*t96-t23*t96-4.785390000313652d+0*t134*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t57*t62+4.78539000031
     2         3652d+0*t134*t23*t62+t21*t23*t233
            t235 = -t21*t63*t97-t23*t97-4.785390000313652d+0*t135*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t58*t62+4.78539000031
     2         3652d+0*t135*t23*t62+t21*t23*t234
            t236 = -t21*t63*t98-t23*t98-4.785390000313652d+0*t136*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t59*t62+4.78539000031
     2         3652d+0*t136*t23*t62+t21*t23*t235
            t237 = -t21*t63*t99-t23*t99-4.785390000313652d+0*t137*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t60*t62+4.78539000031
     2         3652d+0*t137*t23*t62+t21*t23*t236
            t238 = 1.0d+0*(1.0d+0*rhoa*t127*t89+1.5545345434827443d-2*rh
     1         oa*t237*t48+1.5545345434827443d-2*t139*t48+1.0d+0*rhoa*t1
     2         9*t227+1.0d+0*t127*t19+1.5545345434827443d-2*rhoa*t101*t1
     3         13*t139)*wght
            t239 = 1.5545345434827443d-2*rhoa*t101*t116*(t23*(-t21*t23*t
     1         59-t49+t137*t21)+t138)*wght
            t240 = 2*t24*t63+2*t142*t21*t24
            t241 = 2*t25*t63-2*t117*t21*t63+2*t142*t21*t25+t21*t23*t240-
     1         2*t117*t23
            t242 = 2*t26*t63-2*t118*t21*t63+2*t142*t21*t26+t21*t23*t241-
     1         2*t118*t23
            t243 = 2*t27*t63-2*t119*t21*t63+2*t142*t21*t27+t21*t23*t242-
     1         2*t119*t23
            t244 = 2*t28*t63-2*t120*t21*t63+2*t142*t21*t28+t21*t23*t243-
     1         2*t120*t23
            t245 = 2*t29*t63-2*t121*t21*t63+2*t142*t21*t29+t21*t23*t244-
     1         2*t121*t23
            t246 = 2*t30*t63-2*t122*t21*t63+2*t142*t21*t30+t21*t23*t245-
     1         2*t122*t23
            t247 = 2*t31*t63-2*t123*t21*t63+2*t142*t21*t31+t21*t23*t246-
     1         2*t123*t23
            t248 = 2*t32*t63-2*t124*t21*t63+2*t142*t21*t32+t21*t23*t247-
     1         2*t124*t23
            t249 = 2*t33*t63-2*t125*t21*t63+2*t142*t21*t33+t21*t23*t248-
     1         2*t125*t23
            t250 = 2*t34*t63-2*t126*t21*t63+2*t142*t21*t34+t21*t23*t249-
     1         2*t126*t23
            t251 = 2*t50*t63+2*t142*t21*t50
            t252 = 2*t51*t63-2*t128*t21*t63+2*t142*t21*t51+t21*t23*t251-
     1         2*t128*t23
            t253 = 2*t52*t63-2*t129*t21*t63+2*t142*t21*t52+t21*t23*t252-
     1         2*t129*t23
            t254 = 2*t53*t63-2*t130*t21*t63+2*t142*t21*t53+t21*t23*t253-
     1         2*t130*t23
            t255 = 2*t54*t63-2*t131*t21*t63+2*t142*t21*t54+t21*t23*t254-
     1         2*t131*t23
            t256 = 2*t55*t63-2*t132*t21*t63+2*t142*t21*t55+t21*t23*t255-
     1         2*t132*t23
            t257 = 2*t56*t63-2*t133*t21*t63+2*t142*t21*t56+t21*t23*t256-
     1         2*t133*t23
            t258 = 2*t57*t63-2*t134*t21*t63+2*t142*t21*t57+t21*t23*t257-
     1         2*t134*t23
            t259 = 2*t58*t63-2*t135*t21*t63+2*t142*t21*t58+t21*t23*t258-
     1         2*t135*t23
            t260 = 2*t59*t63-2*t136*t21*t63+2*t142*t21*t59+t21*t23*t259-
     1         2*t136*t23
            t261 = 2*t142*t21*t60
            t262 = 2*t60*t63-2*t137*t21*t63+t261+t21*t23*t260-2*t137*t23
            t263 = 1.0d+0*(1.5545345434827443d-2*rhoa*t262*t48+1.0d+0*rh
     1         oa*t19*t250)*wght
            t264 = rhoa**2
            t265 = 1/t141
            t266 = 1/rhoa**3.333333333333333d+0
            t267 = 1/rhoa**3.3333333333333337d+0
            t268 = 1/rhoa**2.666666666666667d+0
            t269 = 1/t2**7
            t270 = 1/rhoa**2.0d+0
            t271 = 1/t16**3
            t272 = t88**3
            t273 = -7.617854707500852d+0*t2*t87**3/t14**4+1.058035376041
     1         7849d-1*t78*t79*t85*t87+4.2321415041671406d-1*t162*t3*t85
     2         *t87+7.617854707500852d+0*t169*t172*t2*t87-1.269642451250
     3         142d+0*t2*t85*(2.625411059665811d-1*t162*t79*t86+1.969058
     4         2947493582d-1*t163*t78*t86-3.9381165894987163d-1*t171*t79
     5         *t80+7.876233178997433d-1*t3*(-1.4585616998143394d-1*t12*
     6         t268*t79-5.469606374303773d-2*t12*t269*t270-1.17081850159
     7         18181d-2*t267-1.3127055298329054d-1*t12*t161*t163)-1.4585
     8         616998143394d-1*t13*t268*t79-5.469606374303773d-2*t13*t26
     9         9*t270-1.3127055298329054d-1*t13*t161*t163)-6.34821225625
     :         071d-1*t172*t3*t80*t85+1.269642451250142d+0*t169*t170*t3*
     ;         t80+7.053569173611901d-2*t15*t161*t79+2.3511897245373004d
     <         -1*t15*t268*t3+1.763392293402975d-2*t15*t163*t270
            t274 = 9.999999999999991d-1*(4.1099018897499934d-3*t266*t9+1
     1         .0991093056753751d-2*t156*t84*t88-1.865442d-1*t167*t173*t
     2         18*t88-8.243319792565315d-3*t173*t75*t84+6.21814d-2*t18*t
     3         273*t84-6.21814d-2*t11*t83**3/t8**3-5.284159572535706d-3*
     4         t156*t76*t83+9.327209999999999d-2*t11*t157*t166*t83-3.109
     5         07d-2*t11*t76*(-7.617854707500852d+0*t2*t82**3/t6**4+1.05
     6         80353760417849d-1*t77*t78*t79*t82+4.2321415041671406d-1*t
     7         162*t3*t77*t82+7.617854707500852d+0*t159*t165*t2*t82-1.26
     8         9642451250142d+0*t2*t77*(2.625411059665811d-1*t162*t79*t8
     9         1+1.9690582947493582d-1*t163*t78*t81-3.9381165894987163d-
     :         1*t164*t79*t80+7.876233178997433d-1*t3*(-1.45856169981433
     ;         94d-1*t268*t4*t79-5.469606374303773d-2*t269*t270*t4-1.312
     <         7055298329054d-1*t161*t163*t4-7.424439106586571d-3*t267)-
     =         1.4585616998143394d-1*t268*t5*t79-5.469606374303773d-2*t2
     >         69*t270*t5-1.3127055298329054d-1*t161*t163*t5)-6.34821225
     ?         625071d-1*t165*t3*t77*t80+1.269642451250142d+0*t159*t160*
     @         t3*t80+7.053569173611901d-2*t161*t7*t79+2.351189724537300
     1         4d-1*t268*t3*t7+1.763392293402975d-2*t163*t270*t7)+3.9631
     2         1967940178d-3*t166*t75*t76+8.243319792565315d-3*t167*t168
     3         *t75-3.96311967940178d-3*t157*t158*t75+1.243628d-1*t18*t2
     4         71*t272-8.548627933030694d-3*t17*t266)-1.0991093056753751
     5         d-2*t156*t84*t88+1.865442d-1*t167*t173*t18*t88+8.24331979
     6         2565315d-3*t173*t75*t84-6.21814d-2*t18*t273*t84-8.2433197
     7         92565315d-3*t167*t168*t75-1.243628d-1*t18*t271*t272+8.548
     8         627933030694d-3*t17*t266
            t275 = 1/t47**3
            t276 = rhoa**5.000000000000002d-1
            t277 = 1/rhoa**6.666666666666665d-1
            t278 = 1/rhoa**1.8333333333333332d+0
            t279 = t89**3
            t280 = exp(-1.92983810657489d+2*t19)
            t281 = 3.453411185284245d+5*gammaaa*t279*t280*t37/t39**4
            t282 = -1.252637628753944d+4*gammaaa*t102*t103*t190*t191*t19
     1         2
            t283 = -3.453411185284245d+5*gammaaa*t191*t192*t279*t37
            t284 = 5.368446980374045d+3*gammaaa*t174*t191*t192*t37*t89
            t285 = -8.240428253953201d+0*gammaaa*t110*t276*t40
            t286 = 8.829030272092719d-1*gammaaa*t114*t277*t40
            t287 = 7.007166882613269d-2*gammaaa*t103*t278*t40
            t288 = 3.4077198126375585d+2*gammaaa*t105*t114*t188*t38*t89
            t289 = -1.6227237203036002d+1*gammaaa*t103*t105*t189*t38*t89
            t290 = 6.263188143769719d+3*gammaaa*t102*t103*t105*t190*t38
            t291 = -9.736342321821596d+1*gammaaa*t102*t103*t105*t174*t38
            t292 = 5.755685308807075d+4*gammaaa*t105*t279*t37*t38
            t293 = -2.6842234901870227d+3*gammaaa*t105*t174*t37*t38*t89
            t294 = 1.3909060459745137d+1*gammaaa*t105*t274*t37*t38
            t295 = 1/t36**7.0d+0
            t296 = 1/t45**4
            t297 = 1.7894823267913484d+3*t190*t191*t192*t37
            t298 = 1.765806054418543d+0*t114*t188*t40
            t299 = -8.408600259135923d-2*t103*t189*t40
            t300 = -6.490894881214397d+1*t102*t103*t105*t38*t89
            t301 = -8.947411633956742d+2*t105*t190*t37*t38
            t302 = 1.3909060459745137d+1*t105*t174*t37*t38
            t303 = 1/t22**5
            t304 = 1.0d+0*(1.5545345434827443d-2*rhoa*t48*(1.91415600012
     1         54607d+1*t142*t21*t62*t99+t21*t23*(1.9141560001254607d+1*
     2         t142*t21*t62*t98+t21*t23*(1.9141560001254607d+1*t142*t21*
     3         t62*t97+t21*t23*(1.9141560001254607d+1*t142*t21*t62*t96+t
     4         21*t23*(1.9141560001254607d+1*t142*t21*t62*t95+t21*t23*(1
     5         .9141560001254607d+1*t142*t21*t62*t94+t21*t23*(1.91415600
     6         01254607d+1*t142*t21*t62*t93+t21*t23*(1.9141560001254607d
     7         +1*t142*t21*t62*t92+t21*t23*(1.9141560001254607d+1*t142*t
     8         21*t62*t91+t21*t23*(1.9141560001254607d+1*t142*t21*t62*t9
     9         0-t175*t21*t63-3.190260000209101d+0*t128*t144*t21*t63-4.5
     :         79991491020378d+1*t128*t141*t63-1.3739974473061137d+2*t14
     ;         1*t21*t217*t51+6.380520000418202d+0*t142*t144*t21*t51+4.5
     <         79991491020378d+1*t141*t142*t51+t21*t23*(-1.3739974473061
     =         137d+2*t141*t21*t217*t50+6.380520000418202d+0*t142*t144*t
     >         21*t50+4.579991491020378d+1*t141*t142*t50)-9.159982982040
     ?         756d+1*t141*t216*t303*t50+9.159982982040756d+1*t141*t21*t
     @         217*t50-t175*t23+3.190260000209101d+0*t128*t144*t23+4.579
     1         991491020378d+1*t128*t141*t142*t21)-9.570780000627304d+0*
     2         t21*t228*t62*t63-t176*t21*t63-3.190260000209101d+0*t129*t
     3         144*t21*t63-4.579991491020378d+1*t129*t141*t63+9.57078000
     4         0627304d+0*t228*t23*t62-1.3739974473061137d+2*t141*t21*t2
     5         17*t52+6.380520000418202d+0*t142*t144*t21*t52+4.579991491
     6         020378d+1*t141*t142*t52-t176*t23+3.190260000209101d+0*t12
     7         9*t144*t23+4.579991491020378d+1*t129*t141*t142*t21)-9.570
     8         780000627304d+0*t21*t229*t62*t63-t177*t21*t63-3.190260000
     9         209101d+0*t130*t144*t21*t63-4.579991491020378d+1*t130*t14
     :         1*t63+9.570780000627304d+0*t229*t23*t62-1.373997447306113
     ;         7d+2*t141*t21*t217*t53+6.380520000418202d+0*t142*t144*t21
     <         *t53+4.579991491020378d+1*t141*t142*t53-t177*t23+3.190260
     =         000209101d+0*t130*t144*t23+4.579991491020378d+1*t130*t141
     >         *t142*t21)-9.570780000627304d+0*t21*t230*t62*t63-t178*t21
     ?         *t63-3.190260000209101d+0*t131*t144*t21*t63-4.57999149102
     @         0378d+1*t131*t141*t63+9.570780000627304d+0*t23*t230*t62-1
     1         .3739974473061137d+2*t141*t21*t217*t54+6.380520000418202d
     2         +0*t142*t144*t21*t54+4.579991491020378d+1*t141*t142*t54-t
     3         178*t23+3.190260000209101d+0*t131*t144*t23+4.579991491020
     4         378d+1*t131*t141*t142*t21)-9.570780000627304d+0*t21*t231*
     5         t62*t63-t179*t21*t63-3.190260000209101d+0*t132*t144*t21*t
     6         63-4.579991491020378d+1*t132*t141*t63+9.570780000627304d+
     7         0*t23*t231*t62-1.3739974473061137d+2*t141*t21*t217*t55+6.
     8         380520000418202d+0*t142*t144*t21*t55+4.579991491020378d+1
     9         *t141*t142*t55-t179*t23+3.190260000209101d+0*t132*t144*t2
     :         3+4.579991491020378d+1*t132*t141*t142*t21)-9.570780000627
     ;         304d+0*t21*t232*t62*t63-t180*t21*t63-3.190260000209101d+0
     <         *t133*t144*t21*t63-4.579991491020378d+1*t133*t141*t63+9.5
     =         70780000627304d+0*t23*t232*t62-1.3739974473061137d+2*t141
     >         *t21*t217*t56+6.380520000418202d+0*t142*t144*t21*t56+4.57
     ?         9991491020378d+1*t141*t142*t56-t180*t23+3.190260000209101
     @         d+0*t133*t144*t23+4.579991491020378d+1*t133*t141*t142*t21
     1         )-9.570780000627304d+0*t21*t233*t62*t63-t181*t21*t63-3.19
     2         0260000209101d+0*t134*t144*t21*t63-4.579991491020378d+1*t
     3         134*t141*t63+9.570780000627304d+0*t23*t233*t62-1.37399744
     4         73061137d+2*t141*t21*t217*t57+6.380520000418202d+0*t142*t
     5         144*t21*t57+4.579991491020378d+1*t141*t142*t57-t181*t23+3
     6         .190260000209101d+0*t134*t144*t23+4.579991491020378d+1*t1
     7         34*t141*t142*t21)-9.570780000627304d+0*t21*t234*t62*t63-t
     8         182*t21*t63-3.190260000209101d+0*t135*t144*t21*t63-4.5799
     9         91491020378d+1*t135*t141*t63+9.570780000627304d+0*t23*t23
     :         4*t62-1.3739974473061137d+2*t141*t21*t217*t58+6.380520000
     ;         418202d+0*t142*t144*t21*t58+4.579991491020378d+1*t141*t14
     <         2*t58-t182*t23+3.190260000209101d+0*t135*t144*t23+4.57999
     =         1491020378d+1*t135*t141*t142*t21)-9.570780000627304d+0*t2
     >         1*t235*t62*t63-t183*t21*t63-3.190260000209101d+0*t136*t14
     ?         4*t21*t63-4.579991491020378d+1*t136*t141*t63+9.5707800006
     @         27304d+0*t23*t235*t62-1.3739974473061137d+2*t141*t21*t217
     1         *t59+6.380520000418202d+0*t142*t144*t21*t59+4.57999149102
     2         0378d+1*t141*t142*t59-t183*t23+3.190260000209101d+0*t136*
     3         t144*t23+4.579991491020378d+1*t136*t141*t142*t21)-9.57078
     4         0000627304d+0*t21*t236*t62*t63-t184*t21*t63-3.19026000020
     5         9101d+0*t137*t144*t21*t63-4.579991491020378d+1*t137*t141*
     6         t63+9.570780000627304d+0*t23*t236*t62-1.3739974473061137d
     7         +2*t141*t21*t217*t60+6.380520000418202d+0*t142*t144*t21*t
     8         60+4.579991491020378d+1*t141*t142*t60-t184*t23+3.19026000
     9         0209101d+0*t137*t144*t23+4.579991491020378d+1*t137*t141*t
     :         142*t21)+2.0d+0*rhoa*t227*t89+2.0d+0*t127*t89+1.0d+0*rhoa
     ;         *t19*(1.9141560001254607d+1*t142*t21*t62*t73+t21*t23*(1.9
     <         141560001254607d+1*t142*t21*t62*t72+t21*t23*(1.9141560001
     =         254607d+1*t142*t21*t62*t71+t21*t23*(1.9141560001254607d+1
     >         *t142*t21*t62*t70+t21*t23*(1.9141560001254607d+1*t142*t21
     ?         *t62*t69+t21*t23*(1.9141560001254607d+1*t142*t21*t62*t68+
     @         t21*t23*(1.9141560001254607d+1*t142*t21*t62*t67+t21*t23*(
     1         1.9141560001254607d+1*t142*t21*t62*t66+t21*t23*(1.9141560
     2         001254607d+1*t142*t21*t62*t65+t21*t23*(1.9141560001254607
     3         d+1*t142*t21*t62*t64-t145*t21*t63-3.190260000209101d+0*t1
     4         17*t144*t21*t63-4.579991491020378d+1*t117*t141*t63-9.1599
     5         82982040756d+1*t141*t216*t24*t303-1.3739974473061137d+2*t
     6         141*t21*t217*t25+6.380520000418202d+0*t142*t144*t21*t25+4
     7         .579991491020378d+1*t141*t142*t25+t21*t23*(-1.37399744730
     8         61137d+2*t141*t21*t217*t24+6.380520000418202d+0*t142*t144
     9         *t21*t24+4.579991491020378d+1*t141*t142*t24)+9.1599829820
     :         40756d+1*t141*t21*t217*t24-t145*t23+3.190260000209101d+0*
     ;         t117*t144*t23+4.579991491020378d+1*t117*t141*t142*t21)-9.
     <         570780000627304d+0*t21*t218*t62*t63-t146*t21*t63-3.190260
     =         000209101d+0*t118*t144*t21*t63-4.579991491020378d+1*t118*
     >         t141*t63+9.570780000627304d+0*t218*t23*t62-1.373997447306
     ?         1137d+2*t141*t21*t217*t26+6.380520000418202d+0*t142*t144*
     @         t21*t26+4.579991491020378d+1*t141*t142*t26-t146*t23+3.190
     1         260000209101d+0*t118*t144*t23+4.579991491020378d+1*t118*t
     2         141*t142*t21)-9.570780000627304d+0*t21*t219*t62*t63-t147*
     3         t21*t63-3.190260000209101d+0*t119*t144*t21*t63-4.57999149
     4         1020378d+1*t119*t141*t63+9.570780000627304d+0*t219*t23*t6
     5         2-1.3739974473061137d+2*t141*t21*t217*t27+6.3805200004182
     6         02d+0*t142*t144*t21*t27+4.579991491020378d+1*t141*t142*t2
     7         7-t147*t23+3.190260000209101d+0*t119*t144*t23+4.579991491
     8         020378d+1*t119*t141*t142*t21)-9.570780000627304d+0*t21*t2
     9         20*t62*t63-t148*t21*t63-3.190260000209101d+0*t120*t144*t2
     :         1*t63-4.579991491020378d+1*t120*t141*t63+9.57078000062730
     ;         4d+0*t220*t23*t62-1.3739974473061137d+2*t141*t21*t217*t28
     <         +6.380520000418202d+0*t142*t144*t21*t28+4.579991491020378
     =         d+1*t141*t142*t28-t148*t23+3.190260000209101d+0*t120*t144
     >         *t23+4.579991491020378d+1*t120*t141*t142*t21)-9.570780000
     ?         627304d+0*t21*t221*t62*t63-t149*t21*t63-3.190260000209101
     @         d+0*t121*t144*t21*t63-4.579991491020378d+1*t121*t141*t63+
     1         9.570780000627304d+0*t221*t23*t62-1.3739974473061137d+2*t
     2         141*t21*t217*t29+6.380520000418202d+0*t142*t144*t21*t29+4
     3         .579991491020378d+1*t141*t142*t29-t149*t23+3.190260000209
     4         101d+0*t121*t144*t23+4.579991491020378d+1*t121*t141*t142*
     5         t21)-9.570780000627304d+0*t21*t222*t62*t63-t150*t21*t63-3
     6         .190260000209101d+0*t122*t144*t21*t63-4.579991491020378d+
     7         1*t122*t141*t63+9.570780000627304d+0*t222*t23*t62-1.37399
     8         74473061137d+2*t141*t21*t217*t30+6.380520000418202d+0*t14
     9         2*t144*t21*t30+4.579991491020378d+1*t141*t142*t30-t150*t2
     :         3+3.190260000209101d+0*t122*t144*t23+4.579991491020378d+1
     ;         *t122*t141*t142*t21)-9.570780000627304d+0*t21*t223*t62*t6
     <         3-t151*t21*t63-3.190260000209101d+0*t123*t144*t21*t63-4.5
     =         79991491020378d+1*t123*t141*t63+9.570780000627304d+0*t223
     >         *t23*t62-1.3739974473061137d+2*t141*t21*t217*t31+6.380520
     ?         000418202d+0*t142*t144*t21*t31+4.579991491020378d+1*t141*
     @         t142*t31-t151*t23+3.190260000209101d+0*t123*t144*t23+4.57
     1         9991491020378d+1*t123*t141*t142*t21)-9.570780000627304d+0
     2         *t21*t224*t62*t63-t152*t21*t63-3.190260000209101d+0*t124*
     3         t144*t21*t63-4.579991491020378d+1*t124*t141*t63+9.5707800
     4         00627304d+0*t224*t23*t62-1.3739974473061137d+2*t141*t21*t
     5         217*t32+6.380520000418202d+0*t142*t144*t21*t32+4.57999149
     6         1020378d+1*t141*t142*t32-t152*t23+3.190260000209101d+0*t1
     7         24*t144*t23+4.579991491020378d+1*t124*t141*t142*t21)-9.57
     8         0780000627304d+0*t21*t225*t62*t63-t153*t21*t63-3.19026000
     9         0209101d+0*t125*t144*t21*t63-4.579991491020378d+1*t125*t1
     :         41*t63+9.570780000627304d+0*t225*t23*t62-1.37399744730611
     ;         37d+2*t141*t21*t217*t33+6.380520000418202d+0*t142*t144*t2
     <         1*t33+4.579991491020378d+1*t141*t142*t33-t153*t23+3.19026
     =         0000209101d+0*t125*t144*t23+4.579991491020378d+1*t125*t14
     >         1*t142*t21)-9.570780000627304d+0*t21*t226*t62*t63-t154*t2
     ?         1*t63-3.190260000209101d+0*t126*t144*t21*t63-4.5799914910
     @         20378d+1*t126*t141*t63+9.570780000627304d+0*t226*t23*t62-
     1         1.3739974473061137d+2*t141*t21*t217*t34+6.380520000418202
     2         d+0*t142*t144*t21*t34+4.579991491020378d+1*t141*t142*t34-
     3         t154*t23+3.190260000209101d+0*t126*t144*t23+4.57999149102
     4         0378d+1*t126*t141*t142*t21)+3.1090690869654886d-2*t237*t4
     5         8+t101*(3.1090690869654886d-2*rhoa*t113*t237+1.5545345434
     6         827443d-2*rhoa*t139*t205+3.1090690869654886d-2*t113*t139)
     7         +2.0d+0*t19*t227-1.5545345434827443d-2*rhoa*t139*t186*t18
     8         7+1.0d+0*rhoa*t127*t174)*wght
            t305 = 1.0d+0*(t101*(1.5545345434827443d-2*rhoa*t116*t237+1.
     1         5545345434827443d-2*rhoa*t139*t211+1.5545345434827443d-2*
     2         t116*t139)-1.5545345434827443d-2*rhoa*t113*t116*t139*t186
     3         )*wght
            t306 = 1.5545345434827443d-2*rhoa*t101*t139*t215*wght-1.5545
     1         345434827443d-2*rhoa*t139*t186*t213*wght
            t307 = 1.0d+0*(1.5545345434827443d-2*rhoa*t48*(2*t63*t99+2*t
     1         142*t21*t99+t21*t23*(2*t63*t98+2*t142*t21*t98+t21*t23*(2*
     2         t63*t97+2*t142*t21*t97+t21*t23*(2*t63*t96+2*t142*t21*t96+
     3         t21*t23*(2*t63*t95+2*t142*t21*t95+t21*t23*(2*t63*t94+2*t1
     4         42*t21*t94+t21*t23*(2*t63*t93+2*t142*t21*t93+t21*t23*(2*t
     5         63*t92+2*t142*t21*t92+t21*t23*(2*t63*t91+2*t142*t21*t91+t
     6         21*t23*(2*t63*t90+2*t142*t21*t90-4.785390000313652d+0*t21
     7         *t251*t62*t63-2.8712340001881914d+1*t21*t217*t51*t62-9.57
     8         0780000627304d+0*t142*t51*t62-4.785390000313652d+1*t216*t
     9         303*t50*t62-2.8712340001881914d+1*t21*t217*t50*t62+4.7853
     :         90000313652d+0*t23*t251*t62+1.9141560001254607d+1*t128*t1
     ;         42*t21*t62)-4.785390000313652d+0*t21*t252*t62*t63-2*t21*t
     <         228*t63-2.8712340001881914d+1*t21*t217*t52*t62-9.57078000
     =         0627304d+0*t142*t52*t62+4.785390000313652d+0*t23*t252*t62
     >         +1.9141560001254607d+1*t129*t142*t21*t62-2*t228*t23)-4.78
     ?         5390000313652d+0*t21*t253*t62*t63-2*t21*t229*t63-2.871234
     @         0001881914d+1*t21*t217*t53*t62-9.570780000627304d+0*t142*
     1         t53*t62+4.785390000313652d+0*t23*t253*t62+1.9141560001254
     2         607d+1*t130*t142*t21*t62-2*t229*t23)-4.785390000313652d+0
     3         *t21*t254*t62*t63-2*t21*t230*t63-2.8712340001881914d+1*t2
     4         1*t217*t54*t62-9.570780000627304d+0*t142*t54*t62+4.785390
     5         000313652d+0*t23*t254*t62+1.9141560001254607d+1*t131*t142
     6         *t21*t62-2*t23*t230)-4.785390000313652d+0*t21*t255*t62*t6
     7         3-2*t21*t231*t63-2.8712340001881914d+1*t21*t217*t55*t62-9
     8         .570780000627304d+0*t142*t55*t62+4.785390000313652d+0*t23
     9         *t255*t62+1.9141560001254607d+1*t132*t142*t21*t62-2*t23*t
     :         231)-4.785390000313652d+0*t21*t256*t62*t63-2*t21*t232*t63
     ;         -2.8712340001881914d+1*t21*t217*t56*t62-9.570780000627304
     <         d+0*t142*t56*t62+4.785390000313652d+0*t23*t256*t62+1.9141
     =         560001254607d+1*t133*t142*t21*t62-2*t23*t232)-4.785390000
     >         313652d+0*t21*t257*t62*t63-2*t21*t233*t63-2.8712340001881
     ?         914d+1*t21*t217*t57*t62-9.570780000627304d+0*t142*t57*t62
     @         +4.785390000313652d+0*t23*t257*t62+1.9141560001254607d+1*
     1         t134*t142*t21*t62-2*t23*t233)-4.785390000313652d+0*t21*t2
     2         58*t62*t63-2*t21*t234*t63-2.8712340001881914d+1*t21*t217*
     3         t58*t62-9.570780000627304d+0*t142*t58*t62+4.7853900003136
     4         52d+0*t23*t258*t62+1.9141560001254607d+1*t135*t142*t21*t6
     5         2-2*t23*t234)-4.785390000313652d+0*t21*t259*t62*t63-2*t21
     6         *t235*t63-2.8712340001881914d+1*t21*t217*t59*t62-9.570780
     7         000627304d+0*t142*t59*t62+4.785390000313652d+0*t23*t259*t
     8         62+1.9141560001254607d+1*t136*t142*t21*t62-2*t23*t235)-4.
     9         785390000313652d+0*t21*t260*t62*t63-2*t21*t236*t63-2.8712
     :         340001881914d+1*t21*t217*t60*t62-9.570780000627304d+0*t14
     ;         2*t60*t62+4.785390000313652d+0*t23*t260*t62+1.91415600012
     <         54607d+1*t137*t142*t21*t62-2*t23*t236)+1.0d+0*rhoa*t250*t
     =         89+1.0d+0*rhoa*t19*(2*t63*t73+2*t142*t21*t73+t21*t23*(2*t
     >         63*t72+2*t142*t21*t72+t21*t23*(2*t63*t71+2*t142*t21*t71+t
     ?         21*t23*(2*t63*t70+2*t142*t21*t70+t21*t23*(2*t63*t69+2*t14
     @         2*t21*t69+t21*t23*(2*t63*t68+2*t142*t21*t68+t21*t23*(2*t6
     1         3*t67+2*t142*t21*t67+t21*t23*(2*t63*t66+2*t142*t21*t66+t2
     2         1*t23*(2*t63*t65+2*t142*t21*t65+t21*t23*(2*t63*t64+2*t142
     3         *t21*t64-4.785390000313652d+0*t21*t240*t62*t63-4.78539000
     4         0313652d+1*t216*t24*t303*t62-2.8712340001881914d+1*t21*t2
     5         17*t25*t62-9.570780000627304d+0*t142*t25*t62+4.7853900003
     6         13652d+0*t23*t240*t62-2.8712340001881914d+1*t21*t217*t24*
     7         t62+1.9141560001254607d+1*t117*t142*t21*t62)-4.7853900003
     8         13652d+0*t21*t241*t62*t63-2*t21*t218*t63-2.87123400018819
     9         14d+1*t21*t217*t26*t62-9.570780000627304d+0*t142*t26*t62+
     :         4.785390000313652d+0*t23*t241*t62+1.9141560001254607d+1*t
     ;         118*t142*t21*t62-2*t218*t23)-4.785390000313652d+0*t21*t24
     <         2*t62*t63-2*t21*t219*t63-2.8712340001881914d+1*t21*t217*t
     =         27*t62-9.570780000627304d+0*t142*t27*t62+4.78539000031365
     >         2d+0*t23*t242*t62+1.9141560001254607d+1*t119*t142*t21*t62
     ?         -2*t219*t23)-4.785390000313652d+0*t21*t243*t62*t63-2*t21*
     @         t220*t63-2.8712340001881914d+1*t21*t217*t28*t62-9.5707800
     1         00627304d+0*t142*t28*t62+4.785390000313652d+0*t23*t243*t6
     2         2+1.9141560001254607d+1*t120*t142*t21*t62-2*t220*t23)-4.7
     3         85390000313652d+0*t21*t244*t62*t63-2*t21*t221*t63-2.87123
     4         40001881914d+1*t21*t217*t29*t62-9.570780000627304d+0*t142
     5         *t29*t62+4.785390000313652d+0*t23*t244*t62+1.914156000125
     6         4607d+1*t121*t142*t21*t62-2*t221*t23)-4.785390000313652d+
     7         0*t21*t245*t62*t63-2*t21*t222*t63-2.8712340001881914d+1*t
     8         21*t217*t30*t62-9.570780000627304d+0*t142*t30*t62+4.78539
     9         0000313652d+0*t23*t245*t62+1.9141560001254607d+1*t122*t14
     :         2*t21*t62-2*t222*t23)-4.785390000313652d+0*t21*t246*t62*t
     ;         63-2*t21*t223*t63-2.8712340001881914d+1*t21*t217*t31*t62-
     <         9.570780000627304d+0*t142*t31*t62+4.785390000313652d+0*t2
     =         3*t246*t62+1.9141560001254607d+1*t123*t142*t21*t62-2*t223
     >         *t23)-4.785390000313652d+0*t21*t247*t62*t63-2*t21*t224*t6
     ?         3-2.8712340001881914d+1*t21*t217*t32*t62-9.57078000062730
     @         4d+0*t142*t32*t62+4.785390000313652d+0*t23*t247*t62+1.914
     1         1560001254607d+1*t124*t142*t21*t62-2*t224*t23)-4.78539000
     2         0313652d+0*t21*t248*t62*t63-2*t21*t225*t63-2.871234000188
     3         1914d+1*t21*t217*t33*t62-9.570780000627304d+0*t142*t33*t6
     4         2+4.785390000313652d+0*t23*t248*t62+1.9141560001254607d+1
     5         *t125*t142*t21*t62-2*t225*t23)-4.785390000313652d+0*t21*t
     6         249*t62*t63-2*t21*t226*t63-2.8712340001881914d+1*t21*t217
     7         *t34*t62-9.570780000627304d+0*t142*t34*t62+4.785390000313
     8         652d+0*t23*t249*t62+1.9141560001254607d+1*t126*t142*t21*t
     9         62-2*t226*t23)+1.5545345434827443d-2*t262*t48+1.554534543
     :         4827443d-2*rhoa*t101*t113*t262+1.0d+0*t19*t250)*wght
            t308 = 1.5545345434827443d-2*rhoa*t101*t116*(t23*(2*t21*t59*
     1         t63+2*t23*t59+t21*t260-2*t136*t21*t23)+(2*t21*t23*t59+2*t
     2         49-2*t137*t21)*t63+t261)*wght
            t309 = 1.0d+0*(1.5545345434827443d-2*rhoa*t48*(t21*t23*(t21*
     1         t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23
     2         *(t21*t23*(-3*t21*t251*t63+6*t128*t63-6*t21*t217*t51-6*t1
     3         42*t51+t21*t23*(-6*t21*t217*t50-6*t142*t50)-3*t23*t251+6*
     4         t128*t142*t21)-3*t21*t252*t63+6*t129*t63-6*t21*t217*t52-6
     5         *t142*t52-3*t23*t252+6*t129*t142*t21)-3*t21*t253*t63+6*t1
     6         30*t63-6*t21*t217*t53-6*t142*t53-3*t23*t253+6*t130*t142*t
     7         21)-3*t21*t254*t63+6*t131*t63-6*t21*t217*t54-6*t142*t54-3
     8         *t23*t254+6*t131*t142*t21)-3*t21*t255*t63+6*t132*t63-6*t2
     9         1*t217*t55-6*t142*t55-3*t23*t255+6*t132*t142*t21)-3*t21*t
     :         256*t63+6*t133*t63-6*t21*t217*t56-6*t142*t56-3*t23*t256+6
     ;         *t133*t142*t21)-3*t21*t257*t63+6*t134*t63-6*t21*t217*t57-
     <         6*t142*t57-3*t23*t257+6*t134*t142*t21)-3*t21*t258*t63+6*t
     =         135*t63-6*t21*t217*t58-6*t142*t58-3*t23*t258+6*t135*t142*
     >         t21)-3*t21*t259*t63+6*t136*t63-6*t21*t217*t59-6*t142*t59-
     ?         3*t23*t259+6*t136*t142*t21)-3*t21*t260*t63+6*t137*t63-6*t
     @         21*t217*t60-6*t142*t60-3*t23*t260+6*t137*t142*t21)+1.0d+0
     1         *rhoa*t19*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t
     2         21*t23*(t21*t23*(t21*t23*(t21*t23*(-3*t21*t240*t63+6*t117
     3         *t63-6*t21*t217*t25-6*t142*t25-3*t23*t240+t21*t23*(-6*t21
     4         *t217*t24-6*t142*t24)+6*t117*t142*t21)-3*t21*t241*t63+6*t
     5         118*t63-6*t21*t217*t26-6*t142*t26-3*t23*t241+6*t118*t142*
     6         t21)-3*t21*t242*t63+6*t119*t63-6*t21*t217*t27-6*t142*t27-
     7         3*t23*t242+6*t119*t142*t21)-3*t21*t243*t63+6*t120*t63-6*t
     8         21*t217*t28-6*t142*t28-3*t23*t243+6*t120*t142*t21)-3*t21*
     9         t244*t63+6*t121*t63-6*t21*t217*t29-6*t142*t29-3*t23*t244+
     :         6*t121*t142*t21)-3*t21*t245*t63+6*t122*t63-6*t21*t217*t30
     ;         -6*t142*t30-3*t23*t245+6*t122*t142*t21)-3*t21*t246*t63+6*
     <         t123*t63-6*t21*t217*t31-6*t142*t31-3*t23*t246+6*t123*t142
     =         *t21)-3*t21*t247*t63+6*t124*t63-6*t21*t217*t32-6*t142*t32
     >         -3*t23*t247+6*t124*t142*t21)-3*t21*t248*t63+6*t125*t63-6*
     ?         t21*t217*t33-6*t142*t33-3*t23*t248+6*t125*t142*t21)-3*t21
     @         *t249*t63+6*t126*t63-6*t21*t217*t34-6*t142*t34-3*t23*t249
     1         +6*t126*t142*t21))*wght
            fnc(iq) = 1.0d+0*(1.5545345434827443d-2*rhoa*t48*t61+1.0d+0*
     1         rhoa*t19*t35)*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*(1.0d+0*rhoa*t35*t89+1.0d+0*rhoa*t19
     1         *t74+1.5545345434827443d-2*t48*t61+1.5545345434827443d-2*
     2         rhoa*t101*t113*t61+1.5545345434827443d-2*rhoa*t100*t48+1.
     3         0d+0*t19*t35)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.5545345434827443d-2*rhoa*t101*t116*t61*w
     1         ght+Cmat(iq,D1_GAA)
            Mmat(iq,D1_TA) = t140+Mmat(iq,D1_TA)
            Mmat(iq,D1_TB) = t140+Mmat(iq,D1_TB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*(2.0d+0*rhoa*t74*t89+2.0d+0*t35*
     1         t89+2.0d+0*t19*t74-1.5545345434827443d-2*rhoa*t186*t187*t
     2         61+1.5545345434827443d-2*rhoa*t185*t48+3.1090690869654886
     3         d-2*t100*t48+1.0d+0*rhoa*t174*t35+t101*t206+1.0d+0*rhoa*t
     4         155*t19)*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*(t101*t212-1.5545345434827443d-
     1         2*rhoa*t113*t116*t186*t61)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.5545345434827443d-2*rhoa*t101*t215*
     1         t61*wght-1.5545345434827443d-2*rhoa*t186*t213*t61*wght+Cm
     2         at2(iq,D2_GAA_GAA)
            Mmat2(iq,D2_RA_TA) = t238+Mmat2(iq,D2_RA_TA)
            Mmat2(iq,D2_RA_TB) = t238+Mmat2(iq,D2_RA_TB)
            Mmat2(iq,D2_GAA_TA) = t239+Mmat2(iq,D2_GAA_TA)
            Mmat2(iq,D2_GAA_TB) = t239+Mmat2(iq,D2_GAA_TB)
            Mmat2(iq,D2_TA_TA) = t263+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = t263+Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = t263+Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*(1.5545345434827443d-2*rhoa*t
     1         48*(-9.570780000627304d+0*t144*t21*t63*t99-1.373997447306
     2         1137d+2*t141*t63*t99+9.570780000627304d+0*t144*t23*t99+1.
     3         3739974473061137d+2*t141*t142*t21*t99+t21*t23*(-9.5707800
     4         00627304d+0*t144*t21*t63*t98-1.3739974473061137d+2*t141*t
     5         63*t98+9.570780000627304d+0*t144*t23*t98+1.37399744730611
     6         37d+2*t141*t142*t21*t98+t21*t23*(-9.570780000627304d+0*t1
     7         44*t21*t63*t97-1.3739974473061137d+2*t141*t63*t97+9.57078
     8         0000627304d+0*t144*t23*t97+1.3739974473061137d+2*t141*t14
     9         2*t21*t97+t21*t23*(-9.570780000627304d+0*t144*t21*t63*t96
     :         -1.3739974473061137d+2*t141*t63*t96+9.570780000627304d+0*
     ;         t144*t23*t96+1.3739974473061137d+2*t141*t142*t21*t96+t21*
     <         t23*(-9.570780000627304d+0*t144*t21*t63*t95-1.37399744730
     =         61137d+2*t141*t63*t95+9.570780000627304d+0*t144*t23*t95+1
     >         .3739974473061137d+2*t141*t142*t21*t95+t21*t23*(-9.570780
     ?         000627304d+0*t144*t21*t63*t94-1.3739974473061137d+2*t141*
     @         t63*t94+9.570780000627304d+0*t144*t23*t94+1.3739974473061
     1         137d+2*t141*t142*t21*t94+t21*t23*(-9.570780000627304d+0*t
     2         144*t21*t63*t93-1.3739974473061137d+2*t141*t63*t93+9.5707
     3         80000627304d+0*t144*t23*t93+1.3739974473061137d+2*t141*t1
     4         42*t21*t93+t21*t23*(-9.570780000627304d+0*t144*t21*t63*t9
     5         2-1.3739974473061137d+2*t141*t63*t92+9.570780000627304d+0
     6         *t144*t23*t92+1.3739974473061137d+2*t141*t142*t21*t92+t21
     7         *t23*(-9.570780000627304d+0*t144*t21*t63*t91-1.3739974473
     8         061137d+2*t141*t63*t91+9.570780000627304d+0*t144*t23*t91+
     9         1.3739974473061137d+2*t141*t142*t21*t91+t21*t23*(-9.57078
     :         0000627304d+0*t144*t21*t63*t90-1.3739974473061137d+2*t141
     ;         *t63*t90+9.570780000627304d+0*t144*t23*t90+1.373997447306
     <         1137d+2*t141*t142*t21*t90+t21*t23*(1.0634200000697003d+0*
     =         t21*t265*t50*t63-9.159982982040756d+1*t143*t50*t63-1.0634
     >         200000697003d+0*t23*t265*t50-6.57511364479516d+2*t21*t217
     ?         *t264*t50+6.57511364479516d+2*t142*t264*t50+9.15998298204
     @         0756d+1*t142*t143*t21*t50)-1.4356170000940957d+1*t175*t21
     1         *t62*t63+1.0634200000697003d+0*t21*t265*t51*t63-9.1599829
     2         82040756d+1*t143*t51*t63+1.4356170000940957d+1*t175*t23*t
     3         62-1.0634200000697003d+0*t23*t265*t51-6.57511364479516d+2
     4         *t21*t217*t264*t51+6.57511364479516d+2*t142*t264*t51+9.15
     5         9982982040756d+1*t142*t143*t21*t51)-1.4356170000940957d+1
     6         *t176*t21*t62*t63+1.0634200000697003d+0*t21*t265*t52*t63-
     7         9.159982982040756d+1*t143*t52*t63+1.4356170000940957d+1*t
     8         176*t23*t62-1.0634200000697003d+0*t23*t265*t52-6.57511364
     9         479516d+2*t21*t217*t264*t52+6.57511364479516d+2*t142*t264
     :         *t52+9.159982982040756d+1*t142*t143*t21*t52)-1.4356170000
     ;         940957d+1*t177*t21*t62*t63+1.0634200000697003d+0*t21*t265
     <         *t53*t63-9.159982982040756d+1*t143*t53*t63+1.435617000094
     =         0957d+1*t177*t23*t62-1.0634200000697003d+0*t23*t265*t53-6
     >         .57511364479516d+2*t21*t217*t264*t53+6.57511364479516d+2*
     ?         t142*t264*t53+9.159982982040756d+1*t142*t143*t21*t53)-1.4
     @         356170000940957d+1*t178*t21*t62*t63+1.0634200000697003d+0
     1         *t21*t265*t54*t63-9.159982982040756d+1*t143*t54*t63+1.435
     2         6170000940957d+1*t178*t23*t62-1.0634200000697003d+0*t23*t
     3         265*t54-6.57511364479516d+2*t21*t217*t264*t54+6.575113644
     4         79516d+2*t142*t264*t54+9.159982982040756d+1*t142*t143*t21
     5         *t54)-1.4356170000940957d+1*t179*t21*t62*t63+1.0634200000
     6         697003d+0*t21*t265*t55*t63-9.159982982040756d+1*t143*t55*
     7         t63+1.4356170000940957d+1*t179*t23*t62-1.0634200000697003
     8         d+0*t23*t265*t55-6.57511364479516d+2*t21*t217*t264*t55+6.
     9         57511364479516d+2*t142*t264*t55+9.159982982040756d+1*t142
     :         *t143*t21*t55)-1.4356170000940957d+1*t180*t21*t62*t63+1.0
     ;         634200000697003d+0*t21*t265*t56*t63-9.159982982040756d+1*
     <         t143*t56*t63+1.4356170000940957d+1*t180*t23*t62-1.0634200
     =         000697003d+0*t23*t265*t56-6.57511364479516d+2*t21*t217*t2
     >         64*t56+6.57511364479516d+2*t142*t264*t56+9.15998298204075
     ?         6d+1*t142*t143*t21*t56)-1.4356170000940957d+1*t181*t21*t6
     @         2*t63+1.0634200000697003d+0*t21*t265*t57*t63-9.1599829820
     1         40756d+1*t143*t57*t63+1.4356170000940957d+1*t181*t23*t62-
     2         1.0634200000697003d+0*t23*t265*t57-6.57511364479516d+2*t2
     3         1*t217*t264*t57+6.57511364479516d+2*t142*t264*t57+9.15998
     4         2982040756d+1*t142*t143*t21*t57)-1.4356170000940957d+1*t1
     5         82*t21*t62*t63+1.0634200000697003d+0*t21*t265*t58*t63-9.1
     6         59982982040756d+1*t143*t58*t63+1.4356170000940957d+1*t182
     7         *t23*t62-1.0634200000697003d+0*t23*t265*t58-6.57511364479
     8         516d+2*t21*t217*t264*t58+6.57511364479516d+2*t142*t264*t5
     9         8+9.159982982040756d+1*t142*t143*t21*t58)-1.4356170000940
     :         957d+1*t183*t21*t62*t63+1.0634200000697003d+0*t21*t265*t5
     ;         9*t63-9.159982982040756d+1*t143*t59*t63+1.435617000094095
     <         7d+1*t183*t23*t62-1.0634200000697003d+0*t23*t265*t59-6.57
     =         511364479516d+2*t21*t217*t264*t59+6.57511364479516d+2*t14
     >         2*t264*t59+9.159982982040756d+1*t142*t143*t21*t59)-1.4356
     ?         170000940957d+1*t184*t21*t62*t63+1.0634200000697003d+0*t2
     @         1*t265*t60*t63-9.159982982040756d+1*t143*t60*t63+1.435617
     1         0000940957d+1*t184*t23*t62-1.0634200000697003d+0*t23*t265
     2         *t60-6.57511364479516d+2*t21*t217*t264*t60+6.575113644795
     3         16d+2*t142*t264*t60+9.159982982040756d+1*t142*t143*t21*t6
     4         0)+t101*(1.5545345434827443d-2*rhoa*t61*(-2.1622114952063
     5         792d-1*gammaaa*t108*t37*t42*(-1.1607717772370736d+3*t111*
     6         t174*t38*t43*t89+3.482315331711221d+3*t174*t191*t200*t43*
     7         t89+4.912140634218306d+2*t109*t111*t188*t201*t38*t89-1.40
     8         34687526338022d+1*t109*t110*t111*t189*t38*t89-8.908774348
     9         060524d+0*t109*t276*t295*t44+3.030195356483172d-2*t109*t1
     :         10*t278*t44+6.363410248614663d-1*t109*t201*t277*t44+2.986
     ;         8021449983523d+5*t279*t280*t43/t39**5.0d+0+2.489001787498
     <         6267d+4*t111*t279*t38*t43+6.014866082716293d+0*t111*t274*
     =         t38*t43-2.2401016087487644d+5*t191*t200*t279*t43+5.416934
     >         960439677d+3*t102*t109*t110*t111*t190*t38-8.4208125158028
     ?         09d+1*t102*t109*t110*t111*t174*t38+t294+t293+t292+t291+t2
     @         90+t289+t288+t287+t286+t285+t284+t283+t282+t281-1.6250804
     1         88131903d+4*t102*t109*t110*t190*t191*t200)+7.007166882613
     2         269d-2*gammaaa*t103*t278*t42*t46+8.829030272092719d-1*gam
     3         maaa*t114*t277*t42*t46-8.240428253953201d+0*gammaaa*t110*
     4         t276*t42*t46+2.1622114952063792d-1*gammaaa*(t294+t293+t29
     5         2+t291+t290+t289+t288+t287+t286+t285+t284+t283+t282+t281)
     6         *t37*t46-1.5135480466444656d+0*gammaaa*t102*t103*t199*t46
     7         -2.522580077740777d-1*gammaaa*t103*t107*t189*t46+5.297418
     8         163255629d+0*gammaaa*t107*t114*t188*t46-1.297326897123827
     9         8d+0*gammaaa*t112**3*t296*t37*t42+1.2973268971238278d+0*g
     :         ammaaa*t112*t202*t203*t37*t42-3.027096093288931d+0*gammaa
     ;         a*t102*t103*t203*t204*t42+1.5135480466444656d+0*gammaaa*t
     <         102*t103*t108*t202*t42+2.522580077740777d-1*gammaaa*t103*
     =         t108*t112*t189*t42-5.297418163255629d+0*gammaaa*t108*t112
     >         *t114*t188*t42+1.2973268971238278d+0*gammaaa*t107*t203*t2
     ?         04*t37-6.486634485619138d-1*gammaaa*t107*t108*t202*t37-6.
     @         486634485619138d-1*gammaaa*t108*t112*t199*t37+3.027096093
     1         288931d+0*gammaaa*t102*t103*t107*t108*t112)+4.66360363044
     2         82326d-2*t205*t61+4.6636036304482326d-2*rhoa*t100*t205+4.
     3         6636036304482326d-2*rhoa*t113*t185+9.327207260896465d-2*t
     4         100*t113)+6.0d+0*t74*t89+3.0d+0*rhoa*t155*t89+3.0d+0*rhoa
     5         *t174*t74+1.0d+0*rhoa*t19*(-9.570780000627304d+0*t144*t21
     6         *t63*t73-1.3739974473061137d+2*t141*t63*t73+9.57078000062
     7         7304d+0*t144*t23*t73+1.3739974473061137d+2*t141*t142*t21*
     8         t73+t21*t23*(-9.570780000627304d+0*t144*t21*t63*t72-1.373
     9         9974473061137d+2*t141*t63*t72+9.570780000627304d+0*t144*t
     :         23*t72+1.3739974473061137d+2*t141*t142*t21*t72+t21*t23*(-
     ;         9.570780000627304d+0*t144*t21*t63*t71-1.3739974473061137d
     <         +2*t141*t63*t71+9.570780000627304d+0*t144*t23*t71+1.37399
     =         74473061137d+2*t141*t142*t21*t71+t21*t23*(-9.570780000627
     >         304d+0*t144*t21*t63*t70-1.3739974473061137d+2*t141*t63*t7
     ?         0+9.570780000627304d+0*t144*t23*t70+1.3739974473061137d+2
     @         *t141*t142*t21*t70+t21*t23*(-9.570780000627304d+0*t144*t2
     1         1*t63*t69-1.3739974473061137d+2*t141*t63*t69+9.5707800006
     2         27304d+0*t144*t23*t69+1.3739974473061137d+2*t141*t142*t21
     3         *t69+t21*t23*(-9.570780000627304d+0*t144*t21*t63*t68-1.37
     4         39974473061137d+2*t141*t63*t68+9.570780000627304d+0*t144*
     5         t23*t68+1.3739974473061137d+2*t141*t142*t21*t68+t21*t23*(
     6         -9.570780000627304d+0*t144*t21*t63*t67-1.3739974473061137
     7         d+2*t141*t63*t67+9.570780000627304d+0*t144*t23*t67+1.3739
     8         974473061137d+2*t141*t142*t21*t67+t21*t23*(-9.57078000062
     9         7304d+0*t144*t21*t63*t66-1.3739974473061137d+2*t141*t63*t
     :         66+9.570780000627304d+0*t144*t23*t66+1.3739974473061137d+
     ;         2*t141*t142*t21*t66+t21*t23*(-9.570780000627304d+0*t144*t
     <         21*t63*t65-1.3739974473061137d+2*t141*t63*t65+9.570780000
     =         627304d+0*t144*t23*t65+1.3739974473061137d+2*t141*t142*t2
     >         1*t65+t21*t23*(-9.570780000627304d+0*t144*t21*t63*t64-1.3
     ?         739974473061137d+2*t141*t63*t64+9.570780000627304d+0*t144
     @         *t23*t64+1.3739974473061137d+2*t141*t142*t21*t64+t21*t23*
     1         (1.0634200000697003d+0*t21*t24*t265*t63-9.159982982040756
     2         d+1*t143*t24*t63-1.0634200000697003d+0*t23*t24*t265-6.575
     3         11364479516d+2*t21*t217*t24*t264+6.57511364479516d+2*t142
     4         *t24*t264+9.159982982040756d+1*t142*t143*t21*t24)-1.43561
     5         70000940957d+1*t145*t21*t62*t63+1.0634200000697003d+0*t21
     6         *t25*t265*t63-9.159982982040756d+1*t143*t25*t63+1.4356170
     7         000940957d+1*t145*t23*t62-1.0634200000697003d+0*t23*t25*t
     8         265-6.57511364479516d+2*t21*t217*t25*t264+6.5751136447951
     9         6d+2*t142*t25*t264+9.159982982040756d+1*t142*t143*t21*t25
     :         )-1.4356170000940957d+1*t146*t21*t62*t63+1.06342000006970
     ;         03d+0*t21*t26*t265*t63-9.159982982040756d+1*t143*t26*t63+
     <         1.4356170000940957d+1*t146*t23*t62-1.0634200000697003d+0*
     =         t23*t26*t265-6.57511364479516d+2*t21*t217*t26*t264+6.5751
     >         1364479516d+2*t142*t26*t264+9.159982982040756d+1*t142*t14
     ?         3*t21*t26)-1.4356170000940957d+1*t147*t21*t62*t63+1.06342
     @         00000697003d+0*t21*t265*t27*t63-9.159982982040756d+1*t143
     1         *t27*t63+1.4356170000940957d+1*t147*t23*t62-1.06342000006
     2         97003d+0*t23*t265*t27-6.57511364479516d+2*t21*t217*t264*t
     3         27+6.57511364479516d+2*t142*t264*t27+9.159982982040756d+1
     4         *t142*t143*t21*t27)-1.4356170000940957d+1*t148*t21*t62*t6
     5         3+1.0634200000697003d+0*t21*t265*t28*t63-9.15998298204075
     6         6d+1*t143*t28*t63+1.4356170000940957d+1*t148*t23*t62-1.06
     7         34200000697003d+0*t23*t265*t28-6.57511364479516d+2*t21*t2
     8         17*t264*t28+6.57511364479516d+2*t142*t264*t28+9.159982982
     9         040756d+1*t142*t143*t21*t28)-1.4356170000940957d+1*t149*t
     :         21*t62*t63+1.0634200000697003d+0*t21*t265*t29*t63-9.15998
     ;         2982040756d+1*t143*t29*t63+1.4356170000940957d+1*t149*t23
     <         *t62-1.0634200000697003d+0*t23*t265*t29-6.57511364479516d
     =         +2*t21*t217*t264*t29+6.57511364479516d+2*t142*t264*t29+9.
     >         159982982040756d+1*t142*t143*t21*t29)-1.4356170000940957d
     ?         +1*t150*t21*t62*t63+1.0634200000697003d+0*t21*t265*t30*t6
     @         3-9.159982982040756d+1*t143*t30*t63+1.4356170000940957d+1
     1         *t150*t23*t62-1.0634200000697003d+0*t23*t265*t30-6.575113
     2         64479516d+2*t21*t217*t264*t30+6.57511364479516d+2*t142*t2
     3         64*t30+9.159982982040756d+1*t142*t143*t21*t30)-1.43561700
     4         00940957d+1*t151*t21*t62*t63+1.0634200000697003d+0*t21*t2
     5         65*t31*t63-9.159982982040756d+1*t143*t31*t63+1.4356170000
     6         940957d+1*t151*t23*t62-1.0634200000697003d+0*t23*t265*t31
     7         -6.57511364479516d+2*t21*t217*t264*t31+6.57511364479516d+
     8         2*t142*t264*t31+9.159982982040756d+1*t142*t143*t21*t31)-1
     9         .4356170000940957d+1*t152*t21*t62*t63+1.0634200000697003d
     :         +0*t21*t265*t32*t63-9.159982982040756d+1*t143*t32*t63+1.4
     ;         356170000940957d+1*t152*t23*t62-1.0634200000697003d+0*t23
     <         *t265*t32-6.57511364479516d+2*t21*t217*t264*t32+6.5751136
     =         4479516d+2*t142*t264*t32+9.159982982040756d+1*t142*t143*t
     >         21*t32)-1.4356170000940957d+1*t153*t21*t62*t63+1.06342000
     ?         00697003d+0*t21*t265*t33*t63-9.159982982040756d+1*t143*t3
     @         3*t63+1.4356170000940957d+1*t153*t23*t62-1.06342000006970
     1         03d+0*t23*t265*t33-6.57511364479516d+2*t21*t217*t264*t33+
     2         6.57511364479516d+2*t142*t264*t33+9.159982982040756d+1*t1
     3         42*t143*t21*t33)-1.4356170000940957d+1*t154*t21*t62*t63+1
     4         .0634200000697003d+0*t21*t265*t34*t63-9.159982982040756d+
     5         1*t143*t34*t63+1.4356170000940957d+1*t154*t23*t62-1.06342
     6         00000697003d+0*t23*t265*t34-6.57511364479516d+2*t21*t217*
     7         t264*t34+6.57511364479516d+2*t142*t264*t34+9.159982982040
     8         756d+1*t142*t143*t21*t34)+t186*(-3.1090690869654886d-2*rh
     9         oa*t113*t205*t61-1.5545345434827443d-2*t187*t61-t113*t206
     :         -1.5545345434827443d-2*rhoa*t100*t187)+3.1090690869654886
     ;         d-2*rhoa*t113**3*t275*t61+4.6636036304482326d-2*t185*t48+
     <         1.0d+0*rhoa*t274*t35+3.0d+0*t174*t35+3.0d+0*t155*t19)*wgh
     =         t+Amat3(iq,D3_RA_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*(t101*(1.5545345434827443d-2
     1         *rhoa*t61*(-2.1622114952063792d-1*gammaaa*t108*t37*t42*(-
     2         1.1227750021070412d+2*gammaaa*t102*t110*t111*t38*t89+2.54
     3         5364099445864d+0*gammaaa*t188*t201*t44-7.272468855559613d
     4         -2*gammaaa*t110*t189*t44-7.738478514913824d+2*gammaaa*t11
     5         1*t114*t190*t38+1.2029732165432584d+1*gammaaa*t111*t114*t
     6         174*t38+t302+t301+t300+t299+t298+t297+2.3215435544741472d
     7         +3*gammaaa*t114*t190*t191*t200)-8.408600259135923d-2*t103
     8         *t189*t42*t46+1.765806054418543d+0*t114*t188*t42*t46+3.81
     9         8046149168795d-1*gammaaa*t188*t201*t40*t46-1.818117213889
     :         9032d-2*gammaaa*t110*t189*t40*t46+2.1622114952063792d-1*g
     ;         ammaaa*(t302+t301+t300+t299+t298+t297)*t37*t46+2.16221149
     <         52063792d-1*t199*t37*t46-1.0090320310963104d+0*gammaaa*t1
     =         02*t103*t209*t46-1.0090320310963104d+0*t102*t103*t107*t46
     >         -1.2973268971238278d+0*gammaaa*t115*t204*t296*t37*t42+8.6
     ?         48845980825517d-1*gammaaa*t112*t203*t210*t37*t42+4.324422
     @         9904127585d-1*t203*t204*t37*t42+4.3244229904127585d-1*gam
     1         maaa*t115*t202*t203*t37*t42-2.1622114952063792d-1*t108*t2
     2         02*t37*t42+1.0090320310963104d+0*gammaaa*t102*t103*t108*t
     3         210*t42-2.0180640621926207d+0*gammaaa*t102*t103*t112*t115
     4         *t203*t42+8.408600259135923d-2*gammaaa*t103*t108*t115*t18
     5         9*t42-1.765806054418543d+0*gammaaa*t108*t114*t115*t188*t4
     6         2+1.0090320310963104d+0*t102*t103*t108*t112*t42+9.3503171
     7         00005212d-2*gammaaa*t114*t203*t204*t40-4.675158550002606d
     8         -2*gammaaa*t108*t114*t202*t40+2.181740656667883d-1*gammaa
     9         a*t102*t108*t110*t112*t40-4.3244229904127585d-1*gammaaa*t
     :         107*t108*t210*t37-4.3244229904127585d-1*gammaaa*t108*t112
     ;         *t209*t37+8.648845980825517d-1*gammaaa*t107*t112*t115*t20
     <         3*t37-2.1622114952063792d-1*gammaaa*t108*t115*t199*t37-4.
     =         3244229904127585d-1*t107*t108*t112*t37+1.0090320310963104
     >         d+0*gammaaa*t102*t103*t107*t108*t115)+3.1090690869654886d
     ?         -2*t211*t61+3.1090690869654886d-2*rhoa*t100*t211+1.554534
     @         5434827443d-2*rhoa*t116*t185+3.1090690869654886d-2*t100*t
     1         116)+t186*(-3.1090690869654886d-2*rhoa*t113*t211*t61-t116
     2         *t206)+3.1090690869654886d-2*rhoa*t116*t187*t275*t61)*wgh
     3         t+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*(t101*(1.5545345434827443d-
     1         2*rhoa*t61*(-2.1622114952063792d-1*gammaaa*t108*t37*t42*(
     2         1.2029732165432584d+1*t111*t114*t38*t89-4.363481313335766
     3         d-1*t102*t110*t44)-2.181740656667883d-1*t102*t110*t40*t46
     4         +4.3244229904127585d-1*t209*t37*t46+4.7173847274064107d-2
     5         *gammaaa*t102*t108*t295*t42*t44+4.0434726234912094d-2*gam
     6         maaa*t112*t201*t203*t42*t44-2.0217363117456047d-2*gammaaa
     7         *t107*t108*t201*t44-1.2973268971238278d+0*gammaaa*t112*t2
     8         14*t296*t37*t42+8.648845980825517d-1*gammaaa*t115*t203*t2
     9         10*t37*t42-4.3244229904127585d-1*t108*t210*t37*t42+8.6488
     :         45980825517d-1*t112*t115*t203*t37*t42-1.0090320310963104d
     ;         +0*gammaaa*t102*t103*t203*t214*t42+1.0090320310963104d+0*
     <         t102*t103*t108*t115*t42-9.350317100005212d-2*gammaaa*t108
     =         *t114*t210*t40+1.8700634200010424d-1*gammaaa*t112*t114*t1
     >         15*t203*t40+2.181740656667883d-1*gammaaa*t102*t108*t110*t
     ?         115*t40-9.350317100005212d-2*t108*t112*t114*t40+4.3244229
     @         904127585d-1*gammaaa*t107*t203*t214*t37-4.324422990412758
     1         5d-1*gammaaa*t108*t115*t209*t37-4.3244229904127585d-1*t10
     2         7*t108*t115*t37)+1.5545345434827443d-2*t215*t61+1.5545345
     3         434827443d-2*rhoa*t100*t215)+t186*(-1.5545345434827443d-2
     4         *rhoa*t113*t215*t61-1.5545345434827443d-2*rhoa*t116*t211*
     5         t61-t116*t212)+3.1090690869654886d-2*rhoa*t113*t213*t275*
     6         t61)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.5545345434827443d-2*rhoa*t101*(
     1         1.2130417870473628d-1*gammaaa*t115*t201*t203*t42*t44-6.06
     2         5208935236814d-2*t108*t201*t42*t44-1.2973268971238278d+0*
     3         gammaaa*t115**3*t296*t37*t42+1.2973268971238278d+0*t203*t
     4         214*t37*t42+2.8050951300015636d-1*gammaaa*t114*t203*t214*
     5         t40-2.8050951300015636d-1*t108*t114*t115*t40-1.3114264480
     6         597482d-2*gammaaa*t108*t111/t36**8.0d+0)*t61*wght+3.10906
     7         90869654886d-2*rhoa*t116**3*t275*t61*wght-4.6636036304482
     8         326d-2*rhoa*t116*t186*t215*t61*wght+Cmat3(iq,D3_GAA_GAA_G
     9         AA)
            Mmat3(iq,D3_RA_RA_TA) = t304+Mmat3(iq,D3_RA_RA_TA)
            Mmat3(iq,D3_RA_RA_TB) = t304+Mmat3(iq,D3_RA_RA_TB)
            Mmat3(iq,D3_RA_GAA_TA) = t305+Mmat3(iq,D3_RA_GAA_TA)
            Mmat3(iq,D3_RA_GAA_TB) = t305+Mmat3(iq,D3_RA_GAA_TB)
            Mmat3(iq,D3_GAA_GAA_TA) = t306+Mmat3(iq,D3_GAA_GAA_TA)
            Mmat3(iq,D3_GAA_GAA_TB) = t306+Mmat3(iq,D3_GAA_GAA_TB)
            Mmat3(iq,D3_RA_TA_TA) = t307+Mmat3(iq,D3_RA_TA_TA)
            Mmat3(iq,D3_RA_TA_TB) = t307+Mmat3(iq,D3_RA_TA_TB)
            Mmat3(iq,D3_RA_TB_TB) = t307+Mmat3(iq,D3_RA_TB_TB)
            Mmat3(iq,D3_GAA_TA_TA) = t308+Mmat3(iq,D3_GAA_TA_TA)
            Mmat3(iq,D3_GAA_TA_TB) = t308+Mmat3(iq,D3_GAA_TA_TB)
            Mmat3(iq,D3_GAA_TB_TB) = t308+Mmat3(iq,D3_GAA_TB_TB)
            Mmat3(iq,D3_TA_TA_TA) = t309+Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = t309+Mmat3(iq,D3_TA_TA_TB)
            Mmat3(iq,D3_TA_TB_TB) = t309+Mmat3(iq,D3_TA_TB_TB)
            Mmat3(iq,D3_TB_TB_TB) = t309+Mmat3(iq,D3_TB_TB_TB)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 9.999999999999991d-1*(6.21814d-2*t17*t18-3.10907d-2*t1
     1         1*t9)-6.21814d-2*t17*t18
            t20 = 2.871234000188191d+0*rhob**1.6666666666666669d+0
            t21 = -taub-taua+t20
            t22 = taub+taua+t20
            t23 = 1/t22
            t24 = param(12)
            t25 = t21*t23*t24+param(11)
            t26 = t21*t23*t25+param(10)
            t27 = t21*t23*t26+param(9)
            t28 = t21*t23*t27+param(8)
            t29 = t21*t23*t28+param(7)
            t30 = t21*t23*t29+param(6)
            t31 = t21*t23*t30+param(5)
            t32 = t21*t23*t31+param(4)
            t33 = t21*t23*t32+param(3)
            t34 = t21*t23*t33+param(2)
            t35 = t21*t23*t34+param(1)
            t36 = rhob**1.1666666666666667d+0
            t37 = 1/t36**2.0d+0
            t38 = exp(-6.432793688582967d+1*t19)
            t39 = t38-1.0d+0
            t40 = 1/t39
            t41 = 2.1622114952063792d-1*gammabb*t37*t40
            t42 = t41+1.0d+0
            t43 = (gammabb*t37)**2.0d+0
            t44 = 1/t39**2.0d+0
            t45 = 4.675158550002606d-2*t43*t44+t41+1.0d+0
            t46 = 1/t45
            t47 = 2.1622114952063792d-1*gammabb*t37*t42*t46+1.0d+0
            t48 = log(t47)
            t49 = param(14)
            t50 = param(24)
            t51 = t21*t23*t50+param(23)
            t52 = t21*t23*t51+param(22)
            t53 = t21*t23*t52+param(21)
            t54 = t21*t23*t53+param(20)
            t55 = t21*t23*t54+param(19)
            t56 = t21*t23*t55+param(18)
            t57 = t21*t23*t56+param(17)
            t58 = t21*t23*t57+param(16)
            t59 = t21*t23*t58+param(15)
            t60 = t21*t23*t59+t49
            t61 = t21*t23*t60+param(13)
            t62 = rhob**6.666666666666666d-1
            t63 = 1/t22**2
            t64 = 4.785390000313652d+0*t23*t24*t62-4.785390000313652d+0*
     1         t21*t24*t62*t63
            t65 = t21*t23*t64-4.785390000313652d+0*t21*t25*t62*t63+4.785
     1         390000313652d+0*t23*t25*t62
            t66 = t21*t23*t65-4.785390000313652d+0*t21*t26*t62*t63+4.785
     1         390000313652d+0*t23*t26*t62
            t67 = t21*t23*t66-4.785390000313652d+0*t21*t27*t62*t63+4.785
     1         390000313652d+0*t23*t27*t62
            t68 = t21*t23*t67-4.785390000313652d+0*t21*t28*t62*t63+4.785
     1         390000313652d+0*t23*t28*t62
            t69 = t21*t23*t68-4.785390000313652d+0*t21*t29*t62*t63+4.785
     1         390000313652d+0*t23*t29*t62
            t70 = t21*t23*t69-4.785390000313652d+0*t21*t30*t62*t63+4.785
     1         390000313652d+0*t23*t30*t62
            t71 = t21*t23*t70-4.785390000313652d+0*t21*t31*t62*t63+4.785
     1         390000313652d+0*t23*t31*t62
            t72 = t21*t23*t71-4.785390000313652d+0*t21*t32*t62*t63+4.785
     1         390000313652d+0*t23*t32*t62
            t73 = t21*t23*t72-4.785390000313652d+0*t21*t33*t62*t63+4.785
     1         390000313652d+0*t23*t33*t62
            t74 = t21*t23*t73-4.785390000313652d+0*t21*t34*t62*t63+4.785
     1         390000313652d+0*t23*t34*t62
            t75 = 1/rhob**1.3333333333333333d+0
            t76 = 1/t8
            t77 = 1/t6**2
            t78 = 1/rhob**1.3333333333333336d+0
            t79 = 1/t2**3
            t80 = 1/rhob**6.666666666666667d-1
            t81 = -1.3127055298329054d-1*t4*t79*t80-2.0096226153166658d-
     1         3*t78
            t82 = 7.876233178997433d-1*t3*t81-1.3127055298329054d-1*t5*t
     1         79*t80
            t83 = 2.11607075208357d-1*t3*t7*t80-1.269642451250142d+0*t2*
     1         t77*t82
            t84 = 1/t16
            t85 = 1/t14**2
            t86 = -1.3127055298329054d-1*t12*t79*t80-3.169132786263567d-
     1         3*t78
            t87 = 7.876233178997433d-1*t3*t86-1.3127055298329054d-1*t13*
     1         t79*t80
            t88 = 2.11607075208357d-1*t15*t3*t80-1.269642451250142d+0*t2
     1         *t85*t87
            t89 = 9.999999999999991d-1*(1.3210398931339265d-3*t75*t9+6.2
     1         1814d-2*t18*t84*t88-3.10907d-2*t11*t76*t83-2.747773264188
     2         438d-3*t17*t75)-6.21814d-2*t18*t84*t88+2.747773264188438d
     3         -3*t17*t75
            t90 = 4.785390000313652d+0*t23*t50*t62-4.785390000313652d+0*
     1         t21*t50*t62*t63
            t91 = t21*t23*t90-4.785390000313652d+0*t21*t51*t62*t63+4.785
     1         390000313652d+0*t23*t51*t62
            t92 = t21*t23*t91-4.785390000313652d+0*t21*t52*t62*t63+4.785
     1         390000313652d+0*t23*t52*t62
            t93 = t21*t23*t92-4.785390000313652d+0*t21*t53*t62*t63+4.785
     1         390000313652d+0*t23*t53*t62
            t94 = t21*t23*t93-4.785390000313652d+0*t21*t54*t62*t63+4.785
     1         390000313652d+0*t23*t54*t62
            t95 = t21*t23*t94-4.785390000313652d+0*t21*t55*t62*t63+4.785
     1         390000313652d+0*t23*t55*t62
            t96 = t21*t23*t95-4.785390000313652d+0*t21*t56*t62*t63+4.785
     1         390000313652d+0*t23*t56*t62
            t97 = t21*t23*t96-4.785390000313652d+0*t21*t57*t62*t63+4.785
     1         390000313652d+0*t23*t57*t62
            t98 = t21*t23*t97-4.785390000313652d+0*t21*t58*t62*t63+4.785
     1         390000313652d+0*t23*t58*t62
            t99 = t21*t23*t98-4.785390000313652d+0*t21*t59*t62*t63+4.785
     1         390000313652d+0*t23*t59*t62
            t100 = t21*t23*t99-4.785390000313652d+0*t21*t60*t62*t63+4.78
     1         5390000313652d+0*t23*t60*t62
            t101 = 1/t47
            t102 = rhob**1.6666666666666674d-1
            t103 = 1/t36**3.0d+0
            t104 = -5.045160155481552d-1*gammabb*t102*t103*t40
            t105 = 1/t39**2
            t106 = 1.3909060459745137d+1*gammabb*t105*t37*t38*t89
            t107 = t106+t104
            t108 = 1/t45**2
            t109 = gammabb**2
            t110 = 1/t36**5.0d+0
            t111 = 1/t39**3.0d+0
            t112 = 6.014866082716293d+0*t111*t38*t43*t89-2.1817406566678
     1         83d-1*t102*t109*t110*t44+t106+t104
            t113 = -5.045160155481552d-1*gammabb*t102*t103*t42*t46+2.162
     1         2114952063792d-1*gammabb*t107*t37*t46-2.1622114952063792d
     2         -1*gammabb*t108*t112*t37*t42
            t114 = 1/t36**4.0d+0
            t115 = 9.350317100005212d-2*gammabb*t114*t44+2.1622114952063
     1         792d-1*t37*t40
            t116 = 2.1622114952063792d-1*t37*t42*t46+4.675158550002606d-
     1         2*gammabb*t114*t40*t46-2.1622114952063792d-1*gammabb*t108
     2         *t115*t37*t42
            t117 = -t21*t24*t63-t23*t24
            t118 = -t21*t25*t63-t23*t25+t117*t21*t23
            t119 = -t21*t26*t63-t23*t26+t118*t21*t23
            t120 = -t21*t27*t63-t23*t27+t119*t21*t23
            t121 = -t21*t28*t63-t23*t28+t120*t21*t23
            t122 = -t21*t29*t63-t23*t29+t121*t21*t23
            t123 = -t21*t30*t63-t23*t30+t122*t21*t23
            t124 = -t21*t31*t63-t23*t31+t123*t21*t23
            t125 = -t21*t32*t63-t23*t32+t124*t21*t23
            t126 = -t21*t33*t63-t23*t33+t125*t21*t23
            t127 = -t21*t34*t63-t23*t34+t126*t21*t23
            t128 = -t21*t50*t63-t23*t50
            t129 = -t21*t51*t63-t23*t51+t128*t21*t23
            t130 = -t21*t52*t63-t23*t52+t129*t21*t23
            t131 = -t21*t53*t63-t23*t53+t130*t21*t23
            t132 = -t21*t54*t63-t23*t54+t131*t21*t23
            t133 = -t21*t55*t63-t23*t55+t132*t21*t23
            t134 = -t21*t56*t63-t23*t56+t133*t21*t23
            t135 = -t21*t57*t63-t23*t57+t134*t21*t23
            t136 = -t21*t58*t63-t23*t58+t135*t21*t23
            t137 = -t21*t59*t63-t23*t59+t136*t21*t23
            t138 = -t21*t60*t63
            t139 = -t23*t60+t137*t21*t23+t138
            t140 = 1.0d+0*(1.5545345434827443d-2*rhob*t139*t48+1.0d+0*rh
     1         ob*t127*t19)*wght
            t141 = rhob**1.3333333333333333d+0
            t142 = 1/t22**3
            t143 = rhob**3.333333333333333d-1
            t144 = 1/t143
            t145 = -3.190260000209101d+0*t144*t21*t24*t63-4.579991491020
     1         378d+1*t141*t24*t63+3.190260000209101d+0*t144*t23*t24+4.5
     2         79991491020378d+1*t141*t142*t21*t24
            t146 = -9.570780000627304d+0*t21*t62*t63*t64+9.5707800006273
     1         04d+0*t23*t62*t64-3.190260000209101d+0*t144*t21*t25*t63-4
     2         .579991491020378d+1*t141*t25*t63+3.190260000209101d+0*t14
     3         4*t23*t25+4.579991491020378d+1*t141*t142*t21*t25+t145*t21
     4         *t23
            t147 = -9.570780000627304d+0*t21*t62*t63*t65+9.5707800006273
     1         04d+0*t23*t62*t65-3.190260000209101d+0*t144*t21*t26*t63-4
     2         .579991491020378d+1*t141*t26*t63+3.190260000209101d+0*t14
     3         4*t23*t26+4.579991491020378d+1*t141*t142*t21*t26+t146*t21
     4         *t23
            t148 = -9.570780000627304d+0*t21*t62*t63*t66+9.5707800006273
     1         04d+0*t23*t62*t66-3.190260000209101d+0*t144*t21*t27*t63-4
     2         .579991491020378d+1*t141*t27*t63+3.190260000209101d+0*t14
     3         4*t23*t27+4.579991491020378d+1*t141*t142*t21*t27+t147*t21
     4         *t23
            t149 = -9.570780000627304d+0*t21*t62*t63*t67+9.5707800006273
     1         04d+0*t23*t62*t67-3.190260000209101d+0*t144*t21*t28*t63-4
     2         .579991491020378d+1*t141*t28*t63+3.190260000209101d+0*t14
     3         4*t23*t28+4.579991491020378d+1*t141*t142*t21*t28+t148*t21
     4         *t23
            t150 = -9.570780000627304d+0*t21*t62*t63*t68+9.5707800006273
     1         04d+0*t23*t62*t68-3.190260000209101d+0*t144*t21*t29*t63-4
     2         .579991491020378d+1*t141*t29*t63+3.190260000209101d+0*t14
     3         4*t23*t29+4.579991491020378d+1*t141*t142*t21*t29+t149*t21
     4         *t23
            t151 = -9.570780000627304d+0*t21*t62*t63*t69+9.5707800006273
     1         04d+0*t23*t62*t69-3.190260000209101d+0*t144*t21*t30*t63-4
     2         .579991491020378d+1*t141*t30*t63+3.190260000209101d+0*t14
     3         4*t23*t30+4.579991491020378d+1*t141*t142*t21*t30+t150*t21
     4         *t23
            t152 = -9.570780000627304d+0*t21*t62*t63*t70+9.5707800006273
     1         04d+0*t23*t62*t70-3.190260000209101d+0*t144*t21*t31*t63-4
     2         .579991491020378d+1*t141*t31*t63+3.190260000209101d+0*t14
     3         4*t23*t31+4.579991491020378d+1*t141*t142*t21*t31+t151*t21
     4         *t23
            t153 = -9.570780000627304d+0*t21*t62*t63*t71+9.5707800006273
     1         04d+0*t23*t62*t71-3.190260000209101d+0*t144*t21*t32*t63-4
     2         .579991491020378d+1*t141*t32*t63+3.190260000209101d+0*t14
     3         4*t23*t32+4.579991491020378d+1*t141*t142*t21*t32+t152*t21
     4         *t23
            t154 = -9.570780000627304d+0*t21*t62*t63*t72+9.5707800006273
     1         04d+0*t23*t62*t72-3.190260000209101d+0*t144*t21*t33*t63-4
     2         .579991491020378d+1*t141*t33*t63+3.190260000209101d+0*t14
     3         4*t23*t33+4.579991491020378d+1*t141*t142*t21*t33+t153*t21
     4         *t23
            t155 = -9.570780000627304d+0*t21*t62*t63*t73+9.5707800006273
     1         04d+0*t23*t62*t73-3.190260000209101d+0*t144*t21*t34*t63-4
     2         .579991491020378d+1*t141*t34*t63+3.190260000209101d+0*t14
     3         4*t23*t34+4.579991491020378d+1*t141*t142*t21*t34+t154*t21
     4         *t23
            t156 = 1/rhob**2.333333333333333d+0
            t157 = 1/t8**2
            t158 = t83**2
            t159 = 1/t6**3
            t160 = t82**2
            t161 = 1/rhob**2.3333333333333334d+0
            t162 = 1/rhob**1.6666666666666669d+0
            t163 = 1/t2**5
            t164 = 8.751370198886037d-2*t162*t4*t79+6.563527649164527d-2
     1         *t163*t4*t78+3.0144339229749983d-3*t161
            t165 = -2.625411059665811d-1*t79*t80*t81+8.751370198886037d-
     1         2*t162*t5*t79+6.563527649164527d-2*t163*t5*t78+7.87623317
     2         8997433d-1*t164*t3
            t166 = -4.23214150416714d-1*t3*t77*t80*t82-3.52678458680595d
     1         -2*t7*t78*t79-1.269642451250142d+0*t165*t2*t77-1.41071383
     2         47223802d-1*t162*t3*t7+2.539284902500284d+0*t159*t160*t2
            t167 = 1/t16**2
            t168 = t88**2
            t169 = 1/t14**3
            t170 = t87**2
            t171 = 8.751370198886037d-2*t12*t162*t79+6.563527649164527d-
     1         2*t12*t163*t78+4.753699179395351d-3*t161
            t172 = -2.625411059665811d-1*t79*t80*t86+8.751370198886037d-
     1         2*t13*t162*t79+6.563527649164527d-2*t13*t163*t78+7.876233
     2         178997433d-1*t171*t3
            t173 = -4.23214150416714d-1*t3*t80*t85*t87-1.269642451250142
     1         d+0*t172*t2*t85-3.52678458680595d-2*t15*t78*t79-1.4107138
     2         347223802d-1*t15*t162*t3+2.539284902500284d+0*t169*t170*t
     3         2
            t174 = 9.999999999999991d-1*(-1.7613865241785687d-3*t156*t9-
     1         5.495546528376876d-3*t75*t84*t88+6.21814d-2*t173*t18*t84+
     2         2.642079786267853d-3*t75*t76*t83-3.10907d-2*t11*t166*t76-
     3         6.21814d-2*t167*t168*t18+3.663697685584584d-3*t156*t17+3.
     4         10907d-2*t11*t157*t158)+5.495546528376876d-3*t75*t84*t88-
     5         6.21814d-2*t173*t18*t84+6.21814d-2*t167*t168*t18-3.663697
     6         685584584d-3*t156*t17
            t175 = -3.190260000209101d+0*t144*t21*t50*t63-4.579991491020
     1         378d+1*t141*t50*t63+3.190260000209101d+0*t144*t23*t50+4.5
     2         79991491020378d+1*t141*t142*t21*t50
            t176 = -9.570780000627304d+0*t21*t62*t63*t90+9.5707800006273
     1         04d+0*t23*t62*t90-3.190260000209101d+0*t144*t21*t51*t63-4
     2         .579991491020378d+1*t141*t51*t63+3.190260000209101d+0*t14
     3         4*t23*t51+4.579991491020378d+1*t141*t142*t21*t51+t175*t21
     4         *t23
            t177 = -9.570780000627304d+0*t21*t62*t63*t91+9.5707800006273
     1         04d+0*t23*t62*t91-3.190260000209101d+0*t144*t21*t52*t63-4
     2         .579991491020378d+1*t141*t52*t63+3.190260000209101d+0*t14
     3         4*t23*t52+4.579991491020378d+1*t141*t142*t21*t52+t176*t21
     4         *t23
            t178 = -9.570780000627304d+0*t21*t62*t63*t92+9.5707800006273
     1         04d+0*t23*t62*t92-3.190260000209101d+0*t144*t21*t53*t63-4
     2         .579991491020378d+1*t141*t53*t63+3.190260000209101d+0*t14
     3         4*t23*t53+4.579991491020378d+1*t141*t142*t21*t53+t177*t21
     4         *t23
            t179 = -9.570780000627304d+0*t21*t62*t63*t93+9.5707800006273
     1         04d+0*t23*t62*t93-3.190260000209101d+0*t144*t21*t54*t63-4
     2         .579991491020378d+1*t141*t54*t63+3.190260000209101d+0*t14
     3         4*t23*t54+4.579991491020378d+1*t141*t142*t21*t54+t178*t21
     4         *t23
            t180 = -9.570780000627304d+0*t21*t62*t63*t94+9.5707800006273
     1         04d+0*t23*t62*t94-3.190260000209101d+0*t144*t21*t55*t63-4
     2         .579991491020378d+1*t141*t55*t63+3.190260000209101d+0*t14
     3         4*t23*t55+4.579991491020378d+1*t141*t142*t21*t55+t179*t21
     4         *t23
            t181 = -9.570780000627304d+0*t21*t62*t63*t95+9.5707800006273
     1         04d+0*t23*t62*t95-3.190260000209101d+0*t144*t21*t56*t63-4
     2         .579991491020378d+1*t141*t56*t63+3.190260000209101d+0*t14
     3         4*t23*t56+4.579991491020378d+1*t141*t142*t21*t56+t180*t21
     4         *t23
            t182 = -9.570780000627304d+0*t21*t62*t63*t96+9.5707800006273
     1         04d+0*t23*t62*t96-3.190260000209101d+0*t144*t21*t57*t63-4
     2         .579991491020378d+1*t141*t57*t63+3.190260000209101d+0*t14
     3         4*t23*t57+4.579991491020378d+1*t141*t142*t21*t57+t181*t21
     4         *t23
            t183 = -9.570780000627304d+0*t21*t62*t63*t97+9.5707800006273
     1         04d+0*t23*t62*t97-3.190260000209101d+0*t144*t21*t58*t63-4
     2         .579991491020378d+1*t141*t58*t63+3.190260000209101d+0*t14
     3         4*t23*t58+4.579991491020378d+1*t141*t142*t21*t58+t182*t21
     4         *t23
            t184 = -9.570780000627304d+0*t21*t62*t63*t98+9.5707800006273
     1         04d+0*t23*t62*t98-3.190260000209101d+0*t144*t21*t59*t63-4
     2         .579991491020378d+1*t141*t59*t63+3.190260000209101d+0*t14
     3         4*t23*t59+4.579991491020378d+1*t141*t142*t21*t59+t183*t21
     4         *t23
            t185 = -9.570780000627304d+0*t21*t62*t63*t99+9.5707800006273
     1         04d+0*t23*t62*t99-3.190260000209101d+0*t144*t21*t60*t63-4
     2         .579991491020378d+1*t141*t60*t63+3.190260000209101d+0*t14
     3         4*t23*t60+4.579991491020378d+1*t141*t142*t21*t60+t184*t21
     4         *t23
            t186 = 1/t47**2
            t187 = t113**2
            t188 = rhob**3.333333333333335d-1
            t189 = 1/rhob**8.333333333333333d-1
            t190 = t89**2
            t191 = exp(-1.2865587377165935d+2*t19)
            t192 = 1/t39**3
            t193 = 1.7894823267913484d+3*gammabb*t190*t191*t192*t37
            t194 = 1.765806054418543d+0*gammabb*t114*t188*t40
            t195 = -8.408600259135923d-2*gammabb*t103*t189*t40
            t196 = -6.490894881214397d+1*gammabb*t102*t103*t105*t38*t89
            t197 = -8.947411633956742d+2*gammabb*t105*t190*t37*t38
            t198 = 1.3909060459745137d+1*gammabb*t105*t174*t37*t38
            t199 = t198+t197+t196+t195+t194+t193
            t200 = 1/t39**4.0d+0
            t201 = 1/t36**6.0d+0
            t202 = -5.613875010535206d+1*t102*t109*t110*t111*t38*t89+1.2
     1         72682049722932d+0*t109*t188*t201*t44-3.6362344277798064d-
     2         2*t109*t110*t189*t44-3.869239257456912d+2*t111*t190*t38*t
     3         43+6.014866082716293d+0*t111*t174*t38*t43+1.1607717772370
     4         736d+3*t190*t191*t200*t43+t198+t197+t196+t195+t194+t193
            t203 = 1/t45**3
            t204 = t112**2
            t205 = -8.408600259135923d-2*gammabb*t103*t189*t42*t46+1.765
     1         806054418543d+0*gammabb*t114*t188*t42*t46+2.1622114952063
     2         792d-1*gammabb*t199*t37*t46-1.0090320310963104d+0*gammabb
     3         *t102*t103*t107*t46+4.3244229904127585d-1*gammabb*t203*t2
     4         04*t37*t42-2.1622114952063792d-1*gammabb*t108*t202*t37*t4
     5         2+1.0090320310963104d+0*gammabb*t102*t103*t108*t112*t42-4
     6         .3244229904127585d-1*gammabb*t107*t108*t112*t37
            t206 = 1.5545345434827443d-2*rhob*t205*t61+3.109069086965488
     1         6d-2*t113*t61+3.1090690869654886d-2*rhob*t100*t113
            t207 = -5.045160155481552d-1*t102*t103*t40
            t208 = 1.3909060459745137d+1*t105*t37*t38*t89
            t209 = t208+t207
            t210 = 1.2029732165432584d+1*gammabb*t111*t114*t38*t89-4.363
     1         481313335766d-1*gammabb*t102*t110*t44+t208+t207
            t211 = -5.045160155481552d-1*t102*t103*t42*t46-1.09087032833
     1         39415d-1*gammabb*t102*t110*t40*t46+2.1622114952063792d-1*
     2         gammabb*t209*t37*t46+2.1622114952063792d-1*t107*t37*t46-2
     3         .1622114952063792d-1*gammabb*t108*t210*t37*t42+4.32442299
     4         04127585d-1*gammabb*t112*t115*t203*t37*t42-2.162211495206
     5         3792d-1*t108*t112*t37*t42+5.045160155481552d-1*gammabb*t1
     6         02*t103*t108*t115*t42-4.675158550002606d-2*gammabb*t108*t
     7         112*t114*t40-2.1622114952063792d-1*gammabb*t107*t108*t115
     8         *t37
            t212 = 1.5545345434827443d-2*rhob*t211*t61+1.554534543482744
     1         3d-2*t116*t61+1.5545345434827443d-2*rhob*t100*t116
            t213 = t116**2
            t214 = t115**2
            t215 = 9.350317100005212d-2*t114*t40*t46-2.0217363117456047d
     1         -2*gammabb*t108*t201*t42*t44+4.3244229904127585d-1*gammab
     2         b*t203*t214*t37*t42-4.3244229904127585d-1*t108*t115*t37*t
     3         42-9.350317100005212d-2*gammabb*t108*t114*t115*t40
            t216 = t21**2
            t217 = 1/t22**4
            t218 = -t21*t63*t64-t23*t64-4.785390000313652d+0*t117*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t25*t62+9.57078000062
     2         7304d+0*t216*t217*t24*t62+4.785390000313652d+0*t117*t23*t
     3         62
            t219 = -t21*t63*t65-t23*t65-4.785390000313652d+0*t118*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t26*t62+4.78539000031
     2         3652d+0*t118*t23*t62+t21*t218*t23
            t220 = -t21*t63*t66-t23*t66-4.785390000313652d+0*t119*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t27*t62+4.78539000031
     2         3652d+0*t119*t23*t62+t21*t219*t23
            t221 = -t21*t63*t67-t23*t67-4.785390000313652d+0*t120*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t28*t62+4.78539000031
     2         3652d+0*t120*t23*t62+t21*t220*t23
            t222 = -t21*t63*t68-t23*t68-4.785390000313652d+0*t121*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t29*t62+4.78539000031
     2         3652d+0*t121*t23*t62+t21*t221*t23
            t223 = -t21*t63*t69-t23*t69-4.785390000313652d+0*t122*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t30*t62+4.78539000031
     2         3652d+0*t122*t23*t62+t21*t222*t23
            t224 = -t21*t63*t70-t23*t70-4.785390000313652d+0*t123*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t31*t62+4.78539000031
     2         3652d+0*t123*t23*t62+t21*t223*t23
            t225 = -t21*t63*t71-t23*t71-4.785390000313652d+0*t124*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t32*t62+4.78539000031
     2         3652d+0*t124*t23*t62+t21*t224*t23
            t226 = -t21*t63*t72-t23*t72-4.785390000313652d+0*t125*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t33*t62+4.78539000031
     2         3652d+0*t125*t23*t62+t21*t225*t23
            t227 = -t21*t63*t73-t23*t73-4.785390000313652d+0*t126*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t34*t62+4.78539000031
     2         3652d+0*t126*t23*t62+t21*t226*t23
            t228 = -t21*t63*t90-t23*t90-4.785390000313652d+0*t128*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t51*t62+9.57078000062
     2         7304d+0*t216*t217*t50*t62+4.785390000313652d+0*t128*t23*t
     3         62
            t229 = -t21*t63*t91-t23*t91-4.785390000313652d+0*t129*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t52*t62+4.78539000031
     2         3652d+0*t129*t23*t62+t21*t228*t23
            t230 = -t21*t63*t92-t23*t92-4.785390000313652d+0*t130*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t53*t62+4.78539000031
     2         3652d+0*t130*t23*t62+t21*t229*t23
            t231 = -t21*t63*t93-t23*t93-4.785390000313652d+0*t131*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t54*t62+4.78539000031
     2         3652d+0*t131*t23*t62+t21*t23*t230
            t232 = -t21*t63*t94-t23*t94-4.785390000313652d+0*t132*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t55*t62+4.78539000031
     2         3652d+0*t132*t23*t62+t21*t23*t231
            t233 = -t21*t63*t95-t23*t95-4.785390000313652d+0*t133*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t56*t62+4.78539000031
     2         3652d+0*t133*t23*t62+t21*t23*t232
            t234 = -t21*t63*t96-t23*t96-4.785390000313652d+0*t134*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t57*t62+4.78539000031
     2         3652d+0*t134*t23*t62+t21*t23*t233
            t235 = -t21*t63*t97-t23*t97-4.785390000313652d+0*t135*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t58*t62+4.78539000031
     2         3652d+0*t135*t23*t62+t21*t23*t234
            t236 = -t21*t63*t98-t23*t98-4.785390000313652d+0*t136*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t59*t62+4.78539000031
     2         3652d+0*t136*t23*t62+t21*t23*t235
            t237 = -t21*t63*t99-t23*t99-4.785390000313652d+0*t137*t21*t6
     1         2*t63+9.570780000627304d+0*t142*t21*t60*t62+4.78539000031
     2         3652d+0*t137*t23*t62+t21*t23*t236
            t238 = 1.0d+0*(1.0d+0*rhob*t127*t89+1.5545345434827443d-2*rh
     1         ob*t237*t48+1.5545345434827443d-2*t139*t48+1.0d+0*rhob*t1
     2         9*t227+1.0d+0*t127*t19+1.5545345434827443d-2*rhob*t101*t1
     3         13*t139)*wght
            t239 = 1.5545345434827443d-2*rhob*t101*t116*(t23*(-t21*t23*t
     1         59-t49+t137*t21)+t138)*wght
            t240 = 2*t24*t63+2*t142*t21*t24
            t241 = 2*t25*t63-2*t117*t21*t63+2*t142*t21*t25+t21*t23*t240-
     1         2*t117*t23
            t242 = 2*t26*t63-2*t118*t21*t63+2*t142*t21*t26+t21*t23*t241-
     1         2*t118*t23
            t243 = 2*t27*t63-2*t119*t21*t63+2*t142*t21*t27+t21*t23*t242-
     1         2*t119*t23
            t244 = 2*t28*t63-2*t120*t21*t63+2*t142*t21*t28+t21*t23*t243-
     1         2*t120*t23
            t245 = 2*t29*t63-2*t121*t21*t63+2*t142*t21*t29+t21*t23*t244-
     1         2*t121*t23
            t246 = 2*t30*t63-2*t122*t21*t63+2*t142*t21*t30+t21*t23*t245-
     1         2*t122*t23
            t247 = 2*t31*t63-2*t123*t21*t63+2*t142*t21*t31+t21*t23*t246-
     1         2*t123*t23
            t248 = 2*t32*t63-2*t124*t21*t63+2*t142*t21*t32+t21*t23*t247-
     1         2*t124*t23
            t249 = 2*t33*t63-2*t125*t21*t63+2*t142*t21*t33+t21*t23*t248-
     1         2*t125*t23
            t250 = 2*t34*t63-2*t126*t21*t63+2*t142*t21*t34+t21*t23*t249-
     1         2*t126*t23
            t251 = 2*t50*t63+2*t142*t21*t50
            t252 = 2*t51*t63-2*t128*t21*t63+2*t142*t21*t51+t21*t23*t251-
     1         2*t128*t23
            t253 = 2*t52*t63-2*t129*t21*t63+2*t142*t21*t52+t21*t23*t252-
     1         2*t129*t23
            t254 = 2*t53*t63-2*t130*t21*t63+2*t142*t21*t53+t21*t23*t253-
     1         2*t130*t23
            t255 = 2*t54*t63-2*t131*t21*t63+2*t142*t21*t54+t21*t23*t254-
     1         2*t131*t23
            t256 = 2*t55*t63-2*t132*t21*t63+2*t142*t21*t55+t21*t23*t255-
     1         2*t132*t23
            t257 = 2*t56*t63-2*t133*t21*t63+2*t142*t21*t56+t21*t23*t256-
     1         2*t133*t23
            t258 = 2*t57*t63-2*t134*t21*t63+2*t142*t21*t57+t21*t23*t257-
     1         2*t134*t23
            t259 = 2*t58*t63-2*t135*t21*t63+2*t142*t21*t58+t21*t23*t258-
     1         2*t135*t23
            t260 = 2*t59*t63-2*t136*t21*t63+2*t142*t21*t59+t21*t23*t259-
     1         2*t136*t23
            t261 = 2*t142*t21*t60
            t262 = 2*t60*t63-2*t137*t21*t63+t261+t21*t23*t260-2*t137*t23
            t263 = 1.0d+0*(1.5545345434827443d-2*rhob*t262*t48+1.0d+0*rh
     1         ob*t19*t250)*wght
            t264 = rhob**2
            t265 = 1/t141
            t266 = 1/rhob**3.333333333333333d+0
            t267 = 1/rhob**3.3333333333333337d+0
            t268 = 1/rhob**2.666666666666667d+0
            t269 = 1/t2**7
            t270 = 1/rhob**2.0d+0
            t271 = 1/t16**3
            t272 = t88**3
            t273 = -7.617854707500852d+0*t2*t87**3/t14**4+1.058035376041
     1         7849d-1*t78*t79*t85*t87+4.2321415041671406d-1*t162*t3*t85
     2         *t87+7.617854707500852d+0*t169*t172*t2*t87-1.269642451250
     3         142d+0*t2*t85*(2.625411059665811d-1*t162*t79*t86+1.969058
     4         2947493582d-1*t163*t78*t86-3.9381165894987163d-1*t171*t79
     5         *t80+7.876233178997433d-1*t3*(-1.4585616998143394d-1*t12*
     6         t268*t79-5.469606374303773d-2*t12*t269*t270-1.17081850159
     7         18181d-2*t267-1.3127055298329054d-1*t12*t161*t163)-1.4585
     8         616998143394d-1*t13*t268*t79-5.469606374303773d-2*t13*t26
     9         9*t270-1.3127055298329054d-1*t13*t161*t163)-6.34821225625
     :         071d-1*t172*t3*t80*t85+1.269642451250142d+0*t169*t170*t3*
     ;         t80+7.053569173611901d-2*t15*t161*t79+2.3511897245373004d
     <         -1*t15*t268*t3+1.763392293402975d-2*t15*t163*t270
            t274 = 9.999999999999991d-1*(4.1099018897499934d-3*t266*t9+1
     1         .0991093056753751d-2*t156*t84*t88-1.865442d-1*t167*t173*t
     2         18*t88-8.243319792565315d-3*t173*t75*t84+6.21814d-2*t18*t
     3         273*t84-6.21814d-2*t11*t83**3/t8**3-5.284159572535706d-3*
     4         t156*t76*t83+9.327209999999999d-2*t11*t157*t166*t83-3.109
     5         07d-2*t11*t76*(-7.617854707500852d+0*t2*t82**3/t6**4+1.05
     6         80353760417849d-1*t77*t78*t79*t82+4.2321415041671406d-1*t
     7         162*t3*t77*t82+7.617854707500852d+0*t159*t165*t2*t82-1.26
     8         9642451250142d+0*t2*t77*(2.625411059665811d-1*t162*t79*t8
     9         1+1.9690582947493582d-1*t163*t78*t81-3.9381165894987163d-
     :         1*t164*t79*t80+7.876233178997433d-1*t3*(-1.45856169981433
     ;         94d-1*t268*t4*t79-5.469606374303773d-2*t269*t270*t4-1.312
     <         7055298329054d-1*t161*t163*t4-7.424439106586571d-3*t267)-
     =         1.4585616998143394d-1*t268*t5*t79-5.469606374303773d-2*t2
     >         69*t270*t5-1.3127055298329054d-1*t161*t163*t5)-6.34821225
     ?         625071d-1*t165*t3*t77*t80+1.269642451250142d+0*t159*t160*
     @         t3*t80+7.053569173611901d-2*t161*t7*t79+2.351189724537300
     1         4d-1*t268*t3*t7+1.763392293402975d-2*t163*t270*t7)+3.9631
     2         1967940178d-3*t166*t75*t76+8.243319792565315d-3*t167*t168
     3         *t75-3.96311967940178d-3*t157*t158*t75+1.243628d-1*t18*t2
     4         71*t272-8.548627933030694d-3*t17*t266)-1.0991093056753751
     5         d-2*t156*t84*t88+1.865442d-1*t167*t173*t18*t88+8.24331979
     6         2565315d-3*t173*t75*t84-6.21814d-2*t18*t273*t84-8.2433197
     7         92565315d-3*t167*t168*t75-1.243628d-1*t18*t271*t272+8.548
     8         627933030694d-3*t17*t266
            t275 = 1/t47**3
            t276 = rhob**5.000000000000002d-1
            t277 = 1/rhob**6.666666666666665d-1
            t278 = 1/rhob**1.8333333333333332d+0
            t279 = t89**3
            t280 = exp(-1.92983810657489d+2*t19)
            t281 = 3.453411185284245d+5*gammabb*t279*t280*t37/t39**4
            t282 = -1.252637628753944d+4*gammabb*t102*t103*t190*t191*t19
     1         2
            t283 = -3.453411185284245d+5*gammabb*t191*t192*t279*t37
            t284 = 5.368446980374045d+3*gammabb*t174*t191*t192*t37*t89
            t285 = -8.240428253953201d+0*gammabb*t110*t276*t40
            t286 = 8.829030272092719d-1*gammabb*t114*t277*t40
            t287 = 7.007166882613269d-2*gammabb*t103*t278*t40
            t288 = 3.4077198126375585d+2*gammabb*t105*t114*t188*t38*t89
            t289 = -1.6227237203036002d+1*gammabb*t103*t105*t189*t38*t89
            t290 = 6.263188143769719d+3*gammabb*t102*t103*t105*t190*t38
            t291 = -9.736342321821596d+1*gammabb*t102*t103*t105*t174*t38
            t292 = 5.755685308807075d+4*gammabb*t105*t279*t37*t38
            t293 = -2.6842234901870227d+3*gammabb*t105*t174*t37*t38*t89
            t294 = 1.3909060459745137d+1*gammabb*t105*t274*t37*t38
            t295 = 1/t36**7.0d+0
            t296 = 1/t45**4
            t297 = 1.7894823267913484d+3*t190*t191*t192*t37
            t298 = 1.765806054418543d+0*t114*t188*t40
            t299 = -8.408600259135923d-2*t103*t189*t40
            t300 = -6.490894881214397d+1*t102*t103*t105*t38*t89
            t301 = -8.947411633956742d+2*t105*t190*t37*t38
            t302 = 1.3909060459745137d+1*t105*t174*t37*t38
            t303 = 1/t22**5
            t304 = 1.0d+0*(1.5545345434827443d-2*rhob*t48*(1.91415600012
     1         54607d+1*t142*t21*t62*t99+t21*t23*(1.9141560001254607d+1*
     2         t142*t21*t62*t98+t21*t23*(1.9141560001254607d+1*t142*t21*
     3         t62*t97+t21*t23*(1.9141560001254607d+1*t142*t21*t62*t96+t
     4         21*t23*(1.9141560001254607d+1*t142*t21*t62*t95+t21*t23*(1
     5         .9141560001254607d+1*t142*t21*t62*t94+t21*t23*(1.91415600
     6         01254607d+1*t142*t21*t62*t93+t21*t23*(1.9141560001254607d
     7         +1*t142*t21*t62*t92+t21*t23*(1.9141560001254607d+1*t142*t
     8         21*t62*t91+t21*t23*(1.9141560001254607d+1*t142*t21*t62*t9
     9         0-t175*t21*t63-3.190260000209101d+0*t128*t144*t21*t63-4.5
     :         79991491020378d+1*t128*t141*t63-1.3739974473061137d+2*t14
     ;         1*t21*t217*t51+6.380520000418202d+0*t142*t144*t21*t51+4.5
     <         79991491020378d+1*t141*t142*t51+t21*t23*(-1.3739974473061
     =         137d+2*t141*t21*t217*t50+6.380520000418202d+0*t142*t144*t
     >         21*t50+4.579991491020378d+1*t141*t142*t50)-9.159982982040
     ?         756d+1*t141*t216*t303*t50+9.159982982040756d+1*t141*t21*t
     @         217*t50-t175*t23+3.190260000209101d+0*t128*t144*t23+4.579
     1         991491020378d+1*t128*t141*t142*t21)-9.570780000627304d+0*
     2         t21*t228*t62*t63-t176*t21*t63-3.190260000209101d+0*t129*t
     3         144*t21*t63-4.579991491020378d+1*t129*t141*t63+9.57078000
     4         0627304d+0*t228*t23*t62-1.3739974473061137d+2*t141*t21*t2
     5         17*t52+6.380520000418202d+0*t142*t144*t21*t52+4.579991491
     6         020378d+1*t141*t142*t52-t176*t23+3.190260000209101d+0*t12
     7         9*t144*t23+4.579991491020378d+1*t129*t141*t142*t21)-9.570
     8         780000627304d+0*t21*t229*t62*t63-t177*t21*t63-3.190260000
     9         209101d+0*t130*t144*t21*t63-4.579991491020378d+1*t130*t14
     :         1*t63+9.570780000627304d+0*t229*t23*t62-1.373997447306113
     ;         7d+2*t141*t21*t217*t53+6.380520000418202d+0*t142*t144*t21
     <         *t53+4.579991491020378d+1*t141*t142*t53-t177*t23+3.190260
     =         000209101d+0*t130*t144*t23+4.579991491020378d+1*t130*t141
     >         *t142*t21)-9.570780000627304d+0*t21*t230*t62*t63-t178*t21
     ?         *t63-3.190260000209101d+0*t131*t144*t21*t63-4.57999149102
     @         0378d+1*t131*t141*t63+9.570780000627304d+0*t23*t230*t62-1
     1         .3739974473061137d+2*t141*t21*t217*t54+6.380520000418202d
     2         +0*t142*t144*t21*t54+4.579991491020378d+1*t141*t142*t54-t
     3         178*t23+3.190260000209101d+0*t131*t144*t23+4.579991491020
     4         378d+1*t131*t141*t142*t21)-9.570780000627304d+0*t21*t231*
     5         t62*t63-t179*t21*t63-3.190260000209101d+0*t132*t144*t21*t
     6         63-4.579991491020378d+1*t132*t141*t63+9.570780000627304d+
     7         0*t23*t231*t62-1.3739974473061137d+2*t141*t21*t217*t55+6.
     8         380520000418202d+0*t142*t144*t21*t55+4.579991491020378d+1
     9         *t141*t142*t55-t179*t23+3.190260000209101d+0*t132*t144*t2
     :         3+4.579991491020378d+1*t132*t141*t142*t21)-9.570780000627
     ;         304d+0*t21*t232*t62*t63-t180*t21*t63-3.190260000209101d+0
     <         *t133*t144*t21*t63-4.579991491020378d+1*t133*t141*t63+9.5
     =         70780000627304d+0*t23*t232*t62-1.3739974473061137d+2*t141
     >         *t21*t217*t56+6.380520000418202d+0*t142*t144*t21*t56+4.57
     ?         9991491020378d+1*t141*t142*t56-t180*t23+3.190260000209101
     @         d+0*t133*t144*t23+4.579991491020378d+1*t133*t141*t142*t21
     1         )-9.570780000627304d+0*t21*t233*t62*t63-t181*t21*t63-3.19
     2         0260000209101d+0*t134*t144*t21*t63-4.579991491020378d+1*t
     3         134*t141*t63+9.570780000627304d+0*t23*t233*t62-1.37399744
     4         73061137d+2*t141*t21*t217*t57+6.380520000418202d+0*t142*t
     5         144*t21*t57+4.579991491020378d+1*t141*t142*t57-t181*t23+3
     6         .190260000209101d+0*t134*t144*t23+4.579991491020378d+1*t1
     7         34*t141*t142*t21)-9.570780000627304d+0*t21*t234*t62*t63-t
     8         182*t21*t63-3.190260000209101d+0*t135*t144*t21*t63-4.5799
     9         91491020378d+1*t135*t141*t63+9.570780000627304d+0*t23*t23
     :         4*t62-1.3739974473061137d+2*t141*t21*t217*t58+6.380520000
     ;         418202d+0*t142*t144*t21*t58+4.579991491020378d+1*t141*t14
     <         2*t58-t182*t23+3.190260000209101d+0*t135*t144*t23+4.57999
     =         1491020378d+1*t135*t141*t142*t21)-9.570780000627304d+0*t2
     >         1*t235*t62*t63-t183*t21*t63-3.190260000209101d+0*t136*t14
     ?         4*t21*t63-4.579991491020378d+1*t136*t141*t63+9.5707800006
     @         27304d+0*t23*t235*t62-1.3739974473061137d+2*t141*t21*t217
     1         *t59+6.380520000418202d+0*t142*t144*t21*t59+4.57999149102
     2         0378d+1*t141*t142*t59-t183*t23+3.190260000209101d+0*t136*
     3         t144*t23+4.579991491020378d+1*t136*t141*t142*t21)-9.57078
     4         0000627304d+0*t21*t236*t62*t63-t184*t21*t63-3.19026000020
     5         9101d+0*t137*t144*t21*t63-4.579991491020378d+1*t137*t141*
     6         t63+9.570780000627304d+0*t23*t236*t62-1.3739974473061137d
     7         +2*t141*t21*t217*t60+6.380520000418202d+0*t142*t144*t21*t
     8         60+4.579991491020378d+1*t141*t142*t60-t184*t23+3.19026000
     9         0209101d+0*t137*t144*t23+4.579991491020378d+1*t137*t141*t
     :         142*t21)+2.0d+0*rhob*t227*t89+2.0d+0*t127*t89+1.0d+0*rhob
     ;         *t19*(1.9141560001254607d+1*t142*t21*t62*t73+t21*t23*(1.9
     <         141560001254607d+1*t142*t21*t62*t72+t21*t23*(1.9141560001
     =         254607d+1*t142*t21*t62*t71+t21*t23*(1.9141560001254607d+1
     >         *t142*t21*t62*t70+t21*t23*(1.9141560001254607d+1*t142*t21
     ?         *t62*t69+t21*t23*(1.9141560001254607d+1*t142*t21*t62*t68+
     @         t21*t23*(1.9141560001254607d+1*t142*t21*t62*t67+t21*t23*(
     1         1.9141560001254607d+1*t142*t21*t62*t66+t21*t23*(1.9141560
     2         001254607d+1*t142*t21*t62*t65+t21*t23*(1.9141560001254607
     3         d+1*t142*t21*t62*t64-t145*t21*t63-3.190260000209101d+0*t1
     4         17*t144*t21*t63-4.579991491020378d+1*t117*t141*t63-9.1599
     5         82982040756d+1*t141*t216*t24*t303-1.3739974473061137d+2*t
     6         141*t21*t217*t25+6.380520000418202d+0*t142*t144*t21*t25+4
     7         .579991491020378d+1*t141*t142*t25+t21*t23*(-1.37399744730
     8         61137d+2*t141*t21*t217*t24+6.380520000418202d+0*t142*t144
     9         *t21*t24+4.579991491020378d+1*t141*t142*t24)+9.1599829820
     :         40756d+1*t141*t21*t217*t24-t145*t23+3.190260000209101d+0*
     ;         t117*t144*t23+4.579991491020378d+1*t117*t141*t142*t21)-9.
     <         570780000627304d+0*t21*t218*t62*t63-t146*t21*t63-3.190260
     =         000209101d+0*t118*t144*t21*t63-4.579991491020378d+1*t118*
     >         t141*t63+9.570780000627304d+0*t218*t23*t62-1.373997447306
     ?         1137d+2*t141*t21*t217*t26+6.380520000418202d+0*t142*t144*
     @         t21*t26+4.579991491020378d+1*t141*t142*t26-t146*t23+3.190
     1         260000209101d+0*t118*t144*t23+4.579991491020378d+1*t118*t
     2         141*t142*t21)-9.570780000627304d+0*t21*t219*t62*t63-t147*
     3         t21*t63-3.190260000209101d+0*t119*t144*t21*t63-4.57999149
     4         1020378d+1*t119*t141*t63+9.570780000627304d+0*t219*t23*t6
     5         2-1.3739974473061137d+2*t141*t21*t217*t27+6.3805200004182
     6         02d+0*t142*t144*t21*t27+4.579991491020378d+1*t141*t142*t2
     7         7-t147*t23+3.190260000209101d+0*t119*t144*t23+4.579991491
     8         020378d+1*t119*t141*t142*t21)-9.570780000627304d+0*t21*t2
     9         20*t62*t63-t148*t21*t63-3.190260000209101d+0*t120*t144*t2
     :         1*t63-4.579991491020378d+1*t120*t141*t63+9.57078000062730
     ;         4d+0*t220*t23*t62-1.3739974473061137d+2*t141*t21*t217*t28
     <         +6.380520000418202d+0*t142*t144*t21*t28+4.579991491020378
     =         d+1*t141*t142*t28-t148*t23+3.190260000209101d+0*t120*t144
     >         *t23+4.579991491020378d+1*t120*t141*t142*t21)-9.570780000
     ?         627304d+0*t21*t221*t62*t63-t149*t21*t63-3.190260000209101
     @         d+0*t121*t144*t21*t63-4.579991491020378d+1*t121*t141*t63+
     1         9.570780000627304d+0*t221*t23*t62-1.3739974473061137d+2*t
     2         141*t21*t217*t29+6.380520000418202d+0*t142*t144*t21*t29+4
     3         .579991491020378d+1*t141*t142*t29-t149*t23+3.190260000209
     4         101d+0*t121*t144*t23+4.579991491020378d+1*t121*t141*t142*
     5         t21)-9.570780000627304d+0*t21*t222*t62*t63-t150*t21*t63-3
     6         .190260000209101d+0*t122*t144*t21*t63-4.579991491020378d+
     7         1*t122*t141*t63+9.570780000627304d+0*t222*t23*t62-1.37399
     8         74473061137d+2*t141*t21*t217*t30+6.380520000418202d+0*t14
     9         2*t144*t21*t30+4.579991491020378d+1*t141*t142*t30-t150*t2
     :         3+3.190260000209101d+0*t122*t144*t23+4.579991491020378d+1
     ;         *t122*t141*t142*t21)-9.570780000627304d+0*t21*t223*t62*t6
     <         3-t151*t21*t63-3.190260000209101d+0*t123*t144*t21*t63-4.5
     =         79991491020378d+1*t123*t141*t63+9.570780000627304d+0*t223
     >         *t23*t62-1.3739974473061137d+2*t141*t21*t217*t31+6.380520
     ?         000418202d+0*t142*t144*t21*t31+4.579991491020378d+1*t141*
     @         t142*t31-t151*t23+3.190260000209101d+0*t123*t144*t23+4.57
     1         9991491020378d+1*t123*t141*t142*t21)-9.570780000627304d+0
     2         *t21*t224*t62*t63-t152*t21*t63-3.190260000209101d+0*t124*
     3         t144*t21*t63-4.579991491020378d+1*t124*t141*t63+9.5707800
     4         00627304d+0*t224*t23*t62-1.3739974473061137d+2*t141*t21*t
     5         217*t32+6.380520000418202d+0*t142*t144*t21*t32+4.57999149
     6         1020378d+1*t141*t142*t32-t152*t23+3.190260000209101d+0*t1
     7         24*t144*t23+4.579991491020378d+1*t124*t141*t142*t21)-9.57
     8         0780000627304d+0*t21*t225*t62*t63-t153*t21*t63-3.19026000
     9         0209101d+0*t125*t144*t21*t63-4.579991491020378d+1*t125*t1
     :         41*t63+9.570780000627304d+0*t225*t23*t62-1.37399744730611
     ;         37d+2*t141*t21*t217*t33+6.380520000418202d+0*t142*t144*t2
     <         1*t33+4.579991491020378d+1*t141*t142*t33-t153*t23+3.19026
     =         0000209101d+0*t125*t144*t23+4.579991491020378d+1*t125*t14
     >         1*t142*t21)-9.570780000627304d+0*t21*t226*t62*t63-t154*t2
     ?         1*t63-3.190260000209101d+0*t126*t144*t21*t63-4.5799914910
     @         20378d+1*t126*t141*t63+9.570780000627304d+0*t226*t23*t62-
     1         1.3739974473061137d+2*t141*t21*t217*t34+6.380520000418202
     2         d+0*t142*t144*t21*t34+4.579991491020378d+1*t141*t142*t34-
     3         t154*t23+3.190260000209101d+0*t126*t144*t23+4.57999149102
     4         0378d+1*t126*t141*t142*t21)+3.1090690869654886d-2*t237*t4
     5         8+t101*(3.1090690869654886d-2*rhob*t113*t237+1.5545345434
     6         827443d-2*rhob*t139*t205+3.1090690869654886d-2*t113*t139)
     7         +2.0d+0*t19*t227-1.5545345434827443d-2*rhob*t139*t186*t18
     8         7+1.0d+0*rhob*t127*t174)*wght
            t305 = 1.0d+0*(t101*(1.5545345434827443d-2*rhob*t116*t237+1.
     1         5545345434827443d-2*rhob*t139*t211+1.5545345434827443d-2*
     2         t116*t139)-1.5545345434827443d-2*rhob*t113*t116*t139*t186
     3         )*wght
            t306 = 1.5545345434827443d-2*rhob*t101*t139*t215*wght-1.5545
     1         345434827443d-2*rhob*t139*t186*t213*wght
            t307 = 1.0d+0*(1.5545345434827443d-2*rhob*t48*(2*t63*t99+2*t
     1         142*t21*t99+t21*t23*(2*t63*t98+2*t142*t21*t98+t21*t23*(2*
     2         t63*t97+2*t142*t21*t97+t21*t23*(2*t63*t96+2*t142*t21*t96+
     3         t21*t23*(2*t63*t95+2*t142*t21*t95+t21*t23*(2*t63*t94+2*t1
     4         42*t21*t94+t21*t23*(2*t63*t93+2*t142*t21*t93+t21*t23*(2*t
     5         63*t92+2*t142*t21*t92+t21*t23*(2*t63*t91+2*t142*t21*t91+t
     6         21*t23*(2*t63*t90+2*t142*t21*t90-4.785390000313652d+0*t21
     7         *t251*t62*t63-2.8712340001881914d+1*t21*t217*t51*t62-9.57
     8         0780000627304d+0*t142*t51*t62-4.785390000313652d+1*t216*t
     9         303*t50*t62-2.8712340001881914d+1*t21*t217*t50*t62+4.7853
     :         90000313652d+0*t23*t251*t62+1.9141560001254607d+1*t128*t1
     ;         42*t21*t62)-4.785390000313652d+0*t21*t252*t62*t63-2*t21*t
     <         228*t63-2.8712340001881914d+1*t21*t217*t52*t62-9.57078000
     =         0627304d+0*t142*t52*t62+4.785390000313652d+0*t23*t252*t62
     >         +1.9141560001254607d+1*t129*t142*t21*t62-2*t228*t23)-4.78
     ?         5390000313652d+0*t21*t253*t62*t63-2*t21*t229*t63-2.871234
     @         0001881914d+1*t21*t217*t53*t62-9.570780000627304d+0*t142*
     1         t53*t62+4.785390000313652d+0*t23*t253*t62+1.9141560001254
     2         607d+1*t130*t142*t21*t62-2*t229*t23)-4.785390000313652d+0
     3         *t21*t254*t62*t63-2*t21*t230*t63-2.8712340001881914d+1*t2
     4         1*t217*t54*t62-9.570780000627304d+0*t142*t54*t62+4.785390
     5         000313652d+0*t23*t254*t62+1.9141560001254607d+1*t131*t142
     6         *t21*t62-2*t23*t230)-4.785390000313652d+0*t21*t255*t62*t6
     7         3-2*t21*t231*t63-2.8712340001881914d+1*t21*t217*t55*t62-9
     8         .570780000627304d+0*t142*t55*t62+4.785390000313652d+0*t23
     9         *t255*t62+1.9141560001254607d+1*t132*t142*t21*t62-2*t23*t
     :         231)-4.785390000313652d+0*t21*t256*t62*t63-2*t21*t232*t63
     ;         -2.8712340001881914d+1*t21*t217*t56*t62-9.570780000627304
     <         d+0*t142*t56*t62+4.785390000313652d+0*t23*t256*t62+1.9141
     =         560001254607d+1*t133*t142*t21*t62-2*t23*t232)-4.785390000
     >         313652d+0*t21*t257*t62*t63-2*t21*t233*t63-2.8712340001881
     ?         914d+1*t21*t217*t57*t62-9.570780000627304d+0*t142*t57*t62
     @         +4.785390000313652d+0*t23*t257*t62+1.9141560001254607d+1*
     1         t134*t142*t21*t62-2*t23*t233)-4.785390000313652d+0*t21*t2
     2         58*t62*t63-2*t21*t234*t63-2.8712340001881914d+1*t21*t217*
     3         t58*t62-9.570780000627304d+0*t142*t58*t62+4.7853900003136
     4         52d+0*t23*t258*t62+1.9141560001254607d+1*t135*t142*t21*t6
     5         2-2*t23*t234)-4.785390000313652d+0*t21*t259*t62*t63-2*t21
     6         *t235*t63-2.8712340001881914d+1*t21*t217*t59*t62-9.570780
     7         000627304d+0*t142*t59*t62+4.785390000313652d+0*t23*t259*t
     8         62+1.9141560001254607d+1*t136*t142*t21*t62-2*t23*t235)-4.
     9         785390000313652d+0*t21*t260*t62*t63-2*t21*t236*t63-2.8712
     :         340001881914d+1*t21*t217*t60*t62-9.570780000627304d+0*t14
     ;         2*t60*t62+4.785390000313652d+0*t23*t260*t62+1.91415600012
     <         54607d+1*t137*t142*t21*t62-2*t23*t236)+1.0d+0*rhob*t250*t
     =         89+1.0d+0*rhob*t19*(2*t63*t73+2*t142*t21*t73+t21*t23*(2*t
     >         63*t72+2*t142*t21*t72+t21*t23*(2*t63*t71+2*t142*t21*t71+t
     ?         21*t23*(2*t63*t70+2*t142*t21*t70+t21*t23*(2*t63*t69+2*t14
     @         2*t21*t69+t21*t23*(2*t63*t68+2*t142*t21*t68+t21*t23*(2*t6
     1         3*t67+2*t142*t21*t67+t21*t23*(2*t63*t66+2*t142*t21*t66+t2
     2         1*t23*(2*t63*t65+2*t142*t21*t65+t21*t23*(2*t63*t64+2*t142
     3         *t21*t64-4.785390000313652d+0*t21*t240*t62*t63-4.78539000
     4         0313652d+1*t216*t24*t303*t62-2.8712340001881914d+1*t21*t2
     5         17*t25*t62-9.570780000627304d+0*t142*t25*t62+4.7853900003
     6         13652d+0*t23*t240*t62-2.8712340001881914d+1*t21*t217*t24*
     7         t62+1.9141560001254607d+1*t117*t142*t21*t62)-4.7853900003
     8         13652d+0*t21*t241*t62*t63-2*t21*t218*t63-2.87123400018819
     9         14d+1*t21*t217*t26*t62-9.570780000627304d+0*t142*t26*t62+
     :         4.785390000313652d+0*t23*t241*t62+1.9141560001254607d+1*t
     ;         118*t142*t21*t62-2*t218*t23)-4.785390000313652d+0*t21*t24
     <         2*t62*t63-2*t21*t219*t63-2.8712340001881914d+1*t21*t217*t
     =         27*t62-9.570780000627304d+0*t142*t27*t62+4.78539000031365
     >         2d+0*t23*t242*t62+1.9141560001254607d+1*t119*t142*t21*t62
     ?         -2*t219*t23)-4.785390000313652d+0*t21*t243*t62*t63-2*t21*
     @         t220*t63-2.8712340001881914d+1*t21*t217*t28*t62-9.5707800
     1         00627304d+0*t142*t28*t62+4.785390000313652d+0*t23*t243*t6
     2         2+1.9141560001254607d+1*t120*t142*t21*t62-2*t220*t23)-4.7
     3         85390000313652d+0*t21*t244*t62*t63-2*t21*t221*t63-2.87123
     4         40001881914d+1*t21*t217*t29*t62-9.570780000627304d+0*t142
     5         *t29*t62+4.785390000313652d+0*t23*t244*t62+1.914156000125
     6         4607d+1*t121*t142*t21*t62-2*t221*t23)-4.785390000313652d+
     7         0*t21*t245*t62*t63-2*t21*t222*t63-2.8712340001881914d+1*t
     8         21*t217*t30*t62-9.570780000627304d+0*t142*t30*t62+4.78539
     9         0000313652d+0*t23*t245*t62+1.9141560001254607d+1*t122*t14
     :         2*t21*t62-2*t222*t23)-4.785390000313652d+0*t21*t246*t62*t
     ;         63-2*t21*t223*t63-2.8712340001881914d+1*t21*t217*t31*t62-
     <         9.570780000627304d+0*t142*t31*t62+4.785390000313652d+0*t2
     =         3*t246*t62+1.9141560001254607d+1*t123*t142*t21*t62-2*t223
     >         *t23)-4.785390000313652d+0*t21*t247*t62*t63-2*t21*t224*t6
     ?         3-2.8712340001881914d+1*t21*t217*t32*t62-9.57078000062730
     @         4d+0*t142*t32*t62+4.785390000313652d+0*t23*t247*t62+1.914
     1         1560001254607d+1*t124*t142*t21*t62-2*t224*t23)-4.78539000
     2         0313652d+0*t21*t248*t62*t63-2*t21*t225*t63-2.871234000188
     3         1914d+1*t21*t217*t33*t62-9.570780000627304d+0*t142*t33*t6
     4         2+4.785390000313652d+0*t23*t248*t62+1.9141560001254607d+1
     5         *t125*t142*t21*t62-2*t225*t23)-4.785390000313652d+0*t21*t
     6         249*t62*t63-2*t21*t226*t63-2.8712340001881914d+1*t21*t217
     7         *t34*t62-9.570780000627304d+0*t142*t34*t62+4.785390000313
     8         652d+0*t23*t249*t62+1.9141560001254607d+1*t126*t142*t21*t
     9         62-2*t226*t23)+1.5545345434827443d-2*t262*t48+1.554534543
     :         4827443d-2*rhob*t101*t113*t262+1.0d+0*t19*t250)*wght
            t308 = 1.5545345434827443d-2*rhob*t101*t116*(t23*(2*t21*t59*
     1         t63+2*t23*t59+t21*t260-2*t136*t21*t23)+(2*t21*t23*t59+2*t
     2         49-2*t137*t21)*t63+t261)*wght
            t309 = 1.0d+0*(1.5545345434827443d-2*rhob*t48*(t21*t23*(t21*
     1         t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23
     2         *(t21*t23*(-3*t21*t251*t63+6*t128*t63-6*t21*t217*t51-6*t1
     3         42*t51+t21*t23*(-6*t21*t217*t50-6*t142*t50)-3*t23*t251+6*
     4         t128*t142*t21)-3*t21*t252*t63+6*t129*t63-6*t21*t217*t52-6
     5         *t142*t52-3*t23*t252+6*t129*t142*t21)-3*t21*t253*t63+6*t1
     6         30*t63-6*t21*t217*t53-6*t142*t53-3*t23*t253+6*t130*t142*t
     7         21)-3*t21*t254*t63+6*t131*t63-6*t21*t217*t54-6*t142*t54-3
     8         *t23*t254+6*t131*t142*t21)-3*t21*t255*t63+6*t132*t63-6*t2
     9         1*t217*t55-6*t142*t55-3*t23*t255+6*t132*t142*t21)-3*t21*t
     :         256*t63+6*t133*t63-6*t21*t217*t56-6*t142*t56-3*t23*t256+6
     ;         *t133*t142*t21)-3*t21*t257*t63+6*t134*t63-6*t21*t217*t57-
     <         6*t142*t57-3*t23*t257+6*t134*t142*t21)-3*t21*t258*t63+6*t
     =         135*t63-6*t21*t217*t58-6*t142*t58-3*t23*t258+6*t135*t142*
     >         t21)-3*t21*t259*t63+6*t136*t63-6*t21*t217*t59-6*t142*t59-
     ?         3*t23*t259+6*t136*t142*t21)-3*t21*t260*t63+6*t137*t63-6*t
     @         21*t217*t60-6*t142*t60-3*t23*t260+6*t137*t142*t21)+1.0d+0
     1         *rhob*t19*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t21*t23*(t
     2         21*t23*(t21*t23*(t21*t23*(t21*t23*(-3*t21*t240*t63+6*t117
     3         *t63-6*t21*t217*t25-6*t142*t25-3*t23*t240+t21*t23*(-6*t21
     4         *t217*t24-6*t142*t24)+6*t117*t142*t21)-3*t21*t241*t63+6*t
     5         118*t63-6*t21*t217*t26-6*t142*t26-3*t23*t241+6*t118*t142*
     6         t21)-3*t21*t242*t63+6*t119*t63-6*t21*t217*t27-6*t142*t27-
     7         3*t23*t242+6*t119*t142*t21)-3*t21*t243*t63+6*t120*t63-6*t
     8         21*t217*t28-6*t142*t28-3*t23*t243+6*t120*t142*t21)-3*t21*
     9         t244*t63+6*t121*t63-6*t21*t217*t29-6*t142*t29-3*t23*t244+
     :         6*t121*t142*t21)-3*t21*t245*t63+6*t122*t63-6*t21*t217*t30
     ;         -6*t142*t30-3*t23*t245+6*t122*t142*t21)-3*t21*t246*t63+6*
     <         t123*t63-6*t21*t217*t31-6*t142*t31-3*t23*t246+6*t123*t142
     =         *t21)-3*t21*t247*t63+6*t124*t63-6*t21*t217*t32-6*t142*t32
     >         -3*t23*t247+6*t124*t142*t21)-3*t21*t248*t63+6*t125*t63-6*
     ?         t21*t217*t33-6*t142*t33-3*t23*t248+6*t125*t142*t21)-3*t21
     @         *t249*t63+6*t126*t63-6*t21*t217*t34-6*t142*t34-3*t23*t249
     1         +6*t126*t142*t21))*wght
            fnc(iq) = 1.0d+0*(1.5545345434827443d-2*rhob*t48*t61+1.0d+0*
     1         rhob*t19*t35)*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*(1.0d+0*rhob*t35*t89+1.0d+0*rhob*t19
     1         *t74+1.5545345434827443d-2*t48*t61+1.5545345434827443d-2*
     2         rhob*t101*t113*t61+1.5545345434827443d-2*rhob*t100*t48+1.
     3         0d+0*t19*t35)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.5545345434827443d-2*rhob*t101*t116*t61*w
     1         ght+Cmat(iq,D1_GBB)
            Mmat(iq,D1_TB) = t140+Mmat(iq,D1_TB)
            Mmat(iq,D1_TA) = t140+Mmat(iq,D1_TA)
            Amat2(iq,D2_RB_RB) = 1.0d+0*(2.0d+0*rhob*t74*t89+2.0d+0*t35*
     1         t89+2.0d+0*t19*t74-1.5545345434827443d-2*rhob*t186*t187*t
     2         61+1.5545345434827443d-2*rhob*t185*t48+3.1090690869654886
     3         d-2*t100*t48+1.0d+0*rhob*t174*t35+t101*t206+1.0d+0*rhob*t
     4         155*t19)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*(t101*t212-1.5545345434827443d-
     1         2*rhob*t113*t116*t186*t61)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.5545345434827443d-2*rhob*t101*t215*
     1         t61*wght-1.5545345434827443d-2*rhob*t186*t213*t61*wght+Cm
     2         at2(iq,D2_GBB_GBB)
            Mmat2(iq,D2_RB_TA) = t238+Mmat2(iq,D2_RB_TA)
            Mmat2(iq,D2_RB_TB) = t238+Mmat2(iq,D2_RB_TB)
            Mmat2(iq,D2_GBB_TA) = t239+Mmat2(iq,D2_GBB_TA)
            Mmat2(iq,D2_GBB_TB) = t239+Mmat2(iq,D2_GBB_TB)
            Mmat2(iq,D2_TA_TA) = t263+Mmat2(iq,D2_TA_TA)
            Mmat2(iq,D2_TA_TB) = t263+Mmat2(iq,D2_TA_TB)
            Mmat2(iq,D2_TB_TB) = t263+Mmat2(iq,D2_TB_TB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*(1.5545345434827443d-2*rhob*t
     1         48*(-9.570780000627304d+0*t144*t21*t63*t99-1.373997447306
     2         1137d+2*t141*t63*t99+9.570780000627304d+0*t144*t23*t99+1.
     3         3739974473061137d+2*t141*t142*t21*t99+t21*t23*(-9.5707800
     4         00627304d+0*t144*t21*t63*t98-1.3739974473061137d+2*t141*t
     5         63*t98+9.570780000627304d+0*t144*t23*t98+1.37399744730611
     6         37d+2*t141*t142*t21*t98+t21*t23*(-9.570780000627304d+0*t1
     7         44*t21*t63*t97-1.3739974473061137d+2*t141*t63*t97+9.57078
     8         0000627304d+0*t144*t23*t97+1.3739974473061137d+2*t141*t14
     9         2*t21*t97+t21*t23*(-9.570780000627304d+0*t144*t21*t63*t96
     :         -1.3739974473061137d+2*t141*t63*t96+9.570780000627304d+0*
     ;         t144*t23*t96+1.3739974473061137d+2*t141*t142*t21*t96+t21*
     <         t23*(-9.570780000627304d+0*t144*t21*t63*t95-1.37399744730
     =         61137d+2*t141*t63*t95+9.570780000627304d+0*t144*t23*t95+1
     >         .3739974473061137d+2*t141*t142*t21*t95+t21*t23*(-9.570780
     ?         000627304d+0*t144*t21*t63*t94-1.3739974473061137d+2*t141*
     @         t63*t94+9.570780000627304d+0*t144*t23*t94+1.3739974473061
     1         137d+2*t141*t142*t21*t94+t21*t23*(-9.570780000627304d+0*t
     2         144*t21*t63*t93-1.3739974473061137d+2*t141*t63*t93+9.5707
     3         80000627304d+0*t144*t23*t93+1.3739974473061137d+2*t141*t1
     4         42*t21*t93+t21*t23*(-9.570780000627304d+0*t144*t21*t63*t9
     5         2-1.3739974473061137d+2*t141*t63*t92+9.570780000627304d+0
     6         *t144*t23*t92+1.3739974473061137d+2*t141*t142*t21*t92+t21
     7         *t23*(-9.570780000627304d+0*t144*t21*t63*t91-1.3739974473
     8         061137d+2*t141*t63*t91+9.570780000627304d+0*t144*t23*t91+
     9         1.3739974473061137d+2*t141*t142*t21*t91+t21*t23*(-9.57078
     :         0000627304d+0*t144*t21*t63*t90-1.3739974473061137d+2*t141
     ;         *t63*t90+9.570780000627304d+0*t144*t23*t90+1.373997447306
     <         1137d+2*t141*t142*t21*t90+t21*t23*(1.0634200000697003d+0*
     =         t21*t265*t50*t63-9.159982982040756d+1*t143*t50*t63-1.0634
     >         200000697003d+0*t23*t265*t50-6.57511364479516d+2*t21*t217
     ?         *t264*t50+6.57511364479516d+2*t142*t264*t50+9.15998298204
     @         0756d+1*t142*t143*t21*t50)-1.4356170000940957d+1*t175*t21
     1         *t62*t63+1.0634200000697003d+0*t21*t265*t51*t63-9.1599829
     2         82040756d+1*t143*t51*t63+1.4356170000940957d+1*t175*t23*t
     3         62-1.0634200000697003d+0*t23*t265*t51-6.57511364479516d+2
     4         *t21*t217*t264*t51+6.57511364479516d+2*t142*t264*t51+9.15
     5         9982982040756d+1*t142*t143*t21*t51)-1.4356170000940957d+1
     6         *t176*t21*t62*t63+1.0634200000697003d+0*t21*t265*t52*t63-
     7         9.159982982040756d+1*t143*t52*t63+1.4356170000940957d+1*t
     8         176*t23*t62-1.0634200000697003d+0*t23*t265*t52-6.57511364
     9         479516d+2*t21*t217*t264*t52+6.57511364479516d+2*t142*t264
     :         *t52+9.159982982040756d+1*t142*t143*t21*t52)-1.4356170000
     ;         940957d+1*t177*t21*t62*t63+1.0634200000697003d+0*t21*t265
     <         *t53*t63-9.159982982040756d+1*t143*t53*t63+1.435617000094
     =         0957d+1*t177*t23*t62-1.0634200000697003d+0*t23*t265*t53-6
     >         .57511364479516d+2*t21*t217*t264*t53+6.57511364479516d+2*
     ?         t142*t264*t53+9.159982982040756d+1*t142*t143*t21*t53)-1.4
     @         356170000940957d+1*t178*t21*t62*t63+1.0634200000697003d+0
     1         *t21*t265*t54*t63-9.159982982040756d+1*t143*t54*t63+1.435
     2         6170000940957d+1*t178*t23*t62-1.0634200000697003d+0*t23*t
     3         265*t54-6.57511364479516d+2*t21*t217*t264*t54+6.575113644
     4         79516d+2*t142*t264*t54+9.159982982040756d+1*t142*t143*t21
     5         *t54)-1.4356170000940957d+1*t179*t21*t62*t63+1.0634200000
     6         697003d+0*t21*t265*t55*t63-9.159982982040756d+1*t143*t55*
     7         t63+1.4356170000940957d+1*t179*t23*t62-1.0634200000697003
     8         d+0*t23*t265*t55-6.57511364479516d+2*t21*t217*t264*t55+6.
     9         57511364479516d+2*t142*t264*t55+9.159982982040756d+1*t142
     :         *t143*t21*t55)-1.4356170000940957d+1*t180*t21*t62*t63+1.0
     ;         634200000697003d+0*t21*t265*t56*t63-9.159982982040756d+1*
     <         t143*t56*t63+1.4356170000940957d+1*t180*t23*t62-1.0634200
     =         000697003d+0*t23*t265*t56-6.57511364479516d+2*t21*t217*t2
     >         64*t56+6.57511364479516d+2*t142*t264*t56+9.15998298204075
     ?         6d+1*t142*t143*t21*t56)-1.4356170000940957d+1*t181*t21*t6
     @         2*t63+1.0634200000697003d+0*t21*t265*t57*t63-9.1599829820
     1         40756d+1*t143*t57*t63+1.4356170000940957d+1*t181*t23*t62-
     2         1.0634200000697003d+0*t23*t265*t57-6.57511364479516d+2*t2
     3         1*t217*t264*t57+6.57511364479516d+2*t142*t264*t57+9.15998
     4         2982040756d+1*t142*t143*t21*t57)-1.4356170000940957d+1*t1
     5         82*t21*t62*t63+1.0634200000697003d+0*t21*t265*t58*t63-9.1
     6         59982982040756d+1*t143*t58*t63+1.4356170000940957d+1*t182
     7         *t23*t62-1.0634200000697003d+0*t23*t265*t58-6.57511364479
     8         516d+2*t21*t217*t264*t58+6.57511364479516d+2*t142*t264*t5
     9         8+9.159982982040756d+1*t142*t143*t21*t58)-1.4356170000940
     :         957d+1*t183*t21*t62*t63+1.0634200000697003d+0*t21*t265*t5
     ;         9*t63-9.159982982040756d+1*t143*t59*t63+1.435617000094095
     <         7d+1*t183*t23*t62-1.0634200000697003d+0*t23*t265*t59-6.57
     =         511364479516d+2*t21*t217*t264*t59+6.57511364479516d+2*t14
     >         2*t264*t59+9.159982982040756d+1*t142*t143*t21*t59)-1.4356
     ?         170000940957d+1*t184*t21*t62*t63+1.0634200000697003d+0*t2
     @         1*t265*t60*t63-9.159982982040756d+1*t143*t60*t63+1.435617
     1         0000940957d+1*t184*t23*t62-1.0634200000697003d+0*t23*t265
     2         *t60-6.57511364479516d+2*t21*t217*t264*t60+6.575113644795
     3         16d+2*t142*t264*t60+9.159982982040756d+1*t142*t143*t21*t6
     4         0)+t101*(1.5545345434827443d-2*rhob*t61*(-2.1622114952063
     5         792d-1*gammabb*t108*t37*t42*(-1.1607717772370736d+3*t111*
     6         t174*t38*t43*t89+3.482315331711221d+3*t174*t191*t200*t43*
     7         t89+4.912140634218306d+2*t109*t111*t188*t201*t38*t89-1.40
     8         34687526338022d+1*t109*t110*t111*t189*t38*t89-8.908774348
     9         060524d+0*t109*t276*t295*t44+3.030195356483172d-2*t109*t1
     :         10*t278*t44+6.363410248614663d-1*t109*t201*t277*t44+2.986
     ;         8021449983523d+5*t279*t280*t43/t39**5.0d+0+2.489001787498
     <         6267d+4*t111*t279*t38*t43+6.014866082716293d+0*t111*t274*
     =         t38*t43-2.2401016087487644d+5*t191*t200*t279*t43+5.416934
     >         960439677d+3*t102*t109*t110*t111*t190*t38-8.4208125158028
     ?         09d+1*t102*t109*t110*t111*t174*t38+t294+t293+t292+t291+t2
     @         90+t289+t288+t287+t286+t285+t284+t283+t282+t281-1.6250804
     1         88131903d+4*t102*t109*t110*t190*t191*t200)+7.007166882613
     2         269d-2*gammabb*t103*t278*t42*t46+8.829030272092719d-1*gam
     3         mabb*t114*t277*t42*t46-8.240428253953201d+0*gammabb*t110*
     4         t276*t42*t46+2.1622114952063792d-1*gammabb*(t294+t293+t29
     5         2+t291+t290+t289+t288+t287+t286+t285+t284+t283+t282+t281)
     6         *t37*t46-1.5135480466444656d+0*gammabb*t102*t103*t199*t46
     7         -2.522580077740777d-1*gammabb*t103*t107*t189*t46+5.297418
     8         163255629d+0*gammabb*t107*t114*t188*t46-1.297326897123827
     9         8d+0*gammabb*t112**3*t296*t37*t42+1.2973268971238278d+0*g
     :         ammabb*t112*t202*t203*t37*t42-3.027096093288931d+0*gammab
     ;         b*t102*t103*t203*t204*t42+1.5135480466444656d+0*gammabb*t
     <         102*t103*t108*t202*t42+2.522580077740777d-1*gammabb*t103*
     =         t108*t112*t189*t42-5.297418163255629d+0*gammabb*t108*t112
     >         *t114*t188*t42+1.2973268971238278d+0*gammabb*t107*t203*t2
     ?         04*t37-6.486634485619138d-1*gammabb*t107*t108*t202*t37-6.
     @         486634485619138d-1*gammabb*t108*t112*t199*t37+3.027096093
     1         288931d+0*gammabb*t102*t103*t107*t108*t112)+4.66360363044
     2         82326d-2*t205*t61+4.6636036304482326d-2*rhob*t100*t205+4.
     3         6636036304482326d-2*rhob*t113*t185+9.327207260896465d-2*t
     4         100*t113)+6.0d+0*t74*t89+3.0d+0*rhob*t155*t89+3.0d+0*rhob
     5         *t174*t74+1.0d+0*rhob*t19*(-9.570780000627304d+0*t144*t21
     6         *t63*t73-1.3739974473061137d+2*t141*t63*t73+9.57078000062
     7         7304d+0*t144*t23*t73+1.3739974473061137d+2*t141*t142*t21*
     8         t73+t21*t23*(-9.570780000627304d+0*t144*t21*t63*t72-1.373
     9         9974473061137d+2*t141*t63*t72+9.570780000627304d+0*t144*t
     :         23*t72+1.3739974473061137d+2*t141*t142*t21*t72+t21*t23*(-
     ;         9.570780000627304d+0*t144*t21*t63*t71-1.3739974473061137d
     <         +2*t141*t63*t71+9.570780000627304d+0*t144*t23*t71+1.37399
     =         74473061137d+2*t141*t142*t21*t71+t21*t23*(-9.570780000627
     >         304d+0*t144*t21*t63*t70-1.3739974473061137d+2*t141*t63*t7
     ?         0+9.570780000627304d+0*t144*t23*t70+1.3739974473061137d+2
     @         *t141*t142*t21*t70+t21*t23*(-9.570780000627304d+0*t144*t2
     1         1*t63*t69-1.3739974473061137d+2*t141*t63*t69+9.5707800006
     2         27304d+0*t144*t23*t69+1.3739974473061137d+2*t141*t142*t21
     3         *t69+t21*t23*(-9.570780000627304d+0*t144*t21*t63*t68-1.37
     4         39974473061137d+2*t141*t63*t68+9.570780000627304d+0*t144*
     5         t23*t68+1.3739974473061137d+2*t141*t142*t21*t68+t21*t23*(
     6         -9.570780000627304d+0*t144*t21*t63*t67-1.3739974473061137
     7         d+2*t141*t63*t67+9.570780000627304d+0*t144*t23*t67+1.3739
     8         974473061137d+2*t141*t142*t21*t67+t21*t23*(-9.57078000062
     9         7304d+0*t144*t21*t63*t66-1.3739974473061137d+2*t141*t63*t
     :         66+9.570780000627304d+0*t144*t23*t66+1.3739974473061137d+
     ;         2*t141*t142*t21*t66+t21*t23*(-9.570780000627304d+0*t144*t
     <         21*t63*t65-1.3739974473061137d+2*t141*t63*t65+9.570780000
     =         627304d+0*t144*t23*t65+1.3739974473061137d+2*t141*t142*t2
     >         1*t65+t21*t23*(-9.570780000627304d+0*t144*t21*t63*t64-1.3
     ?         739974473061137d+2*t141*t63*t64+9.570780000627304d+0*t144
     @         *t23*t64+1.3739974473061137d+2*t141*t142*t21*t64+t21*t23*
     1         (1.0634200000697003d+0*t21*t24*t265*t63-9.159982982040756
     2         d+1*t143*t24*t63-1.0634200000697003d+0*t23*t24*t265-6.575
     3         11364479516d+2*t21*t217*t24*t264+6.57511364479516d+2*t142
     4         *t24*t264+9.159982982040756d+1*t142*t143*t21*t24)-1.43561
     5         70000940957d+1*t145*t21*t62*t63+1.0634200000697003d+0*t21
     6         *t25*t265*t63-9.159982982040756d+1*t143*t25*t63+1.4356170
     7         000940957d+1*t145*t23*t62-1.0634200000697003d+0*t23*t25*t
     8         265-6.57511364479516d+2*t21*t217*t25*t264+6.5751136447951
     9         6d+2*t142*t25*t264+9.159982982040756d+1*t142*t143*t21*t25
     :         )-1.4356170000940957d+1*t146*t21*t62*t63+1.06342000006970
     ;         03d+0*t21*t26*t265*t63-9.159982982040756d+1*t143*t26*t63+
     <         1.4356170000940957d+1*t146*t23*t62-1.0634200000697003d+0*
     =         t23*t26*t265-6.57511364479516d+2*t21*t217*t26*t264+6.5751
     >         1364479516d+2*t142*t26*t264+9.159982982040756d+1*t142*t14
     ?         3*t21*t26)-1.4356170000940957d+1*t147*t21*t62*t63+1.06342
     @         00000697003d+0*t21*t265*t27*t63-9.159982982040756d+1*t143
     1         *t27*t63+1.4356170000940957d+1*t147*t23*t62-1.06342000006
     2         97003d+0*t23*t265*t27-6.57511364479516d+2*t21*t217*t264*t
     3         27+6.57511364479516d+2*t142*t264*t27+9.159982982040756d+1
     4         *t142*t143*t21*t27)-1.4356170000940957d+1*t148*t21*t62*t6
     5         3+1.0634200000697003d+0*t21*t265*t28*t63-9.15998298204075
     6         6d+1*t143*t28*t63+1.4356170000940957d+1*t148*t23*t62-1.06
     7         34200000697003d+0*t23*t265*t28-6.57511364479516d+2*t21*t2
     8         17*t264*t28+6.57511364479516d+2*t142*t264*t28+9.159982982
     9         040756d+1*t142*t143*t21*t28)-1.4356170000940957d+1*t149*t
     :         21*t62*t63+1.0634200000697003d+0*t21*t265*t29*t63-9.15998
     ;         2982040756d+1*t143*t29*t63+1.4356170000940957d+1*t149*t23
     <         *t62-1.0634200000697003d+0*t23*t265*t29-6.57511364479516d
     =         +2*t21*t217*t264*t29+6.57511364479516d+2*t142*t264*t29+9.
     >         159982982040756d+1*t142*t143*t21*t29)-1.4356170000940957d
     ?         +1*t150*t21*t62*t63+1.0634200000697003d+0*t21*t265*t30*t6
     @         3-9.159982982040756d+1*t143*t30*t63+1.4356170000940957d+1
     1         *t150*t23*t62-1.0634200000697003d+0*t23*t265*t30-6.575113
     2         64479516d+2*t21*t217*t264*t30+6.57511364479516d+2*t142*t2
     3         64*t30+9.159982982040756d+1*t142*t143*t21*t30)-1.43561700
     4         00940957d+1*t151*t21*t62*t63+1.0634200000697003d+0*t21*t2
     5         65*t31*t63-9.159982982040756d+1*t143*t31*t63+1.4356170000
     6         940957d+1*t151*t23*t62-1.0634200000697003d+0*t23*t265*t31
     7         -6.57511364479516d+2*t21*t217*t264*t31+6.57511364479516d+
     8         2*t142*t264*t31+9.159982982040756d+1*t142*t143*t21*t31)-1
     9         .4356170000940957d+1*t152*t21*t62*t63+1.0634200000697003d
     :         +0*t21*t265*t32*t63-9.159982982040756d+1*t143*t32*t63+1.4
     ;         356170000940957d+1*t152*t23*t62-1.0634200000697003d+0*t23
     <         *t265*t32-6.57511364479516d+2*t21*t217*t264*t32+6.5751136
     =         4479516d+2*t142*t264*t32+9.159982982040756d+1*t142*t143*t
     >         21*t32)-1.4356170000940957d+1*t153*t21*t62*t63+1.06342000
     ?         00697003d+0*t21*t265*t33*t63-9.159982982040756d+1*t143*t3
     @         3*t63+1.4356170000940957d+1*t153*t23*t62-1.06342000006970
     1         03d+0*t23*t265*t33-6.57511364479516d+2*t21*t217*t264*t33+
     2         6.57511364479516d+2*t142*t264*t33+9.159982982040756d+1*t1
     3         42*t143*t21*t33)-1.4356170000940957d+1*t154*t21*t62*t63+1
     4         .0634200000697003d+0*t21*t265*t34*t63-9.159982982040756d+
     5         1*t143*t34*t63+1.4356170000940957d+1*t154*t23*t62-1.06342
     6         00000697003d+0*t23*t265*t34-6.57511364479516d+2*t21*t217*
     7         t264*t34+6.57511364479516d+2*t142*t264*t34+9.159982982040
     8         756d+1*t142*t143*t21*t34)+t186*(-3.1090690869654886d-2*rh
     9         ob*t113*t205*t61-1.5545345434827443d-2*t187*t61-t113*t206
     :         -1.5545345434827443d-2*rhob*t100*t187)+3.1090690869654886
     ;         d-2*rhob*t113**3*t275*t61+4.6636036304482326d-2*t185*t48+
     <         1.0d+0*rhob*t274*t35+3.0d+0*t174*t35+3.0d+0*t155*t19)*wgh
     =         t+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*(t101*(1.5545345434827443d-2
     1         *rhob*t61*(-2.1622114952063792d-1*gammabb*t108*t37*t42*(-
     2         1.1227750021070412d+2*gammabb*t102*t110*t111*t38*t89+2.54
     3         5364099445864d+0*gammabb*t188*t201*t44-7.272468855559613d
     4         -2*gammabb*t110*t189*t44-7.738478514913824d+2*gammabb*t11
     5         1*t114*t190*t38+1.2029732165432584d+1*gammabb*t111*t114*t
     6         174*t38+t302+t301+t300+t299+t298+t297+2.3215435544741472d
     7         +3*gammabb*t114*t190*t191*t200)-8.408600259135923d-2*t103
     8         *t189*t42*t46+1.765806054418543d+0*t114*t188*t42*t46+3.81
     9         8046149168795d-1*gammabb*t188*t201*t40*t46-1.818117213889
     :         9032d-2*gammabb*t110*t189*t40*t46+2.1622114952063792d-1*g
     ;         ammabb*(t302+t301+t300+t299+t298+t297)*t37*t46+2.16221149
     <         52063792d-1*t199*t37*t46-1.0090320310963104d+0*gammabb*t1
     =         02*t103*t209*t46-1.0090320310963104d+0*t102*t103*t107*t46
     >         -1.2973268971238278d+0*gammabb*t115*t204*t296*t37*t42+8.6
     ?         48845980825517d-1*gammabb*t112*t203*t210*t37*t42+4.324422
     @         9904127585d-1*t203*t204*t37*t42+4.3244229904127585d-1*gam
     1         mabb*t115*t202*t203*t37*t42-2.1622114952063792d-1*t108*t2
     2         02*t37*t42+1.0090320310963104d+0*gammabb*t102*t103*t108*t
     3         210*t42-2.0180640621926207d+0*gammabb*t102*t103*t112*t115
     4         *t203*t42+8.408600259135923d-2*gammabb*t103*t108*t115*t18
     5         9*t42-1.765806054418543d+0*gammabb*t108*t114*t115*t188*t4
     6         2+1.0090320310963104d+0*t102*t103*t108*t112*t42+9.3503171
     7         00005212d-2*gammabb*t114*t203*t204*t40-4.675158550002606d
     8         -2*gammabb*t108*t114*t202*t40+2.181740656667883d-1*gammab
     9         b*t102*t108*t110*t112*t40-4.3244229904127585d-1*gammabb*t
     :         107*t108*t210*t37-4.3244229904127585d-1*gammabb*t108*t112
     ;         *t209*t37+8.648845980825517d-1*gammabb*t107*t112*t115*t20
     <         3*t37-2.1622114952063792d-1*gammabb*t108*t115*t199*t37-4.
     =         3244229904127585d-1*t107*t108*t112*t37+1.0090320310963104
     >         d+0*gammabb*t102*t103*t107*t108*t115)+3.1090690869654886d
     ?         -2*t211*t61+3.1090690869654886d-2*rhob*t100*t211+1.554534
     @         5434827443d-2*rhob*t116*t185+3.1090690869654886d-2*t100*t
     1         116)+t186*(-3.1090690869654886d-2*rhob*t113*t211*t61-t116
     2         *t206)+3.1090690869654886d-2*rhob*t116*t187*t275*t61)*wgh
     3         t+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*(t101*(1.5545345434827443d-
     1         2*rhob*t61*(-2.1622114952063792d-1*gammabb*t108*t37*t42*(
     2         1.2029732165432584d+1*t111*t114*t38*t89-4.363481313335766
     3         d-1*t102*t110*t44)-2.181740656667883d-1*t102*t110*t40*t46
     4         +4.3244229904127585d-1*t209*t37*t46+4.7173847274064107d-2
     5         *gammabb*t102*t108*t295*t42*t44+4.0434726234912094d-2*gam
     6         mabb*t112*t201*t203*t42*t44-2.0217363117456047d-2*gammabb
     7         *t107*t108*t201*t44-1.2973268971238278d+0*gammabb*t112*t2
     8         14*t296*t37*t42+8.648845980825517d-1*gammabb*t115*t203*t2
     9         10*t37*t42-4.3244229904127585d-1*t108*t210*t37*t42+8.6488
     :         45980825517d-1*t112*t115*t203*t37*t42-1.0090320310963104d
     ;         +0*gammabb*t102*t103*t203*t214*t42+1.0090320310963104d+0*
     <         t102*t103*t108*t115*t42-9.350317100005212d-2*gammabb*t108
     =         *t114*t210*t40+1.8700634200010424d-1*gammabb*t112*t114*t1
     >         15*t203*t40+2.181740656667883d-1*gammabb*t102*t108*t110*t
     ?         115*t40-9.350317100005212d-2*t108*t112*t114*t40+4.3244229
     @         904127585d-1*gammabb*t107*t203*t214*t37-4.324422990412758
     1         5d-1*gammabb*t108*t115*t209*t37-4.3244229904127585d-1*t10
     2         7*t108*t115*t37)+1.5545345434827443d-2*t215*t61+1.5545345
     3         434827443d-2*rhob*t100*t215)+t186*(-1.5545345434827443d-2
     4         *rhob*t113*t215*t61-1.5545345434827443d-2*rhob*t116*t211*
     5         t61-t116*t212)+3.1090690869654886d-2*rhob*t113*t213*t275*
     6         t61)*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.5545345434827443d-2*rhob*t101*(
     1         1.2130417870473628d-1*gammabb*t115*t201*t203*t42*t44-6.06
     2         5208935236814d-2*t108*t201*t42*t44-1.2973268971238278d+0*
     3         gammabb*t115**3*t296*t37*t42+1.2973268971238278d+0*t203*t
     4         214*t37*t42+2.8050951300015636d-1*gammabb*t114*t203*t214*
     5         t40-2.8050951300015636d-1*t108*t114*t115*t40-1.3114264480
     6         597482d-2*gammabb*t108*t111/t36**8.0d+0)*t61*wght+3.10906
     7         90869654886d-2*rhob*t116**3*t275*t61*wght-4.6636036304482
     8         326d-2*rhob*t116*t186*t215*t61*wght+Cmat3(iq,D3_GBB_GBB_G
     9         BB)
            Mmat3(iq,D3_RB_RB_TA) = t304+Mmat3(iq,D3_RB_RB_TA)
            Mmat3(iq,D3_RB_RB_TB) = t304+Mmat3(iq,D3_RB_RB_TB)
            Mmat3(iq,D3_RB_GBB_TA) = t305+Mmat3(iq,D3_RB_GBB_TA)
            Mmat3(iq,D3_RB_GBB_TB) = t305+Mmat3(iq,D3_RB_GBB_TB)
            Mmat3(iq,D3_GBB_GBB_TA) = t306+Mmat3(iq,D3_GBB_GBB_TA)
            Mmat3(iq,D3_GBB_GBB_TB) = t306+Mmat3(iq,D3_GBB_GBB_TB)
            Mmat3(iq,D3_RB_TA_TA) = t307+Mmat3(iq,D3_RB_TA_TA)
            Mmat3(iq,D3_RB_TA_TB) = t307+Mmat3(iq,D3_RB_TA_TB)
            Mmat3(iq,D3_RB_TB_TB) = t307+Mmat3(iq,D3_RB_TB_TB)
            Mmat3(iq,D3_GBB_TA_TA) = t308+Mmat3(iq,D3_GBB_TA_TA)
            Mmat3(iq,D3_GBB_TA_TB) = t308+Mmat3(iq,D3_GBB_TA_TB)
            Mmat3(iq,D3_GBB_TB_TB) = t308+Mmat3(iq,D3_GBB_TB_TB)
            Mmat3(iq,D3_TA_TA_TA) = t309+Mmat3(iq,D3_TA_TA_TA)
            Mmat3(iq,D3_TA_TA_TB) = t309+Mmat3(iq,D3_TA_TA_TB)
            Mmat3(iq,D3_TA_TB_TB) = t309+Mmat3(iq,D3_TA_TB_TB)
            Mmat3(iq,D3_TB_TB_TB) = t309+Mmat3(iq,D3_TB_TB_TB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
