# Version 2024.2.0

```{note}
The changelog is available at [https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md](https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md)
```

## Highlights

This section highlights some of the available [features](features.md).


### New fast reconstruction method

This new version ships a faster-than-FBP method for reconstruction:  `HierarchicalBackprojector`, from `nabu.reconstruction.hbp`.
It works by applying FBP recursively on sub-images, in a "divide-and-conquer" scheme.
This will yield an approximate reconstruction, but the accuracy is usually enough for most cases.
It's typically 5-10X faster to reconstruct huge slices.

In the configuration file, it can be used with `method = HBP` in the `[reconstruction]` section.


### Cone-beam reconstruction

There are various improvements for the cone-beam reconstruction (used with `method = cone` in `[reconstruction]` section):
  - Filters other than "ramlak" can now be used
  - Advanced options like padding mode, horizontal translations, slice ROI... are now supported
  - It provides results consistent with FBP regarding scaling and angular convention


### New center of rotation estimator

A new center of rotation (CoR) estimator is available: `method = vo`,
using the method developed by Nghia Vo in [algotom](https://github.com/algotom/algotom).
This will make a fine addition to our (already large) collection.


### Miscellaneous improvements

  - VKFFT is now the default FFT implementation. This normally yields faster processing, with significantly lower memory footprint
  - New data readers (`NXTomoReader` and `EDFStackReader`) are now used by the full-field pipeline. They are simpler and more efficient.
  - Stitching:
    - Generalize pre-processing stitching. Create dedicated stitching for y-stitching on NXtomo(s).
    - Rework calculation of final position


## Fixes

  - Fix `translation_movements_file` when used alongside projections subsampling
  - Fix radios rotation when reconstructing only one slice
  - Fix crash when `method = none` in `[reconstruction]` (i.e don't do the reconstruction, only pre-process the data)
  - Many fixes for cone-beam pipeline (see above)

