# Version 2024.1.0

```{note}
The changelog is available at [https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md](https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md)
```

## Highlights

This section highlights some of the available [features](features.md).


### New sinogram-based rings correction methods

Two rings correction methods were added.

The first one is based on [the article](https://doi.org/10.1364/OE.26.028396) *Nghia T. Vo, Robert C. Atwood, and Michael Drakopoulos, "Superior techniques for eliminating ring artifacts in X-ray micro-tomography," Opt. Express 26, 28396-28412 (2018)*.
The reference implementation used is the one from Nghia Vo in [algotom](https://github.com/algotom/algotom), and the GPU implementation used is the one of [tomocupy](https://github.com/tomography/tomocupy).

In the configuration file, it can be used with `method = vo`


The second is a simple "mean subtraction" (or division) in the sinogram.
The mean of all projections is subtracted from each sinogram row, possibly bandpass-filtered (i.e `sinogram = sinogram - sinogram.sum(axis=0)` in the simplest case). This is roughly equivalent to "double flatfield" (though after phase retrieval in this case!). The bandpass filter tries to preserve the reconstruction quantitativeness (i.e not mess up the low frequencies).

In the configuration file, it can be used with `method = mean-subtraction` or `method = mean-division`.

### Center of rotation estimation

Two estimators were added:
  - `rotation_axis_position = fourier_angles`: contributed work from Valentin Valls
  - `rotation_axis_position = octave-accurate`: tentative re-implementation from the octave-fasttomo legacy system

In the NXTomo file, a coarse estimate from stage motor is sometimes available.
If present, the estimators `composite-coarse-to-fine` (also known as "near"), `sliding-window` and `fourier-angles` will automatically use it. More estimators should use this information in the future.


### Stitching

- Handle different shape of radios / volumes to be stitched - with alignment along axis 1 and / or 2
- Improve shift search


### Reconstruct from even/odd angles

In some cases it can be useful to reconstruct the data from only even-numbered or odd-numbered projections.
For example the denoiser `noise2inverse` needs to split the (reconstructed) data.

  - To reconstruct from only the even projections, use `projections_subsampling = 2` or `projections_subsampling = 2:0`.
  - To reconstruct from only the odd projections, use `projections_subsampling = 2:1`.


### Simpler usage of `exclude_projections`

Discarding projections from the dataset used to be quite difficult, as `exclude_projections` was expecting a text file containing the *indices* of projections. One had to look at the `image_key` values in NXTomo file and produce a text file.

Now, `exclude_projections` can be used in three ways:

  - `exclude_projections = indices = exclude_indices.txt`: Path to a text file with one integer per line. Each corresponding projection INDEX will be ignored. This is the former default.
  - `exclude_projections = angles = exclude_angles.txt` : Path to a text file with angle in DEGREES, one per line. The corresponding angles will be ignored.
  - `exclude_projections = angular_range = [a, b]` ignore angles belonging to angular range [a, b] in degrees, with b included.


## Fixes

  - `nabu-multicor`: fix extraneous folder being created for each HDF5 output
  - Unsharp mask: `sigma = 0` now disables unsharp mask in the configuration file
  - FBP: fix abrupt rounding of the slice position when using `centered_axis=True`.
  - Flat-field: fix crash when using `flatfield=force-compute` if files already exist
  - Double-flat-field: fix invalid values when using a filter (`dff_sigma`)