# Version 2023.2.0

```{note}
The changelog is available at [https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md](https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md)
```

## Highlights

This section highlights some of the available [features](features.md).


### Forward projector

A forward projector (Radon transform) is now available: `nabu.reconstruction.projection.Projector`.  
It is a Cuda implementation of the one in silx, which is itself based on the Joseph-line-model found in PyHST2.

Coupling nabu projector and backprojector enables to build iterative reconstruction methods with persistent arrays on GPU.


### Half-tomography reconstruction

Nabu changed (again!) its way of handling half-tomography (extended field-of-view) reconstruction.
Until 2023.2.0, a sinogram was built by stitching two "180 degrees sinograms".

This approach, though conceptually simpler, had many issues:
  - Center of rotation was somewhat tricky to define
  - Handling odd number of projections was cumbersome
  - Cannot use vertical translations

From 2023.2.0, the half-tomo reconstruction is done without any sinogram stitching, which solves the above problems.


### OpenCL backend for various components

Several components now have an OpenCL backend.
This entailed a refactoring that does not break the API.

Each processing class (eg. `SinoFilter`) now has
  - a base class (code factorization + reference numpy implementation),
  - a cuda backend (eg. `CudaSinoFilter`)
  - an opencl backend (eg. `OpenCLSinoFilter`).

The wrapping to Cuda and OpenCL are done thanks to pycuda and pyopencl, respectively.
Usually, large chunks of code can be factored into the base classes, thanks to the similarity of the API of pycuda and pyopencl.

  - General-purpose classes: `OpenCLKernel`, `OpenCLProcessing`, `OpenCLMemcpy2D`
  - Reconstruction-related classes: `OpenCLSinoMult`, `OpenCLPadding`, `OpenCLSinoFilter`, `OpenCLBackProjector`
  - Processing: `OpenCLUnsharpMask`
  - Utilities functions in nabu.opencl.utils: `get_opencl_devices()`, `allocate_texture()`, `check_textures_availability()`, `copy_to_texture()`

### `nabu-multicor` tool

The `nabu-multicor` tool enables to reconstruct the same slice(s) with varying centers of rotation (CoR).
This is useful to avoid launching many `nabu config.conf` commands (and much faster).


## Fixes

  - Reconstructing into single-frame files (EDF, Tiff, ...) does not produce extraneous folder anymore
