# Version 2023.1.0

```{note}
The changelog is available at [https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md](https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md)
```

## Highlights

This section highlights some of the available [features](features.md).


### Helical pipeline

Datasets acquired with a helical trajectory are now supported by nabu.
A dedicated pipeline has been created, and can be used with the `nabu-helical` command.

See also: [Helical reconstruction](helical.md)

### Full-volume cone-beam reconstruction

The full-field pipeline now supports full-volume reconstruction of cone-beam data. Use `method = cone` (instead of `fbp`) in `[reconstruction]`. 
This feature requires the astra toolbox to be installed, and is still not well-tested. 


### Volumes stitching

Nabu offers a new command, `nabu-stitching`, and a new API (`nabu.stitching`) for performing volumes stitching.
It can be used both in pre-processing (assemble projections) and post-processing (assemble reconstructed volumes).

See also: [Volumes stitching](apidoc/stitching.md)


### Improvements on full-field pipeline

The pipeline got a handful of improvements:
  - Fix `binning`, `binning_z` and `projections_subsampling` which were broken in many cases. These parameters can also be set to arbitrary values.
  - Fix processing margin when using vertical translations and/or CTF
  - Flats distortion correction now works on the GPU backend, but is still very slow
  - Allow to overwrite some metadata, ex. with `overwrite_metadata = energy=19kev; pixel_size = 1.6 micron` in `[dataset]`
  - Unsharp mask: add "imagej" mode to have an unsharp similar to the one of ImageJ
  - Add support for .vol output format (mimics the big binary file from PyHST2)
  - Configuration file now supports relative paths


