# Version 2022.2.0

```{note}
The changelog is available at [https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md](https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md)
```

## Highlights

This section highlights some of the available [features](features.md).

### Partial support for cone-beam reconstruction

Nabu is now able to reconstruct volumes with a cone-beam geometry, using the astra toolbox under the hood.
Interestingly, the full volume does not need to fit in memory: reconstruction can be done by slabs, and the geometry is automatically recomputed for each slab.

This feature is not integrated yet in the pipeline, meaning it's not available yet in the configuration file.

### Volume casting

 This application is casting a user-provided volume to a given expected volume and an output data type.


### SRCurrent normalization

In principle, each frame is normalized as

$$
P' = \dfrac{P - D}{s/sMax} + D
$$

where $s$ is the synchrotron current for the current frame, $sMax$ is the max current, and $D$ is the dark frame.

However the electric current normalization is done during flat-field, lifting the need for knowing $sMax$:

$$
\dfrac{P' - D}{F' - D} = \dfrac{(P - D)/s_P}{(F - D)/s_F}
$$

where $s_P$ and $s_F$ are the electric current of projection $P$ and flat $F$, respectively.

Normalizing by the synchrotron current eventually boils down to multiply with $\frac{s_F}{s_P}$ after flat-field.


### Configuration templates

When generating a new configuration file with `nabu-config`, you can use templates with pre-filled parameters, depending on your beamline/use-case.
The syntax is `nabu-config --template <template_name>`. Built-in templates are `id19_pag`, `id16_ctf`, `id16_holo`.

You can also define your own templates: simply save a configuration file in a directory, and use this directory in the `NABU_TEMPLATES_DIR` environment variable:

`NABU_TEMPLATES_DIR="/home/me/nabu_config_templates" nabu-config --template mytemplate`


## Fixes

  - Improve handling of user-defined values through text file, eg. angles_file
  - NaN support in flat-field
  - horizontal/vertical translation in pipeline
  - Improve results of the "composite-sino-coarse-to-fine" (aka "near") CoR estimator.

