# Version 2022.1.0

```{note}
The changelog is available at [https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md](https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md)
```

## Highlights

This section highlights some of the available [features](features.md).

### Full-field pipelines can now work without GPU

In some cases, it's useful to run a reconstruction without GPU.
Both "chunked and "full-radio" pipelines now support CPU-only reconstruction. Of course, overall processing will be slower, especially reconstruction.

Many of pipeline steps using the numpy backend are multi-threaded by default.

### New FBP filters

In the pipeline, the filtered backprojection (FBP) reconstruction method can now use other filter than the default `ramlak`.
Possible values are: shepp-logan, cosine, hamming, hann, tukey, lanczos.

## Changes

### Configuration file

Some usability improvements:

  - `rotation_axis_position` is now set to `sliding-window` by default. In half tomography, the option `side="right"` is automatically set.
  - `overwrite_results` is set to `True` by default.
  - `padding_mode` is set to `edges` for FBP by default.

## Fixes

  - Reconstruction was sometimes stuck at "Allocating recs". Nabu now avoids allocating more than 17 GB memory to prevent (py)cuda to freeze.
  - Speed-up partial files write by omitting metadata in them. The metadata is kept only for the final master file.
  - Fix cuda FBP scale factor