# Version 2021.1.0


Version 2021.1.0 is a major version bringing many new features.

```{note}
The changelog is available at https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md
```

## Highlights

This section highlights some of the available [features](features.md).

### Sinogram-based center of rotation estimation

  The Center of Rotation (CoR) can now be estimated from a sinogram, instead of two full projections. **This will only work for 360 degrees scans (not 180 degrees).**
  To enable CoR estimation from a sinogram, the new parameter `cor_slice` has to be set to a number. This number specifies that the CoR estimation should be done on the sinogram corresponding to this slice number.
  A new CoR finding method is also available: `rotation_axis_position = sino-coarse-to-fine`. This method only works on (360 deg) sinograms.

### Projections rotation and detector tilt auto-detection

The nabu pipeline can now rotate the projections on the fly, with the parameter `rotate_projections`. It can be useful to correct the effects of a detector tilt, or certain rotation axis tilt in some cases.
A new command-line interface tool `nabu-rotate` is also available.

Nabu can now attempt at estimating the detector tilt, if any. If a tilt is detected, then the projection images will be rotated by the found angle value.
The parameters in configuration file are `tilt_correction` and `autotilt_options` in `[preproc]`.

### Double flat-field CLI tool

  In some cases, double flatfield is not computed correctly.  A new command-line interface tool `nabu-double-flatfield` is now available. It can be used to generate a double flatfield file, which can then be used in `processes_file` in the configuration file for double flat-field.

### Save and resume from sinograms

  It is now possible to save arbitrary processing steps, and to resume the processing pipeline from a saved step.  This should dramatically speed up the process of "reconstructing - editing configuration - reconstructing - etc".
In the new section `[pipeline]`, there are two corresponding options `save_steps` and `resume_from_step`.
For example, to set a check point to the "sinogram" generation, set `save_steps = sinogram`.

Both `save_steps` and `resume_from_step` can be specified at the same time.  If the file is not found, then all the processing is done in normal mode, and the steps are saved to the file. Otherwise, the pipeline resumes from the step. The file where data is dumped can be specified with the parameter `steps_file`.

### Sinogram-based rings artefacts removal

A new rings artefacts removal technique has been added. It is the implementation of Munch Et Al. Fourier-Wavelets destripping method.  The parameters in configuration file are `sino_rings_correction` and `sino_rings_options`.

### CTF phase retrieval

A new single-distance phase retrieval method is available: CTF.  If used, it triggers the use of a new processing pipeline (more details below).
Additional parameters in configuration file are `ctf_geometry`, `ctf_translations_file` and `ctf_advanced_params` in `[phase]`.

### Flats distortion correction

Added support for flats distortion correction. If activated, each radio is correlated with its corresponding flat, in order to determine and correct the flat distortion.
  This is currently quite slow (many correlations).

The parameters in configuration file are `flat_distortion_params` and `flat_distortion_correction_enabled` in `[preproc]`.


### New processing pipeline (CPU only !)

  In some cases, the processing has to be done on the whole projection image, rather than a part of it.  For example, the CTF filter spans the entire image support. This contrast with the approach used by nabu up to now : radios were processed by parts, and then the results were merged.
  Nabu now offers a new pipeline which can process "full images", enabling the use of CTF and images rotation.  Mind that for now, **only the CPU backend of this pipeline is available**, so it might be slow compared to the existing pipeline.

### EDF output format

Nabu can now output single-frame EDF files with `file_format = edf` in `[output]`

