# Version 2020.4.0


Version 2020.4.0 adds a number of features, notably command line tools for manipulating datasets.

```{note}
The changelog is available at https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md
```

## Highlights

This section highlights some of the available [features](features.md).

### Fully automatic center of rotation estimation

Various methods exist for estimating automatically the center of rotation (CoR). Nabu had one, but it did not work for half tomography acquisitions. Another method is now available and should work with any kind of acquisition.

The paramater is `rotation_axis_position` (in section`[reconstruction]`), the value can be:
  - A number (known CoR)
  - Empty: the CoR is set to the middle of the detector
  - `centered` (was `auto`): this searches for a CoR around the center, but does not work for half-acquisition
  - `global`: new method, should return a CoR in any setting.


### Histograms

Nabu can now compute a histogram of the reconstructed volume. This histogram can serve for further volume processing (conversion to uint16 for example). The computation is done while the data is still in memory to avoid extraneous disk reads/writes.
The option is available in a new section `[postproc]` with the parameter `output_histogram = 1`.

A command line tool is also available to merge the histogram of multiple volumes: `nabu-histogram <file1> <file2> ... <output>`.

### Use darks/flats from another dataset

Sometimes, flats cannot be acquired properly during an acquisition. In order to still have the ability to reconstruct the data, a common workaround is to use flats from another dataset.

Suppose you want to reconstruct a dataset which does not have flats/darks. In this case, nabu will detect that these images are missing and won't do flat-field correction. However you can force the flat-field normalization with `flatfield_enabled = forced` in the `[preproc]` section, and by providing `processes_file = /path/to/nabu_processes.h5`. This `nabu_processes.h5` file (or `tomwer_processes.h5`) can be generated either by tomwer or nabu.

### Sinogram normalization

A sinogram normalization is now available in the section `[preproc]` : `sino_normalization = chebyshev`.  If enabled, each line of the sinogram undergoes a baseline removal. This can be useful to correct a "refill" taking place during the scan. See [this discussion](https://gitlab.esrf.fr/tomotools/nabu/-/issues/118#note_74284) for more details.

### Split a NXTomo file by "z series"

Z-series is the name given to a multi-stage scan, i.e scanning a volume in several stages by moving the sample vertically after each stage (this is different from helical tomography).

For the time being, the CLI tool `nxtomomill` merges everything in a single file.
Projections have a varying "z" identified by the `entry/sample/z_translation` key (in conformity to the Nexus-Tomo standard).

The command line tool `nabu-zsplit` enables to split a file into distinct "z" to reconstruct each volume individually.

```{warning}
This is a temporary solution. This will be natively be handled by nxtomomill in the future.
```
