# Version 2020.2.0


Version 2020.2.0 is a "preview" of a major release foreseen for September 2020. It brings new features since 2020.1.0.

```{note}
The changelog is available at https://gitlab.esrf.fr/tomotools/nabu/-/blob/master/CHANGELOG.md
```

## Highlights

This section highlights some of the available [features](features.md).

### Binning

For a quick reconstruction, you can perform binning on the data. There are three parameters in the  configuration file:
  - `binning`: binning in the horizontal direction. Each reconstructed slice will have its dimensions divided by this factor. For now only factors 2 and 3 are supported.
  - `binning_z`: binning in the vertical direction. The number of reconstructed slices will be divided by this number. For now only factors 2 and 3 are supported.
  - `projections_subsampling`: read one projection out of 2 or 3. This accelerates the processing but results in lower quality data.

### Automatic center of rotation estimation

The default `rotation_axis_position` value (if left blank) is half of the detector width. The value `rotation_axis_position = auto` can now be provided, so that the value will be automatically estimated.

In the current version, automatic estimation lacks robustness and does not work for half tomography.

### Half tomography

Half tomography reconstruction is supported by setting  the parameter `enable_halftomo` to 1.

### Double flat-field

[Double flat-field](features.md#double-flat-field) is a projections-based rings artefacts removal. The relevant configuration key is `double_flatfield_enabled`.


## Foreseen developments


Most of the following foreseen developments should materialize for "September Milestone".

### Input/output
  - "merge" HDF5 reconstructions by creating a master file
  - Allow other formats than HDF5 (ex. tiff, jp2k, npy)
  - Enable to dump intermediate results (pre-processed radios/sinograms) and run the processing from a previous intermediate result
  - Generate flats/darks instead of relying on a `tomwer_processes.h5` file

### Reconstruction

  - Determine the minimum number of detector rows to read ("Paganin margin")
  - Reconstruction with overlapping vertical regions for phase retrieval
  - More robust Center of Rotation estimation methods (notably for half-tomography)
  - Sample/detector shifts. This is theoretically already implemented, but real datasets for tests are missing.
  - Sinogram normalization (background subtraction)
  - Iterative reconstruction (need a forward projector implementation)

### Computations distribution

Distributing the computation will be a crucial feature of Nabu.
  - Distribution on the local machine
  - Distribution on the computing cluster (via the SLURM task dispatcher)



