/* Gstreamer
 * Copyright (C) 2013-2014 Intel Corporation
 *    Author: Halley Zhao <halley.zhao@intel.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <gst/check/gstcheck.h>
#include <gst/codecparsers/gstvp8parser.h>

/* A key frame data */
static const guint8 vp8_frame_data_0[] = {
  0x50, 0x1d, 0x00, 0x9d, 0x01, 0x2a, 0xb0, 0x00, 0x90, 0x00, 0x00, 0x07,
  0x08, 0x85, 0x85, 0x88, 0x85, 0x84, 0x88, 0x02, 0x02, 0x03, 0x55, 0xd2,
  0x82, 0xf1, 0x8e, 0xd1, 0x00, 0x13, 0xee, 0x83, 0x17, 0x70, 0xd0, 0xf8,
  0x34, 0xdc, 0x9e, 0x9a, 0x6f, 0x7a, 0x6b, 0xb0, 0x26, 0x33, 0xf7, 0xe1,
  0xba, 0x59, 0xef, 0x1e, 0x97, 0xe6, 0xc4, 0x4e, 0x49, 0x72, 0x22, 0x6d,
  0x72, 0x1a, 0xeb, 0x53, 0x48, 0x32, 0x3a, 0x22, 0x44, 0x5a, 0x61, 0xc5,
  0x1f, 0xd8, 0xb2, 0xf3, 0x3c, 0xb6, 0x40, 0x7b, 0x7b, 0x83, 0x74, 0xb8,
  0x56, 0xfb, 0xdc, 0xac, 0x00, 0x01, 0x55, 0xfc, 0x9d, 0xda, 0x9c, 0x5f,
  0xf0, 0xfe, 0x7a, 0xf1, 0xc4, 0x9a, 0xa9, 0x04, 0x0a, 0xfd, 0x51, 0xe2,
  0xca, 0x64, 0x57, 0xda, 0x5c, 0x0c, 0x16, 0x95, 0x54, 0x79, 0x48, 0xdc,
  0x2c, 0x26, 0xf9, 0x27, 0x52, 0x1f, 0xc2, 0xd6, 0x6e, 0xdc, 0xa6, 0xae,
  0x95, 0x02, 0xff, 0xaf, 0xa7, 0xdd, 0xa1, 0xb1, 0x7e, 0x03, 0x8d, 0x98,
  0x14, 0x6c, 0x80, 0x39, 0x86, 0x65, 0x13, 0x33, 0xad, 0xdc, 0x2e, 0x84,
  0xaa, 0xa8, 0xaa, 0xe4, 0x93, 0x10, 0x18, 0xca, 0x31, 0xe8, 0xa2, 0x1b,
  0x49, 0x9e, 0xc0, 0xe2, 0x94, 0xc6, 0x80, 0x70, 0xe0, 0xf8, 0x41, 0x91,
  0x92, 0xc4, 0xab, 0xf1, 0x46, 0xde, 0x8b, 0xfe, 0x3c, 0x3e, 0x2d, 0xc0,
  0xb4, 0x90, 0xc3, 0x62, 0xef, 0xc7, 0xfb, 0x8f, 0xe0, 0x13, 0x79, 0x0f,
  0x52, 0x64, 0xfb, 0x2b, 0x65, 0x17, 0x6f, 0x25, 0x2a, 0x9c, 0xfb, 0x98,
  0x86, 0xb4, 0x09, 0x8b, 0x37, 0x67, 0x54, 0x32, 0x7e, 0xcc, 0x07, 0xff,
  0xb4, 0x15, 0xd0, 0x11, 0x30, 0x2e, 0x0f, 0x12, 0xc9, 0xff, 0xfd, 0x9b,
  0x69, 0x44, 0x65, 0x60, 0xfe, 0xff, 0xab, 0x52, 0x8a, 0x9a, 0x31, 0xbd,
  0xcc, 0x8d, 0x1e, 0x31, 0x35, 0x8a, 0x27, 0x32, 0x9d, 0xd2, 0xca, 0xc8,
  0x26, 0x0a, 0xe2, 0x4a, 0x12, 0xba, 0x3b, 0x8b, 0x89, 0xa1, 0x3b, 0x05,
  0x54, 0x96, 0xcc, 0xe6, 0x6a, 0x56, 0x3e, 0xcd, 0xd6, 0x13, 0x46, 0x40,
  0x21, 0x64, 0x0b, 0xa3, 0xf9, 0x0a, 0x9a, 0xb4, 0x66, 0xe3, 0x5b, 0x36,
  0xea, 0x0a, 0x56, 0xbf, 0xf3, 0xac, 0x42, 0xcd, 0x7a, 0x36, 0xce, 0xc3,
  0x4b, 0x15, 0x6b, 0xdb, 0x6e, 0x23, 0x94, 0x69, 0x44, 0xd4, 0x42, 0x51,
  0x8f, 0x21, 0x41, 0x4a, 0x24, 0x15, 0x0d, 0xea, 0x3b, 0x5f, 0xdd, 0xc2,
  0xf1, 0x0f, 0x9b, 0x73, 0x49, 0x3e, 0x82, 0x16, 0x44, 0x77, 0x0f, 0x80,
  0x35, 0x04, 0x1a, 0x7f, 0xb3, 0x17, 0xac, 0xf9, 0x38, 0xc9, 0x57, 0x74,
  0xcd, 0x03, 0x95, 0xbb, 0xec, 0xe4, 0x53, 0x2a, 0x6f, 0xf1, 0x51, 0x12,
  0xd7, 0x78, 0xaf, 0x3a, 0x77, 0x86, 0x21, 0xfa, 0xa8, 0x05, 0x99, 0x9a,
  0xc8, 0x9b, 0x4e, 0x72, 0xc9, 0xd5, 0x75, 0x7e, 0x7f, 0x09, 0xdf, 0x02,
  0x70, 0x59, 0xc4, 0x28, 0x04, 0x88, 0x4f, 0x59, 0xe8, 0x30, 0xc9, 0x66,
  0xa2, 0x51, 0xef, 0x40, 0xc5, 0xbc, 0xac, 0x74, 0x03, 0xff, 0x6a, 0xb2,
  0xd4, 0x1a, 0x3b, 0x2c, 0x4a, 0x66, 0xa8, 0xed, 0x18, 0x62, 0x93, 0x4a,
  0xcb, 0x07, 0x86, 0x7b, 0x70, 0x0f, 0xb0, 0x5e, 0xa6, 0xdd, 0xe1, 0x1a,
  0x99, 0xd3, 0x2a, 0xf7, 0x98, 0x06, 0x93, 0xbf, 0xa7, 0x8e, 0x13, 0x50,
  0x44, 0xbc, 0xce, 0x36, 0x17, 0x1b, 0x1f, 0x15, 0xb3, 0x22, 0x3e, 0xd9,
  0x88, 0xe3, 0xa4, 0xa1, 0x60, 0xde, 0x37, 0x53, 0x0b, 0xbe, 0x0c, 0xe8,
  0xd0, 0xfa, 0xdd, 0x1f, 0xa6, 0xda, 0xf7, 0xb3, 0x97, 0x44, 0xf1, 0x23,
  0x29, 0xee, 0xbf, 0xf6, 0xf2, 0x1d, 0xd8, 0x58, 0x20, 0xd7, 0x77, 0xa6,
  0xf9, 0xb0, 0x6b, 0xcd, 0xda, 0x06, 0xc0, 0x2f, 0x50, 0x95, 0xc6, 0x07,
  0x2a, 0xbf, 0x46, 0x27, 0x59, 0x52, 0xc3, 0xc7, 0xe6, 0xd7, 0xcb, 0x00,
  0x53, 0x76, 0x3e, 0x44, 0x4f, 0xab, 0x4d, 0xbd, 0xff, 0x5d, 0xea, 0xf3,
  0xa9, 0x14, 0x0e, 0x4d, 0xb9, 0xe4, 0xde, 0x9e, 0xb0, 0xa7, 0xf1, 0x41,
  0x79, 0x30, 0xa4, 0xa8, 0x2e, 0xb5, 0x42, 0x40, 0x08, 0xf8, 0x00, 0xbf,
  0xdc, 0xe4, 0xe0, 0xff, 0x54, 0x1b, 0x34, 0xe2, 0xed, 0x2c, 0x03, 0x96,
  0x9e, 0xb9, 0xea, 0x6d, 0x46, 0xa9, 0x51, 0x6c, 0xff, 0xa2, 0xd1, 0x84,
  0x0b, 0xa9, 0xd5, 0xd2, 0xb5, 0x08, 0x62, 0x17, 0x7f, 0x5c, 0xcc, 0xdb,
  0x5c, 0x2b, 0xe1, 0x2a, 0x6d, 0x45, 0xf8, 0xf0, 0x32, 0x58, 0xb4, 0xc8,
  0x36, 0x2c, 0xa6, 0x1b, 0xc4, 0x87, 0x4d, 0x29, 0xe6, 0x2f, 0x3b, 0x2e,
  0xd2, 0x80, 0x75, 0xf9, 0x81, 0x22, 0x2e, 0x5e, 0x61, 0xf7, 0xac, 0xb0,
  0xb6, 0x35, 0xd8, 0x38, 0xa8, 0xf4, 0xef, 0xac, 0xe7, 0x3a, 0x87, 0xff,
  0x0d, 0x84, 0x94, 0x4c, 0x6d, 0x81, 0x01, 0xd0, 0x83, 0x65, 0x16, 0x57,
  0xb4, 0x6c, 0x8e, 0x00,
};

/* An inter frame data */
static const guint8 vp8_frame_data_1[] = {
  0x51, 0x0c, 0x00, 0x00, 0x10, 0x10, 0x00, 0x1e, 0xcb, 0x03, 0xdc, 0xc3,
  0xed, 0xef, 0x1d, 0x30, 0xe3, 0x45, 0xc8, 0x86, 0xa6, 0xa4, 0x9c, 0x8e,
  0x72, 0xee, 0xae, 0x46, 0x79, 0x53, 0x58, 0x0b, 0x01, 0xb1, 0xf4, 0x06,
  0x5c, 0xc0, 0x18, 0xb8, 0x2b, 0xa0, 0x00, 0x3f, 0x06, 0x9a, 0x28, 0x55,
  0x3b, 0x5f, 0x2b, 0x02, 0x14, 0x03, 0x93, 0xdf, 0x09, 0xe3, 0x22, 0x23,
  0x53, 0xd3, 0xa8, 0x84, 0x34, 0x05, 0x0d, 0xec, 0xa9, 0x49, 0x72, 0xee,
  0x9f, 0x4a, 0x0e, 0xbe, 0x98, 0xbc, 0x01, 0x08, 0x9e, 0xd5, 0x6a, 0xb2,
  0x47, 0x0c, 0x19, 0xe0, 0x60, 0x3e, 0x3c, 0x75, 0xef, 0x65, 0xc6, 0x6c,
  0x4f, 0xdb, 0x05, 0x38, 0x40, 0xfd, 0xe0, 0x05, 0x6b, 0xb5, 0x02, 0xc3,
  0xeb, 0x8e, 0x18, 0x64, 0xf9, 0xe7, 0x7c, 0x98, 0x43, 0x2a, 0x5a, 0x80,
  0xfb, 0xea, 0x20, 0x08, 0x98, 0x56, 0x73, 0x16, 0x26, 0x38, 0x5f, 0x3a,
  0x7b, 0x7e, 0xf3, 0x0f, 0xe3, 0xbb, 0xa8, 0x76, 0x58, 0xbc, 0xb6, 0xfd,
  0xa2, 0x66, 0xdb, 0xff, 0x84, 0x61, 0x29, 0xf4, 0x93, 0x23, 0x7e, 0x78,
  0x4c, 0x1c, 0x31, 0x45, 0xb4, 0x1a, 0xa7, 0x0e, 0x1c, 0xaa, 0x7a, 0xdd,
  0x85, 0xda, 0xe5, 0xa8, 0x92, 0xca, 0x81, 0xac, 0x72, 0x5d, 0xa1, 0x12,
  0x18, 0xf9, 0xee, 0xfd, 0x31, 0xf3, 0xdf, 0x4b, 0x87, 0x75, 0x80, 0x2c,
  0x12, 0x03, 0xb6, 0x1f, 0x08, 0x3c, 0x7b, 0x32, 0x89, 0xe1, 0xae, 0xa6,
  0x41, 0x43, 0x4d, 0xd6, 0xbb, 0x0d, 0x9c, 0x9d, 0x36, 0x35, 0xc5, 0xa7,
  0xf8, 0xec, 0x18, 0xd2, 0x12, 0x9b, 0x90, 0x84, 0x9c, 0xd8, 0x92, 0x7e,
  0xe9, 0xba, 0x97, 0x53, 0x53, 0xcb, 0x07, 0xda, 0x81, 0xd0, 0x5f, 0xd6,
  0x87, 0x94, 0x64, 0xb9, 0xca, 0x33, 0x2c, 0xb8, 0x14, 0x04, 0x13, 0xe4,
  0x1b, 0xe3, 0xb5, 0x1f, 0xcb, 0xfc, 0xf1, 0x79, 0xc6, 0xc6, 0x32, 0xcf,
  0x28, 0x2e, 0x05, 0x8a, 0xe4, 0x57, 0x08, 0x23, 0xd7, 0x31, 0xef, 0x81,
  0x8a, 0x0a, 0xab, 0x2e, 0x80, 0x1e, 0x4a, 0x95, 0x78, 0x69, 0xed, 0xf6,
  0x00, 0x55, 0x5c, 0x38, 0x1f, 0x8c, 0xd9, 0x6e, 0x6c, 0x1e, 0xce, 0x1c,
  0xa4, 0xf9, 0x1d, 0xff, 0xe6, 0xcd, 0x66, 0xc3, 0x35, 0xe8, 0x84, 0xd7,
  0xe4, 0xac, 0xbf, 0x5b, 0x6f, 0x32, 0x7e, 0x55, 0x66, 0xb2, 0xa8, 0x1e,
  0x8b, 0xcb, 0x70, 0xcf, 0xa1, 0x63, 0xd4, 0xa8, 0xb1, 0xc0, 0x1f, 0xa6,
  0xbf, 0xcf, 0x6b, 0xaf, 0xb4, 0xbc, 0x38, 0x12, 0xbc, 0x1e, 0x72, 0x48,
  0x7d, 0xc9, 0xc9, 0xe9, 0x28, 0xd0, 0xcd, 0xe3, 0xf5, 0x45, 0x91, 0xad,
  0x7b, 0xba, 0x5b, 0x10, 0xd3, 0x85, 0xad, 0x49, 0x15, 0xf6, 0x89, 0x3e,
  0x50, 0x21, 0x18, 0xdc, 0x4e, 0xce, 0xbd, 0x6c, 0xe9, 0xa9, 0x40, 0xf3,
  0x78, 0x97, 0xf9, 0x71, 0xe0, 0x18, 0x32, 0xad, 0xac, 0xf8, 0x3f, 0x42,
  0xa7, 0x43, 0x2b, 0x32, 0xbd, 0xad, 0x77, 0xb5, 0x87, 0xf8, 0xe0, 0xfe,
  0x7e, 0x93, 0xb7, 0xfe, 0x40, 0x19, 0x29, 0x4e, 0x4b, 0x80, 0x77, 0x0f,
  0xa8, 0xc0, 0x17, 0xa1, 0xf1, 0xb8, 0x4f, 0x6c, 0xee, 0x08, 0xe6, 0x78,
  0x98, 0x45, 0x71, 0xbf, 0xea, 0xe9, 0x34, 0x3a, 0x49, 0x44, 0xc8, 0xb1,
  0x79, 0x5c, 0x14, 0x37, 0xf4, 0x77, 0xf8, 0x8f, 0xda, 0xe6, 0x8e, 0x6c,
  0x20, 0xf7, 0x75, 0x35, 0x8c, 0x43, 0x49, 0x21, 0x34, 0xb0, 0x19, 0x16,
  0x2f, 0x2b, 0x9a, 0x64, 0x8f, 0x39, 0x45, 0x9b, 0x7a, 0x27, 0x96, 0xc6,
  0x4d, 0x95, 0xdc, 0x03, 0x6c, 0xea, 0xea, 0x60, 0xa8, 0x16, 0xb4, 0x24,
  0xa6, 0x9a, 0x68, 0x49, 0xcb, 0xf2, 0x22, 0xb5, 0xda, 0x2d, 0xd2, 0x0c,
  0xad, 0x57, 0xba, 0x5a, 0x8d, 0xa0, 0x0a, 0x98, 0x31, 0x64, 0xad, 0x9a,
  0xa0, 0x6b, 0x40, 0xcd, 0x90, 0xba, 0x16, 0xc5, 0x22, 0x92, 0x70, 0x00,
  0x0e, 0xfd, 0x70, 0x4a, 0x48, 0x58, 0xa7, 0xe6, 0x1c, 0x4a, 0xc3, 0x07,
  0xe9, 0xe0, 0x39, 0x1e, 0x96, 0x38, 0x8c, 0x5e, 0xc1, 0x5b, 0x26, 0x43,
  0xd9, 0xc0,
};

GST_START_TEST (test_vp8_parse_key_frame)
{
  GstVp8Parser parser;
  GstVp8FrameHdr frame_hdr;
  GstVp8MbLfAdjustments *const adj = &parser.mb_lf_adjust;

  gst_vp8_parser_init (&parser);

  memset (&frame_hdr, 0, sizeof (frame_hdr));
  assert_equals_int (gst_vp8_parser_parse_frame_header (&parser, &frame_hdr,
          vp8_frame_data_0, sizeof (vp8_frame_data_0)), GST_VP8_PARSER_OK);

  assert_equals_int (frame_hdr.key_frame, 1);

  assert_equals_int (frame_hdr.first_part_size, 234);
  assert_equals_int (frame_hdr.width, 176);
  assert_equals_int (frame_hdr.height, 144);

  assert_equals_int (adj->loop_filter_adj_enable, 1);
  assert_equals_int (adj->mode_ref_lf_delta_update, 1);

  assert_equals_int (adj->ref_frame_delta[0], 2);
  assert_equals_int (adj->ref_frame_delta[1], 0);
  assert_equals_int (adj->ref_frame_delta[2], -2);
  assert_equals_int (adj->ref_frame_delta[3], -2);

  assert_equals_int (adj->mb_mode_delta[0], 4);
  assert_equals_int (adj->mb_mode_delta[1], -2);
  assert_equals_int (adj->mb_mode_delta[2], 2);
  assert_equals_int (adj->mb_mode_delta[3], 4);

  assert_equals_int (frame_hdr.quant_indices.y_ac_qi, 4);
  assert_equals_int (frame_hdr.mb_no_skip_coeff, 1);

  assert_equals_int (frame_hdr.rd_range, 0xe8);
  assert_equals_int (frame_hdr.rd_value, 0x68);
  assert_equals_int (frame_hdr.rd_count, 1);
}

GST_END_TEST;

GST_START_TEST (test_vp8_parse_inter_frame)
{
  GstVp8Parser parser;
  GstVp8FrameHdr frame_hdr;

  gst_vp8_parser_init (&parser);

  memset (&frame_hdr, 0, sizeof (frame_hdr));
  assert_equals_int (gst_vp8_parser_parse_frame_header (&parser, &frame_hdr,
          vp8_frame_data_0, sizeof (vp8_frame_data_0)), GST_VP8_PARSER_OK);

  memset (&frame_hdr, 0, sizeof (frame_hdr));
  assert_equals_int (gst_vp8_parser_parse_frame_header (&parser, &frame_hdr,
          vp8_frame_data_1, sizeof (vp8_frame_data_1)), GST_VP8_PARSER_OK);

  assert_equals_int (frame_hdr.key_frame, 0);

  assert_equals_int (frame_hdr.first_part_size, 98);

  assert_equals_int (parser.mb_lf_adjust.loop_filter_adj_enable, 1);
  assert_equals_int (frame_hdr.quant_indices.y_ac_qi, 4);

  assert_equals_int (frame_hdr.refresh_entropy_probs, 1);
  assert_equals_int (frame_hdr.refresh_last, 1);
  assert_equals_int (frame_hdr.mb_no_skip_coeff, 1);

  assert_equals_int (frame_hdr.prob_skip_false, 131);
  assert_equals_int (frame_hdr.prob_intra, 224);
  assert_equals_int (frame_hdr.prob_last, 233);
  assert_equals_int (frame_hdr.prob_gf, 1);

  assert_equals_int (frame_hdr.rd_range, 0x8e);
  assert_equals_int (frame_hdr.rd_value, 0x85);
  assert_equals_int (frame_hdr.rd_count, 5);
}

GST_END_TEST;

static Suite *
vp8parsers_suite (void)
{
  Suite *s = suite_create ("VP8 Parser library");

  TCase *tc_chain = tcase_create ("general");

  suite_add_tcase (s, tc_chain);
  tcase_add_test (tc_chain, test_vp8_parse_key_frame);
  tcase_add_test (tc_chain, test_vp8_parse_inter_frame);

  return s;
}

GST_CHECK_MAIN (vp8parsers);
