/*
 * src/coot-preferences.h
 *
 * Copyright 2008 by University of York
 * Author: Paul Emsley
 *
 * This file is part of Coot
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copies of the GNU General Public License and
 * the GNU Lesser General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA, 02110-1301, USA.
 * See http://www.gnu.org/licenses/
 *
 */

#define COOT_GENERAL_PREFERENCES           0
#define COOT_BOND_PREFERENCES              1
#define COOT_MAP_PREFERENCES               2
#define COOT_GEOMETRY_PREFERENCES          3
#define COOT_COLOUR_PREFERENCES            4
#define COOT_OTHER_PREFERENCES             5

#define PREFERENCES_FILE_CHOOSER                   0
#define PREFERENCES_FILE_OVERWRITE                 1
#define PREFERENCES_FILE_FILTER                    2
#define PREFERENCES_FILE_SORT_DATE                 3
#define PREFERENCES_ACCEPT_DIALOG_DOCKED           4
#define PREFERENCES_IMMEDIATE_REPLACEMENT          5
#define PREFERENCES_VT_SURFACE                     6
#define PREFERENCES_RECENTRE_PDB                   7
#define PREFERENCES_BONDS_THICKNESS                8
#define PREFERENCES_BOND_COLOUR_ROTATION_C_ONLY    9 
#define PREFERENCES_MAP_RADIUS                    10
#define PREFERENCES_MAP_ISOLEVEL_INCREMENT        11
#define PREFERENCES_DIFF_MAP_ISOLEVEL_INCREMENT   12
#define PREFERENCES_MAP_SAMPLING_RATE             13
#define PREFERENCES_DYNAMIC_MAP_SAMPLING          14
#define PREFERENCES_DYNAMIC_MAP_SIZE_DISPLAY      15
#define PREFERENCES_SWAP_DIFF_MAP_COLOURS         16
#define PREFERENCES_SMOOTH_SCROLL                 17
#define PREFERENCES_SMOOTH_SCROLL_STEPS           18
#define PREFERENCES_SMOOTH_SCROLL_LIMIT           19
#define PREFERENCES_MAP_DRAG                      20
#define PREFERENCES_MARK_CIS_BAD                  21
#define PREFERENCES_DEFAULT_B_FACTOR              43
#define PREFERENCES_BG_COLOUR                     22
#define PREFERENCES_ANTIALIAS                     23
#define PREFERENCES_CONSOLE_COMMANDS              24
#define PREFERENCES_REFINEMENT_SPEED              25
#define PREFERENCES_SPIN_SPEED                    26
#define PREFERENCES_BOND_COLOURS_MAP_ROTATION     27
#define PREFERENCES_FONT_SIZE                     28
#define PREFERENCES_FONT_COLOUR                   29
#define PREFERENCES_PINK_POINTER                  30
#define PREFERENCES_TIPS                          31
#define PREFERENCES_MODEL_TOOLBAR_SHOW            32
#define PREFERENCES_MODEL_TOOLBAR_POSITION        33
#define PREFERENCES_MODEL_TOOLBAR_STYLE           34
#define PREFERENCES_MODEL_TOOLBAR_ICONS           35
#define PREFERENCES_MAIN_TOOLBAR_SHOW             36
#define PREFERENCES_MAIN_TOOLBAR_POSITION         37
#define PREFERENCES_MAIN_TOOLBAR_STYLE            38
#define PREFERENCES_MAIN_TOOLBAR_ICONS            39
#define PREFERENCES_ACCEPT_DIALOG_DOCKED_SHOW     40
#define PREFERENCES_MAP_COLOURS_MAP_ROTATION      41
#define PREFERENCES_FONT_OWN_COLOUR_FLAG          42 // values -1: unset
                                                     //         0: no
                                                     //         1: yes

#define MODEL_TOOLBAR                              0
#define MAIN_TOOLBAR                               1

