// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_WM_DESKS_TEMPLATES_DESKS_TEMPLATES_ANIMATIONS_H_
#define ASH_WM_DESKS_TEMPLATES_DESKS_TEMPLATES_ANIMATIONS_H_

#include "base/callback_forward.h"
#include "base/callback_helpers.h"

namespace ui {
class Layer;
}  // namespace ui

namespace ash {

// Immediately shows `layer` if `animate` is false. Does a linear fade in of
// `layer` if `animate` is true.
void PerformFadeInLayer(ui::Layer* layer, bool animate);

// Immediately hides `layer` if `animate` is false. Does a linear fade out of
// `layer` if `animate` is true.
void PerformFadeOutLayer(ui::Layer* layer,
                         bool animate,
                         base::OnceClosure on_animation_ended_callback);

}  // namespace ash

#endif  // ASH_WM_DESKS_TEMPLATES_DESKS_TEMPLATES_ANIMATIONS_H_
