// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_WEBUI_OS_FEEDBACK_UI_OS_FEEDBACK_UNTRUSTED_UI_H_
#define ASH_WEBUI_OS_FEEDBACK_UI_OS_FEEDBACK_UNTRUSTED_UI_H_

#include <memory>

#include "ui/webui/untrusted_web_ui_controller.h"
#include "ui/webui/webui_config.h"

namespace content {
class WebUI;
}  // namespace content

namespace ash {
namespace feedback {

// Class that stores properties for the chrome-untrusted://os-feedback WebUI.
class OsFeedbackUntrustedUIConfig : public ui::WebUIConfig {
 public:
  OsFeedbackUntrustedUIConfig();
  ~OsFeedbackUntrustedUIConfig() override;

  std::unique_ptr<content::WebUIController> CreateWebUIController(
      content::WebUI* web_ui) override;
};

// WebUI for chrome-untrusted://os-feedback, intended to be used by the file
// manager when untrusted content needs to be processed.
class OsFeedbackUntrustedUI : public ui::UntrustedWebUIController {
 public:
  explicit OsFeedbackUntrustedUI(content::WebUI* web_ui);
  OsFeedbackUntrustedUI(const OsFeedbackUntrustedUI&) = delete;
  OsFeedbackUntrustedUI& operator=(const OsFeedbackUntrustedUI&) = delete;
  ~OsFeedbackUntrustedUI() override;
};

}  // namespace feedback
}  // namespace ash

#endif  // ASH_WEBUI_OS_FEEDBACK_UI_OS_FEEDBACK_UNTRUSTED_UI_H_
