// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_WEBUI_CAMERA_APP_UI_RESOURCES_H_
#define ASH_WEBUI_CAMERA_APP_UI_RESOURCES_H_

#include "ash/webui/camera_app_ui/resources/strings/grit/ash_camera_app_strings.h"

namespace ash {

// TODO(crbug.com/980846): Use camelCase for name instead after totally
// migrating to SWA.
const struct {
  const char* name;
  int id;
} kStringResourceMap[] = {
    {"aria_camera_mode_group", IDS_ARIA_CAMERA_MODE_GROUP},
    {"aria_grid_3x3", IDS_ARIA_GRID_3X3},
    {"aria_grid_4x4", IDS_ARIA_GRID_4X4},
    {"aria_record_type_group", IDS_ARIA_RECORD_TYPE_GROUP},
    {"aria_scan_type_group", IDS_ARIA_SCAN_TYPE_GROUP},
    {"back_button", IDS_BACK_BUTTON},
    {"barcode_copy_link_button", IDS_BARCODE_COPY_LINK_BUTTON},
    {"barcode_copy_text_button", IDS_BARCODE_COPY_TEXT_BUTTON},
    {"barcode_link_detected", IDS_BARCODE_LINK_DETECTED},
    {"barcode_text_detected", IDS_BARCODE_TEXT_DETECTED},
    {"camera_resolution_button", IDS_CAMERA_RESOLUTION_BUTTON},
    {"cancel_review_button", IDS_CANCEL_REVIEW_BUTTON},
    {"confirm_review_button", IDS_CONFIRM_REVIEW_BUTTON},
    {"delete_button", IDS_DELETE_BUTTON},
    {"delete_confirmation_msg", IDS_DELETE_CONFIRMATION_MSG},
    {"delete_multi_confirmation_msg", IDS_DELETE_MULTI_CONFIRMATION_MSG},
    {"description", IDS_DESCRIPTION},
    {"dialog_cancel_button", IDS_DIALOG_CANCEL_BUTTON},
    {"dialog_ok_button", IDS_DIALOG_OK_BUTTON},
    {"document_corner_move_desc", IDS_DOCUMENT_CORNER_MOVE_DESC},
    {"document_mode_dialog_got_it", IDS_DOCUMENT_MODE_DIALOG_GOT_IT},
    {"document_mode_dialog_msg", IDS_DOCUMENT_MODE_DIALOG_MSG},
    {"document_mode_dialog_intro_title", IDS_DOCUMENT_MODE_DIALOG_INTRO_TITLE},
    {"error_msg_camera_paused", IDS_ERROR_MSG_CAMERA_PAUSED},
    {"error_msg_empty_recording", IDS_ERROR_MSG_EMPTY_RECORDING},
    {"error_msg_file_system_failed", IDS_ERROR_MSG_FILE_SYSTEM_FAILED},
    {"error_msg_gallery_export_failed", IDS_ERROR_MSG_GALLERY_EXPORT_FAILED},
    {"error_msg_no_camera", IDS_ERROR_MSG_NO_CAMERA},
    {"error_msg_record_start_failed", IDS_ERROR_MSG_RECORD_START_FAILED},
    {"error_msg_save_file_failed", IDS_ERROR_MSG_SAVE_FILE_FAILED},
    {"error_msg_take_photo_failed", IDS_ERROR_MSG_TAKE_PHOTO_FAILED},
    {"error_msg_take_portrait_bokeh_photo_failed",
     IDS_ERROR_MSG_TAKE_PORTRAIT_BOKEH_PHOTO_FAILED},
    {"error_msg_video_too_short", IDS_ERROR_MSG_VIDEO_TOO_SHORT},
    {"expert_custom_video_parameters", IDS_EXPERT_CUSTOM_VIDEO_PARAMETERS},
    {"expert_enable_expert_mode", IDS_EXPERT_ENABLE_EXPERT_MODE},
    {"expert_enable_full_sized_video_snapshot",
     IDS_EXPERT_ENABLE_FULL_SIZED_VIDEO_SNAPSHOT},
    {"expert_multistream_recording", IDS_EXPERT_MULTISTREAM_RECORDING},
    {"expert_mode_button", IDS_EXPERT_MODE_BUTTON},
    {"expert_preview_metadata", IDS_EXPERT_PREVIEW_METADATA},
    {"expert_print_performance_logs", IDS_EXPERT_PRINT_PERFORMANCE_LOGS},
    {"expert_save_metadata", IDS_EXPERT_SAVE_METADATA},
    {"expert_scan_barcode", IDS_EXPERT_SCAN_BARCODE},
    {"export_button", IDS_EXPORT_BUTTON},
    {"feedback_button", IDS_FEEDBACK_BUTTON},
    {"feedback_description_placeholder", IDS_FEEDBACK_DESCRIPTION_PLACEHOLDER},
    {"gallery_button", IDS_GALLERY_BUTTON},
    {"gallery_images", IDS_GALLERY_IMAGES},
    {"grid_type_button", IDS_GRID_TYPE_BUTTON},
    {"help_button", IDS_HELP_BUTTON},
    {"label_30fps", IDS_LABEL_30FPS},
    {"label_60fps", IDS_LABEL_60FPS},
    {"label_back_camera", IDS_LABEL_BACK_CAMERA},
    {"label_crop_done", IDS_LABEL_CROP_DONE},
    {"label_current_and_maximal_record_time",
     IDS_LABEL_CURRENT_AND_MAXIMAL_RECORD_TIME},
    {"label_detail_photo_resolution", IDS_LABEL_DETAIL_PHOTO_RESOLUTION},
    {"label_document_bottom_left_corner",
     IDS_LABEL_DOCUMENT_BOTTOM_LEFT_CORNER},
    {"label_document_bottom_right_corner",
     IDS_LABEL_DOCUMENT_BOTTOM_RIGHT_CORNER},
    {"label_document_top_left_corner", IDS_LABEL_DOCUMENT_TOP_LEFT_CORNER},
    {"label_document_top_right_corner", IDS_LABEL_DOCUMENT_TOP_RIGHT_CORNER},
    {"label_external_camera", IDS_LABEL_EXTERNAL_CAMERA},
    {"label_fix_document", IDS_LABEL_FIX_DOCUMENT},
    {"label_front_camera", IDS_LABEL_FRONT_CAMERA},
    {"label_grid_3x3", IDS_LABEL_GRID_3X3},
    {"label_grid_4x4", IDS_LABEL_GRID_4X4},
    {"label_grid_golden", IDS_LABEL_GRID_GOLDEN},
    {"label_photo_resolution", IDS_LABEL_PHOTO_RESOLUTION},
    {"label_record_gif_video_option", IDS_LABEL_RECORD_GIF_VIDEO_OPTION},
    {"label_record_normal_video_option", IDS_LABEL_RECORD_NORMAL_VIDEO_OPTION},
    {"label_retake", IDS_LABEL_RETAKE},
    {"label_save", IDS_LABEL_SAVE},
    {"label_save_pdf_document", IDS_LABEL_SAVE_PDF_DOCUMENT},
    {"label_save_photo_document", IDS_LABEL_SAVE_PHOTO_DOCUMENT},
    {"label_scan_document_option", IDS_LABEL_SCAN_DOCUMENT_OPTION},
    {"label_scan_qrcode_option", IDS_LABEL_SCAN_QRCODE_OPTION},
    {"label_share", IDS_LABEL_SHARE},
    {"label_switch_record_video_button", IDS_LABEL_SWITCH_RECORD_VIDEO_BUTTON},
    {"label_switch_scan_mode_button", IDS_LABEL_SWITCH_SCAN_MODE_BUTTON},
    {"label_switch_take_photo_button", IDS_LABEL_SWITCH_TAKE_PHOTO_BUTTON},
    {"label_switch_take_portrait_bokeh_photo_button",
     IDS_LABEL_SWITCH_TAKE_PORTRAIT_BOKEH_PHOTO_BUTTON},
    {"label_switch_take_square_photo_button",
     IDS_LABEL_SWITCH_TAKE_SQUARE_PHOTO_BUTTON},
    {"label_timer_10s", IDS_LABEL_TIMER_10S},
    {"label_timer_3s", IDS_LABEL_TIMER_3S},
    {"label_video_resolution", IDS_LABEL_VIDEO_RESOLUTION},
    {"migrate_pictures_msg", IDS_MIGRATE_PICTURES_MSG},
    {"moving_in_bottom_direction", IDS_MOVING_IN_BOTTOM_DIRECTION},
    {"moving_in_bottom_left_direction", IDS_MOVING_IN_BOTTOM_LEFT_DIRECTION},
    {"moving_in_bottom_right_direction", IDS_MOVING_IN_BOTTOM_RIGHT_DIRECTION},
    {"moving_in_left_direction", IDS_MOVING_IN_LEFT_DIRECTION},
    {"moving_in_right_direction", IDS_MOVING_IN_RIGHT_DIRECTION},
    {"moving_in_top_direction", IDS_MOVING_IN_TOP_DIRECTION},
    {"moving_in_top_left_direction", IDS_MOVING_IN_TOP_LEFT_DIRECTION},
    {"moving_in_top_right_direction", IDS_MOVING_IN_TOP_RIGHT_DIRECTION},
    {"msg_document_detected", IDS_MSG_DOCUMENT_DETECTED},
    {"msg_processing_image", IDS_MSG_PROCESSING_IMAGE},
    {"name", IDS_NAME},
    {"new_control_navigation", IDS_NEW_CONTROL_NAVIGATION},
    {"new_control_toast", IDS_NEW_CONTROL_TOAST},
    {"new_document_scan_toast", IDS_NEW_DOCUMENT_SCAN_TOAST},
    {"no_document_guide_msg", IDS_NO_DOCUMENT_GUIDE_MSG},
    {"open_ptz_panel_button", IDS_OPEN_PTZ_PANEL_BUTTON},
    {"pan_left_button", IDS_PAN_LEFT_BUTTON},
    {"pan_right_button", IDS_PAN_RIGHT_BUTTON},
    {"photo_resolution_button", IDS_PHOTO_RESOLUTION_BUTTON},
    {"print_button", IDS_PRINT_BUTTON},
    {"ptz_reset_all_button", IDS_PTZ_RESET_ALL_BUTTON},
    {"record_gif_video_option", IDS_RECORD_GIF_VIDEO_OPTION},
    {"record_normal_video_option", IDS_RECORD_NORMAL_VIDEO_OPTION},
    {"record_video_pause_button", IDS_RECORD_VIDEO_PAUSE_BUTTON},
    {"record_video_paused_msg", IDS_RECORD_VIDEO_PAUSED_MSG},
    {"record_video_resume_button", IDS_RECORD_VIDEO_RESUME_BUTTON},
    {"record_video_start_button", IDS_RECORD_VIDEO_START_BUTTON},
    {"record_video_stop_button", IDS_RECORD_VIDEO_STOP_BUTTON},
    {"rotate_clockwise_button", IDS_ROTATE_CLOCKWISE_BUTTON},
    {"rotate_counterclockwise_button", IDS_ROTATE_COUNTERCLOCKWISE_BUTTON},
    {"scan_document_option", IDS_SCAN_DOCUMENT_OPTION},
    {"scan_qrcode_option", IDS_SCAN_QRCODE_OPTION},
    {"settings_button", IDS_SETTINGS_BUTTON},
    {"snackbar_link_copied", IDS_SNACKBAR_LINK_COPIED},
    {"snackbar_text_copied", IDS_SNACKBAR_TEXT_COPIED},
    {"status_msg_camera_plugged", IDS_STATUS_MSG_CAMERA_PLUGGED},
    {"status_msg_camera_switched", IDS_STATUS_MSG_CAMERA_SWITCHED},
    {"status_msg_camera_unplugged", IDS_STATUS_MSG_CAMERA_UNPLUGGED},
    {"status_msg_recording_stopped", IDS_STATUS_MSG_RECORDING_STOPPED},
    {"switch_camera_button", IDS_SWITCH_CAMERA_BUTTON},
    {"switch_record_video_button", IDS_SWITCH_RECORD_VIDEO_BUTTON},
    {"switch_scan_mode_button", IDS_SWITCH_SCAN_MODE_BUTTON},
    {"switch_take_photo_button", IDS_SWITCH_TAKE_PHOTO_BUTTON},
    {"switch_take_portrait_bokeh_photo_button",
     IDS_SWITCH_TAKE_PORTRAIT_BOKEH_PHOTO_BUTTON},
    {"switch_take_square_photo_button", IDS_SWITCH_TAKE_SQUARE_PHOTO_BUTTON},
    {"take_photo_button", IDS_TAKE_PHOTO_BUTTON},
    {"take_photo_cancel_button", IDS_TAKE_PHOTO_CANCEL_BUTTON},
    {"take_video_snapshot_button", IDS_TAKE_VIDEO_SNAPSHOT_BUTTON},
    {"tilt_down_button", IDS_TILT_DOWN_BUTTON},
    {"tilt_up_button", IDS_TILT_UP_BUTTON},
    {"timer_duration_button", IDS_TIMER_DURATION_BUTTON},
    {"toggle_60fps_button", IDS_TOGGLE_60FPS_BUTTON},
    {"toggle_barcode_button", IDS_TOGGLE_BARCODE_BUTTON},
    {"toggle_grid_button", IDS_TOGGLE_GRID_BUTTON},
    {"toggle_mic_button", IDS_TOGGLE_MIC_BUTTON},
    {"toggle_mirror_button", IDS_TOGGLE_MIRROR_BUTTON},
    {"toggle_timer_10s_button", IDS_TOGGLE_TIMER_10S_BUTTON},
    {"toggle_timer_3s_button", IDS_TOGGLE_TIMER_3S_BUTTON},
    {"video_resolution_button", IDS_VIDEO_RESOLUTION_BUTTON},
    {"zoom_in_button", IDS_ZOOM_IN_BUTTON},
    {"zoom_out_button", IDS_ZOOM_OUT_BUTTON},
};

}  // namespace ash

#endif  // ASH_WEBUI_CAMERA_APP_UI_RESOURCES_H_
