// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_SERVICES_QUICK_PAIR_PUBLIC_CPP_DECRYPTED_RESPONSE_H_
#define ASH_SERVICES_QUICK_PAIR_PUBLIC_CPP_DECRYPTED_RESPONSE_H_

#include <stddef.h>
#include <stdint.h>

#include <array>

#include "ash/services/quick_pair/public/cpp/fast_pair_message_type.h"

inline constexpr int kDecryptedResponseAddressByteSize = 6;
inline constexpr int kDecryptedResponseSaltByteSize = 9;

namespace ash {
namespace quick_pair {

// Thin class which is used by the higher level components of the Quick Pair
// system to represent a decrypted response.
struct DecryptedResponse {
  DecryptedResponse();
  DecryptedResponse(
      FastPairMessageType message_type,
      std::array<uint8_t, kDecryptedResponseAddressByteSize> address_bytes,
      std::array<uint8_t, kDecryptedResponseSaltByteSize> salt);
  DecryptedResponse(const DecryptedResponse&);
  DecryptedResponse(DecryptedResponse&&);
  DecryptedResponse& operator=(const DecryptedResponse&);
  DecryptedResponse& operator=(DecryptedResponse&&);
  ~DecryptedResponse();

  FastPairMessageType message_type;
  std::array<uint8_t, kDecryptedResponseAddressByteSize> address_bytes;
  std::array<uint8_t, kDecryptedResponseSaltByteSize> salt;
};

}  // namespace quick_pair
}  // namespace ash

#endif  // ASH_SERVICES_QUICK_PAIR_PUBLIC_CPP_DECRYPTED_RESPONSE_H_
