// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_SERVICES_IME_PUBLIC_CPP_SUGGESTIONS_H_
#define ASH_SERVICES_IME_PUBLIC_CPP_SUGGESTIONS_H_

#include <string>

namespace ash {
namespace ime {

enum class TextSuggestionMode {
  kPrediction = 0,
  kCompletion = 1,
};

enum class TextSuggestionType {
  kAssistivePersonalInfo = 0,
  kAssistiveEmoji = 1,
  kMultiWord = 2,
};

// Encapsulates a single text based suggestion generated by the system.
struct TextSuggestion {
  // How should this suggestion be treated by a consumer?
  TextSuggestionMode mode;

  // What kind of suggestion is this?
  TextSuggestionType type;

  // The suggested text
  std::string text;

  bool operator==(const TextSuggestion& rhs) const {
    return (mode == rhs.mode && type == rhs.type && text == rhs.text);
  }
};

struct TextCompletionCandidate {
  // Text to complete the current word
  std::string text;

  // The confidence scoring for the candidate
  float score;
};

}  // namespace ime
}  // namespace ash

#endif  // ASH_SERVICES_IME_PUBLIC_CPP_SUGGESTIONS_H_
