// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/services/ime/public/cpp/rulebased/def/ru_phone_yazhert.h"

namespace ru_phone_yazhert {

const char* kId = "ru_phone_yazhert";
bool kIs102 = false;
const char* kNormal[] = {
    u8"\u044e",  // BackQuote
    u8"1",       // Digit1
    u8"2",       // Digit2
    u8"3",       // Digit3
    u8"4",       // Digit4
    u8"5",       // Digit5
    u8"6",       // Digit6
    u8"7",       // Digit7
    u8"8",       // Digit8
    u8"9",       // Digit9
    u8"0",       // Digit0
    u8"-",       // Minus
    u8"\u044c",  // Equal
    u8"\u044f",  // KeyQ
    u8"\u0436",  // KeyW
    u8"\u0435",  // KeyE
    u8"\u0440",  // KeyR
    u8"\u0442",  // KeyT
    u8"\u044b",  // KeyY
    u8"\u0443",  // KeyU
    u8"\u0438",  // KeyI
    u8"\u043e",  // KeyO
    u8"\u043f",  // KeyP
    u8"\u0448",  // BracketLeft
    u8"\u0449",  // BracketRight
    u8"\u044d",  // Backslash
    u8"\u0430",  // KeyA
    u8"\u0441",  // KeyS
    u8"\u0434",  // KeyD
    u8"\u0444",  // KeyF
    u8"\u0433",  // KeyG
    u8"\u0447",  // KeyH
    u8"\u0439",  // KeyJ
    u8"\u043a",  // KeyK
    u8"\u043b",  // KeyL
    u8";",       // Semicolon
    u8"'",       // Quote
    u8"\u0437",  // KeyZ
    u8"\u0445",  // KeyX
    u8"\u0446",  // KeyC
    u8"\u0432",  // KeyV
    u8"\u0431",  // KeyB
    u8"\u043d",  // KeyN
    u8"\u043c",  // KeyM
    u8",",       // Comma
    u8".",       // Period
    u8"/",       // Slash
    u8"\u0020",  // Space
};
const char* kShift[] = {
    u8"\u042e",  // BackQuote
    u8"!",       // Digit1
    u8"\u044a",  // Digit2
    u8"\u042a",  // Digit3
    u8"$",       // Digit4
    u8"%",       // Digit5
    u8"\u0451",  // Digit6
    u8"\u0401",  // Digit7
    u8"*",       // Digit8
    u8"(",       // Digit9
    u8")",       // Digit0
    u8"_",       // Minus
    u8"\u042c",  // Equal
    u8"\u042f",  // KeyQ
    u8"\u0416",  // KeyW
    u8"\u0415",  // KeyE
    u8"\u0420",  // KeyR
    u8"\u0422",  // KeyT
    u8"\u042b",  // KeyY
    u8"\u0423",  // KeyU
    u8"\u0418",  // KeyI
    u8"\u041e",  // KeyO
    u8"\u041f",  // KeyP
    u8"\u0428",  // BracketLeft
    u8"\u0429",  // BracketRight
    u8"\u042d",  // Backslash
    u8"\u0410",  // KeyA
    u8"\u0421",  // KeyS
    u8"\u0414",  // KeyD
    u8"\u0424",  // KeyF
    u8"\u0413",  // KeyG
    u8"\u0427",  // KeyH
    u8"\u0419",  // KeyJ
    u8"\u041a",  // KeyK
    u8"\u041b",  // KeyL
    u8":",       // Semicolon
    u8"\"",      // Quote
    u8"\u0417",  // KeyZ
    u8"\u0425",  // KeyX
    u8"\u0426",  // KeyC
    u8"\u0412",  // KeyV
    u8"\u0411",  // KeyB
    u8"\u041d",  // KeyN
    u8"\u041c",  // KeyM
    u8"<",       // Comma
    u8">",       // Period
    u8"?",       // Slash
    u8"\u0020",  // Space
};
const char* kAltGr[] = {
    u8"`",       // BackQuote
    u8"1",       // Digit1
    u8"2",       // Digit2
    u8"3",       // Digit3
    u8"4",       // Digit4
    u8"5",       // Digit5
    u8"6",       // Digit6
    u8"7",       // Digit7
    u8"8",       // Digit8
    u8"9",       // Digit9
    u8"0",       // Digit0
    u8"-",       // Minus
    u8"=",       // Equal
    u8"q",       // KeyQ
    u8"w",       // KeyW
    u8"e",       // KeyE
    u8"r",       // KeyR
    u8"t",       // KeyT
    u8"y",       // KeyY
    u8"u",       // KeyU
    u8"i",       // KeyI
    u8"o",       // KeyO
    u8"p",       // KeyP
    u8"[",       // BracketLeft
    u8"]",       // BracketRight
    u8"\\",      // Backslash
    u8"a",       // KeyA
    u8"s",       // KeyS
    u8"d",       // KeyD
    u8"f",       // KeyF
    u8"g",       // KeyG
    u8"h",       // KeyH
    u8"j",       // KeyJ
    u8"k",       // KeyK
    u8"l",       // KeyL
    u8";",       // Semicolon
    u8"'",       // Quote
    u8"z",       // KeyZ
    u8"x",       // KeyX
    u8"c",       // KeyC
    u8"v",       // KeyV
    u8"b",       // KeyB
    u8"n",       // KeyN
    u8"m",       // KeyM
    u8",",       // Comma
    u8".",       // Period
    u8"/",       // Slash
    u8"\u0020",  // Space
};
const char* kCapslock[] = {
    u8"\u042e",  // BackQuote
    u8"1",       // Digit1
    u8"2",       // Digit2
    u8"3",       // Digit3
    u8"4",       // Digit4
    u8"5",       // Digit5
    u8"6",       // Digit6
    u8"7",       // Digit7
    u8"8",       // Digit8
    u8"9",       // Digit9
    u8"0",       // Digit0
    u8"-",       // Minus
    u8"\u042c",  // Equal
    u8"\u042f",  // KeyQ
    u8"\u0416",  // KeyW
    u8"\u0415",  // KeyE
    u8"\u0420",  // KeyR
    u8"\u0422",  // KeyT
    u8"\u042b",  // KeyY
    u8"\u0423",  // KeyU
    u8"\u0418",  // KeyI
    u8"\u041e",  // KeyO
    u8"\u041f",  // KeyP
    u8"\u0428",  // BracketLeft
    u8"\u0429",  // BracketRight
    u8"\u042d",  // Backslash
    u8"\u0410",  // KeyA
    u8"\u0421",  // KeyS
    u8"\u0414",  // KeyD
    u8"\u0424",  // KeyF
    u8"\u0413",  // KeyG
    u8"\u0427",  // KeyH
    u8"\u0419",  // KeyJ
    u8"\u041a",  // KeyK
    u8"\u041b",  // KeyL
    u8";",       // Semicolon
    u8"'",       // Quote
    u8"\u0417",  // KeyZ
    u8"\u0425",  // KeyX
    u8"\u0426",  // KeyC
    u8"\u0412",  // KeyV
    u8"\u0411",  // KeyB
    u8"\u041d",  // KeyN
    u8"\u041c",  // KeyM
    u8",",       // Comma
    u8".",       // Period
    u8"/",       // Slash
    u8"\u0020",  // Space
};
const char* kShiftAltGr[] = {
    u8"~",       // BackQuote
    u8"!",       // Digit1
    u8"@",       // Digit2
    u8"#",       // Digit3
    u8"$",       // Digit4
    u8"%",       // Digit5
    u8"^",       // Digit6
    u8"&",       // Digit7
    u8"*",       // Digit8
    u8"(",       // Digit9
    u8")",       // Digit0
    u8"_",       // Minus
    u8"+",       // Equal
    u8"Q",       // KeyQ
    u8"W",       // KeyW
    u8"E",       // KeyE
    u8"R",       // KeyR
    u8"T",       // KeyT
    u8"Y",       // KeyY
    u8"U",       // KeyU
    u8"I",       // KeyI
    u8"O",       // KeyO
    u8"P",       // KeyP
    u8"{",       // BracketLeft
    u8"}",       // BracketRight
    u8"|",       // Backslash
    u8"A",       // KeyA
    u8"S",       // KeyS
    u8"D",       // KeyD
    u8"F",       // KeyF
    u8"G",       // KeyG
    u8"H",       // KeyH
    u8"J",       // KeyJ
    u8"K",       // KeyK
    u8"L",       // KeyL
    u8":",       // Semicolon
    u8"\"",      // Quote
    u8"Z",       // KeyZ
    u8"X",       // KeyX
    u8"C",       // KeyC
    u8"V",       // KeyV
    u8"B",       // KeyB
    u8"N",       // KeyN
    u8"M",       // KeyM
    u8"<",       // Comma
    u8">",       // Period
    u8"?",       // Slash
    u8"\u0020",  // Space
};
const char* kAltgrCapslock[] = {
    u8"`",       // BackQuote
    u8"1",       // Digit1
    u8"2",       // Digit2
    u8"3",       // Digit3
    u8"4",       // Digit4
    u8"5",       // Digit5
    u8"6",       // Digit6
    u8"7",       // Digit7
    u8"8",       // Digit8
    u8"9",       // Digit9
    u8"0",       // Digit0
    u8"-",       // Minus
    u8"=",       // Equal
    u8"Q",       // KeyQ
    u8"W",       // KeyW
    u8"E",       // KeyE
    u8"R",       // KeyR
    u8"T",       // KeyT
    u8"Y",       // KeyY
    u8"U",       // KeyU
    u8"I",       // KeyI
    u8"O",       // KeyO
    u8"P",       // KeyP
    u8"[",       // BracketLeft
    u8"]",       // BracketRight
    u8"\\",      // Backslash
    u8"A",       // KeyA
    u8"S",       // KeyS
    u8"D",       // KeyD
    u8"F",       // KeyF
    u8"G",       // KeyG
    u8"H",       // KeyH
    u8"J",       // KeyJ
    u8"K",       // KeyK
    u8"L",       // KeyL
    u8";",       // Semicolon
    u8"'",       // Quote
    u8"Z",       // KeyZ
    u8"X",       // KeyX
    u8"C",       // KeyC
    u8"V",       // KeyV
    u8"B",       // KeyB
    u8"N",       // KeyN
    u8"M",       // KeyM
    u8",",       // Comma
    u8".",       // Period
    u8"/",       // Slash
    u8"\u0020",  // Space
};
const char* kShiftCapslock[] = {
    u8"\u044e",  // BackQuote
    u8"!",       // Digit1
    u8"\u044a",  // Digit2
    u8"\u042a",  // Digit3
    u8"$",       // Digit4
    u8"%",       // Digit5
    u8"\u0451",  // Digit6
    u8"\u0401",  // Digit7
    u8"*",       // Digit8
    u8"(",       // Digit9
    u8")",       // Digit0
    u8"_",       // Minus
    u8"\u044c",  // Equal
    u8"\u044f",  // KeyQ
    u8"\u0436",  // KeyW
    u8"\u0435",  // KeyE
    u8"\u0440",  // KeyR
    u8"\u0442",  // KeyT
    u8"\u044b",  // KeyY
    u8"\u0443",  // KeyU
    u8"\u0438",  // KeyI
    u8"\u043e",  // KeyO
    u8"\u043f",  // KeyP
    u8"\u0448",  // BracketLeft
    u8"\u0449",  // BracketRight
    u8"\u044d",  // Backslash
    u8"\u0430",  // KeyA
    u8"\u0441",  // KeyS
    u8"\u0434",  // KeyD
    u8"\u0444",  // KeyF
    u8"\u0433",  // KeyG
    u8"\u0447",  // KeyH
    u8"\u0439",  // KeyJ
    u8"\u043a",  // KeyK
    u8"\u043b",  // KeyL
    u8":",       // Semicolon
    u8"\"",      // Quote
    u8"\u0437",  // KeyZ
    u8"\u0445",  // KeyX
    u8"\u0446",  // KeyC
    u8"\u0432",  // KeyV
    u8"\u0431",  // KeyB
    u8"\u043d",  // KeyN
    u8"\u043c",  // KeyM
    u8"<",       // Comma
    u8">",       // Period
    u8"?",       // Slash
    u8"\u0020",  // Space
};
const char* kShiftAltGrCapslock[] = {
    u8"~",       // BackQuote
    u8"!",       // Digit1
    u8"@",       // Digit2
    u8"#",       // Digit3
    u8"$",       // Digit4
    u8"%",       // Digit5
    u8"^",       // Digit6
    u8"&",       // Digit7
    u8"*",       // Digit8
    u8"(",       // Digit9
    u8")",       // Digit0
    u8"_",       // Minus
    u8"+",       // Equal
    u8"q",       // KeyQ
    u8"w",       // KeyW
    u8"e",       // KeyE
    u8"r",       // KeyR
    u8"t",       // KeyT
    u8"y",       // KeyY
    u8"u",       // KeyU
    u8"i",       // KeyI
    u8"o",       // KeyO
    u8"p",       // KeyP
    u8"{",       // BracketLeft
    u8"}",       // BracketRight
    u8"|",       // Backslash
    u8"a",       // KeyA
    u8"s",       // KeyS
    u8"d",       // KeyD
    u8"f",       // KeyF
    u8"g",       // KeyG
    u8"h",       // KeyH
    u8"j",       // KeyJ
    u8"k",       // KeyK
    u8"l",       // KeyL
    u8":",       // Semicolon
    u8"\"",      // Quote
    u8"z",       // KeyZ
    u8"x",       // KeyX
    u8"c",       // KeyC
    u8"v",       // KeyV
    u8"b",       // KeyB
    u8"n",       // KeyN
    u8"m",       // KeyM
    u8"<",       // Comma
    u8">",       // Period
    u8"?",       // Slash
    u8"\u0020",  // Space
};
const char** kKeyMap[8] = {
    kNormal,   kShift,         kAltGr,         kShiftAltGr,
    kCapslock, kShiftCapslock, kAltgrCapslock, kShiftAltGrCapslock};

}  // namespace ru_phone_yazhert
