// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ash/components/login/auth/cryptohome_key_constants.h"

namespace ash {

// The label used for the key derived from the user's GAIA credentials.
//
// Also, for historical reasons, this key is used for Active Directory users and
// for Public Session keys.
//
// TODO(crbug.com/826417): Introduce a separate constant for the Public Session
// key label.
const char kCryptohomeGaiaKeyLabel[] = "gaia";

const char kCryptohomeGaiaKeyLegacyLabelPrefix[] = "legacy-";

const char kCryptohomePinLabel[] = "pin";

// The label used for the key generated by Cryptohome for public mount aka
// kiosks.
const char kCryptohomePublicMountLabel[] = "publicmount";

const char kCryptohomeWildcardLabel[] = "";

}  // namespace ash
