/* chatty-application.h
 *
 * Copyright 2019 Purism SPC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *   Mohammed Sadiq <sadiq@sadiqpk.org>
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <adwaita.h>

#include "chatty-window.h"

G_BEGIN_DECLS

#define CHATTY_APPLICATION_DEFAULT() ((ChattyApplication *)g_application_get_default ())
#define CHATTY_TYPE_APPLICATION (chatty_application_get_type ())

G_DECLARE_FINAL_TYPE (ChattyApplication, chatty_application, CHATTY, APPLICATION, AdwApplication)

ChattyApplication *chatty_application_new (void);
ChattyChat        *chatty_application_get_active_chat (ChattyApplication *self);
void               chatty_application_set_active_chat (ChattyApplication *self,
                                                       ChattyChat        *chat);

G_END_DECLS
